/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.por;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.FSMComposition;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.por.DependencyInterface;

public class ClusterPORPerformanceFunctional {
    private Map<List<Location>, Location> stateMap;
    private Integer currentStateId;
    private List<FSM<Location, Edge>> fsmList;
    private FSMImpl cFSM;
    private Set<String> alphabet;
    private Set<String> controllableEvents;
    private Set<String> uncontrollableEvents;
    private Set<Edge> visitedEdges;
    private Set<Location> visitedLocations;
    private DependencyInterface dependencies;
    private Map<String, Set<Integer>> occursInMap;
    private Map<String, Set<String>> alphabetMap;
    private Set<String> setU;
    private List<Location> globalDumpState = new ArrayList<Location>();
    private static final String OMEGA = "_omega";
    private final Approach approach;
    private static final boolean OPTIMIZE_LOCAL_EVENT_CHECK = true;

    public ClusterPORPerformanceFunctional() {
        this.approach = Approach.ALL_CANDIDATES_HEURISTIC;
    }

    public ClusterPORPerformanceFunctional(Approach approach) {
        this.approach = approach;
    }

    public FSMImpl compute(List<FSM<Location, Edge>> fsmList, DependencyInterface dependencies) {
        this.stateMap = new HashMap<List<Location>, Location>();
        this.currentStateId = 0;
        this.cFSM = new FSMImpl();
        this.visitedEdges = new HashSet<Edge>();
        this.visitedLocations = new HashSet<Location>();
        this.fsmList = fsmList;
        this.dependencies = dependencies;
        this.alphabet = new HashSet<String>();
        this.uncontrollableEvents = new HashSet<String>();
        this.controllableEvents = new HashSet<String>();
        for (FSM<Location, Edge> fsm : fsmList) {
            this.alphabet.addAll(fsm.getAlphabet());
            this.uncontrollableEvents.addAll(fsm.getUncontrollable());
            this.controllableEvents.addAll(fsm.getControllable());
        }
        this.occursInMap = new HashMap<String, Set<Integer>>();
        this.alphabetMap = new HashMap<String, Set<String>>();
        for (String event : this.alphabet) {
            HashSet<Integer> occursList = new HashSet<Integer>();
            Iterator<String> alphabetList = new HashSet<String>();
            int fsmId = 0;
            while (fsmId < this.fsmList.size()) {
                FSM<Location, Edge> fsm = fsmList.get(fsmId);
                if (fsm.getAlphabet().contains(event)) {
                    occursList.add(fsmId);
                    alphabetList.addAll(fsm.getAlphabet());
                }
                ++fsmId;
            }
            this.occursInMap.put(event, occursList);
            this.alphabetMap.put(event, (Set<String>)((Object)alphabetList));
        }
        ArrayList<Location> initialState = new ArrayList<Location>();
        int fsmId = 0;
        while (fsmId < this.fsmList.size()) {
            initialState.add(fsmId, this.fsmList.get(fsmId).getInitial());
            ++fsmId;
        }
        Location stateLocation = this.getLocation(initialState);
        this.cFSM.setInitial(stateLocation);
        this.globalDumpState = new ArrayList<Location>();
        int fsmId2 = 0;
        while (fsmId2 < this.fsmList.size()) {
            this.globalDumpState.add(fsmId2, new Location("_dump"));
            ++fsmId2;
        }
        for (String uEvent : this.uncontrollableEvents) {
            this.cFSM.addUncontrollable(uEvent);
        }
        for (String cEvent : this.controllableEvents) {
            this.cFSM.addControllable(cEvent);
        }
        this.setU = new HashSet<String>();
        fsmId = 0;
        while (fsmId < this.fsmList.size()) {
            FSM<Location, Edge> fsm = this.fsmList.get(fsmId);
            for (Edge e : fsm.getEdges()) {
                Location target = (Location)fsm.getEdgeTarget(e);
                Set<String> enabled_in_target = FSMComposition.enabled(fsm, target);
                for (String event_enabled : enabled_in_target) {
                    if (!this.uncontrollableEvents.contains(event_enabled)) continue;
                    this.setU.add(e.getEvent());
                }
            }
            ++fsmId;
        }
        this.dfsTraversal(initialState);
        return this.cFSM;
    }

    private void dfsTraversal(List<Location> initialState) {
        Stack<List<Location>> stack = new Stack<List<Location>>();
        stack.push(initialState);
        while (!stack.isEmpty()) {
            List state = (List)stack.pop();
            if (!this.isVisited(this.getLocation(state))) {
                this.visit(state);
            }
            LinkedList<String> queueAmple = new LinkedList<String>();
            queueAmple.addAll(switch (this.approach) {
                case Approach.ALL_CANDIDATES_HEURISTIC -> this.campleAll(this.fsmList, state);
                case Approach.SMART_CANDIDATE_HEURISTIC -> this.campleHeuristic(this.fsmList, state);
                case Approach.RANDOM_CANDIDATE -> this.campleAny(this.fsmList, state);
                default -> this.campleAll(this.fsmList, state);
            });
            while (!queueAmple.isEmpty()) {
                Edge e;
                Location dump_state;
                String a = (String)queueAmple.remove();
                List<Location> targetState = FSMComposition.getEdgeTarget(this.fsmList, state, a);
                if (targetState.contains(dump_state = new Location("_dump"))) {
                    targetState = this.globalDumpState;
                }
                if (this.isVisited(e = new Edge(this.getLocation(state), a, this.getLocation(targetState)))) continue;
                this.visit(e);
                if (this.isVisited(this.getLocation(targetState))) continue;
                stack.push(targetState);
            }
        }
    }

    private void dfsTraversalRecursive(List<Location> state) {
        this.visit(state);
        for (String a : switch (this.approach) {
            case Approach.ALL_CANDIDATES_HEURISTIC -> this.campleAll(this.fsmList, state);
            case Approach.SMART_CANDIDATE_HEURISTIC -> this.campleHeuristic(this.fsmList, state);
            case Approach.RANDOM_CANDIDATE -> this.campleAny(this.fsmList, state);
            default -> this.campleAll(this.fsmList, state);
        }) {
            List<Location> targetState = FSMComposition.getEdgeTarget(this.fsmList, state, a);
            Edge e = new Edge(this.getLocation(state), a, this.getLocation(targetState));
            if (this.isVisited(e)) continue;
            this.visit(e);
            if (this.isVisited(this.getLocation(targetState))) continue;
            this.dfsTraversalRecursive(targetState);
        }
    }

    private Set<String> campleAll(List<FSM<Location, Edge>> fsmList, List<Location> state) {
        Set<String> enabled = FSMComposition.enabled(fsmList, state);
        if (enabled.size() <= 1) {
            return enabled;
        }
        HashSet<String> clusterEnabled = new HashSet<String>(enabled);
        for (String event : enabled) {
            Set<Integer> cluster = this.getCluster(fsmList, state, enabled, event);
            HashSet<String> clusterAlphabet = new HashSet<String>();
            int fsmId = 0;
            while (fsmId < fsmList.size()) {
                if (cluster.contains(fsmId)) {
                    clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
                }
                ++fsmId;
            }
            HashSet<String> clusterEnabledCheck = new HashSet<String>(enabled);
            clusterEnabledCheck.retainAll(clusterAlphabet);
            if (clusterEnabledCheck.size() >= clusterEnabled.size()) continue;
            clusterEnabled = clusterEnabledCheck;
        }
        return clusterEnabled;
    }

    private Set<String> campleHeuristic(List<FSM<Location, Edge>> fsmList, List<Location> state) {
        Set<String> enabled = FSMComposition.enabled(fsmList, state);
        if (enabled.size() <= 1) {
            return enabled;
        }
        String candidate = "_undefined";
        if (enabled.contains(OMEGA)) {
            candidate = OMEGA;
        } else {
            HashSet<String> unctrlEnabled = new HashSet<String>(enabled);
            unctrlEnabled.retainAll(this.uncontrollableEvents);
            if (!unctrlEnabled.isEmpty()) {
                candidate = (String)unctrlEnabled.iterator().next();
            } else {
                HashMap<String, Integer> eventValueMap = new HashMap<String, Integer>();
                for (String event : enabled) {
                    Integer v = 0;
                    int fsmId = 0;
                    while (fsmId < fsmList.size()) {
                        if (fsmList.get(fsmId).getAlphabet().contains(event)) {
                            for (String localEvent : FSMComposition.enabled(fsmList.get(fsmId), state.get(fsmId))) {
                                v = enabled.contains(localEvent) ? Integer.valueOf(v + 100) : Integer.valueOf(v + 1);
                            }
                        }
                        ++fsmId;
                    }
                    eventValueMap.put(event, v);
                }
                Integer minVal = Integer.MAX_VALUE;
                for (String event : enabled) {
                    if ((Integer)eventValueMap.get(event) >= minVal) continue;
                    candidate = event;
                    minVal = (Integer)eventValueMap.get(event);
                }
            }
        }
        Set<Integer> cluster = this.getCluster(fsmList, state, enabled, candidate);
        HashSet<String> clusterAlphabet = new HashSet<String>();
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            if (cluster.contains(fsmId)) {
                clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
            }
            ++fsmId;
        }
        HashSet<String> clusterEnabledCheck = new HashSet<String>(enabled);
        clusterEnabledCheck.retainAll(clusterAlphabet);
        return clusterEnabledCheck;
    }

    private Set<String> campleAny(List<FSM<Location, Edge>> fsmList, List<Location> state) {
        Set<String> enabled = FSMComposition.enabled(fsmList, state);
        if (enabled.size() <= 1) {
            return enabled;
        }
        String candidate = enabled.iterator().next();
        Set<Integer> cluster = this.getCluster(fsmList, state, enabled, candidate);
        HashSet<String> clusterAlphabet = new HashSet<String>();
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            if (cluster.contains(fsmId)) {
                clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
            }
            ++fsmId;
        }
        HashSet<String> clusterEnabledCheck = new HashSet<String>(enabled);
        clusterEnabledCheck.retainAll(clusterAlphabet);
        return clusterEnabledCheck;
    }

    private Set<Integer> getCluster(List<FSM<Location, Edge>> fsmList, List<Location> state, Set<String> enabled, String candidate) {
        HashSet<String> processed = new HashSet<String>();
        HashSet<String> toProcess = new HashSet<String>();
        HashSet<Integer> cluster = new HashSet<Integer>();
        HashSet<String> clusterAlphabet = new HashSet<String>();
        toProcess.add(candidate);
        HashSet<String> uncontrollableEnabled = new HashSet<String>(enabled);
        uncontrollableEnabled.retainAll(this.uncontrollableEvents);
        for (String uEnabled : uncontrollableEnabled) {
            cluster.addAll((Collection<Integer>)this.occursInMap.get(uEnabled));
            clusterAlphabet.addAll((Collection)this.alphabetMap.get(uEnabled));
        }
        if (enabled.contains(OMEGA)) {
            cluster.addAll((Collection<Integer>)this.occursInMap.get(OMEGA));
            clusterAlphabet.addAll((Collection)this.alphabetMap.get(OMEGA));
        }
        while (!toProcess.isEmpty()) {
            String event = (String)toProcess.iterator().next();
            processed.add(event);
            if (enabled.contains(event)) {
                if (this.setU.contains(event)) {
                    Integer fsmId = 0;
                    while (fsmId < fsmList.size()) {
                        cluster.add(fsmId);
                        fsmId = fsmId + 1;
                    }
                    return cluster;
                }
                cluster.addAll((Collection<Integer>)this.occursInMap.get(event));
                clusterAlphabet.addAll((Collection)this.alphabetMap.get(event));
                for (String dep : this.getDependencies(event)) {
                    if (clusterAlphabet.contains(dep)) continue;
                    Integer fsmId = this.occursInMap.get(dep).iterator().next();
                    cluster.add(fsmId);
                    clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
                }
            }
            Set<String> locallyEnabled = this.getLocallyEnabled(fsmList, cluster, state);
            if (!enabled.contains(event) && locallyEnabled.contains(event)) {
                int validFSM = -1;
                int candidateFSM = -1;
                int fsmId = 0;
                while (fsmId < fsmList.size()) {
                    Set<String> alphabet = fsmList.get(fsmId).getAlphabet();
                    HashSet<String> alphabetEnabledEvents = new HashSet<String>(alphabet);
                    alphabetEnabledEvents.retainAll(enabled);
                    if (alphabet.contains(event) && !cluster.contains(fsmId) && !FSMComposition.isEnabled(fsmList.get(fsmId), state.get(fsmId), event)) {
                        validFSM = fsmId;
                        if (alphabetEnabledEvents.isEmpty()) {
                            candidateFSM = fsmId;
                            cluster.add(fsmId);
                            clusterAlphabet.addAll(fsmList.get(fsmId).getAlphabet());
                            break;
                        }
                    }
                    ++fsmId;
                }
                if (candidateFSM == -1) {
                    cluster.add(validFSM);
                    clusterAlphabet.addAll(fsmList.get(validFSM).getAlphabet());
                }
                locallyEnabled = this.getLocallyEnabled(fsmList, cluster, state);
            }
            HashSet<String> newQueue = new HashSet<String>(locallyEnabled);
            newQueue.removeAll(processed);
            toProcess = newQueue;
        }
        return cluster;
    }

    private Set<String> getDependencies(String event) {
        return this.dependencies.getDependencies(event);
    }

    private Set<String> getLocallyEnabled(List<FSM<Location, Edge>> fsmList, Set<Integer> cluster, List<Location> state) {
        ArrayList<FSM<Location, Edge>> clusterFSMs = new ArrayList<FSM<Location, Edge>>();
        ArrayList<Location> clusterState = new ArrayList<Location>();
        for (Integer fid : cluster) {
            clusterFSMs.add(fsmList.get(fid));
            clusterState.add(state.get(fid));
        }
        return FSMComposition.enabled(clusterFSMs, clusterState);
    }

    private void visit(List<Location> state) {
        this.visitedLocations.add(this.getLocation(state));
        Location location = this.stateMap.get(state);
        if (FSMComposition.isMarked(this.fsmList, state)) {
            this.cFSM.setMarked(location);
        }
        this.cFSM.addLocation(location);
    }

    private void visit(Edge e) {
        this.visitedEdges.add(e);
        this.cFSM.addEdge(e);
    }

    private Location getLocation(List<Location> state) {
        if (!this.stateMap.containsKey(state)) {
            this.currentStateId = this.currentStateId + 1;
            this.stateMap.put(state, new Location("s" + String.valueOf(this.currentStateId)));
        }
        return this.stateMap.get(state);
    }

    private boolean isVisited(Location l) {
        return this.visitedLocations.contains(l);
    }

    private boolean isVisited(Edge e) {
        return this.visitedEdges.contains(e);
    }

    public static enum Approach {
        ALL_CANDIDATES_HEURISTIC,
        SMART_CANDIDATE_HEURISTIC,
        RANDOM_CANDIDATE;

    }
}

