/**
 */
package trigonometry.impl;

import expressions.Expression;

import expressions.impl.ExpressionImpl;

import java.lang.reflect.InvocationTargetException;

import java.math.BigDecimal;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import trigonometry.Atan2Expression;
import trigonometry.TrigonometryPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Atan2 Expression</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link trigonometry.impl.Atan2ExpressionImpl#getY <em>Y</em>}</li>
 *   <li>{@link trigonometry.impl.Atan2ExpressionImpl#getX <em>X</em>}</li>
 * </ul>
 *
 * @generated
 */
public class Atan2ExpressionImpl extends ExpressionImpl implements Atan2Expression
{
    /**
     * The cached value of the '{@link #getY() <em>Y</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getY()
     * @generated
     * @ordered
     */
    protected Expression y;

    /**
     * The cached value of the '{@link #getX() <em>X</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getX()
     * @generated
     * @ordered
     */
    protected Expression x;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Atan2ExpressionImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    protected EClass eStaticClass()
    {
        return TrigonometryPackage.Literals.ATAN2_EXPRESSION;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getY()
    {
        return y;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetY(Expression newY, NotificationChain msgs)
    {
        Expression oldY = y;
        y = newY;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TrigonometryPackage.ATAN2_EXPRESSION__Y, oldY, newY);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setY(Expression newY)
    {
        if (newY != y)
        {
            NotificationChain msgs = null;
            if (y != null)
                msgs = ((InternalEObject)y).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TrigonometryPackage.ATAN2_EXPRESSION__Y, null, msgs);
            if (newY != null)
                msgs = ((InternalEObject)newY).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TrigonometryPackage.ATAN2_EXPRESSION__Y, null, msgs);
            msgs = basicSetY(newY, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, TrigonometryPackage.ATAN2_EXPRESSION__Y, newY, newY));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Expression getX()
    {
        return x;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetX(Expression newX, NotificationChain msgs)
    {
        Expression oldX = x;
        x = newX;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TrigonometryPackage.ATAN2_EXPRESSION__X, oldX, newX);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void setX(Expression newX)
    {
        if (newX != x)
        {
            NotificationChain msgs = null;
            if (x != null)
                msgs = ((InternalEObject)x).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TrigonometryPackage.ATAN2_EXPRESSION__X, null, msgs);
            if (newX != null)
                msgs = ((InternalEObject)newX).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - TrigonometryPackage.ATAN2_EXPRESSION__X, null, msgs);
            msgs = basicSetX(newX, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, TrigonometryPackage.ATAN2_EXPRESSION__X, newX, newX));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public BigDecimal evaluate()
    {
        return new BigDecimal(Math.atan2(y.evaluate().doubleValue(), x.evaluate().doubleValue()));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
    {
        switch (featureID)
        {
            case TrigonometryPackage.ATAN2_EXPRESSION__Y:
                return basicSetY(null, msgs);
            case TrigonometryPackage.ATAN2_EXPRESSION__X:
                return basicSetX(null, msgs);
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType)
    {
        switch (featureID)
        {
            case TrigonometryPackage.ATAN2_EXPRESSION__Y:
                return getY();
            case TrigonometryPackage.ATAN2_EXPRESSION__X:
                return getX();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue)
    {
        switch (featureID)
        {
            case TrigonometryPackage.ATAN2_EXPRESSION__Y:
                setY((Expression)newValue);
                return;
            case TrigonometryPackage.ATAN2_EXPRESSION__X:
                setX((Expression)newValue);
                return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public void eUnset(int featureID)
    {
        switch (featureID)
        {
            case TrigonometryPackage.ATAN2_EXPRESSION__Y:
                setY((Expression)null);
                return;
            case TrigonometryPackage.ATAN2_EXPRESSION__X:
                setX((Expression)null);
                return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID)
    {
        switch (featureID)
        {
            case TrigonometryPackage.ATAN2_EXPRESSION__Y:
                return y != null;
            case TrigonometryPackage.ATAN2_EXPRESSION__X:
                return x != null;
        }
        return super.eIsSet(featureID);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
    {
        switch (operationID)
        {
            case TrigonometryPackage.ATAN2_EXPRESSION___EVALUATE:
                return evaluate();
        }
        return super.eInvoke(operationID, arguments);
    }

} //Atan2ExpressionImpl
