
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link BlockIoStats}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlockIoStats.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableBlockIoStats implements BlockIoStats {
  private final @Nullable List<Object> ioServiceBytesRecursive;
  private final @Nullable List<Object> ioServicedRecursive;
  private final @Nullable List<Object> ioQueueRecursive;
  private final @Nullable List<Object> ioServiceTimeRecursive;
  private final @Nullable List<Object> ioWaitTimeRecursive;
  private final @Nullable List<Object> ioMergedRecursive;
  private final @Nullable List<Object> ioTimeRecursive;
  private final @Nullable List<Object> sectorsRecursive;

  private ImmutableBlockIoStats(
      @Nullable List<Object> ioServiceBytesRecursive,
      @Nullable List<Object> ioServicedRecursive,
      @Nullable List<Object> ioQueueRecursive,
      @Nullable List<Object> ioServiceTimeRecursive,
      @Nullable List<Object> ioWaitTimeRecursive,
      @Nullable List<Object> ioMergedRecursive,
      @Nullable List<Object> ioTimeRecursive,
      @Nullable List<Object> sectorsRecursive) {
    this.ioServiceBytesRecursive = ioServiceBytesRecursive;
    this.ioServicedRecursive = ioServicedRecursive;
    this.ioQueueRecursive = ioQueueRecursive;
    this.ioServiceTimeRecursive = ioServiceTimeRecursive;
    this.ioWaitTimeRecursive = ioWaitTimeRecursive;
    this.ioMergedRecursive = ioMergedRecursive;
    this.ioTimeRecursive = ioTimeRecursive;
    this.sectorsRecursive = sectorsRecursive;
  }

  /**
   * @return The value of the {@code ioServiceBytesRecursive} attribute
   */
  @JsonProperty("io_service_bytes_recursive")
  @Override
  public @Nullable List<Object> ioServiceBytesRecursive() {
    return ioServiceBytesRecursive;
  }

  /**
   * @return The value of the {@code ioServicedRecursive} attribute
   */
  @JsonProperty("io_serviced_recursive")
  @Override
  public @Nullable List<Object> ioServicedRecursive() {
    return ioServicedRecursive;
  }

  /**
   * @return The value of the {@code ioQueueRecursive} attribute
   */
  @JsonProperty("io_queue_recursive")
  @Override
  public @Nullable List<Object> ioQueueRecursive() {
    return ioQueueRecursive;
  }

  /**
   * @return The value of the {@code ioServiceTimeRecursive} attribute
   */
  @JsonProperty("io_service_time_recursive")
  @Override
  public @Nullable List<Object> ioServiceTimeRecursive() {
    return ioServiceTimeRecursive;
  }

  /**
   * @return The value of the {@code ioWaitTimeRecursive} attribute
   */
  @JsonProperty("io_wait_time_recursive")
  @Override
  public @Nullable List<Object> ioWaitTimeRecursive() {
    return ioWaitTimeRecursive;
  }

  /**
   * @return The value of the {@code ioMergedRecursive} attribute
   */
  @JsonProperty("io_merged_recursive")
  @Override
  public @Nullable List<Object> ioMergedRecursive() {
    return ioMergedRecursive;
  }

  /**
   * @return The value of the {@code ioTimeRecursive} attribute
   */
  @JsonProperty("io_time_recursive")
  @Override
  public @Nullable List<Object> ioTimeRecursive() {
    return ioTimeRecursive;
  }

  /**
   * @return The value of the {@code sectorsRecursive} attribute
   */
  @JsonProperty("sectors_recursive")
  @Override
  public @Nullable List<Object> sectorsRecursive() {
    return sectorsRecursive;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoServiceBytesRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioServiceBytesRecursive == null) return this;
      return new ImmutableBlockIoStats(
          null,
          this.ioServicedRecursive,
          this.ioQueueRecursive,
          this.ioServiceTimeRecursive,
          this.ioWaitTimeRecursive,
          this.ioMergedRecursive,
          this.ioTimeRecursive,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        newValue,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioServiceBytesRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoServiceBytesRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioServiceBytesRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        newValue,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoServicedRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioServicedRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          null,
          this.ioQueueRecursive,
          this.ioServiceTimeRecursive,
          this.ioWaitTimeRecursive,
          this.ioMergedRecursive,
          this.ioTimeRecursive,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        newValue,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioServicedRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoServicedRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioServicedRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        newValue,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoQueueRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioQueueRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          this.ioServicedRecursive,
          null,
          this.ioServiceTimeRecursive,
          this.ioWaitTimeRecursive,
          this.ioMergedRecursive,
          this.ioTimeRecursive,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        newValue,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioQueueRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoQueueRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioQueueRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        newValue,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoServiceTimeRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioServiceTimeRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          this.ioServicedRecursive,
          this.ioQueueRecursive,
          null,
          this.ioWaitTimeRecursive,
          this.ioMergedRecursive,
          this.ioTimeRecursive,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        newValue,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioServiceTimeRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoServiceTimeRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioServiceTimeRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        newValue,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoWaitTimeRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioWaitTimeRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          this.ioServicedRecursive,
          this.ioQueueRecursive,
          this.ioServiceTimeRecursive,
          null,
          this.ioMergedRecursive,
          this.ioTimeRecursive,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        newValue,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioWaitTimeRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoWaitTimeRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioWaitTimeRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        newValue,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoMergedRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioMergedRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          this.ioServicedRecursive,
          this.ioQueueRecursive,
          this.ioServiceTimeRecursive,
          this.ioWaitTimeRecursive,
          null,
          this.ioTimeRecursive,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        newValue,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioMergedRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoMergedRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioMergedRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        newValue,
        this.ioTimeRecursive,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withIoTimeRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.ioTimeRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          this.ioServicedRecursive,
          this.ioQueueRecursive,
          this.ioServiceTimeRecursive,
          this.ioWaitTimeRecursive,
          this.ioMergedRecursive,
          null,
          this.sectorsRecursive);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        newValue,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ioTimeRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withIoTimeRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.ioTimeRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        newValue,
        this.sectorsRecursive);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#sectorsRecursive() sectorsRecursive}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlockIoStats withSectorsRecursive(@Nullable Object... elements) {
    if (elements == null) {
      if (this.sectorsRecursive == null) return this;
      return new ImmutableBlockIoStats(
          this.ioServiceBytesRecursive,
          this.ioServicedRecursive,
          this.ioQueueRecursive,
          this.ioServiceTimeRecursive,
          this.ioWaitTimeRecursive,
          this.ioMergedRecursive,
          this.ioTimeRecursive,
          null);
    }
    List<Object> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BlockIoStats#sectorsRecursive() sectorsRecursive}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sectorsRecursive elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBlockIoStats withSectorsRecursive(@Nullable Iterable<? extends Object> elements) {
    if (this.sectorsRecursive == elements) return this;
    @Nullable List<Object> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBlockIoStats(
        this.ioServiceBytesRecursive,
        this.ioServicedRecursive,
        this.ioQueueRecursive,
        this.ioServiceTimeRecursive,
        this.ioWaitTimeRecursive,
        this.ioMergedRecursive,
        this.ioTimeRecursive,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlockIoStats} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlockIoStats
        && equalsByValue((ImmutableBlockIoStats) another);
  }

  private boolean equalsByValue(ImmutableBlockIoStats another) {
    return Objects.equals(ioServiceBytesRecursive, another.ioServiceBytesRecursive)
        && Objects.equals(ioServicedRecursive, another.ioServicedRecursive)
        && Objects.equals(ioQueueRecursive, another.ioQueueRecursive)
        && Objects.equals(ioServiceTimeRecursive, another.ioServiceTimeRecursive)
        && Objects.equals(ioWaitTimeRecursive, another.ioWaitTimeRecursive)
        && Objects.equals(ioMergedRecursive, another.ioMergedRecursive)
        && Objects.equals(ioTimeRecursive, another.ioTimeRecursive)
        && Objects.equals(sectorsRecursive, another.sectorsRecursive);
  }

  /**
   * Computes a hash code from attributes: {@code ioServiceBytesRecursive}, {@code ioServicedRecursive}, {@code ioQueueRecursive}, {@code ioServiceTimeRecursive}, {@code ioWaitTimeRecursive}, {@code ioMergedRecursive}, {@code ioTimeRecursive}, {@code sectorsRecursive}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(ioServiceBytesRecursive);
    h += (h << 5) + Objects.hashCode(ioServicedRecursive);
    h += (h << 5) + Objects.hashCode(ioQueueRecursive);
    h += (h << 5) + Objects.hashCode(ioServiceTimeRecursive);
    h += (h << 5) + Objects.hashCode(ioWaitTimeRecursive);
    h += (h << 5) + Objects.hashCode(ioMergedRecursive);
    h += (h << 5) + Objects.hashCode(ioTimeRecursive);
    h += (h << 5) + Objects.hashCode(sectorsRecursive);
    return h;
  }

  /**
   * Prints the immutable value {@code BlockIoStats} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BlockIoStats{"
        + "ioServiceBytesRecursive=" + ioServiceBytesRecursive
        + ", ioServicedRecursive=" + ioServicedRecursive
        + ", ioQueueRecursive=" + ioQueueRecursive
        + ", ioServiceTimeRecursive=" + ioServiceTimeRecursive
        + ", ioWaitTimeRecursive=" + ioWaitTimeRecursive
        + ", ioMergedRecursive=" + ioMergedRecursive
        + ", ioTimeRecursive=" + ioTimeRecursive
        + ", sectorsRecursive=" + sectorsRecursive
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link BlockIoStats} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlockIoStats instance
   */
  public static ImmutableBlockIoStats copyOf(BlockIoStats instance) {
    if (instance instanceof ImmutableBlockIoStats) {
      return (ImmutableBlockIoStats) instance;
    }
    return ImmutableBlockIoStats.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlockIoStats ImmutableBlockIoStats}.
   * <pre>
   * ImmutableBlockIoStats.builder()
   *    .ioServiceBytesRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive}
   *    .ioServicedRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive}
   *    .ioQueueRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive}
   *    .ioServiceTimeRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive}
   *    .ioWaitTimeRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive}
   *    .ioMergedRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive}
   *    .ioTimeRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive}
   *    .sectorsRecursive(List&lt;Object&gt; | null) // nullable {@link BlockIoStats#sectorsRecursive() sectorsRecursive}
   *    .build();
   * </pre>
   * @return A new ImmutableBlockIoStats builder
   */
  public static ImmutableBlockIoStats.Builder builder() {
    return new ImmutableBlockIoStats.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlockIoStats ImmutableBlockIoStats}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private List<Object> ioServiceBytesRecursive = null;
    private List<Object> ioServicedRecursive = null;
    private List<Object> ioQueueRecursive = null;
    private List<Object> ioServiceTimeRecursive = null;
    private List<Object> ioWaitTimeRecursive = null;
    private List<Object> ioMergedRecursive = null;
    private List<Object> ioTimeRecursive = null;
    private List<Object> sectorsRecursive = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlockIoStats} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BlockIoStats instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable List<Object> ioServiceBytesRecursiveValue = instance.ioServiceBytesRecursive();
      if (ioServiceBytesRecursiveValue != null) {
        addAllIoServiceBytesRecursive(ioServiceBytesRecursiveValue);
      }
      @Nullable List<Object> ioServicedRecursiveValue = instance.ioServicedRecursive();
      if (ioServicedRecursiveValue != null) {
        addAllIoServicedRecursive(ioServicedRecursiveValue);
      }
      @Nullable List<Object> ioQueueRecursiveValue = instance.ioQueueRecursive();
      if (ioQueueRecursiveValue != null) {
        addAllIoQueueRecursive(ioQueueRecursiveValue);
      }
      @Nullable List<Object> ioServiceTimeRecursiveValue = instance.ioServiceTimeRecursive();
      if (ioServiceTimeRecursiveValue != null) {
        addAllIoServiceTimeRecursive(ioServiceTimeRecursiveValue);
      }
      @Nullable List<Object> ioWaitTimeRecursiveValue = instance.ioWaitTimeRecursive();
      if (ioWaitTimeRecursiveValue != null) {
        addAllIoWaitTimeRecursive(ioWaitTimeRecursiveValue);
      }
      @Nullable List<Object> ioMergedRecursiveValue = instance.ioMergedRecursive();
      if (ioMergedRecursiveValue != null) {
        addAllIoMergedRecursive(ioMergedRecursiveValue);
      }
      @Nullable List<Object> ioTimeRecursiveValue = instance.ioTimeRecursive();
      if (ioTimeRecursiveValue != null) {
        addAllIoTimeRecursive(ioTimeRecursiveValue);
      }
      @Nullable List<Object> sectorsRecursiveValue = instance.sectorsRecursive();
      if (sectorsRecursiveValue != null) {
        addAllSectorsRecursive(sectorsRecursiveValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive} list.
     * @param element A ioServiceBytesRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioServiceBytesRecursive(Object element) {
      if (this.ioServiceBytesRecursive == null) {
        this.ioServiceBytesRecursive = new ArrayList<Object>();
      }
      this.ioServiceBytesRecursive.add(Objects.requireNonNull(element, "ioServiceBytesRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive} list.
     * @param elements An array of ioServiceBytesRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioServiceBytesRecursive(Object... elements) {
      if (this.ioServiceBytesRecursive == null) {
        this.ioServiceBytesRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioServiceBytesRecursive.add(Objects.requireNonNull(element, "ioServiceBytesRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive} list.
     * @param elements An iterable of ioServiceBytesRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_service_bytes_recursive")
    public final Builder ioServiceBytesRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioServiceBytesRecursive = null;
        return this;
      }
      this.ioServiceBytesRecursive = new ArrayList<Object>();
      return addAllIoServiceBytesRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioServiceBytesRecursive() ioServiceBytesRecursive} list.
     * @param elements An iterable of ioServiceBytesRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoServiceBytesRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioServiceBytesRecursive element");
      if (this.ioServiceBytesRecursive == null) {
        this.ioServiceBytesRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioServiceBytesRecursive.add(Objects.requireNonNull(element, "ioServiceBytesRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive} list.
     * @param element A ioServicedRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioServicedRecursive(Object element) {
      if (this.ioServicedRecursive == null) {
        this.ioServicedRecursive = new ArrayList<Object>();
      }
      this.ioServicedRecursive.add(Objects.requireNonNull(element, "ioServicedRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive} list.
     * @param elements An array of ioServicedRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioServicedRecursive(Object... elements) {
      if (this.ioServicedRecursive == null) {
        this.ioServicedRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioServicedRecursive.add(Objects.requireNonNull(element, "ioServicedRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive} list.
     * @param elements An iterable of ioServicedRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_serviced_recursive")
    public final Builder ioServicedRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioServicedRecursive = null;
        return this;
      }
      this.ioServicedRecursive = new ArrayList<Object>();
      return addAllIoServicedRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioServicedRecursive() ioServicedRecursive} list.
     * @param elements An iterable of ioServicedRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoServicedRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioServicedRecursive element");
      if (this.ioServicedRecursive == null) {
        this.ioServicedRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioServicedRecursive.add(Objects.requireNonNull(element, "ioServicedRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive} list.
     * @param element A ioQueueRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioQueueRecursive(Object element) {
      if (this.ioQueueRecursive == null) {
        this.ioQueueRecursive = new ArrayList<Object>();
      }
      this.ioQueueRecursive.add(Objects.requireNonNull(element, "ioQueueRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive} list.
     * @param elements An array of ioQueueRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioQueueRecursive(Object... elements) {
      if (this.ioQueueRecursive == null) {
        this.ioQueueRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioQueueRecursive.add(Objects.requireNonNull(element, "ioQueueRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive} list.
     * @param elements An iterable of ioQueueRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_queue_recursive")
    public final Builder ioQueueRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioQueueRecursive = null;
        return this;
      }
      this.ioQueueRecursive = new ArrayList<Object>();
      return addAllIoQueueRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioQueueRecursive() ioQueueRecursive} list.
     * @param elements An iterable of ioQueueRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoQueueRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioQueueRecursive element");
      if (this.ioQueueRecursive == null) {
        this.ioQueueRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioQueueRecursive.add(Objects.requireNonNull(element, "ioQueueRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive} list.
     * @param element A ioServiceTimeRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioServiceTimeRecursive(Object element) {
      if (this.ioServiceTimeRecursive == null) {
        this.ioServiceTimeRecursive = new ArrayList<Object>();
      }
      this.ioServiceTimeRecursive.add(Objects.requireNonNull(element, "ioServiceTimeRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive} list.
     * @param elements An array of ioServiceTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioServiceTimeRecursive(Object... elements) {
      if (this.ioServiceTimeRecursive == null) {
        this.ioServiceTimeRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioServiceTimeRecursive.add(Objects.requireNonNull(element, "ioServiceTimeRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive} list.
     * @param elements An iterable of ioServiceTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_service_time_recursive")
    public final Builder ioServiceTimeRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioServiceTimeRecursive = null;
        return this;
      }
      this.ioServiceTimeRecursive = new ArrayList<Object>();
      return addAllIoServiceTimeRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioServiceTimeRecursive() ioServiceTimeRecursive} list.
     * @param elements An iterable of ioServiceTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoServiceTimeRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioServiceTimeRecursive element");
      if (this.ioServiceTimeRecursive == null) {
        this.ioServiceTimeRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioServiceTimeRecursive.add(Objects.requireNonNull(element, "ioServiceTimeRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive} list.
     * @param element A ioWaitTimeRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioWaitTimeRecursive(Object element) {
      if (this.ioWaitTimeRecursive == null) {
        this.ioWaitTimeRecursive = new ArrayList<Object>();
      }
      this.ioWaitTimeRecursive.add(Objects.requireNonNull(element, "ioWaitTimeRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive} list.
     * @param elements An array of ioWaitTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioWaitTimeRecursive(Object... elements) {
      if (this.ioWaitTimeRecursive == null) {
        this.ioWaitTimeRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioWaitTimeRecursive.add(Objects.requireNonNull(element, "ioWaitTimeRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive} list.
     * @param elements An iterable of ioWaitTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_wait_time_recursive")
    public final Builder ioWaitTimeRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioWaitTimeRecursive = null;
        return this;
      }
      this.ioWaitTimeRecursive = new ArrayList<Object>();
      return addAllIoWaitTimeRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioWaitTimeRecursive() ioWaitTimeRecursive} list.
     * @param elements An iterable of ioWaitTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoWaitTimeRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioWaitTimeRecursive element");
      if (this.ioWaitTimeRecursive == null) {
        this.ioWaitTimeRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioWaitTimeRecursive.add(Objects.requireNonNull(element, "ioWaitTimeRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive} list.
     * @param element A ioMergedRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioMergedRecursive(Object element) {
      if (this.ioMergedRecursive == null) {
        this.ioMergedRecursive = new ArrayList<Object>();
      }
      this.ioMergedRecursive.add(Objects.requireNonNull(element, "ioMergedRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive} list.
     * @param elements An array of ioMergedRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioMergedRecursive(Object... elements) {
      if (this.ioMergedRecursive == null) {
        this.ioMergedRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioMergedRecursive.add(Objects.requireNonNull(element, "ioMergedRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive} list.
     * @param elements An iterable of ioMergedRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_merged_recursive")
    public final Builder ioMergedRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioMergedRecursive = null;
        return this;
      }
      this.ioMergedRecursive = new ArrayList<Object>();
      return addAllIoMergedRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioMergedRecursive() ioMergedRecursive} list.
     * @param elements An iterable of ioMergedRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoMergedRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioMergedRecursive element");
      if (this.ioMergedRecursive == null) {
        this.ioMergedRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioMergedRecursive.add(Objects.requireNonNull(element, "ioMergedRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive} list.
     * @param element A ioTimeRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioTimeRecursive(Object element) {
      if (this.ioTimeRecursive == null) {
        this.ioTimeRecursive = new ArrayList<Object>();
      }
      this.ioTimeRecursive.add(Objects.requireNonNull(element, "ioTimeRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive} list.
     * @param elements An array of ioTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ioTimeRecursive(Object... elements) {
      if (this.ioTimeRecursive == null) {
        this.ioTimeRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioTimeRecursive.add(Objects.requireNonNull(element, "ioTimeRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive} list.
     * @param elements An iterable of ioTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("io_time_recursive")
    public final Builder ioTimeRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.ioTimeRecursive = null;
        return this;
      }
      this.ioTimeRecursive = new ArrayList<Object>();
      return addAllIoTimeRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#ioTimeRecursive() ioTimeRecursive} list.
     * @param elements An iterable of ioTimeRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIoTimeRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "ioTimeRecursive element");
      if (this.ioTimeRecursive == null) {
        this.ioTimeRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.ioTimeRecursive.add(Objects.requireNonNull(element, "ioTimeRecursive element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link BlockIoStats#sectorsRecursive() sectorsRecursive} list.
     * @param element A sectorsRecursive element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sectorsRecursive(Object element) {
      if (this.sectorsRecursive == null) {
        this.sectorsRecursive = new ArrayList<Object>();
      }
      this.sectorsRecursive.add(Objects.requireNonNull(element, "sectorsRecursive element"));
      return this;
    }

    /**
     * Adds elements to {@link BlockIoStats#sectorsRecursive() sectorsRecursive} list.
     * @param elements An array of sectorsRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sectorsRecursive(Object... elements) {
      if (this.sectorsRecursive == null) {
        this.sectorsRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.sectorsRecursive.add(Objects.requireNonNull(element, "sectorsRecursive element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BlockIoStats#sectorsRecursive() sectorsRecursive} list.
     * @param elements An iterable of sectorsRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sectors_recursive")
    public final Builder sectorsRecursive(@Nullable Iterable<? extends Object> elements) {
      if (elements == null) {
        this.sectorsRecursive = null;
        return this;
      }
      this.sectorsRecursive = new ArrayList<Object>();
      return addAllSectorsRecursive(elements);
    }

    /**
     * Adds elements to {@link BlockIoStats#sectorsRecursive() sectorsRecursive} list.
     * @param elements An iterable of sectorsRecursive elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSectorsRecursive(Iterable<? extends Object> elements) {
      Objects.requireNonNull(elements, "sectorsRecursive element");
      if (this.sectorsRecursive == null) {
        this.sectorsRecursive = new ArrayList<Object>();
      }
      for (Object element : elements) {
        this.sectorsRecursive.add(Objects.requireNonNull(element, "sectorsRecursive element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlockIoStats ImmutableBlockIoStats}.
     * @return An immutable instance of BlockIoStats
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlockIoStats build() {
      return new ImmutableBlockIoStats(
          ioServiceBytesRecursive == null ? null : createUnmodifiableList(true, ioServiceBytesRecursive),
          ioServicedRecursive == null ? null : createUnmodifiableList(true, ioServicedRecursive),
          ioQueueRecursive == null ? null : createUnmodifiableList(true, ioQueueRecursive),
          ioServiceTimeRecursive == null ? null : createUnmodifiableList(true, ioServiceTimeRecursive),
          ioWaitTimeRecursive == null ? null : createUnmodifiableList(true, ioWaitTimeRecursive),
          ioMergedRecursive == null ? null : createUnmodifiableList(true, ioMergedRecursive),
          ioTimeRecursive == null ? null : createUnmodifiableList(true, ioTimeRecursive),
          sectorsRecursive == null ? null : createUnmodifiableList(true, sectorsRecursive));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
