/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.transport.mqtt;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.kura.data.DataTransportToken;
import org.eclipse.kura.data.transport.listener.DataTransportListener;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataTransportListenerS
implements DataTransportListener {
    private static final Logger logger = LoggerFactory.getLogger(DataTransportListenerS.class);
    private static final String DATA_TRANSPORT_LISTENER_REFERENCE = "DataTransportListener";
    private final ComponentContext ctx;
    private final List<DataTransportListener> listeners;

    public DataTransportListenerS(ComponentContext ctx) {
        this.ctx = ctx;
        this.listeners = new CopyOnWriteArrayList<DataTransportListener>();
    }

    public void onConnectionEstablished(boolean newSession) {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onConnectionEstablished(newSession);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onConnectionEstablished");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onConnectionEstablished(newSession);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onConnectionEstablished");
        }
    }

    public void onDisconnecting() {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onDisconnecting();
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onDisconnecting");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onDisconnecting();
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onDisconnecting");
        }
    }

    public void onDisconnected() {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onDisconnected();
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onDisconnected");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onDisconnected();
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onDisconnected");
        }
    }

    public void onConfigurationUpdating(boolean wasConnected) {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onConfigurationUpdating(wasConnected);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onConfigurationUpdating");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onConfigurationUpdating(wasConnected);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onConfigurationUpdating");
        }
    }

    public void onConfigurationUpdated(boolean wasConnected) {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onConfigurationUpdated(wasConnected);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onConfigurationUpdated");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onConfigurationUpdated(wasConnected);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onConfigurationUpdated");
        }
    }

    public void onConnectionLost(Throwable cause) {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onConnectionLost(cause);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onConnectionLost");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onConnectionLost(cause);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onConnectionLost");
        }
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onMessageArrived(topic, payload, qos, retained);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onMessageArrived");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onMessageArrived(topic, payload, qos, retained);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onMessageArrived");
        }
    }

    public void onMessageConfirmed(DataTransportToken token) {
        Object[] services = this.ctx.locateServices(DATA_TRANSPORT_LISTENER_REFERENCE);
        if (services != null) {
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                try {
                    ((org.eclipse.kura.data.DataTransportListener)service).onMessageConfirmed(token);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
                ++n2;
            }
        } else {
            logger.debug("No registered listener services. Ignoring onMessageConfirmed");
        }
        if (!this.listeners.isEmpty()) {
            for (DataTransportListener listener : this.listeners) {
                try {
                    listener.onMessageConfirmed(token);
                }
                catch (Throwable t) {
                    logger.warn("Unexpected Throwable", t);
                }
            }
        } else {
            logger.warn("No registered listeners. Ignoring onMessageConfirmed");
        }
    }

    public void add(DataTransportListener listener) {
        this.listeners.add(listener);
    }

    public void remove(DataTransportListener listener) {
        this.listeners.remove(listener);
    }
}

