/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.device;

import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.device.Activator;
import org.eclipse.equinox.device.DeviceMsg;
import org.eclipse.equinox.device.LogTracker;
import org.eclipse.equinox.device.Match;
import org.eclipse.equinox.device.SecureAction;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.device.Driver;
import org.osgi.util.tracker.ServiceTracker;

public class DriverTracker
extends ServiceTracker {
    protected static final String clazz = "org.osgi.service.device.Driver";
    protected LogTracker log;
    protected Hashtable<Object, Object> drivers;
    protected Activator manager;
    protected Hashtable<String, Hashtable<ServiceReference, Match>> matches;
    protected Hashtable<String, Hashtable<ServiceReference, String>> referrals;

    public DriverTracker(Activator manager) {
        super(manager.context, clazz, null);
        this.manager = manager;
        this.log = manager.log;
        this.drivers = new Hashtable(37);
        this.matches = new Hashtable(37);
        this.referrals = new Hashtable(37);
        this.open();
    }

    public Object addingService(ServiceReference reference) {
        String driver_id = this.getDriverID(reference);
        if (this.drivers.get(driver_id) != null) {
            this.log.log(reference, 2, NLS.bind((String)DeviceMsg.Multiple_Driver_services_with_the_same_DRIVER_ID, (Object)driver_id));
            return null;
        }
        this.drivers.put(driver_id, reference);
        this.drivers.put(reference, driver_id);
        this.manager.driverServiceRegistered = true;
        Bundle bundle = reference.getBundle();
        if (this.manager.running && !this.manager.locators.isUninstallCandidate(bundle)) {
            this.manager.refineIdleDevices();
        }
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        String old_id;
        String driver_id = this.getDriverID(reference);
        if (!driver_id.equals(old_id = (String)this.drivers.get(reference))) {
            this.drivers.put(driver_id, reference);
            this.drivers.put(reference, driver_id);
            this.drivers.remove(old_id);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        String driver_id = this.getDriverID(reference);
        this.drivers.remove(driver_id);
        this.drivers.remove(reference);
        this.matches.remove(driver_id);
        this.referrals.remove(driver_id);
        this.context.ungetService(reference);
        Bundle bundle = reference.getBundle();
        if (this.manager.running && !this.manager.locators.isUninstallCandidate(bundle)) {
            DriverUpdate update = new DriverUpdate(bundle, this.manager);
            Thread thread = new SecureAction().createThread(update, DeviceMsg.DeviceManager_Update_Wait);
            thread.start();
        }
    }

    public String getDriverID(ServiceReference reference) {
        String driver_id = (String)reference.getProperty("DRIVER_ID");
        if (driver_id == null) {
            this.log.log(reference, 2, DeviceMsg.Driver_service_has_no_DRIVER_ID);
            driver_id = AccessController.doPrivileged(() -> reference.getBundle().getLocation());
        }
        return driver_id;
    }

    public ServiceReference getDriver(String driver_id) {
        return (ServiceReference)this.drivers.get(driver_id);
    }

    public ServiceReference match(ServiceReference device, Vector exclude) {
        block7: {
            ServiceReference[] references = this.getServiceReferences();
            if (references == null) break block7;
            int size = references.length;
            Vector<Match> successfulMatches = new Vector<Match>(size);
            int i = 0;
            while (i < size) {
                block6: {
                    Match match;
                    block8: {
                        ServiceReference driver = references[i];
                        if (exclude.contains(driver)) break block6;
                        match = this.getMatch(driver, device);
                        if (match != null) break block8;
                        Driver service = (Driver)this.getService(driver);
                        if (service == null) break block6;
                        int matchValue = 0;
                        try {
                            matchValue = service.match(device);
                        }
                        catch (Throwable t) {
                            this.log.log(driver, 1, DeviceMsg.Driver_error_during_match, t);
                            break block6;
                        }
                        match = new Match(driver, matchValue);
                        this.storeMatch(driver, device, match);
                    }
                    if (match.getMatchValue() > 0) {
                        successfulMatches.addElement(match);
                    }
                }
                ++i;
            }
            size = successfulMatches.size();
            if (size > 0) {
                Object[] matchArray = new Match[size];
                successfulMatches.copyInto(matchArray);
                return this.manager.selectors.select(device, (Match[])matchArray);
            }
        }
        return null;
    }

    public Match getMatch(ServiceReference driver, ServiceReference device) {
        String driverid = this.getDriverID(driver);
        Hashtable<ServiceReference, Match> driverMatches = this.matches.get(driverid);
        if (driverMatches == null) {
            return null;
        }
        return driverMatches.get(device);
    }

    public void storeMatch(ServiceReference driver, ServiceReference device, Match match) {
        String driverid = this.getDriverID(driver);
        Hashtable<Object, Match> driverMatches = this.matches.get(driverid);
        if (driverMatches == null) {
            driverMatches = new Hashtable(37);
            this.matches.put(driverid, driverMatches);
        }
        driverMatches.put(device, match);
    }

    public boolean attach(ServiceReference driver, ServiceReference device, Vector exclude) {
        Driver service = (Driver)this.getService(driver);
        if (service != null) {
            String referral = this.getReferral(driver, device);
            if (referral == null) {
                try {
                    referral = service.attach(device);
                }
                catch (Throwable t) {
                    this.log.log(driver, 1, DeviceMsg.Driver_error_during_attach, t);
                    exclude.addElement(driver);
                    return false;
                }
                this.storeReferral(driver, device, referral == null ? "" : referral);
            } else if (referral.length() == 0) {
                referral = null;
            }
            if (referral == null) {
                this.log.log(device, 3, NLS.bind((String)DeviceMsg.Device_attached_by_DRIVER_ID, (Object)this.drivers.get(driver)));
                this.manager.locators.usingDriverBundle(driver.getBundle());
                return true;
            }
            this.log.log(device, 3, NLS.bind((String)DeviceMsg.Device_referred_to, (Object)referral));
            this.manager.locators.loadDriver(referral, this);
        }
        exclude.addElement(driver);
        return false;
    }

    public String getReferral(ServiceReference driver, ServiceReference device) {
        String driverid = this.getDriverID(driver);
        Hashtable<ServiceReference, String> driverReferrals = this.referrals.get(driverid);
        if (driverReferrals == null) {
            return null;
        }
        return driverReferrals.get(device);
    }

    public void storeReferral(ServiceReference driver, ServiceReference device, String referral) {
        String driverid = this.getDriverID(driver);
        Hashtable<Object, String> driverReferrals = this.referrals.get(driverid);
        if (driverReferrals == null) {
            driverReferrals = new Hashtable(37);
            this.referrals.put(driverid, driverReferrals);
        }
        driverReferrals.put(device, referral);
    }

    public String toString() {
        return "DriverTracker";
    }

    public class DriverUpdate
    implements Runnable,
    ServiceListener,
    BundleListener {
        private Activator manager_;
        private Bundle bundle;
        private BundleContext contxt;
        private volatile boolean running;
        private long updatewait;

        DriverUpdate(Bundle bundle, Activator manager) {
            this.manager_ = manager;
            this.bundle = bundle;
            this.contxt = this.manager_.context;
            this.updatewait = this.manager_.updatewait;
            this.running = true;
            this.contxt.addBundleListener((BundleListener)this);
            try {
                this.contxt.addServiceListener((ServiceListener)this, this.manager_.driverFilter.toString());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.updatewait <= 0L) break block6;
                    DriverUpdate driverUpdate = this;
                    synchronized (driverUpdate) {
                        this.wait(this.updatewait);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            this.contxt.removeServiceListener((ServiceListener)this);
            this.contxt.removeBundleListener((BundleListener)this);
            if (this.running) {
                DriverTracker.this.manager.refineIdleDevices();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1 && this.bundle.equals(event.getServiceReference().getBundle())) {
                this.contxt.removeServiceListener((ServiceListener)this);
                this.running = false;
            }
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 1 && this.bundle.equals(event.getBundle())) {
                this.contxt.removeBundleListener((BundleListener)this);
                this.updatewait = 0L;
            }
        }
    }
}

