/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class FloatValue
implements TypedValue<Float> {
    private final float value;

    public FloatValue(float value) {
        this.value = value;
    }

    @Override
    public int compareTo(TypedValue<Float> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        return Float.valueOf(this.value).compareTo(otherTypedValue.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatValue)) {
            return false;
        }
        FloatValue other = (FloatValue)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }

    @Override
    public DataType getType() {
        return DataType.FLOAT;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    public String toString() {
        return "FloatValue [value=" + this.value + "]";
    }
}

