/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.utils.log;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.internal.utils.log.Log;

public class FileLog
implements Log {
    private File logFile;
    Object lock = new Object();

    public FileLog(File logFile) {
        if (logFile == null) {
            throw new IllegalArgumentException("logFile is null");
        }
        this.logFile = logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void log(int severity, String msg, Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileWriter(this.logFile.getAbsolutePath(), true));
                    out.println(String.valueOf(FileLog.getDateTime()) + " " + FileLog.getSeverityString(severity) + msg);
                    if (t != null) {
                        out.println(DebugUtils.getStackTrace(t));
                    }
                    out.flush();
                }
                catch (Exception exception) {}
                Object var6_8 = null;
                if (out == null) return;
                out.close();
                return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
        }
    }

    private static String getDateTime() {
        return new Date().toString();
    }

    private static String getSeverityString(int severity) {
        switch (severity) {
            case 0: {
                return "[I]";
            }
            case 1: {
                return "[E]";
            }
            case 2: {
                return "[D]";
            }
        }
        return "[E]";
    }
}

