/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.io.InputStream;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.tigris.mtoolkit.iagent.Error;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.internal.utils.ExceptionCodeHelper;
import org.tigris.mtoolkit.iagent.rpc.spi.DeploymentManagerDelegate;

public class DefaultDeploymentManagerDelegate
implements DeploymentManagerDelegate {
    DeploymentAdmin dpAdmin;

    public DefaultDeploymentManagerDelegate(DeploymentAdmin dpAdmin) {
        this.dpAdmin = dpAdmin;
    }

    public Object installDeploymentPackage(InputStream in) {
        try {
            DeploymentPackage dp = this.dpAdmin.installDeploymentPackage(in);
            return dp;
        }
        catch (DeploymentException e) {
            return new Error(ExceptionCodeHelper.fromDeploymentExceptionCode(e.getCode()), "Failed to install deployment package: " + DebugUtils.toString((Exception)((Object)e)));
        }
    }

    public Object uninstallDeploymentPackage(DeploymentPackage dp, boolean force) {
        if (!force) {
            try {
                dp.uninstall();
                return Boolean.TRUE;
            }
            catch (DeploymentException e) {
                return new Error(ExceptionCodeHelper.fromDeploymentExceptionCode(e.getCode()), "Failed to uninstall deployment package: " + DebugUtils.toString((Exception)((Object)e)));
            }
        }
        try {
            boolean result = dp.uninstallForced();
            return result ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (DeploymentException e) {
            return new Error(ExceptionCodeHelper.fromDeploymentExceptionCode(e.getCode()), "Failed to uninstall deployment package: " + DebugUtils.toString((Exception)((Object)e)));
        }
    }

    public boolean isSupported() {
        return true;
    }
}

