/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.util;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtWireConfiguration;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class GwtWireGraphServiceUtil {
    private GwtWireGraphServiceUtil() {
    }

    public static String getDriverByPid(String pid) {
        ServiceReference<?>[] refs;
        BundleContext context = FrameworkUtil.getBundle(GwtWireGraphServiceUtil.class).getBundleContext();
        ServiceReference<?>[] serviceReferenceArray = refs = GwtWireGraphServiceUtil.getServiceReferences(context, WireComponent.class.getName(), null);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> ref = serviceReferenceArray[n2];
            if (ref.getProperty("kura.service.pid").equals(pid)) {
                String driver = String.valueOf(ref.getProperty("driver.pid"));
                context.ungetService(ref);
                return driver;
            }
            ++n2;
        }
        return null;
    }

    public static String getFactoryPid(String pid) {
        ServiceReference<?>[] refs;
        BundleContext context = FrameworkUtil.getBundle(GwtWireGraphServiceUtil.class).getBundleContext();
        ServiceReference<?>[] serviceReferenceArray = refs = GwtWireGraphServiceUtil.getServiceReferences(context, WireComponent.class.getName(), null);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> ref = serviceReferenceArray[n2];
            if (ref.getProperty("kura.service.pid").equals(pid)) {
                return (String)ref.getProperty("service.factoryPid");
            }
            ++n2;
        }
        return null;
    }

    public static ServiceReference<?>[] getServiceReferences(BundleContext bundleContext, String clazz, String filter) {
        try {
            ServiceReference[] refs = bundleContext.getServiceReferences(clazz, filter);
            return refs == null ? new ServiceReference[]{} : refs;
        }
        catch (InvalidSyntaxException ise) {
            throw new KuraRuntimeException(KuraErrorCode.INVALID_PARAMETER, (Throwable)ise, new Object[0]);
        }
    }

    public static String getType(String pid) {
        ServiceReference<?>[] refs;
        BundleContext context = FrameworkUtil.getBundle(GwtWireGraphServiceUtil.class).getBundleContext();
        ServiceReference<?>[] serviceReferenceArray = refs = GwtWireGraphServiceUtil.getServiceReferences(context, WireComponent.class.getName(), null);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> ref = serviceReferenceArray[n2];
            if (ref.getProperty("kura.service.pid").equals(pid)) {
                WireComponent wc = (WireComponent)context.getService(ref);
                boolean isEmitter = false;
                boolean isReceiver = false;
                if (wc instanceof WireEmitter) {
                    isEmitter = true;
                }
                if (wc instanceof WireReceiver) {
                    isReceiver = true;
                }
                if (isEmitter && isReceiver) {
                    return "both";
                }
                if (isEmitter) {
                    return "producer";
                }
                if (isReceiver) {
                    return "consumer";
                }
                context.ungetService(ref);
            }
            ++n2;
        }
        return "";
    }

    public static List<String> getWireComponents() throws GwtKuraException {
        ServiceReference<?>[] refs;
        WireHelperService helperService = ServiceLocator.getInstance().getService(WireHelperService.class);
        ArrayList<String> list = new ArrayList<String>();
        BundleContext context = FrameworkUtil.getBundle(GwtWireGraphServiceUtil.class).getBundleContext();
        ServiceReference<?>[] serviceReferenceArray = refs = GwtWireGraphServiceUtil.getServiceReferences(context, WireComponent.class.getName(), null);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> ref = serviceReferenceArray[n2];
            WireComponent wc = (WireComponent)context.getService(ref);
            if (wc != null) {
                String pid = helperService.getPid(wc);
                list.add(pid);
            }
            context.ungetService(ref);
            ++n2;
        }
        return list;
    }

    public static Map<String, WireComponentDescriptor> getWireComponentsFromJson(JsonObject jWireGraph) {
        HashMap<String, WireComponentDescriptor> result = new HashMap<String, WireComponentDescriptor>();
        int lenght = jWireGraph.size() - 1;
        int i = 0;
        while (i < lenght) {
            JsonObject jsonObject = jWireGraph.get(String.valueOf(i)).asObject();
            String pid = jsonObject.getString("pid", null);
            String factoryPid = jsonObject.getString("fpid", null);
            String driverPid = jsonObject.getString("driver", null);
            if (pid != null && factoryPid != null) {
                result.put(pid, new WireComponentDescriptor(pid, factoryPid, driverPid));
            }
            ++i;
        }
        return result;
    }

    public static List<GwtWireConfiguration> getWireConfigurationsFromJson(JsonObject json) {
        ArrayList<GwtWireConfiguration> list = new ArrayList<GwtWireConfiguration>();
        int i = 0;
        while (i < json.size()) {
            JsonObject jsonObject = json.get(String.valueOf(i)).asObject();
            String emitter = jsonObject.getString("producer", null);
            String receiver = jsonObject.getString("consumer", null);
            if (emitter != null && receiver != null) {
                GwtWireConfiguration configuration = new GwtWireConfiguration();
                configuration.setEmitterPid(emitter);
                configuration.setReceiverPid(receiver);
                list.add(configuration);
            }
            ++i;
        }
        return list;
    }

    public static String getWireConfigurationsJson(List<GwtWireConfiguration> list) {
        JsonObject wireConfigs = Json.object();
        int i = 0;
        for (GwtWireConfiguration wcConf : list) {
            JsonObject wireConf = Json.object();
            wireConf.add("emitter", wcConf.getEmitterPid()).add("receiver", wcConf.getReceiverPid());
            wireConfigs.add(String.valueOf(i++), (JsonValue)wireConf);
        }
        wireConfigs.add("length", String.valueOf(i));
        return wireConfigs.toString();
    }

    public static class WireComponentDescriptor {
        private final String pid;
        private final String factoryPid;
        private final String driverPid;

        public WireComponentDescriptor(String pid, String factoryPid, String driverPid) {
            this.pid = pid;
            this.factoryPid = factoryPid;
            this.driverPid = driverPid;
        }

        public String getPid() {
            return this.pid;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public String getDriverPid() {
            return this.driverPid;
        }
    }
}

