/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.common;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.db.BaseDbService;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.internal.wire.db.common.CommonDbServiceProvider;
import org.eclipse.kura.internal.wire.db.common.DbServiceHelper;
import org.eclipse.kura.internal.wire.db.common.DbServiceProvider;
import org.eclipse.kura.wire.WireRecord;

public class H2DbServiceProviderImpl
extends CommonDbServiceProvider
implements DbServiceProvider {
    private static final Logger logger = LogManager.getLogger(H2DbServiceProviderImpl.class);
    private static final String SQL_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS {0} (ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 1 INCREMENT BY 1) PRIMARY KEY, TIMESTAMP BIGINT);";
    private static final String SQL_DELETE_RANGE_TABLE = "DELETE FROM {0} WHERE ID IN (SELECT ID FROM {0} ORDER BY ID ASC LIMIT {1});";
    private static final String SQL_TRUNCATE_TABLE = "TRUNCATE TABLE {0};";

    public H2DbServiceProviderImpl(H2DbService dbService) {
        this.dbHelper = DbServiceHelper.of((BaseDbService)dbService);
    }

    @Override
    public void truncate(int noOfRecordsToKeep, String tableName, int maxTableSize) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        int tableSize = this.getTableSize(tableName);
        int entriesToDeleteCount = tableSize + 1;
        entriesToDeleteCount = maxTableSize < noOfRecordsToKeep ? (entriesToDeleteCount -= maxTableSize) : (entriesToDeleteCount -= noOfRecordsToKeep);
        String limit = Integer.toString(entriesToDeleteCount);
        this.dbHelper.withConnection(c -> {
            String catalog = c.getCatalog();
            DatabaseMetaData dbMetaData = c.getMetaData();
            Throwable throwable = null;
            Object var9_10 = null;
            try (ResultSet rsTbls = dbMetaData.getTables(catalog, null, tableName, TABLE_TYPE);){
                if (rsTbls.next()) {
                    if (noOfRecordsToKeep == 0) {
                        logger.info("Truncating table {}...", (Object)sqlTableName);
                        this.dbHelper.execute(c, this.format(SQL_TRUNCATE_TABLE, sqlTableName), new Integer[0]);
                    } else {
                        logger.info("Partially emptying table {}", (Object)sqlTableName);
                        this.dbHelper.execute(c, this.format(SQL_DELETE_RANGE_TABLE, sqlTableName, limit), new Integer[0]);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    @Override
    public int getTableSize(String tableName) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        return (Integer)this.dbHelper.withConnection(c -> this.getTableSize(sqlTableName, c, (string, objectArray) -> this.format((String)string, objectArray)));
    }

    @Override
    public void reconcileTable(String tableName) throws SQLException {
        this.dbHelper.withConnection(c -> {
            this.reconcileTable(c, tableName, SQL_CREATE_TABLE, (string, objectArray) -> this.format((String)string, objectArray));
            return null;
        });
    }

    @Override
    public void reconcileColumns(String tableName, WireRecord wireRecord) throws SQLException {
        this.dbHelper.withConnection(c -> {
            this.reconcileColumns(c, tableName, wireRecord, (string, objectArray) -> this.format((String)string, objectArray));
            return null;
        });
    }

    @Override
    public void insertDataRecord(String tableName, WireRecord wireRecord) throws SQLException {
        this.dbHelper.withConnection(c -> {
            this.insertDataRecord(c, tableName, wireRecord, (string, objectArray) -> this.format((String)string, objectArray));
            return null;
        });
    }

    @Override
    public List<WireRecord> performSQLQuery(String query) throws SQLException {
        return (List)this.dbHelper.withConnection(c -> this.performSQLQuery(c, query));
    }

    private String format(String message, Object ... arguments) {
        return MessageFormat.format(message, arguments);
    }
}

