/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.wire.store;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.connection.listener.ConnectionListener;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.util.jdbc.ConnectionProvider;
import org.eclipse.kura.util.jdbc.JdbcUtil;
import org.eclipse.kura.util.wire.store.JdbcWireRecordStoreQueries;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.store.provider.WireRecordStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcWireRecordStoreImpl
implements WireRecordStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJdbcWireRecordStoreImpl.class);
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    protected final String tableName;
    protected final String escapedTableName;
    protected final ConnectionProvider connectionProvider;
    protected final JdbcWireRecordStoreQueries queries;
    private Set<ConnectionListener> connectionListeners;

    protected AbstractJdbcWireRecordStoreImpl(ConnectionProvider connectionProvider, String tableName) {
        if (tableName == null || tableName.trim().isEmpty()) {
            throw new IllegalArgumentException("Table name cannot be null or empty.");
        }
        this.tableName = tableName;
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "Connection provider cannot be null");
        this.escapedTableName = this.escapeIdentifier(tableName);
        this.queries = this.buildSqlWireRecordStoreQueries();
    }

    protected AbstractJdbcWireRecordStoreImpl(ConnectionProvider connectionProvider, String tableName, Set<ConnectionListener> listeners) {
        this(connectionProvider, tableName);
        this.connectionListeners = listeners;
    }

    protected abstract Optional<String> getMappedSqlType(TypedValue<?> var1);

    protected abstract JdbcWireRecordStoreQueries buildSqlWireRecordStoreQueries();

    protected String escapeIdentifier(String string) {
        String escapedName = string.replace("\"", "\"\"");
        return "\"" + escapedName + "\"";
    }

    protected void createTable() throws KuraStoreException {
        this.connectionProvider.withConnection(c -> {
            this.execute((Connection)c, this.queries.getSqlCreateTable(), new Object[0]);
            return null;
        }, "failed to create table");
    }

    protected void createTimestampIndex() throws KuraStoreException {
        this.connectionProvider.withConnection(c -> {
            this.execute((Connection)c, this.queries.getSqlCreateTimestampIndex(), new Object[0]);
            return null;
        }, "failed to create index");
    }

    public synchronized void truncate(int noOfRecordsToKeep) throws KuraStoreException {
        this.connectionProvider.withConnection(c -> {
            if (noOfRecordsToKeep == 0) {
                logger.info("Truncating table {}...", (Object)this.escapedTableName);
                this.execute((Connection)c, this.queries.getSqlTruncateTable(), new Object[0]);
            } else {
                int tableSize = this.getTableSize((Connection)c);
                int deleteCount = Math.max(0, tableSize - noOfRecordsToKeep);
                if (deleteCount == 0) {
                    return null;
                }
                logger.info("Partially emptying table {}", (Object)this.escapedTableName);
                this.execute((Connection)c, MessageFormat.format(this.queries.getSqlDeleteRangeTable(), deleteCount), new Object[0]);
            }
            return null;
        }, "failed to truncate table");
    }

    public synchronized int getSize() throws KuraStoreException {
        return this.connectionProvider.withConnection(this::getTableSize, "failed to determine table size");
    }

    public synchronized void insertRecords(List<WireRecord> records) throws KuraStoreException {
        this.connectionProvider.withConnection(c -> {
            for (WireRecord r : records) {
                try {
                    this.createColumns((Connection)c, r);
                    this.insertRecord((Connection)c, r);
                }
                catch (SQLException sQLException) {
                    logger.info("Reconciling table and columns");
                    this.execute((Connection)c, this.queries.getSqlCreateTable(), new Object[0]);
                    this.createColumns((Connection)c, r);
                    this.insertRecord((Connection)c, r);
                }
            }
            return null;
        }, "failed to insert records");
    }

    public void close() {
    }

    protected void createColumns(Connection c, WireRecord wireRecord) throws SQLException {
        Map<String, String> columnTypes = this.probeColumnTypes(c);
        for (Map.Entry entry : wireRecord.getProperties().entrySet()) {
            this.createColumn(c, (String)entry.getKey(), (TypedValue)entry.getValue(), columnTypes);
        }
    }

    protected void createColumn(Connection c, String name, TypedValue<?> value, Map<String, String> columnTypes) throws SQLException {
        Optional<String> mappedType = this.getMappedSqlType(value);
        if (!mappedType.isPresent()) {
            logger.warn("Unsupported typed value: {}", value);
            return;
        }
        String escapedColName = this.escapeIdentifier(name);
        if (!columnTypes.containsKey(escapedColName)) {
            logger.debug("creating new column: {} {}", (Object)name, (Object)mappedType.get());
            this.execute(c, MessageFormat.format(this.queries.getSqlAddColumn(), escapedColName, mappedType.get()), new Object[0]);
        } else {
            String actualColumnType = columnTypes.get(escapedColName);
            if (!this.isCorrectColumnType(value, mappedType.get(), actualColumnType)) {
                logger.debug("changing column type: {} {}", (Object)name, (Object)mappedType.get());
                this.execute(c, MessageFormat.format(this.queries.getSqlDropColumn(), escapedColName), new Object[0]);
                this.execute(c, MessageFormat.format(this.queries.getSqlAddColumn(), escapedColName, mappedType.get()), new Object[0]);
            }
        }
    }

    protected boolean isCorrectColumnType(TypedValue<?> value, String mappedType, String actualType) {
        return mappedType.equals(actualType);
    }

    protected Map<String, String> probeColumnTypes(Connection c) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        String catalog = c.getCatalog();
        DatabaseMetaData dbMetaData = c.getMetaData();
        Throwable throwable = null;
        Object var6_7 = null;
        try (ResultSet rsColumns = dbMetaData.getColumns(catalog, null, this.tableName, null);){
            while (rsColumns.next()) {
                String colName = this.getEscapedColumnName(rsColumns);
                String type = this.getColumnType(rsColumns);
                result.put(colName, type);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    protected String getEscapedColumnName(ResultSet columnMetadata) throws SQLException {
        return this.escapeIdentifier(columnMetadata.getString(COLUMN_NAME));
    }

    protected String getColumnType(ResultSet columnMetadata) throws SQLException {
        return columnMetadata.getString(TYPE_NAME);
    }

    protected void insertRecord(Connection connection, WireRecord wireRecord) throws SQLException {
        String insertQuery = this.buildInsertQuerySql(wireRecord.getProperties());
        long timestamp = System.currentTimeMillis();
        logger.debug("Storing data into table {}...", (Object)this.escapedTableName);
        Throwable throwable = null;
        Object var7_7 = null;
        try (PreparedStatement stmt = connection.prepareStatement(insertQuery);){
            stmt.setLong(1, timestamp);
            int i = 2;
            for (Map.Entry entry : wireRecord.getProperties().entrySet()) {
                this.setParameterValue(stmt, i, ((TypedValue)entry.getValue()).getValue());
                ++i;
            }
            stmt.execute();
            if (this.isExplicitCommitEnabled()) {
                connection.commit();
            }
            logger.debug("Stored typed value");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String buildInsertQuerySql(Map<String, TypedValue<?>> properties) {
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbVals = new StringBuilder();
        sbCols.append("TIMESTAMP");
        sbVals.append("?");
        for (Map.Entry<String, TypedValue<?>> entry : properties.entrySet()) {
            String escapedColName = this.escapeIdentifier(entry.getKey());
            sbCols.append(", ").append(escapedColName);
            sbVals.append(", ?");
        }
        return MessageFormat.format(this.queries.getSqlInsertRecord(), sbCols.toString(), sbVals.toString());
    }

    protected void setParameterValue(PreparedStatement stmt, int index, Object value) throws SQLException {
        if (value instanceof String) {
            stmt.setString(index, (String)value);
        } else if (value instanceof Integer) {
            stmt.setInt(index, (Integer)value);
        } else if (value instanceof Double) {
            stmt.setDouble(index, (Double)value);
        } else if (value instanceof Boolean) {
            stmt.setBoolean(index, (Boolean)value);
        } else if (value instanceof Float) {
            stmt.setFloat(index, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            stmt.setLong(index, (Long)value);
        } else if (value instanceof byte[]) {
            stmt.setBytes(index, (byte[])value);
        } else {
            logger.warn("Unsupported value type {}", value.getClass());
        }
    }

    /*
     * Loose catch block
     */
    protected int getTableSize(Connection c) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            int n;
            ResultSet rset;
            Statement stmt;
            block16: {
                block15: {
                    stmt = c.createStatement();
                    rset = stmt.executeQuery(this.queries.getSqlRowCount());
                    n = JdbcUtil.getFirstColumnValue(() -> stmt.executeQuery(this.queries.getSqlRowCount()), ResultSet::getInt);
                    if (rset == null) break block15;
                    rset.close();
                }
                if (stmt == null) break block16;
                stmt.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void execute(Connection c, String sql, Object ... params) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement stmt = c.prepareStatement(sql);){
            int i = 0;
            while (i < params.length) {
                this.setParameterValue(stmt, 1 + i, params[i]);
                ++i;
            }
            stmt.execute();
            if (this.isExplicitCommitEnabled()) {
                c.commit();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isExplicitCommitEnabled() {
        return false;
    }
}

