/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.store.listener;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.kura.connection.listener.ConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionListenerManager {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionListenerManager.class);
    private final ExecutorService dispatchThread = Executors.newSingleThreadExecutor();
    private Set<ConnectionListener> listeners = new CopyOnWriteArraySet<ConnectionListener>();

    public void dispatchConnected() {
        this.dispatchThread.execute(() -> this.dispatch(ConnectionListener::connected));
    }

    public void dispatchDisconnected() {
        this.dispatchThread.execute(() -> this.dispatch(ConnectionListener::disconnected));
    }

    private void dispatch(Consumer<ConnectionListener> consumer) {
        for (ConnectionListener listener : this.listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Exception e) {
                logger.warn("Unexpected exception dispatching event", (Throwable)e);
            }
        }
    }

    public void addAll(Set<ConnectionListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public void add(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void remove(ConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public void shutdown() {
        this.dispatchThread.shutdown();
        try {
            this.dispatchThread.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting for executor shutdown", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

