/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.pushstream.AbstractPushStreamImpl;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamProvider;
import org.osgi.util.pushstream.PushbackPolicy;
import org.osgi.util.pushstream.QueuePolicy;
import org.osgi.util.pushstream.UnbufferedPushStreamImpl;

class BufferedPushStreamImpl<T, U extends BlockingQueue<PushEvent<? extends T>>>
extends UnbufferedPushStreamImpl<T, U>
implements PushStream<T> {
    private final U eventQueue;
    private final Semaphore semaphore;
    private final QueuePolicy<T, U> queuePolicy;
    private final PushbackPolicy<T, U> pushbackPolicy;
    private final AtomicBoolean softClose = new AtomicBoolean();
    private final int parallelism;

    BufferedPushStreamImpl(PushStreamProvider psp, PromiseFactory promiseFactory, U eventQueue, int parallelism, QueuePolicy<T, U> queuePolicy, PushbackPolicy<T, U> pushbackPolicy, Function<PushEventConsumer<T>, AutoCloseable> connector) {
        super(psp, promiseFactory, connector);
        this.eventQueue = eventQueue;
        this.parallelism = parallelism;
        this.semaphore = new Semaphore(parallelism);
        this.queuePolicy = queuePolicy;
        this.pushbackPolicy = pushbackPolicy;
    }

    @Override
    protected long handleEvent(PushEvent<? extends T> event) {
        long backPressure;
        block5: {
            if (!this.softClose.compareAndSet(false, event.isTerminal()) || this.closed.get() == AbstractPushStreamImpl.State.CLOSED) {
                return -1L;
            }
            try {
                this.queuePolicy.doOffer(this.eventQueue, event);
                backPressure = this.pushbackPolicy.pushback(this.eventQueue);
                if (backPressure >= 0L) break block5;
                this.close();
                return -1L;
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
                return -1L;
            }
        }
        if (this.semaphore.tryAcquire()) {
            this.startWorker();
        }
        return backPressure;
    }

    private void startWorker() {
        this.promiseFactory.executor().execute(() -> {
            try {
                PushEvent event;
                while ((event = (PushEvent)this.eventQueue.poll()) != null) {
                    long backpressure;
                    if (event.isTerminal()) {
                        this.semaphore.acquire(this.parallelism - 1);
                    }
                    if ((backpressure = super.handleEvent(event)) < 0L) {
                        this.close();
                        return;
                    }
                    if (backpressure <= 0L) continue;
                    this.promiseFactory.scheduledExecutor().schedule(this::startWorker, backpressure, TimeUnit.MILLISECONDS);
                    return;
                }
                this.semaphore.release();
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
            }
            if (this.eventQueue.peek() != null && this.semaphore.tryAcquire()) {
                try {
                    this.startWorker();
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                }
            }
        });
    }
}

