/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.asset.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.kura.asset.provider.BaseAsset;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.driver.PreparedRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverState {
    private static final Logger logger = LoggerFactory.getLogger(DriverState.class);
    private final Driver driver;
    private final Set<BaseAsset.ChannelListenerRegistration> attachedListeners;
    private PreparedRead preparedRead;

    public DriverState(Driver driver) {
        this.driver = driver;
        this.attachedListeners = new HashSet<BaseAsset.ChannelListenerRegistration>();
    }

    public Driver getDriver() {
        return this.driver;
    }

    public PreparedRead getPreparedRead() {
        return this.preparedRead;
    }

    public PreparedRead tryPrepareRead(List<ChannelRecord> records) {
        PreparedRead pRead;
        try {
            pRead = this.driver.prepareRead(records);
        }
        catch (Exception exception) {
            pRead = null;
        }
        if (pRead != null) {
            this.preparedRead = pRead;
        }
        return pRead;
    }

    private void closePreparedRead() {
        if (this.preparedRead != null) {
            try {
                this.preparedRead.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close prepared read", (Throwable)e);
            }
            this.preparedRead = null;
        }
    }

    public void syncChannelListeners(Set<BaseAsset.ChannelListenerRegistration> targetState, Map<String, Channel> channels) {
        this.setChannelListenersInternal(new HashSet<BaseAsset.ChannelListenerRegistration>(targetState), channels);
    }

    private void setChannelListenersInternal(Set<BaseAsset.ChannelListenerRegistration> targetState, Map<String, Channel> channels) {
        Iterator<BaseAsset.ChannelListenerRegistration> iter = this.attachedListeners.iterator();
        while (iter.hasNext()) {
            BaseAsset.ChannelListenerRegistration reg = iter.next();
            if (targetState.contains(reg)) continue;
            this.detach(iter, reg);
        }
        for (BaseAsset.ChannelListenerRegistration reg : targetState) {
            Channel channel;
            if (this.attachedListeners.contains(reg) || (channel = channels.get(reg.getChannelName())) == null || !channel.isEnabled()) continue;
            this.attach(reg, channel);
        }
    }

    private void attach(BaseAsset.ChannelListenerRegistration reg, Channel channel) {
        try {
            logger.debug("Registering Channel Listener for monitoring...");
            this.driver.registerChannelListener(channel.getConfiguration(), reg.getChannelListener());
            this.attachedListeners.add(reg);
            logger.debug("Registering Channel Listener for monitoring...done");
        }
        catch (Exception e) {
            logger.warn("Failed to register channel listener", (Throwable)e);
        }
    }

    private void detach(Iterator<BaseAsset.ChannelListenerRegistration> iter, BaseAsset.ChannelListenerRegistration reg) {
        try {
            logger.debug("Unregistering Asset Listener...");
            this.driver.unregisterChannelListener(reg.getChannelListener());
            iter.remove();
            logger.debug("Unregistering Asset Listener...done");
        }
        catch (Exception e) {
            logger.warn("Failed to unregister channel listener", (Throwable)e);
        }
    }

    public synchronized void shutdown() {
        this.closePreparedRead();
        this.setChannelListenersInternal(Collections.emptySet(), Collections.emptyMap());
    }
}

