/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCertificatesService;
import org.eclipse.kura.web.shared.service.GwtCertificatesServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Span;

public class DeviceCertsTabUi
extends Composite
implements Tab {
    private static DeviceCertsTabUiUiBinder uiBinder = (DeviceCertsTabUiUiBinder)GWT.create(DeviceCertsTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtCertificatesServiceAsync gwtCertificatesService = (GwtCertificatesServiceAsync)GWT.create(GwtCertificatesService.class);
    private boolean dirty;
    @UiField
    HTMLPanel description;
    @UiField
    Form deviceSslCertsForm;
    @UiField
    FormGroup groupStorageAliasForm;
    @UiField
    FormGroup groupPrivateKeyForm;
    @UiField
    FormGroup groupCertForm;
    @UiField
    FormLabel storageAliasLabel;
    @UiField
    FormLabel privateKeyLabel;
    @UiField
    FormLabel certificateLabel;
    @UiField
    Input storageAliasInput;
    @UiField
    TextArea privateKeyInput;
    @UiField
    TextArea certificateInput;
    @UiField
    Button reset;
    @UiField
    Button apply;

    public DeviceCertsTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initForm();
        this.setDirty(false);
        this.apply.setEnabled(false);
        this.reset.setEnabled(false);
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isValid() {
        boolean validAlias = this.isAliasValid();
        boolean validPrivateKey = this.isPrivateKeyValid();
        boolean validDeviceCert = this.isDeviceCertValid();
        return validAlias && validPrivateKey && validDeviceCert;
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            this.reset();
        }
    }

    private void initForm() {
        StringBuilder title = new StringBuilder();
        title.append("<p>");
        title.append(MSGS.settingsMAuthDescription1());
        title.append(" ");
        title.append(MSGS.settingsMAuthDescription2());
        title.append("</p>");
        this.description.add((Widget)new Span(title.toString()));
        this.storageAliasLabel.setText(MSGS.settingsStorageAliasLabel());
        this.storageAliasInput.addChangeHandler(event -> {
            this.isAliasValid();
            this.setDirty(true);
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        });
        this.privateKeyLabel.setText(MSGS.settingsPrivateCertLabel());
        this.privateKeyInput.setVisibleLines(20);
        this.privateKeyInput.addChangeHandler(event -> {
            this.isPrivateKeyValid();
            this.setDirty(true);
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        });
        this.certificateLabel.setText(MSGS.settingsPublicCertLabel());
        this.certificateInput.setVisibleLines(20);
        this.certificateInput.addChangeHandler(event -> {
            this.isDeviceCertValid();
            this.setDirty(true);
            this.apply.setEnabled(true);
            this.reset.setEnabled(true);
        });
        this.reset.setText(MSGS.reset());
        this.reset.addClickHandler(event -> {
            this.reset();
            this.setDirty(false);
            this.apply.setEnabled(false);
            this.reset.setEnabled(false);
        });
        this.apply.setText(MSGS.apply());
        this.apply.addClickHandler(event -> {
            if (this.isValid()) {
                EntryClassUi.showWaitModal();
                this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex);
                        EntryClassUi.hideWaitModal();
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        DeviceCertsTabUi.this.gwtCertificatesService.storePublicPrivateKeys(token, DeviceCertsTabUi.this.privateKeyInput.getValue(), DeviceCertsTabUi.this.certificateInput.getValue(), null, (String)DeviceCertsTabUi.this.storageAliasInput.getValue(), new AsyncCallback<Integer>(){

                            public void onFailure(Throwable caught) {
                                FailureHandler.handle(caught);
                                EntryClassUi.hideWaitModal();
                            }

                            public void onSuccess(Integer certsStored) {
                                DeviceCertsTabUi.this.reset();
                                DeviceCertsTabUi.this.setDirty(false);
                                (this).DeviceCertsTabUi.this.apply.setEnabled(false);
                                (this).DeviceCertsTabUi.this.reset.setEnabled(false);
                                EntryClassUi.hideWaitModal();
                            }
                        });
                    }
                });
            }
        });
    }

    private void reset() {
        this.storageAliasInput.setText("");
        this.privateKeyInput.setText("");
        this.certificateInput.setText("");
    }

    private boolean isAliasValid() {
        if (this.storageAliasInput.getText() == null || "".equals(this.storageAliasInput.getText().trim())) {
            this.groupStorageAliasForm.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.groupStorageAliasForm.setValidationState(ValidationState.NONE);
        return true;
    }

    private boolean isPrivateKeyValid() {
        if (this.certificateInput.getText() == null || "".equals(this.certificateInput.getText().trim())) {
            this.groupCertForm.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.groupCertForm.setValidationState(ValidationState.NONE);
        return true;
    }

    private boolean isDeviceCertValid() {
        if (this.certificateInput.getText() == null || "".equals(this.certificateInput.getText().trim())) {
            this.groupCertForm.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.groupCertForm.setValidationState(ValidationState.NONE);
        return true;
    }

    static interface DeviceCertsTabUiUiBinder
    extends UiBinder<Widget, DeviceCertsTabUi> {
    }
}

