/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.SessionRegistry;
import io.moquette.persistence.EnqueuedMessageValueType;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

class H2PersistentQueue
extends AbstractQueue<SessionRegistry.EnqueuedMessage> {
    private final MVMap<Long, SessionRegistry.EnqueuedMessage> queueMap;
    private final MVMap<String, Long> metadataMap;
    private final AtomicLong head;
    private final AtomicLong tail;

    H2PersistentQueue(MVStore store, String queueName) {
        if (queueName == null || queueName.isEmpty()) {
            throw new IllegalArgumentException("queueName parameter can't be empty or null");
        }
        MVMap.BasicBuilder messageTypeBuilder = new MVMap.Builder().valueType(new EnqueuedMessageValueType());
        this.queueMap = store.openMap("queue_" + queueName, messageTypeBuilder);
        this.metadataMap = store.openMap("queue_" + queueName + "_meta");
        long headIdx = 0L;
        if (this.metadataMap.containsKey("head")) {
            headIdx = this.metadataMap.get("head");
        } else {
            this.metadataMap.put("head", headIdx);
        }
        this.head = new AtomicLong(headIdx);
        long tailIdx = 0L;
        if (this.metadataMap.containsKey("tail")) {
            tailIdx = this.metadataMap.get("tail");
        } else {
            this.metadataMap.put("tail", tailIdx);
        }
        this.tail = new AtomicLong(tailIdx);
    }

    static void dropQueue(MVStore store, String queueName) {
        store.removeMap(store.openMap("queue_" + queueName));
        store.removeMap(store.openMap("queue_" + queueName + "_meta"));
    }

    @Override
    public Iterator<SessionRegistry.EnqueuedMessage> iterator() {
        return null;
    }

    @Override
    public int size() {
        return this.head.intValue() - this.tail.intValue();
    }

    @Override
    public boolean offer(SessionRegistry.EnqueuedMessage t) {
        if (t == null) {
            throw new NullPointerException("Inserted element can't be null");
        }
        long nextHead = this.head.getAndIncrement();
        this.queueMap.put(nextHead, t);
        this.metadataMap.put("head", nextHead + 1L);
        return true;
    }

    @Override
    public SessionRegistry.EnqueuedMessage poll() {
        if (this.head.equals(this.tail)) {
            return null;
        }
        long nextTail = this.tail.getAndIncrement();
        SessionRegistry.EnqueuedMessage tail = this.queueMap.get(nextTail);
        this.queueMap.remove(nextTail);
        this.metadataMap.put("tail", nextTail + 1L);
        return tail;
    }

    @Override
    public SessionRegistry.EnqueuedMessage peek() {
        if (this.head.equals(this.tail)) {
            return null;
        }
        return this.queueMap.get(this.tail.get());
    }
}

