/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.Authorizator;
import io.moquette.broker.BrokerConfiguration;
import io.moquette.broker.ClientDescriptor;
import io.moquette.broker.DefaultMoquetteSslContextCreator;
import io.moquette.broker.IQueueRepository;
import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.ISslContextCreator;
import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.MQTTConnectionFactory;
import io.moquette.broker.MemoryQueueRepository;
import io.moquette.broker.MemoryRetainedRepository;
import io.moquette.broker.NewNettyAcceptor;
import io.moquette.broker.NewNettyMQTTHandler;
import io.moquette.broker.PostOffice;
import io.moquette.broker.SessionRegistry;
import io.moquette.broker.config.FileResourceLoader;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.IResourceLoader;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.config.ResourceLoaderConfig;
import io.moquette.broker.security.ACLFileParser;
import io.moquette.broker.security.AcceptAllAuthenticator;
import io.moquette.broker.security.DenyAllAuthorizatorPolicy;
import io.moquette.broker.security.IAuthenticator;
import io.moquette.broker.security.IAuthorizatorPolicy;
import io.moquette.broker.security.PermitAllAuthorizatorPolicy;
import io.moquette.broker.security.ResourceAuthenticator;
import io.moquette.broker.subscriptions.CTrieSubscriptionDirectory;
import io.moquette.interception.BrokerInterceptor;
import io.moquette.interception.InterceptHandler;
import io.moquette.logging.LoggingUtils;
import io.moquette.persistence.H2Builder;
import io.moquette.persistence.MemorySubscriptionsRepository;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private ScheduledExecutorService scheduler;
    private NewNettyAcceptor acceptor;
    private volatile boolean initialized;
    private PostOffice dispatcher;
    private BrokerInterceptor interceptor;
    private H2Builder h2Builder;
    private SessionRegistry sessions;

    public static void main(String[] args) throws IOException {
        Server server = new Server();
        server.startServer();
        System.out.println("Server started, version 0.15");
        Runtime.getRuntime().addShutdownHook(new Thread(server::stopServer));
    }

    public void startServer() throws IOException {
        File defaultConfigurationFile = Server.defaultConfigFile();
        LOG.info("Starting Moquette integration. Configuration file path={}", (Object)defaultConfigurationFile.getAbsolutePath());
        FileResourceLoader filesystemLoader = new FileResourceLoader(defaultConfigurationFile);
        ResourceLoaderConfig config = new ResourceLoaderConfig(filesystemLoader);
        this.startServer(config);
    }

    private static File defaultConfigFile() {
        String configPath = System.getProperty("moquette.path", null);
        return new File(configPath, "config/moquette.conf");
    }

    public void startServer(File configFile) throws IOException {
        LOG.info("Starting Moquette integration. Configuration file path: {}", (Object)configFile.getAbsolutePath());
        FileResourceLoader filesystemLoader = new FileResourceLoader(configFile);
        ResourceLoaderConfig config = new ResourceLoaderConfig(filesystemLoader);
        this.startServer(config);
    }

    public void startServer(Properties configProps) throws IOException {
        LOG.debug("Starting Moquette integration using properties object");
        MemoryConfig config = new MemoryConfig(configProps);
        this.startServer(config);
    }

    public void startServer(IConfig config) throws IOException {
        LOG.debug("Starting Moquette integration using IConfig instance");
        this.startServer(config, null);
    }

    public void startServer(IConfig config, List<? extends InterceptHandler> handlers) throws IOException {
        LOG.debug("Starting moquette integration using IConfig instance and intercept handlers");
        this.startServer(config, handlers, null, null, null);
    }

    public void startServer(IConfig config, List<? extends InterceptHandler> handlers, ISslContextCreator sslCtxCreator, IAuthenticator authenticator, IAuthorizatorPolicy authorizatorPolicy) {
        IRetainedRepository retainedRepository;
        IQueueRepository queueRepository;
        ISubscriptionsRepository subscriptionsRepository;
        long start = System.currentTimeMillis();
        if (handlers == null) {
            handlers = Collections.emptyList();
        }
        LOG.trace("Starting Moquette Server. MQTT message interceptors={}", (Object)LoggingUtils.getInterceptorIds(handlers));
        this.scheduler = Executors.newScheduledThreadPool(1);
        String handlerProp = System.getProperty("intercept.handler");
        if (handlerProp != null) {
            config.setProperty("intercept.handler", handlerProp);
        }
        String persistencePath = config.getProperty("persistent_store");
        LOG.debug("Configuring Using persistent store file, path: {}", (Object)persistencePath);
        this.initInterceptors(config, handlers);
        LOG.debug("Initialized MQTT protocol processor");
        if (sslCtxCreator == null) {
            LOG.info("Using default SSL context creator");
            sslCtxCreator = new DefaultMoquetteSslContextCreator(config);
        }
        authenticator = this.initializeAuthenticator(authenticator, config);
        authorizatorPolicy = this.initializeAuthorizatorPolicy(authorizatorPolicy, config);
        if (persistencePath != null && !persistencePath.isEmpty()) {
            LOG.trace("Configuring H2 subscriptions store to {}", (Object)persistencePath);
            this.h2Builder = new H2Builder(config, this.scheduler).initStore();
            subscriptionsRepository = this.h2Builder.subscriptionsRepository();
            queueRepository = this.h2Builder.queueRepository();
            retainedRepository = this.h2Builder.retainedRepository();
        } else {
            LOG.trace("Configuring in-memory subscriptions store");
            subscriptionsRepository = new MemorySubscriptionsRepository();
            queueRepository = new MemoryQueueRepository();
            retainedRepository = new MemoryRetainedRepository();
        }
        CTrieSubscriptionDirectory subscriptions = new CTrieSubscriptionDirectory();
        subscriptions.init(subscriptionsRepository);
        Authorizator authorizator = new Authorizator(authorizatorPolicy);
        this.sessions = new SessionRegistry(subscriptions, queueRepository, authorizator);
        this.dispatcher = new PostOffice(subscriptions, retainedRepository, this.sessions, this.interceptor, authorizator);
        BrokerConfiguration brokerConfig = new BrokerConfiguration(config);
        MQTTConnectionFactory connectionFactory = new MQTTConnectionFactory(brokerConfig, authenticator, this.sessions, this.dispatcher);
        NewNettyMQTTHandler mqttHandler = new NewNettyMQTTHandler(connectionFactory);
        this.acceptor = new NewNettyAcceptor();
        this.acceptor.initialize(mqttHandler, config, sslCtxCreator);
        long startTime = System.currentTimeMillis() - start;
        LOG.info("Moquette integration has been started successfully in {} ms", (Object)startTime);
        this.initialized = true;
    }

    private IAuthorizatorPolicy initializeAuthorizatorPolicy(IAuthorizatorPolicy authorizatorPolicy, IConfig props) {
        LOG.debug("Configuring MQTT authorizator policy");
        String authorizatorClassName = props.getProperty("authorizator_class", "");
        if (authorizatorPolicy == null && !authorizatorClassName.isEmpty()) {
            authorizatorPolicy = this.loadClass(authorizatorClassName, IAuthorizatorPolicy.class, IConfig.class, props);
        }
        if (authorizatorPolicy == null) {
            String aclFilePath = props.getProperty("acl_file", "");
            if (aclFilePath != null && !aclFilePath.isEmpty()) {
                authorizatorPolicy = new DenyAllAuthorizatorPolicy();
                try {
                    LOG.info("Parsing ACL file. Path = {}", (Object)aclFilePath);
                    IResourceLoader resourceLoader = props.getResourceLoader();
                    authorizatorPolicy = ACLFileParser.parse(resourceLoader.loadResource(aclFilePath));
                }
                catch (ParseException pex) {
                    LOG.error("Unable to parse ACL file. path = {}", (Object)aclFilePath, (Object)pex);
                }
            } else {
                authorizatorPolicy = new PermitAllAuthorizatorPolicy();
            }
            LOG.info("Authorizator policy {} instance will be used", (Object)authorizatorPolicy.getClass().getName());
        }
        return authorizatorPolicy;
    }

    private IAuthenticator initializeAuthenticator(IAuthenticator authenticator, IConfig props) {
        LOG.debug("Configuring MQTT authenticator");
        String authenticatorClassName = props.getProperty("authenticator_class", "");
        if (authenticator == null && !authenticatorClassName.isEmpty()) {
            authenticator = this.loadClass(authenticatorClassName, IAuthenticator.class, IConfig.class, props);
        }
        IResourceLoader resourceLoader = props.getResourceLoader();
        if (authenticator == null) {
            String passwdPath = props.getProperty("password_file", "");
            authenticator = passwdPath.isEmpty() ? new AcceptAllAuthenticator() : new ResourceAuthenticator(resourceLoader, passwdPath);
            LOG.info("An {} authenticator instance will be used", (Object)authenticator.getClass().getName());
        }
        return authenticator;
    }

    private void initInterceptors(IConfig props, List<? extends InterceptHandler> embeddedObservers) {
        InterceptHandler handler;
        LOG.info("Configuring message interceptors...");
        ArrayList<InterceptHandler> observers = new ArrayList<InterceptHandler>(embeddedObservers);
        String interceptorClassName = props.getProperty("intercept.handler");
        if (interceptorClassName != null && !interceptorClassName.isEmpty() && (handler = this.loadClass(interceptorClassName, InterceptHandler.class, Server.class, this)) != null) {
            observers.add(handler);
        }
        this.interceptor = new BrokerInterceptor(props, observers);
    }

    private <T, U> T loadClass(String className, Class<T> intrface, Class<U> constructorArgClass, U props) {
        T instance = null;
        try {
            LOG.info("Invoking constructor with {} argument. ClassName={}, interfaceName={}", constructorArgClass.getName(), className, intrface.getName());
            instance = this.getClass().getClassLoader().loadClass(className).asSubclass(intrface).getConstructor(constructorArgClass).newInstance(props);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.warn("Unable to invoke constructor with {} argument. ClassName={}, interfaceName={}, cause={}, errorMessage={}", constructorArgClass.getName(), className, intrface.getName(), ex.getCause(), ex.getMessage());
            return null;
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            try {
                LOG.info("Invoking default constructor. ClassName={}, interfaceName={}", (Object)className, (Object)intrface.getName());
                instance = this.getClass().getClassLoader().loadClass(className).asSubclass(intrface).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.error("Unable to invoke default constructor. ClassName={}, interfaceName={}, cause={}, errorMessage={}", className, intrface.getName(), ex.getCause(), ex.getMessage());
                return null;
            }
        }
        return instance;
    }

    public void internalPublish(MqttPublishMessage msg, String clientId) {
        int messageID = msg.variableHeader().packetId();
        if (!this.initialized) {
            LOG.error("Moquette is not started, internal message cannot be published. CId: {}, messageId: {}", (Object)clientId, (Object)messageID);
            throw new IllegalStateException("Can't publish on a integration is not yet started");
        }
        LOG.trace("Internal publishing message CId: {}, messageId: {}", (Object)clientId, (Object)messageID);
        this.dispatcher.internalPublish(msg);
        msg.payload().release();
    }

    public void stopServer() {
        LOG.info("Unbinding integration from the configured ports");
        this.acceptor.close();
        LOG.trace("Stopping MQTT protocol processor");
        this.initialized = false;
        this.scheduler.shutdownNow();
        if (this.h2Builder != null) {
            LOG.trace("Shutting down H2 persistence {}");
            this.h2Builder.closeStore();
        }
        this.interceptor.stop();
        LOG.info("Moquette integration has been stopped.");
    }

    public int getPort() {
        return this.acceptor.getPort();
    }

    public int getSslPort() {
        return this.acceptor.getSslPort();
    }

    public void addInterceptHandler(InterceptHandler interceptHandler) {
        if (!this.initialized) {
            LOG.error("Moquette is not started, MQTT message interceptor cannot be added. InterceptorId={}", (Object)interceptHandler.getID());
            throw new IllegalStateException("Can't register interceptors on a integration that is not yet started");
        }
        LOG.info("Adding MQTT message interceptor. InterceptorId={}", (Object)interceptHandler.getID());
        this.interceptor.addInterceptHandler(interceptHandler);
    }

    public void removeInterceptHandler(InterceptHandler interceptHandler) {
        if (!this.initialized) {
            LOG.error("Moquette is not started, MQTT message interceptor cannot be removed. InterceptorId={}", (Object)interceptHandler.getID());
            throw new IllegalStateException("Can't deregister interceptors from a integration that is not yet started");
        }
        LOG.info("Removing MQTT message interceptor. InterceptorId={}", (Object)interceptHandler.getID());
        this.interceptor.removeInterceptHandler(interceptHandler);
    }

    public Collection<ClientDescriptor> listConnectedClients() {
        return this.sessions.listConnectedClients();
    }
}

