/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.AbstractMeasure;
import com.librato.metrics.client.GaugeMeasure;
import com.librato.metrics.client.Maps;
import com.librato.metrics.client.Sanitizer;
import com.librato.metrics.client.Tag;
import com.librato.metrics.client.Tags;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TaggedMeasure
extends AbstractMeasure {
    private double sum;
    private long count;
    private double min;
    private double max;
    private List<Tag> tags = new LinkedList<Tag>();

    public TaggedMeasure(GaugeMeasure measure) {
        super(measure);
        if (measure.getValue() != null) {
            this.sum = measure.getValue();
            this.count = 1L;
            this.min = this.sum;
            this.max = this.sum;
        } else {
            this.sum = measure.getSum();
            this.count = measure.getCount();
            this.min = measure.getMin();
            this.max = measure.getMax();
        }
    }

    public TaggedMeasure(String name, double value, Tag tag, Tag ... tags) {
        this(name, value, 1L, value, value, tag, tags);
    }

    public TaggedMeasure(String name, double sum, long count, double min, double max, Tag tag, Tag ... tags) {
        super(name);
        this.sum = sum;
        this.count = count;
        this.min = min;
        this.max = max;
        this.addTag(tag);
        this.addTags(tags);
    }

    public void addTags(Tag ... tags) {
        for (Tag tag : tags) {
            this.addTag(tag);
        }
    }

    public void addTag(Tag tag) {
        String tagName = this.sanitizeTagName(tag.name);
        String tagValue = this.sanitizeTagValue(tag.value);
        this.tags.add(new Tag(tagName, tagValue));
    }

    private String sanitizeTagValue(String value) {
        value = Sanitizer.LAST_PASS.apply(value);
        return this.trimToSize(value, 255);
    }

    private String sanitizeTagName(String name) {
        name = Sanitizer.LAST_PASS.apply(name);
        return this.trimToSize(name, 64);
    }

    private String trimToSize(String string, int size) {
        if (string == null || string.length() <= size) {
            return string;
        }
        return string.substring(0, size);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        Maps.putIfNotNull(map, "time", this.epoch);
        map.put("sum", this.sum);
        map.put("count", this.count);
        map.put("min", this.min);
        map.put("max", this.max);
        if (!this.tags.isEmpty()) {
            map.put("tags", Tags.toMap(this.tags));
        }
        return map;
    }

    @Override
    public boolean isTagged() {
        return true;
    }

    @Override
    public boolean isGauge() {
        return true;
    }

    public TaggedMeasure setPeriod(int period) {
        this.period = period;
        return this;
    }

    public TaggedMeasure setMetricAttributes(Map<String, Object> attributes) {
        this.metricAttributes = attributes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("name=").append(this.name);
        sb.append(", epoch=").append(this.epoch);
        sb.append(", tags=").append(this.tags);
        sb.append(", sum=").append(this.sum);
        sb.append(", count=").append(this.count);
        sb.append(", min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaggedMeasure that = (TaggedMeasure)o;
        if (Double.compare(that.sum, this.sum) != 0) {
            return false;
        }
        if (this.count != that.count) {
            return false;
        }
        if (Double.compare(that.min, this.min) != 0) {
            return false;
        }
        if (Double.compare(that.max, this.max) != 0) {
            return false;
        }
        return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.sum);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        return result;
    }
}

