/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.watchdog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.emulator.watchdog.CriticalServiceImpl;
import org.eclipse.kura.watchdog.CriticalComponent;
import org.eclipse.kura.watchdog.WatchdogService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchdogServiceImpl
implements WatchdogService,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(WatchdogServiceImpl.class);
    private static List<CriticalServiceImpl> criticalServiceList;
    private Map<String, Object> properties;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private int pingInterval = 10000;
    private boolean configEnabled = false;
    private boolean enabled;

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        this.properties = properties;
        if (properties == null) {
            logger.debug("activating WatchdogService with null props");
        } else {
            logger.debug("activating WatchdogService with {}", (Object)properties.toString());
        }
        criticalServiceList = new ArrayList<CriticalServiceImpl>();
        this.enabled = false;
        if (this.executor != null) {
            this.executor.shutdown();
            while (!this.executor.isTerminated()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
            this.executor = null;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.future = this.executor.scheduleAtFixedRate(() -> {
            Thread.currentThread().setName(this.getClass().getSimpleName());
            if (this.configEnabled) {
                this.doWatchdogLoop();
            }
        }, 0L, this.pingInterval, TimeUnit.MILLISECONDS);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        this.executor = null;
        criticalServiceList = null;
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("updated...");
        this.properties = properties;
        if (this.properties != null) {
            Object enabled = this.properties.get("enabled");
            if (enabled != null) {
                this.configEnabled = (Boolean)enabled;
            }
            if (!this.configEnabled) {
                return;
            }
            if (this.properties.get("pingInterval") != null) {
                this.pingInterval = (Integer)this.properties.get("pingInterval");
                if (this.future != null) {
                    this.future.cancel(false);
                    while (!this.future.isDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                this.future = this.executor.scheduleAtFixedRate(() -> {
                    Thread.currentThread().setName(this.getClass().getSimpleName());
                    if (this.configEnabled) {
                        this.doWatchdogLoop();
                    }
                }, 0L, this.pingInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void startWatchdog() {
        this.enabled = true;
    }

    public void stopWatchdog() {
        this.enabled = false;
    }

    public int getHardwareTimeout() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCriticalComponent(CriticalComponent criticalComponent) {
        CriticalServiceImpl service = new CriticalServiceImpl(criticalComponent.getCriticalComponentName(), criticalComponent.getCriticalComponentTimeout());
        List<CriticalServiceImpl> list = criticalServiceList;
        synchronized (list) {
            boolean existing = false;
            for (CriticalServiceImpl csi : criticalServiceList) {
                if (criticalComponent.getCriticalComponentName().compareTo(csi.getName()) != 0) continue;
                existing = true;
            }
            if (!existing) {
                criticalServiceList.add(service);
            }
        }
        logger.debug("Added {} , with timeout = {}, list contains {} critical services", new Object[]{criticalComponent.getCriticalComponentName(), criticalComponent.getCriticalComponentTimeout(), criticalServiceList.size()});
    }

    @Deprecated
    public void registerCriticalService(CriticalComponent criticalComponent) {
        this.registerCriticalComponent(criticalComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCriticalComponent(CriticalComponent criticalComponent) {
        List<CriticalServiceImpl> list = criticalServiceList;
        synchronized (list) {
            int i = 0;
            while (i < criticalServiceList.size()) {
                if (criticalComponent.getCriticalComponentName().compareTo(criticalServiceList.get(i).getName()) == 0) {
                    criticalServiceList.remove(i);
                    logger.debug("Critical service {} removed, {}", (Object)criticalComponent.getCriticalComponentName(), (Object)System.currentTimeMillis());
                }
                ++i;
            }
        }
    }

    @Deprecated
    public void unregisterCriticalService(CriticalComponent criticalComponent) {
        this.unregisterCriticalComponent(criticalComponent);
    }

    public List<CriticalComponent> getCriticalComponents() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin(CriticalComponent criticalService) {
        List<CriticalServiceImpl> list = criticalServiceList;
        synchronized (list) {
            for (CriticalServiceImpl csi : criticalServiceList) {
                if (criticalService.getCriticalComponentName().compareTo(csi.getName()) != 0) continue;
                csi.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWatchdogLoop() {
        if (!this.enabled) {
            return;
        }
        boolean failure = false;
        List<CriticalServiceImpl> list = criticalServiceList;
        synchronized (list) {
            if (!criticalServiceList.isEmpty()) {
                for (CriticalServiceImpl csi : criticalServiceList) {
                    if (!csi.isTimedOut()) continue;
                    failure = true;
                    logger.warn("Critical service {} failed -> SYSTEM REBOOT", (Object)csi.getName());
                }
            }
        }
        if (!failure) {
            this.refreshWatchdog();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void refreshWatchdog() {
        File f = new File("/dev/watchdog");
        if (!f.exists()) return;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(f);
                try {
                    try (PrintWriter pw = new PrintWriter(fos);){
                        pw.write("w");
                        pw.flush();
                        fos.getFD().sync();
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isConfigEnabled() {
        return this.configEnabled;
    }

    public void setConfigEnabled(boolean configEnabled) {
        this.configEnabled = configEnabled;
    }
}

