/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_be extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Час па Грынвічы",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Стандартны час Апіі",
               "",
               "Летні час Апіі",
               "",
               "Час Апіі",
               "",
            };
        final String[] Cook = new String[] {
               "Стандартны час астравоў Кука",
               "",
               "Паўлетні час астравоў Кука",
               "",
               "Час астравоў Кука",
               "",
            };
        final String[] Cuba = new String[] {
               "Стандартны час Кубы",
               "CST",
               "Летні час Кубы",
               "CDT",
               "Час Кубы",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Стандартны час Фіджы",
               "",
               "Летні час Фіджы",
               "",
               "Час Фіджы",
               "",
            };
        final String[] Gulf = new String[] {
               "Час Персідскага заліва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Стандартны час Хоўда",
               "",
               "Летні час Хоўда",
               "",
               "Час Хоўда",
               "",
            };
        final String[] Iran = new String[] {
               "Іранскі стандартны час",
               "",
               "Іранскі летні час",
               "",
               "Іранскі час",
               "",
            };
        final String[] Niue = new String[] {
               "Час Ніуэ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омскі стандартны час",
               "",
               "Омскі летні час",
               "",
               "Омскі час",
               "",
            };
        final String[] Peru = new String[] {
               "Перуанскі стандартны час",
               "",
               "Перуанскі летні час",
               "",
               "Перуанскі час",
               "",
            };
        final String[] Truk = new String[] {
               "Час Трука",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Час вострава Уэйк",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чылійскі стандартны час",
               "",
               "Чылійскі летні час",
               "",
               "Чылійскі час",
               "",
            };
        final String[] China = new String[] {
               "Стандартны час Кітая",
               "CST",
               "Летні час Кітая",
               "CDT",
               "Час Кітая",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Час Какосавых астравоў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Час станцыі Дэйвіс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Час Індыі",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Стандартны час Японіі",
               "JST",
               "Летні час Японіі",
               "JDT",
               "Час Японіі",
               "JT",
            };
        final String[] Korea = new String[] {
               "Стандартны час Карэі",
               "KST",
               "Летні час Карэі",
               "KST",
               "Час Карэі",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Час Науру",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непальскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Час Палау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Стандартны час Самоа",
               "SST",
               "Летні час Самоа",
               "SST",
               "Час Самоа",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Час станцыі Сёва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Стандартны час Тонга",
               "",
               "Летні час Тонга",
               "",
               "Час Тонга",
               "",
            };
        final String[] Yukon = new String[] {
               "Час Юкана",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Стандартны час Аляскі",
               "AKST",
               "Летні час Аляскі",
               "AKDT",
               "Час Аляскі",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазонскі стандартны час",
               "",
               "Амазонскі летні час",
               "",
               "Амазонскі час",
               "",
            };
        final String[] Azores = new String[] {
               "Стандартны час Азорскіх астравоў",
               "",
               "Летні час Азорскіх астравоў",
               "",
               "Час Азорскіх астравоў",
               "",
            };
        final String[] Bhutan = new String[] {
               "Час Бутана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Час Брунея",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Стандартны час вострава Вялікадня",
               "",
               "Летні час вострава Вялікадня",
               "",
               "Час вострава Вялікадня",
               "",
            };
        final String[] Guyana = new String[] {
               "Час Гаяны",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Гавайска-Алеуцкі стандартны час",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Ізраільскі стандартны час",
               "IST",
               "Ізраільскі летні час",
               "IDT",
               "Ізраільскі час",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Час астравоў Кусаіе",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Час станцыі Моўсан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Маскоўскі стандартны час",
               "MSK",
               "Маскоўскі летні час",
               "MSK",
               "Маскоўскі час",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Час вострава Панпеі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Час Таіці",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Стандартны час Тайбэя",
               "CST",
               "Летні час Тайбэя",
               "CDT",
               "Час Тайбэя",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Час Тувалу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Час станцыі Васток",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Час астравоў Уоліс і Футуна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Стандартны час Саудаўскай Аравіі",
               "",
               "Летні час Саудаўскай Аравіі",
               "",
               "Час Саудаўскай Аравіі",
               "",
            };
        final String[] Armenia = new String[] {
               "Стандартны час Арменіі",
               "",
               "Летні час Арменіі",
               "",
               "Час Арменіі",
               "",
            };
        final String[] Bolivia = new String[] {
               "Балівійскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Стандартны час Чатэма",
               "",
               "Летні час Чатэма",
               "",
               "Час Чатэма",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Універсальны каардынаваны час",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Эквадорскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Час астравоў Гамб’е",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузінскі стандартны час",
               "",
               "Грузінскі летні час",
               "",
               "Грузінскі час",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Іркуцкі стандартны час",
               "",
               "Іркуцкі летні час",
               "",
               "Іркуцкі час",
               "",
            };
        final String[] Magadan = new String[] {
               "Магаданскі стандартны час",
               "",
               "Магаданскі летні час",
               "",
               "Магаданскі час",
               "",
            };
        final String[] Myanmar = new String[] {
               "Час М’янмы",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Стандартны час вострава Норфалк",
               "",
               "Летні час вострава Норфалк",
               "",
               "Час вострава Норфалк",
               "",
            };
        final String[] Noronha = new String[] {
               "Стандартны час Фернанду-дзі-Наронья",
               "",
               "Летні час Фернанду-дзі-Наронья",
               "",
               "Час Фернанду-дзі-Наронья",
               "",
            };
        final String[] Reunion = new String[] {
               "Час Рэюньёна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Час станцыі Ротэра",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Час Саламонавых астравоў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Час Такелау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвайскі стандартны час",
               "",
               "Уругвайскі летні час",
               "",
               "Уругвайскі час",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Стандартны час Вануату",
               "",
               "Летні час Вануату",
               "",
               "Час Вануату",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якуцкі стандартны час",
               "",
               "Якуцкі летні час",
               "",
               "Якуцкі час",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантычны стандартны час",
               "AST",
               "Атлантычны летні час",
               "AST",
               "Атлантычны час",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразільскі стандартны час",
               "",
               "Бразільскі летні час",
               "",
               "Бразільскі час",
               "",
            };
        final String[] Chamorro = new String[] {
               "Час Чамора",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Калумбійскі стандартны час",
               "",
               "Калумбійскі летні час",
               "",
               "Калумбійскі час",
               "",
            };
        final String[] Falkland = new String[] {
               "Стандартны час Фалклендскіх астравоў",
               "",
               "Летні час Фалклендскіх астравоў",
               "",
               "Час Фалклендскіх астравоў",
               "",
            };
        final String[] Malaysia = new String[] {
               "Час Малайзіі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Час Мальдываў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Стандартны час Улан-Батара",
               "",
               "Летні час Улан-Батара",
               "",
               "Час Улан-Батара",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакістанскі стандартны час",
               "PKT",
               "Пакістанскі летні час",
               "PKST",
               "Пакістанскі час",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Стандартны час Парагвая",
               "",
               "Летні час Парагвая",
               "",
               "Час Парагвая",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Час вострава Піткэрн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Час Сурынама",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргенцінскі стандартны час",
               "",
               "Аргенцінскі летні час",
               "",
               "Аргенцінскі час",
               "",
            };
        final String[] Christmas = new String[] {
               "Час вострава Каляд",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Стандартны час Галапагоскіх астравоў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Стандартны час Ганконга",
               "HKT",
               "Летні час Ганконга",
               "HKST",
               "Час Ганконга",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Індакітайскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Час Кыргызстана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Стандартны час Лорд-Хау",
               "",
               "Летні час Лорд-Хау",
               "",
               "Час Лорд-Хау",
               "",
            };
        final String[] Marquesas = new String[] {
               "Час Маркізскіх астравоў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Стандартны час Маўрыкія",
               "",
               "Летні час Маўрыкія",
               "",
               "Час Маўрыкія",
               "",
            };
        final String[] Singapore = new String[] {
               "Сінгапурскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэльскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Стандартны час Азербайджана",
               "",
               "Летні час Азербайджана",
               "",
               "Час Азербайджана",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Стандартны час Бангладэш",
               "",
               "Летні час Бангладэш",
               "",
               "Час Бангладэш",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Стандартны час Каба-Вердэ",
               "",
               "Летні час Каба-Вердэ",
               "",
               "Час Каба-Вердэ",
               "",
            };
        final String[] East_Timor = new String[] {
               "Час Усходняга Тымора",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казахстанскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Час Сейшэльскіх астравоў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Час Таджыкістана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Стандартны час Узбекістана",
               "",
               "Летні час Узбекістана",
               "",
               "Час Узбекістана",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афганістанскі час",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Краснаярскі стандартны час",
               "",
               "Краснаярскі летні час",
               "",
               "Краснаярскі час",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Стандартны час Новай Зеландыі",
               "NZST",
               "Летні час Новай Зеландыі",
               "NZDT",
               "Час Новай Зеландыі",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Філіпінскі стандартны час",
               "PST",
               "Філіпінскі летні час",
               "PDT",
               "Філіпінскі час",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Уладзівастоцкі стандартны час",
               "",
               "Уладзівастоцкі летні час",
               "",
               "Уладзівастоцкі час",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Час Індыйскага акіяна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Час астравоў Лайн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ньюфаўндлендскі стандартны час",
               "NST",
               "Ньюфаўндлендскі летні час",
               "NDT",
               "Ньюфаўндлендскі час",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Стандартны час Туркменістана",
               "",
               "Летні час Туркменістана",
               "",
               "Час Туркменістана",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Час Французскай Гвіяны",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Стандартны час Новай Каледоніі",
               "",
               "Летні час Новай Каледоніі",
               "",
               "Час Новай Каледоніі",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Час Паўднёвай Георгіі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екацярынбургскі стандартны час",
               "",
               "Екацярынбургскі летні час",
               "",
               "Екацярынбургскі час",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Цэнтральнаафрыканскі час",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Усходнеафрыканскі час",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Заходнеафрыканскі час",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Час станцыі Дзюмон-Дзюрвіль",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Цэнтральнаеўрапейскі стандартны час",
               "CET",
               "Цэнтральнаеўрапейскі летні час",
               "CEST",
               "Цэнтральнаеўрапейскі час",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Усходнееўрапейскі стандартны час",
               "EET",
               "Усходнееўрапейскі летні час",
               "EEST",
               "Усходнееўрапейскі час",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Заходнееўрапейскі стандартны час",
               "WET",
               "Заходнееўрапейскі летні час",
               "WEST",
               "Заходнееўрапейскі час",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексіканскі ціхаакіянскі стандатны час",
               "MST",
               "Мексіканскі ціхаакіянскі летні час",
               "MDT",
               "Мексіканскі ціхаакіянскі час",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Паўднёваафрыканскі час",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Паўночнаамерыканскі цэнтральны стандартны час",
               "CST",
               "Паўночнаамерыканскі цэнтральны летні час",
               "CDT",
               "Паўночнаамерыканскі цэнтральны час",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Паўночнаамерыканскі ўсходні стандартны час",
               "EST",
               "Паўночнаамерыканскі ўсходні летні час",
               "EST",
               "Паўночнаамерыканскі ўсходні час",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Ціхаакіянскі стандартны час",
               "PST",
               "Ціхаакіянскі летні час",
               "PDT",
               "Ціхаакіянскі час",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Час Французскай паўднёва-антарктычнай тэрыторыі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Час астравоў Гілберта",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Гавайска-Алеуцкі стандартны час",
               "HST",
               "Гавайска-Алеуцкі летні час",
               "HDT",
               "Гавайска-Алеуцкі час",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Час астравоў Фенікс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Стандартны час Сен-П’ер і Мікелон",
               "",
               "Стандартны летні час Сен-П’ер і Мікелон",
               "",
               "Час Сен-П’ер і Мікелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Паўночнаамерыканскі горны стандартны час",
               "MST",
               "Паўночнаамерыканскі горны летні час",
               "MST",
               "Паўночнаамерыканскі горны час",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Час Маршалавых астравоў",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Час Папуа-Новай Гвінеі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Стандартны час цэнтральнай Аўстраліі",
               "ACST",
               "Летні час цэнтральнай Аўстраліі",
               "ACDT",
               "Час цэнтральнай Аўстраліі",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Стандартны час усходняй Аўстраліі",
               "AEST",
               "Летні час усходняй Аўстраліі",
               "AEDT",
               "Час усходняй Аўстраліі",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Стандартны час заходняй Аўстраліі",
               "AWST",
               "Летні час заходняй Аўстраліі",
               "AWDT",
               "Час заходняй Аўстраліі",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Цэнтральнаінданезійскі час",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Усходнеінданезійскі час",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Заходнеінданезійскі час",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Стандартны цэнтральна-заходні час Аўстраліі",
               "",
               "Летні цэнтральна-заходні час Аўстраліі",
               "",
               "Цэнтральна-заходні час Аўстраліі",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Універсальны каардынаваны час",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Ірландскі стандартны час",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Універсальны каардынаваны час",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Універсальны каардынаваны час",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Універсальны каардынаваны час",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Універсальны каардынаваны час",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Універсальны каардынаваны час",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Ірландскі стандартны час",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Час па Грынвічы",
                    "GMT",
                    "Брытанскі летні час",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Адэн" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дылі" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Хоўд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Уральск" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Аман (горад)" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чыта" },
            { "timezone.excity.Asia/Dhaka", "Дака" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макаа" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токіа" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Джуба" },
            { "timezone.excity.Africa/Lome", "Ламэ" },
            { "timezone.excity.Asia/Almaty", "Алматы" },
            { "timezone.excity.Asia/Anadyr", "Анадыр" },
            { "timezone.excity.Asia/Aqtobe", "Актабэ" },
            { "timezone.excity.Asia/Atyrau", "Атырау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеўрон" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Маніла" },
            { "timezone.excity.Asia/Muscat", "Маскат" },
            { "timezone.excity.Asia/Riyadh", "Эр-Рыяд" },
            { "timezone.excity.Asia/Saigon", "Хашымін" },
            { "timezone.excity.Asia/Taipei", "Тайбэй" },
            { "timezone.excity.Asia/Tehran", "Тэгеран" },
            { "timezone.excity.Asia/Urumqi", "Урумчы" },
            { "timezone.excity.Etc/Unknown", "Невядомы горад" },
            { "timezone.excity.Europe/Kiev", "Кіеў" },
            { "timezone.excity.Europe/Oslo", "Осла" },
            { "timezone.excity.Europe/Riga", "Рыга" },
            { "timezone.excity.Europe/Rome", "Рым" },
            { "timezone.excity.Indian/Mahe", "Маэ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Акра" },
            { "timezone.excity.Africa/Cairo", "Каір" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагас" },
            { "timezone.excity.Africa/Tunis", "Туніс" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Ліма" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрэйн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бішкек" },
            { "timezone.excity.Asia/Colombo", "Каломба" },
            { "timezone.excity.Asia/Irkutsk", "Іркуцк" },
            { "timezone.excity.Asia/Jakarta", "Джакарта" },
            { "timezone.excity.Asia/Karachi", "Карачы" },
            { "timezone.excity.Asia/Kuching", "Кучынг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Нікасія" },
            { "timezone.excity.Asia/Rangoon", "Рангун" },
            { "timezone.excity.Asia/Tbilisi", "Тбілісі" },
            { "timezone.excity.Asia/Thimphu", "Тхімпху" },
            { "timezone.excity.Asia/Yakutsk", "Якуцк" },
            { "timezone.excity.Asia/Yerevan", "Ерэван" },
            { "timezone.excity.Europe/Kirov", "Кіраў" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Мінск" },
            { "timezone.excity.Europe/Paris", "Парыж" },
            { "timezone.excity.Europe/Sofia", "Сафія" },
            { "timezone.excity.Europe/Vaduz", "Вадуц" },
            { "timezone.excity.Indian/Cocos", "Какосавыя астравы" },
            { "timezone.excity.Pacific/Apia", "Апія" },
            { "timezone.excity.Pacific/Fiji", "Фіджы" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ніуэ" },
            { "timezone.excity.Pacific/Truk", "Трук" },
            { "timezone.excity.Pacific/Wake", "Уэйк" },
            { "timezone.excity.Africa/Asmera", "Асмара" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Бангі" },
            { "timezone.excity.Africa/Banjul", "Банджул" },
            { "timezone.excity.Africa/Bissau", "Бісау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Харарэ" },
            { "timezone.excity.Africa/Kigali", "Кігалі" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малаба" },
            { "timezone.excity.Africa/Maputo", "Мапуту" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ніямей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Баія" },
            { "timezone.excity.America/Belem", "Белен" },
            { "timezone.excity.America/Boise", "Бойсэ" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Сітка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашгабат" },
            { "timezone.excity.Asia/Calcutta", "Калькута" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбэ" },
            { "timezone.excity.Asia/Jayapura", "Джаяпура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандыга" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Qostanay", "Кустанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалін" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Усць-Нера" },
            { "timezone.excity.Europe/Athens", "Афіны" },
            { "timezone.excity.Europe/Berlin", "Берлін" },
            { "timezone.excity.Europe/Dublin", "Дублін" },
            { "timezone.excity.Europe/Jersey", "Джэрсі" },
            { "timezone.excity.Europe/Lisbon", "Лісабон" },
            { "timezone.excity.Europe/London", "Лондан" },
            { "timezone.excity.Europe/Madrid", "Мадрыд" },
            { "timezone.excity.Europe/Monaco", "Манака" },
            { "timezone.excity.Europe/Moscow", "Масква" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скоп’е" },
            { "timezone.excity.Europe/Tirane", "Тырана" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Заграб" },
            { "timezone.excity.Europe/Zurich", "Цюрых" },
            { "timezone.excity.Indian/Chagos", "Чагас" },
            { "timezone.excity.Indian/Comoro", "Каморскія астравы" },
            { "timezone.excity.Pacific/Efate", "Эфатэ" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абіджан" },
            { "timezone.excity.Africa/Algiers", "Алжыр" },
            { "timezone.excity.Africa/Conakry", "Конакры" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабанэ" },
            { "timezone.excity.Africa/Nairobi", "Найробі" },
            { "timezone.excity.Africa/Tripoli", "Трыпалі" },
            { "timezone.excity.America/Belize", "Беліз" },
            { "timezone.excity.America/Bogota", "Багата" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайманавы астравы" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доўсан" },
            { "timezone.excity.America/Denver", "Дэнвер" },
            { "timezone.excity.America/Guyana", "Гаяна" },
            { "timezone.excity.America/Havana", "Гавана" },
            { "timezone.excity.America/Inuvik", "Інувік" },
            { "timezone.excity.America/Juneau", "Джуна" },
            { "timezone.excity.America/La_Paz", "Ла-Пас" },
            { "timezone.excity.America/Maceio", "Масеё" },
            { "timezone.excity.America/Manaus", "Манаўс" },
            { "timezone.excity.America/Merida", "Мерыда" },
            { "timezone.excity.America/Nassau", "Насаў" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Рэсіфі" },
            { "timezone.excity.America/Regina", "Рэджайна" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Ганконг" },
            { "timezone.excity.Asia/Jerusalem", "Іерусалім" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Пантыянак" },
            { "timezone.excity.Asia/Pyongyang", "Пхеньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кзыл-Арда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сінгапур" },
            { "timezone.excity.Asia/Vientiane", "В’енцьян" },
            { "timezone.excity.Europe/Andorra", "Андора" },
            { "timezone.excity.Europe/Saratov", "Саратаў" },
            { "timezone.excity.Europe/Tallinn", "Талін" },
            { "timezone.excity.Europe/Vatican", "Ватыкан" },
            { "timezone.excity.Europe/Vilnius", "Вільнюс" },
            { "timezone.excity.Indian/Mayotte", "Маёта" },
            { "timezone.excity.Indian/Reunion", "Рэюньён" },
            { "timezone.excity.Pacific/Easter", "Вялікадня востраў" },
            { "timezone.excity.Pacific/Kosrae", "Кусаіе" },
            { "timezone.excity.Pacific/Majuro", "Маджура" },
            { "timezone.excity.Pacific/Midway", "Мідуэй" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Панпеі" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таіці" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уоліс" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Джыбуці" },
            { "timezone.excity.Africa/El_Aaiun", "Эль-Аюн" },
            { "timezone.excity.Africa/Freetown", "Фрытаўн" },
            { "timezone.excity.Africa/Gaborone", "Габаронэ" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Кіншаса" },
            { "timezone.excity.Africa/Monrovia", "Манровія" },
            { "timezone.excity.Africa/Ndjamena", "Нджамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Тамэ" },
            { "timezone.excity.Africa/Windhoek", "Віндхук" },
            { "timezone.excity.America/Antigua", "Антыгуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Каена" },
            { "timezone.excity.America/Chicago", "Чыкага" },
            { "timezone.excity.America/Cordoba", "Кордава" },
            { "timezone.excity.America/Creston", "Крэстан" },
            { "timezone.excity.America/Curacao", "Кюрасаа" },
            { "timezone.excity.America/Detroit", "Дэтройт" },
            { "timezone.excity.America/Godthab", "Нук" },
            { "timezone.excity.America/Grenada", "Грэнада" },
            { "timezone.excity.America/Halifax", "Галіфакс" },
            { "timezone.excity.America/Iqaluit", "Ікалуіт" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Марыго" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктан" },
            { "timezone.excity.America/Noronha", "Наронья" },
            { "timezone.excity.America/Ojinaga", "Ахінага" },
            { "timezone.excity.America/Phoenix", "Фінікс" },
            { "timezone.excity.America/Tijuana", "Тыхуана" },
            { "timezone.excity.America/Toronto", "Таронта" },
            { "timezone.excity.America/Tortola", "Тартола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пнампень" },
            { "timezone.excity.Atlantic/Azores", "Азорскія астравы" },
            { "timezone.excity.Atlantic/Canary", "Канарскія астравы" },
            { "timezone.excity.Atlantic/Faeroe", "Фарэрскія астравы" },
            { "timezone.excity.Australia/Eucla", "Юкла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Бялград" },
            { "timezone.excity.Europe/Brussels", "Брусель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бюзінген" },
            { "timezone.excity.Europe/Chisinau", "Кішынёў" },
            { "timezone.excity.Europe/Guernsey", "Гернсі" },
            { "timezone.excity.Europe/Helsinki", "Хельсінкі" },
            { "timezone.excity.Europe/Istanbul", "Стамбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараева" },
            { "timezone.excity.Indian/Maldives", "Мальдывы" },
            { "timezone.excity.Pacific/Chatham", "Чатэм" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофа" },
            { "timezone.excity.Pacific/Gambier", "Астравы Гамб’е" },
            { "timezone.excity.Pacific/Norfolk", "Норфалк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Магадыша" },
            { "timezone.excity.America/Anguilla", "Ангілья" },
            { "timezone.excity.America/Asuncion", "Асунсьён" },
            { "timezone.excity.America/Barbados", "Барбадас" },
            { "timezone.excity.America/Dominica", "Дамініка" },
            { "timezone.excity.America/Edmonton", "Эдмантан" },
            { "timezone.excity.America/Eirunepe", "Эйрунэпе" },
            { "timezone.excity.America/Mazatlan", "Масатлан" },
            { "timezone.excity.America/Miquelon", "Мікелон" },
            { "timezone.excity.America/New_York", "Нью-Ёрк" },
            { "timezone.excity.America/Resolute", "Рэзальют" },
            { "timezone.excity.America/Santarem", "Сантарэн" },
            { "timezone.excity.America/Santiago", "Сант’яга" },
            { "timezone.excity.America/St_Johns", "Сент-Джонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Кітс" },
            { "timezone.excity.America/St_Lucia", "Сент-Люсія" },
            { "timezone.excity.America/Winnipeg", "Вініпег" },
            { "timezone.excity.Antarctica/Casey", "Кэйсі" },
            { "timezone.excity.Antarctica/Davis", "Дэйвіс" },
            { "timezone.excity.Antarctica/Syowa", "Сёва" },
            { "timezone.excity.Antarctica/Troll", "Трол" },
            { "timezone.excity.Asia/Krasnoyarsk", "Краснаярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новасібірск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батар" },
            { "timezone.excity.Asia/Vladivostok", "Уладзівасток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермудскія астравы" },
            { "timezone.excity.Atlantic/Madeira", "Мадэйра" },
            { "timezone.excity.Atlantic/Stanley", "Порт-Стэнлі" },
            { "timezone.excity.Australia/Darwin", "Дарвін" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сідней" },
            { "timezone.excity.Europe/Amsterdam", "Амстэрдам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарэст" },
            { "timezone.excity.Europe/Gibraltar", "Гібралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Марыянхаміна" },
            { "timezone.excity.Europe/Podgorica", "Падгорыца" },
            { "timezone.excity.Europe/Stockholm", "Стакгольм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульянаўск" },
            { "timezone.excity.Europe/Volgograd", "Валгаград" },
            { "timezone.excity.Indian/Christmas", "Востраў Каляд" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маўрыкій" },
            { "timezone.excity.Pacific/Auckland", "Окленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафуці" },
            { "timezone.excity.Pacific/Honolulu", "Ганалулу" },
            { "timezone.excity.Pacific/Pitcairn", "Піткэрн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Лібрэвіль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбашы" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порта-Нова" },
            { "timezone.excity.America/Anchorage", "Анкарыдж" },
            { "timezone.excity.America/Araguaina", "Арагуаіна" },
            { "timezone.excity.America/Boa_Vista", "Боа-Віста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чыўаўа" },
            { "timezone.excity.America/Coyhaique", "Кайайке" },
            { "timezone.excity.America/Fortaleza", "Фарталеза" },
            { "timezone.excity.America/Glace_Bay", "Глэйс-Бэй" },
            { "timezone.excity.America/Goose_Bay", "Гус-Бэй" },
            { "timezone.excity.America/Guatemala", "Гватэмала" },
            { "timezone.excity.America/Guayaquil", "Гуаякіль" },
            { "timezone.excity.America/Matamoros", "Матаморас" },
            { "timezone.excity.America/Menominee", "Меноміні" },
            { "timezone.excity.America/Monterrey", "Мантэрэй" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паўлу" },
            { "timezone.excity.America/St_Thomas", "Сент-Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моўсан" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Васток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала-Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новакузнецк" },
            { "timezone.excity.Europe/Bratislava", "Браціслава" },
            { "timezone.excity.Europe/Copenhagen", "Капенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марына" },
            { "timezone.excity.Europe/Simferopol", "Сімферопаль" },
            { "timezone.excity.Pacific/Enderbury", "Кантон" },
            { "timezone.excity.Pacific/Galapagos", "Галапагас" },
            { "timezone.excity.Pacific/Kwajalein", "Кваджалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркізскія астравы" },
            { "timezone.excity.Pacific/Pago_Pago", "Пага-Пага" },
            { "timezone.excity.Pacific/Rarotonga", "Раратонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тангатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Адыс-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Бразавіль" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Рыка" },
            { "timezone.excity.America/Grand_Turk", "Гранд-Цёрк" },
            { "timezone.excity.America/Guadeloupe", "Гвадэлупа" },
            { "timezone.excity.America/Hermosillo", "Эрмасілья" },
            { "timezone.excity.America/Kralendijk", "Кралендэйк" },
            { "timezone.excity.America/Louisville", "Луісвіл" },
            { "timezone.excity.America/Martinique", "Марцініка" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Мантэвідэа" },
            { "timezone.excity.America/Montserrat", "Мантсерат" },
            { "timezone.excity.America/Paramaribo", "Парамарыба" },
            { "timezone.excity.America/Rio_Branco", "Рыу-Бранку" },
            { "timezone.excity.America/St_Vincent", "Сент-Вінсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Мак-Мерда" },
            { "timezone.excity.Antarctica/Rothera", "Ротэра" },
            { "timezone.excity.Asia/Srednekolymsk", "Сярэднекалымск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екацярынбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рэйк’явік" },
            { "timezone.excity.Atlantic/St_Helena", "Востраў Святой Алены" },
            { "timezone.excity.Australia/Adelaide", "Адэлаіда" },
            { "timezone.excity.Australia/Brisbane", "Брысбен" },
            { "timezone.excity.Australia/Lindeman", "Ліндэман" },
            { "timezone.excity.Europe/Isle_of_Man", "Востраў Мэн" },
            { "timezone.excity.Europe/Kaliningrad", "Калінінград" },
            { "timezone.excity.Pacific/Kiritimati", "Кірыцімаці" },
            { "timezone.excity.Africa/Johannesburg", "Яганэсбург" },
            { "timezone.excity.America/El_Salvador", "Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт-Нельсан" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анджэлес" },
            { "timezone.excity.America/Mexico_City", "Мехіка" },
            { "timezone.excity.America/Porto_Velho", "Порту-Велью" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрта-Рыка" },
            { "timezone.excity.America/Tegucigalpa", "Тэгусігальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгйір" },
            { "timezone.excity.Atlantic/Cape_Verde", "Каба-Вердэ" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд-Хау" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананарыву" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-эс-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Бланк-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнас-Айрэс" },
            { "timezone.excity.America/Campo_Grande", "Кампу-Гранды" },
            { "timezone.excity.America/Danmarkshavn", "Данмарксхаўн" },
            { "timezone.excity.America/Dawson_Creek", "Досан-Крык" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Індыяна" },
            { "timezone.excity.America/Indianapolis", "Індыянапаліс" },
            { "timezone.excity.America/Punta_Arenas", "Пунта-Арэнас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкін-Інлет" },
            { "timezone.excity.America/Scoresbysund", "Ітакартаарміт" },
            { "timezone.excity.Antarctica/Macquarie", "Макуоры" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвіль" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт-Морсбі" },
            { "timezone.excity.America/Cambridge_Bay", "Кембрыдж-Бей" },
            { "timezone.excity.America/Ciudad_Juarez", "Сьюдад-Хуарэс" },
            { "timezone.excity.America/Coral_Harbour", "Атыкокан" },
            { "timezone.excity.America/Indiana/Vevay", "Віві, Індыяна" },
            { "timezone.excity.America/Lower_Princes", "Лоўэр Прынсіз Квотэр" },
            { "timezone.excity.America/Port_of_Spain", "Порт-оф-Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санта-Дамінга" },
            { "timezone.excity.America/St_Barthelemy", "Сен-Бартэльмі" },
            { "timezone.excity.America/Swift_Current", "Свіфт-Керэнт" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен-Хіл" },
            { "timezone.excity.America/Bahia_Banderas", "Баія-дэ-Бандэрас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Прэнс" },
            { "timezone.excity.Atlantic/South_Georgia", "Паўднёвая Георгія" },
            { "timezone.excity.America/Argentina/Salta", "Сальта" },
            { "timezone.excity.America/Indiana/Marengo", "Марэнга, Індыяна" },
            { "timezone.excity.America/Indiana/Winamac", "Уінамак, Індыяна" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуая" },
            { "timezone.excity.America/Indiana/Tell_City", "Тэл Сіці, Індыяна" },
            { "timezone.excity.America/Indiana/Vincennes", "Вінсенс, Індыяна" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дзюмон-Дзюрвіль" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Рыёха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан-Луіс" },
            { "timezone.excity.America/Indiana/Petersburg", "Пітэрсберг, Індыяна" },
            { "timezone.excity.America/Kentucky/Monticello", "Мантысела, Кентукі" },
            { "timezone.excity.America/North_Dakota/Beulah", "Б’юла, Паўночная Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Сентэр, Паўночная Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рыа-Гальегас" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Сейлем, Паўночная Дакота" },
        };
        return data;
    }
}
