/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TV = "टुवालु";
        final String metaValue_ar = "अरबी";
        final String metaValue_hy = "अर्मेनियन";
        final String metaValue_bn = "बंगाली";
        final String metaValue_zbl = "ब्लिसिम्बॉल्स";
        final String metaValue_chr = "चेरोकी";
        final String metaValue_cop = "कॉप्टिक";
        final String metaValue_ka = "जॉर्जियन";
        final String metaValue_el = "ग्रीक";
        final String metaValue_gu = "गुजराती";
        final String metaValue_he = "हिब्रू";
        final String metaValue_ja = "जपानी";
        final String metaValue_km = "ख्मेर";
        final String metaValue_kn = "कन्नड";
        final String metaValue_ko = "कोरियन";
        final String metaValue_lo = "लाओ";
        final String metaValue_la = "लॅटिन";
        final String metaValue_ml = "मल्याळम";
        final String metaValue_mn = "मंगोलियन";
        final String metaValue_or = "उडिया";
        final String metaValue_phn = "फोनिशियन";
        final String metaValue_si = "सिंहला";
        final String metaValue_ta = "तामिळ";
        final String metaValue_tl = "टागालोग";
        final String metaValue_th = "थाई";
        final String metaValue_bo = "तिबेटी";
        final String metaValue_vai = "वाई";
        final String metaValue_peo = "पुरातन फारसी";
        final Object[][] data = new Object[][] {
            { "001", "जग" },
            { "002", "आफ्रिका" },
            { "003", "उत्तर अमेरिका" },
            { "005", "दक्षिण अमेरिका" },
            { "009", "ओशनिया" },
            { "011", "पश्चिम आफ्रिका" },
            { "013", "मध्य अमेरिका" },
            { "014", "पूर्व आफ्रिका" },
            { "015", "उत्तर आफ्रिका" },
            { "017", "मध्य आफ्रिका" },
            { "018", "दक्षिणी आफ्रिका" },
            { "019", "अमेरिका" },
            { "021", "उत्तरी अमेरिका" },
            { "029", "कॅरीबियन" },
            { "030", "पूर्व आशिया" },
            { "034", "दक्षिण आशिया" },
            { "035", "दक्षिण पूर्व आशिया" },
            { "039", "दक्षिण युरोप" },
            { "053", "ऑस्‍ट्रेलेशिया" },
            { "054", "मेलानेशिया" },
            { "057", "मायक्रोनेशियन प्रदेश" },
            { "061", "पॉलिनेशिया" },
            { "142", "आशिया" },
            { "143", "मध्य आशिया" },
            { "145", "पश्चिम आशिया" },
            { "150", "युरोप" },
            { "151", "पूर्व युरोप" },
            { "154", "उत्तर युरोप" },
            { "155", "पश्चिम युरोप" },
            { "202", "उप-सहारा आफ्रिका" },
            { "419", "लॅटिन अमेरिका" },
            { "AC", "अ‍ॅसेन्शियन बेट" },
            { "AD", "अँडोरा" },
            { "AE", "संयुक्त अरब अमिराती" },
            { "AF", "अफगाणिस्तान" },
            { "AG", "अँटिग्वा आणि बर्बुडा" },
            { "AI", "अँग्विला" },
            { "AL", "अल्बानिया" },
            { "AM", "अर्मेनिया" },
            { "AO", "अंगोला" },
            { "AQ", "अंटार्क्टिका" },
            { "AR", "अर्जेंटिना" },
            { "AS", "अमेरिकन सामोआ" },
            { "AT", "ऑस्ट्रिया" },
            { "AU", "ऑस्ट्रेलिया" },
            { "AW", "अरुबा" },
            { "AX", "अ‍ॅलँड बेटे" },
            { "AZ", "अझरबैजान" },
            { "BA", "बोस्निया अणि हर्जेगोविना" },
            { "BB", "बार्बाडोस" },
            { "BD", "बांगलादेश" },
            { "BE", "बेल्जियम" },
            { "BF", "बुर्किना फासो" },
            { "BG", "बल्गेरिया" },
            { "BH", "बहारीन" },
            { "BI", "बुरुंडी" },
            { "BJ", "बेनिन" },
            { "BL", "सेंट बार्थेलेमी" },
            { "BM", "बर्मुडा" },
            { "BN", "ब्रुनेई" },
            { "BO", "बोलिव्हिया" },
            { "BQ", "कॅरिबियन नेदरलँड्स" },
            { "BR", "ब्राझिल" },
            { "BS", "बहामाज" },
            { "BT", "भूतान" },
            { "BV", "बोउवेट बेट" },
            { "BW", "बोट्सवाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलिझे" },
            { "CA", "कॅनडा" },
            { "CC", "कोकोस (कीलिंग) बेटे" },
            { "CD", "काँगो - किंशासा" },
            { "CF", "केंद्रीय अफ्रिकी प्रजासत्ताक" },
            { "CG", "काँगो - ब्राझाविले" },
            { "CH", "स्वित्झर्लंड" },
            { "CI", "कोत द’ईवोआर" },
            { "CK", "कुक बेटे" },
            { "CL", "चिली" },
            { "CM", "कॅमेरून" },
            { "CN", "चीन" },
            { "CO", "कोलम्बिया" },
            { "CP", "क्लिपरटोन बेट" },
            { "CQ", "सार्क" },
            { "CR", "कोस्टा रिका" },
            { "CU", "क्यूबा" },
            { "CV", "केप व्हर्डे" },
            { "CW", "क्युरासाओ" },
            { "CX", "ख्रिसमस बेट" },
            { "CY", "सायप्रस" },
            { "CZ", "झेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "दिएगो गार्सिया" },
            { "DJ", "जिबौटी" },
            { "DK", "डेन्मार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन प्रजासत्ताक" },
            { "DZ", "अल्जीरिया" },
            { "EA", "स्यूटा आणि मेलिला" },
            { "EC", "इक्वाडोर" },
            { "EE", "एस्टोनिया" },
            { "EG", "इजिप्त" },
            { "EH", "पश्चिम सहारा" },
            { "ER", "एरिट्रिया" },
            { "ES", "स्पेन" },
            { "ET", "इथिओपिया" },
            { "EU", "युरोपीय संघ" },
            { "EZ", "युरोझोन" },
            { "FI", "फिनलंड" },
            { "FJ", "फिजी" },
            { "FK", "फॉकलंड बेटे" },
            { "FM", "मायक्रोनेशिया" },
            { "FO", "फेरो बेटे" },
            { "FR", "फ्रान्स" },
            { "GA", "गॅबॉन" },
            { "GB", "युनायटेड किंगडम" },
            { "GD", "ग्रेनेडा" },
            { "GE", "जॉर्जिया" },
            { "GF", "फ्रेंच गयाना" },
            { "GG", "ग्वेर्नसे" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टर" },
            { "GL", "ग्रीनलंड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडेलोउपे" },
            { "GQ", "इक्वेटोरियल गिनी" },
            { "GR", "ग्रीस" },
            { "GS", "दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनी-बिसाउ" },
            { "GY", "गयाना" },
            { "HK", "हाँगकाँग एसएआर चीन" },
            { "HM", "हर्ड आणि मॅक्डोनाल्ड बेटे" },
            { "HN", "होंडुरास" },
            { "HR", "क्रोएशिया" },
            { "HT", "हैती" },
            { "HU", "हंगेरी" },
            { "IC", "कॅनरी बेटे" },
            { "ID", "इंडोनेशिया" },
            { "IE", "आयर्लंड" },
            { "IL", "इस्त्राइल" },
            { "IM", "आयल ऑफ मॅन" },
            { "IN", "भारत" },
            { "IO", "ब्रिटिश हिंद महासागर प्रदेश" },
            { "IQ", "इराक" },
            { "IR", "इराण" },
            { "IS", "आइसलँड" },
            { "IT", "इटली" },
            { "JE", "जर्सी" },
            { "JM", "जमैका" },
            { "JO", "जॉर्डन" },
            { "JP", "जपान" },
            { "KE", "केनिया" },
            { "KG", "किरगिझस्तान" },
            { "KH", "कंबोडिया" },
            { "KI", "किरीबाटी" },
            { "KM", "कोमोरोज" },
            { "KN", "सेंट किट्स आणि नेव्हिस" },
            { "KP", "उत्तर कोरिया" },
            { "KR", "दक्षिण कोरिया" },
            { "KW", "कुवेत" },
            { "KY", "केमन बेटे" },
            { "KZ", "कझाकस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनॉन" },
            { "LC", "सेंट ल्यूसिया" },
            { "LI", "लिक्टेनस्टाइन" },
            { "LK", "श्रीलंका" },
            { "LR", "लायबेरिया" },
            { "LS", "लेसोथो" },
            { "LT", "लिथुआनिया" },
            { "LU", "लक्झेंबर्ग" },
            { "LV", "लाटव्हिया" },
            { "LY", "लिबिया" },
            { "MA", "मोरोक्को" },
            { "MC", "मोनॅको" },
            { "MD", "मोल्डोव्हा" },
            { "ME", "मोंटेनेग्रो" },
            { "MF", "सेंट मार्टिन" },
            { "MG", "मादागास्कर" },
            { "MH", "मार्शल बेटे" },
            { "MK", "उत्तर मॅसेडोनिया" },
            { "ML", "माली" },
            { "MM", "म्यानमार (बर्मा)" },
            { "MN", "मंगोलिया" },
            { "MO", "मकाओ एसएआर चीन" },
            { "MP", "उत्तरी मारियाना बेटे" },
            { "MQ", "मार्टिनिक" },
            { "MR", "मॉरिटानिया" },
            { "MS", "मॉन्ट्सेराट" },
            { "MT", "माल्टा" },
            { "MU", "मॉरिशस" },
            { "MV", "मालदीव" },
            { "MW", "मलावी" },
            { "MX", "मेक्सिको" },
            { "MY", "मलेशिया" },
            { "MZ", "मोझाम्बिक" },
            { "NA", "नामिबिया" },
            { "NC", "न्यू कॅलेडोनिया" },
            { "NE", "नाइजर" },
            { "NF", "नॉरफॉक बेट" },
            { "NG", "नायजेरिया" },
            { "NI", "निकाराग्वा" },
            { "NL", "नेदरलँड" },
            { "NO", "नॉर्वे" },
            { "NP", "नेपाळ" },
            { "NR", "नाउरू" },
            { "NU", "नीयू" },
            { "NZ", "न्यूझीलंड" },
            { "OM", "ओमान" },
            { "PA", "पनामा" },
            { "PE", "पेरू" },
            { "PF", "फ्रेंच पॉलिनेशिया" },
            { "PG", "पापुआ न्यू गिनी" },
            { "PH", "फिलिपिन्स" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोलंड" },
            { "PM", "सेंट पियरे आणि मिक्वेलोन" },
            { "PN", "पिटकैर्न बेटे" },
            { "PR", "प्युएर्तो रिको" },
            { "PS", "पॅलेस्टिनियन प्रदेश" },
            { "PT", "पोर्तुगाल" },
            { "PW", "पलाऊ" },
            { "PY", "पराग्वे" },
            { "QA", "कतार" },
            { "QO", "आउटलाईंग ओशनिया" },
            { "RE", "रियुनियन" },
            { "RO", "रोमानिया" },
            { "RS", "सर्बिया" },
            { "RU", "रशिया" },
            { "RW", "रवांडा" },
            { "SA", "सौदी अरब" },
            { "SB", "सोलोमन बेटे" },
            { "SC", "सेशेल्स" },
            { "SD", "सुदान" },
            { "SE", "स्वीडन" },
            { "SG", "सिंगापूर" },
            { "SH", "सेंट हेलेना" },
            { "SI", "स्लोव्हेनिया" },
            { "SJ", "स्वालबर्ड आणि जान मायेन" },
            { "SK", "स्लोव्हाकिया" },
            { "SL", "सिएरा लिओन" },
            { "SM", "सॅन मरीनो" },
            { "SN", "सेनेगल" },
            { "SO", "सोमालिया" },
            { "SR", "सुरिनाम" },
            { "SS", "दक्षिण सुदान" },
            { "ST", "साओ टोम आणि प्रिंसिपे" },
            { "SV", "अल साल्वाडोर" },
            { "SX", "सिंट मार्टेन" },
            { "SY", "सीरिया" },
            { "SZ", "इस्वातिनी" },
            { "TA", "ट्रिस्टन दा कुन्हा" },
            { "TC", "टर्क्स आणि कैकोस बेटे" },
            { "TD", "चाड" },
            { "TF", "फ्रेंच दाक्षिणात्य प्रदेश" },
            { "TG", "टोगो" },
            { "TH", "थायलंड" },
            { "TJ", "ताजिकिस्तान" },
            { "TK", "तोकेलाउ" },
            { "TL", "तिमोर-लेस्ते" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "ट्यूनिशिया" },
            { "TO", "टोंगा" },
            { "TR", "तुर्किये" },
            { "TT", "त्रिनिदाद आणि टोबॅगो" },
            { "TV", metaValue_TV },
            { "TW", "तैवान" },
            { "TZ", "टांझानिया" },
            { "UA", "युक्रेन" },
            { "UG", "युगांडा" },
            { "UM", "यू.एस. आउटलाइंग बेटे" },
            { "UN", "संयुक्त राष्ट्र" },
            { "US", "युनायटेड स्टेट्स" },
            { "UY", "उरुग्वे" },
            { "UZ", "उझबेकिस्तान" },
            { "VA", "व्हॅटिकन सिटी" },
            { "VC", "सेंट व्हिन्सेंट आणि ग्रेनडाइन्स" },
            { "VE", "व्हेनेझुएला" },
            { "VG", "ब्रिटिश व्हर्जिन बेटे" },
            { "VI", "यू.एस. व्हर्जिन बेटे" },
            { "VN", "व्हिएतनाम" },
            { "VU", "वानुआतु" },
            { "WF", "वालिस आणि फ्यूचूना" },
            { "WS", "सामोआ" },
            { "XA", "नकली-उच्चारणे" },
            { "XB", "नकली-बीडी" },
            { "XK", "कोसोव्हो" },
            { "YE", "येमेन" },
            { "YT", "मायोट्टे" },
            { "ZA", "दक्षिण आफ्रिका" },
            { "ZM", "झाम्बिया" },
            { "ZW", "झिम्बाब्वे" },
            { "ZZ", "अज्ञात प्रदेश" },
            { "aa", "अफार" },
            { "ab", "अबखेजियन" },
            { "ae", "अवेस्तन" },
            { "af", "अफ्रिकान्स" },
            { "ak", "अकान" },
            { "am", "अम्हारिक" },
            { "an", "अर्गोनीज" },
            { "ar", metaValue_ar },
            { "as", "आसामी" },
            { "av", "अ‍ॅव्हेरिक" },
            { "ay", "ऐमरा" },
            { "az", "अझरबैजानी" },
            { "ba", "बष्किर" },
            { "be", "बेलारुशियन" },
            { "bg", "बल्गेरियन" },
            { "bi", "बिस्लामा" },
            { "bm", "बाम्बारा" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ब्रेतॉन" },
            { "bs", "बोस्नियन" },
            { "ca", "कातालान" },
            { "ce", "चेचेन" },
            { "ch", "कॅमोरो" },
            { "co", "कॉर्सिकन" },
            { "cr", "क्री" },
            { "cs", "झेक" },
            { "cu", "चर्च स्लाव्हिक" },
            { "cv", "चूवाश" },
            { "cy", "वेल्श" },
            { "da", "डॅनिश" },
            { "de", "जर्मन" },
            { "dv", "दिवेही" },
            { "dz", "झोंगखा" },
            { "ee", "एवे" },
            { "el", metaValue_el },
            { "en", "इंग्रजी" },
            { "eo", "एस्परान्टो" },
            { "es", "स्पॅनिश" },
            { "et", "इस्टोनियन" },
            { "eu", "बास्क" },
            { "fa", "फारसी" },
            { "ff", "फुलाह" },
            { "fi", "फिनिश" },
            { "fj", "फिजियन" },
            { "fo", "फरोइज" },
            { "fr", "फ्रेंच" },
            { "fy", "पश्चिमी फ्रिशियन" },
            { "ga", "आयरिश" },
            { "gd", "स्कॉटिश गेलिक" },
            { "gl", "गॅलिशियन" },
            { "gn", "गुआरनी" },
            { "gu", metaValue_gu },
            { "gv", "मांक्स" },
            { "ha", "हौसा" },
            { "he", metaValue_he },
            { "hi", "हिंदी" },
            { "ho", "हिरी मॉटू" },
            { "hr", "क्रोएशियन" },
            { "ht", "हैतीयन क्रेओल" },
            { "hu", "हंगेरियन" },
            { "hy", metaValue_hy },
            { "hz", "हरेरो" },
            { "ia", "इंटरलिंग्वा" },
            { "id", "इंडोनेशियन" },
            { "ie", "इंटरलिंग" },
            { "ig", "ईग्बो" },
            { "ii", "सिचुआन यी" },
            { "ik", "इनूपियाक" },
            { "io", "इडौ" },
            { "is", "आईसलँडिक" },
            { "it", "इटालियन" },
            { "iu", "इनुक्तीटुट" },
            { "ja", metaValue_ja },
            { "jv", "जावानीज" },
            { "ka", metaValue_ka },
            { "kg", "काँगो" },
            { "ki", "किकुयू" },
            { "kj", "क्वान्यामा" },
            { "kk", "कझाक" },
            { "kl", "कलाल्लिसत" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "कनुरी" },
            { "ks", "काश्मिरी" },
            { "ku", "कुरमंजी" },
            { "kv", "कोमी" },
            { "kw", "कोर्निश" },
            { "ky", "किरगीझ" },
            { "la", metaValue_la },
            { "lb", "लक्झेंबर्गिश" },
            { "lg", "गांडा" },
            { "li", "लिंबूर्गिश" },
            { "ln", "लिंगाला" },
            { "lo", metaValue_lo },
            { "lt", "लिथुआनियन" },
            { "lu", "ल्यूबा-कटांगा" },
            { "lv", "लात्व्हियन" },
            { "mg", "मलागसी" },
            { "mh", "मार्शलीज" },
            { "mi", "माओरी" },
            { "mk", "मॅसेडोनियन" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "मराठी" },
            { "ms", "मलय" },
            { "mt", "माल्टिज्" },
            { "my", "बर्मी" },
            { "na", "नउरू" },
            { "nb", "नॉर्वेजियन बोकमाल" },
            { "nd", "उत्तर देबेली" },
            { "ne", "नेपाळी" },
            { "ng", "डोंगा" },
            { "nl", "डच" },
            { "nn", "नॉर्वेजियन न्योर्स्क" },
            { "no", "नॉर्वेजियन" },
            { "nr", "दक्षिणात्य देबेली" },
            { "nv", "नावाजो" },
            { "ny", "न्यान्जा" },
            { "oc", "ऑक्सितान" },
            { "oj", "ओजिब्वा" },
            { "om", "ओरोमो" },
            { "or", metaValue_or },
            { "os", "ओस्सेटिक" },
            { "pa", "पंजाबी" },
            { "pi", "पाली" },
            { "pl", "पोलिश" },
            { "ps", "पश्तो" },
            { "pt", "पोर्तुगीज" },
            { "qu", "क्वेचुआ" },
            { "rm", "रोमान्श" },
            { "rn", "रुन्दी" },
            { "ro", "रोमानियन" },
            { "ru", "रशियन" },
            { "rw", "किन्यार्वान्डा" },
            { "sa", "संस्कृत" },
            { "sc", "सर्दिनियन" },
            { "sd", "सिंधी" },
            { "se", "उत्तरी सामी" },
            { "sg", "सांगो" },
            { "sh", "सर्बो-क्रोएशियन" },
            { "si", metaValue_si },
            { "sk", "स्लोव्हाक" },
            { "sl", "स्लोव्हेनियन" },
            { "sm", "सामोअन" },
            { "sn", "शोना" },
            { "so", "सोमाली" },
            { "sq", "अल्बानियन" },
            { "sr", "सर्बियन" },
            { "ss", "स्वाती" },
            { "st", "दक्षिणी सोथो" },
            { "su", "सुंदानीज" },
            { "sv", "स्वीडिश" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", "तेलगू" },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "तिग्रिन्या" },
            { "tk", "तुर्कमेन" },
            { "tl", metaValue_tl },
            { "tn", "त्स्वाना" },
            { "to", "टोंगन" },
            { "tr", "तुर्की" },
            { "ts", "सोंगा" },
            { "tt", "तातर" },
            { "tw", "ट्वी" },
            { "ty", "ताहितीयन" },
            { "ug", "उइगुर" },
            { "uk", "युक्रेनियन" },
            { "ur", "उर्दू" },
            { "uz", "उझ्बेक" },
            { "ve", "व्हेंदा" },
            { "vi", "व्हिएतनामी" },
            { "vo", "ओलापुक" },
            { "wa", "वालून" },
            { "wo", "वोलोफ" },
            { "xh", "खोसा" },
            { "yi", "यिद्दिश" },
            { "yo", "योरुबा" },
            { "za", "झुआंग" },
            { "zh", "चीनी" },
            { "zu", "झुलू" },
            { "ace", "अचीनी" },
            { "ach", "अकोली" },
            { "ada", "अडांग्मे" },
            { "ady", "अडिघे" },
            { "afh", "अफ्रिहिली" },
            { "agq", "अघेम" },
            { "ain", "ऐनू" },
            { "akk", "अक्केडियन" },
            { "ale", "अलेउत" },
            { "alt", "दक्षिणात्य अल्ताई" },
            { "ang", "पुरातन इंग्रजी" },
            { "ann", "ओबोलो" },
            { "anp", "अंगिका" },
            { "arc", "अ‍ॅरेमाइक" },
            { "arn", "मापुची" },
            { "arp", "आरापाहो" },
            { "ars", "नजदी अरबी" },
            { "arw", "आरावाक" },
            { "asa", "असु" },
            { "ast", "अस्तुरियन" },
            { "atj", "अटिकमेक" },
            { "awa", "अवधी" },
            { "bal", "बलुची" },
            { "ban", "बालिनीज" },
            { "bas", "बसा" },
            { "bej", "बेजा" },
            { "bem", "बेम्बा" },
            { "bez", "बेना" },
            { "bgc", "हरियाणवी" },
            { "bgn", "पश्चिमी बालोची" },
            { "bho", "भोजपुरी" },
            { "bik", "बिकोल" },
            { "bin", "बिनी" },
            { "bla", "सिक्सिका" },
            { "blo", "ॲनीआय" },
            { "bra", "ब्रज" },
            { "brx", "बोडो" },
            { "bua", "बुरियात" },
            { "bug", "बगिनीस" },
            { "byn", "ब्लिन" },
            { "cad", "कॅड्डो" },
            { "car", "कॅरिब" },
            { "cay", "केयुगा" },
            { "cch", "अत्सम" },
            { "ccp", "चाकमा" },
            { "ceb", "सिबुआनो" },
            { "cgg", "किगा" },
            { "chb", "चिब्चा" },
            { "chg", "छागाताइ" },
            { "chk", "चूकीसे" },
            { "chm", "मारी" },
            { "chn", "चिनूक जारगॉन" },
            { "cho", "चोक्तौ" },
            { "chp", "शिपेव्यान" },
            { "chr", metaValue_chr },
            { "chy", "शेयेन्न" },
            { "ckb", "मध्य कुर्दिश" },
            { "clc", "चिलकोटिन" },
            { "cop", metaValue_cop },
            { "crg", "मिचिफो" },
            { "crh", "क्राइमीन तुर्की" },
            { "crj", "दक्षिणात्य इस्ट क्री" },
            { "crk", "प्लेन्स क्री" },
            { "crl", "नॉर्दर्न ईस्ट क्री" },
            { "crm", "मूस क्री" },
            { "crr", "कॅरोलिना अल्गोंक्वियन" },
            { "crs", "सेसेल्वा क्रिओल फ्रेंच" },
            { "csb", "काशुबियन" },
            { "csw", "स्वॅम्पी क्री" },
            { "dak", "डाकोटा" },
            { "dar", "दार्गवा" },
            { "dav", "तायता" },
            { "del", "डेलावेयर" },
            { "den", "स्लाव्ह" },
            { "dgr", "डोग्रिब" },
            { "din", "डिन्का" },
            { "dje", "झार्मा" },
            { "doi", "डोगरी" },
            { "dsb", "लोअर सोर्बियन" },
            { "dua", "दुआला" },
            { "dum", "मिडल डच" },
            { "dyo", "जोला-फॉन्यी" },
            { "dyu", "ड्युला" },
            { "dzg", "दाझागा" },
            { "ebu", "एम्बू" },
            { "efi", "एफिक" },
            { "egy", "प्राचीन इजिप्शियन" },
            { "eka", "एकाजुक" },
            { "elx", "एलामाइट" },
            { "enm", "मिडल इंग्रजी" },
            { "ewo", "इवोन्डो" },
            { "fan", "फँग" },
            { "fat", "फन्टी" },
            { "fil", "फिलिपिनो" },
            { "fon", "फॉन" },
            { "frc", "केजॉन फ्रेंच" },
            { "frm", "मिडल फ्रेंच" },
            { "fro", "पुरातन फ्रेंच" },
            { "frr", "उत्तरी फ्रिशियन" },
            { "frs", "पौर्वात्य फ्रिशियन" },
            { "fur", "फ्रियुलियान" },
            { "gaa", "गा" },
            { "gag", "गागाउझ" },
            { "gan", "गॅन चिनी" },
            { "gay", "गायो" },
            { "gba", "बाया" },
            { "gez", "गीझ" },
            { "gil", "जिल्बरटीज" },
            { "gmh", "मिडल हाय जर्मन" },
            { "goh", "पुरातन हाइ जर्मन" },
            { "gon", "गाँडी" },
            { "gor", "गोरोन्तालो" },
            { "got", "गॉथिक" },
            { "grb", "ग्रेबो" },
            { "grc", "प्राचीन ग्रीक" },
            { "gsw", "स्विस जर्मन" },
            { "guz", "गसी" },
            { "gwi", "ग्विच’इन" },
            { "hai", "हैडा" },
            { "hak", "हाक्का चिनी" },
            { "haw", "हवाईयन" },
            { "hax", "दक्षिणात्य हैडा" },
            { "hil", "हिलीगेनॉन" },
            { "hit", "हिट्टिते" },
            { "hmn", "माँग" },
            { "hsb", "अप्पर सॉर्बियन" },
            { "hsn", "शियांग चिनी" },
            { "hup", "हूपा" },
            { "hur", "हॉल्कमेलम" },
            { "iba", "इबान" },
            { "ibb", "इबिबिओ" },
            { "ikt", "वेस्टर्न कॅनेडियन इनुकिटुट" },
            { "ilo", "इलोको" },
            { "inh", "इंगुश" },
            { "jbo", "लोज्बान" },
            { "jgo", "गोम्बा" },
            { "jmc", "मशामे" },
            { "jpr", "जुदेओ-फारसी" },
            { "jrb", "जुदेओ-अरबी" },
            { "kaa", "कारा-कल्पक" },
            { "kab", "कबाइल" },
            { "kac", "काचिन" },
            { "kaj", "ज्जु" },
            { "kam", "काम्बा" },
            { "kaw", "कावी" },
            { "kbd", "कबार्डियन" },
            { "kcg", "त्याप" },
            { "kde", "माकोन्दे" },
            { "kea", "काबवर्दियानु" },
            { "kfo", "कोरो" },
            { "kgp", "काइंगांग" },
            { "kha", "खासी" },
            { "kho", "खोतानीस" },
            { "khq", "कोयरा चीनी" },
            { "kkj", "काको" },
            { "kln", "कालेंजीन" },
            { "kmb", "किम्बन्दु" },
            { "koi", "कोमी-परम्याक" },
            { "kok", "कोंकणी" },
            { "kos", "कोसरियन" },
            { "kpe", "क्पेल्ले" },
            { "krc", "कराचय-बाल्कर" },
            { "krl", "करेलियन" },
            { "kru", "कुरूख" },
            { "ksb", "शांबाला" },
            { "ksf", "बाफिया" },
            { "ksh", "कोलोग्नियन" },
            { "kum", "कुमीक" },
            { "kut", "कुतेनाई" },
            { "kwk", "क्वक्क्वाला" },
            { "kxv", "कुवी" },
            { "lad", "लादीनो" },
            { "lag", "लांगी" },
            { "lah", "लाह्न्डा" },
            { "lam", "लाम्बा" },
            { "lez", "लेझ्घीयन" },
            { "lij", "लिगुरिअन" },
            { "lil", "लिलूएट" },
            { "lkt", "लाकोटा" },
            { "lmo", "लोंबार्ड" },
            { "lol", "मोंगो" },
            { "lou", "ल्युसियाना क्रिओल" },
            { "loz", "लोझि" },
            { "lrc", "उत्तरी ल्युरी" },
            { "lsm", "सामिया" },
            { "lua", "लुबा-लुलुआ" },
            { "lui", "लुइसेनो" },
            { "lun", "लुन्डा" },
            { "luo", "ल्युओ" },
            { "lus", "मिझो" },
            { "luy", "ल्युइया" },
            { "mad", "मादुरीस" },
            { "mag", "मगही" },
            { "mai", "मैथिली" },
            { "mak", "मकस्सर" },
            { "man", "मन्डिन्गो" },
            { "mas", "मसाई" },
            { "mdf", "मोक्ष" },
            { "mdr", "मंडार" },
            { "men", "मेन्डे" },
            { "mer", "मेरू" },
            { "mfe", "मोरिस्येन" },
            { "mga", "मिडल आयरिश" },
            { "mgh", "माखुव्हा-मीट्टो" },
            { "mgo", "मीटा" },
            { "mic", "मिकमॅक" },
            { "min", "मिनांग्काबाउ" },
            { "mnc", "मान्चु" },
            { "mni", "मणिपुरी" },
            { "moe", "इन्नू-ॲमन" },
            { "moh", "मोहॉक" },
            { "mos", "मोस्सी" },
            { "mua", "मुंडांग" },
            { "mul", "एकाधिक भाषा" },
            { "mus", "क्रीक" },
            { "mwl", "मिरांडिज्" },
            { "mwr", "मारवाडी" },
            { "myv", "एर्झ्या" },
            { "mzn", "माझानदेरानी" },
            { "nan", "मिन नान चिनी" },
            { "nap", "नेपोलिटान" },
            { "naq", "नामा" },
            { "nds", "लो जर्मन" },
            { "new", "नेवारी" },
            { "nia", "नियास" },
            { "niu", "नियुआन" },
            { "nmg", "क्वासिओ" },
            { "nnh", "जिएम्बून" },
            { "nog", "नोगाई" },
            { "non", "पुरातन नॉर्स" },
            { "nqo", "एन्को" },
            { "nso", "उत्तरी सोथो" },
            { "nus", "नुएर" },
            { "nwc", "अभिजात नेवारी" },
            { "nym", "न्यामवेझी" },
            { "nyn", "न्यानकोल" },
            { "nyo", "न्योरो" },
            { "nzi", "न्झिमा" },
            { "ojb", "नॉर्थवेस्टर्न ओजिब्वा" },
            { "ojc", "सेंट्रल ओजिब्वा" },
            { "ojs", "ओजी-क्री" },
            { "ojw", "वेस्टर्न ओजिबवा" },
            { "oka", "ओकनागन" },
            { "osa", "ओसेज" },
            { "ota", "ओटोमान तुर्किश" },
            { "pag", "पंगासीनान" },
            { "pal", "पहलवी" },
            { "pam", "पाम्पान्गा" },
            { "pap", "पापियामेन्टो" },
            { "pau", "पालाउआन" },
            { "pcm", "नायजिरिअन पिजिन" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "पिजिन" },
            { "pon", "पोह्नपियन" },
            { "pqm", "मालीसेट-पासामाक्वाड्डी" },
            { "prg", "प्रुशियन" },
            { "pro", "पुरातन प्रोव्हेन्सल" },
            { "quc", "कीशेइ" },
            { "raj", "राजस्थानी" },
            { "rap", "रापानुई" },
            { "rar", "रारोटोंगन" },
            { "rhg", "रोहिंग्या" },
            { "rof", "रोम्बो" },
            { "rom", "रोमानी" },
            { "rup", "अरोमानियन" },
            { "rwk", "रव्हा" },
            { "sad", "सँडवे" },
            { "sah", "साखा" },
            { "sam", "सामरिटान अरॅमिक" },
            { "saq", "सांबुरू" },
            { "sas", "सासाक" },
            { "sat", "संताली" },
            { "sba", "गाम्बे" },
            { "sbp", "सांगु" },
            { "scn", "सिसिलियन" },
            { "sco", "स्कॉट्स" },
            { "sdh", "दक्षिणी कुर्दिश" },
            { "seh", "सेना" },
            { "sel", "सेल्कप" },
            { "ses", "कोयराबोरो सेन्नी" },
            { "sga", "पुरातन आयरिश" },
            { "shi", "ताशेल्हिट" },
            { "shn", "शॅन" },
            { "sid", "सिदामो" },
            { "slh", "दक्षिणात्य लुशूटसीड" },
            { "sma", "दक्षिणात्य सामी" },
            { "smj", "ल्युल सामी" },
            { "smn", "इनारी सामी" },
            { "sms", "स्कोल्ट सामी" },
            { "snk", "सोनिन्के" },
            { "sog", "सोग्डिएन" },
            { "srn", "स्रानान टॉन्गो" },
            { "srr", "सेरेर" },
            { "ssy", "साहो" },
            { "str", "स्ट्राइट्स सालीश" },
            { "suk", "सुकुमा" },
            { "sus", "सुसु" },
            { "sux", "सुमेरियन" },
            { "swb", "कोमोरियन" },
            { "syc", "अभिजात सिरियाक" },
            { "syr", "सिरियाक" },
            { "szl", "सिलेशियन" },
            { "tce", "दक्षिणात्य टचोन" },
            { "tem", "टिम्ने" },
            { "teo", "तेसो" },
            { "ter", "तेरेनो" },
            { "tet", "तेतुम" },
            { "tgx", "टॅगिश" },
            { "tht", "तहल्टन" },
            { "tig", "टाइग्रे" },
            { "tiv", "तिव" },
            { "tkl", "टोकेलाऊ" },
            { "tlh", "क्लिंगॉन" },
            { "tli", "लिंगित" },
            { "tmh", "तामाशेक" },
            { "tog", "न्यासा टोन्गा" },
            { "tok", "टोकि पोना" },
            { "tpi", "टोक पिसिन" },
            { "trv", "तारोको" },
            { "tsi", "सिम्शियन" },
            { "ttm", "नॉर्दर्न टचोन" },
            { "tum", "तुम्बुका" },
            { "tvl", metaValue_TV },
            { "twq", "तासाव्हाक" },
            { "tyv", "टुवीनियन" },
            { "tzm", "मध्य अ‍ॅटलास तॅमाझाइट" },
            { "udm", "उदमुर्त" },
            { "uga", "युगॅरिटिक" },
            { "umb", "उम्बुन्डु" },
            { "und", "अज्ञात भाषा" },
            { "vai", metaValue_vai },
            { "vec", "व्हेनेशियन" },
            { "vmw", "मखुवा" },
            { "vot", "वॉटिक" },
            { "vun", "वुंजो" },
            { "wae", "वालसेर" },
            { "wal", "वोलायता" },
            { "war", "वारे" },
            { "was", "वाशो" },
            { "wbp", "वार्लपिरी" },
            { "wuu", "व्हू चिनी" },
            { "xal", "काल्मिक" },
            { "xnr", "कांगरी" },
            { "xog", "सोगा" },
            { "yao", "याओ" },
            { "yap", "यापीस" },
            { "yav", "यांगबेन" },
            { "ybb", "येमबा" },
            { "yrl", "न्हेंगाटू" },
            { "yue", "कँटोनीज" },
            { "zap", "झेपोटेक" },
            { "zbl", metaValue_zbl },
            { "zen", "झेनान्गा" },
            { "zgh", "प्रमाण मोरोक्कन तॅमॅझायट" },
            { "zun", "झुनी" },
            { "zxx", "भाषावैज्ञानिक सामग्री नाही" },
            { "zza", "झाझा" },
            { "Adlm", "अदलम" },
            { "Arab", metaValue_ar },
            { "Aran", "नस्तालीक" },
            { "Armi", "इम्पिरियल आर्मेनिक" },
            { "Armn", metaValue_hy },
            { "Avst", "अवेस्तान" },
            { "Bali", "बाली" },
            { "Batk", "बटाक" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "बोपोमोफो" },
            { "Brah", "ब्रह्मी" },
            { "Brai", "ब्रेल" },
            { "Bugi", "बूगी" },
            { "Buhd", "बुहिद" },
            { "Cakm", "चकमा" },
            { "Cans", "यूनिफाइड कॅनेडियन अ‍ॅबोरिजनल सिलॅबिक्स" },
            { "Cari", "कॅरियन" },
            { "Cham", "चाम" },
            { "Cher", metaValue_chr },
            { "Cirt", "किर्थ" },
            { "Copt", metaValue_cop },
            { "Cprt", "सायप्रिऑट" },
            { "Cyrl", "सीरिलिक" },
            { "Cyrs", "पुरातन चर्च स्लाव्होनिक सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Dsrt", "डेसर्ट" },
            { "Egyd", "इजिप्शियन डेमोटिक" },
            { "Egyh", "इजिप्शियन हायरेटिक" },
            { "Egyp", "इजिप्शियन हायरोग्लिफ्स" },
            { "Ethi", "ईथिओपिक" },
            { "Geok", "जॉर्जियन खुत्सुरी" },
            { "Geor", metaValue_ka },
            { "Glag", "ग्लॅगोलिटिक" },
            { "Goth", "गोथिक" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरुमुखी" },
            { "Hanb", "बोपोमोफोसह हान" },
            { "Hang", "हंगुल" },
            { "Hani", "हान" },
            { "Hano", "हनुनू" },
            { "Hans", "सरलीकृत" },
            { "Hant", "पारंपारिक" },
            { "Hebr", metaValue_he },
            { "Hira", "हिरागाना" },
            { "Hmng", "पहाउ मंग" },
            { "Hrkt", "जापानी स्वरलिपी" },
            { "Hung", "पुरातन हंगेरियन" },
            { "Inds", "सिन्धु" },
            { "Ital", "जुनी इटालिक" },
            { "Jamo", "जामो" },
            { "Java", "जावानीस" },
            { "Jpan", metaValue_ja },
            { "Kali", "कायाह ली" },
            { "Kana", "कॅटाकाना" },
            { "Khar", "खारोश्थी" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "काइथी" },
            { "Lana", "लाना" },
            { "Laoo", metaValue_lo },
            { "Latf", "फ्रॅक्तुर लॅटिन" },
            { "Latg", "गाएलिक लेटिन" },
            { "Latn", metaValue_la },
            { "Lepc", "लेपचा" },
            { "Limb", "लिम्बू" },
            { "Lina", "लीनियार अ" },
            { "Linb", "लीनियर बी" },
            { "Lyci", "लायशियान" },
            { "Lydi", "लायडियान" },
            { "Mand", "मान्डायीन" },
            { "Mani", "मानीचायीन" },
            { "Maya", "मायान हाइरोग्लिफ्स" },
            { "Mero", "मेरोइटिक" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "मून" },
            { "Mtei", "मेइतेइ मायेक" },
            { "Mymr", "म्यानमार" },
            { "Nkoo", "एन्‘को" },
            { "Ogam", "ओघाम" },
            { "Olck", "ओल चिकि" },
            { "Orkh", "ओर्खोन" },
            { "Orya", metaValue_or },
            { "Osma", "उस्मानिया" },
            { "Perm", "पुरातन पर्मिक" },
            { "Phag", "फाग्स-पा" },
            { "Phli", "इन्स्क्रिप्शनल पाहलवी" },
            { "Phlp", "सॉल्टर पाहलवी" },
            { "Phlv", "बुक पाहलवी" },
            { "Phnx", metaValue_phn },
            { "Plrd", "पोलार्ड फोनेटिक" },
            { "Prti", "इन्स्क्रिप्शनल पर्थियन" },
            { "Rjng", "रीजांग" },
            { "Rohg", "हनीफी" },
            { "Roro", "रोन्गोरोन्गो" },
            { "Runr", "रूनिक" },
            { "Samr", "समरिटान" },
            { "Sara", "सराती" },
            { "Saur", "सौराष्ट्र" },
            { "Sgnw", "संकेत लिपी" },
            { "Shaw", "शॅव्हियन" },
            { "Sinh", metaValue_si },
            { "Sund", "सूदानी" },
            { "Sylo", "सिलोती नागरी" },
            { "Syrc", "सिरीयाक" },
            { "Syre", "एस्त्ट्रेन्जेलो सिरियाक" },
            { "Syrj", "पश्चिमी सिरियाक" },
            { "Syrn", "पूर्वी सिरियाक" },
            { "Tagb", "तगोआन्वा" },
            { "Tale", "ताई ली" },
            { "Talu", "नवीन ताई लू" },
            { "Taml", metaValue_ta },
            { "Tavt", "ताई विएत" },
            { "Telu", "तेलगु" },
            { "Teng", "तेन्गवार" },
            { "Tfng", "तिफिनाघ" },
            { "Tglg", metaValue_tl },
            { "Thaa", "थाना" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "युगारिटिक" },
            { "Vaii", metaValue_vai },
            { "Visp", "दृश्य संवाद" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "दृश्यमान भाषा" },
            { "Yiii", "यी" },
            { "Zinh", "वंशपरंपरागत" },
            { "Zmth", "गणितीय संकेतलिपी" },
            { "Zsye", "इमोजी" },
            { "Zsym", "प्रतीक" },
            { "Zxxx", "अलिखित" },
            { "Zyyy", "सामान्य" },
            { "Zzzz", "अज्ञात लिपी" },
            { "de_AT", "ऑस्ट्रियन जर्मन" },
            { "de_CH", "स्विस हाय जर्मन" },
            { "en_AU", "ऑस्ट्रेलियन इंग्रजी" },
            { "en_CA", "कॅनडियन इंग्रजी" },
            { "en_GB", "ब्रिटिश इंग्रजी" },
            { "en_US", "अमेरिकन इंग्रजी" },
            { "es_ES", "युरोपियन स्पॅनिश" },
            { "es_MX", "मेक्सिकन स्पॅनिश" },
            { "fa_AF", "दारी" },
            { "fr_CA", "कॅनडियन फ्रेंच" },
            { "fr_CH", "स्विस फ्रेंच" },
            { "nl_BE", "फ्लेमिश" },
            { "pt_BR", "ब्राझिलियन पोर्तुगीज" },
            { "pt_PT", "युरोपियन पोर्तुगीज" },
            { "ro_MD", "मोल्डाव्हियन" },
            { "sw_CD", "काँगो स्वाहिली" },
            { "ar_001", "आधुनिक प्रमाणित अरबी" },
            { "es_419", "लॅटिन अमेरिकन स्पॅनिश" },
            { "key.ca", "दिनदर्शिका" },
            { "key.cf", "चलन स्वरूप" },
            { "key.co", "वर्गवारी क्रम" },
            { "key.cu", "चलन" },
            { "key.em", "इमोजी सादरीकरण" },
            { "key.hc", "तास चक्र (12 वि 24)" },
            { "key.lb", "लाइन ब्रेक स्ट्रिक्टनेस" },
            { "key.lw", "शब्दांमधील लाईन ब्रेक" },
            { "key.ms", "मापन पद्धती" },
            { "key.nu", "संख्या" },
            { "key.ss", "संक्षिप्त रूपानंतर वाक्य खंड" },
            { "key.tz", "टाइम झोन" },
            { "key.va", "लोकेल व्हेरियंट" },
            { "nds_NL", "लो सॅक्सन" },
            { "zh_Hans", "सरलीकृत चीनी" },
            { "zh_Hant", "पारंपारिक चीनी" },
            { "%%PINYIN", "पिनयिन रोमनायझेशन" },
            { "%%WADEGILE", "वादे-गिलेस रोमनायझेशन" },
            { "type.ca.roc", "मिनगुओ वर्ष" },
            { "type.co.eor", "युरोपियन क्रमवारी नियम" },
            { "type.hc.h11", "12 तास पद्धती (0–11)" },
            { "type.hc.h12", "12 तास पद्धती (1–12)" },
            { "type.hc.h23", "24 तास पद्धती (0–23)" },
            { "type.hc.h24", "24 तास पद्धती (1–24)" },
            { "type.m0.bgn", "यूएस बीजीएन लिप्यंतरण" },
            { "type.nu.arab", "अरबी-भारतीय अंक" },
            { "type.nu.armn", "अर्मेनियन अंक" },
            { "type.nu.beng", "बंगाली अंक" },
            { "type.nu.cakm", "चकमा अंक" },
            { "type.nu.deva", "देवनागरी अंक" },
            { "type.nu.ethi", "इथिओपिक अंक" },
            { "type.nu.geor", "जॉर्जियन अंक" },
            { "type.nu.grek", "ग्रीक अंक" },
            { "type.nu.gujr", "गुजराती अंक" },
            { "type.nu.guru", "गुरमुखी अंक" },
            { "type.nu.hans", "सरलीकृत चीनी अंक" },
            { "type.nu.hant", "पारंपारिक चीनी अंक" },
            { "type.nu.hebr", "हिब्रू अंक" },
            { "type.nu.java", "जावानीज अंक" },
            { "type.nu.jpan", "जपानी अंक" },
            { "type.nu.khmr", "ख्मेर अंक" },
            { "type.nu.knda", "कन्नड अंक" },
            { "type.nu.laoo", "लाओ अंक" },
            { "type.nu.latn", "पश्चिमी अंक" },
            { "type.nu.mlym", "मल्याळम अंक" },
            { "type.nu.mong", "मंगोलियन अंक" },
            { "type.nu.mtei", "मीतेई मायेक अंक" },
            { "type.nu.mymr", "म्यानमार अंक" },
            { "type.nu.olck", "ओलचिकी अंक" },
            { "type.nu.orya", "उडिया अंक" },
            { "type.nu.taml", "पारंपरिक तामिळ अंक" },
            { "type.nu.telu", "तेलगु अंक" },
            { "type.nu.thai", "थाई अंक" },
            { "type.nu.tibt", "तिबेटी अंक" },
            { "type.nu.vaii", "व्हाई अंक" },
            { "type.ca.dangi", "डांगी दिनदर्शिका" },
            { "type.co.ducet", "डीफॉल्ट युनिकोड क्रमवारी क्रम" },
            { "type.lb.loose", "लूज लाइन ब्रेक स्टाइल" },
            { "type.nu.roman", "रोमन अंक" },
            { "type.ca.coptic", "कॉप्टिक दिनदर्शिका" },
            { "type.ca.hebrew", "यहूदी दिनदर्शिका" },
            { "type.ca.indian", "भारतीय राष्ट्रीय दिनदर्शिका" },
            { "type.co.compat", "अनुकूलतेसाठी आधीची क्रमवारी" },
            { "type.co.pinyin", "पिनयिन अनुक्रम" },
            { "type.co.search", "सामान्य हेतू शोध" },
            { "type.co.stroke", "स्ट्रोक अनुक्रम" },
            { "type.co.unihan", "रॅडिकल-स्ट्रोक अनुक्रम" },
            { "type.d0.fwidth", "पूर्णरुंदी" },
            { "type.d0.hwidth", "अर्धीरुंदी" },
            { "type.lb.normal", "नॉर्मल लाइन ब्रेक स्टाइल" },
            { "type.lb.strict", "स्ट्रिक्ट लाइन ब्रेक स्टाइल" },
            { "type.m0.ungegn", "यूएन जीईजीएन लिप्यंतरण" },
            { "type.ms.metric", "दशमान पद्धती" },
            { "type.nu.native", "मूळ अंक" },
            { "type.ca.chinese", "चीनी दिनदर्शिका" },
            { "type.ca.islamic", "हिजरी दिनदर्शिका" },
            { "type.ca.iso8601", "ग्रेगोरियन दिनदर्शिका (प्रथम वर्ष)" },
            { "type.ca.persian", "फारसी दिनदर्शिका" },
            { "type.cf.account", "अकाउंटिंग चलन स्वरूप" },
            { "type.d0.npinyin", "अंकीय" },
            { "type.nu.arabext", "विस्तारित अरबी-भारतीय अंक" },
            { "type.nu.armnlow", "अर्मेनियन लोअरकेस अंक" },
            { "type.nu.finance", "वित्तीय संख्‍या" },
            { "type.nu.greklow", "ग्रीक लहान लिपीचे अंक" },
            { "type.nu.hanidec", "चीनी दशांश अंक" },
            { "type.nu.hansfin", "सरलीकृत चीनी वित्तीय अंक" },
            { "type.nu.hantfin", "पारंपारिक चीनी वित्तीय अंक" },
            { "type.nu.jpanfin", "जपानी वित्तीय अंक" },
            { "type.nu.tamldec", "तामिळ अंक" },
            { "type.ca.buddhist", "बौद्ध दिनदर्शिका" },
            { "type.ca.ethiopic", "इथिओपिक दिनदर्शिका" },
            { "type.ca.japanese", "जपानी दिनदर्शिका" },
            { "type.cf.standard", "प्रमाणित चलन स्वरूप" },
            { "type.co.phonetic", "ध्वनीविचार क्रमवारी क्रम" },
            { "type.co.searchjl", "हँगुल प्रारंभिक व्यंजनानुसार शोधा" },
            { "type.co.standard", "प्रमाणित क्रमवारी क्रम" },
            { "type.ms.uksystem", "ब्रिटिश मापन पद्धती" },
            { "type.ms.ussystem", "अमेरिकन मापन पद्धती" },
            { "type.nu.fullwide", "पूर्ण रुंदीचे अंक" },
            { "type.nu.romanlow", "रोमन लोअरकेस अंक" },
            { "type.ca.gregorian", "ग्रेगोरियन दिनदर्शिका" },
            { "type.co.phonebook", "फोनबुक अनुक्रम" },
            { "type.co.dictionary", "शब्दकोश अनुक्रम" },
            { "type.co.traditional", "पारंपारिक अनुक्रम" },
            { "type.nu.traditional", "पारंपारिक संख्‍या" },
            { "type.ca.islamic-civil", "हिजरी दिनदर्शिका (टॅब्युलर, सिव्हील ईपॉक्)" },
            { "type.ca.islamic-umalqura", "हिजरी दिनदर्शिका (उम-अल-कुरा)" },
            { "type.ca.ethiopic-amete-alem", "इथियोपिक अमेते अलेम दिनदर्शिका" },
        };
        return data;
    }
}
