/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_rm extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "temp dal meridian da Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "temp normal da la Samoa",
               "",
               "temp da stad da la Samoa",
               "",
               "temp da la Samoa",
               "",
            };
        final String[] Cook = new String[] {
               "temp normal da las Inslas Cook",
               "",
               "temp da stad da las Inslas Cook",
               "",
               "temp da las Inslas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "temp normal da la Cuba",
               "CST",
               "temp da stad da la Cuba",
               "CDT",
               "temp da la Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "temp normal dal Fidschi",
               "",
               "temp da stad dal Fidschi",
               "",
               "temp dal Fidschi",
               "",
            };
        final String[] Gulf = new String[] {
               "temp normal dal Golf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "temp normal da Hovd",
               "",
               "temp da stad da Hovd",
               "",
               "temp da Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "temp normal da l’Iran",
               "",
               "temp da stad da l’Iran",
               "",
               "temp da l’Iran",
               "",
            };
        final String[] Niue = new String[] {
               "temp da Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "temp normal dad Omsk",
               "",
               "temp da stad dad Omsk",
               "",
               "temp dad Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "temp normal dal Peru",
               "",
               "temp da stad dal Peru",
               "",
               "temp dal Peru",
               "",
            };
        final String[] Truk = new String[] {
               "temp da Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "temp da l’Insla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "temp normal dal Chile",
               "",
               "temp da stad dal Chile",
               "",
               "temp dal Chile",
               "",
            };
        final String[] China = new String[] {
               "temp normal da la China",
               "CST",
               "temp da stad da la China",
               "CDT",
               "temp da la China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "temp da las Inslas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "temp da Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "temp normal da l’India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "temp normal dal Giapun",
               "JST",
               "temp da stad dal Giapun",
               "JDT",
               "temp dal Giapun",
               "JT",
            };
        final String[] Korea = new String[] {
               "temp normal da la Corea",
               "KST",
               "temp da stad da la Corea",
               "KST",
               "temp da la Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "temp da Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "temp dal Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "temp da Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "temp normal da la Samoa Americana",
               "SST",
               "temp da stad da la Samoa Americana",
               "SST",
               "temp da la Samoa Americana",
               "SST",
            };
        final String[] Syowa = new String[] {
               "temp da Shōwa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "temp normal da Tonga",
               "",
               "temp da stad da Tonga",
               "",
               "temp da Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "temp dal Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "temp normal da l’Alasca",
               "AKST",
               "temp da stad da l’Alasca",
               "AKDT",
               "temp da l’Alasca",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "temp normal da l’Amazonas",
               "",
               "temp da stad da l’Amazonas",
               "",
               "temp da l’Amazonas",
               "",
            };
        final String[] Azores = new String[] {
               "temp normal da las Azoras",
               "",
               "temp da stad da las Azoras",
               "",
               "temp da las Azoras",
               "",
            };
        final String[] Bhutan = new String[] {
               "temp dal Butan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "temp dal Brunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "temp normal da l’Insla da Pasca",
               "",
               "temp da stad da l’Insla da Pasca",
               "",
               "temp da l’Insla da Pasca",
               "",
            };
        final String[] Guyana = new String[] {
               "temp da la Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "temp normal dal Hawai e las Aleutinas",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "temp normal da l’Israel",
               "IST",
               "temp da stad da l’Israel",
               "IDT",
               "temp da l’Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "temp da Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "temp da Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "temp normal da Moscau",
               "MSK",
               "temp da stad da Moscau",
               "MSK",
               "temp da Moscau",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "temp da Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "temp da Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "temp normal dal Taiwan",
               "CST",
               "temp da stad dal Taiwan",
               "CDT",
               "temp dal Taiwan",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "temp da las Inslas da Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "temp da Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "temp da Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "temp normal arab",
               "",
               "temp da stad arab",
               "",
               "temp arab",
               "",
            };
        final String[] Armenia = new String[] {
               "temp normal da l’Armenia",
               "",
               "temp da stad da l’Armenia",
               "",
               "temp da l’Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "temp da la Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "temp normal da las Inslas Chatham",
               "",
               "temp da stad da las Inslas Chatham",
               "",
               "temp da las Inslas Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "temp universal coordinà",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "temp da l’Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "temp da las Inslas Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "temp normal da la Georgia",
               "",
               "temp da stad da la Georgia",
               "",
               "temp da la Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "temp normal dad Irkutsk",
               "",
               "temp da stad dad Irkutsk",
               "",
               "temp dad Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "temp normal da Magadan",
               "",
               "temp da stad da Magadan",
               "",
               "temp da Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "temp dal Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "temp normal da l’Insla Norfolk",
               "",
               "temp da stad da l’Insla Norfolk",
               "",
               "temp da l’Insla Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "temp normal da Fernando de Noronha",
               "",
               "temp da stad da Fernando de Noronha",
               "",
               "temp da Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "temp da la Réunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "temp da Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "temp da las Inslas da Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "temp da Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "temp normal da l’Uruguai",
               "",
               "temp da stad da l’Uruguai",
               "",
               "temp da l’Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "temp normal dal Vanuatu",
               "",
               "temp da stad dal Vanuatu",
               "",
               "temp dal Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "temp normal da Jakutsk",
               "",
               "temp da stad da Jakutsk",
               "",
               "temp da Jakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "temp normal da l’Atlantic USA",
               "AST",
               "temp da stad da l’Atlantic USA",
               "AST",
               "temp da l’Atlantic USA",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "temp normal da la Brasilia",
               "",
               "temp da stad da la Brasilia",
               "",
               "temp da la Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "temp dals Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "temp normal da la Columbia",
               "",
               "temp da stad da la Columbia",
               "",
               "temp da la Columbia",
               "",
            };
        final String[] Falkland = new String[] {
               "temp normal da las Inslas Falkland",
               "",
               "temp da stad da las Inslas Falkland",
               "",
               "temp da las Inslas Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "temp da la Malaisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "temp da las Maledivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "temp normal dad Ulaanbaatar",
               "",
               "temp da stad dad Ulaanbaatar",
               "",
               "temp dad Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "temp normal dal Pakistan",
               "PKT",
               "temp da stad dal Pakistan",
               "PKST",
               "temp dal Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "temp normal dal Paraguai",
               "",
               "temp da stad dal Paraguai",
               "",
               "temp dal Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "temp da las Inslas Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "temp dal Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "temp normal da l’Argentina",
               "",
               "temp da stad da l’Argentina",
               "",
               "temp da l’Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "temp da l’Insla da Nadal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "temp da las Inslas Galápagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "temp normal dal Hongkong",
               "HKT",
               "temp da stad dal Hongkong",
               "HKST",
               "temp dal Hongkong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "temp da l’Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "temp dal Kirghistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "temp normal da Lord Howe",
               "",
               "temp da stad da Lord Howe",
               "",
               "temp da Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "temp da las Inslas Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "temp normal dal Mauritius",
               "",
               "temp da stad dal Mauritius",
               "",
               "temp dal Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "temp normal dal Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "temp da la Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "temp normal da l’Aserbaidschan",
               "",
               "temp da stad da l’Aserbaidschan",
               "",
               "temp da l’Aserbaidschan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "temp normal dal Bangladesch",
               "",
               "temp da stad dal Bangladesch",
               "",
               "temp dal Bangladesch",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "temp normal dal Cap Verd",
               "",
               "temp da stad dal Cap Verd",
               "",
               "temp dal Cap Verd",
               "",
            };
        final String[] East_Timor = new String[] {
               "temp dal Timor da l’Ost",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "temp dal Kasachstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "temp da las Seychellas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "temp dal Tadschikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "temp normal da l’Usbekistan",
               "",
               "temp da stad da l’Usbekistan",
               "",
               "temp da l’Usbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "temp da l’Afganistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "temp normal da Krasnojarsk",
               "",
               "temp da stad da Krasnojarsk",
               "",
               "temp da Krasnojarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "temp normal da la Nova Zelanda",
               "NZST",
               "temp da stad da la Nova Zelanda",
               "NZDT",
               "temp da la Nova Zelanda",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "temp normal da las Filippinas",
               "PST",
               "temp da stad da las Filippinas",
               "PDT",
               "temp da las Filippinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "temp normal da Vladivostok",
               "",
               "temp da stad da Vladivostok",
               "",
               "temp da Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "temp da l’Ocean Indic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "temp da las Inslas da la Lingia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "temp normal da la Terranova",
               "NST",
               "temp da stad da la Terranova",
               "NDT",
               "temp da la Terranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "temp normal dal Turkmenistan",
               "",
               "temp da stad dal Turkmenistan",
               "",
               "temp dal Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "temp da la Guyana Franzosa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "temp normal da la Nova Caledonia",
               "",
               "temp da stad da la Nova Caledonia",
               "",
               "temp da la Nova Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "temp da la Georgia dal Sid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "temp normal da Jekaterinburg",
               "",
               "temp da stad da Jekaterinburg",
               "",
               "temp da Jekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "temp da l’Africa Centrala",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "temp da l’Africa Orientala",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "temp da l’Africa Occidentala",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "temp da Dumont d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "temp normal da l’Europa Centrala",
               "CET",
               "temp da stad da l’Europa Centrala",
               "CEST",
               "temp da l’Europa Centrala",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "temp normal da l’Europa Orientala",
               "EET",
               "temp da stad da l’Europa Orientala",
               "EEST",
               "temp da l’Europa Orientala",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "temp normal da l’Europa dal Vest",
               "WET",
               "temp da stad da l’Europa dal Vest",
               "WEST",
               "temp da l’Europa dal Vest",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "temp normal mexican dal Pacific",
               "MST",
               "temp da stad mexican dal Pacific",
               "MDT",
               "temp mexican dal Pacific",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "temp normal da l’Africa Meridiunala",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "temp normal dal center USA",
               "CST",
               "temp da stad dal center USA",
               "CDT",
               "temp dal center USA",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "temp normal da l’ost USA",
               "EST",
               "temp da stad da l’ost USA",
               "EST",
               "temp da l’ost USA",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "temp normal dal Pacific USA",
               "PST",
               "temp da stad dal Pacific USA",
               "PDT",
               "temp dal Pacific USA",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "temp dals Territoris Franzos Meridiunals ed Antarctics",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "temp da las Inslas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "temp normal dal Hawai e las Aleutinas",
               "HST",
               "temp da stad dal Hawai e da las Aleutinas",
               "HDT",
               "temp dal Hawai e las Aleutinas",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "temp da las Inslas Fenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "temp normal da Saint Pierre e Miquelon",
               "",
               "temp da stad da Saint Pierre e Miquelon",
               "",
               "temp da Saint Pierre e Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "temp normal dals Rocky Mountains",
               "MST",
               "temp da stad dals Rocky Mountains",
               "MST",
               "temp dals Rocky Mountains",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "temp da las Inslas da Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "temp da la Papua Nova Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "temp normal dal center da l’Australia",
               "ACST",
               "temp da stad dal center da l’Australia",
               "ACDT",
               "temp dal center da l’Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "temp normal da l’ost da l’Australia",
               "AEST",
               "temp da stad da l’ost da l’Australia",
               "AEDT",
               "temp da l’ost da l’Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "temp normal dal vest da l’Australia",
               "AWST",
               "temp da stad dal vest da l’Australia",
               "AWDT",
               "temp dal vest da l’Australia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "temp dal center da l’Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "temp da l’ost da l’Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "temp dal vest da l’Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "temp normal dal center-vest da l’Australia",
               "",
               "temp da stad dal center-vest da l’Australia",
               "",
               "temp dal center-vest da l’Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "temp universal coordinà",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da l’Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "temp universal coordinà",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "temp universal coordinà",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "temp universal coordinà",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "temp universal coordinà",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "temp universal coordinà",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da l’Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "temp dal meridian da Greenwich",
                    "GMT",
                    "temp da stad da la Gronda Britannia",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Chita", "Tschita" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Muscat", "Mascat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Citad da Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "lieu nunenconuschent" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bischkek" },
            { "timezone.excity.Asia/Karachi", "Karatschi" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Indian/Cocos", "Inslas Cocos" },
            { "timezone.excity.Pacific/Fiji", "Fidschi" },
            { "timezone.excity.Asia/Ashgabat", "Aşgabat" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "timezone.excity.Asia/Dushanbe", "Duschanbe" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Qostanay", "Qostanai" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Shanghai", "Schanghai" },
            { "timezone.excity.Asia/Tashkent", "Taschkent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Moscow", "Moscau" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zurich", "Turitg" },
            { "timezone.excity.Indian/Comoro", "Comoras" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algier" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Cayman", "Inslas Cayman" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamtschatka" },
            { "timezone.excity.Asia/Pyongyang", "Pjöngjang" },
            { "timezone.excity.Asia/Qyzylorda", "Qysylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Pacific/Easter", "Insla da Pasca" },
            { "timezone.excity.Africa/Djibouti", "Dschibuti" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.America/Jamaica", "Giamaica" },
            { "timezone.excity.Atlantic/Azores", "Azoras" },
            { "timezone.excity.Atlantic/Canary", "Inslas Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Inslas Feroe" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brüssel" },
            { "timezone.excity.Indian/Maldives", "Maledivas" },
            { "timezone.excity.Pacific/Norfolk", "Insla Norfolk" },
            { "timezone.excity.Africa/Mogadishu", "Mogadischu" },
            { "timezone.excity.America/Miquelon", "Saint Pierre" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Sontga Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Europe/Astrakhan", "Astrachan" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Indian/Christmas", "Insla da Nadal" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Guadeloupe", "Guadalupa" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/St_Vincent", "Son Vincenz" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Sontg’elena" },
            { "timezone.excity.Europe/Isle_of_Man", "Insla da Man" },
            { "timezone.excity.America/Mexico_City", "Citad dal Mexico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cap Verd" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daressalam" },
            { "timezone.excity.America/St_Barthelemy", "Son Barthélemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia dal Sid" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota dal Nord" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota dal Nord" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota dal Nord" },
        };
        return data;
    }
}
