/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_es extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "árabe";
        final String metaValue_hy = "armenio";
        final String metaValue_ae = "avéstico";
        final String metaValue_ban = "balinés";
        final String metaValue_bn = "bengalí";
        final String metaValue_bug = "buginés";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cheroqui";
        final String metaValue_cop = "copto";
        final String metaValue_ka = "georgiano";
        final String metaValue_got = "gótico";
        final String metaValue_el = "griego";
        final String metaValue_gu = "guyaratí";
        final String metaValue_he = "hebreo";
        final String metaValue_jv = "javanés";
        final String metaValue_ja = "japonés";
        final String metaValue_km = "jemer";
        final String metaValue_kn = "canarés";
        final String metaValue_ko = "coreano";
        final String metaValue_ml = "malayálam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmano";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "oriya";
        final String metaValue_phn = "fenicio";
        final String metaValue_si = "cingalés";
        final String metaValue_su = "sundanés";
        final String metaValue_syr = "siriaco";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalo";
        final String metaValue_th = "tailandés";
        final String metaValue_bo = "tibetano";
        final String metaValue_uga = "ugarítico";
        final String metaValue_peo = "persa antiguo";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "África" },
            { "003", "América del Norte" },
            { "005", "Sudamérica" },
            { "009", "Oceanía" },
            { "011", "África occidental" },
            { "013", "Centroamérica" },
            { "014", "África oriental" },
            { "015", "África septentrional" },
            { "017", "África central" },
            { "018", "África meridional" },
            { "019", "América" },
            { "021", "Norteamérica" },
            { "029", "Caribe" },
            { "030", "Asia oriental" },
            { "034", "Asia meridional" },
            { "035", "Sudeste asiático" },
            { "039", "Europa meridional" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Región de Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia central" },
            { "145", "Asia occidental" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "155", "Europa occidental" },
            { "202", "África subsahariana" },
            { "419", "Latinoamérica" },
            { "AC", "Isla de la Ascensión" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Árabes Unidos" },
            { "AF", "Afganistán" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antártida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islas Aland" },
            { "AZ", "Azerbaiyán" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladés" },
            { "BE", "Bélgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Baréin" },
            { "BI", "Burundi" },
            { "BJ", "Benín" },
            { "BL", "San Bartolomé" },
            { "BM", "Bermudas" },
            { "BN", "Brunéi" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe neerlandés" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bután" },
            { "BV", "Isla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belice" },
            { "CA", "Canadá" },
            { "CC", "Islas Cocos" },
            { "CD", "República Democrática del Congo" },
            { "CF", "República Centroafricana" },
            { "CG", "Congo" },
            { "CH", "Suiza" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Islas Cook" },
            { "CL", "Chile" },
            { "CM", "Camerún" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Isla Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curazao" },
            { "CX", "Isla de Navidad" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "DE", "Alemania" },
            { "DG", "Diego García" },
            { "DJ", "Yibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "República Dominicana" },
            { "DZ", "Argelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egipto" },
            { "EH", "Sáhara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "España" },
            { "ET", "Etiopía" },
            { "EU", "Unión Europea" },
            { "EZ", "zona del euro" },
            { "FI", "Finlandia" },
            { "FJ", "Fiyi" },
            { "FK", "Islas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Islas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gabón" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Georgia" },
            { "GF", "Guayana Francesa" },
            { "GG", "Guernesey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islas Georgia del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bisáu" },
            { "GY", "Guyana" },
            { "HK", "RAE de Hong Kong (China)" },
            { "HM", "Islas Heard y McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Haití" },
            { "HU", "Hungría" },
            { "IC", "Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Isla de Man" },
            { "IN", "India" },
            { "IO", "Territorio Británico del Océano Índico" },
            { "IQ", "Irak" },
            { "IR", "Irán" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordania" },
            { "JP", "Japón" },
            { "KE", "Kenia" },
            { "KG", "Kirguistán" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "KN", "San Cristóbal y Nieves" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islas Caimán" },
            { "KZ", "Kazajistán" },
            { "LA", "Laos" },
            { "LB", "Líbano" },
            { "LC", "Santa Lucía" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "Mónaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "San Martín" },
            { "MG", "Madagascar" },
            { "MH", "Islas Marshall" },
            { "MK", "Macedonia del Norte" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "RAE de Macao (China)" },
            { "MP", "Islas Marianas del Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "México" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "Níger" },
            { "NF", "Isla Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Países Bajos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Omán" },
            { "PA", "Panamá" },
            { "PE", "Perú" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Papúa Nueva Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Pakistán" },
            { "PL", "Polonia" },
            { "PM", "San Pedro y Miquelón" },
            { "PN", "Islas Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palaos" },
            { "PY", "Paraguay" },
            { "QA", "Catar" },
            { "QO", "Territorios alejados de Oceanía" },
            { "RE", "Reunión" },
            { "RO", "Rumanía" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudí" },
            { "SB", "Islas Salomón" },
            { "SC", "Seychelles" },
            { "SD", "Sudán" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Elena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard y Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudán del Sur" },
            { "ST", "Santo Tomé y Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Esuatini" },
            { "TA", "Tristán de Acuña" },
            { "TC", "Islas Turcas y Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Australes Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tayikistán" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistán" },
            { "TN", "Túnez" },
            { "TO", "Tonga" },
            { "TR", "Turquía" },
            { "TT", "Trinidad y Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwán" },
            { "TZ", "Tanzania" },
            { "UA", "Ucrania" },
            { "UG", "Uganda" },
            { "UM", "Islas menores alejadas de EE. UU." },
            { "UN", "Naciones Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistán" },
            { "VA", "Ciudad del Vaticano" },
            { "VC", "San Vicente y las Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Islas Vírgenes Británicas" },
            { "VI", "Islas Vírgenes de EE. UU." },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoacentos" },
            { "XB", "Pseudobidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sudáfrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Región desconocida" },
            { "aa", "afar" },
            { "ab", "abjasio" },
            { "ae", metaValue_ae },
            { "af", "afrikáans" },
            { "ak", "akan" },
            { "am", "amárico" },
            { "an", "aragonés" },
            { "ar", metaValue_ar },
            { "as", "asamés" },
            { "av", "avar" },
            { "ay", "aimara" },
            { "az", "azerbaiyano" },
            { "ba", "baskir" },
            { "be", "bielorruso" },
            { "bg", "búlgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretón" },
            { "bs", "bosnio" },
            { "ca", "catalán" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "checo" },
            { "cu", "eslavo eclesiástico" },
            { "cv", "chuvasio" },
            { "cy", "galés" },
            { "da", "danés" },
            { "de", "alemán" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewé" },
            { "el", metaValue_el },
            { "en", "inglés" },
            { "eo", "esperanto" },
            { "es", "español" },
            { "et", "estonio" },
            { "eu", "euskera" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finés" },
            { "fj", "fiyiano" },
            { "fo", "feroés" },
            { "fr", "francés" },
            { "fy", "frisón occidental" },
            { "ga", "irlandés" },
            { "gd", "gaélico escocés" },
            { "gl", "gallego" },
            { "gn", "guaraní" },
            { "gu", metaValue_gu },
            { "gv", "manés" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "criollo haitiano" },
            { "hu", "húngaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesio" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuán" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandés" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazajo" },
            { "kl", "groenlandés" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cachemir" },
            { "ku", "kurmanji" },
            { "kv", "komi" },
            { "kw", "córnico" },
            { "ky", "kirguís" },
            { "la", "latín" },
            { "lb", "luxemburgués" },
            { "lg", "ganda" },
            { "li", "limburgués" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "letón" },
            { "mg", "malgache" },
            { "mh", "marshalés" },
            { "mi", "maorí" },
            { "mk", "macedonio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "maratí" },
            { "ms", "malayo" },
            { "mt", "maltés" },
            { "my", metaValue_my },
            { "na", "nauruano" },
            { "nb", "noruego bokmal" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepalí" },
            { "ng", "ndonga" },
            { "nl", "neerlandés" },
            { "nn", "noruego nynorsk" },
            { "no", "noruego" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitano" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osético" },
            { "pa", "punyabí" },
            { "pi", "pali" },
            { "pl", "polaco" },
            { "ps", "pastún" },
            { "pt", "portugués" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "kirundi" },
            { "ro", "rumano" },
            { "ru", "ruso" },
            { "rw", "kinyarwanda" },
            { "sa", "sánscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami septentrional" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somalí" },
            { "sq", "albanés" },
            { "sr", "serbio" },
            { "ss", "suazi" },
            { "st", "sotho meridional" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "suajili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tayiko" },
            { "th", metaValue_th },
            { "ti", "tigriña" },
            { "tk", "turcomano" },
            { "tl", metaValue_tl },
            { "tn", "setsuana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tártaro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "ug", "uigur" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "uz", "uzbeko" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapük" },
            { "wa", "valón" },
            { "wo", "wólof" },
            { "xh", "xhosa" },
            { "yi", "yidis" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chino" },
            { "zu", "zulú" },
            { "ace", "achenés" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigué" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "acadio" },
            { "ale", "aleutiano" },
            { "alt", "altái meridional" },
            { "ang", "inglés antiguo" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameo" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "árabe najdí" },
            { "arw", "arahuaco" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "avadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bas", "basaa" },
            { "bax", "bamún" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "baluchi occidental" },
            { "bho", "bhoyapurí" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriato" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatái" },
            { "chk", "trukés" },
            { "chm", "marí" },
            { "chn", "jerga chinuk" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyene" },
            { "ckb", "kurdo sorani" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "tártaro de Crimea" },
            { "crj", "cree suroriental" },
            { "crk", "cree de las llanuras" },
            { "crl", "cree nororiental" },
            { "crm", "cree moose" },
            { "crr", "algonquino de Carolina" },
            { "crs", "criollo seychelense" },
            { "csb", "casubio" },
            { "csw", "cree de los pantanos" },
            { "dak", "dakota" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "bajo sorbio" },
            { "dua", "duala" },
            { "dum", "neerlandés medio" },
            { "dyo", "jola-fonyi" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "egipcio antiguo" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "inglés medio" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fon", "fon" },
            { "frc", "francés cajún" },
            { "frm", "francés medio" },
            { "fro", "francés antiguo" },
            { "frr", "frisón septentrional" },
            { "frs", "frisón oriental" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauzo" },
            { "gan", "chino gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertés" },
            { "gmh", "alto alemán medio" },
            { "goh", "alto alemán antiguo" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "griego antiguo" },
            { "gsw", "alemán suizo" },
            { "guz", "gusii" },
            { "gwi", "kutchin" },
            { "hai", "haida" },
            { "hak", "chino hakka" },
            { "haw", "hawaiano" },
            { "hax", "haida meridional" },
            { "hil", "hiligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "alto sorbio" },
            { "hsn", "chino xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuit del oeste de Canadá" },
            { "ilo", "ilocano" },
            { "inh", "ingush" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "judeo-persa" },
            { "jrb", "judeo-árabe" },
            { "kaa", "karakalpako" },
            { "kab", "cabileño" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardiano" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "criollo caboverdiano" },
            { "kfo", "koro" },
            { "kgp", "káingang" },
            { "kha", "khasi" },
            { "kho", "kotanés" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi permio" },
            { "kok", "konkaní" },
            { "kos", "kosraeano" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "carelio" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgiano" },
            { "lij", "ligur" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombardo" },
            { "lol", "mongo" },
            { "lou", "criollo de Luisiana" },
            { "loz", "lozi" },
            { "lrc", "lorí septentrional" },
            { "lsm", "samia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseño" },
            { "lun", "lunda" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madurés" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "macasar" },
            { "man", "mandingo" },
            { "mas", "masái" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "criollo mauriciano" },
            { "mga", "irlandés medio" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manchú" },
            { "mni", "manipurí" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "varios idiomas" },
            { "mus", "creek" },
            { "mwl", "mirandés" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazandaraní" },
            { "nan", "chino min nan" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "bajo alemán" },
            { "new", "nevarí" },
            { "nia", "nias" },
            { "niu", "niueano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "nórdico antiguo" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho septentrional" },
            { "nus", "nuer" },
            { "nwc", "newari clásico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwa noroccidental" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa occidental" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turco otomano" },
            { "pag", "pangasinán" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin de Nigeria" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "pidgin salomonense" },
            { "pon", "pohnpeiano" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prusiano" },
            { "pro", "provenzal antiguo" },
            { "quc", "quiché" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "rohinyá" },
            { "rof", "rombo" },
            { "rom", "romaní" },
            { "rup", "arrumano" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "arameo samaritano" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "escocés" },
            { "sdh", "kurdo meridional" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irlandés antiguo" },
            { "shi", "tashelhit" },
            { "shn", "shan" },
            { "shu", "árabe chadiano" },
            { "sid", "sidamo" },
            { "slh", "lushootseed meridional" },
            { "sma", "sami meridional" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "soninké" },
            { "sog", "sogdiano" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "salish de los estrechos" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerio" },
            { "swb", "comorense" },
            { "syc", "siríaco clásico" },
            { "syr", metaValue_syr },
            { "szl", "silesio" },
            { "tce", "tutchone meridional" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetún" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigré" },
            { "tiv", "tiv" },
            { "tkl", "tokelauano" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "tonga del Nyasa" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshiano" },
            { "ttm", "tutchone septentrional" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluano" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniano" },
            { "tzm", "tamazight del Atlas Central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "lengua desconocida" },
            { "vec", "veneciano" },
            { "vmw", "makua" },
            { "vot", "vótico" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolayta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "chino wu" },
            { "xal", "kalmyk" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapés" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "ñe’engatú" },
            { "yue", "cantonés" },
            { "zap", "zapoteco" },
            { "zbl", "símbolos Bliss" },
            { "zen", "zenaga" },
            { "zgh", "tamazight estándar marroquí" },
            { "zun", "zuñi" },
            { "zxx", "sin contenido lingüístico" },
            { "zza", "zazaki" },
            { "Adlm", "ádlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "símbolos blis" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabarios aborígenes canadienses unificados" },
            { "Cari", "cario" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "chipriota" },
            { "Cyrl", "cirílico" },
            { "Cyrs", "cirílico del antiguo eslavo eclesiástico" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egipcio demótico" },
            { "Egyh", "egipcio hierático" },
            { "Egyp", "jeroglíficos egipcios" },
            { "Ethi", "etiópico" },
            { "Geok", "georgiano eclesiástico" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolítico" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuji" },
            { "Hanb", "han con bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "silabarios japoneses" },
            { "Hung", "húngaro antiguo" },
            { "Inds", "Indio (harappan)" },
            { "Ital", "antigua bastardilla" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "lanna" },
            { "Laoo", "laosiano" },
            { "Latf", "latino fraktur" },
            { "Latg", "latino gaélico" },
            { "Latn", "latino" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineal A" },
            { "Linb", "lineal B" },
            { "Lyci", "licio" },
            { "Lydi", "lidio" },
            { "Mand", "mandeo" },
            { "Maya", "jeroglíficos mayas" },
            { "Mero", "meroítico" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmaniya" },
            { "Perm", "permiano antiguo" },
            { "Phag", "phags-pa" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollard Miao" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongo-rongo" },
            { "Runr", "rúnico" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "shaviano" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siriaco estrangelo" },
            { "Syrj", "siriaco occidental" },
            { "Syrn", "siriaco oriental" },
            { "Tagb", "tagbanúa" },
            { "Tale", "tai le" },
            { "Talu", "nuevo tai lue" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Visp", "lenguaje visible" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiforme sumerio-acadio" },
            { "Yiii", "yi" },
            { "Zinh", "heredado" },
            { "Zmth", "notación matemática" },
            { "Zsye", "emojis" },
            { "Zsym", "símbolos" },
            { "Zxxx", "no escrito" },
            { "Zyyy", "común" },
            { "Zzzz", "alfabeto desconocido" },
            { "de_AT", "alemán austríaco" },
            { "de_CH", "alto alemán suizo" },
            { "en_AU", "inglés australiano" },
            { "en_CA", "inglés canadiense" },
            { "en_GB", "inglés británico" },
            { "en_US", "inglés estadounidense" },
            { "es_ES", "español de España" },
            { "es_MX", "español de México" },
            { "fa_AF", "darí" },
            { "fr_CA", "francés canadiense" },
            { "fr_CH", "francés suizo" },
            { "nl_BE", "flamenco" },
            { "pt_BR", "portugués de Brasil" },
            { "pt_PT", "portugués de Portugal" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "suajili del Congo" },
            { "%%1901", "Ortografía alemana tradicional" },
            { "%%1996", "Ortografía alemana de 1996" },
            { "ar_001", "árabe estándar moderno" },
            { "es_419", "español latinoamericano" },
            { "key.ca", "calendario" },
            { "key.cf", "formato de moneda" },
            { "key.co", "orden" },
            { "key.cu", "moneda" },
            { "key.em", "presentación del emoji" },
            { "key.hc", "ciclo horario (12 o 24 horas)" },
            { "key.lb", "estilo de salto de línea" },
            { "key.lw", "salto de línea en palabras" },
            { "key.ms", "sistema de medición" },
            { "key.nu", "números" },
            { "key.ss", "salto de oración después de abreviatura" },
            { "key.tz", "zona horaria" },
            { "key.va", "variante local" },
            { "nds_NL", "bajo sajón" },
            { "%%POSIX", "Ordenador" },
            { "zh_Hans", "chino simplificado" },
            { "zh_Hant", "chino tradicional" },
            { "%%FONIPA", "Alfabeto fonético internacional IPA" },
            { "%%PINYIN", "Romanización pinyin" },
            { "%%AREVELA", "Armenio oriental" },
            { "%%MONOTON", "Monotónico" },
            { "%%POLYTON", "Politónico" },
            { "%%REVISED", "Ortografía revisada" },
            { "%%SCOTLAND", "Inglés escocés estándar" },
            { "%%VALENCIA", "Valenciano" },
            { "%%WADEGILE", "Romanización Wade-Giles" },
            { "type.ca.roc", "calendario de la República de China" },
            { "type.co.eor", "reglas de ordenación europeas" },
            { "type.hc.h11", "sistema de 12 horas (0–11)" },
            { "type.hc.h12", "sistema de 12 horas (1–12)" },
            { "type.hc.h23", "sistema de 24 horas (0–23)" },
            { "type.hc.h24", "sistema de 24 horas (1–24)" },
            { "type.m0.bgn", "transliteración USBGN" },
            { "type.nu.arab", "dígitos indoarábigos" },
            { "type.nu.armn", "números en armenio" },
            { "type.nu.beng", "dígitos en bengalí" },
            { "type.nu.cakm", "dígitos en chakma" },
            { "type.nu.deva", "dígitos en devanagari" },
            { "type.nu.ethi", "números en etíope" },
            { "type.nu.geor", "números en georgiano" },
            { "type.nu.grek", "números en griego" },
            { "type.nu.gujr", "dígitos en guyaratí" },
            { "type.nu.guru", "dígitos en gurmuji" },
            { "type.nu.hans", "números en chino simplificado" },
            { "type.nu.hant", "números en chino tradicional" },
            { "type.nu.hebr", "números en hebreo" },
            { "type.nu.java", "dígitos en javanés" },
            { "type.nu.jpan", "números en japonés" },
            { "type.nu.khmr", "dígitos en jemer" },
            { "type.nu.knda", "dígitos en canarés" },
            { "type.nu.laoo", "dígitos en lao" },
            { "type.nu.latn", "dígitos occidentales" },
            { "type.nu.mlym", "dígitos en malayálam" },
            { "type.nu.mong", "dígitos en mongol" },
            { "type.nu.mtei", "dígitos en meitei" },
            { "type.nu.mymr", "dígitos en birmano" },
            { "type.nu.olck", "dígitos en ol chiki" },
            { "type.nu.orya", "dígitos en oriya" },
            { "type.nu.taml", "números en tamil tradicional" },
            { "type.nu.telu", "dígitos en telugu" },
            { "type.nu.thai", "dígitos en tailandés" },
            { "type.nu.tibt", "dígitos en tibetano" },
            { "type.nu.vaii", "dígitos en vai" },
            { "type.ca.dangi", "calendario dangi" },
            { "type.co.ducet", "orden predeterminado de Unicode" },
            { "type.lb.loose", "estilo de salto de línea flexible" },
            { "type.nu.roman", "números romanos" },
            { "type.ca.coptic", "calendario cóptico" },
            { "type.ca.hebrew", "calendario hebreo" },
            { "type.ca.indian", "calendario nacional hindú" },
            { "type.co.compat", "orden anterior, para compatibilidad" },
            { "type.co.pinyin", "orden pinyin" },
            { "type.co.search", "búsqueda de uso general" },
            { "type.co.stroke", "orden de los trazos" },
            { "type.co.unihan", "orden de trazos radicales" },
            { "type.co.zhuyin", "orden zhuyin" },
            { "type.d0.fwidth", "ancho completo" },
            { "type.d0.hwidth", "ancho medio" },
            { "type.lb.normal", "estilo de salto de línea normal" },
            { "type.lb.strict", "estilo de salto de línea estricto" },
            { "type.m0.ungegn", "transliteración UNGEGN" },
            { "type.ms.metric", "sistema métrico" },
            { "type.nu.native", "dígitos nativos" },
            { "type.ca.chinese", "calendario chino" },
            { "type.ca.islamic", "calendario hijri" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "type.ca.persian", "calendario persa" },
            { "type.cf.account", "formato de moneda de contabilidad" },
            { "type.d0.npinyin", "Numérico" },
            { "type.nu.arabext", "dígitos indoarábigos extendidos" },
            { "type.nu.armnlow", "números en armenio en minúscula" },
            { "type.nu.finance", "Números financieros" },
            { "type.nu.greklow", "números en griego en minúscula" },
            { "type.nu.hanidec", "números decimales en chino" },
            { "type.nu.hansfin", "números financieros en chino simplificado" },
            { "type.nu.hantfin", "números financieros en chino tradicional" },
            { "type.nu.jpanfin", "números financieros en japonés" },
            { "type.nu.tamldec", "dígitos en tamil" },
            { "type.ca.buddhist", "calendario budista" },
            { "type.ca.ethiopic", "calendario etíope" },
            { "type.ca.japanese", "calendario japonés" },
            { "type.cf.standard", "formato de moneda estándar" },
            { "type.co.phonetic", "orden fonético" },
            { "type.co.searchjl", "Buscar por consonante inicial de hangul" },
            { "type.co.standard", "orden estándar" },
            { "type.ms.uksystem", "sistema imperial" },
            { "type.ms.ussystem", "sistema estadounidense" },
            { "type.nu.fullwide", "dígitos de ancho completo" },
            { "type.nu.romanlow", "números romanos en minúscula" },
            { "type.ca.gregorian", "calendario gregoriano" },
            { "type.co.phonebook", "orden de listín telefónico" },
            { "type.co.dictionary", "orden de diccionario" },
            { "type.co.traditional", "orden tradicional" },
            { "type.nu.traditional", "Números tradicionales" },
            { "type.ca.islamic-civil", "calendario hijri tabular" },
            { "type.ca.islamic-umalqura", "calendario hijri Umm al-Qura" },
            { "type.ca.ethiopic-amete-alem", "calendario etíope Amete Alem" },
        };
        return data;
    }
}
