/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_am extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ግሪንዊች ማዕከላዊ ሰዓት",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "የአፒያ መደበኛ ሰዓት",
               "",
               "የአፒያ የቀን ጊዜ ሰዓት",
               "",
               "የአፒያ ሰዓት",
               "",
            };
        final String[] Cook = new String[] {
               "የኩክ ደሴቶች መደበኛ ሰዓት",
               "",
               "የኩክ ደሴቶች ግማሽ ክረምት ሰዓት",
               "",
               "የኩክ ደሴቶች ሰዓት",
               "",
            };
        final String[] Cuba = new String[] {
               "የኩባ መደበኛ ሰዓት",
               "CST",
               "የኩባ የቀን ብርሃን ሰዓት",
               "CDT",
               "ኩባ ሰዓት",
               "CT",
            };
        final String[] Fiji = new String[] {
               "የፊጂ መደበኛ ሰዓት",
               "",
               "የፊጂ ክረምት ሰዓት",
               "",
               "የፊጂ ሰዓት",
               "",
            };
        final String[] Gulf = new String[] {
               "የባህረሰላጤ መደበኛ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "የሆቭድ መደበኛ የሰዓት አቆጣጠር",
               "",
               "የሆቭድ የበጋ ሰዓት አቆጣጠር",
               "",
               "የሆቭድ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Iran = new String[] {
               "የኢራን መደበኛ ሰዓት",
               "",
               "የኢራን የቀን ብርሃን ሰዓት",
               "",
               "የኢራን ሰዓት",
               "",
            };
        final String[] Niue = new String[] {
               "የኒዩዌ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "የኦምስክ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የኦምስክ የበጋ ሰዓት አቆጣጠር",
               "",
               "የኦምስክ የሰዓት አቆጣጠር",
               "",
            };
        final String[] Peru = new String[] {
               "የፔሩ መደበኛ ሰዓት",
               "",
               "የፔሩ ክረምት ሰዓት",
               "",
               "የፔሩ ሰዓት",
               "",
            };
        final String[] Truk = new String[] {
               "የቹክ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "የዌክ ደሴት ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "የቺሊ መደበኛ ሰዓት",
               "",
               "የቺሊ ክረምት ሰዓት",
               "",
               "የቺሊ ሰዓት",
               "",
            };
        final String[] China = new String[] {
               "የቻይና መደበኛ ሰዓት",
               "CST",
               "የቻይና የቀን ብርሃን ሰዓት",
               "CDT",
               "የቻይና ሰዓት",
               "CT",
            };
        final String[] Cocos = new String[] {
               "የኮኮስ ደሴቶች ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "የዴቪስ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "የህንድ መደበኛ ሰዓት",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "የጃፓን መደበኛ ሰዓት",
               "JST",
               "የጃፓን የቀን ብርሃን ሰዓት",
               "JDT",
               "የጃፓን ሰዓት",
               "JT",
            };
        final String[] Korea = new String[] {
               "የኮሪያ መደበኛ ሰዓት",
               "KST",
               "የኮሪያ የቀን ብርሃን ሰዓት",
               "KST",
               "የኮሪያ ሰዓት",
               "KST",
            };
        final String[] Nauru = new String[] {
               "የናውሩ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "የኔፓል ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "የፓላው ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "የሳሞዋ መደበኛ ሰዓት",
               "SST",
               "የሳሞዋ የበጋ ሰዓት",
               "SST",
               "የሳሞዋ ሰዓት",
               "SST",
            };
        final String[] Syowa = new String[] {
               "የሲዮዋ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "የቶንጋ መደበኛ ሰዓት",
               "",
               "የቶንጋ ክረምት ሰዓት",
               "",
               "የቶንጋ ሰዓት",
               "",
            };
        final String[] Yukon = new String[] {
               "የዩኮን ጊዜ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "የአላስካ መደበኛ የሰዓት አቆጣጠር",
               "AKST",
               "የአላስካ የቀን ሰዓት አቆጣጠር",
               "AKDT",
               "የአላስካ ሰዓት አቆጣጠር",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "የአማዞን መደበኛ ሰዓት አቆጣጠር",
               "",
               "የአማዞን የቀን ሰዓት አቆጣጠር",
               "",
               "የአማዞን ሰዓት አቆጣጠር",
               "",
            };
        final String[] Azores = new String[] {
               "የአዞረስ መደበኛ ሰዓት",
               "",
               "የአዞረስ ክረምት ሰዓት",
               "",
               "የአዞረስ ሰዓት",
               "",
            };
        final String[] Bhutan = new String[] {
               "የቡታን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "የብሩኔይ ዳሩሳላም ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "የኢስተር ደሴት መደበኛ ሰዓት",
               "",
               "የኢስተር ደሴት ክረምት ሰዓት",
               "",
               "የኢስተር ደሴት ሰዓት",
               "",
            };
        final String[] Guyana = new String[] {
               "የጉያና ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "የሃዋይ አሌኡት መደበኛ ሰዓት አቆጣጠር",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "የእስራኤል መደበኛ ሰዓት",
               "IST",
               "የእስራኤል የቀን ብርሃን ሰዓት",
               "IDT",
               "የእስራኤል ሰዓት",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "የኮስራኤ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "የማውሰን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "የሞስኮ መደበኛ ሰዓት አቆጣጠር",
               "MSK",
               "የሞስኮ የበጋ ሰዓት አቆጣጠር",
               "MSK",
               "የሞስኮ ሰዓት አቆጣጠር",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "የፖናፔ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "የሳማራ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የሳማራ የበጋ ሰዓት አቆጣጠር",
               "",
               "የሳማራ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Tahiti = new String[] {
               "የታሂቲ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "የታይፔይ መደበኛ ሰዓት",
               "CST",
               "የታይፔይ የቀን ብርሃን ሰዓት",
               "CDT",
               "የታይፔይ ሰዓት",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "የቱቫሉ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "የቮስቶክ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "የዋሊስ እና ፉቱና ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "የዓረቢያ መደበኛ ሰዓት",
               "",
               "የዓረቢያ የቀን ብርሃን ሰዓት",
               "",
               "የዓረቢያ ሰዓት",
               "",
            };
        final String[] Armenia = new String[] {
               "የአርመኒያ መደበኛ ሰዓት",
               "",
               "የአርመኒያ ክረምት ሰዓት",
               "",
               "የአርመኒያ ሰዓት",
               "",
            };
        final String[] Bolivia = new String[] {
               "የቦሊቪያ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "የቻታም መደበኛ ሰዓት",
               "",
               "የቻታም የቀን ብርሃን ሰዓት",
               "",
               "የቻታም ሰዓት",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "የተቀነባበረ ሁለገብ ሰዓት",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "የኢኳዶር ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "የጋምቢየር ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "የጂዮርጂያ መደበኛ ሰዓት",
               "",
               "የጂዮርጂያ ክረምት ሰዓት",
               "",
               "የጂዮርጂያ ሰዓት",
               "",
            };
        final String[] Irkutsk = new String[] {
               "የኢርኩትስክ መደበኛ የሰዓት አቆጣጠር",
               "",
               "ኢርኩትስክ የበጋ የሰዓት አቆጣጠር",
               "",
               "የኢርኩትስክ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Magadan = new String[] {
               "የማጋዳን መደበኛ ሰዓት አቆጣጠር",
               "",
               "የማጋዳን በጋ ሰዓት አቆጣጠር",
               "",
               "የማጋዳን የሰዓት አቆጣጠር",
               "",
            };
        final String[] Myanmar = new String[] {
               "የሚያንማር ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "የኖርፎልክ ደሴቶች መደበኛ የሰዓት አቆጣጠር",
               "",
               "የኖርፎልክ ደሴቶች የቀን የሰዓት አቆጣጠር",
               "",
               "የኖርፎልክ ደሴቶች ሰዓት",
               "",
            };
        final String[] Noronha = new String[] {
               "የፈርናንዶ ዲ ኖሮንቻ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የፈርናንዶ ዲ ኖሮንሃ የበጋ የሰዓት አቆጣጠር",
               "",
               "የኖሮንሃ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Reunion = new String[] {
               "የሬዩኒየን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "የሮቴራ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "የሰለሞን ደሴቶች ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "የቶኬላው ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "የኡራጓይ መደበኛ ሰዓት",
               "",
               "የኡራጓይ ክረምት ሰዓት",
               "",
               "የኡራጓይ ሰዓት",
               "",
            };
        final String[] Vanuatu = new String[] {
               "የቫኗቱ መደበኛ ሰዓት",
               "",
               "የቫኗቱ ክረምት ሰዓት",
               "",
               "የቫኗቱ ሰዓት",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ያኩትስክ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የያኩትስክ የበጋ ሰዓት አቆጣጠር",
               "",
               "ያኩትስክ የሰዓት አቆጣጠር",
               "",
            };
        final String[] Atlantic = new String[] {
               "የአትላንቲክ መደበኛ የሰዓት አቆጣጠር",
               "AST",
               "የአትላንቲክ የቀን ሰዓት አቆጣጠር",
               "AST",
               "የአትላንቲክ የሰዓት አቆጣጠር",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "የብራሲሊያ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የብራዚላ የበጋ ሰዓት አቆጣጠር",
               "",
               "የብራዚላዊ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Chamorro = new String[] {
               "የቻሞሮ መደበኛ ሰዓት",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "የኮሎምቢያ መደበኛ ሰዓት",
               "",
               "የኮሎምቢያ ክረምት ሰዓት",
               "",
               "የኮሎምቢያ ሰዓት",
               "",
            };
        final String[] Falkland = new String[] {
               "የፋልክላንድ ደሴቶች መደበኛ ሰዓት",
               "",
               "የፋልክላንድ ደሴቶች ክረምት ሰዓት",
               "",
               "የፋልክላንድ ደሴቶች ሰዓት",
               "",
            };
        final String[] Malaysia = new String[] {
               "የማሌይዢያ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "የማልዲቭስ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "የኡላን ባቶር መደበኛ ሰዓት አቆጣጠር",
               "",
               "የኡላን ባቶር የበጋ ሰዓት አቆጣጠር",
               "",
               "የኡላን ባቶር ጊዜ",
               "",
            };
        final String[] Pakistan = new String[] {
               "የፓኪስታን መደበኛ ሰዓት",
               "PKT",
               "የፓኪስታን ክረምት ሰዓት",
               "PKST",
               "የፓኪስታን ሰዓት",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "የፓራጓይ መደበኛ ሰዓት",
               "",
               "የፓራጓይ ክረምት ሰዓት",
               "",
               "የፓራጓይ ሰዓት",
               "",
            };
        final String[] Pitcairn = new String[] {
               "የፒትካይርን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "የሱሪናም ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "የአርጀንቲና መደበኛ ሰዓት አቆጣጠር",
               "",
               "የአርጀንቲና የበጋ ሰዓት አቆጣጠር",
               "",
               "የአርጀንቲና የሰዓት አቆጣጠር",
               "",
            };
        final String[] Christmas = new String[] {
               "የገና ደሴት ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "የጋላፓጎስ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "የሆንግ ኮንግ መደበኛ ሰዓት",
               "HKT",
               "የሆንግ ኮንግ ክረምት ሰዓት",
               "HKST",
               "የሆንግ ኮንግ ሰዓት",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "የኢንዶቻይና ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "የፔትሮፓቭሎስኪ - ካምቻትስኪ ሰዓት አቆጣጠር",
               "",
               "የፔትሮፓቭሎስኪ - ካምቻትስኪ የበጋ ሰዓት አቆጣጠር",
               "",
               "የካምቻትካ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "የኪርጊስታን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "የሎርድ ሆዌ መደበኛ የሰዓት አቆጣጠር",
               "",
               "የሎርድ ሆዌ የቀን ሰዓት አቆጣጠር",
               "",
               "የሎርድ ሆዌ የሰዓት አቆጣጠር",
               "",
            };
        final String[] Marquesas = new String[] {
               "የማርኴሳስ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "የማውሪሺየስ መደበኛ ሰዓት",
               "",
               "የማውሪሺየስ ክረምት ሰዓት",
               "",
               "የማውሪሺየስ ሰዓት",
               "",
            };
        final String[] Singapore = new String[] {
               "የሲንጋፒር መደበኛ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "የቬኔዝዌላ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "የአዘርባጃን መደበኛ ሰዓት",
               "",
               "የአዘርባጃን ክረምት ሰዓት",
               "",
               "የአዘርባጃን ሰዓት",
               "",
            };
        final String[] Bangladesh = new String[] {
               "የባንግላዴሽ መደበኛ ሰዓት",
               "",
               "የባንግላዴሽ ክረምት ሰዓት",
               "",
               "የባንግላዴሽ ሰዓት",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "የኬፕ ቨርዴ መደበኛ ሰዓት",
               "",
               "የኬፕ ቨርዴ ክረምት ሰዓት",
               "",
               "የኬፕ ቨርዴ ሰዓት",
               "",
            };
        final String[] East_Timor = new String[] {
               "የምስራቅ ቲሞር ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "ካዛኪስታን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "የሴሸልስ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "የታጂኪስታን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "የኡዝቤኪስታን መደበኛ ሰዓት",
               "",
               "የኡዝቤኪስታን ክረምት ሰዓት",
               "",
               "የኡዝቤኪስታን ሰዓት",
               "",
            };
        final String[] Afghanistan = new String[] {
               "የአፍጋኒስታን ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "የክራስኖይአርስክ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የክራስኖያርስክ የበጋ ሰዓት አቆጣጠር",
               "",
               "የክራስኖያርስክ ሰዓት አቆጣጠር",
               "",
            };
        final String[] New_Zealand = new String[] {
               "የኒው ዚላንድ መደበኛ ሰዓት",
               "NZST",
               "የኒው ዚላንድ የቀን ብርሃን ሰዓት",
               "NZDT",
               "የኒው ዚላንድ ሰዓት",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "የፊሊፒን መደበኛ ሰዓት",
               "PST",
               "የፊሊፒን ክረምት ሰዓት",
               "PDT",
               "የፊሊፒን ሰዓት",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "የቪላዲቮስቶክ መደበኛ የሰዓት አቆጣጠር",
               "",
               "የቭላዲቮስቶክ የበጋ የሰዓት አቆጣጠር",
               "",
               "የቭላዲቮስቶክ የሰዓት አቆጣጠር",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "የህንድ ውቅያኖስ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "የላይን ደሴቶች ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "የኒውፋውንድላንድ መደበኛ የሰዓት አቆጣጠር",
               "NST",
               "የኒውፋውንድላንድ የቀን የሰዓት አቆጣጠር",
               "NDT",
               "የኒውፋውንድላንድ የሰዓት አቆጣጠር",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "የቱርክመኒስታን መደበኛ ሰዓት",
               "",
               "የቱርክመኒስታን ክረምት ሰዓት",
               "",
               "የቱርክመኒስታን ሰዓት",
               "",
            };
        final String[] French_Guiana = new String[] {
               "የፈረንሳይ ጉያና ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "የኒው ካሌዶኒያ መደበኛ ሰዓት",
               "",
               "የኒው ካሌዶኒያ ክረምት ሰዓት",
               "",
               "የኒው ካሌዶኒያ ሰዓት",
               "",
            };
        final String[] South_Georgia = new String[] {
               "የደቡብ ጂዮርጂያ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "የየካተሪንበርግ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የየካተሪንበርግ የበጋ ሰዓት አቆጣጠር",
               "",
               "የየካተሪንበርግ ሰዓት አቆጣጠር",
               "",
            };
        final String[] Africa_Central = new String[] {
               "የመካከለኛው አፍሪካ ሰዓት",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "የምስራቅ አፍሪካ ሰዓት",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "የምዕራብ አፍሪካ ሰዓት",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "የዱሞንት-ዱርቪል ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "የመካከለኛው አውሮፓ መደበኛ ሰዓት",
               "CET",
               "የመካከለኛው አውሮፓ ክረምት ሰዓት",
               "CEST",
               "የመካከለኛው አውሮፓ ሰዓት",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "የምስራቃዊ አውሮፓ መደበኛ ሰዓት",
               "EET",
               "የምስራቃዊ አውሮፓ ክረምት ሰዓት",
               "EEST",
               "የምስራቃዊ አውሮፓ ሰዓት",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "የምዕራባዊ አውሮፓ መደበኛ ሰዓት",
               "WET",
               "የምዕራባዊ አውሮፓ ክረምት ሰዓት",
               "WEST",
               "የምዕራባዊ አውሮፓ ሰዓት",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "የሜክሲኮ ፓሲፊክ መደበኛ ሰዓት አቆጣጠር",
               "MST",
               "የሜክሲኮ ፓሲፊክ የቀን ሰዓት አቆጣጠር",
               "MDT",
               "የሜክሲኮ ፓሲፊክ ሰዓት አቆጣጠር",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "የደቡብ አፍሪካ መደበኛ ሰዓት",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "የሰሜን አሜሪካ የመካከለኛ መደበኛ ሰዓት አቆጣጠር",
               "CST",
               "የመካከለኛ የቀን ሰዓት አቆጣጠር",
               "CDT",
               "የሰሜን አሜሪካ የመካከለኛ ሰዓት አቆጣጠር",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ምስራቃዊ መደበኛ ሰዓት አቆጣጠር",
               "EST",
               "ምስራቃዊ የቀን ሰዓት አቆጣጠር",
               "EST",
               "ምስራቃዊ ሰዓት አቆጣጠር",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "የፓስፊክ መደበኛ ሰዓት አቆጣጠር",
               "PST",
               "የፓስፊክ የቀን ሰዓት አቆጣጠር",
               "PDT",
               "የፓስፊክ ሰዓት አቆጣጠር",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "የፈረንሳይ ደቡባዊ እና አንታርክቲክ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "የጂልበርት ደሴቶች ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "የሃዋይ አሌኡት መደበኛ ሰዓት አቆጣጠር",
               "HST",
               "የሃዋይ አሌኡት የቀን ሰዓት አቆጣጠር",
               "HDT",
               "የሃዋይ አሌኡት ሰዓት አቆጣጠር",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "የፊኒክስ ደሴቶች ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ቅዱስ የፒዬር እና ሚኴሎን መደበኛ ሰዓት",
               "",
               "ቅዱስ የፒዬር እና ሚኴሎን የቀን ብርሃን ሰዓት",
               "",
               "ቅዱስ የፒዬር እና ሚኴሎን ሰዓት",
               "",
            };
        final String[] America_Mountain = new String[] {
               "የተራራ መደበኛ የሰዓት አቆጣጠር",
               "MST",
               "የተራራ የቀንሰዓት አቆጣጠር",
               "MST",
               "የተራራ የሰዓት አቆጣጠር",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "የማርሻል ደሴቶች ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "የፓፗ ኒው ጊኒ ሰዓት",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "የአውስትራሊያ መካከለኛ መደበኛ የሰዓት አቆጣጠር",
               "ACST",
               "የአውስትራሊያ መካከለኛ የቀን ሰዓት አቆጣጠር",
               "ACDT",
               "የመካከለኛው አውስትራሊያ ሰዓት አቆጣጠር",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "የአውስትራሊያ ምዕራባዊ መደበኛ የሰዓት አቆጣጠር",
               "AEST",
               "የአውስትራሊያ ምዕራባዊ የቀን ሰዓት አቆጣጠር",
               "AEDT",
               "የምዕራባዊ አውስትራሊያ የሰዓት አቆጣጠር",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "የአውስትራሊያ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር",
               "AWST",
               "የአውስትራሊያ ምስራቃዊ የቀን ሰዓት አቆጣጠር",
               "AWDT",
               "የምስራቃዊ አውስትራሊያ ሰዓት አቆጣጠር",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "የመካከለኛው ኢንዶኔዢያ ሰዓት",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "የምስራቃዊ ኢንዶኔዢያ ሰዓት",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "የምዕራባዊ ኢንዶኔዢያ ሰዓት",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "የአውስትራሊያ መካከለኛ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር",
               "",
               "የአውስትራሊያ መካከለኛው ምስራቅ የቀን ሰዓት አቆጣጠር",
               "",
               "የአውስትራሊያ መካከለኛ ምስራቃዊ ሰዓት አቆጣጠር",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "የተቀነባበረ ሁለገብ ሰዓት",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የአይሪሽ መደበኛ ሰዓት አቆጣጠር",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "የተቀነባበረ ሁለገብ ሰዓት",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "የተቀነባበረ ሁለገብ ሰዓት",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "የተቀነባበረ ሁለገብ ሰዓት",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "የተቀነባበረ ሁለገብ ሰዓት",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "የተቀነባበረ ሁለገብ ሰዓት",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የአይሪሽ መደበኛ ሰዓት አቆጣጠር",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ግሪንዊች ማዕከላዊ ሰዓት",
                    "GMT",
                    "የብሪትሽ የበጋ ሰዓት አቆጣጠር",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ኤደን" },
            { "timezone.excity.Asia/Baku", "ባኩ" },
            { "timezone.excity.Asia/Dili", "ዲሊ" },
            { "timezone.excity.Asia/Gaza", "ጋዛ" },
            { "timezone.excity.Asia/Hovd", "ሆቭድ" },
            { "timezone.excity.Asia/Omsk", "ኦምስክ" },
            { "timezone.excity.Asia/Oral", "ኦራል" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "አማን" },
            { "timezone.excity.Asia/Aqtau", "አኩታኡ" },
            { "timezone.excity.Asia/Chita", "ቺታ" },
            { "timezone.excity.Asia/Dhaka", "ዳካ" },
            { "timezone.excity.Asia/Dubai", "ዱባይ" },
            { "timezone.excity.Asia/Kabul", "ካቡል" },
            { "timezone.excity.Asia/Macau", "ማካኡ" },
            { "timezone.excity.Asia/Qatar", "ኳታር" },
            { "timezone.excity.Asia/Seoul", "ሴኦል" },
            { "timezone.excity.Asia/Tokyo", "ቶኪዮ" },
            { "timezone.excity.Asia/Tomsk", "ቶምስክ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ጁባ" },
            { "timezone.excity.Africa/Lome", "ሎሜ" },
            { "timezone.excity.Asia/Almaty", "አልማትይ" },
            { "timezone.excity.Asia/Anadyr", "አናድይር" },
            { "timezone.excity.Asia/Aqtobe", "አኩቶቤ" },
            { "timezone.excity.Asia/Atyrau", "አትይራኡ" },
            { "timezone.excity.Asia/Beirut", "ቤሩት" },
            { "timezone.excity.Asia/Brunei", "ብሩናይ" },
            { "timezone.excity.Asia/Hebron", "ኬብሮን" },
            { "timezone.excity.Asia/Kuwait", "ኩዌት" },
            { "timezone.excity.Asia/Manila", "ማኒላ" },
            { "timezone.excity.Asia/Muscat", "ሙስካት" },
            { "timezone.excity.Asia/Riyadh", "ሪያድ" },
            { "timezone.excity.Asia/Saigon", "ሆ ቺ ሚንህ ከተማ" },
            { "timezone.excity.Asia/Taipei", "ታይፓይ" },
            { "timezone.excity.Asia/Tehran", "ቴህራን" },
            { "timezone.excity.Asia/Urumqi", "ኡሩምኪ" },
            { "timezone.excity.Etc/Unknown", "ያልታወቀ ከተማ" },
            { "timezone.excity.Europe/Kiev", "ኪየቭ" },
            { "timezone.excity.Europe/Oslo", "ኦስሎ" },
            { "timezone.excity.Europe/Riga", "ሪጋ" },
            { "timezone.excity.Europe/Rome", "ሮም" },
            { "timezone.excity.Indian/Mahe", "ማሄ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "አክራ" },
            { "timezone.excity.Africa/Cairo", "ካይሮ" },
            { "timezone.excity.Africa/Ceuta", "ሲኡታ" },
            { "timezone.excity.Africa/Dakar", "ዳካር" },
            { "timezone.excity.Africa/Lagos", "ሌጎስ" },
            { "timezone.excity.Africa/Tunis", "ቱኒዝ" },
            { "timezone.excity.America/Adak", "አዳክ" },
            { "timezone.excity.America/Lima", "ሊማ" },
            { "timezone.excity.America/Nome", "ኖሜ" },
            { "timezone.excity.Asia/Baghdad", "ባግዳድ" },
            { "timezone.excity.Asia/Bahrain", "ባህሬን" },
            { "timezone.excity.Asia/Bangkok", "ባንኮክ" },
            { "timezone.excity.Asia/Barnaul", "ባርናኡል" },
            { "timezone.excity.Asia/Bishkek", "ቢሽኬክ" },
            { "timezone.excity.Asia/Colombo", "ኮሎምቦ" },
            { "timezone.excity.Asia/Irkutsk", "ኢርኩትስክ" },
            { "timezone.excity.Asia/Jakarta", "ጃካርታ" },
            { "timezone.excity.Asia/Karachi", "ካራቺ" },
            { "timezone.excity.Asia/Kuching", "ኩቺንግ" },
            { "timezone.excity.Asia/Magadan", "ማጋዳን" },
            { "timezone.excity.Asia/Nicosia", "ኒኮሲአ" },
            { "timezone.excity.Asia/Rangoon", "ያንጎን" },
            { "timezone.excity.Asia/Tbilisi", "ትብሊሲ" },
            { "timezone.excity.Asia/Thimphu", "ቲምፉ" },
            { "timezone.excity.Asia/Yakutsk", "ያኩትስክ" },
            { "timezone.excity.Asia/Yerevan", "ይሬቫን" },
            { "timezone.excity.Europe/Kirov", "ኪሮቭ" },
            { "timezone.excity.Europe/Malta", "ማልታ" },
            { "timezone.excity.Europe/Minsk", "ሚንስክ" },
            { "timezone.excity.Europe/Paris", "ፓሪስ" },
            { "timezone.excity.Europe/Sofia", "ሶፊያ" },
            { "timezone.excity.Europe/Vaduz", "ቫዱዝ" },
            { "timezone.excity.Indian/Cocos", "ኮኮስ" },
            { "timezone.excity.Pacific/Apia", "አፒአ" },
            { "timezone.excity.Pacific/Fiji", "ፊጂ" },
            { "timezone.excity.Pacific/Guam", "ጉአም" },
            { "timezone.excity.Pacific/Niue", "ኒዌ" },
            { "timezone.excity.Pacific/Truk", "ቹክ" },
            { "timezone.excity.Pacific/Wake", "ዋኬ" },
            { "timezone.excity.Africa/Asmera", "አስመራ" },
            { "timezone.excity.Africa/Bamako", "ባማኮ" },
            { "timezone.excity.Africa/Bangui", "ባንጉኢ" },
            { "timezone.excity.Africa/Banjul", "ባንጁል" },
            { "timezone.excity.Africa/Bissau", "ቢሳኦ" },
            { "timezone.excity.Africa/Douala", "ዱአላ" },
            { "timezone.excity.Africa/Harare", "ሃራሬ" },
            { "timezone.excity.Africa/Kigali", "ኪጋሊ" },
            { "timezone.excity.Africa/Luanda", "ሉአንዳ" },
            { "timezone.excity.Africa/Lusaka", "ሉሳካ" },
            { "timezone.excity.Africa/Malabo", "ማላቡ" },
            { "timezone.excity.Africa/Maputo", "ማፑቱ" },
            { "timezone.excity.Africa/Maseru", "ማሴሩ" },
            { "timezone.excity.Africa/Niamey", "ኒያሜይ" },
            { "timezone.excity.America/Aruba", "አሩባ" },
            { "timezone.excity.America/Bahia", "ባሂአ" },
            { "timezone.excity.America/Belem", "ቤለም" },
            { "timezone.excity.America/Boise", "ቦይዝ" },
            { "timezone.excity.America/Jujuy", "ጁጁይ" },
            { "timezone.excity.America/Sitka", "ሲትካ" },
            { "timezone.excity.America/Thule", "ቱሌ" },
            { "timezone.excity.Asia/Ashgabat", "አሽጋባት" },
            { "timezone.excity.Asia/Calcutta", "ኮልካታ" },
            { "timezone.excity.Asia/Damascus", "ደማስቆ" },
            { "timezone.excity.Asia/Dushanbe", "ደሻንቤ" },
            { "timezone.excity.Asia/Jayapura", "ጃያፑራ" },
            { "timezone.excity.Asia/Katmandu", "ካትማንዱ" },
            { "timezone.excity.Asia/Khandyga", "ካንዲጋ" },
            { "timezone.excity.Asia/Makassar", "ማካሳር" },
            { "timezone.excity.Asia/Qostanay", "ኮስታናይ" },
            { "timezone.excity.Asia/Sakhalin", "ሳክሃሊን" },
            { "timezone.excity.Asia/Shanghai", "ሻንጋይ" },
            { "timezone.excity.Asia/Tashkent", "ታሽኬንት" },
            { "timezone.excity.Asia/Ust-Nera", "ኡስት-ኔራ" },
            { "timezone.excity.Europe/Athens", "አቴንስ" },
            { "timezone.excity.Europe/Berlin", "በርሊን" },
            { "timezone.excity.Europe/Dublin", "ደብሊን" },
            { "timezone.excity.Europe/Jersey", "ጀርሲ" },
            { "timezone.excity.Europe/Lisbon", "ሊዝበን" },
            { "timezone.excity.Europe/London", "ለንደን" },
            { "timezone.excity.Europe/Madrid", "ማድሪድ" },
            { "timezone.excity.Europe/Monaco", "ሞናኮ" },
            { "timezone.excity.Europe/Moscow", "ሞስኮ" },
            { "timezone.excity.Europe/Prague", "ፕራግ" },
            { "timezone.excity.Europe/Samara", "ሳማራ" },
            { "timezone.excity.Europe/Skopje", "ስኮፕየ" },
            { "timezone.excity.Europe/Tirane", "ቴራን" },
            { "timezone.excity.Europe/Vienna", "ቪየና" },
            { "timezone.excity.Europe/Warsaw", "ዋርሶው" },
            { "timezone.excity.Europe/Zagreb", "ዛግሬብ" },
            { "timezone.excity.Europe/Zurich", "ዙሪክ" },
            { "timezone.excity.Indian/Chagos", "ቻጎስ" },
            { "timezone.excity.Indian/Comoro", "ኮሞሮ" },
            { "timezone.excity.Pacific/Efate", "ኢፋቴ" },
            { "timezone.excity.Pacific/Nauru", "ናውሩ" },
            { "timezone.excity.Pacific/Palau", "ፓላው" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "አቢጃን" },
            { "timezone.excity.Africa/Algiers", "አልጀርስ" },
            { "timezone.excity.Africa/Conakry", "ኮናክሬ" },
            { "timezone.excity.Africa/Kampala", "ካምፓላ" },
            { "timezone.excity.Africa/Mbabane", "ምባባኔ" },
            { "timezone.excity.Africa/Nairobi", "ናይሮቢ" },
            { "timezone.excity.Africa/Tripoli", "ትሪፖሊ" },
            { "timezone.excity.America/Belize", "ቤሊዝ" },
            { "timezone.excity.America/Bogota", "ቦጎታ" },
            { "timezone.excity.America/Cancun", "ካንኩን" },
            { "timezone.excity.America/Cayman", "ካይማን" },
            { "timezone.excity.America/Cuiaba", "ኩየአባ" },
            { "timezone.excity.America/Dawson", "ዳውሰን" },
            { "timezone.excity.America/Denver", "ዴንቨር" },
            { "timezone.excity.America/Guyana", "ጉያና" },
            { "timezone.excity.America/Havana", "ሃቫና" },
            { "timezone.excity.America/Inuvik", "ኢኑቪክ" },
            { "timezone.excity.America/Juneau", "ጁኒዩ" },
            { "timezone.excity.America/La_Paz", "ላ ፓዝ" },
            { "timezone.excity.America/Maceio", "ሜሲኦ" },
            { "timezone.excity.America/Manaus", "ማናኡስ" },
            { "timezone.excity.America/Merida", "ሜሪዳ" },
            { "timezone.excity.America/Nassau", "ናሳው" },
            { "timezone.excity.America/Panama", "ፓናማ" },
            { "timezone.excity.America/Recife", "ረሲፍ" },
            { "timezone.excity.America/Regina", "ረጂና" },
            { "timezone.excity.Asia/Famagusta", "ፋማጉስታ" },
            { "timezone.excity.Asia/Hong_Kong", "ሆንግ ኮንግ" },
            { "timezone.excity.Asia/Jerusalem", "እየሩሳሌም" },
            { "timezone.excity.Asia/Kamchatka", "ካምቻትካ" },
            { "timezone.excity.Asia/Pontianak", "ፖንቲአናክ" },
            { "timezone.excity.Asia/Pyongyang", "ፕዮንግያንግ" },
            { "timezone.excity.Asia/Qyzylorda", "ኩይዚሎርዳ" },
            { "timezone.excity.Asia/Samarkand", "ሳማርካንድ" },
            { "timezone.excity.Asia/Singapore", "ሲንጋፖር" },
            { "timezone.excity.Asia/Vientiane", "ቬንቲአን" },
            { "timezone.excity.Europe/Andorra", "አንዶራ" },
            { "timezone.excity.Europe/Saratov", "ሳራቶቭ" },
            { "timezone.excity.Europe/Tallinn", "ታሊን" },
            { "timezone.excity.Europe/Vatican", "ቫቲካን" },
            { "timezone.excity.Europe/Vilnius", "ቪሊነስ" },
            { "timezone.excity.Indian/Mayotte", "ማዮቴ" },
            { "timezone.excity.Indian/Reunion", "ሬዩኒየን" },
            { "timezone.excity.Pacific/Easter", "ፋሲካ" },
            { "timezone.excity.Pacific/Kosrae", "ኮስሬ" },
            { "timezone.excity.Pacific/Majuro", "ማጁሩ" },
            { "timezone.excity.Pacific/Midway", "ሚድወይ" },
            { "timezone.excity.Pacific/Noumea", "ናኦሚአ" },
            { "timezone.excity.Pacific/Ponape", "ፖህንፔ" },
            { "timezone.excity.Pacific/Saipan", "ሴይፓን" },
            { "timezone.excity.Pacific/Tahiti", "ታሂቲ" },
            { "timezone.excity.Pacific/Tarawa", "ታራዋ" },
            { "timezone.excity.Pacific/Wallis", "ዋሊስ" },
            { "timezone.excity.Africa/Blantyre", "ብላንታየር" },
            { "timezone.excity.Africa/Djibouti", "ጅቡቲ" },
            { "timezone.excity.Africa/El_Aaiun", "ኤል አዩአን" },
            { "timezone.excity.Africa/Freetown", "ፍሪታውን" },
            { "timezone.excity.Africa/Gaborone", "ጋቦሮን" },
            { "timezone.excity.Africa/Khartoum", "ካርቱም" },
            { "timezone.excity.Africa/Kinshasa", "ኪንሻሳ" },
            { "timezone.excity.Africa/Monrovia", "ሞንሮቪያ" },
            { "timezone.excity.Africa/Ndjamena", "ንጃሜና" },
            { "timezone.excity.Africa/Sao_Tome", "ሳኦ ቶሜ" },
            { "timezone.excity.Africa/Windhoek", "ዊንድሆክ" },
            { "timezone.excity.America/Antigua", "አንቲጓ" },
            { "timezone.excity.America/Caracas", "ካራካስ" },
            { "timezone.excity.America/Cayenne", "ካይንኤ" },
            { "timezone.excity.America/Chicago", "ቺካጎ" },
            { "timezone.excity.America/Cordoba", "ኮርዶባ" },
            { "timezone.excity.America/Creston", "ክረስተን" },
            { "timezone.excity.America/Curacao", "ኩራሳዎ" },
            { "timezone.excity.America/Detroit", "ዲትሮይት" },
            { "timezone.excity.America/Godthab", "ጋድታብ" },
            { "timezone.excity.America/Grenada", "ግሬናዳ" },
            { "timezone.excity.America/Halifax", "ሃሊፋክስ" },
            { "timezone.excity.America/Iqaluit", "ኢኳሊውት" },
            { "timezone.excity.America/Jamaica", "ጃማይካ" },
            { "timezone.excity.America/Managua", "ማናጉአ" },
            { "timezone.excity.America/Marigot", "ማርጎት" },
            { "timezone.excity.America/Mendoza", "ሜንዶዛ" },
            { "timezone.excity.America/Moncton", "ሞንክቶን" },
            { "timezone.excity.America/Noronha", "ኖሮኛ" },
            { "timezone.excity.America/Ojinaga", "ኦዪናጋ" },
            { "timezone.excity.America/Phoenix", "ፊኒክስ" },
            { "timezone.excity.America/Tijuana", "ቲጁአና" },
            { "timezone.excity.America/Toronto", "ቶሮንቶ" },
            { "timezone.excity.America/Tortola", "ቶርቶላ" },
            { "timezone.excity.America/Yakutat", "ያኩታት" },
            { "timezone.excity.Asia/Phnom_Penh", "ፍኖም ፔንህ" },
            { "timezone.excity.Atlantic/Azores", "አዞረስ" },
            { "timezone.excity.Atlantic/Canary", "ካናሪ" },
            { "timezone.excity.Atlantic/Faeroe", "ፋሮእ" },
            { "timezone.excity.Australia/Eucla", "ኡክላ" },
            { "timezone.excity.Australia/Perth", "ፐርዝ" },
            { "timezone.excity.Europe/Belgrade", "ቤልግሬድ" },
            { "timezone.excity.Europe/Brussels", "ብራሰልስ" },
            { "timezone.excity.Europe/Budapest", "ቡዳፔስት" },
            { "timezone.excity.Europe/Busingen", "ቡሲንገን" },
            { "timezone.excity.Europe/Chisinau", "ቺስናኡ" },
            { "timezone.excity.Europe/Guernsey", "ጉርነሲ" },
            { "timezone.excity.Europe/Helsinki", "ሄልሲንኪ" },
            { "timezone.excity.Europe/Istanbul", "ኢስታንቡል" },
            { "timezone.excity.Europe/Sarajevo", "ሳሪየቮ" },
            { "timezone.excity.Indian/Maldives", "ማልዲቨ" },
            { "timezone.excity.Pacific/Chatham", "ቻታም" },
            { "timezone.excity.Pacific/Fakaofo", "ፋካኦፎ" },
            { "timezone.excity.Pacific/Gambier", "ጋምቢየር" },
            { "timezone.excity.Pacific/Norfolk", "ኖርፎልክ" },
            { "timezone.excity.Africa/Bujumbura", "ቡጁምብራ" },
            { "timezone.excity.Africa/Mogadishu", "ሞቃዲሹ" },
            { "timezone.excity.America/Anguilla", "አንጉይላ" },
            { "timezone.excity.America/Asuncion", "አሱንሲዮን" },
            { "timezone.excity.America/Barbados", "ባርቤዶስ" },
            { "timezone.excity.America/Dominica", "ዶሜኒካ" },
            { "timezone.excity.America/Edmonton", "ኤድመንተን" },
            { "timezone.excity.America/Eirunepe", "ኢሩኔፕ" },
            { "timezone.excity.America/Mazatlan", "ማዛትላን" },
            { "timezone.excity.America/Miquelon", "ሚኮውሎን" },
            { "timezone.excity.America/New_York", "ኒውዮርክ" },
            { "timezone.excity.America/Resolute", "ሪዞሊዩት" },
            { "timezone.excity.America/Santarem", "ሳንታሬም" },
            { "timezone.excity.America/Santiago", "ሳንቲያጎ" },
            { "timezone.excity.America/St_Johns", "ቅዱስ ዮሐንስ" },
            { "timezone.excity.America/St_Kitts", "ቅዱስ ኪትስ" },
            { "timezone.excity.America/St_Lucia", "ቅድስት ሉሲያ" },
            { "timezone.excity.America/Winnipeg", "ዊኒፔግ" },
            { "timezone.excity.Antarctica/Casey", "ካዚይ" },
            { "timezone.excity.Antarctica/Davis", "ዳቪስ" },
            { "timezone.excity.Antarctica/Syowa", "ስዮዋ" },
            { "timezone.excity.Antarctica/Troll", "ትሮል" },
            { "timezone.excity.Asia/Krasnoyarsk", "ክራስኖያርስክ" },
            { "timezone.excity.Asia/Novosibirsk", "ኖቮሲቢሪስክ" },
            { "timezone.excity.Asia/Ulaanbaatar", "ኡላአንባአታር" },
            { "timezone.excity.Asia/Vladivostok", "ቭላዲቮስቶክ" },
            { "timezone.excity.Atlantic/Bermuda", "ቤርሙዳ" },
            { "timezone.excity.Atlantic/Madeira", "ማዴራ" },
            { "timezone.excity.Atlantic/Stanley", "ስታንሌይ" },
            { "timezone.excity.Australia/Darwin", "ዳርዊን" },
            { "timezone.excity.Australia/Hobart", "ሆባርት" },
            { "timezone.excity.Australia/Sydney", "ሲድኒ" },
            { "timezone.excity.Europe/Amsterdam", "አምስተርዳም" },
            { "timezone.excity.Europe/Astrakhan", "አስትራክሃን" },
            { "timezone.excity.Europe/Bucharest", "ቡካሬስት" },
            { "timezone.excity.Europe/Gibraltar", "ጂብራልታር" },
            { "timezone.excity.Europe/Ljubljana", "ልጁብልጃና" },
            { "timezone.excity.Europe/Mariehamn", "ሜሪሃምን" },
            { "timezone.excity.Europe/Podgorica", "ፖድጎሪካ" },
            { "timezone.excity.Europe/Stockholm", "ስቶክሆልም" },
            { "timezone.excity.Europe/Ulyanovsk", "ኡልያኖቭስክ" },
            { "timezone.excity.Europe/Volgograd", "ቮልጎራድ" },
            { "timezone.excity.Indian/Christmas", "ገና" },
            { "timezone.excity.Indian/Kerguelen", "ኬርጉለን" },
            { "timezone.excity.Indian/Mauritius", "ሞሪሽየስ" },
            { "timezone.excity.Pacific/Auckland", "ኦክላንድ" },
            { "timezone.excity.Pacific/Funafuti", "ፈናፉቲ" },
            { "timezone.excity.Pacific/Honolulu", "ሆኖሉሉ" },
            { "timezone.excity.Pacific/Pitcairn", "ፒትከይርን" },
            { "timezone.excity.Africa/Casablanca", "ካዛብላንካ" },
            { "timezone.excity.Africa/Libreville", "ሊበርቪል" },
            { "timezone.excity.Africa/Lubumbashi", "ሉቡምባሺ" },
            { "timezone.excity.Africa/Nouakchott", "ኑአክቾት" },
            { "timezone.excity.Africa/Porto-Novo", "ፖርቶ - ኖቮ" },
            { "timezone.excity.America/Anchorage", "አንኮራጅ" },
            { "timezone.excity.America/Araguaina", "አራጉየና" },
            { "timezone.excity.America/Boa_Vista", "ቦአ ቪስታ" },
            { "timezone.excity.America/Catamarca", "ካታማርካ" },
            { "timezone.excity.America/Chihuahua", "ቺሁዋውአ" },
            { "timezone.excity.America/Fortaleza", "ፎርታሌዛ" },
            { "timezone.excity.America/Glace_Bay", "ግሌስ ቤይ" },
            { "timezone.excity.America/Goose_Bay", "ጉዝ ቤይ" },
            { "timezone.excity.America/Guatemala", "ጓቲማላ" },
            { "timezone.excity.America/Guayaquil", "ጉያኩይል" },
            { "timezone.excity.America/Matamoros", "ማታሞሮስ" },
            { "timezone.excity.America/Menominee", "ሜኖሚኒ" },
            { "timezone.excity.America/Monterrey", "ሞንተርሬይ" },
            { "timezone.excity.America/Sao_Paulo", "ሳኦ ፖሎ" },
            { "timezone.excity.America/St_Thomas", "ቅዱስ ቶማስ" },
            { "timezone.excity.America/Vancouver", "ቫንኮቨር" },
            { "timezone.excity.Antarctica/Mawson", "ናውሰን" },
            { "timezone.excity.Antarctica/Palmer", "ፓልመር" },
            { "timezone.excity.Antarctica/Vostok", "ቭስቶክ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ኩዋላ ላምፑር" },
            { "timezone.excity.Asia/Novokuznetsk", "ኖቮኩትዝኔክ" },
            { "timezone.excity.Europe/Bratislava", "ብራቲስላቫ" },
            { "timezone.excity.Europe/Copenhagen", "ኮፐንሃገን" },
            { "timezone.excity.Europe/Luxembourg", "ሉክሰምበርግ" },
            { "timezone.excity.Europe/San_Marino", "ሳን ማሪኖ" },
            { "timezone.excity.Europe/Simferopol", "ሲምፈሮፖል" },
            { "timezone.excity.Pacific/Enderbury", "ካንቶን" },
            { "timezone.excity.Pacific/Galapagos", "ጋላፓጎስ" },
            { "timezone.excity.Pacific/Kwajalein", "ክዋጃሊን" },
            { "timezone.excity.Pacific/Marquesas", "ማርክዌሳስ" },
            { "timezone.excity.Pacific/Pago_Pago", "ፓጎ ፓጎ" },
            { "timezone.excity.Pacific/Rarotonga", "ራሮቶንጋ" },
            { "timezone.excity.Pacific/Tongatapu", "ቶንጋታፑ" },
            { "timezone.excity.Africa/Addis_Ababa", "አዲስ አበባ" },
            { "timezone.excity.Africa/Brazzaville", "ብራዛቪል" },
            { "timezone.excity.Africa/Ouagadougou", "ኡጋዱጉ" },
            { "timezone.excity.America/Costa_Rica", "ኮስታሪካ" },
            { "timezone.excity.America/Grand_Turk", "ግራንድ ተርክ" },
            { "timezone.excity.America/Guadeloupe", "ጕዳሉፕ" },
            { "timezone.excity.America/Hermosillo", "ኸርሞዚሎ" },
            { "timezone.excity.America/Kralendijk", "ክራለንዲይክ" },
            { "timezone.excity.America/Louisville", "ሊውስቪል" },
            { "timezone.excity.America/Martinique", "ማርቲኒክ" },
            { "timezone.excity.America/Metlakatla", "መትላካትላ" },
            { "timezone.excity.America/Montevideo", "ሞንቴቪድዮ" },
            { "timezone.excity.America/Montserrat", "ሞንትሴራት" },
            { "timezone.excity.America/Paramaribo", "ፓራማሪቦ" },
            { "timezone.excity.America/Rio_Branco", "ሪዮ ብራንኮ" },
            { "timezone.excity.America/St_Vincent", "ቅዱስ ቪንሰንት" },
            { "timezone.excity.America/Whitehorse", "ኋይትሆርስ" },
            { "timezone.excity.Antarctica/McMurdo", "ማክመርዶ" },
            { "timezone.excity.Antarctica/Rothera", "ሮቴራ" },
            { "timezone.excity.Asia/Srednekolymsk", "ስሬድኔስኮልምስክ" },
            { "timezone.excity.Asia/Yekaterinburg", "የካተሪንበርግ" },
            { "timezone.excity.Atlantic/Reykjavik", "ሬይክጃቪክ" },
            { "timezone.excity.Atlantic/St_Helena", "ቅድስት ሄለና" },
            { "timezone.excity.Australia/Adelaide", "አዴሌእድ" },
            { "timezone.excity.Australia/Brisbane", "ብሪስቤን" },
            { "timezone.excity.Australia/Lindeman", "ሊንድማን" },
            { "timezone.excity.Europe/Isle_of_Man", "አይስል ኦፍ ማን" },
            { "timezone.excity.Europe/Kaliningrad", "ካሊኒንግራድ" },
            { "timezone.excity.Pacific/Kiritimati", "ኪሪቲማቲ" },
            { "timezone.excity.Africa/Johannesburg", "ጆሃንስበርግ" },
            { "timezone.excity.America/El_Salvador", "ኤልሳልቫዶር" },
            { "timezone.excity.America/Fort_Nelson", "ፎርት ኔልሰን" },
            { "timezone.excity.America/Los_Angeles", "ሎስ አንጀለስ" },
            { "timezone.excity.America/Mexico_City", "ሜክሲኮ ከተማ" },
            { "timezone.excity.America/Porto_Velho", "ፔትሮ ቬልሆ" },
            { "timezone.excity.America/Puerto_Rico", "ፖርቶሪኮ" },
            { "timezone.excity.America/Tegucigalpa", "ቴጉሲጋልፓ" },
            { "timezone.excity.Arctic/Longyearbyen", "ሎንግይርባየን" },
            { "timezone.excity.Atlantic/Cape_Verde", "ኬፕ ቬርደ" },
            { "timezone.excity.Australia/Lord_Howe", "ሎርድ ሆዊ" },
            { "timezone.excity.Australia/Melbourne", "ሜልቦርን" },
            { "timezone.excity.Indian/Antananarivo", "አንታናናሪቮ" },
            { "timezone.excity.Pacific/Guadalcanal", "ጉዋዳልካናል" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ዳሬ ሰላም" },
            { "timezone.excity.America/Blanc-Sablon", "ብላንክ- ሳብሎን" },
            { "timezone.excity.America/Buenos_Aires", "ቦነስ አይረስ" },
            { "timezone.excity.America/Campo_Grande", "ካምፖ ግራንዴ" },
            { "timezone.excity.America/Danmarkshavn", "ዳንማርክሻቭን" },
            { "timezone.excity.America/Dawson_Creek", "ዳውሰን ክሬክ" },
            { "timezone.excity.America/Indiana/Knox", "ኖክስ, ኢንዲያና" },
            { "timezone.excity.America/Indianapolis", "ኢንዲያናፖሊስ" },
            { "timezone.excity.America/Punta_Arenas", "ፑንታ አሬናስ" },
            { "timezone.excity.America/Rankin_Inlet", "ራንኪን ኢንሌት" },
            { "timezone.excity.America/Scoresbysund", "ስኮርስባይሰንድ" },
            { "timezone.excity.Antarctica/Macquarie", "ማከሪ" },
            { "timezone.excity.Pacific/Bougainville", "ቦጌይንቪል" },
            { "timezone.excity.Pacific/Port_Moresby", "ፖርት ሞሬስባይ" },
            { "timezone.excity.America/Cambridge_Bay", "ካምብሪጅ ቤይ" },
            { "timezone.excity.America/Ciudad_Juarez", "ሳዮዳድ ሁዋሬዝ" },
            { "timezone.excity.America/Coral_Harbour", "አቲኮካን" },
            { "timezone.excity.America/Indiana/Vevay", "ቪቫይ, ኢንዲያና" },
            { "timezone.excity.America/Lower_Princes", "የታችኛው ልዑል ሩብ" },
            { "timezone.excity.America/Port_of_Spain", "የእስፔን ወደብ" },
            { "timezone.excity.America/Santo_Domingo", "ሳንቶ ዶሚንጎ" },
            { "timezone.excity.America/St_Barthelemy", "ቅድስት ቤርተሎሜ" },
            { "timezone.excity.America/Swift_Current", "የሐዋላ ገንዘብ" },
            { "timezone.excity.Australia/Broken_Hill", "ብሮክን ሂል" },
            { "timezone.excity.America/Bahia_Banderas", "ባሂያ ባንደራስ" },
            { "timezone.excity.America/Port-au-Prince", "ፖርት ኦ ፕሪንስ" },
            { "timezone.excity.Atlantic/South_Georgia", "ደቡብ ጆርጂያ" },
            { "timezone.excity.America/Argentina/Salta", "ሳልታ" },
            { "timezone.excity.America/Indiana/Marengo", "ማሬንጎ, ኢንዲያና" },
            { "timezone.excity.America/Indiana/Winamac", "ዊናማክ, ኢንዲያና" },
            { "timezone.excity.America/Argentina/Tucuman", "ቱኩማን" },
            { "timezone.excity.America/Argentina/Ushuaia", "ኡሹአኢ" },
            { "timezone.excity.America/Indiana/Tell_City", "ቴል ከተማ, ኢንዲያና" },
            { "timezone.excity.America/Indiana/Vincennes", "ቪንቼንስ, ኢንዲያና" },
            { "timezone.excity.Antarctica/DumontDUrville", "ደሞንት ዲኡርቪል" },
            { "timezone.excity.America/Argentina/La_Rioja", "ላ ሪኦጃ" },
            { "timezone.excity.America/Argentina/San_Juan", "ሳን ጁአን" },
            { "timezone.excity.America/Argentina/San_Luis", "ሳን ሊውስ" },
            { "timezone.excity.America/Indiana/Petersburg", "ፒተርስበርግ, ኢንዲያና" },
            { "timezone.excity.America/Kentucky/Monticello", "ሞንቲሴሎ, ኪንታኪ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ቤኡላህ, ሰሜን ዳኮታ" },
            { "timezone.excity.America/North_Dakota/Center", "መካከለኛ, ሰሜን ዳኮታ" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ሪዮ ጋሌጎስ" },
            { "timezone.excity.America/North_Dakota/New_Salem", "አዲስ ሳሌም, ሰሜን ዳኮታ" },
        };
        return data;
    }
}
