/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_uk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "за Гринвічем",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "час: Акрі, стандартний",
               "",
               "час: Акрі, літній",
               "",
               "час: Акрі",
               "",
            };
        final String[] Apia = new String[] {
               "за стандартним часом в Апіа",
               "",
               "за літнім часом в Апіа",
               "",
               "за часом в Апіа",
               "",
            };
        final String[] Cook = new String[] {
               "за стандартним часом на Островах Кука",
               "",
               "за літнім часом на Островах Кука",
               "",
               "за часом на Островах Кука",
               "",
            };
        final String[] Cuba = new String[] {
               "за стандартним часом на Кубі",
               "CST",
               "за літнім часом на Кубі",
               "CDT",
               "за часом на Кубі",
               "CT",
            };
        final String[] Fiji = new String[] {
               "за стандартним часом у Фіджі",
               "",
               "за літнім часом у Фіджі",
               "",
               "за часом у Фіджі",
               "",
            };
        final String[] Gulf = new String[] {
               "за часом Перської затоки",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "за стандартним часом у Ховді",
               "",
               "за літнім часом у Ховді",
               "",
               "за часом у Ховді",
               "",
            };
        final String[] Iran = new String[] {
               "за іранським стандартним часом",
               "",
               "за іранським літнім часом",
               "",
               "за іранським часом",
               "",
            };
        final String[] Niue = new String[] {
               "за часом на острові Ніуе",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "за омським стандартним часом",
               "",
               "за омським літнім часом",
               "",
               "за омським часом",
               "",
            };
        final String[] Peru = new String[] {
               "за стандартним часом у Перу",
               "",
               "за літнім часом у Перу",
               "",
               "за часом у Перу",
               "",
            };
        final String[] Truk = new String[] {
               "за часом на островах Чуук",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "за часом на острові Вейк",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "за стандартним чилійським часом",
               "",
               "за літнім чилійським часом",
               "",
               "за чилійським часом",
               "",
            };
        final String[] China = new String[] {
               "за китайським стандартним часом",
               "CST",
               "за китайським літнім часом",
               "CDT",
               "за китайським часом",
               "CT",
            };
        final String[] Cocos = new String[] {
               "за часом на Кокосових островах",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "за часом на станції Девіс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "за індійським стандартним часом",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "за японським стандартним часом",
               "JST",
               "за японським літнім часом",
               "JDT",
               "за японським часом",
               "JT",
            };
        final String[] Korea = new String[] {
               "за корейським стандартним часом",
               "KST",
               "за корейським літнім часом",
               "KST",
               "за корейським часом",
               "KST",
            };
        final String[] Nauru = new String[] {
               "за часом на острові Науру",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "за часом у Непалі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "за часом на острові Палау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "за стандартним часом на острові Самоа",
               "SST",
               "за літнім часом на острові Самоа",
               "SST",
               "за часом на острові Самоа",
               "SST",
            };
        final String[] Syowa = new String[] {
               "за часом на станції Сева",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "за стандартним часом на островах Тонга",
               "",
               "за літнім часом на островах Тонга",
               "",
               "за часом на островах Тонга",
               "",
            };
        final String[] Yukon = new String[] {
               "за стандартним часом на Юконі",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "за стандартним часом на Алясці",
               "AKST",
               "за літнім часом на Алясці",
               "AKDT",
               "за часом на Алясці",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "за стандартним часом на Амазонці",
               "",
               "за літнім часом на Амазонці",
               "",
               "за часом на Амазонці",
               "",
            };
        final String[] Anadyr = new String[] {
               "час: Анадир, стандартний",
               "",
               "час: Анадир, літній",
               "",
               "час: Анадир",
               "",
            };
        final String[] Azores = new String[] {
               "за стандартним часом на Азорських островах",
               "",
               "за літнім часом на Азорських островах",
               "",
               "за часом на Азорських островах",
               "",
            };
        final String[] Bhutan = new String[] {
               "за часом у Бутані",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "за часом у Брунеї",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "за стандартним часом на острові Пасхи",
               "",
               "за літнім часом на острові Пасхи",
               "",
               "за часом на острові Пасхи",
               "",
            };
        final String[] Guyana = new String[] {
               "за часом у Ґаяні",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "за ізраїльським стандартним часом",
               "IST",
               "за ізраїльським літнім часом",
               "IDT",
               "за ізраїльським часом",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "за часом на острові Косрае",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "за часом на станції Моусон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "за московським стандартним часом",
               "MSK",
               "за московським літнім часом",
               "MSK",
               "за московським часом",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "за часом на острові Понапе",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "за самарським стандартним часом",
               "",
               "за самарським літнім часом",
               "",
               "за самарським часом",
               "",
            };
        final String[] Tahiti = new String[] {
               "за часом на острові Таїті",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "за стандартним часом у Тайбеї",
               "CST",
               "за літнім часом у Тайбеї",
               "CDT",
               "за часом у Тайбеї",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "за часом на островах Тувалу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "за часом на станції Восток",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "за часом на островах Уолліс і Футуна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "за арабським стандартним часом",
               "",
               "за арабським літнім часом",
               "",
               "за арабським часом",
               "",
            };
        final String[] Armenia = new String[] {
               "за вірменським стандартним часом",
               "",
               "за вірменським літнім часом",
               "",
               "за вірменським часом",
               "",
            };
        final String[] Bolivia = new String[] {
               "за болівійським часом",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "за стандартним часом на архіпелазі Чатем",
               "",
               "за літнім часом на архіпелазі Чатем",
               "",
               "за часом на архіпелазі Чатем",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "за всесвітнім координованим часом",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "за часом в Еквадорі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "за часом на острові Ґамбʼє",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "за стандартним грузинським часом",
               "",
               "за літнім грузинським часом",
               "",
               "за грузинським часом",
               "",
            };
        final String[] Irkutsk = new String[] {
               "за іркутським стандартним часом",
               "",
               "за іркутським літнім часом",
               "",
               "за іркутським часом",
               "",
            };
        final String[] Magadan = new String[] {
               "за магаданським стандартним часом",
               "",
               "за магаданським літнім часом",
               "",
               "за магаданським часом",
               "",
            };
        final String[] Myanmar = new String[] {
               "за часом у Мʼянмі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "за стандартним часом на острові Норфолк",
               "",
               "за літнім часом на острові Норфолк",
               "",
               "за часом на острові Норфолк",
               "",
            };
        final String[] Noronha = new String[] {
               "за стандартним часом на архіпелазі Фернанду-ді-Норонья",
               "",
               "за літнім часом на архіпелазі Фернанду-ді-Норонья",
               "",
               "за часом на архіпелазі Фернанду-ді-Норонья",
               "",
            };
        final String[] Reunion = new String[] {
               "за часом на острові Реюньйон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "за часом на станції Ротера",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "за часом на Соломонових Островах",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "за часом на островах Токелау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "за стандартним часом в Уруґваї",
               "",
               "за літнім часом в Уруґваї",
               "",
               "за часом в Уруґваї",
               "",
            };
        final String[] Vanuatu = new String[] {
               "за стандартним часом на островах Вануату",
               "",
               "за літнім часом на островах Вануату",
               "",
               "за часом на островах Вануату",
               "",
            };
        final String[] Yakutsk = new String[] {
               "за якутським стандартним часом",
               "",
               "за якутським літнім часом",
               "",
               "за якутським часом",
               "",
            };
        final String[] Atlantic = new String[] {
               "за атлантичним стандартним часом",
               "AST",
               "за атлантичним літнім часом",
               "AST",
               "за атлантичним часом",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "за стандартним бразильським часом",
               "",
               "за літнім бразильським часом",
               "",
               "за бразильським часом",
               "",
            };
        final String[] Chamorro = new String[] {
               "за часом на Північних Маріанських островах",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "за стандартним колумбійським часом",
               "",
               "за літнім колумбійським часом",
               "",
               "за колумбійським часом",
               "",
            };
        final String[] Falkland = new String[] {
               "за стандартним часом на Фолклендських Островах",
               "",
               "за літнім часом на Фолклендських Островах",
               "",
               "за часом на Фолклендських Островах",
               "",
            };
        final String[] Malaysia = new String[] {
               "за часом у Малайзії",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "за часом на Мальдівах",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "за стандартним часом в Улан-Баторі",
               "",
               "за літнім часом в Улан-Баторі",
               "",
               "за часом в Улан-Баторі",
               "",
            };
        final String[] Pakistan = new String[] {
               "за стандартним часом у Пакистані",
               "PKT",
               "за літнім часом у Пакистані",
               "PKST",
               "за часом у Пакистані",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "за стандартним параґвайським часом",
               "",
               "за літнім параґвайським часом",
               "",
               "за параґвайським часом",
               "",
            };
        final String[] Pitcairn = new String[] {
               "за часом на островах Піткерн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "за сахалінським стандартним часом",
               "",
               "за сахалінським літнім часом",
               "",
               "за сахалінським часом",
               "",
            };
        final String[] Suriname = new String[] {
               "за часом у Суринамі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "за стандартним аргентинським часом",
               "",
               "за літнім аргентинським часом",
               "",
               "за аргентинським часом",
               "",
            };
        final String[] Christmas = new String[] {
               "за часом на острові Різдва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "за часом Ґалапаґосу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "за стандартним часом у Гонконзі",
               "HKT",
               "за літнім часом у Гонконзі",
               "HKST",
               "за часом у Гонконзі",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "за часом в Індокитаї",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "за камчатським стандартним часом",
               "",
               "за камчатським літнім часом",
               "",
               "за камчатським часом",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "за часом у Киргизстані",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "за стандартним часом на острові Лорд-Хау",
               "",
               "за літнім часом на острові Лорд-Хау",
               "",
               "за часом на острові Лорд-Хау",
               "",
            };
        final String[] Marquesas = new String[] {
               "за часом на Маркізьких островах",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "за стандартним часом на острові Маврикій",
               "",
               "за літнім часом на острові Маврикій",
               "",
               "за часом на острові Маврикій",
               "",
            };
        final String[] Singapore = new String[] {
               "за часом у Сінгапурі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "за часом у Венесуелі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "за волгоградським стандартним часом",
               "MSK",
               "за волгоградським літнім часом",
               "MSK",
               "за волгоградським часом",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "за стандартним азербайджанським часом",
               "",
               "за літнім азербайджанським часом",
               "",
               "за азербайджанським часом",
               "",
            };
        final String[] Bangladesh = new String[] {
               "за стандартним часом у Бангладеш",
               "",
               "за літнім часом у Бангладеш",
               "",
               "за часом у Бангладеш",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "за стандартним часом на островах Кабо-Верде",
               "",
               "за літнім часом на островах Кабо-Верде",
               "",
               "за часом на островах Кабо-Верде",
               "",
            };
        final String[] East_Timor = new String[] {
               "за часом у Східному Тиморі",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "за часом у Казахстані",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "за часом на Сейшельських Островах",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "за часом у Таджикистані",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "за стандартним часом в Узбекистані",
               "",
               "за літнім часом в Узбекистані",
               "",
               "за часом в Узбекистані",
               "",
            };
        final String[] Afghanistan = new String[] {
               "за часом в Афганістані",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "за красноярським стандартним часом",
               "",
               "за красноярським літнім часом",
               "",
               "за красноярським часом",
               "",
            };
        final String[] New_Zealand = new String[] {
               "за стандартним часом у Новій Зеландії",
               "NZST",
               "за літнім часом у Новій Зеландії",
               "NZDT",
               "за часом у Новій Зеландії",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "за новосибірським стандартним часом",
               "",
               "за новосибірським літнім часом",
               "",
               "за новосибірським часом",
               "",
            };
        final String[] Philippines = new String[] {
               "за стандартним часом на Філіппінах",
               "PST",
               "за літнім часом на Філіппінах",
               "PDT",
               "за часом на Філіппінах",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "за владивостоцьким стандартним часом",
               "",
               "за владивостоцьким літнім часом",
               "",
               "за владивостоцьким часом",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "за часом в Індійському Океані",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "за часом на острові Лайн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "за стандартним часом на острові Ньюфаундленд",
               "NST",
               "за літнім часом у Ньюфаундленд",
               "NDT",
               "за часом на острові Ньюфаундленд",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "за стандартним часом у Туркменістані",
               "",
               "за літнім часом у Туркменістані",
               "",
               "за часом у Туркменістані",
               "",
            };
        final String[] French_Guiana = new String[] {
               "за часом Французької Ґвіани",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "за стандартним часом на островах Нової Каледонії",
               "",
               "за літнім часом на островах Нової Каледонії",
               "",
               "за часом на островах Нової Каледонії",
               "",
            };
        final String[] South_Georgia = new String[] {
               "за часом на острові Південна Джорджія",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "за єкатеринбурзьким стандартним часом",
               "",
               "за єкатеринбурзьким літнім часом",
               "",
               "за єкатеринбурзьким часом",
               "",
            };
        final String[] Africa_Central = new String[] {
               "за центральноафриканським часом",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "за східноафриканським часом",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "за західноафриканським стандартним часом",
               "WAT",
               "за західноафриканським літнім часом",
               "WAT",
               "за західноафриканським часом",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "за часом на станції Дюмон дʼЮрвіль",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "за центральноєвропейським стандартним часом",
               "CET",
               "за центральноєвропейським літнім часом",
               "CEST",
               "за центральноєвропейським часом",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "за східноєвропейським стандартним часом",
               "EET",
               "за східноєвропейським літнім часом",
               "EEST",
               "за східноєвропейським часом",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "за західноєвропейським стандартним часом",
               "WET",
               "за західноєвропейським літнім часом",
               "WEST",
               "за західноєвропейським часом",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "за стандартним тихоокеанським часом у Мексиці",
               "MST",
               "за літнім тихоокеанським часом у Мексиці",
               "MDT",
               "за тихоокеанським часом у Мексиці",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "за південноафриканським часом",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "за північноамериканським центральним стандартним часом",
               "CST",
               "за північноамериканським центральним літнім часом",
               "CDT",
               "за північноамериканським центральним часом",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "за північноамериканським східним стандартним часом",
               "EST",
               "за північноамериканським східним літнім часом",
               "EST",
               "за північноамериканським східним часом",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "за північноамериканським тихоокеанським стандартним часом",
               "PST",
               "за північноамериканським тихоокеанським літнім часом",
               "PDT",
               "за північноамериканським тихоокеанським часом",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "за часом на Французьких Південних і Антарктичних територіях",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "за часом на островах Гілберта",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "за стандартним гавайсько-алеутським часом",
               "HST",
               "за літнім гавайсько-алеутським часом",
               "HST",
               "за гавайсько-алеутським часом",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "за часом на островах Фенікс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "за стандартним часом на островах Сен-П’єр і Мікелон",
               "",
               "за літнім часом на островах Сен-П’єр і Мікелон",
               "",
               "за часом на островах Сен-П’єр і Мікелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "за північноамериканським гірським стандартним часом",
               "MST",
               "за північноамериканським гірським літнім часом",
               "MST",
               "за північноамериканським гірським часом",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "за часом на Маршаллових Островах",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "за часом на островах Папуа-Нова Ґвінея",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "за стандартним центральноавстралійським часом",
               "ACST",
               "за літнім центральноавстралійським часом",
               "ACDT",
               "за центральноавстралійським часом",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "за стандартним східноавстралійським часом",
               "AEST",
               "за літнім східноавстралійським часом",
               "AEDT",
               "за східноавстралійським часом",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "за стандартним західноавстралійським часом",
               "AWST",
               "за літнім західноавстралійським часом",
               "AWDT",
               "за західноавстралійським часом",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "за центральноіндонезійським часом",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "за східноіндонезійським часом",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "за західноіндонезійським часом",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "за стандартним центральнозахідним австралійським часом",
               "",
               "за літнім центральнозахідним австралійським часом",
               "",
               "за центральнозахідним австралійським часом",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "за всесвітнім координованим часом",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом в Ірландії",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "за всесвітнім координованим часом",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "за всесвітнім координованим часом",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "за всесвітнім координованим часом",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "за всесвітнім координованим часом",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "за всесвітнім координованим часом",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом в Ірландії",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "за Гринвічем",
                    "GMT",
                    "за літнім часом у Великій Британії",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Ділі" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омськ" },
            { "timezone.excity.Asia/Oral", "Орал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Амман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дакка" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токіо" },
            { "timezone.excity.Asia/Tomsk", "Томськ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Джуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алмати" },
            { "timezone.excity.Asia/Anadyr", "Анадир" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атирау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеврон" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Маніла" },
            { "timezone.excity.Asia/Muscat", "Маскат" },
            { "timezone.excity.Asia/Riyadh", "Ер-Ріяд" },
            { "timezone.excity.Asia/Saigon", "Хошимін" },
            { "timezone.excity.Asia/Taipei", "Тайбей" },
            { "timezone.excity.Asia/Tehran", "Тегеран" },
            { "timezone.excity.Asia/Urumqi", "Урумчі" },
            { "timezone.excity.Etc/Unknown", "Невідоме місто" },
            { "timezone.excity.Europe/Kiev", "Київ" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Махе" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "Каїр" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лаґос" },
            { "timezone.excity.Africa/Tunis", "Туніс" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Ліма" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бішкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Іркутськ" },
            { "timezone.excity.Asia/Jakarta", "Джакарта" },
            { "timezone.excity.Asia/Karachi", "Карачі" },
            { "timezone.excity.Asia/Kuching", "Кучинг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Нікосія" },
            { "timezone.excity.Asia/Rangoon", "Янгон" },
            { "timezone.excity.Asia/Tbilisi", "Тбілісі" },
            { "timezone.excity.Asia/Thimphu", "Тхімпху" },
            { "timezone.excity.Asia/Yakutsk", "Якутськ" },
            { "timezone.excity.Asia/Yerevan", "Єреван" },
            { "timezone.excity.Europe/Kirov", "Кіров" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Мінськ" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "Софія" },
            { "timezone.excity.Europe/Vaduz", "Вадуц" },
            { "timezone.excity.Indian/Cocos", "Кокосові острови" },
            { "timezone.excity.Pacific/Apia", "Апіа" },
            { "timezone.excity.Pacific/Fiji", "Фіджі" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ніуе" },
            { "timezone.excity.Pacific/Truk", "Чуук" },
            { "timezone.excity.Pacific/Wake", "Вейк" },
            { "timezone.excity.Africa/Asmera", "Асмера" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Банґі" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Бісау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кігалі" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуту" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ніамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Байя" },
            { "timezone.excity.America/Belem", "Белен" },
            { "timezone.excity.America/Boise", "Бойсе" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Сітка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашгабат" },
            { "timezone.excity.Asia/Calcutta", "Колката" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Джайпур" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандига" },
            { "timezone.excity.Asia/Makassar", "Макассар" },
            { "timezone.excity.Asia/Qostanay", "Костанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалін" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Усть-Нера" },
            { "timezone.excity.Europe/Athens", "Афіни" },
            { "timezone.excity.Europe/Berlin", "Берлін" },
            { "timezone.excity.Europe/Dublin", "Дублін" },
            { "timezone.excity.Europe/Jersey", "Джерсі" },
            { "timezone.excity.Europe/Lisbon", "Лісабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопʼє" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Відень" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюріх" },
            { "timezone.excity.Indian/Chagos", "Чаґос" },
            { "timezone.excity.Indian/Comoro", "Комори" },
            { "timezone.excity.Pacific/Efate", "Ефате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абіджан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакрі" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найробі" },
            { "timezone.excity.Africa/Tripoli", "Триполі" },
            { "timezone.excity.America/Belize", "Беліз" },
            { "timezone.excity.America/Bogota", "Боґота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайманові Острови" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Ґайана" },
            { "timezone.excity.America/Havana", "Гавана" },
            { "timezone.excity.America/Inuvik", "Інувік" },
            { "timezone.excity.America/Juneau", "Джуно" },
            { "timezone.excity.America/La_Paz", "Ла-Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Меріда" },
            { "timezone.excity.America/Nassau", "Насау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресіфі" },
            { "timezone.excity.America/Regina", "Реджайна" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Гонконг" },
            { "timezone.excity.Asia/Jerusalem", "Єрусалим" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Понтіанак" },
            { "timezone.excity.Asia/Pyongyang", "Пхеньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кизилорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сінгапур" },
            { "timezone.excity.Asia/Vientiane", "Вʼєнтьян" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллінн" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вільнюс" },
            { "timezone.excity.Indian/Mayotte", "Майотта" },
            { "timezone.excity.Indian/Reunion", "Реюньйон" },
            { "timezone.excity.Pacific/Easter", "Острів Пасхи" },
            { "timezone.excity.Pacific/Kanton", "Кантон" },
            { "timezone.excity.Pacific/Kosrae", "Косрае" },
            { "timezone.excity.Pacific/Majuro", "Маджуро" },
            { "timezone.excity.Pacific/Midway", "Мідвей" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понапе" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таїті" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уолліс" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Джібуті" },
            { "timezone.excity.Africa/El_Aaiun", "Ель-Аюн" },
            { "timezone.excity.Africa/Freetown", "Фрітаун" },
            { "timezone.excity.Africa/Gaborone", "Ґабороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Кіншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровія" },
            { "timezone.excity.Africa/Ndjamena", "Нджамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Томе" },
            { "timezone.excity.Africa/Windhoek", "Віндгук" },
            { "timezone.excity.America/Antigua", "Антиґуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Каєнна" },
            { "timezone.excity.America/Chicago", "Чікаґо" },
            { "timezone.excity.America/Cordoba", "Кордова" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нуук" },
            { "timezone.excity.America/Grenada", "Ґренада" },
            { "timezone.excity.America/Halifax", "Галіфакс" },
            { "timezone.excity.America/Iqaluit", "Ікалуїт" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манаґуа" },
            { "timezone.excity.America/Marigot", "Маріґо" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норонья" },
            { "timezone.excity.America/Ojinaga", "Охінаґа" },
            { "timezone.excity.America/Phoenix", "Фінікс" },
            { "timezone.excity.America/Tijuana", "Тіхуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпень" },
            { "timezone.excity.Atlantic/Azores", "Азорські острови" },
            { "timezone.excity.Atlantic/Canary", "Канарські острови" },
            { "timezone.excity.Atlantic/Faeroe", "Фарерські острови" },
            { "timezone.excity.Australia/Eucla", "Евкла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бюзінген" },
            { "timezone.excity.Europe/Chisinau", "Кишинів" },
            { "timezone.excity.Europe/Guernsey", "Гернсі" },
            { "timezone.excity.Europe/Helsinki", "Гельсінкі" },
            { "timezone.excity.Europe/Istanbul", "Стамбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараєво" },
            { "timezone.excity.Indian/Maldives", "Мальдіви" },
            { "timezone.excity.Pacific/Chatham", "Чатем" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбʼє" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Моґадішо" },
            { "timezone.excity.America/Anguilla", "Анґілья" },
            { "timezone.excity.America/Asuncion", "Асунсьйон" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Домініка" },
            { "timezone.excity.America/Edmonton", "Едмонтон" },
            { "timezone.excity.America/Eirunepe", "Ейрунепе" },
            { "timezone.excity.America/Mazatlan", "Масатлан" },
            { "timezone.excity.America/Miquelon", "Мікелон" },
            { "timezone.excity.America/New_York", "Нью-Йорк" },
            { "timezone.excity.America/Resolute", "Резольют" },
            { "timezone.excity.America/Santarem", "Сантарен" },
            { "timezone.excity.America/Santiago", "Сантьяґо" },
            { "timezone.excity.America/St_Johns", "Сент-Джонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Кіттс" },
            { "timezone.excity.America/St_Lucia", "Сент-Люсія" },
            { "timezone.excity.America/Winnipeg", "Вінніпеґ" },
            { "timezone.excity.Antarctica/Casey", "Кейсі" },
            { "timezone.excity.Antarctica/Davis", "Девіс" },
            { "timezone.excity.Antarctica/Syowa", "Сьова" },
            { "timezone.excity.Antarctica/Troll", "Тролл" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярськ" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибірськ" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермуди" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стенлі" },
            { "timezone.excity.Australia/Darwin", "Дарвін" },
            { "timezone.excity.Australia/Hobart", "Гобарт" },
            { "timezone.excity.Australia/Sydney", "Сідней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гібралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Марієгамн" },
            { "timezone.excity.Europe/Podgorica", "Подгориця" },
            { "timezone.excity.Europe/Stockholm", "Стокгольм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульянівськ" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Острів Різдва" },
            { "timezone.excity.Indian/Kerguelen", "Керґелен" },
            { "timezone.excity.Indian/Mauritius", "Маврикій" },
            { "timezone.excity.Pacific/Auckland", "Окленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафуті" },
            { "timezone.excity.Pacific/Honolulu", "Гонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Піткерн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Лібревіль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаші" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшотт" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкоридж" },
            { "timezone.excity.America/Araguaina", "Араґуаіна" },
            { "timezone.excity.America/Boa_Vista", "Боа-Віста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чіуауа" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Ґлейс-Бей" },
            { "timezone.excity.America/Goose_Bay", "Ґус-Бей" },
            { "timezone.excity.America/Guatemala", "Ґватемала" },
            { "timezone.excity.America/Guayaquil", "Ґуаякіль" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меноміні" },
            { "timezone.excity.America/Monterrey", "Монтерей" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паулу" },
            { "timezone.excity.America/St_Thomas", "Сент-Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моусон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала-Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецьк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марино" },
            { "timezone.excity.Europe/Simferopol", "Сімферополь" },
            { "timezone.excity.Pacific/Enderbury", "Ендербері" },
            { "timezone.excity.Pacific/Galapagos", "Ґалапаґос" },
            { "timezone.excity.Pacific/Kwajalein", "Кваджалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркізькі острови" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго-Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавіль" },
            { "timezone.excity.Africa/Ouagadougou", "Уаґадуґу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Ріка" },
            { "timezone.excity.America/Grand_Turk", "Ґранд-Терк" },
            { "timezone.excity.America/Guadeloupe", "Ґваделупа" },
            { "timezone.excity.America/Hermosillo", "Ермосільйо" },
            { "timezone.excity.America/Kralendijk", "Кралендейк" },
            { "timezone.excity.America/Louisville", "Луїсвілл" },
            { "timezone.excity.America/Martinique", "Мартініка" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевідео" },
            { "timezone.excity.America/Montserrat", "Монтсеррат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Ріо-Бранко" },
            { "timezone.excity.America/St_Vincent", "Сент-Вінсент" },
            { "timezone.excity.America/Whitehorse", "Вайтгорс" },
            { "timezone.excity.Antarctica/McMurdo", "Мак-Мердо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Середньоколимськ" },
            { "timezone.excity.Asia/Yekaterinburg", "Єкатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкʼявік" },
            { "timezone.excity.Atlantic/St_Helena", "Острів Святої Єлени" },
            { "timezone.excity.Australia/Adelaide", "Аделаїда" },
            { "timezone.excity.Australia/Brisbane", "Брісбен" },
            { "timezone.excity.Australia/Lindeman", "Ліндеман" },
            { "timezone.excity.Europe/Isle_of_Man", "Острів Мен" },
            { "timezone.excity.Europe/Kaliningrad", "Калінінград" },
            { "timezone.excity.Pacific/Kiritimati", "Кірітіматі" },
            { "timezone.excity.Africa/Johannesburg", "Йоганнесбурґ" },
            { "timezone.excity.America/El_Salvador", "Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нельсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анджелес" },
            { "timezone.excity.America/Mexico_City", "Мехіко" },
            { "timezone.excity.America/Porto_Velho", "Порту-Велью" },
            { "timezone.excity.America/Puerto_Rico", "Пуерто-Ріко" },
            { "timezone.excity.America/Tegucigalpa", "Теґусіґальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгʼїр" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо-Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд-Хау" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананаріву" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-ес-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Блан-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буенос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампу-Ґранді" },
            { "timezone.excity.America/Danmarkshavn", "Денмарксхавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон-Крік" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Індіана" },
            { "timezone.excity.America/Indianapolis", "Індіанаполіс" },
            { "timezone.excity.America/Punta_Arenas", "Пунта-Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ренкін-Інлет" },
            { "timezone.excity.America/Scoresbysund", "Іттоккортоорміут" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуорі" },
            { "timezone.excity.Pacific/Bougainville", "Буґенвіль" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт-Морсбі" },
            { "timezone.excity.America/Cambridge_Bay", "Кеймбрідж-Бей" },
            { "timezone.excity.America/Ciudad_Juarez", "С’юдад-Хуарес" },
            { "timezone.excity.America/Coral_Harbour", "Атікокан" },
            { "timezone.excity.America/Indiana/Vevay", "Вівей, Індіана" },
            { "timezone.excity.America/Lower_Princes", "Лоуер-Принсес-Квотер" },
            { "timezone.excity.America/Port_of_Spain", "Порт-оф-Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санто-Домінґо" },
            { "timezone.excity.America/St_Barthelemy", "Сен-Бартелемі" },
            { "timezone.excity.America/Swift_Current", "Свіфт-Каррент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен-Хілл" },
            { "timezone.excity.America/Bahia_Banderas", "Баїя Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Південна Джорджія" },
            { "timezone.excity.America/Argentina/Salta", "Сальта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Індіана" },
            { "timezone.excity.America/Indiana/Winamac", "Вінамак, Індіана" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуая" },
            { "timezone.excity.America/Indiana/Tell_City", "Телл-Сіті, Індіана" },
            { "timezone.excity.America/Indiana/Vincennes", "Вінсенс, Індіана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон-дʼЮрвіль" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Ріоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан-Луїс" },
            { "timezone.excity.America/Indiana/Petersburg", "Пітерсберг, Індіана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтіселло, Кентуккі" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бʼюла, Північна Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Сентр, Північна Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Ріо-Ґальєґос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Салем, Північна Дакота" },
        };
        return data;
    }
}
