/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_tk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grinwiç ortaça wagty",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia standart wagty",
               "",
               "Apia tomusky wagty",
               "",
               "Apia wagty",
               "",
            };
        final String[] Cook = new String[] {
               "Kuk adalary standart wagty",
               "",
               "Kuk adalary tomusky wagty",
               "",
               "Kuk adalary wagty",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba standart wagty",
               "CST",
               "Kuba tomusky wagty",
               "CDT",
               "Kuba wagty",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji standart wagty",
               "",
               "Fiji tomusky wagty",
               "",
               "Fiji wagty",
               "",
            };
        final String[] Gulf = new String[] {
               "Pars aýlagy standart wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Howd standart wagty",
               "",
               "Howd tomusky wagty",
               "",
               "Howd wagty",
               "",
            };
        final String[] Iran = new String[] {
               "Eýran standart wagty",
               "",
               "Eýran tomusky wagty",
               "",
               "Eýran wagty",
               "",
            };
        final String[] Niue = new String[] {
               "Niue wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk standart wagty",
               "",
               "Omsk tomusky wagty",
               "",
               "Omsk wagty",
               "",
            };
        final String[] Peru = new String[] {
               "Peru standart wagty",
               "",
               "Peru tomusky wagty",
               "",
               "Peru wagty",
               "",
            };
        final String[] Truk = new String[] {
               "Çuuk wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Weýk adasy wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Çili standart wagty",
               "",
               "Çili tomusky wagty",
               "",
               "Çili wagty",
               "",
            };
        final String[] China = new String[] {
               "Hytaý standart wagty",
               "CST",
               "Hytaý tomusky wagty",
               "CDT",
               "Hytaý wagty",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokos adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Deýwis wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hindistan standart wagty",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ýaponiýa standart wagty",
               "JST",
               "Ýaponiýa tomusky wagty",
               "JDT",
               "Ýaponiýa wagty",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreýa standart wagty",
               "KST",
               "Koreýa tomusky wagty",
               "KST",
               "Koreýa wagty",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa standart wagty",
               "SST",
               "Samoa tomusky wagty",
               "SST",
               "Samoa wagty",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Sýowa wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga standart wagty",
               "",
               "Tonga tomusky wagty",
               "",
               "Tonga wagty",
               "",
            };
        final String[] Yukon = new String[] {
               "Ýukon wagty",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alýaska standart wagty",
               "AKST",
               "Alýaska tomusky wagty",
               "AKDT",
               "Alýaska wagty",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon standart wagty",
               "",
               "Amazon tomusky wagty",
               "",
               "Amazon wagty",
               "",
            };
        final String[] Anadyr = new String[] {
               "",
               "",
               "",
               "",
               "Anadyr wagty",
               "",
            };
        final String[] Azores = new String[] {
               "Azor adalary standart wagty",
               "",
               "Azor adalary tomusky wagty",
               "",
               "Azor adalary wagty",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneý-Darussalam wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Pasha adasy standart wagty",
               "",
               "Pasha adasy tomusky wagty",
               "",
               "Pasha adasy wagty",
               "",
            };
        final String[] Guyana = new String[] {
               "Gaýana wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ysraýyl standart wagty",
               "IST",
               "Ysraýyl tomusky wagty",
               "IDT",
               "Ysraýyl wagty",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraýe wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mouson wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskwa standart wagty",
               "MSK",
               "Moskwa tomusky wagty",
               "MSK",
               "Moskwa wagty",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "",
               "",
               "",
               "",
               "Samara wagty",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taýbeý standart wagty",
               "CST",
               "Taýbeý tomusky wagty",
               "CDT",
               "Taýbeý wagty",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuwalu wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostok wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Uollis we Futuna wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arap ýurtlary standart wagty",
               "",
               "Arap ýurtlary tomusky wagty",
               "",
               "Arap ýurtlary wagty",
               "",
            };
        final String[] Armenia = new String[] {
               "Ermenistan standart wagty",
               "",
               "Ermenistan tomusky wagty",
               "",
               "Ermenistan wagty",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliwiýa wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Çatem standart wagty",
               "",
               "Çatem tomusky wagty",
               "",
               "Çatem wagty",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Utgaşdyrylýan ähliumumy wagt",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekwador wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambýe wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruziýa standart wagty",
               "",
               "Gruziýa tomusky wagty",
               "",
               "Gruziýa wagty",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk standart wagty",
               "",
               "Irkutsk tomusky wagty",
               "",
               "Irkutsk wagty",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan standart wagty",
               "",
               "Magadan tomusky wagty",
               "",
               "Magadan wagty",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mýanma wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk adasy standart wagty",
               "",
               "Norfolk adasy tomusky wagty",
               "",
               "Norfolk adasy wagty",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernandu-di-Noronýa standart wagty",
               "",
               "Fernandu-di-Noronýa tomusky wagty",
               "",
               "Fernandu-di-Noronýa wagty",
               "",
            };
        final String[] Reunion = new String[] {
               "Reýunýon wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugwaý standart wagty",
               "",
               "Urugwaý tomusky wagty",
               "",
               "Urugwaý wagty",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Wanuatu standart wagty",
               "",
               "Wanuatu tomusky wagty",
               "",
               "Wanuatu wagty",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ýakutsk standart wagty",
               "",
               "Ýakutsk tomusky wagty",
               "",
               "Ýakutsk wagty",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik standart wagty",
               "AST",
               "Atlantik tomusky wagty",
               "AST",
               "Atlantik wagty",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Braziliýa standart wagty",
               "",
               "Braziliýa tomusky wagty",
               "",
               "Braziliýa wagty",
               "",
            };
        final String[] Chamorro = new String[] {
               "Çamorro wagty",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbiýa standart wagty",
               "",
               "Kolumbiýa tomusky wagty",
               "",
               "Kolumbiýa wagty",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklend adalary standart wagty",
               "",
               "Folklend adalary tomusky wagty",
               "",
               "Folklend adalary wagty",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaýziýa wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldiwler wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Bator standart wagty",
               "",
               "Ulan-Bator tomusky wagty",
               "",
               "Ulan-Bator wagty",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan standart wagty",
               "PKT",
               "Pakistan tomusky wagty",
               "PKST",
               "Pakistan wagty",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragwaý standart wagty",
               "",
               "Paragwaý tomusky wagty",
               "",
               "Paragwaý wagty",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalin standart wagty",
               "",
               "Sahalin tomusky wagty",
               "",
               "Sahalin wagty",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina standart wagty",
               "",
               "Argentina tomusky wagty",
               "",
               "Argentina wagty",
               "",
            };
        final String[] Christmas = new String[] {
               "Roždestwo adasy wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Gonkong standart wagty",
               "HKT",
               "Gonkong tomusky wagty",
               "HKST",
               "Gonkong wagty",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hindihytaý wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "",
               "",
               "",
               "",
               "Petropavlowsk-Kamçatskiý wagty",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Gyrgyzystan wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Hau standart wagty",
               "",
               "Lord-Hau tomusky wagty",
               "",
               "Lord-Hau wagty",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiz adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mawrikiý standart wagty",
               "",
               "Mawrikiý tomusky wagty",
               "",
               "Mawrikiý wagty",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wenesuela wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd standart wagty",
               "MSK",
               "Wolgograd tomusky wagty",
               "MSK",
               "Wolgograd wagty",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaýjan standart wagty",
               "",
               "Azerbaýjan tomusky wagty",
               "",
               "Azerbaýjan wagty",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeş standart wagty",
               "",
               "Bangladeş tomusky wagty",
               "",
               "Bangladeş wagty",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kabo-Werde standart wagty",
               "",
               "Kabo-Werde tomusky wagty",
               "",
               "Kabo-Werde wagty",
               "",
            };
        final String[] East_Timor = new String[] {
               "Gündogar Timor wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Gazagystan wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seýşel adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Täjigistan wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Özbegistan standart wagty",
               "",
               "Özbegistan tomusky wagty",
               "",
               "Özbegistan wagty",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Owganystan wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoýarsk standart wagty",
               "",
               "Krasnoýarsk tomusky wagty",
               "",
               "Krasnoýarsk wagty",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Täze Zelandiýa standart wagty",
               "NZST",
               "Täze Zelandiýa tomusky wagty",
               "NZDT",
               "Täze Zelandiýa wagty",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirsk standart wagty",
               "",
               "Nowosibisk tomusky wagty",
               "",
               "Nowosibirsk wagty",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippinler standart wagty",
               "PST",
               "Filippinler tomusky wagty",
               "PDT",
               "Filippinler wagty",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok standart wagty",
               "",
               "Wladiwostok tomusky wagty",
               "",
               "Wladiwostok wagty",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hindi ummany wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Laýn adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Nýufaundlend standart wagty",
               "NST",
               "Nýufaundlend tomusky wagty",
               "NDT",
               "Nýufaundlend wagty",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Türkmenistan standart wagty",
               "",
               "Türkmenistan tomusky wagty",
               "",
               "Türkmenistan wagty",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Fransuz Gwianasy wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Täze Kaledoniýa standart wagty",
               "",
               "Täze Kaledoniýa tomusky wagty",
               "",
               "Täze Kaledoniýa wagty",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Günorta Georgiýa wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ýekaterinburg standart wagty",
               "",
               "Ýekaterinburg tomusky wagty",
               "",
               "Ýekaterinburg wagty",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Merkezi Afrika wagty",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Gündogar Afrika wagty",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Günbatar Afrika standart wagty",
               "WAT",
               "Günbatar Afrika tomusky wagty",
               "WAT",
               "Günbatar Afrika wagty",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dýumon-d-Ýurwil wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Merkezi Ýewropa standart wagty",
               "CET",
               "Merkezi Ýewropa tomusky wagty",
               "CEST",
               "Merkezi Ýewropa wagty",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Gündogar Ýewropa standart wagty",
               "EET",
               "Gündogar Ýewropa tomusky wagty",
               "EEST",
               "Gündogar Ýewropa wagty",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Günbatar Ýewropa standart wagty",
               "WET",
               "Günbatar Ýewropa tomusky wagty",
               "WEST",
               "Günbatar Ýewropa wagty",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikan Ýuwaş umman standart wagty",
               "MST",
               "Meksikan Ýuwaş umman tomusky wagty",
               "MDT",
               "Meksikan Ýuwaş umman wagty",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Günorta Afrika standart wagty",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Merkezi Amerika standart wagty",
               "CST",
               "Merkezi Amerika tomusky wagty",
               "CDT",
               "Merkezi Amerika",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Demirgazyk Amerika gündogar standart wagty",
               "EST",
               "Demirgazyk Amerika gündogar tomusky wagty",
               "EST",
               "Demirgazyk Amerika gündogar wagty",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Demirgazyk Amerika Ýuwaş umman standart wagty",
               "PST",
               "Demirgazyk Amerika Ýuwaş umman tomusky wagty",
               "PDT",
               "Demirgazyk Amerika Ýuwaş umman wagty",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Fransuz Günorta we Antarktika ýerleri wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Gawaý-Aleut standart wagty",
               "HST",
               "Gawaý-Aleut tomusky wagty",
               "HST",
               "Gawaý-Aleut wagty",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen-Pýer we Mikelon standart wagty",
               "",
               "Sen-Pýer we Mikelon tomusky wagty",
               "",
               "Sen-Pýer we Mikelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Demirgazyk Amerika dag standart wagty",
               "MST",
               "Demirgazyk Amerika dag tomusky wagty",
               "MST",
               "Demirgazyk Amerika dag wagty",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marşall adalary wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua - Täze Gwineýa wagty",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Merkezi Awstraliýa standart wagty",
               "ACST",
               "Merkezi Awstraliýa tomusky wagty",
               "ACDT",
               "Merkezi Awstraliýa wagty",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Gündogar Awstraliýa standart wagty",
               "AEST",
               "Gündogar Awstraliýa tomusky wagty",
               "AEDT",
               "Gündogar Awstraliýa wagty",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Günbatar Awstraliýa standart wagty",
               "AWST",
               "Günbatar Awstraliýa tomusky wagty",
               "AWDT",
               "Günbatar Awstraliýa wagty",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Merkezi Indoneziýa wagty",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Gündogar Indoneziýa wagty",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Günbatar Indoneziýa wagty",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Merkezi Awstraliýa günbatar standart wagty",
               "",
               "Merkezi Awstraliýa günbatar tomusky wagty",
               "",
               "Merkezi Awstraliýa günbatar wagty",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Utgaşdyrylýan ähliumumy wagt",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Irlandiýa standart wagty",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Utgaşdyrylýan ähliumumy wagt",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Utgaşdyrylýan ähliumumy wagt",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Utgaşdyrylýan ähliumumy wagt",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Utgaşdyrylýan ähliumumy wagt",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Utgaşdyrylýan ähliumumy wagt",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Irlandiýa standart wagty",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Grinwiç ortaça wagty",
                    "GMT",
                    "Beýik Britaniýa tomusky wagty",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Hovd", "Howd" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Çita" },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "timezone.excity.Asia/Dubai", "Dubaý" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Beýrut" },
            { "timezone.excity.Asia/Brunei", "Bruneý" },
            { "timezone.excity.Asia/Hebron", "Hewron" },
            { "timezone.excity.Asia/Kuwait", "Kuweýt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Er-Riýad" },
            { "timezone.excity.Asia/Saigon", "Hoşimin" },
            { "timezone.excity.Asia/Taipei", "Taýbeý" },
            { "timezone.excity.Asia/Tehran", "Tähran" },
            { "timezone.excity.Asia/Urumqi", "Urumçi" },
            { "timezone.excity.Etc/Unknown", "Näbelli şäher" },
            { "timezone.excity.Europe/Kiev", "Kiýew" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "timezone.excity.Indian/Mahe", "Maýe" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akkra" },
            { "timezone.excity.Africa/Cairo", "Kair" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.America/Adak", "Adak adasy" },
            { "timezone.excity.America/Nome", "Nom" },
            { "timezone.excity.Asia/Baghdad", "Bagdat" },
            { "timezone.excity.Asia/Bahrain", "Bahreýn" },
            { "timezone.excity.Asia/Bishkek", "Bişkek" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Karachi", "Karaçi" },
            { "timezone.excity.Asia/Kuching", "Kuçing" },
            { "timezone.excity.Asia/Nicosia", "Nikosiýa" },
            { "timezone.excity.Asia/Rangoon", "Ýangon" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "timezone.excity.Asia/Yakutsk", "Ýakutsk" },
            { "timezone.excity.Asia/Yerevan", "Ýerewan" },
            { "timezone.excity.Europe/Kirov", "Kirow" },
            { "timezone.excity.Europe/Paris", "Pariž" },
            { "timezone.excity.Europe/Sofia", "Sofiýa" },
            { "timezone.excity.Europe/Vaduz", "Waduz" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Pacific/Truk", "Çuuk" },
            { "timezone.excity.Pacific/Wake", "Weýk" },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Niamey", "Niameý" },
            { "timezone.excity.America/Bahia", "Baiýa" },
            { "timezone.excity.America/Belem", "Belen" },
            { "timezone.excity.America/Boise", "Boýse" },
            { "timezone.excity.America/Jujuy", "Žužuý" },
            { "timezone.excity.America/Thule", "Tule" },
            { "timezone.excity.Asia/Ashgabat", "Aşgabat" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Duşanbe" },
            { "timezone.excity.Asia/Jayapura", "Jaýapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handyga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanaý" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "Şanhaý" },
            { "timezone.excity.Asia/Tashkent", "Taşkent" },
            { "timezone.excity.Europe/Athens", "Afiny" },
            { "timezone.excity.Europe/Jersey", "Jersi" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskwa" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Skopje", "Skopýe" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wena" },
            { "timezone.excity.Europe/Warsaw", "Warşawa" },
            { "timezone.excity.Europe/Zurich", "Sýurih" },
            { "timezone.excity.Indian/Chagos", "Çagos" },
            { "timezone.excity.Indian/Comoro", "Komor adalary" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abijan" },
            { "timezone.excity.Africa/Algiers", "Alžir" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Nairobi", "Naýrobi" },
            { "timezone.excity.America/Belize", "Beliz" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.America/Cayman", "Kaýman adalary" },
            { "timezone.excity.America/Cuiaba", "Kuýaba" },
            { "timezone.excity.America/Dawson", "Douson" },
            { "timezone.excity.America/Denver", "Denwer" },
            { "timezone.excity.America/Guyana", "Gaýana" },
            { "timezone.excity.America/Havana", "Gawana" },
            { "timezone.excity.America/Inuvik", "Inuwik" },
            { "timezone.excity.America/Juneau", "Džuno" },
            { "timezone.excity.America/La_Paz", "La-Pas" },
            { "timezone.excity.America/Maceio", "Maseýo" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.America/Regina", "Rejaýna" },
            { "timezone.excity.Asia/Hong_Kong", "Gonkong" },
            { "timezone.excity.Asia/Jerusalem", "Iýerusalim" },
            { "timezone.excity.Asia/Kamchatka", "Kamçatka" },
            { "timezone.excity.Asia/Pyongyang", "Phenýan" },
            { "timezone.excity.Asia/Qyzylorda", "Gyzylorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Wýentýan" },
            { "timezone.excity.Europe/Saratov", "Saratow" },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Europe/Vatican", "Watikan" },
            { "timezone.excity.Europe/Vilnius", "Wilnýus" },
            { "timezone.excity.Indian/Mayotte", "Maýotta" },
            { "timezone.excity.Indian/Reunion", "Reýunýon" },
            { "timezone.excity.Pacific/Easter", "Pasha adasy" },
            { "timezone.excity.Pacific/Kosrae", "Kosraýe" },
            { "timezone.excity.Pacific/Midway", "Midueý" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Ponape", "Ponape" },
            { "timezone.excity.Pacific/Saipan", "Saýpan" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Wallis", "Uollis" },
            { "timezone.excity.Africa/Blantyre", "Blantaýr" },
            { "timezone.excity.Africa/Djibouti", "Jibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El-Aýun" },
            { "timezone.excity.Africa/Freetown", "Fritaun" },
            { "timezone.excity.Africa/Khartoum", "Hartum" },
            { "timezone.excity.Africa/Kinshasa", "Kinşasa" },
            { "timezone.excity.Africa/Monrovia", "Monrowiýa" },
            { "timezone.excity.Africa/Ndjamena", "Jamena" },
            { "timezone.excity.Africa/Sao_Tome", "San-Tome" },
            { "timezone.excity.Africa/Windhoek", "Windhuk" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Cayenne", "Kaýenna" },
            { "timezone.excity.America/Chicago", "Çikago" },
            { "timezone.excity.America/Cordoba", "Kordowa" },
            { "timezone.excity.America/Creston", "Kreston" },
            { "timezone.excity.America/Curacao", "Kýurasao" },
            { "timezone.excity.America/Detroit", "Detroýt" },
            { "timezone.excity.America/Halifax", "Galifaks" },
            { "timezone.excity.America/Iqaluit", "Ikaluit" },
            { "timezone.excity.America/Jamaica", "Ýamaýka" },
            { "timezone.excity.America/Marigot", "Marigo" },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.America/Phoenix", "Feniks" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.America/Yakutat", "Ýakutat" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompen" },
            { "timezone.excity.Atlantic/Azores", "Azor adalary" },
            { "timezone.excity.Atlantic/Canary", "Kanar adalary" },
            { "timezone.excity.Atlantic/Faeroe", "Farer adalary" },
            { "timezone.excity.Australia/Eucla", "Ýukla" },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brýussel" },
            { "timezone.excity.Europe/Budapest", "Budapeşt" },
            { "timezone.excity.Europe/Busingen", "Býuzingen" },
            { "timezone.excity.Europe/Chisinau", "Kişinýow" },
            { "timezone.excity.Europe/Guernsey", "Gernsi" },
            { "timezone.excity.Europe/Istanbul", "Stambul" },
            { "timezone.excity.Europe/Sarajevo", "Saraýewo" },
            { "timezone.excity.Indian/Maldives", "Maldiwler" },
            { "timezone.excity.Pacific/Chatham", "Çatem" },
            { "timezone.excity.Pacific/Gambier", "Gambýe" },
            { "timezone.excity.Africa/Mogadishu", "Mogadişo" },
            { "timezone.excity.America/Anguilla", "Angilýa" },
            { "timezone.excity.America/Asuncion", "Asunsýon" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Eirunepe", "Eýrunepe" },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "timezone.excity.America/New_York", "Nýu-Ýork" },
            { "timezone.excity.America/Resolute", "Rezolýut" },
            { "timezone.excity.America/Santiago", "Santýago" },
            { "timezone.excity.America/St_Johns", "Sent-Jons" },
            { "timezone.excity.America/St_Kitts", "Sent-Kits" },
            { "timezone.excity.America/St_Lucia", "Sent-Lýusiýa" },
            { "timezone.excity.Antarctica/Casey", "Keýsi" },
            { "timezone.excity.Antarctica/Davis", "Deýwis" },
            { "timezone.excity.Antarctica/Syowa", "Sýowa" },
            { "timezone.excity.Antarctica/Troll", "Trol" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoýarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan-Bator" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "timezone.excity.Atlantic/Madeira", "Madeýra adalary" },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "timezone.excity.Australia/Sydney", "Sidneý" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Buharest" },
            { "timezone.excity.Europe/Ljubljana", "Lýublýana" },
            { "timezone.excity.Europe/Mariehamn", "Mariýehamn" },
            { "timezone.excity.Europe/Podgorica", "Podgorisa" },
            { "timezone.excity.Europe/Stockholm", "Stokgolm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulýanowsk" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Roždestwo" },
            { "timezone.excity.Indian/Kerguelen", "Kergelen" },
            { "timezone.excity.Indian/Mauritius", "Mawrikiý" },
            { "timezone.excity.Pacific/Auckland", "Oklend" },
            { "timezone.excity.Pacific/Honolulu", "Gonolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkern" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.Africa/Libreville", "Librewil" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbaşi" },
            { "timezone.excity.Africa/Nouakchott", "Nuakşot" },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Nowo" },
            { "timezone.excity.America/Anchorage", "Ankoridž" },
            { "timezone.excity.America/Araguaina", "Araguaýna" },
            { "timezone.excity.America/Boa_Vista", "Boa-Wista" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Chihuahua", "Çihuahua" },
            { "timezone.excity.America/Glace_Bay", "Gleýs-Beý" },
            { "timezone.excity.America/Goose_Bay", "Gus-Beý" },
            { "timezone.excity.America/Guatemala", "Gwatemala" },
            { "timezone.excity.America/Guayaquil", "Guýakil" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "Monterreý" },
            { "timezone.excity.America/Sao_Paulo", "San-Paulu" },
            { "timezone.excity.America/St_Thomas", "Sent-Tomas" },
            { "timezone.excity.America/Vancouver", "Wankuwer" },
            { "timezone.excity.Antarctica/Mawson", "Mouson" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala-Lumpur" },
            { "timezone.excity.Asia/Novokuznetsk", "Nowokuznesk" },
            { "timezone.excity.Europe/Bratislava", "Bratislawa" },
            { "timezone.excity.Europe/Copenhagen", "Kopengagen" },
            { "timezone.excity.Europe/Luxembourg", "Lýuksemburg" },
            { "timezone.excity.Europe/San_Marino", "San-Marino" },
            { "timezone.excity.Pacific/Enderbury", "Enderberi" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos adalary" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajaleýn" },
            { "timezone.excity.Pacific/Marquesas", "Markiz adalary" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago-Pago" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis-Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzawil" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kosta-Rika" },
            { "timezone.excity.America/Grand_Turk", "Grand-Terk" },
            { "timezone.excity.America/Guadeloupe", "Gwadelupa" },
            { "timezone.excity.America/Hermosillo", "Ermosilo" },
            { "timezone.excity.America/Kralendijk", "Kralendeýk" },
            { "timezone.excity.America/Louisville", "Luiswill" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "timezone.excity.America/Montevideo", "Montewideo" },
            { "timezone.excity.America/Montserrat", "Monserrat" },
            { "timezone.excity.America/Rio_Branco", "Riu-Branku" },
            { "timezone.excity.America/St_Vincent", "Sent-Winsent" },
            { "timezone.excity.America/Whitehorse", "Waýthors" },
            { "timezone.excity.Antarctica/McMurdo", "Mak-Merdo" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Yekaterinburg", "Ýekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reýkýawik" },
            { "timezone.excity.Atlantic/St_Helena", "Keramatly Ýelena adasy" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Australia/Brisbane", "Brisben" },
            { "timezone.excity.Europe/Isle_of_Man", "Men adasy" },
            { "timezone.excity.Africa/Johannesburg", "Ýohannesburg" },
            { "timezone.excity.America/El_Salvador", "Salwador" },
            { "timezone.excity.America/Los_Angeles", "Los-Anjeles" },
            { "timezone.excity.America/Mexico_City", "Mehiko" },
            { "timezone.excity.America/Porto_Velho", "Portu-Welýu" },
            { "timezone.excity.America/Puerto_Rico", "Puerto-Riko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Longir" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kabo-Werde" },
            { "timezone.excity.Australia/Lord_Howe", "Lord-Hau" },
            { "timezone.excity.Australia/Melbourne", "Melburn" },
            { "timezone.excity.Indian/Antananarivo", "Antananariwu" },
            { "timezone.excity.Pacific/Guadalcanal", "Gwadalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar-es-Salam" },
            { "timezone.excity.America/Blanc-Sablon", "Blank-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos-Aýres" },
            { "timezone.excity.America/Campo_Grande", "Kampu-Grandi" },
            { "timezone.excity.America/Danmarkshavn", "Denmarkshawn" },
            { "timezone.excity.America/Dawson_Creek", "Douson-Krik" },
            { "timezone.excity.America/Indiana/Knox", "Noks, Indiana" },
            { "timezone.excity.America/Punta_Arenas", "Punta-Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Rankin-Inlet" },
            { "timezone.excity.America/Scoresbysund", "Illokkortoormiut" },
            { "timezone.excity.Antarctica/Macquarie", "Makkuori" },
            { "timezone.excity.Pacific/Bougainville", "Bugenwil" },
            { "timezone.excity.Pacific/Port_Moresby", "Port-Morsbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kembrij-Beý" },
            { "timezone.excity.America/Ciudad_Juarez", "Sýudad-Huares" },
            { "timezone.excity.America/Indiana/Vevay", "Wiweý, Indiana" },
            { "timezone.excity.America/Lower_Princes", "Lower-Prinses-Kuorter" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Speýn" },
            { "timezone.excity.America/Santo_Domingo", "Santo-Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Sen-Bartelemi" },
            { "timezone.excity.America/Swift_Current", "Swift-Karent" },
            { "timezone.excity.Australia/Broken_Hill", "Broken-Hil" },
            { "timezone.excity.America/Bahia_Banderas", "Baiýa-de-Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-o-Prens" },
            { "timezone.excity.Atlantic/South_Georgia", "Günorta Georgiýa" },
            { "timezone.excity.America/Indiana/Winamac", "Winamak, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Uşuaýa" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell-Siti, Indiana" },
            { "timezone.excity.America/Indiana/Vincennes", "Winsens, Indiana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dýumon-d-Ýurwil" },
            { "timezone.excity.America/Argentina/La_Rioja", "La-Rioha" },
            { "timezone.excity.America/Argentina/San_Juan", "San-Huan" },
            { "timezone.excity.America/Argentina/San_Luis", "San-Luis" },
            { "timezone.excity.America/Kentucky/Monticello", "Montisello, Kentuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Boýla, Demirgazyk Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Sentr, Demirgazyk Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio-Galegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nýu-Salem, Demirgazyk Dakota" },
        };
        return data;
    }
}
