/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sq extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ora e Grinuiçit",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Ora standarde e Ejkrit [Ako]",
               "",
               "Ora verore e Ejkrit [Ako]",
               "",
               "Ora e Ejkrit [Ako]",
               "",
            };
        final String[] Apia = new String[] {
               "Ora standarde e Apias",
               "",
               "Ora verore e Apias",
               "",
               "Ora e Apias",
               "",
            };
        final String[] Cook = new String[] {
               "Ora standarde e Ishujve Kuk",
               "",
               "Ora verore e Ishujve Kuk",
               "",
               "Ora e Ishujve Kuk",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora standarde e Kubës",
               "CST",
               "Ora verore e Kubës",
               "CDT",
               "Ora e Kubës",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Ora standarde e Fixhit",
               "",
               "Ora verore e Fixhit",
               "",
               "Ora e Fixhit",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora e Gjirit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora standarde e Hovdit",
               "",
               "Ora verore e Hovdit",
               "",
               "Ora e Hovdit",
               "",
            };
        final String[] Iran = new String[] {
               "Ora standarde e Iranit",
               "",
               "Ora verore e Iranit",
               "",
               "Ora e Iranit",
               "",
            };
        final String[] Niue = new String[] {
               "Ora e Niuesë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora standarde e Omskut",
               "",
               "Ora verore e Omskut",
               "",
               "Ora e Omskut",
               "",
            };
        final String[] Peru = new String[] {
               "Ora standarde e Perusë",
               "",
               "Ora verore e Perusë",
               "",
               "Ora e Perusë",
               "",
            };
        final String[] Truk = new String[] {
               "Ora e Çukut",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora e Ishullit Uejk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ora standarde e Kilit",
               "",
               "Ora verore e Kilit",
               "",
               "Ora e Kilit",
               "",
            };
        final String[] China = new String[] {
               "Ora standarde e Kinës",
               "CST",
               "Ora verore e Kinës",
               "CDT",
               "Ora e Kinës",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Ora e Ishujve Kokos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ora e Dejvisit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora standarde e Indisë",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ora standarde e Japonisë",
               "JST",
               "Ora verore e Japonisë",
               "JDT",
               "Ora e Japonisë",
               "JT",
            };
        final String[] Korea = new String[] {
               "Ora standarde koreane",
               "KST",
               "Ora verore koreane",
               "KST",
               "Ora koreane",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Ora e Naurusë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora e Nepalit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora e Palaut",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora standarde e Samoas",
               "SST",
               "Ora verore e Samoas",
               "SST",
               "Ora e Samoas",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Ora e Sjouit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora standarde e Tongës",
               "",
               "Ora verore e Tongës",
               "",
               "Ora e Tongës",
               "",
            };
        final String[] Yukon = new String[] {
               "Ora e Jukonit",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Ora standarde e Alaskës",
               "AKST",
               "Ora verore e Alaskës",
               "AKDT",
               "Ora e Alaskës",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ora standarde e Amazonës",
               "",
               "Ora verore e Amazonës",
               "",
               "Ora e Amazonës",
               "",
            };
        final String[] Anadyr = new String[] {
               "Ora standarde e Anadirit",
               "",
               "Ora verore e Anadirit",
               "",
               "Ora e Anadirit",
               "",
            };
        final String[] Azores = new String[] {
               "Ora standarde e Azoreve",
               "",
               "Ora verore e Azoreve",
               "",
               "Ora e Azoreve",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora e Butanit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora e Brunei-Durasalamit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora standarde e Ishullit të Pashkës",
               "",
               "Ora verore e Ishullit të Pashkës",
               "",
               "Ora e Ishullit të Pashkës",
               "",
            };
        final String[] Guyana = new String[] {
               "Ora e Guajanës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ora standarde e Izraelit",
               "IST",
               "Ora verore e Izraelit",
               "IDT",
               "Ora e Izraelit",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ora e Kosrës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora e Mausonit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ora standarde e Moskës",
               "MSK",
               "Ora verore e Moskës",
               "MSK",
               "Ora e Moskës",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ora e Ponapeit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Ora standarde e Samarës",
               "",
               "Ora verore e Samarës",
               "",
               "Ora e Samarës",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora e Tahitit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora standarde e Tajpeit",
               "CST",
               "Ora verore e Tajpeit",
               "CDT",
               "Ora e Tajpeit",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Ora e Tuvalusë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora e Vostokut",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora e Uollisit dhe Futunës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora standarde arabe",
               "",
               "Ora verore arabe",
               "",
               "Ora arabe",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora standarde e Armenisë",
               "",
               "Ora verore e Armenisë",
               "",
               "Ora e Armenisë",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora e Bolivisë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora standarde e Katamit",
               "",
               "Ora verore e Katamit",
               "",
               "Ora e Katamit",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ora universale e koordinuar",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora e Ekuadorit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora e Gambierit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora standarde e Gjeorgjisë",
               "",
               "Ora verore e Gjeorgjisë",
               "",
               "Ora e Gjeorgjisë",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora standarde e Irkutskut",
               "",
               "Ora verore e Irkutskut",
               "",
               "Ora e Irkutskut",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora standarde e Magadanit",
               "",
               "Ora verore e Magadanit",
               "",
               "Ora e Magadanit",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora e Mianmarit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora standarde e Ishullit Norfolk",
               "",
               "Ora verore e Ishullit Norfolk",
               "",
               "Ora e Ishullit Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora standarde e Fernando-de-Noronjës",
               "",
               "Ora verore e Fernando-de-Noronjës",
               "",
               "Ora e Fernando-de-Noronjës",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora e Reunionit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora e Rodherës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora e Ishujve Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora e Tokelaut",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora standarde e Uruguait",
               "",
               "Ora verore e Uruguait",
               "",
               "Ora e Uruguait",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora standarde e Vanuatusë",
               "",
               "Ora verore e Vanuatusë",
               "",
               "Ora e Vanuatusë",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora standarde e Jakutskut",
               "",
               "Ora verore e Jakutskut",
               "",
               "Ora e Jakutskut",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora standarde e Atlantikut",
               "AST",
               "Ora verore e Atlantikut",
               "AST",
               "Ora e Atlantikut",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Ora standarde e Brazilisë",
               "",
               "Ora verore e Brazilisë",
               "",
               "Ora e Brazilisë",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora e Kamorros",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Ora standarde e Kolumbisë",
               "",
               "Ora verore e Kolumbisë",
               "",
               "Ora e Kolumbisë",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora standarde e Ishujve Falkland",
               "",
               "Ora verore e Ishujve Falkland",
               "",
               "Ora e Ishujve Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora e Malajzisë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora e Maldiveve",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora standarde e Ulan-Batorit",
               "",
               "Ora verore e Ulan-Batorit",
               "",
               "Ora e Ulan-Batorit",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora standarde e Pakistanit",
               "PKT",
               "Ora verore e Pakistanit",
               "PKST",
               "Ora e Pakistanit",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Ora standarde e Paraguait",
               "",
               "Ora Verore e Paraguait",
               "",
               "Ora e Paraguait",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora e Pitkernit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Ora standarde e Sakalinit",
               "",
               "Ora verore e Sakalinit",
               "",
               "Ora e Sakalinit",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora e Surinamit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora standarde e Argjentinës",
               "",
               "Ora verore e Argjentinës",
               "",
               "Ora e Argjentinës",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora e Ishullit të Krishtlindjeve",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora e Galapagosit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standarde e Hong-Kongut",
               "HKT",
               "Ora verore e Hong-Kongut",
               "HKST",
               "Ora e Hong-Kongut",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ora e Indokinës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Ora standarde e Petropavllovsk-Kamçatkës",
               "",
               "Ora verore e Petropavllovsk-Kamçatkës",
               "",
               "Ora e Petropavllovsk-Kamçatkës",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora e Kirgizisë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standarde e Lord-Houit",
               "",
               "Ora verore e Lord-Houit",
               "",
               "Ora e Lord-Houit",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora e Ishujve Markezë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora standarde e Mauritiusit",
               "",
               "Ora verore e Mauritiusit",
               "",
               "Ora e Mauritiusit",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora e Singaporit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora e Venezuelës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Ora standarde e Volgogradit",
               "MSK",
               "Ora verore e Volgogradit",
               "MSK",
               "Ora e Volgogradit",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standarde e Azerbajxhanit",
               "",
               "Ora verore e Azerbajxhanit",
               "",
               "Ora e Azerbajxhanit",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora standarde e Bangladeshit",
               "",
               "Ora verore e Bangladeshit",
               "",
               "Ora e Bangladeshit",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standarde e Kepit të Gjelbër",
               "",
               "Ora verore e Kepit të Gjelbër",
               "",
               "Ora e Kepit të Gjelbër",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora e Timorit Lindor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Ora e Kazakistanit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora e Sejshelleve",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora e Taxhikistanit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standarde e Uzbekistanit",
               "",
               "Ora verore e Uzbekistanit",
               "",
               "Ora e Uzbekistanit",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora e Afganistanit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standarde e Krasnojarskut",
               "",
               "Ora verore e Krasnojarskut",
               "",
               "Ora e Krasnojarskut",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora standarde e Zelandës së Re",
               "NZST",
               "Ora verore e Zelandës së Re",
               "NZDT",
               "Ora e Zelandës së Re",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standarde e Novosibirskut",
               "",
               "Ora verore e Novosibirskut",
               "",
               "Ora e Novosibirskut",
               "",
            };
        final String[] Philippines = new String[] {
               "Ora standarde e Filipineve",
               "PST",
               "Ora verore e Filipineve",
               "PDT",
               "Ora e Filipineve",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standarde e Vladivostokut",
               "",
               "Ora verore e Vladivostokut",
               "",
               "Ora e Vladivostokut",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora e Oqeanit Indian",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora e Ishujve Sporadikë Ekuatorialë",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora standarde e Njufaundlendit [Tokës së Re]",
               "NST",
               "Ora verore e Njufaundlendit [Tokës së Re]",
               "NDT",
               "Ora e Njufaundlendit [Tokës së Re]",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standarde e Turkmenistanit",
               "",
               "Ora verore e Turkmenistanit",
               "",
               "Ora e Turkmenistanit",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora e Guajanës Franceze",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standarde e Kaledonisë së Re",
               "",
               "Ora verore e Kaledonisë së Re",
               "",
               "Ora e Kaledonisë së Re",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora e Xhorxhas të Jugut",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standarde e Ekaterinburgut",
               "",
               "Ora verore e Ekaterinburgut",
               "",
               "Ora e Ekaterinburgut",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora e Afrikës Qendrore",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora e Afrikës Lindore",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standarde e Afrikës Perëndimore",
               "WAT",
               "Ora verore e Afrikës Perëndimore",
               "WAT",
               "Ora e Afrikës Perëndimore",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora e Dumont-d’Urvilës",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora standarde e Evropës Qendrore",
               "CET",
               "Ora verore e Evropës Qendrore",
               "CEST",
               "Ora e Evropës Qendrore",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standarde e Evropës Lindore",
               "EET",
               "Ora verore e Evropës Lindore",
               "EEST",
               "Ora e Evropës Lindore",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ora standarde e Evropës Perëndimore",
               "WET",
               "Ora verore e Evropës Perëndimore",
               "WEST",
               "Ora e Evropës Perëndimore",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standarde e Territoreve Meksikane të Bregut të Paqësorit",
               "MST",
               "Ora verore e Territoreve Meksikane të Bregut të Paqësorit",
               "MDT",
               "Ora e Territoreve Meksikane të Bregut të Paqësorit",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora standarde e Afrikës Jugore",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Ora standarde e SHBA-së Qendrore",
               "CST",
               "Ora verore e SHBA-së Qendrore",
               "CDT",
               "Ora e SHBA-së Qendrore",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standarde e SHBA-së Lindore",
               "EST",
               "Ora verore e SHBA-së Lindore",
               "EST",
               "Ora e SHBA-së Lindore",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Ora standarde e Territoreve Amerikane të Bregut të Paqësorit",
               "PST",
               "Ora verore e Territoreve Amerikane të Bregut të Paqësorit",
               "PDT",
               "Ora e Territoreve Amerikane të Bregut të Paqësorit",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ora e Territoreve Jugore dhe Antarktike Franceze",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora e Ishujve Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standarde e Ishujve Hauai-Aleutian",
               "HST",
               "Ora verore e Ishujve Hauai-Aleutian",
               "HST",
               "Ora e Ishujve Hauai-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora e Ishujve Feniks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standarde e Shën-Pier dhe Mikelon",
               "",
               "Ora verore e Shën-Pier dhe Mikelon",
               "",
               "Ora e Shën-Pier dhe Mikelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora standarde e Territoreve Amerikane të Brezit Malor",
               "MST",
               "Ora verore e Territoreve Amerikane të Brezit Malor",
               "MST",
               "Ora e Territoreve Amerikane të Brezit Malor",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora e Ishujve Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora e Guinesë së Re-Papua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora standarde e Australisë Qendrore",
               "ACST",
               "Ora verore e Australisë Qendrore",
               "ACDT",
               "Ora e Australisë Qendrore",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standarde e Australisë Lindore",
               "AEST",
               "Ora verore e Australisë Lindore",
               "AEDT",
               "Ora e Australisë Lindore",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ora standarde e Australisë Perëndimore",
               "AWST",
               "Ora verore e Australisë Perëndimore",
               "AWDT",
               "Ora e Australisë Perëndimore",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora e Indonezisë Qendrore",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora e Indonezisë Lindore",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora e Indonezisë Perëndimore",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standarde e Australisë Qendroro-Perëndimore",
               "",
               "Ora verore e Australisë Qendroro-Perëndimore",
               "",
               "Ora e Australisë Qendroro-Perëndimore",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ora universale e koordinuar",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora strandarde e Irlandës",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ora universale e koordinuar",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ora universale e koordinuar",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ora universale e koordinuar",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Ora universale e koordinuar",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ora universale e koordinuar",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora strandarde e Irlandës",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Ora e Grinuiçit",
                    "GMT",
                    "Ora verore britanike",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Çita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Xhuba" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Bejrut" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Manila", "Manilë" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ho-Çi-Min" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Qytet i panjohur" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Riga", "Rigë" },
            { "timezone.excity.Europe/Rome", "Romë" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kajro" },
            { "timezone.excity.Africa/Ceuta", "Theuta" },
            { "timezone.excity.Africa/Tunis", "Tuniz" },
            { "timezone.excity.America/Lima", "Limë" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrejn" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Jakarta", "Xhakartë" },
            { "timezone.excity.Asia/Karachi", "Karaçi" },
            { "timezone.excity.Asia/Kuching", "Kuçing" },
            { "timezone.excity.Asia/Nicosia", "Nikozia" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Tbilisi", "Tbilis" },
            { "timezone.excity.Asia/Thimphu", "Thimpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Malta", "Maltë" },
            { "timezone.excity.Europe/Sofia", "Sofje" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Pacific/Fiji", "Fixhi" },
            { "timezone.excity.Pacific/Truk", "Çuk" },
            { "timezone.excity.Pacific/Wake", "Uejk" },
            { "timezone.excity.Africa/Asmera", "Asmarë" },
            { "timezone.excity.Africa/Banjul", "Banxhul" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Niamey", "Niamej" },
            { "timezone.excity.America/Aruba", "Arubë" },
            { "timezone.excity.America/Boise", "Boizë" },
            { "timezone.excity.America/Jujuy", "Huhui" },
            { "timezone.excity.America/Thule", "Dhule" },
            { "timezone.excity.Asia/Calcutta", "Kalkutë" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Jayapura", "Xhajapurë" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Kandigë" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Sakhalin", "Sakalin" },
            { "timezone.excity.Asia/Shanghai", "Shangai" },
            { "timezone.excity.Europe/Athens", "Athinë" },
            { "timezone.excity.Europe/Jersey", "Xhersej" },
            { "timezone.excity.Europe/Lisbon", "Lisbonë" },
            { "timezone.excity.Europe/London", "Londër" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskë" },
            { "timezone.excity.Europe/Prague", "Pragë" },
            { "timezone.excity.Europe/Skopje", "Shkup" },
            { "timezone.excity.Europe/Tirane", "Tiranë" },
            { "timezone.excity.Europe/Vienna", "Vjenë" },
            { "timezone.excity.Europe/Warsaw", "Varshavë" },
            { "timezone.excity.Europe/Zurich", "Zyrih" },
            { "timezone.excity.Indian/Chagos", "Çagos" },
            { "timezone.excity.Indian/Comoro", "Komore" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abixhan" },
            { "timezone.excity.Africa/Algiers", "Algjer" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.America/Belize", "Belizë" },
            { "timezone.excity.America/Bogota", "Bogotë" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.America/Cayman", "Kajman" },
            { "timezone.excity.America/Cuiaba", "Kujaba" },
            { "timezone.excity.America/Dawson", "Douson" },
            { "timezone.excity.America/Guyana", "Guajanë" },
            { "timezone.excity.America/Havana", "Havanë" },
            { "timezone.excity.America/Juneau", "Xhunou" },
            { "timezone.excity.America/Maceio", "Makejo" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Nasao" },
            { "timezone.excity.America/Regina", "Rexhina" },
            { "timezone.excity.Asia/Famagusta", "Famagustë" },
            { "timezone.excity.Asia/Hong_Kong", "Hong-Kong" },
            { "timezone.excity.Asia/Kamchatka", "Kamçatkë" },
            { "timezone.excity.Asia/Pyongyang", "Penian" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Singapore", "Singapor" },
            { "timezone.excity.Asia/Vientiane", "Vjentianë" },
            { "timezone.excity.Europe/Andorra", "Andorrë" },
            { "timezone.excity.Europe/Tallinn", "Talin" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Indian/Mayotte", "Majotë" },
            { "timezone.excity.Pacific/Easter", "Pashkë" },
            { "timezone.excity.Pacific/Kosrae", "Kosre" },
            { "timezone.excity.Pacific/Majuro", "Mahuro" },
            { "timezone.excity.Pacific/Midway", "Miduej" },
            { "timezone.excity.Pacific/Ponape", "Ponapei" },
            { "timezone.excity.Pacific/Tarawa", "Taravë" },
            { "timezone.excity.Pacific/Wallis", "Uollis" },
            { "timezone.excity.Africa/Blantyre", "Blantirë" },
            { "timezone.excity.Africa/Djibouti", "Xhibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Ajun" },
            { "timezone.excity.Africa/Freetown", "Fritaun" },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "timezone.excity.Africa/Sao_Tome", "Sao-Tome" },
            { "timezone.excity.Africa/Windhoek", "Vint’huk" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Cayenne", "Kajenë" },
            { "timezone.excity.America/Chicago", "Çikago" },
            { "timezone.excity.America/Cordoba", "Kordoba" },
            { "timezone.excity.America/Creston", "Kreston" },
            { "timezone.excity.America/Curacao", "Kurasao" },
            { "timezone.excity.America/Godthab", "Njuk" },
            { "timezone.excity.America/Grenada", "Granadë" },
            { "timezone.excity.America/Halifax", "Halifaks" },
            { "timezone.excity.America/Iqaluit", "Ikaluit" },
            { "timezone.excity.America/Jamaica", "Xhamajkë" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "timezone.excity.America/Noronha", "Noronja" },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.America/Phoenix", "Feniks" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.America/Tortola", "Tortolë" },
            { "timezone.excity.America/Yakutat", "Jakutat" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnom-Pen" },
            { "timezone.excity.Atlantic/Azores", "Azore" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Australia/Eucla", "Eukla" },
            { "timezone.excity.Australia/Perth", "Përth" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Bruksel" },
            { "timezone.excity.Europe/Chisinau", "Kishineu" },
            { "timezone.excity.Europe/Guernsey", "Gernsej" },
            { "timezone.excity.Europe/Istanbul", "Stamboll" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevë" },
            { "timezone.excity.Indian/Maldives", "Maldive" },
            { "timezone.excity.Pacific/Chatham", "Çatman" },
            { "timezone.excity.Africa/Bujumbura", "Buxhumburë" },
            { "timezone.excity.America/Anguilla", "Anguilë" },
            { "timezone.excity.America/Asuncion", "Asunsion" },
            { "timezone.excity.America/Dominica", "Dominikë" },
            { "timezone.excity.America/Eirunepe", "Ejrunep" },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "timezone.excity.America/New_York", "Nju-Jork" },
            { "timezone.excity.America/St_Johns", "Shën-Gjon" },
            { "timezone.excity.America/St_Kitts", "Shën-Kits" },
            { "timezone.excity.America/St_Lucia", "Shën-Luçia" },
            { "timezone.excity.America/Winnipeg", "Uinipeg" },
            { "timezone.excity.Antarctica/Casey", "Kejsi" },
            { "timezone.excity.Antarctica/Davis", "Dejvis" },
            { "timezone.excity.Antarctica/Syowa", "Sjoua" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbatar" },
            { "timezone.excity.Atlantic/Bermuda", "Bermude" },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "timezone.excity.Australia/Darwin", "Darvin" },
            { "timezone.excity.Australia/Sydney", "Sidnej" },
            { "timezone.excity.Europe/Astrakhan", "Astrakan" },
            { "timezone.excity.Europe/Bucharest", "Bukuresht" },
            { "timezone.excity.Europe/Gibraltar", "Gjibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Lubjanë" },
            { "timezone.excity.Europe/Podgorica", "Podgoricë" },
            { "timezone.excity.Europe/Stockholm", "Stokholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Krishtlindje" },
            { "timezone.excity.Pacific/Auckland", "Okland" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkern" },
            { "timezone.excity.Africa/Casablanca", "Kazablankë" },
            { "timezone.excity.Africa/Libreville", "Librevilë" },
            { "timezone.excity.Africa/Nouakchott", "Nouakot" },
            { "timezone.excity.America/Anchorage", "Ankorejxh" },
            { "timezone.excity.America/Araguaina", "Araguajana" },
            { "timezone.excity.America/Boa_Vista", "Boa-Vista" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Chihuahua", "Çihahua" },
            { "timezone.excity.America/Glace_Bay", "Gjiri i Ngrirë" },
            { "timezone.excity.America/Goose_Bay", "Gjiri i Patës" },
            { "timezone.excity.America/Guatemala", "Guatemalë" },
            { "timezone.excity.America/Guayaquil", "Guajakuil" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "Monterrej" },
            { "timezone.excity.America/Sao_Paulo", "Sao-Paulo" },
            { "timezone.excity.America/St_Thomas", "Shën-Tomas" },
            { "timezone.excity.America/Vancouver", "Vankuver" },
            { "timezone.excity.Antarctica/Mawson", "Mauson" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala-Lumpur" },
            { "timezone.excity.Europe/Bratislava", "Bratislavë" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Europe/San_Marino", "San-Marino" },
            { "timezone.excity.Pacific/Enderbury", "Enderbur" },
            { "timezone.excity.Pacific/Kwajalein", "Kuaxhalein" },
            { "timezone.excity.Pacific/Marquesas", "Markez" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago-Pago" },
            { "timezone.excity.Pacific/Rarotonga", "Rarotongë" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis-Ababë" },
            { "timezone.excity.Africa/Brazzaville", "Brazavillë" },
            { "timezone.excity.Africa/Ouagadougou", "Uagëdugu" },
            { "timezone.excity.America/Costa_Rica", "Kosta-Rikë" },
            { "timezone.excity.America/Grand_Turk", "Turku i Madh" },
            { "timezone.excity.America/Guadeloupe", "Guadelupë" },
            { "timezone.excity.America/Hermosillo", "Hermosijo" },
            { "timezone.excity.America/Louisville", "Luizvilë" },
            { "timezone.excity.America/Martinique", "Martinikë" },
            { "timezone.excity.America/Montserrat", "Montserat" },
            { "timezone.excity.America/Rio_Branco", "Rio-Branko" },
            { "timezone.excity.America/St_Vincent", "Shën-Vincent" },
            { "timezone.excity.America/Whitehorse", "Uajt’hors" },
            { "timezone.excity.Antarctica/McMurdo", "Mekmurdo" },
            { "timezone.excity.Antarctica/Rothera", "Rodherë" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikjavik" },
            { "timezone.excity.Atlantic/St_Helena", "Shën-Elenë" },
            { "timezone.excity.Australia/Adelaide", "Adelajde" },
            { "timezone.excity.Australia/Brisbane", "Brisbejn" },
            { "timezone.excity.Australia/Lindeman", "Lindëmen" },
            { "timezone.excity.Europe/Isle_of_Man", "Ishulli i Manit" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimat" },
            { "timezone.excity.Africa/Johannesburg", "Johanesburg" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Fort_Nelson", "Fort-Nelson" },
            { "timezone.excity.America/Los_Angeles", "Los Anxhelos" },
            { "timezone.excity.America/Mexico_City", "Qyteti i Meksikës" },
            { "timezone.excity.America/Porto_Velho", "Porto-Velho" },
            { "timezone.excity.America/Puerto_Rico", "Porto-Riko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Long’jëbjen" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kepi i Gjelbër" },
            { "timezone.excity.Australia/Lord_Howe", "Lord-Houi" },
            { "timezone.excity.Australia/Melbourne", "Melburn" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar-es-Salam" },
            { "timezone.excity.America/Blanc-Sablon", "Blank-Sablon" },
            { "timezone.excity.America/Buenos_Aires", "Buenos-Ajres" },
            { "timezone.excity.America/Campo_Grande", "Kampo-Grande" },
            { "timezone.excity.America/Danmarkshavn", "Denmarkshavën" },
            { "timezone.excity.America/Dawson_Creek", "Gjiri i Dousonit" },
            { "timezone.excity.America/Indiana/Knox", "Knoks, Indiana" },
            { "timezone.excity.America/Punta_Arenas", "Punta-Arenas" },
            { "timezone.excity.America/Rankin_Inlet", "Gryka Inlet" },
            { "timezone.excity.America/Scoresbysund", "Itokorturmit" },
            { "timezone.excity.Antarctica/Macquarie", "Mekuari" },
            { "timezone.excity.Pacific/Bougainville", "Bunganvilë" },
            { "timezone.excity.Pacific/Port_Moresby", "Port-Moresbi" },
            { "timezone.excity.America/Cambridge_Bay", "Gjiri i Kembrixhit" },
            { "timezone.excity.America/Ciudad_Juarez", "Siudad-Huarez" },
            { "timezone.excity.America/Indiana/Vevay", "Vevëj, Indiana" },
            { "timezone.excity.America/Lower_Princes", "Louer-Prinsis-Kuortër" },
            { "timezone.excity.America/Santo_Domingo", "Santo-Domingo" },
            { "timezone.excity.America/St_Barthelemy", "Sen-Bartelemi" },
            { "timezone.excity.America/Swift_Current", "Rryma e Shpejtë" },
            { "timezone.excity.Australia/Broken_Hill", "Brokën-Hill" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia-Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Port-o-Prins" },
            { "timezone.excity.Atlantic/South_Georgia", "Xhorxha e Jugut" },
            { "timezone.excity.America/Argentina/Salta", "Saltë" },
            { "timezone.excity.America/Indiana/Winamac", "Uinamak, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaja" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell-Siti, Indiana" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincenes, Indiana" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont-d’Urvilë" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioha" },
            { "timezone.excity.America/Argentina/San_Juan", "San-Huan" },
            { "timezone.excity.America/Argentina/San_Luis", "Shën-Luis" },
            { "timezone.excity.America/Indiana/Petersburg", "Petërsburg, Indiana" },
            { "timezone.excity.America/Kentucky/Monticello", "Montiçelo, Kentaki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beula, Dakota e Veriut" },
            { "timezone.excity.America/North_Dakota/Center", "Qendër, Dakota e Veriut" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio-Galegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nju-Salem, Dakota e Veriut" },
        };
        return data;
    }
}
