/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ko extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "그리니치 표준시",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "아크레 표준시",
               "",
               "아크레 하계 표준시",
               "",
               "아크레 시간",
               "",
            };
        final String[] Apia = new String[] {
               "아피아 표준시",
               "",
               "아피아 하계 표준시",
               "",
               "아피아 시간",
               "",
            };
        final String[] Cook = new String[] {
               "쿡 제도 표준시",
               "",
               "쿡 제도 절반 하계 표준시",
               "",
               "쿡 제도 시간",
               "",
            };
        final String[] Cuba = new String[] {
               "쿠바 표준시",
               "CST",
               "쿠바 하계 표준시",
               "CDT",
               "쿠바 시간",
               "CT",
            };
        final String[] Fiji = new String[] {
               "피지 표준시",
               "",
               "피지 하계 표준시",
               "",
               "피지 시간",
               "",
            };
        final String[] Gulf = new String[] {
               "걸프만 표준시",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "호브드 표준시",
               "",
               "호브드 하계 표준시",
               "",
               "호브드 시간",
               "",
            };
        final String[] Iran = new String[] {
               "이란 표준시",
               "",
               "이란 하계 표준시",
               "",
               "이란 시간",
               "",
            };
        final String[] Niue = new String[] {
               "니우에 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "옴스크 표준시",
               "",
               "옴스크 하계 표준시",
               "",
               "옴스크 시간",
               "",
            };
        final String[] Peru = new String[] {
               "페루 표준시",
               "",
               "페루 하계 표준시",
               "",
               "페루 시간",
               "",
            };
        final String[] Truk = new String[] {
               "추크 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "웨이크섬 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "칠레 표준시",
               "",
               "칠레 하계 표준시",
               "",
               "칠레 시간",
               "",
            };
        final String[] China = new String[] {
               "중국 표준시",
               "CST",
               "중국 하계 표준시",
               "CDT",
               "중국 시간",
               "CT",
            };
        final String[] Cocos = new String[] {
               "코코스 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "데이비스 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "인도 표준시",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "일본 표준시",
               "JST",
               "일본 하계 표준시",
               "JDT",
               "일본 시간",
               "JT",
            };
        final String[] Korea = new String[] {
               "대한민국 표준시",
               "KST",
               "대한민국 하계 표준시",
               "KST",
               "대한민국 시간",
               "KST",
            };
        final String[] Nauru = new String[] {
               "나우루 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "네팔 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "팔라우 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "사모아 표준시",
               "SST",
               "사모아 하계 표준시",
               "SST",
               "사모아 시간",
               "SST",
            };
        final String[] Syowa = new String[] {
               "쇼와 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "통가 표준시",
               "",
               "통가 하계 표준시",
               "",
               "통가 시간",
               "",
            };
        final String[] Yukon = new String[] {
               "유콘 시간",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "알래스카 표준시",
               "AKST",
               "알래스카 하계 표준시",
               "AKDT",
               "알래스카 시간",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "아마존 표준시",
               "",
               "아마존 하계 표준시",
               "",
               "아마존 시간",
               "",
            };
        final String[] Anadyr = new String[] {
               "아나디리 표준시",
               "",
               "아나디리 하계 표준시",
               "",
               "아나디리 시간",
               "",
            };
        final String[] Azores = new String[] {
               "아조레스 표준시",
               "",
               "아조레스 하계 표준시",
               "",
               "아조레스 시간",
               "",
            };
        final String[] Bhutan = new String[] {
               "부탄 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "브루나이 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "이스터섬 표준시",
               "",
               "이스터섬 하계 표준시",
               "",
               "이스터섬 시간",
               "",
            };
        final String[] Guyana = new String[] {
               "가이아나 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "이스라엘 표준시",
               "IST",
               "이스라엘 하계 표준시",
               "IDT",
               "이스라엘 시간",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "코스라에섬 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "모슨 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "모스크바 표준시",
               "MSK",
               "모스크바 하계 표준시",
               "MSK",
               "모스크바 시간",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "포나페 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "사마라 표준시",
               "",
               "사마라 하계 표준시",
               "",
               "사마라 시간",
               "",
            };
        final String[] Tahiti = new String[] {
               "타히티 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "대만 표준시",
               "CST",
               "대만 하계 표준시",
               "CDT",
               "대만 시간",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "투발루 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "보스톡 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "월리스푸투나 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "아라비아 표준시",
               "",
               "아라비아 하계 표준시",
               "",
               "아라비아 시간",
               "",
            };
        final String[] Armenia = new String[] {
               "아르메니아 표준시",
               "",
               "아르메니아 하계 표준시",
               "",
               "아르메니아 시간",
               "",
            };
        final String[] Bolivia = new String[] {
               "볼리비아 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "채텀 표준시",
               "",
               "채텀 하계 표준시",
               "",
               "채텀 시간",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "협정 세계시",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "에콰도르 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "감비에 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "조지아 표준시",
               "",
               "조지아 하계 표준시",
               "",
               "조지아 시간",
               "",
            };
        final String[] Irkutsk = new String[] {
               "이르쿠츠크 표준시",
               "",
               "이르쿠츠크 하계 표준시",
               "",
               "이르쿠츠크 시간",
               "",
            };
        final String[] Magadan = new String[] {
               "마가단 표준시",
               "",
               "마가단 하계 표준시",
               "",
               "마가단 시간",
               "",
            };
        final String[] Myanmar = new String[] {
               "미얀마 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "노퍽섬 표준시",
               "",
               "노퍽섬 하계 표준시",
               "",
               "노퍽섬 시간",
               "",
            };
        final String[] Noronha = new String[] {
               "페르난도 데 노로냐 표준시",
               "",
               "페르난도 데 노로냐 하계 표준시",
               "",
               "페르난도 데 노로냐 시간",
               "",
            };
        final String[] Reunion = new String[] {
               "레위니옹 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "로데라 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "솔로몬 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "토켈라우 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "우루과이 표준시",
               "",
               "우루과이 하계 표준시",
               "",
               "우루과이 시간",
               "",
            };
        final String[] Vanuatu = new String[] {
               "바누아투 표준시",
               "",
               "바누아투 하계 표준시",
               "",
               "바누아투 시간",
               "",
            };
        final String[] Yakutsk = new String[] {
               "야쿠츠크 표준시",
               "",
               "야쿠츠크 하계 표준시",
               "",
               "야쿠츠크 시간",
               "",
            };
        final String[] Atlantic = new String[] {
               "대서양 표준시",
               "AST",
               "대서양 하계 표준시",
               "AST",
               "대서양 시간",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "브라질리아 표준시",
               "",
               "브라질리아 하계 표준시",
               "",
               "브라질리아 시간",
               "",
            };
        final String[] Chamorro = new String[] {
               "차모로 시간",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "콜롬비아 표준시",
               "",
               "콜롬비아 하계 표준시",
               "",
               "콜롬비아 시간",
               "",
            };
        final String[] Falkland = new String[] {
               "포클랜드 제도 표준시",
               "",
               "포클랜드 제도 하계 표준시",
               "",
               "포클랜드 제도 시간",
               "",
            };
        final String[] Malaysia = new String[] {
               "말레이시아 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "몰디브 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "울란바토르 표준시",
               "",
               "울란바토르 하계 표준시",
               "",
               "울란바토르 시간",
               "",
            };
        final String[] Pakistan = new String[] {
               "파키스탄 표준시",
               "PKT",
               "파키스탄 하계 표준시",
               "PKST",
               "파키스탄 시간",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "파라과이 표준시",
               "",
               "파라과이 하계 표준시",
               "",
               "파라과이 시간",
               "",
            };
        final String[] Pitcairn = new String[] {
               "핏케언 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "사할린 표준시",
               "",
               "사할린 하계 표준시",
               "",
               "사할린 시간",
               "",
            };
        final String[] Suriname = new String[] {
               "수리남 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "아르헨티나 표준시",
               "",
               "아르헨티나 하계 표준시",
               "",
               "아르헨티나 시간",
               "",
            };
        final String[] Christmas = new String[] {
               "크리스마스섬 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "갈라파고스 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "홍콩 표준시",
               "HKT",
               "홍콩 하계 표준시",
               "HKST",
               "홍콩 시간",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "인도차이나 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "페트로파블롭스크-캄차츠키 표준시",
               "",
               "페트로파블롭스크-캄차츠키 하계 표준시",
               "",
               "페트로파블롭스크-캄차츠키 시간",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "키르기스스탄 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "로드 하우 표준시",
               "",
               "로드 하우 하계 표준시",
               "",
               "로드 하우 시간",
               "",
            };
        final String[] Marquesas = new String[] {
               "마르키즈 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "모리셔스 표준시",
               "",
               "모리셔스 하계 표준시",
               "",
               "모리셔스 시간",
               "",
            };
        final String[] Singapore = new String[] {
               "싱가포르 표준시",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "베네수엘라 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "볼고그라드 표준시",
               "MSK",
               "볼고그라드 하계 표준시",
               "MSK",
               "볼고그라드 시간",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "아제르바이잔 표준시",
               "",
               "아제르바이잔 하계 표준시",
               "",
               "아제르바이잔 시간",
               "",
            };
        final String[] Bangladesh = new String[] {
               "방글라데시 표준시",
               "",
               "방글라데시 하계 표준시",
               "",
               "방글라데시 시간",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "카보 베르데 표준시",
               "",
               "카보 베르데 하계 표준시",
               "",
               "카보 베르데 시간",
               "",
            };
        final String[] East_Timor = new String[] {
               "동티모르 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "카자흐스탄 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "세이셸 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "타지키스탄 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "우즈베키스탄 표준시",
               "",
               "우즈베키스탄 하계 표준시",
               "",
               "우즈베키스탄 시간",
               "",
            };
        final String[] Afghanistan = new String[] {
               "아프가니스탄 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "크라스노야르스크 표준시",
               "",
               "크라스노야르스크 하계 표준시",
               "",
               "크라스노야르스크 시간",
               "",
            };
        final String[] New_Zealand = new String[] {
               "뉴질랜드 표준시",
               "NZST",
               "뉴질랜드 하계 표준시",
               "NZDT",
               "뉴질랜드 시간",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "노보시비르스크 표준시",
               "",
               "노보시비르스크 하계 표준시",
               "",
               "노보시비르스크 시간",
               "",
            };
        final String[] Philippines = new String[] {
               "필리핀 표준시",
               "PST",
               "필리핀 하계 표준시",
               "PDT",
               "필리핀 시간",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "블라디보스토크 표준시",
               "",
               "블라디보스토크 하계 표준시",
               "",
               "블라디보스토크 시간",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "인도양 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "라인 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "뉴펀들랜드 표준시",
               "NST",
               "뉴펀들랜드 하계 표준시",
               "NDT",
               "뉴펀들랜드 시간",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "투르크메니스탄 표준시",
               "",
               "투르크메니스탄 하계 표준시",
               "",
               "투르크메니스탄 시간",
               "",
            };
        final String[] French_Guiana = new String[] {
               "프랑스령 가이아나 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "뉴칼레도니아 표준시",
               "",
               "뉴칼레도니아 하계 표준시",
               "",
               "뉴칼레도니아 시간",
               "",
            };
        final String[] South_Georgia = new String[] {
               "사우스 조지아 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "예카테린부르크 표준시",
               "",
               "예카테린부르크 하계 표준시",
               "",
               "예카테린부르크 시간",
               "",
            };
        final String[] Africa_Central = new String[] {
               "중앙아프리카 시간",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "동아프리카 시간",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "서아프리카 표준시",
               "WAT",
               "서아프리카 하계 표준시",
               "WAT",
               "서아프리카 시간",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "뒤몽뒤르빌 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "중부유럽 표준시",
               "CET",
               "중부유럽 하계 표준시",
               "CEST",
               "중부유럽 시간",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "동유럽 표준시",
               "EET",
               "동유럽 하계 표준시",
               "EEST",
               "동유럽 시간",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "서유럽 표준시",
               "WET",
               "서유럽 하계 표준시",
               "WEST",
               "서유럽 시간",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "멕시코 태평양 표준시",
               "MST",
               "멕시코 태평양 하계 표준시",
               "MDT",
               "멕시코 태평양 시간",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "남아프리카 시간",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "미 중부 표준시",
               "CST",
               "미 중부 하계 표준시",
               "CDT",
               "미 중부 시간",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "미 동부 표준시",
               "EST",
               "미 동부 하계 표준시",
               "EST",
               "미 동부 시간",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "미 태평양 표준시",
               "PST",
               "미 태평양 하계 표준시",
               "PDT",
               "미 태평양 시간",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "프랑스령 남부 식민지 및 남극 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "길버트 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "하와이 알류샨 표준시",
               "HST",
               "하와이 알류샨 하계 표준시",
               "HST",
               "하와이 알류샨 시간",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "피닉스 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "세인트피에르 미클롱 표준시",
               "",
               "세인트피에르 미클롱 하계 표준시",
               "",
               "세인트피에르 미클롱 시간",
               "",
            };
        final String[] America_Mountain = new String[] {
               "미 산악 표준시",
               "MST",
               "미 산지 하계 표준시",
               "MST",
               "미 산지 시간",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "마셜 제도 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "파푸아뉴기니 시간",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "오스트레일리아 중부 표준시",
               "ACST",
               "오스트레일리아 중부 하계 표준시",
               "ACDT",
               "오스트레일리아 중부 시간",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "오스트레일리아 동부 표준시",
               "AEST",
               "오스트레일리아 동부 하계 표준시",
               "AEDT",
               "오스트레일리아 동부 시간",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "오스트레일리아 서부 표준시",
               "AWST",
               "오스트레일리아 서부 하계 표준시",
               "AWDT",
               "오스트레일리아 서부 시간",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "중부 인도네시아 시간",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "동부 인도네시아 시간",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "서부 인도네시아 시간",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "오스트레일리아 중서부 표준시",
               "",
               "오스트레일리아 중서부 하계 표준시",
               "",
               "오스트레일리아 중서부 시간",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "협정 세계시",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "아일랜드 표준시",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "협정 세계시",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "협정 세계시",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "협정 세계시",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "협정 세계시",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "협정 세계시",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "아일랜드 표준시",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "그리니치 표준시",
                    "GMT",
                    "영국 하계 표준시",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "아덴" },
            { "timezone.excity.Asia/Baku", "바쿠" },
            { "timezone.excity.Asia/Dili", "딜리" },
            { "timezone.excity.Asia/Gaza", "가자" },
            { "timezone.excity.Asia/Hovd", "호브드" },
            { "timezone.excity.Asia/Omsk", "옴스크" },
            { "timezone.excity.Asia/Oral", "오랄" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "암만" },
            { "timezone.excity.Asia/Aqtau", "아크타우" },
            { "timezone.excity.Asia/Chita", "치타" },
            { "timezone.excity.Asia/Dhaka", "다카" },
            { "timezone.excity.Asia/Dubai", "두바이" },
            { "timezone.excity.Asia/Kabul", "카불" },
            { "timezone.excity.Asia/Macau", "마카오" },
            { "timezone.excity.Asia/Qatar", "카타르" },
            { "timezone.excity.Asia/Seoul", "서울" },
            { "timezone.excity.Asia/Tokyo", "도쿄" },
            { "timezone.excity.Asia/Tomsk", "톰스크" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "주바" },
            { "timezone.excity.Africa/Lome", "로메" },
            { "timezone.excity.Asia/Almaty", "알마티" },
            { "timezone.excity.Asia/Anadyr", "아나디리" },
            { "timezone.excity.Asia/Aqtobe", "악토브" },
            { "timezone.excity.Asia/Atyrau", "아티라우" },
            { "timezone.excity.Asia/Beirut", "베이루트" },
            { "timezone.excity.Asia/Brunei", "브루나이" },
            { "timezone.excity.Asia/Hebron", "헤브론" },
            { "timezone.excity.Asia/Kuwait", "쿠웨이트" },
            { "timezone.excity.Asia/Manila", "마닐라" },
            { "timezone.excity.Asia/Muscat", "무스카트" },
            { "timezone.excity.Asia/Riyadh", "리야드" },
            { "timezone.excity.Asia/Saigon", "사이공" },
            { "timezone.excity.Asia/Taipei", "타이베이" },
            { "timezone.excity.Asia/Tehran", "테헤란" },
            { "timezone.excity.Asia/Urumqi", "우루무치" },
            { "timezone.excity.Etc/Unknown", "알 수 없는 장소" },
            { "timezone.excity.Europe/Kiev", "키예프" },
            { "timezone.excity.Europe/Oslo", "오슬로" },
            { "timezone.excity.Europe/Riga", "리가" },
            { "timezone.excity.Europe/Rome", "로마" },
            { "timezone.excity.Indian/Mahe", "마헤" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "아크라" },
            { "timezone.excity.Africa/Cairo", "카이로" },
            { "timezone.excity.Africa/Ceuta", "세우타" },
            { "timezone.excity.Africa/Dakar", "다카르" },
            { "timezone.excity.Africa/Lagos", "라고스" },
            { "timezone.excity.Africa/Tunis", "튀니스" },
            { "timezone.excity.America/Adak", "에이닥" },
            { "timezone.excity.America/Lima", "리마" },
            { "timezone.excity.America/Nome", "놈" },
            { "timezone.excity.Asia/Baghdad", "바그다드" },
            { "timezone.excity.Asia/Bahrain", "바레인" },
            { "timezone.excity.Asia/Bangkok", "방콕" },
            { "timezone.excity.Asia/Barnaul", "바르나울" },
            { "timezone.excity.Asia/Bishkek", "비슈케크" },
            { "timezone.excity.Asia/Colombo", "콜롬보" },
            { "timezone.excity.Asia/Irkutsk", "이르쿠츠크" },
            { "timezone.excity.Asia/Jakarta", "자카르타" },
            { "timezone.excity.Asia/Karachi", "카라치" },
            { "timezone.excity.Asia/Kuching", "쿠칭" },
            { "timezone.excity.Asia/Magadan", "마가단" },
            { "timezone.excity.Asia/Nicosia", "니코시아" },
            { "timezone.excity.Asia/Rangoon", "랑군" },
            { "timezone.excity.Asia/Tbilisi", "트빌리시" },
            { "timezone.excity.Asia/Thimphu", "팀부" },
            { "timezone.excity.Asia/Yakutsk", "야쿠츠크" },
            { "timezone.excity.Asia/Yerevan", "예레반" },
            { "timezone.excity.Europe/Kirov", "키로프" },
            { "timezone.excity.Europe/Malta", "몰타" },
            { "timezone.excity.Europe/Minsk", "민스크" },
            { "timezone.excity.Europe/Paris", "파리" },
            { "timezone.excity.Europe/Sofia", "소피아" },
            { "timezone.excity.Europe/Vaduz", "파두츠" },
            { "timezone.excity.Indian/Cocos", "코코스" },
            { "timezone.excity.Pacific/Apia", "아피아" },
            { "timezone.excity.Pacific/Fiji", "피지" },
            { "timezone.excity.Pacific/Guam", "괌" },
            { "timezone.excity.Pacific/Niue", "니우에" },
            { "timezone.excity.Pacific/Truk", "트루크" },
            { "timezone.excity.Pacific/Wake", "웨이크" },
            { "timezone.excity.Africa/Asmera", "아스메라" },
            { "timezone.excity.Africa/Bamako", "바마코" },
            { "timezone.excity.Africa/Bangui", "방기" },
            { "timezone.excity.Africa/Banjul", "반줄" },
            { "timezone.excity.Africa/Bissau", "비사우" },
            { "timezone.excity.Africa/Douala", "두알라" },
            { "timezone.excity.Africa/Harare", "하라레" },
            { "timezone.excity.Africa/Kigali", "키갈리" },
            { "timezone.excity.Africa/Luanda", "루안다" },
            { "timezone.excity.Africa/Lusaka", "루사카" },
            { "timezone.excity.Africa/Malabo", "말라보" },
            { "timezone.excity.Africa/Maputo", "마푸토" },
            { "timezone.excity.Africa/Maseru", "마세루" },
            { "timezone.excity.Africa/Niamey", "니아메" },
            { "timezone.excity.America/Aruba", "아루바" },
            { "timezone.excity.America/Bahia", "바히아" },
            { "timezone.excity.America/Belem", "벨렘" },
            { "timezone.excity.America/Boise", "보이시" },
            { "timezone.excity.America/Jujuy", "후후이" },
            { "timezone.excity.America/Sitka", "싯카" },
            { "timezone.excity.America/Thule", "툴레" },
            { "timezone.excity.Asia/Ashgabat", "아슈하바트" },
            { "timezone.excity.Asia/Calcutta", "콜카타" },
            { "timezone.excity.Asia/Damascus", "다마스쿠스" },
            { "timezone.excity.Asia/Dushanbe", "두샨베" },
            { "timezone.excity.Asia/Jayapura", "자야푸라" },
            { "timezone.excity.Asia/Katmandu", "카트만두" },
            { "timezone.excity.Asia/Khandyga", "한디가" },
            { "timezone.excity.Asia/Makassar", "마카사르" },
            { "timezone.excity.Asia/Qostanay", "코스타나이" },
            { "timezone.excity.Asia/Sakhalin", "사할린" },
            { "timezone.excity.Asia/Shanghai", "상하이" },
            { "timezone.excity.Asia/Tashkent", "타슈켄트" },
            { "timezone.excity.Asia/Ust-Nera", "우스티네라" },
            { "timezone.excity.Europe/Athens", "아테네" },
            { "timezone.excity.Europe/Berlin", "베를린" },
            { "timezone.excity.Europe/Dublin", "더블린" },
            { "timezone.excity.Europe/Jersey", "저지" },
            { "timezone.excity.Europe/Lisbon", "리스본" },
            { "timezone.excity.Europe/London", "런던" },
            { "timezone.excity.Europe/Madrid", "마드리드" },
            { "timezone.excity.Europe/Monaco", "모나코" },
            { "timezone.excity.Europe/Moscow", "모스크바" },
            { "timezone.excity.Europe/Prague", "프라하" },
            { "timezone.excity.Europe/Samara", "사마라" },
            { "timezone.excity.Europe/Skopje", "스코페" },
            { "timezone.excity.Europe/Tirane", "티라나" },
            { "timezone.excity.Europe/Vienna", "비엔나" },
            { "timezone.excity.Europe/Warsaw", "바르샤바" },
            { "timezone.excity.Europe/Zagreb", "자그레브" },
            { "timezone.excity.Europe/Zurich", "취리히" },
            { "timezone.excity.Indian/Chagos", "차고스" },
            { "timezone.excity.Indian/Comoro", "코모로" },
            { "timezone.excity.Pacific/Efate", "에파테" },
            { "timezone.excity.Pacific/Nauru", "나우루" },
            { "timezone.excity.Pacific/Palau", "팔라우" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "아비장" },
            { "timezone.excity.Africa/Algiers", "알제" },
            { "timezone.excity.Africa/Conakry", "코나크리" },
            { "timezone.excity.Africa/Kampala", "캄팔라" },
            { "timezone.excity.Africa/Mbabane", "음바바네" },
            { "timezone.excity.Africa/Nairobi", "나이로비" },
            { "timezone.excity.Africa/Tripoli", "트리폴리" },
            { "timezone.excity.America/Belize", "벨리즈" },
            { "timezone.excity.America/Bogota", "보고타" },
            { "timezone.excity.America/Cancun", "칸쿤" },
            { "timezone.excity.America/Cayman", "케이맨" },
            { "timezone.excity.America/Cuiaba", "쿠이아바" },
            { "timezone.excity.America/Dawson", "도슨" },
            { "timezone.excity.America/Denver", "덴버" },
            { "timezone.excity.America/Guyana", "가이아나" },
            { "timezone.excity.America/Havana", "하바나" },
            { "timezone.excity.America/Inuvik", "이누빅" },
            { "timezone.excity.America/Juneau", "주노" },
            { "timezone.excity.America/La_Paz", "라파스" },
            { "timezone.excity.America/Maceio", "마세이오" },
            { "timezone.excity.America/Manaus", "마나우스" },
            { "timezone.excity.America/Merida", "메리다" },
            { "timezone.excity.America/Nassau", "나소" },
            { "timezone.excity.America/Panama", "파나마" },
            { "timezone.excity.America/Recife", "레시페" },
            { "timezone.excity.America/Regina", "리자이나" },
            { "timezone.excity.Asia/Famagusta", "파마구스타" },
            { "timezone.excity.Asia/Hong_Kong", "홍콩" },
            { "timezone.excity.Asia/Jerusalem", "예루살렘" },
            { "timezone.excity.Asia/Kamchatka", "캄차카" },
            { "timezone.excity.Asia/Pontianak", "폰티아나크" },
            { "timezone.excity.Asia/Pyongyang", "평양" },
            { "timezone.excity.Asia/Qyzylorda", "키질로르다" },
            { "timezone.excity.Asia/Samarkand", "사마르칸트" },
            { "timezone.excity.Asia/Singapore", "싱가포르" },
            { "timezone.excity.Asia/Vientiane", "비엔티안" },
            { "timezone.excity.Europe/Andorra", "안도라" },
            { "timezone.excity.Europe/Saratov", "사라토프" },
            { "timezone.excity.Europe/Tallinn", "탈린" },
            { "timezone.excity.Europe/Vatican", "바티칸" },
            { "timezone.excity.Europe/Vilnius", "빌니우스" },
            { "timezone.excity.Indian/Mayotte", "메요트" },
            { "timezone.excity.Indian/Reunion", "레위니옹" },
            { "timezone.excity.Pacific/Easter", "이스터 섬" },
            { "timezone.excity.Pacific/Kanton", "칸톤" },
            { "timezone.excity.Pacific/Kosrae", "코스레" },
            { "timezone.excity.Pacific/Majuro", "마주로" },
            { "timezone.excity.Pacific/Midway", "미드웨이" },
            { "timezone.excity.Pacific/Noumea", "누메아" },
            { "timezone.excity.Pacific/Ponape", "포나페" },
            { "timezone.excity.Pacific/Saipan", "사이판" },
            { "timezone.excity.Pacific/Tahiti", "타히티" },
            { "timezone.excity.Pacific/Tarawa", "타라와" },
            { "timezone.excity.Pacific/Wallis", "월리스" },
            { "timezone.excity.Africa/Blantyre", "블랜타이어" },
            { "timezone.excity.Africa/Djibouti", "지부티" },
            { "timezone.excity.Africa/El_Aaiun", "엘아이운" },
            { "timezone.excity.Africa/Freetown", "프리타운" },
            { "timezone.excity.Africa/Gaborone", "가보로네" },
            { "timezone.excity.Africa/Khartoum", "카르툼" },
            { "timezone.excity.Africa/Kinshasa", "킨샤사" },
            { "timezone.excity.Africa/Monrovia", "몬로비아" },
            { "timezone.excity.Africa/Ndjamena", "엔자메나" },
            { "timezone.excity.Africa/Sao_Tome", "상투메" },
            { "timezone.excity.Africa/Windhoek", "빈트후크" },
            { "timezone.excity.America/Antigua", "안티과" },
            { "timezone.excity.America/Caracas", "카라카스" },
            { "timezone.excity.America/Cayenne", "카옌" },
            { "timezone.excity.America/Chicago", "시카고" },
            { "timezone.excity.America/Cordoba", "코르도바" },
            { "timezone.excity.America/Creston", "크레스톤" },
            { "timezone.excity.America/Curacao", "퀴라소" },
            { "timezone.excity.America/Detroit", "디트로이트" },
            { "timezone.excity.America/Godthab", "고드호프" },
            { "timezone.excity.America/Grenada", "그레나다" },
            { "timezone.excity.America/Halifax", "핼리팩스" },
            { "timezone.excity.America/Iqaluit", "이칼루이트" },
            { "timezone.excity.America/Jamaica", "자메이카" },
            { "timezone.excity.America/Managua", "마나과" },
            { "timezone.excity.America/Marigot", "마리곳" },
            { "timezone.excity.America/Mendoza", "멘도사" },
            { "timezone.excity.America/Moncton", "몽턴" },
            { "timezone.excity.America/Noronha", "노롱야" },
            { "timezone.excity.America/Ojinaga", "오히나가" },
            { "timezone.excity.America/Phoenix", "피닉스" },
            { "timezone.excity.America/Tijuana", "티후아나" },
            { "timezone.excity.America/Toronto", "토론토" },
            { "timezone.excity.America/Tortola", "토르톨라" },
            { "timezone.excity.America/Yakutat", "야쿠타트" },
            { "timezone.excity.Asia/Phnom_Penh", "프놈펜" },
            { "timezone.excity.Atlantic/Azores", "아조레스" },
            { "timezone.excity.Atlantic/Canary", "카나리아 제도" },
            { "timezone.excity.Atlantic/Faeroe", "페로 제도" },
            { "timezone.excity.Australia/Eucla", "유클라" },
            { "timezone.excity.Australia/Perth", "퍼스" },
            { "timezone.excity.Europe/Belgrade", "베오그라드" },
            { "timezone.excity.Europe/Brussels", "브뤼셀" },
            { "timezone.excity.Europe/Budapest", "부다페스트" },
            { "timezone.excity.Europe/Busingen", "뷔지겐" },
            { "timezone.excity.Europe/Chisinau", "키시나우" },
            { "timezone.excity.Europe/Guernsey", "건지" },
            { "timezone.excity.Europe/Helsinki", "헬싱키" },
            { "timezone.excity.Europe/Istanbul", "이스탄불" },
            { "timezone.excity.Europe/Sarajevo", "사라예보" },
            { "timezone.excity.Indian/Maldives", "몰디브" },
            { "timezone.excity.Pacific/Chatham", "채텀" },
            { "timezone.excity.Pacific/Fakaofo", "파카오푸" },
            { "timezone.excity.Pacific/Gambier", "감비어" },
            { "timezone.excity.Pacific/Norfolk", "노퍽" },
            { "timezone.excity.Africa/Bujumbura", "부줌부라" },
            { "timezone.excity.Africa/Mogadishu", "모가디슈" },
            { "timezone.excity.America/Anguilla", "앙귈라" },
            { "timezone.excity.America/Asuncion", "아순시온" },
            { "timezone.excity.America/Barbados", "바베이도스" },
            { "timezone.excity.America/Dominica", "도미니카" },
            { "timezone.excity.America/Edmonton", "에드먼턴" },
            { "timezone.excity.America/Eirunepe", "아이루네페" },
            { "timezone.excity.America/Mazatlan", "마사틀란" },
            { "timezone.excity.America/Miquelon", "미클롱" },
            { "timezone.excity.America/New_York", "뉴욕" },
            { "timezone.excity.America/Resolute", "리졸루트" },
            { "timezone.excity.America/Santarem", "산타렘" },
            { "timezone.excity.America/Santiago", "산티아고" },
            { "timezone.excity.America/St_Johns", "세인트존스" },
            { "timezone.excity.America/St_Kitts", "세인트키츠" },
            { "timezone.excity.America/St_Lucia", "세인트루시아" },
            { "timezone.excity.America/Winnipeg", "위니펙" },
            { "timezone.excity.Antarctica/Casey", "케이시" },
            { "timezone.excity.Antarctica/Davis", "데이비스" },
            { "timezone.excity.Antarctica/Syowa", "쇼와" },
            { "timezone.excity.Antarctica/Troll", "트롤" },
            { "timezone.excity.Asia/Krasnoyarsk", "크라스노야르스크" },
            { "timezone.excity.Asia/Novosibirsk", "노보시비르스크" },
            { "timezone.excity.Asia/Ulaanbaatar", "울란바토르" },
            { "timezone.excity.Asia/Vladivostok", "블라디보스토크" },
            { "timezone.excity.Atlantic/Bermuda", "버뮤다" },
            { "timezone.excity.Atlantic/Madeira", "마데이라" },
            { "timezone.excity.Atlantic/Stanley", "스탠리" },
            { "timezone.excity.Australia/Darwin", "다윈" },
            { "timezone.excity.Australia/Hobart", "호바트" },
            { "timezone.excity.Australia/Sydney", "시드니" },
            { "timezone.excity.Europe/Amsterdam", "암스테르담" },
            { "timezone.excity.Europe/Astrakhan", "아스트라한" },
            { "timezone.excity.Europe/Bucharest", "부쿠레슈티" },
            { "timezone.excity.Europe/Gibraltar", "지브롤터" },
            { "timezone.excity.Europe/Ljubljana", "류블랴나" },
            { "timezone.excity.Europe/Mariehamn", "마리에함" },
            { "timezone.excity.Europe/Podgorica", "포드고리차" },
            { "timezone.excity.Europe/Stockholm", "스톡홀름" },
            { "timezone.excity.Europe/Ulyanovsk", "울리야노프스크" },
            { "timezone.excity.Europe/Volgograd", "볼고그라트" },
            { "timezone.excity.Indian/Christmas", "크리스마스" },
            { "timezone.excity.Indian/Kerguelen", "케르켈렌" },
            { "timezone.excity.Indian/Mauritius", "모리셔스" },
            { "timezone.excity.Pacific/Auckland", "오클랜드" },
            { "timezone.excity.Pacific/Funafuti", "푸나푸티" },
            { "timezone.excity.Pacific/Honolulu", "호놀룰루" },
            { "timezone.excity.Pacific/Pitcairn", "핏케언" },
            { "timezone.excity.Africa/Casablanca", "카사블랑카" },
            { "timezone.excity.Africa/Libreville", "리브르빌" },
            { "timezone.excity.Africa/Lubumbashi", "루붐바시" },
            { "timezone.excity.Africa/Nouakchott", "누악쇼트" },
            { "timezone.excity.Africa/Porto-Novo", "포르토노보" },
            { "timezone.excity.America/Anchorage", "앵커리지" },
            { "timezone.excity.America/Araguaina", "아라과이나" },
            { "timezone.excity.America/Boa_Vista", "보아 비스타" },
            { "timezone.excity.America/Catamarca", "카타마르카" },
            { "timezone.excity.America/Chihuahua", "치와와" },
            { "timezone.excity.America/Fortaleza", "포르탈레자" },
            { "timezone.excity.America/Glace_Bay", "글라스베이" },
            { "timezone.excity.America/Goose_Bay", "구즈베이" },
            { "timezone.excity.America/Guatemala", "과테말라" },
            { "timezone.excity.America/Guayaquil", "과야킬" },
            { "timezone.excity.America/Matamoros", "마타모로스" },
            { "timezone.excity.America/Menominee", "메노미니" },
            { "timezone.excity.America/Monterrey", "몬테레이" },
            { "timezone.excity.America/Sao_Paulo", "상파울루" },
            { "timezone.excity.America/St_Thomas", "세인트토마스" },
            { "timezone.excity.America/Vancouver", "벤쿠버" },
            { "timezone.excity.Antarctica/Mawson", "모슨" },
            { "timezone.excity.Antarctica/Palmer", "파머" },
            { "timezone.excity.Antarctica/Vostok", "보스토크" },
            { "timezone.excity.Asia/Kuala_Lumpur", "쿠알라룸푸르" },
            { "timezone.excity.Asia/Novokuznetsk", "노보쿠즈네츠크" },
            { "timezone.excity.Europe/Bratislava", "브라티슬라바" },
            { "timezone.excity.Europe/Copenhagen", "코펜하겐" },
            { "timezone.excity.Europe/Luxembourg", "룩셈부르크" },
            { "timezone.excity.Europe/San_Marino", "산마리노" },
            { "timezone.excity.Europe/Simferopol", "심페로폴" },
            { "timezone.excity.Pacific/Enderbury", "엔더베리" },
            { "timezone.excity.Pacific/Galapagos", "갈라파고스" },
            { "timezone.excity.Pacific/Kwajalein", "콰잘렌" },
            { "timezone.excity.Pacific/Marquesas", "마퀘사스" },
            { "timezone.excity.Pacific/Pago_Pago", "파고파고" },
            { "timezone.excity.Pacific/Rarotonga", "라로통가" },
            { "timezone.excity.Pacific/Tongatapu", "통가타푸" },
            { "timezone.excity.Africa/Addis_Ababa", "아디스아바바" },
            { "timezone.excity.Africa/Brazzaville", "브라자빌" },
            { "timezone.excity.Africa/Ouagadougou", "와가두구" },
            { "timezone.excity.America/Costa_Rica", "코스타리카" },
            { "timezone.excity.America/Grand_Turk", "그랜드 터크" },
            { "timezone.excity.America/Guadeloupe", "과들루프" },
            { "timezone.excity.America/Hermosillo", "에르모시요" },
            { "timezone.excity.America/Kralendijk", "크라렌디즈크" },
            { "timezone.excity.America/Louisville", "루이빌" },
            { "timezone.excity.America/Martinique", "마티니크" },
            { "timezone.excity.America/Metlakatla", "메틀라카틀라" },
            { "timezone.excity.America/Montevideo", "몬테비데오" },
            { "timezone.excity.America/Montserrat", "몬세라트" },
            { "timezone.excity.America/Paramaribo", "파라마리보" },
            { "timezone.excity.America/Rio_Branco", "히우 브랑쿠" },
            { "timezone.excity.America/St_Vincent", "세인트빈센트" },
            { "timezone.excity.America/Whitehorse", "화이트호스" },
            { "timezone.excity.Antarctica/McMurdo", "맥머도" },
            { "timezone.excity.Antarctica/Rothera", "로데라" },
            { "timezone.excity.Asia/Srednekolymsk", "스레드네콜림스크" },
            { "timezone.excity.Asia/Yekaterinburg", "예카테린부르크" },
            { "timezone.excity.Atlantic/Reykjavik", "레이캬비크" },
            { "timezone.excity.Atlantic/St_Helena", "세인트 헬레나" },
            { "timezone.excity.Australia/Adelaide", "애들레이드" },
            { "timezone.excity.Australia/Brisbane", "브리스베인" },
            { "timezone.excity.Australia/Lindeman", "린데만" },
            { "timezone.excity.Europe/Isle_of_Man", "맨섬" },
            { "timezone.excity.Europe/Kaliningrad", "칼리닌그라드" },
            { "timezone.excity.Pacific/Kiritimati", "키리티마티" },
            { "timezone.excity.Africa/Johannesburg", "요하네스버그" },
            { "timezone.excity.America/El_Salvador", "엘살바도르" },
            { "timezone.excity.America/Fort_Nelson", "포트 넬슨" },
            { "timezone.excity.America/Los_Angeles", "로스앤젤레스" },
            { "timezone.excity.America/Mexico_City", "멕시코 시티" },
            { "timezone.excity.America/Porto_Velho", "포르토벨료" },
            { "timezone.excity.America/Puerto_Rico", "푸에르토리코" },
            { "timezone.excity.America/Tegucigalpa", "테구시갈파" },
            { "timezone.excity.Arctic/Longyearbyen", "롱이어비엔" },
            { "timezone.excity.Atlantic/Cape_Verde", "카보 베르데" },
            { "timezone.excity.Australia/Lord_Howe", "로드 하우" },
            { "timezone.excity.Australia/Melbourne", "멜버른" },
            { "timezone.excity.Indian/Antananarivo", "안타나나리보" },
            { "timezone.excity.Pacific/Guadalcanal", "과달카날" },
            { "timezone.excity.Africa/Dar_es_Salaam", "다르에스살람" },
            { "timezone.excity.America/Blanc-Sablon", "블랑 사블롱" },
            { "timezone.excity.America/Buenos_Aires", "부에노스 아이레스" },
            { "timezone.excity.America/Campo_Grande", "캄포 그란데" },
            { "timezone.excity.America/Danmarkshavn", "덴마크샤븐" },
            { "timezone.excity.America/Dawson_Creek", "도슨크릭" },
            { "timezone.excity.America/Indiana/Knox", "인디애나주, 녹스" },
            { "timezone.excity.America/Indianapolis", "인디애나폴리스" },
            { "timezone.excity.America/Punta_Arenas", "푼타아레나스" },
            { "timezone.excity.America/Rankin_Inlet", "랭킹 인렛" },
            { "timezone.excity.America/Scoresbysund", "스코레스바이선드" },
            { "timezone.excity.Antarctica/Macquarie", "맥쿼리" },
            { "timezone.excity.Pacific/Bougainville", "부갱빌" },
            { "timezone.excity.Pacific/Port_Moresby", "포트모르즈비" },
            { "timezone.excity.America/Cambridge_Bay", "케임브리지 베이" },
            { "timezone.excity.America/Ciudad_Juarez", "시우다드후아레스" },
            { "timezone.excity.America/Coral_Harbour", "코랄하버" },
            { "timezone.excity.America/Indiana/Vevay", "인디애나주, 비비" },
            { "timezone.excity.America/Lower_Princes", "로워 프린스 쿼터" },
            { "timezone.excity.America/Port_of_Spain", "포트오브스페인" },
            { "timezone.excity.America/Santo_Domingo", "산토도밍고" },
            { "timezone.excity.America/St_Barthelemy", "생바르텔레미" },
            { "timezone.excity.America/Swift_Current", "스위프트커런트" },
            { "timezone.excity.Australia/Broken_Hill", "브로컨힐" },
            { "timezone.excity.America/Bahia_Banderas", "바이아 반데라스" },
            { "timezone.excity.America/Port-au-Prince", "포르토프랭스" },
            { "timezone.excity.Atlantic/South_Georgia", "사우스조지아" },
            { "timezone.excity.America/Argentina/Salta", "살타" },
            { "timezone.excity.America/Indiana/Marengo", "인디애나주, 머렝고" },
            { "timezone.excity.America/Indiana/Winamac", "인디애나주, 위너맥" },
            { "timezone.excity.America/Argentina/Tucuman", "투쿠만" },
            { "timezone.excity.America/Argentina/Ushuaia", "우수아이아" },
            { "timezone.excity.America/Indiana/Tell_City", "인디애나주, 텔시티" },
            { "timezone.excity.America/Indiana/Vincennes", "인디애나주, 빈센스" },
            { "timezone.excity.Antarctica/DumontDUrville", "뒤몽 뒤르빌" },
            { "timezone.excity.America/Argentina/La_Rioja", "라 리오하" },
            { "timezone.excity.America/Argentina/San_Juan", "산후안" },
            { "timezone.excity.America/Argentina/San_Luis", "산루이스" },
            { "timezone.excity.America/Indiana/Petersburg", "인디애나주, 피츠버그" },
            { "timezone.excity.America/Kentucky/Monticello", "켄터키주, 몬티첼로" },
            { "timezone.excity.America/North_Dakota/Beulah", "노스다코타주, 베라" },
            { "timezone.excity.America/North_Dakota/Center", "중부, 노스다코타" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "리오 가예고스" },
            { "timezone.excity.America/North_Dakota/New_Salem", "노스다코타주, 뉴살렘" },
        };
        return data;
    }
}
