/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ak extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Berɛ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia Susudua Berɛ",
               "",
               "Apia Awia Berɛ",
               "",
               "Apia Berɛ",
               "",
            };
        final String[] Cook = new String[] {
               "Kuk Aeland Susudua Berɛ",
               "",
               "Kuk Aeland Awia Fa Berɛ",
               "",
               "Kuk Aeland Berɛ",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba Susudua Berɛ",
               "CST",
               "Kuba Awia Berɛ",
               "CDT",
               "Kuba Berɛ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Figyi Susudua Berɛ",
               "",
               "Figyi Awia Berɛ",
               "",
               "Figyi Berɛ",
               "",
            };
        final String[] Gulf = new String[] {
               "Gɔɔfo Susudua Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd Susudua Berɛ",
               "",
               "Hovd Awia Berɛ",
               "",
               "Hovd Berɛ",
               "",
            };
        final String[] Iran = new String[] {
               "Iran Susudua Berɛ",
               "",
               "Iran Awia Berɛ",
               "",
               "Iran Berɛ",
               "",
            };
        final String[] Niue = new String[] {
               "Niue Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk Susudua Berɛ",
               "",
               "Omsk Awia Berɛ",
               "",
               "Omsk Berɛ",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Susudua Berɛ",
               "",
               "Peru Awia Berɛ",
               "",
               "Peru Berɛ",
               "",
            };
        final String[] Truk = new String[] {
               "Kyuuk Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Kyili Susudua Berɛ",
               "",
               "Kyili Awia Berɛ",
               "",
               "Kyili Berɛ",
               "",
            };
        final String[] China = new String[] {
               "Kyaena Susudua Berɛ",
               "CST",
               "Kyaena Awia Berɛ",
               "CDT",
               "Kyaena Berɛ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokoso Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India Susudua Berɛ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Gyapan Susudua Berɛ",
               "JST",
               "Gyapan Awia Berɛ",
               "JDT",
               "Gyapan Berɛ",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korean Susudua Berɛ",
               "KST",
               "Korean Awia Berɛ",
               "KST",
               "Korean Berɛ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nɛpal Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Susudua Berɛ",
               "SST",
               "Samoa Awia Berɛ",
               "SST",
               "Samoa Berɛ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga Susudua Berɛ",
               "",
               "Tonga Awia Berɛ",
               "",
               "Tonga Berɛ",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukɔn Berɛ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska Susudua Berɛ",
               "AKST",
               "Alaska Awia Berɛ",
               "AKDT",
               "Alaska Berɛ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon Susudua Berɛ",
               "",
               "Amazon Awia Berɛ",
               "",
               "Amazon Berɛ",
               "",
            };
        final String[] Azores = new String[] {
               "Azores Susudua Berɛ",
               "",
               "Azores Awia Berɛ",
               "",
               "Azores Berɛ",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darusalam Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Easta Aeland Susudua Berɛ",
               "",
               "Easta Aeland Awia Berɛ",
               "",
               "Easta Aeland Berɛ",
               "",
            };
        final String[] Guyana = new String[] {
               "Gayana Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel Susudua Berɛ",
               "IST",
               "Israel Awia Berɛ",
               "IDT",
               "Israel Berɛ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mɔɔson Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Mɔsko Susudua Berɛ",
               "MSK",
               "Mɔsko Awia Berɛ",
               "MSK",
               "Mɔsko Berɛ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Susudua Berɛ",
               "CST",
               "Taipei Awia Berɛ",
               "CDT",
               "Taipei Berɛ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis ne Futuna Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabia Susudua Berɛ",
               "",
               "Arabia Awia Berɛ",
               "",
               "Arabia Berɛ",
               "",
            };
        final String[] Armenia = new String[] {
               "Aamenia Susudua Berɛ",
               "",
               "Aamenia Awia Berɛ",
               "",
               "Aamenia Berɛ",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Kyatam Susudua Berɛ",
               "",
               "Kyatam Awia Berɛ",
               "",
               "Kyatam Berɛ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Amansan Kɔdinatɛde Berɛ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Yikuwedɔ Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gyɔgyea Susudua Berɛ",
               "",
               "Gyɔgyea Awia Berɛ",
               "",
               "Gyɔgyea Berɛ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk Susudua Berɛ",
               "",
               "Irkutsk Awia Berɛ",
               "",
               "Irkutsk Berɛ",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan Susudua Berɛ",
               "",
               "Magadan Awia Berɛ",
               "",
               "Magadan Berɛ",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mayaama Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Nɔɔfɔk Aeland Susudua Berɛ",
               "",
               "Nɔɔfɔk Aeland Awia Berɛ",
               "",
               "Nɔɔfɔk Aeland Berɛ",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Susudua Berɛ",
               "",
               "Fernando de Noronha Awia Berɛ",
               "",
               "Fernando de Noronha Berɛ",
               "",
            };
        final String[] Reunion = new String[] {
               "Réunion Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Yurugwae Susudua Berɛ",
               "",
               "Yurugwae Awia Berɛ",
               "",
               "Yurugwae Berɛ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Susudua Berɛ",
               "",
               "Vanuatu Awia Berɛ",
               "",
               "Vanuatu Berɛ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Susudua Berɛ",
               "",
               "Yakutsk Awia Berɛ",
               "",
               "Yakutsk Berɛ",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik Susudua Berɛ",
               "AST",
               "Atlantik Awia Berɛ",
               "AST",
               "Atlantik Berɛ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Susudua Berɛ",
               "",
               "Brasilia Awia Berɛ",
               "",
               "Brasilia Berɛ",
               "",
            };
        final String[] Chamorro = new String[] {
               "Kyamoro Susudua Berɛ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolombia Susudua Berɛ",
               "",
               "Kolombia Awia Berɛ",
               "",
               "Kolombia Berɛ",
               "",
            };
        final String[] Falkland = new String[] {
               "Fɔkman Aeland Susudua Berɛ",
               "",
               "Fɔkman Aeland Awia Berɛ",
               "",
               "Fɔkman Aeland Berɛ",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malehyia Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Yulanbata Susudua Berɛ",
               "",
               "Yulanbata Awia Berɛ",
               "",
               "Yulanbata Berɛ",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Susudua Berɛ",
               "PKT",
               "Pakistan Awia Berɛ",
               "PKST",
               "Pakistan Berɛ",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguae Susudua Berɛ",
               "",
               "Paraguae Awia Berɛ",
               "",
               "Paraguae Berɛ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkairn Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin Susudua Berɛ",
               "",
               "Sakhalin Awia Berɛ",
               "",
               "Sakhalin Berɛ",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Agyɛntina Susudua Berɛ",
               "",
               "Agyɛntina Awia Berɛ",
               "",
               "Agyɛntina Berɛ",
               "",
            };
        final String[] Christmas = new String[] {
               "Buronya Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagɔs Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hɔnkɔn Susudua Berɛ",
               "HKT",
               "Hɔnkɔn Awia Berɛ",
               "HKST",
               "Hɔnkɔn Berɛ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indɔkyina Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kɛɛgestan Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lɔd Howe Susudua Berɛ",
               "",
               "Lɔd Howe Awia Berɛ",
               "",
               "Lɔd Howe Berɛ",
               "",
            };
        final String[] Marquesas = new String[] {
               "Makesase Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mɔrihyiɔso Susudua Berɛ",
               "",
               "Mɔrihyiɔso Awia Berɛ",
               "",
               "Mɔrihyiɔso Berɛ",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapɔ Susudua Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd Susudua Berɛ",
               "MSK",
               "Volgograd Awia Berɛ",
               "MSK",
               "Volgograd Berɛ",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Asabegyan Susudua Berɛ",
               "",
               "Asabegyan Awia Berɛ",
               "",
               "Asabegyan Berɛ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladɛhye Susudua Berɛ",
               "",
               "Bangladɛhye Awia Berɛ",
               "",
               "Bangladɛhye Berɛ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kepvɛde Susudua Berɛ",
               "",
               "Kepvɛde Awia Berɛ",
               "",
               "Kepvɛde Berɛ",
               "",
            };
        final String[] East_Timor = new String[] {
               "Timɔɔ Apueeɛ Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazakstan Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seyhyɛl Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tagyikistan Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbɛkistan Susudua Berɛ",
               "",
               "Usbɛkistan Awia Berɛ",
               "",
               "Usbɛkistan Berɛ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Susudua Berɛ",
               "",
               "Krasnoyarsk Awia Berɛ",
               "",
               "Krasnoyarsk Berɛ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ziland Foforɔ Susudua Berɛ",
               "NZST",
               "Ziland Foforɔ Awia Berɛ",
               "NZDT",
               "Ziland Foforɔ Berɛ",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Susudua Berɛ",
               "",
               "Novosibirsk Awia Berɛ",
               "",
               "Novosibirsk Berɛ",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipin Susudua Berɛ",
               "PST",
               "Filipin Awia Berɛ",
               "PDT",
               "Filipin Berɛ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Susudua Berɛ",
               "",
               "Vladivostok Awia Berɛ",
               "",
               "Vladivostok Berɛ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "India Po Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lai Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Susudua Berɛ",
               "NST",
               "Newfoundland Awia Berɛ",
               "NDT",
               "Newfoundland Berɛ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Tɛkmɛnistan Susudua Berɛ",
               "",
               "Tɛkmɛnistan Awia Berɛ",
               "",
               "Tɛkmɛnistan Berɛ",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frɛnkye Gayana Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Kaledonia Foforɔ Susudua Berɛ",
               "",
               "Kaledonia Foforɔ Awia Berɛ",
               "",
               "Kaledonia Foforɔ Berɛ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Gyɔɔgyia Anaafoɔ Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yɛkatɛrinbɛg Susudua Berɛ",
               "",
               "Yɛkatɛrinbɛg Awia Berɛ",
               "",
               "Yɛkatɛrinbɛg Berɛ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afrika Finimfin Berɛ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afrika Apueeɛ Berɛ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Afrika Atɔeɛ Susudua Berɛ",
               "WAT",
               "Afrika Atɔeɛ Awia Berɛ",
               "WAT",
               "Afrika Atɔeɛ Berɛ",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Yuropu Mfinimfini Susudua Berɛ",
               "CET",
               "Yuropu Mfinimfini Awia Berɛ",
               "CEST",
               "Yuropu Mfinimfini Berɛ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Yuropu Apueeɛ Susudua Berɛ",
               "EET",
               "Yuropu Apueeɛ Awia Berɛ",
               "EEST",
               "Yuropu Apueeɛ Berɛ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Yuropu Atɔeeɛ Susudua Berɛ",
               "WET",
               "Yuropu Atɔeeɛ Awia Berɛ",
               "WEST",
               "Yuropu Atɔeeɛ Berɛ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mɛksiko Pasifik Susudua Berɛ",
               "MST",
               "Mɛksiko Pasifik Awia Berɛ",
               "MDT",
               "Mɛksiko Pasifik Berɛ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Afrika Anaafoɔ Susudua Berɛ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Mfinimfini Susudua Berɛ",
               "CST",
               "Mfinimfini Awia Berɛ",
               "CDT",
               "Mfinimfini Berɛ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Apueeɛ Susudua Berɛ",
               "EST",
               "Apueeɛ Awia Berɛ",
               "EST",
               "Apueeɛ Berɛ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pasifik Susudua Berɛ",
               "PST",
               "Pasifik Awia Berɛ",
               "PDT",
               "Pasifik Berɛ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frɛnkye Anaafoɔ ne Antaatik Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Geebɛt Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian Susudua Berɛ",
               "HST",
               "Hawaii-Aleutian Awia Berɛ",
               "HST",
               "Hawaii-Aleutian Berɛ",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Finise Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon Susudua Berɛ",
               "",
               "St. Pierre & Miquelon Awia Berɛ",
               "",
               "St. Pierre & Miquelon Berɛ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Bepɔ Susudua Berɛ",
               "MST",
               "Bepɔ Awia Berɛ",
               "MST",
               "Bepɔ Berɛ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Mahyaa Aeland Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Gini Foforɔ Berɛ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ɔstrelia Mfinimfini Susudua Berɛ",
               "ACST",
               "Ɔstrelia Mfinimfini Awia Berɛ",
               "ACDT",
               "Ɔstrelia Mfinimfini Berɛ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ɔstrelia Apueeɛ Susudua Berɛ",
               "AEST",
               "Ɔstrelia Apueeɛ Awia Berɛ",
               "AEDT",
               "Ɔstrelia Apueeɛ Berɛ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ɔstrelia Atɔeeɛ Susudua Berɛ",
               "AWST",
               "Ɔstrelia Atɔeeɛ Awia Berɛ",
               "AWDT",
               "Ɔstrelia Atɔeeɛ Berɛ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indɔnehyia Mfinimfini Berɛ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indɔnehyia Apueeɛ Berɛ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indɔnehyia Atɔeeɛ Berɛ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ɔstrelia Mfinimfini Atɔeeɛ Susudua Berɛ",
               "",
               "Ɔstrelia Mfinimfini Atɔeeɛ Awia Berɛ",
               "",
               "Ɔstrelia Mfinimfini Atɔeeɛ Berɛ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Amansan Kɔdinatɛde Berɛ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Irelandfoɔ Susudua Berɛ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Amansan Kɔdinatɛde Berɛ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Amansan Kɔdinatɛde Berɛ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Amansan Kɔdinatɛde Berɛ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Amansan Kɔdinatɛde Berɛ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Amansan Kɔdinatɛde Berɛ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Irelandfoɔ Susudua Berɛ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Berɛ",
                    "GMT",
                    "Ingresi Awia Berɛ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Kyita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Qatar", "Kata" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Dwuba" },
            { "timezone.excity.Asia/Almaty", "Aamati" },
            { "timezone.excity.Asia/Aqtobe", "Aktopɛ" },
            { "timezone.excity.Asia/Beirut", "Bɛɛrut" },
            { "timezone.excity.Asia/Hebron", "Hɛbrɔn" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Saigon", "Ho Kyi Min" },
            { "timezone.excity.Asia/Tehran", "Tɛɛran" },
            { "timezone.excity.Asia/Urumqi", "Yurymki" },
            { "timezone.excity.Etc/Unknown", "Baabi a yɛnnim" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akraa" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Ceuta", "Kyuta" },
            { "timezone.excity.Africa/Dakar", "Dakaa" },
            { "timezone.excity.Africa/Lagos", "Legɔs" },
            { "timezone.excity.Asia/Bangkok", "Bankɔk" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Jakarta", "Gyakaata" },
            { "timezone.excity.Asia/Karachi", "Karakyi" },
            { "timezone.excity.Asia/Kuching", "Kukyin" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Thimphu", "Timphu" },
            { "timezone.excity.Europe/Malta", "Mɔɔta" },
            { "timezone.excity.Europe/Sofia", "Sɔfia" },
            { "timezone.excity.Indian/Cocos", "Kokoso" },
            { "timezone.excity.Pacific/Fiji", "Figyi" },
            { "timezone.excity.Pacific/Truk", "Kyuuk" },
            { "timezone.excity.Africa/Banjul", "Bandwuu" },
            { "timezone.excity.Africa/Bissau", "Bisaw" },
            { "timezone.excity.America/Belem", "Bɛlɛm" },
            { "timezone.excity.America/Boise", "Bɔisi" },
            { "timezone.excity.America/Jujuy", "Dwudwui" },
            { "timezone.excity.Asia/Calcutta", "Kɔɔkata" },
            { "timezone.excity.Asia/Damascus", "Damaskɔso" },
            { "timezone.excity.Asia/Jayapura", "Gyayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Makassar", "Makasa" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Berlin", "Bɛɛlin" },
            { "timezone.excity.Europe/Dublin", "Dɔblin" },
            { "timezone.excity.Europe/Jersey", "Jɛɛsi" },
            { "timezone.excity.Europe/Lisbon", "Lisbɔn" },
            { "timezone.excity.Europe/London", "Lɔndɔn" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Mɔsko" },
            { "timezone.excity.Europe/Skopje", "Skɔpgye" },
            { "timezone.excity.Europe/Vienna", "Veɛna" },
            { "timezone.excity.Europe/Warsaw", "Wɔɔsɔɔ" },
            { "timezone.excity.Europe/Zurich", "Zurekye" },
            { "timezone.excity.Indian/Chagos", "Kyagɔs" },
            { "timezone.excity.Indian/Comoro", "Kɔmɔrɔ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abigyan" },
            { "timezone.excity.Africa/Algiers", "Ɔlgyese" },
            { "timezone.excity.Africa/Conakry", "Kɔnakri" },
            { "timezone.excity.America/Belize", "Bɛlisi" },
            { "timezone.excity.America/Cayman", "Kemanfo" },
            { "timezone.excity.America/Cuiaba", "Kuiaba" },
            { "timezone.excity.America/Dawson", "Dɔɔson" },
            { "timezone.excity.America/Denver", "Dɛnva" },
            { "timezone.excity.America/Guyana", "Gayana" },
            { "timezone.excity.America/Maceio", "Makeio" },
            { "timezone.excity.America/Recife", "Rɛsifɛ" },
            { "timezone.excity.America/Regina", "Rɛgyina" },
            { "timezone.excity.Asia/Jerusalem", "Yerusalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamkyatka" },
            { "timezone.excity.Asia/Singapore", "Singapɔ" },
            { "timezone.excity.Asia/Vientiane", "Vienhyiane" },
            { "timezone.excity.Europe/Andorra", "Andɔra" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Indian/Mayotte", "Mayote" },
            { "timezone.excity.Pacific/Easter", "Easta" },
            { "timezone.excity.Pacific/Majuro", "Magyuro" },
            { "timezone.excity.Pacific/Ponape", "Pɔnpei" },
            { "timezone.excity.Africa/Blantyre", "Blantai" },
            { "timezone.excity.Africa/Djibouti", "Gyibuuti" },
            { "timezone.excity.Africa/Kinshasa", "Kinhyaahya" },
            { "timezone.excity.Africa/Ndjamena", "Ngyamena" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Cayenne", "Kayiini" },
            { "timezone.excity.America/Chicago", "Kyikago" },
            { "timezone.excity.America/Cordoba", "Kɔɔdɔba" },
            { "timezone.excity.America/Creston", "Krɛston" },
            { "timezone.excity.America/Curacao", "Kurukaw" },
            { "timezone.excity.America/Detroit", "Detrɔit" },
            { "timezone.excity.America/Iqaluit", "Ikaluit" },
            { "timezone.excity.America/Jamaica", "Gyameka" },
            { "timezone.excity.America/Marigot", "Marigɔt" },
            { "timezone.excity.America/Mendoza", "Mɛndɔsa" },
            { "timezone.excity.America/Moncton", "Mɔnktin" },
            { "timezone.excity.America/Ojinaga", "Ogyinaga" },
            { "timezone.excity.America/Phoenix", "Finisk" },
            { "timezone.excity.America/Tijuana", "Tidwuana" },
            { "timezone.excity.America/Tortola", "Tɔɔtola" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Australia/Eucla", "Eukla" },
            { "timezone.excity.Australia/Perth", "Pɛɛt" },
            { "timezone.excity.Europe/Belgrade", "Bɛlgrade" },
            { "timezone.excity.Europe/Brussels", "Brɛsɛlse" },
            { "timezone.excity.Europe/Budapest", "Budapɛsh" },
            { "timezone.excity.Europe/Busingen", "Busingye" },
            { "timezone.excity.Europe/Chisinau", "Kyisinau" },
            { "timezone.excity.Europe/Helsinki", "Hɛlsinki" },
            { "timezone.excity.Europe/Sarajevo", "Saragyevo" },
            { "timezone.excity.Pacific/Chatham", "Kyatam" },
            { "timezone.excity.Pacific/Norfolk", "Nɔɔfɔk" },
            { "timezone.excity.Africa/Bujumbura", "Budwumbura" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Barbados", "Baabados" },
            { "timezone.excity.America/Dominica", "Dɔmeneka" },
            { "timezone.excity.America/Edmonton", "Edmɔnton" },
            { "timezone.excity.America/Mazatlan", "Masatlan" },
            { "timezone.excity.America/New_York", "New Yɔk" },
            { "timezone.excity.America/Resolute", "Rɛsɔlut" },
            { "timezone.excity.America/Winnipeg", "Winipɛg" },
            { "timezone.excity.Antarctica/Casey", "Kasi" },
            { "timezone.excity.Antarctica/Troll", "Trɔɔ" },
            { "timezone.excity.Asia/Ulaanbaatar", "Yulanbata" },
            { "timezone.excity.Atlantic/Bermuda", "Bɛmuda" },
            { "timezone.excity.Atlantic/Stanley", "Stanli" },
            { "timezone.excity.Australia/Darwin", "Daawin" },
            { "timezone.excity.Australia/Hobart", "Hɔbat" },
            { "timezone.excity.Australia/Sydney", "Sidni" },
            { "timezone.excity.Europe/Amsterdam", "Amstadam" },
            { "timezone.excity.Europe/Bucharest", "Bukyarɛst" },
            { "timezone.excity.Europe/Gibraltar", "Gyebrota" },
            { "timezone.excity.Europe/Ljubljana", "Ldwubdwana" },
            { "timezone.excity.Europe/Podgorica", "Podgorika" },
            { "timezone.excity.Europe/Stockholm", "Stɔkhɔm" },
            { "timezone.excity.Indian/Christmas", "Buronya" },
            { "timezone.excity.Indian/Kerguelen", "Kɛguelɛn" },
            { "timezone.excity.Indian/Mauritius", "Mɔrihyiɔso" },
            { "timezone.excity.Pacific/Auckland", "Aukland" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkairne" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.America/Anchorage", "Ankɔragyi" },
            { "timezone.excity.America/Catamarca", "Katamaaka" },
            { "timezone.excity.America/Chihuahua", "Kyihuahua" },
            { "timezone.excity.America/Fortaleza", "Fɔɔtalɛsa" },
            { "timezone.excity.America/Goose_Bay", "Guus Bay" },
            { "timezone.excity.America/Guatemala", "Guwatemala" },
            { "timezone.excity.America/Guayaquil", "Gayakwuil" },
            { "timezone.excity.America/Matamoros", "Matamɔrɔso" },
            { "timezone.excity.America/Menominee", "Mɛnɔminee" },
            { "timezone.excity.America/Monterrey", "Mɔntirii" },
            { "timezone.excity.Antarctica/Mawson", "Mɔɔson" },
            { "timezone.excity.Antarctica/Palmer", "Paama" },
            { "timezone.excity.Antarctica/Vostok", "Vɔstɔk" },
            { "timezone.excity.Europe/Copenhagen", "Kɔpɛhangɛne" },
            { "timezone.excity.Europe/Luxembourg", "Lɛsembɛg" },
            { "timezone.excity.Pacific/Galapagos", "Galapagɔs" },
            { "timezone.excity.Pacific/Kwajalein", "Kwagyaleene" },
            { "timezone.excity.Pacific/Marquesas", "Maakesase" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kɔsta Rika" },
            { "timezone.excity.America/Grand_Turk", "Grand Tuk" },
            { "timezone.excity.America/Guadeloupe", "Guwadelup" },
            { "timezone.excity.America/Hermosillo", "Hɛmɔsilo" },
            { "timezone.excity.America/Kralendijk", "Kralɛngyik" },
            { "timezone.excity.America/Martinique", "Martinike" },
            { "timezone.excity.America/Metlakatla", "Mɛtlakatla" },
            { "timezone.excity.America/Montserrat", "Mantserat" },
            { "timezone.excity.America/Paramaribo", "Paramaribɔ" },
            { "timezone.excity.America/Rio_Branco", "Rio Branko" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Yekaterinburg", "Yɛkatɛrinbɛg" },
            { "timezone.excity.Atlantic/Reykjavik", "Rɛɛkgyavik" },
            { "timezone.excity.America/El_Salvador", "El Salvadɔɔ" },
            { "timezone.excity.America/Fort_Nelson", "Fɔt Nɛlson" },
            { "timezone.excity.America/Los_Angeles", "Lɔs Angyɛlis" },
            { "timezone.excity.America/Mexico_City", "Mɛksiko Siti" },
            { "timezone.excity.America/Porto_Velho", "Pɔɔto Velho" },
            { "timezone.excity.America/Puerto_Rico", "Puɛto Riko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kepvɛde" },
            { "timezone.excity.Australia/Lord_Howe", "Lɔd Howe" },
            { "timezone.excity.Australia/Melbourne", "Mɛɛbɔn" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadaakanaa" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablɔn" },
            { "timezone.excity.America/Campo_Grande", "Kampo Grande" },
            { "timezone.excity.America/Dawson_Creek", "Dɔɔson Kreek" },
            { "timezone.excity.America/Indianapolis", "Indianapɔlis" },
            { "timezone.excity.America/Scoresbysund", "Yitokɔtuɔmete" },
            { "timezone.excity.Antarctica/Macquarie", "Makaari" },
            { "timezone.excity.Pacific/Port_Moresby", "Pɔt Morɛsbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kambrigyi Bay" },
            { "timezone.excity.America/Lower_Princes", "Lowa Prinse Kɔta" },
            { "timezone.excity.America/Port_of_Spain", "Spain Pɔɔto" },
            { "timezone.excity.America/St_Barthelemy", "St. Baatilemi" },
            { "timezone.excity.America/Swift_Current", "Swift Kɛrɛnt" },
            { "timezone.excity.Australia/Broken_Hill", "Brɔken Hill" },
            { "timezone.excity.Atlantic/South_Georgia", "Gyɔɔgyia Anaafoɔ" },
            { "timezone.excity.America/Indiana/Winamac", "Winamak, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell Siti, Indiana" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riogya" },
            { "timezone.excity.America/Argentina/San_Juan", "San Dwuan" },
            { "timezone.excity.America/Indiana/Petersburg", "Pitɛsbɛgye, Indiana" },
            { "timezone.excity.America/Kentucky/Monticello", "Mɔntisɛlo, Kɛntɛki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beula, Nɔf Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Sɛnta, Nɔf Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegɔs" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salɛm, Nɔf Dakota" },
        };
        return data;
    }
}
