/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ks extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "گریٖن وِچ میٖن ٹایِم",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "اؠکرے سٹینڑاڑ ٹایِم",
               "",
               "اؠکرے سَمَر ٹایِم",
               "",
               "اؠکرے ٹایِم",
               "",
            };
        final String[] Cook = new String[] {
               "کُک اَیلینڑز سٹینڑاڑ ٹایِم",
               "",
               "کُک اَیلینڑز حاف سَمَر ٹایِم",
               "",
               "کُک اَیلینڑز ٹایِم",
               "",
            };
        final String[] Cuba = new String[] {
               "کیوٗبا سٹینڑاڑ ٹایِم",
               "CST",
               "کیوٗبا ڈےلایِٔٹ ٹایِم",
               "CDT",
               "کیوٗبا ٹایِم",
               "CT",
            };
        final String[] Fiji = new String[] {
               "فیٖجی سٹینڑاڑ ٹایِم",
               "",
               "فیٖجی سَمَر ٹایِم",
               "",
               "فیٖجی ٹایِم",
               "",
            };
        final String[] Gulf = new String[] {
               "گَلف سٹینڈرڈ ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "حووڑ سٹینڈرڈ ٹایِم",
               "",
               "حووڑ سَمَر ٹایِم",
               "",
               "حووڑ ٹایِم",
               "",
            };
        final String[] Iran = new String[] {
               "اِیٖرٲنؠ سٹینڑاڑ ٹایِم",
               "",
               "اِیٖرٲنی سَمَر ٹایِم",
               "",
               "اِیٖرٲنؠ ٹایِم",
               "",
            };
        final String[] Niue = new String[] {
               "نِیوٗ ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "اۄمسک سٹینڈرڈ ٹایِم",
               "",
               "اۄمسک سَمَر ٹایِم",
               "",
               "اۄمسک ٹایِم",
               "",
            };
        final String[] Peru = new String[] {
               "پٔروٗ سٹینڈرڈ ٹایِم",
               "",
               "پٔروٗ سَمَر ٹایِم",
               "",
               "پٔروٗ ٹایِم",
               "",
            };
        final String[] Truk = new String[] {
               "ٹٔرک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ویک ججیٖرُک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "چِلی سٹینڑاڑ ٹایِم",
               "",
               "چِلی سَمَر ٹایِم",
               "",
               "چِلی ٹایِم",
               "",
            };
        final String[] China = new String[] {
               "چَینا سٹینڈرڈ ٹایِم",
               "CST",
               "چَینا ڈےلایِٔٹ ٹایِم",
               "CDT",
               "چَینا ٹایِم",
               "CT",
            };
        final String[] Cocos = new String[] {
               "کوکوز اَیلینڑز ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ڑیوِس ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ہِندوستان",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "جاپٲنؠ سٹینڈرڈ ٹایِم",
               "JST",
               "جاپٲنؠ ڑےلایِٔٹ ٹایِم",
               "JDT",
               "جاپٲنؠ ٹایِم",
               "JT",
            };
        final String[] Korea = new String[] {
               "کورِیا سٹینڈرڈ ٹایِم",
               "KST",
               "کورِیا ڑےلایِٔٹ ٹایِم",
               "KST",
               "کورِیا ٹایِم",
               "KST",
            };
        final String[] Nauru = new String[] {
               "نَعوٗروٗ ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "نؠپٲلؠ ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "پَلاو ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "سؠموآ سٹینڑاڑ ٹایِم",
               "SST",
               "سؠموآ سَمَر ٹایِم",
               "SST",
               "سؠموآ ٹایِم",
               "SST",
            };
        final String[] Syowa = new String[] {
               "سیووا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ٹعانگا سٹینڑاڑ ٹایِم",
               "",
               "ٹعانگا سَمَر ٹایِم",
               "",
               "ٹعانگا ٹایِم",
               "",
            };
        final String[] Yukon = new String[] {
               "یوکون ٹائم",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "اؠلاسکا سٹینڑاڑ ٹایِم",
               "AKST",
               "اؠلاسکا ڈےلایِٔٹ ٹایِم",
               "AKDT",
               "اؠلاسکا ٹایِم",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "اؠمَزَن سٹینڑاڑ ٹایِم",
               "",
               "اؠمَزَن سَمَر ٹایِم",
               "",
               "اؠمَزَن ٹایِم",
               "",
            };
        final String[] Anadyr = new String[] {
               "اؠنَڑیٖر سٹینڑاڑ ٹایِم",
               "",
               "اؠنڑیٖر سَمَر ٹایِم",
               "",
               "اؠنَڑیٖر ٹایِم",
               "",
            };
        final String[] Azores = new String[] {
               "اؠزورٕس سٹینڑاڑ ٹایِم",
               "",
               "اؠزورٕس سَمَر ٹائم",
               "",
               "اؠزورٕس ٹایِم",
               "",
            };
        final String[] Bhutan = new String[] {
               "بوٗٹان ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "بروٗنَے دَروٗسَلَم ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ایٖسٹَر جزیرٕ سٹینڈرڈ ٹایِم",
               "",
               "ایٖسٹَر جزیرٕ سَمَر ٹایِم",
               "",
               "ایٖسٹَر جزیرٕ ٹایِم",
               "",
            };
        final String[] Guyana = new String[] {
               "گُیَنا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "اِسرٲیِلی سٹینڈرڈ ٹایِم",
               "IST",
               "اِسرٲیِلی ڑےلایِٔٹ ٹایِم",
               "IDT",
               "اِسرٲیِلی ٹایِم",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "کورسَے ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ماسَن ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ماسکو سٹینڈرڈ ٹایِم",
               "MSK",
               "ماسکو سَمَر ٹایِم",
               "MSK",
               "ماسکَو ٹایِم",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "پونیپ ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "سمؠرا سٹینڑاڑ ٹایِم",
               "",
               "سمؠرا سَمَر ٹایِم",
               "",
               "سمؠرا ٹایِم",
               "",
            };
        final String[] Tahiti = new String[] {
               "ٹاہِٹی ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ٹے پے سٹینڈرڈ ٹائم",
               "CST",
               "ٹے پے ڈے لائٹ ٹائم",
               "CDT",
               "ٹے پے ٹائم",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ٹوٗوَلوٗ ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ووسٹوک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "والِس تہٕ فیوٗٹیوٗنا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ارؠبِیَن سٹینڈرڈ ٹایِم",
               "",
               "ارؠبِیَن ڈےلایِٔٹ ٹایِم",
               "",
               "ارؠبِیَن ٹایِم",
               "",
            };
        final String[] Armenia = new String[] {
               "ارمیٖنِیا سٹینڈرڈ ٹایِم",
               "",
               "ارمیٖنِیا سَمَر ٹایِم",
               "",
               "ارمیٖنِیا ٹایِم",
               "",
            };
        final String[] Bolivia = new String[] {
               "بولِوِیا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "کؠتھَم سٹینڑاڑ ٹایِم",
               "",
               "چؠتھَم سَمَر ٹایِم",
               "",
               "کؠتھَم ٹایِم",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "کوآرڈنیٹڈ یونیورسل وَکھ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "اِکویڑَر ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "گؠمبِیَر ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "جورجِیاہُک سٹینڈرڈ ٹایِم",
               "",
               "جورجِیاہُک سَمَر ٹایِم",
               "",
               "جورجِیاہُک ٹایِم",
               "",
            };
        final String[] Irkutsk = new String[] {
               "اِرکُٹسک سٹینڈرڈ ٹایِم",
               "",
               "اِرکُٹسک سَمَر ٹایِم",
               "",
               "اِرکُٹسک ٹایِم",
               "",
            };
        final String[] Magadan = new String[] {
               "مَگَدَن سٹینڈرڈ ٹایِم",
               "",
               "مَگَدَن سَمَر ٹایِم",
               "",
               "مَگَدَن ٹایِم",
               "",
            };
        final String[] Myanmar = new String[] {
               "مِیانمَر ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "نورفعاک سٹینڑاڑ ٹایِم",
               "",
               "نورفعاک سَمَر ٹایِم",
               "",
               "نورفعاک ٹایِم",
               "",
            };
        final String[] Noronha = new String[] {
               "فرنینڈو ڈی نورونہا سٹینڈرڈ ٹائم",
               "",
               "فرنینڈو ڈی نورونہا سَمَر ٹائم",
               "",
               "فرنینڈو ڈی نورونہا ٹائم",
               "",
            };
        final String[] Reunion = new String[] {
               "رِیوٗنِیَن ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "روتھؠرا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "سولومَن ججیٖرَن ہُند ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ٹوکؠلو ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "یوٗرؠگوَے سٹینڈرڈ ٹایِم",
               "",
               "یوٗرؠگوَے سَمَر ٹایِم",
               "",
               "یوٗرؠگوَے ٹایِم",
               "",
            };
        final String[] Vanuatu = new String[] {
               "وَنوٗاَٹوٗ سٹینڑاڑ ٹایِم",
               "",
               "وَنوٗاَٹوٗ سَمَر ٹایِم",
               "",
               "وَنوٗاَٹوٗ ٹایِم",
               "",
            };
        final String[] Yakutsk = new String[] {
               "یَکُٹسک سٹینڈرڈ ٹایِم",
               "",
               "یَکُٹُسک سَمَر ٹایِم",
               "",
               "یَکُٹسک ٹایِم",
               "",
            };
        final String[] Atlantic = new String[] {
               "اؠٹلانٹِک سٹینڑاڑ ٹایِم",
               "AST",
               "اؠٹلانٹِک ڈےلایِٔٹ ٹایِم",
               "AST",
               "اؠٹلانٹِک ٹایِم",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "برؠسِلِیا سٹینڑاڑ ٹایِم",
               "",
               "برؠسِلِیا سَمَر ٹایِم",
               "",
               "برؠسِلِیا ٹایِم",
               "",
            };
        final String[] Chamorro = new String[] {
               "کؠمورو سٹینڑاڑ ٹایِم",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "کولومبِیا سٹینڑاڑ ٹایِم",
               "",
               "کولومبِیا سَمَر ٹایِم",
               "",
               "کولومبِیا ٹایِم",
               "",
            };
        final String[] Falkland = new String[] {
               "فالک لینڈ جزیرٕ سٹینڈرڈ ٹائم",
               "",
               "فالک لینڈ جزیرٕ سَمَر ٹائم",
               "",
               "فالک لینڈ جزیرٕ ٹائم",
               "",
            };
        final String[] Malaysia = new String[] {
               "مَلیشِیا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "مالدیٖوٕز ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "اولن باٹر سٹینڈرڈ ٹائم",
               "",
               "اولن باٹر سَمَر ٹایِم",
               "",
               "اولن باٹر ٹائم",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاکِستان سٹینڑاڑ ٹایِم",
               "PKT",
               "پاکِستان سَمَر ٹایِم",
               "PKST",
               "پاکِستان ٹایِم",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پیرؠگوے سٹینڈرڈ ٹایِم",
               "",
               "پیرؠگوے سَمَر ٹایِم",
               "",
               "پیرؠگوے ٹایِم",
               "",
            };
        final String[] Pitcairn = new String[] {
               "پِٹکیرٕن ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "سَکھؠلِن سٹینڈرڈ ٹایِم",
               "",
               "سَکھؠلِن سَمَر ٹایِم",
               "",
               "سَکھؠلِن ٹایِم",
               "",
            };
        final String[] Suriname = new String[] {
               "سُرِنام ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ارجؠنٹیٖنا سٹینڑاڑ ٹایِم",
               "",
               "ارجؠنٹیٖنا سَمَر ٹایِم",
               "",
               "ارجؠنٹیٖنا ٹایِم",
               "",
            };
        final String[] Christmas = new String[] {
               "کرسمَس ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "گؠلؠپیگوز ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ہانگ کانگ سٹینڈرڈ ٹائم",
               "HKT",
               "ہانگ کانگ سَمر ٹائم",
               "HKST",
               "ہانگ کانگ ٹائم",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "اِنڑوچَینا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "کَمچَٹکا سٹینڑاڑ ٹایِم",
               "",
               "کَمچَٹکا سَمَر ٹایِم",
               "",
               "کَمچَٹکا ٹایِم",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "کرغزستان ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "لعاڑ حووے سٹینڑاڑ ٹایِم",
               "",
               "لعاڑ ڑےلایٔٹ ٹایِم",
               "",
               "لعاڑ حووے ٹایِم",
               "",
            };
        final String[] Marquesas = new String[] {
               "مارقیوٗسَس ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "مورِشَس سٹینڈرڈ ٹایِم",
               "",
               "مورِشَس سَمَر ٹایِم",
               "",
               "مورِشَس ٹایِم",
               "",
            };
        final String[] Singapore = new String[] {
               "سِنگاپوٗر ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "وؠنؠزیوٗلا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "وولگوگریڑ سٹینڈرڈ ٹایِم",
               "MSK",
               "وولگوگریڑ سَمَر ٹایِم",
               "MSK",
               "وولگوگریڑ ٹایِم",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "ازربائیجان سٹینڈرڈ ٹائم",
               "",
               "ازربائیجان سَمَر ٹائم",
               "",
               "ازربائیجان ٹائم",
               "",
            };
        final String[] Bangladesh = new String[] {
               "بَنگلادیش سٹینڑاڑ ٹایِم",
               "",
               "بَنگلادیش سَمَر ٹایِم",
               "",
               "بَنگلادیش ٹایِم",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "کیپ ؤرڑو سٹینڈرڈ ٹایِم",
               "",
               "کیپ سَمَر ٹایِم",
               "",
               "کیپ ؤرڑو ٹایِم",
               "",
            };
        final String[] East_Timor = new String[] {
               "ایٖسٹ ٹیٖمَر ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "سیشؠلٕز ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجکستان ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "اُزبیکِستان سٹینڈرڈ ٹایِم",
               "",
               "اُزبیکِستانُک سَمَر ٹایِم",
               "",
               "اُزبیکِستان ٹایِم",
               "",
            };
        final String[] Afghanistan = new String[] {
               "افغانِستان ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "کرؠسنوےیارسک سٹینڈرڈ ٹایِم",
               "",
               "کرؠسنوےیارسک سَمَر ٹایِم",
               "",
               "کرؠسنوےیارسک ٹایِم",
               "",
            };
        final String[] New_Zealand = new String[] {
               "نِوزِلینڑ سٹینڑاڑ ٹایِم",
               "NZST",
               "نِوزِلینڑ ڑےلایٔٹ ٹایِم",
               "NZDT",
               "نِوزِلینڑ ٹایِم",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "نۄوۄسِبٔرسک سٹینڈرڈ ٹایِم",
               "",
               "نۄوۄسِبٔرسک سَمَر ٹایِم",
               "",
               "نۄوۄسِبٔرسک ٹایِم",
               "",
            };
        final String[] Philippines = new String[] {
               "پھِلِپایِن سٹینڑاڑ ٹایِم",
               "PST",
               "پھِلِپایِن سَمَر ٹایِم",
               "PDT",
               "پھِلِپایِن ٹایِم",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ولاڑِووسٹوک سٹینڈرڈ ٹایِم",
               "",
               "ولاڑِووسٹوک سَمَر ٹایِم",
               "",
               "ولاڑِووسٹوک ٹایِم",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ہِندوستٲنؠ اوشَن ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "لایِٔن ججیٖرُک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "نیو فاؤنڈ لینڈ سٹینڈرڈ ٹائم",
               "NST",
               "نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم",
               "NDT",
               "نیو فاؤنڈ لینڈ ٹائم",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ترکمانستان سٹینڈرڈ ٹائم",
               "",
               "تُرکمؠنِستان سَمَر ٹایِم",
               "",
               "ترکمانستان ٹائم",
               "",
            };
        final String[] French_Guiana = new String[] {
               "فرؠنچ گیوٗؠنا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "نِو کیلؠڑونِیا سٹینڑاڑ ٹایِم",
               "",
               "نِو کیلؠڑونِیس سَمَر ٹایِم",
               "",
               "نِو کیلؠڑونِیا ٹایِم",
               "",
            };
        final String[] South_Georgia = new String[] {
               "شُمٲلی جورجِیا ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "یؠکَٹٔرِنبٔرگ سٹینڈرڈ ٹایِم",
               "",
               "یؠکَٹرِنبٔرگ سَمَر ٹایِم",
               "",
               "یؠکَٹٔرِنبٔرگ ٹایِم",
               "",
            };
        final String[] Africa_Central = new String[] {
               "مرکزی افریٖقا ٹایِم",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "مشرقی افریٖقا ٹایِم",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "مغربی افریٖقا سٹینڈرڈ ٹایِم",
               "WAT",
               "مغربی افریٖقا سَمَر ٹایِم",
               "WAT",
               "مغربی افریٖقا ٹایِم",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ڑمانٹ ڈی اُرویٖل ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "مرکزی یوٗرپی سٹینڑاڑ ٹایِم",
               "CET",
               "مرکزی یوٗرپی سَمَر ٹایِم",
               "CEST",
               "مرکزی یوٗرپی ٹایِم",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "مشرقی یوٗرپی سٹینڑاڑ ٹایِم",
               "EET",
               "مشرقی یوٗرپی سَمَر ٹایِم",
               "EEST",
               "مشرقی یوٗرپی ٹایِم",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "مغرِبی یوٗرپی سٹینڈرڈ ٹایِم",
               "WET",
               "مغرِبی یوٗرِپی سَمَر ٹایِم",
               "WEST",
               "مغرِبی یوٗرپی ٹایِم",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "میکسیکن پیسیفک سٹینڈرڈ ٹائم",
               "MST",
               "میکسیکن پیسیفک ڈے لائٹ ٹائم",
               "MDT",
               "میکسیکن پیسیفک ٹائم",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "جنوٗبی افریقا ٹایِم",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "مرکزی سٹینڑاڑ ٹایِم",
               "CST",
               "مرکزی ڈےلایِٔٹ ٹایِم",
               "CDT",
               "مرکزی ٹایِم",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "مشرقی سٹینڑاڑ ٹایِم",
               "EST",
               "مشرقی ڈےلایِٔٹ ٹایِم",
               "EST",
               "مشرقی ٹایِم",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "پیسِفِک سٹینڑاڑ ٹایِم",
               "PST",
               "پیسِفِک ڈےلایِٔٹ ٹایِم",
               "PDT",
               "پیسِفِک ٹایِم",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "فرینچ جنوبی تٕہ انٹارکٹِک ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "گِلبٲٹ ججیٖرُک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "حَواے اؠلیوٗٹِیَن سٹینڑاڑ ٹایِم",
               "HST",
               "حَواے اؠلیوٗٹِیَن سَمَر ٹایِم",
               "HST",
               "حَواے اؠلیوٗٹِیَن ٹایِم",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "پھونِکس ججیٖرُک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "سینٹ پَیری مِقیوٗلَن سٹینڑاڑ ٹایِم",
               "",
               "سینٹ پَیری مِقیوٗلَن ڑےلایِٔٹ ٹایِم",
               "",
               "سینٹ پَیری مِقیوٗلَن ٹایِم",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ماونٹین سٹینڑاڑ ٹایِم",
               "MST",
               "ماونٹین ڈےلایِٔٹ ٹایِم",
               "MST",
               "ماونٹین ٹایِم",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "مارشَل ججیٖرُک ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "پاپُعا نیوٗ گؠنی ٹایِم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "آسٹریلِیَن مرکزی سٹینڑاڑ ٹایِم",
               "ACST",
               "آسٹریلِیَن مرکزی ڈےلایِٔٹ ٹایِم",
               "ACDT",
               "مرکزی آسٹریلِیَن ٹایِم",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "آسٹریلِیَن مشرقی سٹینڑاڑ ٹایِم",
               "AEST",
               "آسٹریلِیَن مشرقی ڈےلایِٔٹ ٹایِم",
               "AEDT",
               "مشرِقی آسٹریلِیا ٹایِم",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "آسٹریلِیَن مغرِبی سٹینڑاڑ ٹایِم",
               "AWST",
               "آسٹریلِیَن مغرِبیٖ ڈےلایٔٹ ٹایِم",
               "AWDT",
               "مغرِبی آسٹریلِیا ٹایِم",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "مرکزی اِنڑونیشِیا ٹایِم",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "مشرِقی اِنڑونیشِیا ٹایِم",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "مغرِبی اِنڑونیشِیا ٹایِم",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "آسٹریلِیَن مرکزی مغربی سٹینڑاڑ ٹایِم",
               "",
               "آسٹریلِیَن مرکزی مغربی ڈےلایِٔٹ ٹایِم",
               "",
               "آسٹریلِیَن مرکزی مغربی ٹایِم",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "کوآرڈنیٹڈ یونیورسل وَکھ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "اَیرِش سَمَر ٹایِم",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "کوآرڈنیٹڈ یونیورسل وَکھ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "کوآرڈنیٹڈ یونیورسل وَکھ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "کوآرڈنیٹڈ یونیورسل وَکھ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "کوآرڈنیٹڈ یونیورسل وَکھ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "کوآرڈنیٹڈ یونیورسل وَکھ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "اَیرِش سَمَر ٹایِم",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "گریٖن وِچ میٖن ٹایِم",
                    "GMT",
                    "برطٲنوی سَمَر ٹایِم",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ایڈٕن" },
            { "timezone.excity.Asia/Baku", "باقوٗ" },
            { "timezone.excity.Asia/Dili", "دِلی" },
            { "timezone.excity.Asia/Gaza", "غزہ" },
            { "timezone.excity.Asia/Hovd", "حووڑ" },
            { "timezone.excity.Asia/Omsk", "اومسک" },
            { "timezone.excity.Asia/Oral", "اورَل" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "اَمان" },
            { "timezone.excity.Asia/Aqtau", "اکٹو" },
            { "timezone.excity.Asia/Chita", "چیٹا" },
            { "timezone.excity.Asia/Dhaka", "ڈھاکا" },
            { "timezone.excity.Asia/Dubai", "دُبئی" },
            { "timezone.excity.Asia/Kabul", "قابُل" },
            { "timezone.excity.Asia/Macau", "مکو" },
            { "timezone.excity.Asia/Qatar", "قطر" },
            { "timezone.excity.Asia/Seoul", "سیول" },
            { "timezone.excity.Asia/Tokyo", "ٹوکیو" },
            { "timezone.excity.Asia/Tomsk", "ٹومسک" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جوبا" },
            { "timezone.excity.Africa/Lome", "لوم" },
            { "timezone.excity.Asia/Almaty", "اَلماٹی" },
            { "timezone.excity.Asia/Anadyr", "اَنَدیر" },
            { "timezone.excity.Asia/Aqtobe", "اَقٹوب" },
            { "timezone.excity.Asia/Atyrau", "اٹیرو" },
            { "timezone.excity.Asia/Beirut", "بیرٹ" },
            { "timezone.excity.Asia/Brunei", "بروٗنَے" },
            { "timezone.excity.Asia/Hebron", "ہیبرون" },
            { "timezone.excity.Asia/Kuwait", "کُویت" },
            { "timezone.excity.Asia/Manila", "مَنیٖلا" },
            { "timezone.excity.Asia/Muscat", "مسقط" },
            { "timezone.excity.Asia/Riyadh", "ریاض" },
            { "timezone.excity.Asia/Saigon", "سیگَن" },
            { "timezone.excity.Asia/Taipei", "تَیپیے" },
            { "timezone.excity.Asia/Tehran", "تؠہران" },
            { "timezone.excity.Asia/Urumqi", "اُرومقی" },
            { "timezone.excity.Etc/Unknown", "غٲر زان" },
            { "timezone.excity.Europe/Kiev", "کیٖو" },
            { "timezone.excity.Europe/Oslo", "اوسلو" },
            { "timezone.excity.Europe/Riga", "رِگا" },
            { "timezone.excity.Europe/Rome", "روم" },
            { "timezone.excity.Indian/Mahe", "ماہیے" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "اؠکرا" },
            { "timezone.excity.Africa/Cairo", "کَیرو" },
            { "timezone.excity.Africa/Ceuta", "کیوٗٹا" },
            { "timezone.excity.Africa/Dakar", "دَکار" },
            { "timezone.excity.Africa/Lagos", "لیگوس" },
            { "timezone.excity.Africa/Tunis", "ٹوٗنِس" },
            { "timezone.excity.America/Adak", "ادک" },
            { "timezone.excity.America/Lima", "لِما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "بغداد" },
            { "timezone.excity.Asia/Bahrain", "بؠہریٖن" },
            { "timezone.excity.Asia/Bangkok", "بینگ کاک" },
            { "timezone.excity.Asia/Barnaul", "برنول" },
            { "timezone.excity.Asia/Bishkek", "بِشکیک" },
            { "timezone.excity.Asia/Colombo", "کولَمبو" },
            { "timezone.excity.Asia/Irkutsk", "اِرکُسک" },
            { "timezone.excity.Asia/Jakarta", "جکارتا" },
            { "timezone.excity.Asia/Karachi", "کَراچی" },
            { "timezone.excity.Asia/Kuching", "کُچِنگ" },
            { "timezone.excity.Asia/Magadan", "مَگادَن" },
            { "timezone.excity.Asia/Nicosia", "نِکوسِیا" },
            { "timezone.excity.Asia/Rangoon", "رنگوٗن" },
            { "timezone.excity.Asia/Tbilisi", "بِلِسی" },
            { "timezone.excity.Asia/Thimphu", "تھِمپوٗ" },
            { "timezone.excity.Asia/Yakutsk", "یکوسک" },
            { "timezone.excity.Asia/Yerevan", "یےریوَن" },
            { "timezone.excity.Europe/Kirov", "کیرو" },
            { "timezone.excity.Europe/Malta", "مالٹا" },
            { "timezone.excity.Europe/Minsk", "مِنسک" },
            { "timezone.excity.Europe/Paris", "پیرِس" },
            { "timezone.excity.Europe/Sofia", "سوفِیا" },
            { "timezone.excity.Europe/Vaduz", "وادُز" },
            { "timezone.excity.Indian/Cocos", "کوکوس" },
            { "timezone.excity.Pacific/Apia", "آپِیا" },
            { "timezone.excity.Pacific/Fiji", "فِجی" },
            { "timezone.excity.Pacific/Guam", "گوام" },
            { "timezone.excity.Pacific/Niue", "نِو" },
            { "timezone.excity.Pacific/Truk", "ٹرک" },
            { "timezone.excity.Pacific/Wake", "ویک" },
            { "timezone.excity.Africa/Asmera", "اَسمیرا" },
            { "timezone.excity.Africa/Bamako", "بماکو" },
            { "timezone.excity.Africa/Bangui", "بؠنگوٗیی" },
            { "timezone.excity.Africa/Banjul", "بَنجوٗل" },
            { "timezone.excity.Africa/Bissau", "بِساؤں" },
            { "timezone.excity.Africa/Douala", "ڈوولا" },
            { "timezone.excity.Africa/Harare", "ہَراریے" },
            { "timezone.excity.Africa/Kigali", "کِگالی" },
            { "timezone.excity.Africa/Luanda", "لیوانڈا" },
            { "timezone.excity.Africa/Lusaka", "لوساکا" },
            { "timezone.excity.Africa/Malabo", "مالابو" },
            { "timezone.excity.Africa/Maputo", "مَپوٗٹو" },
            { "timezone.excity.Africa/Maseru", "مَسیروٗ" },
            { "timezone.excity.Africa/Niamey", "نَیمیے" },
            { "timezone.excity.America/Aruba", "اَروٗبا" },
            { "timezone.excity.America/Bahia", "بَہِیا" },
            { "timezone.excity.America/Belem", "بؠلؠم" },
            { "timezone.excity.America/Boise", "بویِس" },
            { "timezone.excity.America/Jujuy", "جُجویے" },
            { "timezone.excity.America/Sitka", "سِٹکا" },
            { "timezone.excity.America/Thule", "تھیوٗلے" },
            { "timezone.excity.Asia/Ashgabat", "اَشگَبَت" },
            { "timezone.excity.Asia/Damascus", "دَمَسکَس" },
            { "timezone.excity.Asia/Dushanbe", "دُشانبیے" },
            { "timezone.excity.Asia/Jayapura", "جَیاپوٗرا" },
            { "timezone.excity.Asia/Katmandu", "کاٹھمَنڈوٗ" },
            { "timezone.excity.Asia/Khandyga", "کھانڈیگا" },
            { "timezone.excity.Asia/Makassar", "مَکَسَر" },
            { "timezone.excity.Asia/Qostanay", "کوسٹانے" },
            { "timezone.excity.Asia/Sakhalin", "سَکھالِن" },
            { "timezone.excity.Asia/Shanghai", "شانگے" },
            { "timezone.excity.Asia/Tashkent", "تاشکینٹ" },
            { "timezone.excity.Asia/Ust-Nera", "اوسٹ-نیرا" },
            { "timezone.excity.Europe/Athens", "اؠتھٕنس" },
            { "timezone.excity.Europe/Berlin", "بٔرلِن" },
            { "timezone.excity.Europe/Dublin", "ڈَبلِن" },
            { "timezone.excity.Europe/Jersey", "جرسی" },
            { "timezone.excity.Europe/Lisbon", "لِسبَن" },
            { "timezone.excity.Europe/London", "لَندَن" },
            { "timezone.excity.Europe/Madrid", "میڈریڈ" },
            { "timezone.excity.Europe/Monaco", "موناکو" },
            { "timezone.excity.Europe/Moscow", "ماسکو" },
            { "timezone.excity.Europe/Prague", "پراگ" },
            { "timezone.excity.Europe/Samara", "سَمارا" },
            { "timezone.excity.Europe/Skopje", "سِکوپیے" },
            { "timezone.excity.Europe/Tirane", "ٹِرین" },
            { "timezone.excity.Europe/Vienna", "وِیَننا" },
            { "timezone.excity.Europe/Warsaw", "وارسا" },
            { "timezone.excity.Europe/Zagreb", "زگریب" },
            { "timezone.excity.Europe/Zurich", "زیوٗرِک" },
            { "timezone.excity.Indian/Chagos", "چاگوس" },
            { "timezone.excity.Indian/Comoro", "کومورو" },
            { "timezone.excity.Pacific/Efate", "ایفاتیے" },
            { "timezone.excity.Pacific/Nauru", "ناوروٗ" },
            { "timezone.excity.Pacific/Palau", "پَلاو" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "عابِدجان" },
            { "timezone.excity.Africa/Algiers", "اَلجیٖرِیا" },
            { "timezone.excity.Africa/Conakry", "کوناکری" },
            { "timezone.excity.Africa/Kampala", "کَمپالا" },
            { "timezone.excity.Africa/Mbabane", "مابین" },
            { "timezone.excity.Africa/Nairobi", "نیروبی" },
            { "timezone.excity.Africa/Tripoli", "ترپولی" },
            { "timezone.excity.America/Belize", "بؠلیٖز" },
            { "timezone.excity.America/Bogota", "بوگوٹا" },
            { "timezone.excity.America/Cancun", "کینکَن" },
            { "timezone.excity.America/Cayman", "کیمَن" },
            { "timezone.excity.America/Cuiaba", "کوٗیابا" },
            { "timezone.excity.America/Dawson", "ڈاوسن" },
            { "timezone.excity.America/Denver", "ڈینوَر" },
            { "timezone.excity.America/Guyana", "گُیانا" },
            { "timezone.excity.America/Havana", "حوانا" },
            { "timezone.excity.America/Inuvik", "اِنوٗوِک" },
            { "timezone.excity.America/Juneau", "جوٗنی" },
            { "timezone.excity.America/La_Paz", "لا پاز" },
            { "timezone.excity.America/Maceio", "میسِیوو" },
            { "timezone.excity.America/Manaus", "مَنوس" },
            { "timezone.excity.America/Merida", "میرِڈا" },
            { "timezone.excity.America/Nassau", "نساؤں" },
            { "timezone.excity.America/Panama", "پَناما" },
            { "timezone.excity.America/Recife", "ریسیف" },
            { "timezone.excity.America/Regina", "رؠجیٖنا" },
            { "timezone.excity.Asia/Famagusta", "فاما گوسٹا" },
            { "timezone.excity.Asia/Hong_Kong", "ہانگ کانگ" },
            { "timezone.excity.Asia/Jerusalem", "یروشلم" },
            { "timezone.excity.Asia/Kamchatka", "کَمچھٹکا" },
            { "timezone.excity.Asia/Pontianak", "پونتِعانک" },
            { "timezone.excity.Asia/Pyongyang", "پیونگیانگ" },
            { "timezone.excity.Asia/Qyzylorda", "قؠزؠلوڑا" },
            { "timezone.excity.Asia/Samarkand", "سَمَرکَند" },
            { "timezone.excity.Asia/Singapore", "سِنگاپور" },
            { "timezone.excity.Asia/Vientiane", "وِیَنتِیین" },
            { "timezone.excity.Europe/Andorra", "اَنڈورا" },
            { "timezone.excity.Europe/Saratov", "ساراٹو" },
            { "timezone.excity.Europe/Tallinn", "ٹؠلِن" },
            { "timezone.excity.Europe/Vatican", "ویٹیکن" },
            { "timezone.excity.Europe/Vilnius", "وِلِنِیَس" },
            { "timezone.excity.Indian/Mayotte", "میوٹ" },
            { "timezone.excity.Indian/Reunion", "رِیوٗنیَن" },
            { "timezone.excity.Pacific/Easter", "ایٖسٹَر" },
            { "timezone.excity.Pacific/Kosrae", "کوسراے" },
            { "timezone.excity.Pacific/Majuro", "مَجوٗرو" },
            { "timezone.excity.Pacific/Midway", "مِڈویے" },
            { "timezone.excity.Pacific/Noumea", "نومیی" },
            { "timezone.excity.Pacific/Ponape", "پوناپے" },
            { "timezone.excity.Pacific/Saipan", "سَیپان" },
            { "timezone.excity.Pacific/Tahiti", "تَہِتی" },
            { "timezone.excity.Pacific/Tarawa", "ٹَراوا" },
            { "timezone.excity.Pacific/Wallis", "ویلِس" },
            { "timezone.excity.Africa/Blantyre", "بلانتَیر" },
            { "timezone.excity.Africa/Djibouti", "ڈِجیبوٹی" },
            { "timezone.excity.Africa/El_Aaiun", "ال عیون" },
            { "timezone.excity.Africa/Freetown", "فری ٹاوُن" },
            { "timezone.excity.Africa/Gaborone", "گؠبورون" },
            { "timezone.excity.Africa/Khartoum", "کھارتوم" },
            { "timezone.excity.Africa/Kinshasa", "کِنشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونرووِیا" },
            { "timezone.excity.Africa/Ndjamena", "جَمیٖنا" },
            { "timezone.excity.Africa/Sao_Tome", "ساو ٹوم" },
            { "timezone.excity.Africa/Windhoek", "وِنڈہوک" },
            { "timezone.excity.America/Antigua", "اؠنٹِگُوا" },
            { "timezone.excity.America/Caracas", "کیرَکَس" },
            { "timezone.excity.America/Cayenne", "کَیین" },
            { "timezone.excity.America/Chicago", "شِکاگو" },
            { "timezone.excity.America/Cordoba", "کورڑوبا" },
            { "timezone.excity.America/Creston", "کریسٹن" },
            { "timezone.excity.America/Curacao", "کیوٗراکااو" },
            { "timezone.excity.America/Detroit", "ڈیٹرایِٹ" },
            { "timezone.excity.America/Godthab", "نوٗک" },
            { "timezone.excity.America/Grenada", "گریناڈا" },
            { "timezone.excity.America/Halifax", "حیلِفؠکس" },
            { "timezone.excity.America/Iqaluit", "اِقالیوٗیِت" },
            { "timezone.excity.America/Jamaica", "جَمَیکا" },
            { "timezone.excity.America/Managua", "مَناگوا" },
            { "timezone.excity.America/Marigot", "میریگوٹ" },
            { "timezone.excity.America/Mendoza", "مؠنڑوزا" },
            { "timezone.excity.America/Moncton", "مونکٹٕن" },
            { "timezone.excity.America/Noronha", "نورونہا" },
            { "timezone.excity.America/Ojinaga", "اوجی ناگا" },
            { "timezone.excity.America/Phoenix", "پھِنِکس" },
            { "timezone.excity.America/Tijuana", "تِجُوانا" },
            { "timezone.excity.America/Toronto", "ٹورونٹو" },
            { "timezone.excity.America/Tortola", "ٹارٹولا" },
            { "timezone.excity.America/Yakutat", "یکوٗتات" },
            { "timezone.excity.Asia/Phnom_Penh", "نوم پؠنہہ" },
            { "timezone.excity.Atlantic/Azores", "اَزورَس" },
            { "timezone.excity.Atlantic/Canary", "کؠنَری" },
            { "timezone.excity.Atlantic/Faeroe", "فؠرو" },
            { "timezone.excity.Australia/Eucla", "یوٗکلا" },
            { "timezone.excity.Australia/Perth", "پٔرتھ" },
            { "timezone.excity.Europe/Belgrade", "بیلگریڈ" },
            { "timezone.excity.Europe/Brussels", "برسٕلس" },
            { "timezone.excity.Europe/Budapest", "بُڈاپیسٹ" },
            { "timezone.excity.Europe/Busingen", "بوسِنگین" },
            { "timezone.excity.Europe/Chisinau", "چِسیٖنو" },
            { "timezone.excity.Europe/Guernsey", "گویرنسے" },
            { "timezone.excity.Europe/Helsinki", "حؠلسِنکی" },
            { "timezone.excity.Europe/Istanbul", "اِستانبُل" },
            { "timezone.excity.Europe/Sarajevo", "سارا جیوو" },
            { "timezone.excity.Indian/Maldives", "مالدیٖوز" },
            { "timezone.excity.Pacific/Chatham", "چَتھَم" },
            { "timezone.excity.Pacific/Fakaofo", "فَکَوفو" },
            { "timezone.excity.Pacific/Gambier", "گیمبِیَر" },
            { "timezone.excity.Pacific/Norfolk", "نورفوک" },
            { "timezone.excity.Africa/Bujumbura", "بُجُمبُرا" },
            { "timezone.excity.Africa/Mogadishu", "موگادِشوٗ" },
            { "timezone.excity.America/Anguilla", "اؠنگِولا" },
            { "timezone.excity.America/Asuncion", "اَسُنچِیَن" },
            { "timezone.excity.America/Barbados", "بارباڈوس" },
            { "timezone.excity.America/Dominica", "ڈومِنِکا" },
            { "timezone.excity.America/Edmonton", "اؠڈمَنٹَن" },
            { "timezone.excity.America/Eirunepe", "ایٖروٗنیپ" },
            { "timezone.excity.America/Mazatlan", "مَزَٹلان" },
            { "timezone.excity.America/Miquelon", "مِکیٖلَن" },
            { "timezone.excity.America/New_York", "نِو یارک" },
            { "timezone.excity.America/Resolute", "رِسولیوٗٹ" },
            { "timezone.excity.America/Santarem", "سانتاریم" },
            { "timezone.excity.America/Santiago", "سینٹیاگو" },
            { "timezone.excity.America/St_Johns", "سؠنٹ جونس" },
            { "timezone.excity.America/St_Kitts", "سینٹ کِٹس" },
            { "timezone.excity.America/St_Lucia", "سؠنٹ لوٗسِیا" },
            { "timezone.excity.America/Winnipeg", "وِنِپؠگ" },
            { "timezone.excity.Antarctica/Casey", "کیسی" },
            { "timezone.excity.Antarctica/Davis", "ڈیوِس" },
            { "timezone.excity.Antarctica/Syowa", "سیووا" },
            { "timezone.excity.Asia/Krasnoyarsk", "کرنسنویارسک" },
            { "timezone.excity.Asia/Novosibirsk", "نوووسِبِرسک" },
            { "timezone.excity.Asia/Ulaanbaatar", "اولن باٹر" },
            { "timezone.excity.Asia/Vladivostok", "لادِووستوک" },
            { "timezone.excity.Atlantic/Bermuda", "برموٗڑا" },
            { "timezone.excity.Atlantic/Madeira", "مَڈیٖرا" },
            { "timezone.excity.Atlantic/Stanley", "سٹینلی" },
            { "timezone.excity.Australia/Darwin", "ڈاروِن" },
            { "timezone.excity.Australia/Hobart", "حۄبٲٹ" },
            { "timezone.excity.Australia/Sydney", "سِڑنی" },
            { "timezone.excity.Europe/Amsterdam", "ایمسٹَرڈیم" },
            { "timezone.excity.Europe/Astrakhan", "ایسٹرا کھان" },
            { "timezone.excity.Europe/Bucharest", "بَچاریسٹ" },
            { "timezone.excity.Europe/Gibraltar", "گِبرالٹَر" },
            { "timezone.excity.Europe/Ljubljana", "لِیوٗب لِیانا" },
            { "timezone.excity.Europe/Mariehamn", "میری ہیم" },
            { "timezone.excity.Europe/Podgorica", "پوڈگوریکا" },
            { "timezone.excity.Europe/Stockholm", "سٹاک ہولم" },
            { "timezone.excity.Europe/Ulyanovsk", "اولیانووسک" },
            { "timezone.excity.Europe/Volgograd", "وولگوگرَد" },
            { "timezone.excity.Indian/Christmas", "کرِسمَس" },
            { "timezone.excity.Indian/Kerguelen", "کیرگولِن" },
            { "timezone.excity.Indian/Mauritius", "مورِشیس" },
            { "timezone.excity.Pacific/Auckland", "آکلینڈ" },
            { "timezone.excity.Pacific/Funafuti", "فُنافوٗتی" },
            { "timezone.excity.Pacific/Honolulu", "ہونولو لو" },
            { "timezone.excity.Pacific/Pitcairn", "پِٹکیرَن" },
            { "timezone.excity.Africa/Casablanca", "کؠسابلؠنکا" },
            { "timezone.excity.Africa/Libreville", "لِبَروِل" },
            { "timezone.excity.Africa/Lubumbashi", "لوبم باشی" },
            { "timezone.excity.Africa/Nouakchott", "نوواکچھوت" },
            { "timezone.excity.Africa/Porto-Novo", "پورٹو نووو" },
            { "timezone.excity.America/Anchorage", "اَنکوراج" },
            { "timezone.excity.America/Araguaina", "اؠریگُوینا" },
            { "timezone.excity.America/Boa_Vista", "بوآ وِسٹا" },
            { "timezone.excity.America/Catamarca", "کیٹامارکا" },
            { "timezone.excity.America/Chihuahua", "چِہُوا ہُوا" },
            { "timezone.excity.America/Fortaleza", "فورٹیلیزا" },
            { "timezone.excity.America/Glace_Bay", "گلیس خلیٖج" },
            { "timezone.excity.America/Goose_Bay", "گوٗس خلیٖج" },
            { "timezone.excity.America/Guatemala", "گواٹیمالا" },
            { "timezone.excity.America/Guayaquil", "گوایاکِوَل" },
            { "timezone.excity.America/Matamoros", "میٹاموروس" },
            { "timezone.excity.America/Menominee", "مینومِنی" },
            { "timezone.excity.America/Monterrey", "موٹیری" },
            { "timezone.excity.America/Sao_Paulo", "ساؤ پالو" },
            { "timezone.excity.America/St_Thomas", "سینٹ تھامَس" },
            { "timezone.excity.America/Vancouver", "وؠنکووَر" },
            { "timezone.excity.Antarctica/Mawson", "ماسَن" },
            { "timezone.excity.Antarctica/Palmer", "پامَر" },
            { "timezone.excity.Antarctica/Vostok", "ووستوک" },
            { "timezone.excity.Asia/Kuala_Lumpur", "کولالَمپوٗر" },
            { "timezone.excity.Asia/Novokuznetsk", "نوووکُزنیٹسک" },
            { "timezone.excity.Europe/Bratislava", "بریٹیسلاوا" },
            { "timezone.excity.Europe/Copenhagen", "کوپن ہیگن" },
            { "timezone.excity.Europe/Luxembourg", "لَکزٕمبٔرگ" },
            { "timezone.excity.Europe/San_Marino", "سین مرینو" },
            { "timezone.excity.Europe/Simferopol", "سِمفیروپول" },
            { "timezone.excity.Pacific/Enderbury", "اؠنڑربیری" },
            { "timezone.excity.Pacific/Galapagos", "گؠلَپگوس" },
            { "timezone.excity.Pacific/Kwajalein", "کُوجلین" },
            { "timezone.excity.Pacific/Marquesas", "مارکیسَس" },
            { "timezone.excity.Pacific/Pago_Pago", "پیگو پیگو" },
            { "timezone.excity.Pacific/Rarotonga", "راروٹونگا" },
            { "timezone.excity.Pacific/Tongatapu", "تونگاتَپوٗ" },
            { "timezone.excity.Africa/Addis_Ababa", "عدیس ابابا" },
            { "timezone.excity.Africa/Brazzaville", "برازاوِل" },
            { "timezone.excity.Africa/Ouagadougou", "اوآگدوگو" },
            { "timezone.excity.America/Costa_Rica", "کوسٹا ریٖکا" },
            { "timezone.excity.America/Grand_Turk", "گرینڈ تٔرک" },
            { "timezone.excity.America/Guadeloupe", "گوڑلوپ" },
            { "timezone.excity.America/Hermosillo", "ۂرموسِلو" },
            { "timezone.excity.America/Kralendijk", "کرالینڈِک" },
            { "timezone.excity.America/Louisville", "لوٗیِس وِل" },
            { "timezone.excity.America/Martinique", "مارٹِنِک" },
            { "timezone.excity.America/Metlakatla", "میٹلا کاٹلا" },
            { "timezone.excity.America/Montevideo", "مونٹیوِڈیو" },
            { "timezone.excity.America/Montserrat", "مونژیرات" },
            { "timezone.excity.America/Paramaribo", "پَرامارِبو" },
            { "timezone.excity.America/Rio_Branco", "رِیو برانکو" },
            { "timezone.excity.America/St_Vincent", "سینٹ وِنسینٹ" },
            { "timezone.excity.America/Whitehorse", "وایِٹ ہارٕس" },
            { "timezone.excity.Antarctica/McMurdo", "مؠک مٲڑو" },
            { "timezone.excity.Antarctica/Rothera", "روتھیرا" },
            { "timezone.excity.Asia/Srednekolymsk", "سریڈنیکولیمسک" },
            { "timezone.excity.Asia/Yekaterinburg", "یَکاتِرِنبٔرگ" },
            { "timezone.excity.Atlantic/Reykjavik", "رؠکیاوِک" },
            { "timezone.excity.Atlantic/St_Helena", "سینٹ ہیلِنا" },
            { "timezone.excity.Australia/Adelaide", "اؠڑِلیڑ" },
            { "timezone.excity.Australia/Brisbane", "برسبین" },
            { "timezone.excity.Australia/Lindeman", "لِنڑیمان" },
            { "timezone.excity.Europe/Isle_of_Man", "آئل آف مین" },
            { "timezone.excity.Europe/Kaliningrad", "کَلِناِنگرَد" },
            { "timezone.excity.Pacific/Kiritimati", "کِرِتِماتی" },
            { "timezone.excity.Africa/Johannesburg", "جوہانسبرگ" },
            { "timezone.excity.America/El_Salvador", "ایل سَلویدَر" },
            { "timezone.excity.America/Fort_Nelson", "فورٹ نیلسن" },
            { "timezone.excity.America/Los_Angeles", "لاس اینجٕلز" },
            { "timezone.excity.America/Mexico_City", "میکسِکو سِٹی" },
            { "timezone.excity.America/Porto_Velho", "پوٹو وؠلہو" },
            { "timezone.excity.America/Puerto_Rico", "پیٖٹو رِکو" },
            { "timezone.excity.America/Tegucigalpa", "ٹیگوسی گالپا" },
            { "timezone.excity.Arctic/Longyearbyen", "لونگ ییئر بئین" },
            { "timezone.excity.Atlantic/Cape_Verde", "کیپ ؤرڑے" },
            { "timezone.excity.Australia/Lord_Howe", "لعاڑ ہووے" },
            { "timezone.excity.Australia/Melbourne", "مؠلبعارن" },
            { "timezone.excity.Indian/Antananarivo", "اؠنٹنانرِوو" },
            { "timezone.excity.Pacific/Guadalcanal", "گُوادَلچَنَل" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دارالسلام" },
            { "timezone.excity.America/Blanc-Sablon", "بلانک سؠبلَن" },
            { "timezone.excity.America/Buenos_Aires", "بیوٗنَس آیرَس" },
            { "timezone.excity.America/Campo_Grande", "کؠمپو گرینڑ" },
            { "timezone.excity.America/Danmarkshavn", "ڈنمارک شاون" },
            { "timezone.excity.America/Dawson_Creek", "ڈواسَن کریٖک" },
            { "timezone.excity.America/Indiana/Knox", "نوکس" },
            { "timezone.excity.America/Indianapolis", "اِنڈیَن پولِس" },
            { "timezone.excity.America/Punta_Arenas", "پونٹا اریناس" },
            { "timezone.excity.America/Rankin_Inlet", "رینکِن اِنلؠٹ" },
            { "timezone.excity.America/Scoresbysund", "سکورٕسباےسَنڑ" },
            { "timezone.excity.Pacific/Port_Moresby", "پوٹ مورسبی" },
            { "timezone.excity.America/Cambridge_Bay", "کیمبرِج خلیٖج" },
            { "timezone.excity.America/Coral_Harbour", "اٹی کوکنٍ" },
            { "timezone.excity.America/Indiana/Vevay", "ویویے، انڈیانا" },
            { "timezone.excity.America/Lower_Princes", "لوور پرنس کوارٹر" },
            { "timezone.excity.America/Port_of_Spain", "پوٹ آف سپین" },
            { "timezone.excity.America/Santo_Domingo", "سؠنٹو ڑومِنگو" },
            { "timezone.excity.America/St_Barthelemy", "سینٹ بارتھیلمی" },
            { "timezone.excity.America/Swift_Current", "سٕوِفٹ کَرَنٹ" },
            { "timezone.excity.Australia/Broken_Hill", "بروکٕن ہِل" },
            { "timezone.excity.America/Bahia_Banderas", "باہیا بندارس" },
            { "timezone.excity.America/Port-au-Prince", "پوٹ آؤں پرِنس" },
            { "timezone.excity.Atlantic/South_Georgia", "جنوبی جارجیا" },
            { "timezone.excity.America/Argentina/Salta", "سالٹا" },
            { "timezone.excity.America/Indiana/Marengo", "میرنگو، انڈیانا" },
            { "timezone.excity.America/Indiana/Winamac", "وِنیمیک، انڈیانا" },
            { "timezone.excity.America/Argentina/Tucuman", "ٹوکوٗمَن" },
            { "timezone.excity.America/Argentina/Ushuaia", "اُشُوٗاییا" },
            { "timezone.excity.America/Indiana/Tell_City", "ٹیل سِٹی، انڈیانا" },
            { "timezone.excity.America/Indiana/Vincennes", "وِنسینیس، انڈیانا" },
            { "timezone.excity.Antarctica/DumontDUrville", "ڈُمونٹ ڈ اَروِل" },
            { "timezone.excity.America/Argentina/La_Rioja", "لا رِیوجا" },
            { "timezone.excity.America/Argentina/San_Juan", "سین جُواں" },
            { "timezone.excity.America/Argentina/San_Luis", "سین لوٗیِس" },
            { "timezone.excity.America/Indiana/Petersburg", "پِٹس بٔرگ، انڈیانا" },
            { "timezone.excity.America/Kentucky/Monticello", "مونٹِسیلو، کینٹوکی" },
            { "timezone.excity.America/North_Dakota/Beulah", "بیولاہ، شُمالی ڈیکوٹا" },
            { "timezone.excity.America/North_Dakota/Center", "مَرکزی جنوٗبی ڈکوٹا" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "رِیو گالیگوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نوو سیلٕم، شُمالی ڈیکوٹا" },
        };
        return data;
    }
}
