/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bax = "bamum";
        final String metaValue_doi = "dogri";
        final String metaValue_kpe = "kpelle";
        final String metaValue_mak = "makassar";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n’ko";
        final Object[][] data = new Object[][] {
            { "001", "maailma" },
            { "002", "Afrikka" },
            { "003", "Pohjois-Amerikka" },
            { "005", "Etelä-Amerikka" },
            { "009", "Oseania" },
            { "011", "Länsi-Afrikka" },
            { "013", "Väli-Amerikka" },
            { "014", "Itä-Afrikka" },
            { "015", "Pohjois-Afrikka" },
            { "017", "Keski-Afrikka" },
            { "018", "eteläinen Afrikka" },
            { "019", "Amerikka" },
            { "021", "pohjoinen Amerikka" },
            { "029", "Karibia" },
            { "030", "Itä-Aasia" },
            { "034", "Etelä-Aasia" },
            { "035", "Kaakkois-Aasia" },
            { "039", "Etelä-Eurooppa" },
            { "053", "Australaasia" },
            { "054", "Melanesia" },
            { "057", "Mikronesian alue" },
            { "061", "Polynesia" },
            { "142", "Aasia" },
            { "143", "Keski-Aasia" },
            { "145", "Länsi-Aasia" },
            { "150", "Eurooppa" },
            { "151", "Itä-Eurooppa" },
            { "154", "Pohjois-Eurooppa" },
            { "155", "Länsi-Eurooppa" },
            { "202", "Saharan eteläpuolinen Afrikka" },
            { "419", "Latinalainen Amerikka" },
            { "AC", "Ascension-saari" },
            { "AD", "Andorra" },
            { "AE", "Arabiemiirikunnat" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiina" },
            { "AS", "Amerikan Samoa" },
            { "AT", "Itävalta" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Ahvenanmaa" },
            { "AZ", "Azerbaidžan" },
            { "BA", "Bosnia ja Hertsegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibian Alankomaat" },
            { "BR", "Brasilia" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet’nsaari" },
            { "BW", "Botswana" },
            { "BY", "Valko-Venäjä" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kookossaaret (Keelingsaaret)" },
            { "CD", "Kongon demokraattinen tasavalta" },
            { "CF", "Keski-Afrikan tasavalta" },
            { "CG", "Kongon tasavalta" },
            { "CH", "Sveitsi" },
            { "CI", "Norsunluurannikko" },
            { "CK", "Cookinsaaret" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "Kiina" },
            { "CO", "Kolumbia" },
            { "CP", "Clippertoninsaari" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Joulusaari" },
            { "CY", "Kypros" },
            { "CZ", "Tšekki" },
            { "DE", "Saksa" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Tanska" },
            { "DM", "Dominica" },
            { "DO", "Dominikaaninen tasavalta" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta ja Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Viro" },
            { "EG", "Egypti" },
            { "EH", "Länsi-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Espanja" },
            { "ET", "Etiopia" },
            { "EU", "Euroopan unioni" },
            { "EZ", "euroalue" },
            { "FI", "Suomi" },
            { "FJ", "Fidži" },
            { "FK", "Falklandinsaaret" },
            { "FM", "Mikronesia" },
            { "FO", "Färsaaret" },
            { "FR", "Ranska" },
            { "GA", "Gabon" },
            { "GB", "Iso-Britannia" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Ranskan Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönlanti" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Päiväntasaajan Guinea" },
            { "GR", "Kreikka" },
            { "GS", "Etelä-Georgia ja Eteläiset Sandwichinsaaret" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong – Kiinan erityishallintoalue" },
            { "HM", "Heard ja McDonaldinsaaret" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Unkari" },
            { "IC", "Kanariansaaret" },
            { "ID", "Indonesia" },
            { "IE", "Irlanti" },
            { "IL", "Israel" },
            { "IM", "Mansaari" },
            { "IN", "Intia" },
            { "IO", "Brittiläinen Intian valtameren alue" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Islanti" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "JP", "Japani" },
            { "KE", "Kenia" },
            { "KG", "Kirgisia" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komorit" },
            { "KN", "Saint Kitts ja Nevis" },
            { "KP", "Pohjois-Korea" },
            { "KR", "Etelä-Korea" },
            { "KW", "Kuwait" },
            { "KY", "Caymansaaret" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Liettua" },
            { "LU", "Luxemburg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinsaaret" },
            { "MK", "Pohjois-Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao – Kiinan erityishallintoalue" },
            { "MP", "Pohjois-Mariaanit" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediivit" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Uusi-Kaledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsaari" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Alankomaat" },
            { "NO", "Norja" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Uusi-Seelanti" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Ranskan Polynesia" },
            { "PG", "Papua-Uusi-Guinea" },
            { "PH", "Filippiinit" },
            { "PK", "Pakistan" },
            { "PL", "Puola" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiinalaisalue" },
            { "PT", "Portugali" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oseanian erillissaaret" },
            { "RE", "Réunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Venäjä" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabia" },
            { "SB", "Salomonsaaret" },
            { "SC", "Seychellit" },
            { "SD", "Sudan" },
            { "SE", "Ruotsi" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Huippuvuoret ja Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Etelä-Sudan" },
            { "ST", "São Tomé ja Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syyria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- ja Caicossaaret" },
            { "TD", "Tšad" },
            { "TF", "Ranskan eteläiset ja antarktiset alueet" },
            { "TG", "Togo" },
            { "TH", "Thaimaa" },
            { "TJ", "Tadžikistan" },
            { "TK", "Tokelau" },
            { "TL", "Itä-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkki" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Yhdysvaltain erillissaaret" },
            { "UN", "Yhdistyneet kansakunnat" },
            { "US", "Yhdysvallat" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikaani" },
            { "VC", "Saint Vincent ja Grenadiinit" },
            { "VE", "Venezuela" },
            { "VG", "Brittiläiset Neitsytsaaret" },
            { "VI", "Yhdysvaltain Neitsytsaaret" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ja Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudoaksentit" },
            { "XB", "kaksisuuntainen pseudo" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Etelä-Afrikka" },
            { "ZM", "Sambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tuntematon alue" },
            { "aa", "afar" },
            { "ab", "abhaasi" },
            { "ae", "avesta" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhara" },
            { "an", "aragonia" },
            { "ar", "arabia" },
            { "as", "assami" },
            { "av", "avaari" },
            { "ay", "aimara" },
            { "az", "azeri" },
            { "ba", "baškiiri" },
            { "be", "valkovenäjä" },
            { "bg", "bulgaria" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tiibet" },
            { "br", "bretoni" },
            { "bs", "bosnia" },
            { "ca", "katalaani" },
            { "ce", "tšetšeeni" },
            { "ch", "tšamorro" },
            { "co", "korsika" },
            { "cr", "cree" },
            { "cs", "tšekki" },
            { "cu", "kirkkoslaavi" },
            { "cv", "tšuvassi" },
            { "cy", "kymri" },
            { "da", "tanska" },
            { "de", "saksa" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "kreikka" },
            { "en", "englanti" },
            { "eo", "esperanto" },
            { "es", "espanja" },
            { "et", "viro" },
            { "eu", "baski" },
            { "fa", "persia" },
            { "ff", "fulani" },
            { "fi", "suomi" },
            { "fj", "fidži" },
            { "fo", "fääri" },
            { "fr", "ranska" },
            { "fy", "länsifriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "gl", "galicia" },
            { "gn", "guarani" },
            { "gu", "gudžarati" },
            { "gv", "manksi" },
            { "ha", "hausa" },
            { "he", "heprea" },
            { "hi", "hindi" },
            { "ho", "hiri-motu" },
            { "hr", "kroatia" },
            { "ht", "haiti" },
            { "hu", "unkari" },
            { "hy", "armenia" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesia" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuanin-yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islanti" },
            { "it", "italia" },
            { "iu", "inuktitut" },
            { "ja", "japani" },
            { "jv", "jaava" },
            { "ka", "georgia" },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kuanjama" },
            { "kk", "kazakki" },
            { "kl", "kalaallisut" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "korea" },
            { "kr", "kanuri" },
            { "ks", "kašmiri" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "la", "latina" },
            { "lb", "luxemburg" },
            { "lg", "ganda" },
            { "li", "limburg" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "liettua" },
            { "lu", "katanganluba" },
            { "lv", "latvia" },
            { "mg", "malagassi" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedonia" },
            { "ml", "malajalam" },
            { "mn", "mongoli" },
            { "mr", "marathi" },
            { "ms", "malaiji" },
            { "mt", "malta" },
            { "my", "burma" },
            { "na", "nauru" },
            { "nb", "norjan bokmål" },
            { "nd", "pohjois-ndebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "nl", "hollanti" },
            { "nn", "norjan nynorsk" },
            { "no", "norja" },
            { "nr", "etelä-ndebele" },
            { "nv", "navajo" },
            { "ny", "njandža" },
            { "oc", "oksitaani" },
            { "oj", "odžibwa" },
            { "om", "oromo" },
            { "or", "orija" },
            { "os", "osseetti" },
            { "pa", "pandžabi" },
            { "pi", "paali" },
            { "pl", "puola" },
            { "ps", "paštu" },
            { "pt", "portugali" },
            { "qu", "ketšua" },
            { "rm", "retoromaani" },
            { "rn", "rundi" },
            { "ro", "romania" },
            { "ru", "venäjä" },
            { "rw", "ruanda" },
            { "sa", "sanskrit" },
            { "sc", "sardi" },
            { "sd", "sindhi" },
            { "se", "pohjoissaame" },
            { "sg", "sango" },
            { "sh", "serbokroaatti" },
            { "si", "sinhala" },
            { "sk", "slovakki" },
            { "sl", "sloveeni" },
            { "sm", "samoa" },
            { "sn", "šona" },
            { "so", "somali" },
            { "sq", "albania" },
            { "sr", "serbia" },
            { "ss", "swazi" },
            { "st", "eteläsotho" },
            { "su", "sunda" },
            { "sv", "ruotsi" },
            { "sw", "swahili" },
            { "ta", "tamili" },
            { "te", "telugu" },
            { "tg", "tadžikki" },
            { "th", "thai" },
            { "ti", "tigrinja" },
            { "tk", "turkmeeni" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "turkki" },
            { "ts", "tsonga" },
            { "tt", "tataari" },
            { "tw", "twi" },
            { "ty", "tahiti" },
            { "ug", "uiguuri" },
            { "uk", "ukraina" },
            { "ur", "urdu" },
            { "uz", "uzbekki" },
            { "ve", "venda" },
            { "vi", "vietnam" },
            { "vo", "volapük" },
            { "wa", "valloni" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddiš" },
            { "yo", "joruba" },
            { "za", "zhuang" },
            { "zh", "kiina" },
            { "zu", "zulu" },
            { "ace", "atšeh" },
            { "ach", "atšoli" },
            { "ada", "adangme" },
            { "ady", "adyge" },
            { "aeb", "tunisianarabia" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "akkadi" },
            { "akz", "alabama" },
            { "ale", "aleutti" },
            { "aln", "gegi" },
            { "alt", "altai" },
            { "ang", "muinaisenglanti" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "urduni" },
            { "arc", "valtakunnanaramea" },
            { "arn", "mapudungun" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "algerianarabia" },
            { "ars", "arabia – najd" },
            { "arw", "arawak" },
            { "ary", "marokonarabia" },
            { "arz", "egyptinarabia" },
            { "asa", "asu" },
            { "ase", "amerikkalainen viittomakieli" },
            { "ast", "asturia" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "belutši" },
            { "ban", "bali" },
            { "bar", "baijeri" },
            { "bas", "basaa" },
            { "bax", metaValue_bax },
            { "bbc", "batak-toba" },
            { "bbj", "ghomala" },
            { "bej", "bedža" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "fut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "länsibelutši" },
            { "bho", "bhodžpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "blt", "tai dam" },
            { "bpy", "bišnupria" },
            { "bqi", "bahtiari" },
            { "bra", "bradž" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "koose" },
            { "bua", "burjaatti" },
            { "bug", "bugi" },
            { "bum", "bulu" },
            { "byn", "bilin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karibi" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chb", "tšibtša" },
            { "chg", "tšagatai" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "chinook-jargon" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "cic", "chickasaw" },
            { "ckb", "soranî" },
            { "clc", "chilcotin" },
            { "cop", "kopti" },
            { "cps", "capiznon" },
            { "crg", "michif" },
            { "crh", "krimintataari" },
            { "crj", "east cree (eteläinen)" },
            { "crk", "plains cree" },
            { "crl", "east cree (pohjoinen)" },
            { "crm", "moose cree" },
            { "crr", "pamlico" },
            { "crs", "seychellienkreoli" },
            { "csb", "kašubi" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "dargi" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slevi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "djerma" },
            { "doi", metaValue_doi },
            { "dsb", "alasorbi" },
            { "dtp", "dusun" },
            { "dua", "duala" },
            { "dum", "keskihollanti" },
            { "dyo", "jola-fonyi" },
            { "dyu", "djula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emilia" },
            { "egy", "muinaisegypti" },
            { "eka", "ekajuk" },
            { "elx", "elami" },
            { "enm", "keskienglanti" },
            { "esu", "alaskanjupik" },
            { "ewo", "ewondo" },
            { "ext", "extremadura" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fit", "meänkieli" },
            { "fon", "fon" },
            { "frc", "cajunranska" },
            { "frm", "keskiranska" },
            { "fro", "muinaisranska" },
            { "frp", "arpitaani" },
            { "frr", "pohjoisfriisi" },
            { "frs", "itäfriisi" },
            { "fur", "friuli" },
            { "gaa", "ga" },
            { "gag", "gagauzi" },
            { "gan", "gan-kiina" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gbz", "zoroastrialaisdari" },
            { "gez", "ge’ez" },
            { "gil", "kiribati" },
            { "glk", "gilaki" },
            { "gmh", "keskiyläsaksa" },
            { "goh", "muinaisyläsaksa" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gootti" },
            { "grb", "grebo" },
            { "grc", "muinaiskreikka" },
            { "gsw", "sveitsinsaksa" },
            { "guc", "wayuu" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwitšin" },
            { "hai", "haida" },
            { "hak", "hakka-kiina" },
            { "haw", "havaiji" },
            { "hax", "haida (eteläinen)" },
            { "hif", "fidžinhindi" },
            { "hil", "hiligaino" },
            { "hit", "heetti" },
            { "hmn", "hmong" },
            { "hnj", "hmong njua" },
            { "hsb", "yläsorbi" },
            { "hsn", "xiang-kiina" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "Länsi-Kanadan inuktitut" },
            { "ilo", "iloko" },
            { "inh", "inguuši" },
            { "izh", "inkeroinen" },
            { "jam", "jamaikankreolienglanti" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "juutalaispersia" },
            { "jrb", "juutalaisarabia" },
            { "jut", "juutti" },
            { "kaa", "karakalpakki" },
            { "kab", "kabyyli" },
            { "kac", "katšin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kavi" },
            { "kbd", "kabardi" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdenkreoli" },
            { "ken", "kenyang" },
            { "kfo", "norsunluurannikonkoro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotani" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komipermjakki" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", metaValue_kpe },
            { "krc", "karatšai-balkaari" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karjala" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kumykki" },
            { "kut", "kutenai" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "lango" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgi" },
            { "lfn", "lingua franca nova" },
            { "lij", "liguuri" },
            { "lil", "lillooet" },
            { "liv", "liivi" },
            { "lkt", "lakota" },
            { "lld", "ladin" },
            { "lmo", "lombardi" },
            { "lol", "mongo" },
            { "lou", "louisianankreoli" },
            { "loz", "lozi" },
            { "lrc", "pohjoisluri" },
            { "lsm", "samia" },
            { "ltg", "latgalli" },
            { "lua", "luluanluba" },
            { "lui", "luiseño" },
            { "lun", "lunda" },
            { "lus", "lusai" },
            { "luy", "luhya" },
            { "lzh", "klassinen kiina" },
            { "lzz", "lazi" },
            { "mad", "madura" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "man", "mandingo" },
            { "mas", "maasai" },
            { "mde", "maba" },
            { "mdf", "mokša" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "keski-iiri" },
            { "mgh", "makua-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mantšu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "vuorimari" },
            { "mua", "mundang" },
            { "mul", "useita kieliä" },
            { "mus", "creek" },
            { "mwl", "mirandeesi" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "ersä" },
            { "mzn", "mazandarani" },
            { "nan", "min nan -kiina" },
            { "nap", "napoli" },
            { "naq", "nama" },
            { "nds", "alasaksa" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "ao naga" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "muinaisnorja" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "pohjoissotho" },
            { "nus", "nuer" },
            { "nwc", "klassinen newari" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "luoteis-odžibwa" },
            { "ojc", "keskiojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "länsi-odžibwa" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "osmani" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamentu" },
            { "pau", "palau" },
            { "pcd", "picardi" },
            { "pcm", "nigerianpidgin" },
            { "pdc", "pennsylvaniansaksa" },
            { "pdt", "plautdietsch" },
            { "peo", "muinaispersia" },
            { "pfl", "pfaltsi" },
            { "phn", "foinikia" },
            { "pis", "pijin" },
            { "pms", "piemonte" },
            { "pnt", "pontoksenkreikka" },
            { "pon", "pohnpei" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "muinaispreussi" },
            { "pro", "muinaisprovensaali" },
            { "quc", "kʼicheʼ" },
            { "qug", "chimborazonylänköketšua" },
            { "raj", "radžastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnoli" },
            { "rhg", "rohinga" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotuma" },
            { "rue", "ruteeni" },
            { "rug", "roviana" },
            { "rup", "aromania" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakuutti" },
            { "sam", "samarianaramea" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", "sauraštri" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sisilia" },
            { "sco", "skotti" },
            { "sdc", "sassarinsardi" },
            { "sdh", "eteläkurdi" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkuppi" },
            { "ses", "koyraboro senni" },
            { "sga", "muinaisiiri" },
            { "sgs", "samogiitti" },
            { "shi", "tašelhit" },
            { "shn", "shan" },
            { "shu", "tšadinarabia" },
            { "sid", "sidamo" },
            { "skr", "saraiki" },
            { "slh", "lushootseed (eteläinen)" },
            { "sli", "sleesiansaksa" },
            { "sly", "selayar" },
            { "sma", "eteläsaame" },
            { "smj", "luulajansaame" },
            { "smn", "inarinsaame" },
            { "sms", "koltansaame" },
            { "snk", "soninke" },
            { "sog", "sogdi" },
            { "srn", "sranan" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "stq", "saterlandinfriisi" },
            { "str", "straits-salish" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeri" },
            { "swb", "komori" },
            { "syc", "muinaissyyria" },
            { "syr", "syyria" },
            { "szl", "sleesia" },
            { "tce", "etelätutchone" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahlta" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsahuri" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "tališi" },
            { "tmh", "tamašek" },
            { "tog", "malawintonga" },
            { "tok", "toki pona" },
            { "tpi", "tok-pisin" },
            { "tru", "turojo" },
            { "trv", "taroko" },
            { "trw", "torwali" },
            { "tsd", "tsakonia" },
            { "tsi", "tsimši" },
            { "ttm", "pohjoinen tutchone" },
            { "ttt", "tati" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuva" },
            { "tzm", "keskiatlaksentamazight" },
            { "udm", "udmurtti" },
            { "uga", "ugarit" },
            { "umb", "mbundu" },
            { "und", "tuntematon kieli" },
            { "vec", "venetsia" },
            { "vep", "vepsä" },
            { "vls", "länsiflaami" },
            { "vmf", "maininfrankki" },
            { "vmw", "makhuwa" },
            { "vot", "vatja" },
            { "vro", "võro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaitta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu-kiina" },
            { "xal", "kalmukki" },
            { "xmf", "mingreli" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "jao" },
            { "yap", "japi" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "ñeengatú" },
            { "yue", "kantoninkiina" },
            { "zap", "zapoteekki" },
            { "zbl", "blisskieli" },
            { "zea", "seelanti" },
            { "zen", "zenaga" },
            { "zgh", "vakioitu tamazight" },
            { "zun", "zuni" },
            { "zxx", "ei kielellistä sisältöä" },
            { "zza", "zaza" },
            { "Adlm", "fulanin adlam-aakkosto" },
            { "Afak", "afaka" },
            { "Aghb", "kaukasianalbanialainen" },
            { "Ahom", "ahom" },
            { "Arab", "arabialainen" },
            { "Aran", "nastaliq" },
            { "Armi", "valtakunnanaramealainen" },
            { "Armn", "armenialainen" },
            { "Avst", "avestalainen" },
            { "Bali", "balilainen" },
            { "Bamu", metaValue_bax },
            { "Bass", "bassa" },
            { "Batk", "batakilainen" },
            { "Beng", "bengalilainen" },
            { "Bhks", "sanskritin bhaiksuki-aakkosto" },
            { "Blis", "bliss-symbolit" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille-pistekirjoitus" },
            { "Bugi", "bugilainen" },
            { "Buhd", "buhidilainen" },
            { "Cakm", "chakmalainen" },
            { "Cans", "kanadalaisten alkuperäiskansojen yhtenäistetty tavukirjoitus" },
            { "Cari", "kaarialainen" },
            { "Cham", "tšamilainen" },
            { "Cher", "cherokeelainen" },
            { "Chrs", "horemzi" },
            { "Cirt", "cirth" },
            { "Copt", "koptilainen" },
            { "Cpmn", "kypro-minolainen" },
            { "Cprt", "muinaiskyproslainen" },
            { "Cyrl", "kyrillinen" },
            { "Cyrs", "kyrillinen muinaiskirkkoslaavimuunnelma" },
            { "Deva", "devanagari" },
            { "Diak", "dives akuru" },
            { "Dogr", metaValue_doi },
            { "Dsrt", "deseret" },
            { "Dupl", "Duployén pikakirjoitus" },
            { "Egyd", "egyptiläinen demoottinen" },
            { "Egyh", "egyptiläinen hieraattinen" },
            { "Egyp", "egyptiläiset hieroglyfit" },
            { "Elba", "elbasanilainen" },
            { "Elym", "elymealainen" },
            { "Ethi", "etiopialainen" },
            { "Geok", "muinaisgeorgialainen" },
            { "Geor", "georgialainen" },
            { "Glag", "glagoliittinen" },
            { "Gong", "gondin gunjala" },
            { "Gonm", "masaram-gondi" },
            { "Goth", "goottilainen" },
            { "Gran", "grantha" },
            { "Grek", "kreikkalainen" },
            { "Gujr", "gudžaratilainen" },
            { "Guru", "gurmukhi" },
            { "Hanb", "kiinan han ja bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "kiinalainen han" },
            { "Hano", "hanunoolainen" },
            { "Hans", "yksinkertaistettu" },
            { "Hant", "perinteinen" },
            { "Hatr", "hatralainen" },
            { "Hebr", "heprealainen" },
            { "Hira", "hiragana" },
            { "Hluw", "anatolialaiset hieroglyfit" },
            { "Hmng", "pahawh hmong" },
            { "Hmnp", "hmongin nyiakeng puachue" },
            { "Hrkt", "japanin tavumerkistöt" },
            { "Hung", "muinaisunkarilainen" },
            { "Inds", "induslainen" },
            { "Ital", "muinaisitalialainen" },
            { "Jamo", "korean hangulin jamo-elementit" },
            { "Java", "jaavalainen" },
            { "Jpan", "japanilainen" },
            { "Jurc", "džurtšen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Kawi", "kawi" },
            { "Khar", "kharosthi" },
            { "Khmr", "khmeriläinen" },
            { "Khoj", "khojki" },
            { "Kits", "kitaanin pieni merkistö" },
            { "Knda", "kannadalainen" },
            { "Kore", "korealainen" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "laolainen" },
            { "Latf", "latinalainen fraktuuramuunnelma" },
            { "Latg", "latinalainen gaelimuunnelma" },
            { "Latn", "latinalainen" },
            { "Lepc", "lepchalainen" },
            { "Limb", "limbulainen" },
            { "Lina", "lineaari-A" },
            { "Linb", "lineaari-B" },
            { "Lisu", "Fraserin aakkoset" },
            { "Loma", "loma" },
            { "Lyci", "lyykialainen" },
            { "Lydi", "lyydialainen" },
            { "Mahj", "mahajanilainen" },
            { "Maka", metaValue_mak },
            { "Mand", "mandealainen" },
            { "Mani", "manikealainen" },
            { "Marc", "tiibetiläinen marchan-kirjoitus" },
            { "Maya", "maya-hieroglyfit" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "meroiittinen kursiivikirjoitus" },
            { "Mero", "meroiittinen" },
            { "Mlym", "malajalamilainen" },
            { "Modi", "modi-aakkoset" },
            { "Mong", "mongolilainen" },
            { "Moon", "moon-kohokirjoitus" },
            { "Mroo", "mro" },
            { "Mtei", "meitei" },
            { "Mult", "multanilainen" },
            { "Mymr", "burmalainen" },
            { "Nagm", "Nagin mundariaakkoset" },
            { "Nand", "nandinagari" },
            { "Narb", "muinaispohjoisarabialainen" },
            { "Nbat", "nabatealainen" },
            { "Newa", "newarin newa-tavukirjoitus" },
            { "Nkgb", "naxi geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nüshu" },
            { "Ogam", "ogam" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", "orijalainen" },
            { "Osge", "osagen aakkosto" },
            { "Osma", "osmanjalainen" },
            { "Ougr", "vanha uiguurilainen" },
            { "Palm", "palmyralainen" },
            { "Pauc", "zotuallai" },
            { "Perm", "muinaispermiläinen" },
            { "Phag", "phags-pa" },
            { "Phli", "piirtokirjoituspahlavilainen" },
            { "Phlp", "psalttaripahlavilainen" },
            { "Phlv", "kirjapahlavilainen" },
            { "Phnx", "foinikialainen" },
            { "Plrd", "Pollardin foneettinen" },
            { "Prti", "piirtokirjoitusparthialainen" },
            { "Qaag", "burmalainen zawgyi-toteutus" },
            { "Rjng", "rejang" },
            { "Rohg", "rohingalainen hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "riimukirjoitus" },
            { "Samr", "samarianaramealainen" },
            { "Sara", "sarati" },
            { "Sarb", "muinaiseteläarabialainen" },
            { "Saur", "saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "shaw’lainen" },
            { "Shrd", "šarada" },
            { "Sidd", "siddham-tavukirjoitus" },
            { "Sind", "khudabadi" },
            { "Sinh", "sinhalilainen" },
            { "Sogd", "sogdialainen" },
            { "Sogo", "muinaissogdialainen" },
            { "Sora", "sorang sompeng" },
            { "Soyo", "soyombo-kirjaimisto" },
            { "Sund", "sundalainen" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "syyrialainen" },
            { "Syre", "syyrialainen estrangelo-muunnelma" },
            { "Syrj", "syyrialainen läntinen muunnelma" },
            { "Syrn", "syyrialainen itäinen muunnelma" },
            { "Tagb", "tagbanwalainen" },
            { "Takr", "takri" },
            { "Tale", "tailelainen" },
            { "Talu", "uusi tailuelainen" },
            { "Taml", "tamililainen" },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", "telugulainen" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalogilainen" },
            { "Thaa", "thaana" },
            { "Thai", "thailainen" },
            { "Tibt", "tiibetiläinen" },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsa" },
            { "Toto", "toto" },
            { "Ugar", "ugaritilainen" },
            { "Vaii", "vailainen" },
            { "Visp", "näkyvä puhe" },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wancholainen" },
            { "Wole", "woleai" },
            { "Xpeo", "muinaispersialainen" },
            { "Xsux", "sumerilais-akkadilainen nuolenpääkirjoitus" },
            { "Yezi", "jesidi" },
            { "Yiii", "yiläinen" },
            { "Zanb", "zanabazar-neliökirjaimisto" },
            { "Zinh", "peritty" },
            { "Zmth", "matemaattinen" },
            { "Zsye", "emoji-symbolit" },
            { "Zsym", "symbolit" },
            { "Zxxx", "kirjoittamaton" },
            { "Zyyy", "määrittämätön" },
            { "Zzzz", "tuntematon kirjoitusjärjestelmä" },
            { "de_AT", "itävallansaksa" },
            { "de_CH", "sveitsinyläsaksa" },
            { "en_AU", "australianenglanti" },
            { "en_CA", "kanadanenglanti" },
            { "en_GB", "britannianenglanti" },
            { "en_US", "amerikanenglanti" },
            { "es_ES", "euroopanespanja" },
            { "es_MX", "meksikonespanja" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadanranska" },
            { "fr_CH", "sveitsinranska" },
            { "nl_BE", "flaami" },
            { "pt_BR", "brasilianportugali" },
            { "pt_PT", "euroopanportugali" },
            { "ro_MD", "moldova" },
            { "sw_CD", "kongonswahili" },
            { "%%1901", "saksan perinteinen oikeinkirjoitus" },
            { "%%1994", "sloveenin resian murteen yhdenmukaistettu oikeinkirjoitus" },
            { "%%1996", "saksan uusi oikeinkirjoitus" },
            { "ar_001", "yleisarabia" },
            { "es_419", "amerikanespanja" },
            { "key.ca", "kalenteri" },
            { "key.cf", "valuuttojen esitysmuoto" },
            { "key.co", "lajittelujärjestys" },
            { "key.cu", "valuutta" },
            { "key.hc", "tuntijärjestelmä" },
            { "key.lb", "rivinvaihtotyyli" },
            { "key.ms", "mittajärjestelmä" },
            { "key.nu", "numerot" },
            { "key.tz", "aikavyöhyke" },
            { "key.va", "maavalinnan muunnelma" },
            { "nds_NL", "alankomaidenalasaksa" },
            { "%%ALUKU", "alukun kreolimurre" },
            { "%%BARLA", "kapverdenkreolin barlaventolainen murreryhmä" },
            { "%%BISKE", "sloveenin resian San Giorgion/Bilan alamurre" },
            { "%%BOONT", "englannin boontling-murre" },
            { "%%CORNU", "englannin cornu-murre" },
            { "%%GALLO", "galo" },
            { "%%JAUER", "retoromaanin jauer-murre" },
            { "%%KKCOR", "kornin yleiskirjoitus" },
            { "%%KSCOR", "kornin Kernowek-ortografia" },
            { "%%LIPAW", "sloveenin resian Lipovazin/Lipovecin alamurre" },
            { "%%NEDIS", "sloveenin natisonen murre" },
            { "%%NJIVA", "sloveenin resian Gnivan/Njivan alamurre" },
            { "%%NULIK", "nykyvolapük" },
            { "%%OSOJS", "sloveenin resian Oseaccon/Osojanen alamurre" },
            { "%%PEANO", "taivutukseton latina" },
            { "%%POSIX", "tietokonemäärittely POSIX" },
            { "%%PUTER", "retoromaanin puter-muoto" },
            { "%%RIGIK", "klassinen volapük" },
            { "%%ROZAJ", "sloveenin resian murre" },
            { "%%RUMGR", "retoromaanin rumantsch grischun -muoto" },
            { "%%SAAHO", "afarin saho-murre" },
            { "%%SOLBA", "sloveenin resian Stolvizzan/Solbican alamurre" },
            { "%%SOTAV", "kapverdenkreolin sotaventolainen murreryhmä" },
            { "%%UCCOR", "kornin yhtenäiskirjoitus" },
            { "%%AO1990", "portugalin oikeinkirjoitussopimus 1990" },
            { "%%ARANES", "oksitaanin Aranin laakson variantti" },
            { "%%ASANTE", "akanin asante-variantti" },
            { "%%AUVERN", "oksitaanin Auvergnen variantti" },
            { "%%CISAUP", "oksitaanin luoteisitalialainen variantti" },
            { "%%CREISS", "oksitaanin Croissantin variantti" },
            { "%%DAJNKO", "sloveenin Dajnko-aakkosto" },
            { "%%EKAVSK", "serbian ekavialainen ääntämys" },
            { "%%FONIPA", "kansainvälinen foneettinen aakkosto IPA" },
            { "%%FONUPA", "uralilainen foneettinen aakkosto UPA" },
            { "%%GASCON", "oksitaanin Gasconyn variantti" },
            { "%%GRITAL", "oksitaanin italialaisvaikutteinen ortografia" },
            { "%%NDYUKA", "ndyukan kreolimurre" },
            { "%%NICARD", "oksitaanin Nizzan variantti" },
            { "%%PAMAKA", "pamakan kreolimurre" },
            { "%%PINYIN", "kiinan pinyin-latinaistus" },
            { "%%SCOUSE", "englannin scouse-murre" },
            { "%%SIMPLE", "yksinkertaistettu kielimuoto" },
            { "%%TARASK", "valkovenäjän taraškevitsa-oikeinkirjoitus" },
            { "%%UCRCOR", "kornin uusittu yhtenäiskirjoitus" },
            { "%%ULSTER", "skotin ulster-murre" },
            { "%%UNIFON", "englannin foneeminen unifon-aakkosto" },
            { "%%ABL1943", "portugalin oikeinkirjoitus 1943" },
            { "%%AKUAPEM", "akanin akuapem-murre" },
            { "%%ALALC97", "amerikkalainen kirjastolatinaistus 1997" },
            { "%%AREVELA", "itäarmenialainen" },
            { "%%AREVMDA", "länsiarmenialainen" },
            { "%%ARKAIKA", "varhaisesperanto" },
            { "%%BALANKA", "aniin balankalaismurre" },
            { "%%BAUDDHA", "sanskriitin buddhalainen sekamuoto" },
            { "%%BOHORIC", "sloveenin Bohorič-aakkosto" },
            { "%%EMODENG", "varhaisnykyenglanti" },
            { "%%FONNAPA", "pohjoisamerikkalainen foneettinen aakkosto NAPA" },
            { "%%GRCLASS", "oksitaanin klassinen ortografia" },
            { "%%GRMISTR", "oksitaanin Mistral-vaikutteinen ortografia" },
            { "%%HEPBURN", "japanin Hepburn-latinaistus" },
            { "%%ITIHASA", "sanskriitin eeppinen muoto" },
            { "%%LAUKIKA", "klassinen sanskriitti" },
            { "%%LEMOSIN", "oksitaanin Limousin-alueen variantti" },
            { "%%METELKO", "sloveenin Metelko-aakkosto" },
            { "%%MONOTON", "monotoninen kreikka" },
            { "%%PAHAWH2", "pahawh-hmongin tavukirjoituksen toinen vaihe" },
            { "%%PAHAWH3", "pahawh-hmongin tavukirjoituksen kolmas vaihe" },
            { "%%PAHAWH4", "pahawh-hmongin tavukirjoituksen viimeinen vaihe" },
            { "%%POLYTON", "polytoninen kreikka" },
            { "%%PROVENC", "provensaali" },
            { "%%REVISED", "uudistettu oikeinkirjoitus" },
            { "%%SURSILV", "retoromaanin sursilvan-muoto" },
            { "%%SUTSILV", "retoromaanin sutsilvan-muoto" },
            { "%%VAIDIKA", "sanskriitin veda-murre" },
            { "%%1606NICT", "myöhäiskeskiranska" },
            { "%%1694ACAD", "varhaisnykyranska" },
            { "%%1959ACAD", "valkovenäjän virallinen oikeinkirjoitus" },
            { "%%BAKU1926", "yhtenäistetty turkkilainen latinalainen aakkosto" },
            { "%%BASICENG", "Ogdenin perusenglanti" },
            { "%%BISCAYAN", "baskin biskajalaismurre" },
            { "%%BORNHOLM", "Bornholmin murre" },
            { "%%COLB1945", "portugalin oikeinkirjoitus 1945" },
            { "%%FONKIRSH", "Kirshenbaumin foneettinen aakkosto" },
            { "%%FONXSAMP", "foneettinen X-SAMPA-merkistö" },
            { "%%HOGNORSK", "norjan högnorsk" },
            { "%%HSISTEMO", "esperanton h-kirjoitus" },
            { "%%IJEKAVSK", "serbian ijekavialainen ääntämys" },
            { "%%IVANCHOV", "bulgarian 1899 ortografia" },
            { "%%JYUTPING", "kantoninkiinan jyutping-latinaistus" },
            { "%%KOCIEWIE", "puolan kociewielainen murre" },
            { "%%LENGADOC", "oksitaanin lengadocian variantti" },
            { "%%LUNA1918", "venäjän ortografia 1918" },
            { "%%NEWFOUND", "englannin newfoundlandilaismurre" },
            { "%%OXENDICT", "englannin Oxfordin sanakirjan oikeinkirjoitus" },
            { "%%PETR1708", "venäjän Pietarin siviiliaakkosto 1708" },
            { "%%SCOTLAND", "skotlanninenglanti" },
            { "%%SPANGLIS", "spanglish" },
            { "%%SURMIRAN", "retoromaanin surmiran-muoto" },
            { "%%SYNNEJYL", "Etelä-Jyllannin kieli" },
            { "%%TONGYONG", "taiwanilainen pinyinin" },
            { "%%TUNUMIIT", "tunumiit" },
            { "%%VALENCIA", "katalaanin valencian murre" },
            { "%%VALLADER", "reoromaanin vallader-muoto" },
            { "%%VECDRUKA", "varhaislatvia" },
            { "%%VIVARAUP", "oksitaanin vivaro-alpiininen variantti" },
            { "%%WADEGILE", "kiinan Wade-Giles-latinaistus" },
            { "%%XSISTEMO", "esperanton x-kirjoitus" },
            { "type.ca.roc", "Kiinan tasavallan kalenteri" },
            { "type.co.eor", "yleiseurooppalainen lajittelujärjestys" },
            { "type.hc.h11", "12 tunnin järjestelmä (0–11)" },
            { "type.hc.h12", "12 tunnin järjestelmä (1–12)" },
            { "type.hc.h23", "24 tunnin järjestelmä (0–23)" },
            { "type.hc.h24", "24 tunnin järjestelmä (1–24)" },
            { "type.m0.bgn", "BGN-latinaistus" },
            { "type.nu.ahom", "ahom-numerot" },
            { "type.nu.arab", "arabialaiset numerot" },
            { "type.nu.armn", "armenialaiset numerot" },
            { "type.nu.bali", "balilaiset numerot" },
            { "type.nu.beng", "bengalilaiset numerot" },
            { "type.nu.brah", "brahmilaiset numerot" },
            { "type.nu.cakm", "chakmalaiset numerot" },
            { "type.nu.cham", "cham-numerot" },
            { "type.nu.cyrl", "kyrilliset numerot" },
            { "type.nu.deva", "devanagarinumerot" },
            { "type.nu.diak", "dives akuru -numerot" },
            { "type.nu.ethi", "etiopialaiset numerot" },
            { "type.nu.geor", "georgialaiset numerot" },
            { "type.nu.gong", "gondin gunjala-numerot" },
            { "type.nu.gonm", "gondin masaram-numerot" },
            { "type.nu.grek", "kreikkalaiset numerot" },
            { "type.nu.gujr", "gudžaratilaiset numerot" },
            { "type.nu.guru", "gurmukhilaiset numerot" },
            { "type.nu.hans", "yksinkertaistetut kiinalaiset numerot" },
            { "type.nu.hant", "perinteiset kiinalaiset numerot" },
            { "type.nu.hebr", "heprealaiset numerot" },
            { "type.nu.hmng", "pahawh hmong -numerot" },
            { "type.nu.hmnp", "hmongin nyiakeng puachue -numerot" },
            { "type.nu.java", "jaavalaiset numerot" },
            { "type.nu.jpan", "japanilaiset numerot" },
            { "type.nu.kali", "kayah li -numerot" },
            { "type.nu.kawi", "kawilaiset numerot" },
            { "type.nu.khmr", "khmeriläiset numerot" },
            { "type.nu.knda", "kannadalaiset numerot" },
            { "type.nu.lana", "taithamin hora-numerot" },
            { "type.nu.laoo", "laolaiset numerot" },
            { "type.nu.latn", "länsimaiset numerot" },
            { "type.nu.lepc", "lepchanumerot" },
            { "type.nu.limb", "limbunumerot" },
            { "type.nu.mlym", "malajalamilaiset numerot" },
            { "type.nu.modi", "modi-numerot" },
            { "type.nu.mong", "mongolialaiset numerot" },
            { "type.nu.mroo", "mro-numerot" },
            { "type.nu.mtei", "meetei mayek -numerot" },
            { "type.nu.mymr", "burmalaiset numerot" },
            { "type.nu.nagm", "Nagin mundarinumerot" },
            { "type.nu.nkoo", "n’ko-numerot" },
            { "type.nu.olck", "ol chiki -numerot" },
            { "type.nu.orya", "orijalaiset numerot" },
            { "type.nu.osma", "osmanjalaiset numerot" },
            { "type.nu.rohg", "hanifilaisen rohingyan numerot" },
            { "type.nu.saur", "saurashtra-numerot" },
            { "type.nu.shrd", "šarada-numerot" },
            { "type.nu.sind", "khutabadi-numerot" },
            { "type.nu.sinh", "sinhalan lith-numerot" },
            { "type.nu.sora", "sora sompeng -numerot" },
            { "type.nu.sund", "sundalaiset numerot" },
            { "type.nu.takr", "takri-numerot" },
            { "type.nu.talu", "uudet tai lue -numerot" },
            { "type.nu.taml", "perinteiset tamilinumerot" },
            { "type.nu.telu", "telugulaiset numerot" },
            { "type.nu.thai", "thainumerot" },
            { "type.nu.tibt", "tiibetiläiset numerot" },
            { "type.nu.tirh", "tirhuta-numerot" },
            { "type.nu.tnsa", "tangsa-numerot" },
            { "type.nu.vaii", "vai-numerot" },
            { "type.nu.wara", "varang kshiti -numerot" },
            { "type.nu.wcho", "wancholaiset numerot" },
            { "type.ca.dangi", "dangilainen kalenteri" },
            { "type.co.ducet", "Unicoden oletusjärjestys" },
            { "type.co.emoji", "emojien lajittelujärjestys" },
            { "type.lb.loose", "väljä rivinvaihto" },
            { "type.nu.roman", "roomalaiset numerot" },
            { "type.ca.coptic", "koptilainen kalenteri" },
            { "type.ca.hebrew", "juutalainen kalenteri" },
            { "type.ca.indian", "intialainen kalenteri" },
            { "type.co.compat", "aiempi lajittelujärjestys yhteensopivuutta varten" },
            { "type.co.pinyin", "pinyin-järjestys" },
            { "type.co.search", "yleishakujärjestys" },
            { "type.co.stroke", "piirtojärjestys" },
            { "type.co.unihan", "radikaali- ja piirtojärjestys" },
            { "type.co.zhuyin", "zhuyin-järjestys" },
            { "type.d0.fwidth", "ideogrammin levyinen" },
            { "type.d0.hwidth", "ideogrammin puolikkaan levyinen" },
            { "type.lb.normal", "normaali rivinvaihto" },
            { "type.lb.strict", "tarkka rivinvaihto" },
            { "type.m0.ungegn", "UNGEGN-latinaistus" },
            { "type.ms.metric", "metrijärjestelmä" },
            { "type.nu.native", "kielen omat numerot" },
            { "type.ca.chinese", "kiinalainen kalenteri" },
            { "type.ca.islamic", "hidžra-kalenteri" },
            { "type.ca.iso8601", "ISO 8601 -kalenteri" },
            { "type.ca.persian", "persialainen kalenteri" },
            { "type.cf.account", "valuuttojen laskentatoimen esitysmuoto" },
            { "type.co.big5han", "perinteinen kiinalainen järjestys Big5" },
            { "type.d0.npinyin", "numeerinen muunnos" },
            { "type.nu.arabext", "laajennetut arabialaiset numerot" },
            { "type.nu.armnlow", "armenialaiset piennumerot" },
            { "type.nu.finance", "talousnumerot" },
            { "type.nu.greklow", "kreikkalaiset piennumerot" },
            { "type.nu.hanidec", "kiinalaiset desimaalinumerot" },
            { "type.nu.hansfin", "yksinkertaistetut kiinalaiset talousnumerot" },
            { "type.nu.hantfin", "perinteiset kiinalaiset talousnumerot" },
            { "type.nu.jpanfin", "japanilaiset talousnumerot" },
            { "type.nu.mathdbl", "matemaattiset kaksoislyöntinumerot" },
            { "type.nu.tamldec", "tamilinumerot" },
            { "type.ca.buddhist", "buddhalainen kalenteri" },
            { "type.ca.ethiopic", "etiopialainen kalenteri" },
            { "type.ca.japanese", "japanilainen kalenteri" },
            { "type.cf.standard", "valuuttojen vakioesitysmuoto" },
            { "type.co.phonetic", "äänteellinen järjestys" },
            { "type.co.searchjl", "haku hangul-alkukonsonantin mukaan" },
            { "type.co.standard", "normaalijärjestys" },
            { "type.ms.uksystem", "brittiläinen mittajärjestelmä" },
            { "type.ms.ussystem", "yhdysvaltalainen mittajärjestelmä" },
            { "type.nu.fullwide", "ideografin levyiset numerot" },
            { "type.nu.lanatham", "taithamin tham-numerot" },
            { "type.nu.mathbold", "matemaattiset lihavoidut numerot" },
            { "type.nu.mathmono", "matemaattiset tasalevyiset numerot" },
            { "type.nu.mathsanb", "matemaattiset pääteviivattomat lihavoidut numerot" },
            { "type.nu.mathsans", "matemaattiset pääteviivattomat numerot" },
            { "type.nu.mymrshan", "myanmarin shan-numerot" },
            { "type.nu.mymrtlng", "myanmarin tai laing -numerot" },
            { "type.nu.romanlow", "roomalaiset piennumerot" },
            { "type.ca.gregorian", "gregoriaaninen kalenteri" },
            { "type.co.gb2312han", "yksinkertaistettu kiinalainen järjestys GB2312" },
            { "type.co.phonebook", "puhelinluettelojärjestys" },
            { "type.co.dictionary", "sanakirjajärjestys" },
            { "type.co.traditional", "perinteinen järjestys" },
            { "type.nu.traditional", "perinteiset numerot" },
            { "type.ca.islamic-rgsa", "hidžra-kalenteri (saudiarabialainen)" },
            { "type.ca.islamic-tbla", "hidžra-matemaattinen kalenteri (tabulaarinen, torstaiepookki)" },
            { "type.ca.islamic-civil", "hidžra-siviilikalenteri (tabulaarinen, perjantaiepookki)" },
            { "type.ca.islamic-umalqura", "hidžra-kalenteri, Umm al-Qura" },
            { "type.ca.ethiopic-amete-alem", "etiopialainen amete alem -kalenteri" },
        };
        return data;
    }
}
