/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Wā Toharite Kiriwīti",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Wā Āpia Arowhānui",
               "",
               "Wā Āpia Awatea",
               "",
               "Wā Āpia",
               "",
            };
        final String[] Cook = new String[] {
               "Wā Kuki Airani Arowhānui",
               "",
               "Wā Kuki Airani Raumati Haurua",
               "",
               "Wā Kuki Airani",
               "",
            };
        final String[] Cuba = new String[] {
               "Wā Arowhānui Kiupa",
               "CST",
               "Wā Awatea Kiupa",
               "CDT",
               "Wā Kiupa",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Wā Whītī Arowhānui",
               "",
               "Wā Whītī Raumati",
               "",
               "Wā Whītī",
               "",
            };
        final String[] Gulf = new String[] {
               "Wā Whanga Arowhānui",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Wā Hovd Arowhānui",
               "",
               "Wā Hovd Raumati",
               "",
               "Wā Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Wā Irāna Arowhānui",
               "",
               "Wā Irāna Awatea",
               "",
               "Wā Irāna",
               "",
            };
        final String[] Niue = new String[] {
               "Wā Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Wā Omsk Arowhānui",
               "",
               "Wā Omsk Raumati",
               "",
               "Wā Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Wā Peru Arowhānui",
               "",
               "Wā Peru Raumati",
               "",
               "Wā Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Wā Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wā o Te Motu Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Wā Hiri Arowhānui",
               "",
               "Wā Hiri Raumati",
               "",
               "Wā Hiri",
               "",
            };
        final String[] China = new String[] {
               "Wā Haina Arowhānui",
               "CST",
               "Wā Haina Awatea",
               "CDT",
               "Wā Haina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Wā o Ngā Moutere Kokohi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Wā Rēweti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Wā Īnia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Wā Hapani Arowhānui",
               "JST",
               "Wā Hapani Awatea",
               "JDT",
               "Wā Hapani",
               "JT",
            };
        final String[] Korea = new String[] {
               "Wā Kōrea Arowhānui",
               "KST",
               "Wā Kōrea Awatea",
               "KST",
               "Wā Kōrea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Wā Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Wā Nepōra",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Wā Pārau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Wā Hāmoa Arowhānui",
               "SST",
               "Wā Hāmoa Awatea",
               "SST",
               "Wā Hāmoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Wā Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Wā Tonga Arowhānui",
               "",
               "Wā Tonga Raumati",
               "",
               "Wā Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Wā Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Wā Arowhānui Alaska",
               "AKST",
               "Wā Awatea Alaska",
               "AKDT",
               "Wā Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Wā Amahona Arowhānui",
               "",
               "Wā Amahona Raumati",
               "",
               "Wā Amahona",
               "",
            };
        final String[] Azores = new String[] {
               "Wā Azores Arowhānui",
               "",
               "Wā Azores Raumati",
               "",
               "Wā Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Wā Pūtana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Wā Poronai Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Wā ki te Moutere Aranga Arowhānui",
               "",
               "Wā ki te Moutere Aranga Raumati",
               "",
               "Wā ki te Moutere o Aranga",
               "",
            };
        final String[] Guyana = new String[] {
               "Wā Kaiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Wā Iharaira Arowhānui",
               "IST",
               "Wā Iharaira Awatea",
               "IDT",
               "Wā Iharaira",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Wā Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Wā Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Wā Mohikau Arowhānui",
               "MSK",
               "Wā Mohikau Raumati",
               "MSK",
               "Wā Mohikau",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Wā Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Wā Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Wā Taipei Arowhānui",
               "CST",
               "Wā Taipei Awatea",
               "CDT",
               "Wā Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Wā Tūwaru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wā Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wā Wārihi me Whutuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Wā Arāpia Arowhānui",
               "",
               "Wā Arāpia Awatea",
               "",
               "Wā Arāpia",
               "",
            };
        final String[] Armenia = new String[] {
               "Wā Āmenia Arowhānui",
               "",
               "Wā Āmenia Raumati",
               "",
               "Wā Āmenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Wā Poriwia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Wā Rēkohu Arowhānui",
               "",
               "Wā Rēkohu Awatea",
               "",
               "Wā Rēkohu",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Wā Aonui Kōtuitui",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Wā Ekuatoa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Wā Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Wā Hōria Arowhānui",
               "",
               "Wā Hōria Raumati",
               "",
               "Wā Hōria",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Wā Irkutsk Arowhānui",
               "",
               "Wā Irkutsk Raumati",
               "",
               "Wā Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Wā Magadan Arowhānui",
               "",
               "Wā Magadan Raumati",
               "",
               "Wā Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Wā Pēma",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Wā o Te Moutere Nōpoke Arowhānui",
               "",
               "Wā o Te Moutere Nōpoke Awatea",
               "",
               "Wā o Te Moutere Nōpoke",
               "",
            };
        final String[] Noronha = new String[] {
               "Wā Fernando de Noronha Arowhānui",
               "",
               "Wā Fernando de Noronha Raumati",
               "",
               "Wā Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Wā Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Wā Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Wā o Ngā Motu Horomona",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Wā Tokerau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Wā Urukoi Arowhānui",
               "",
               "Wā Urukoi Raumati",
               "",
               "Wā Urukoi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Wā Whenuatū Arowhānui",
               "",
               "Wā Whenuatū Raumati",
               "",
               "Wā Whenuatū",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Wā Yakutsk Arowhānui",
               "",
               "Wā Yakutsk Raumati",
               "",
               "Wā Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Wā Arowhānui Ranatiki",
               "AST",
               "Wā Awatea Ranatiki",
               "AST",
               "Wā Ranatiki",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Wā Parīhia Arowhānui",
               "",
               "Wā Parīhia Raumati",
               "",
               "Wā Parīhia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Wā Chamorro Arowhānui",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Wā Koromōpia Arowhānui",
               "",
               "Wā Koromōpia Raumati",
               "",
               "Wā Koromōpia",
               "",
            };
        final String[] Falkland = new String[] {
               "Wā ki Ngā Motu Whākana Arowhānui",
               "",
               "Wā ki Ngā Motu Whākana Raumati",
               "",
               "Wā ki Ngā Motu Whākana",
               "",
            };
        final String[] Malaysia = new String[] {
               "Wā Mareia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Wā Māratiri",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Wā Ulaanbaatar Arowhānui",
               "",
               "Wā Ulaanbaatar Raumati",
               "",
               "Wā Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Wā Pakitāne Arowhānui",
               "PKT",
               "Wā Pakitāne Raumati",
               "PKST",
               "Wā Pakitāne",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Wā Parakai Arowhānui",
               "",
               "Wā Parakai Raumati",
               "",
               "Wā Parakai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Wā Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Wā Sakhalin Arowhānui",
               "",
               "Wā Sakhalin Raumati",
               "",
               "Wā Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Wā Huriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Wā Āketina Arowhānui",
               "",
               "Wā Āketina Raumati",
               "",
               "Wā Āketina",
               "",
            };
        final String[] Christmas = new String[] {
               "Wā o Te Moutere Kirihimete",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Wā Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Wā Hongipua Arowhānui",
               "HKT",
               "Wā Hongipua Raumati",
               "HKST",
               "Wā Hongipua",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Wā Īniahaina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Wā Kikitānga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Wā Lord Howe Arowhānui",
               "",
               "Wā Lord Howe Awatea",
               "",
               "Wā Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Wā Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Wā Marihi Arowhānui",
               "",
               "Wā Marihi Raumati",
               "",
               "Wā Marihi",
               "",
            };
        final String[] Singapore = new String[] {
               "Wā Hingapoa Arowhānui",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wā Penehūera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wā Volgograd Arowhānui",
               "MSK",
               "Wā Volgograd Raumati",
               "MSK",
               "Wā Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Wā Atepaihānia Arowhānui",
               "",
               "Wā Atepaihānia Raumati",
               "",
               "Wā Atepaihānia",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Wā Pākaratēhi Arowhānui",
               "",
               "Wā Pākaratēhi Raumati",
               "",
               "Wā Pākaratēhi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Wā Arowhānui o Te Kūrae Matomato",
               "",
               "Wā Raumati o Te Kūrae Matomato",
               "",
               "Wā o Te Kūrae Matomato",
               "",
            };
        final String[] East_Timor = new String[] {
               "Wā o Timoa ki te Rāwhiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Wā Katatānga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Wā Heikere",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Wā Takiritānga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Wā Uhipeketāne Arowhānui",
               "",
               "Wā Uhipeketāne Raumati",
               "",
               "Wā Uhipeketāne",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Wā Awhekenetāna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Wā Krasnoyarsk Arowhānui",
               "",
               "Wā Krasnoyarsk Raumati",
               "",
               "Wā Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Wā Aotearoa Arowhānui",
               "NZST",
               "Wā Aotearoa Awatea",
               "NZDT",
               "Wā Aotearoa",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Wā Novosibirsk Arowhānui",
               "",
               "Wā Novosibirsk Raumati",
               "",
               "Wā Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Wā Piripīni Arowhānui",
               "PST",
               "Wā Piripīni Raumati",
               "PDT",
               "Wā Piripīni",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wā Vladivostok Arowhānui",
               "",
               "Wā Vladivostok Raumati",
               "",
               "Wā Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Wā o Te Moana Īnia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Wā o Ngā Mouter o Te Raina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Wā Arowhānui Newfoundland",
               "NST",
               "Wā Awatea Newfoundland",
               "NDT",
               "Wā Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Wā Tukumanatānga Arowhānui",
               "",
               "Wā Tukumanatānga Raumati",
               "",
               "Wā Tukumanatānga",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Wā Kiāna Wīwī",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Wā Whenua Kanaki Arowhānui",
               "",
               "Wā Whenua Kanaki Raumati",
               "",
               "Wā Whenua Kanaki",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Wā Hōria ki te Tonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Wā Yekaterinburg Arowhānui",
               "",
               "Wā Yekaterinburg Raumati",
               "",
               "Wā Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Wā o Te Puku o Āwherika",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Wā o Āwherika ki te rāwhiti",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Wā Arowhānui o Āwerika ki te uru",
               "WAT",
               "Wā Raumati o Āwherika ki te uru",
               "WAT",
               "Wā o Āwherika ki te uru",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Wā Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Wā Arowhānui Uropi Waenga",
               "CET",
               "Wā Raumati Uropi Waenga",
               "CEST",
               "Wā Uropi Waenga",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Wā Arowhānui Uropi Rāwhiti",
               "EET",
               "Wā Raumati Uropi Rāwhiti",
               "EEST",
               "Wā Uropi Rāwhiti",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Wā Arowhānui Uropi Uru",
               "WET",
               "Wā Raumati Uropi Uru",
               "WEST",
               "Wā Uropi Uru",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Wā Arowhānui Mēhiko Kiwa",
               "MST",
               "Wā Awatea Mēhiko Kiwa",
               "MDT",
               "Wā Mēhiko Kiwa",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Wā Arowhānui o Āwherika ki te tonga",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Wā Arowhānui Waenga",
               "CST",
               "Wā Awatea Waenga",
               "CDT",
               "Wā Waenga",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Wā Arowhānui Rāwhiti",
               "EST",
               "Wā Awatea Rāwhiti",
               "EST",
               "Wā Rāwhiti",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Wā Arowhānui Kiwa",
               "PST",
               "Wā Awatea Kiwa",
               "PDT",
               "Wā Kiwa",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Wā Wīwī o Te Tonga me te Kōpakatanga ki te Tonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Wā Kiripati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Wā Arowhānui Hawaii-Aleutian",
               "HST",
               "Wā Awatea Hawaii-Aleutian",
               "HST",
               "Wā Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Wā o Ngā Moutere Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Wā Arowhānui o St. Pierre me Miquelon",
               "",
               "Wā Awatea o St. Pierre me Miquelon",
               "",
               "Wā St. Pierre me Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Wā Arowhānui Maunga",
               "MST",
               "Wā Awatea Maunga",
               "MST",
               "Wā Maunga",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Wā o Ngā Motu Māhara",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Wā Papua Nūkini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Wā Ahitereiria Waenga Arowhānui",
               "ACST",
               "Wā Ahitereiria Waenga Awatea",
               "ACDT",
               "Wā Ahitereiria Waenga",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Wā Ahitereiria ki te Rāwhiti Arowhānui",
               "AEST",
               "Wā Ahitereiria ki te Rāwhiti Awatea",
               "AEDT",
               "Wā Ahitereiria ki te Rāwhiti",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Wā Ahitereiria ki te Uru Arowhānui",
               "AWST",
               "Wā Ahitereiria ki te Uru Awatea",
               "AWDT",
               "Wā Ahitereiria ki te Uru",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Wā Initonīhia Waenga",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Wā Initonīhia ki te rāwhiti",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Wā Initonīhia ki te uru",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Wā Ahitereiria Waenga-Uru Arowhānui",
               "",
               "Wā Ahitereiria Waenga-Uru Awatea",
               "",
               "Wā Ahitereiria Waenga-Uru",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Wā Aonui Kōtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Airihi Arowhānui",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Wā Aonui Kōtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Wā Aonui Kōtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Wā Aonui Kōtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Wā Aonui Kōtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Wā Aonui Kōtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Airihi Arowhānui",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Wā Toharite Kiriwīti",
                    "GMT",
                    "Wā Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "Kāha" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dubai", "Tupae" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "timezone.excity.Asia/Qatar", "Katā" },
            { "timezone.excity.Asia/Seoul", "Houra" },
            { "timezone.excity.Asia/Tokyo", "Tōkio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Brunei", "Poronai" },
            { "timezone.excity.Asia/Kuwait", "Kūweiti" },
            { "timezone.excity.Asia/Manila", "Manira" },
            { "timezone.excity.Asia/Riyadh", "Riata" },
            { "timezone.excity.Asia/Tehran", "Terāna" },
            { "timezone.excity.Etc/Unknown", "Tāone Tē Mōhiotia" },
            { "timezone.excity.Europe/Oslo", "Ōhoro" },
            { "timezone.excity.Europe/Rome", "Rōma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Tunis", "Tūnīhi" },
            { "timezone.excity.Asia/Baghdad", "Pākatata" },
            { "timezone.excity.Asia/Bahrain", "Pāreina" },
            { "timezone.excity.Asia/Bangkok", "Pangakoko" },
            { "timezone.excity.Asia/Jakarta", "Tiakāta" },
            { "timezone.excity.Europe/Malta", "Mārata" },
            { "timezone.excity.Europe/Paris", "Parī" },
            { "timezone.excity.Indian/Cocos", "Kokohi" },
            { "timezone.excity.Pacific/Apia", "Āpia" },
            { "timezone.excity.Pacific/Fiji", "Whītī" },
            { "timezone.excity.Pacific/Guam", "Kuama" },
            { "timezone.excity.Asia/Katmandu", "Katamarū" },
            { "timezone.excity.Asia/Shanghai", "Hangahai" },
            { "timezone.excity.Europe/Athens", "Ātene" },
            { "timezone.excity.Europe/Berlin", "Pearīni" },
            { "timezone.excity.Europe/Dublin", "Tapurini" },
            { "timezone.excity.Europe/Lisbon", "Rīpene" },
            { "timezone.excity.Europe/London", "Rānana" },
            { "timezone.excity.Europe/Madrid", "Mātiri" },
            { "timezone.excity.Europe/Monaco", "Monāko" },
            { "timezone.excity.Europe/Moscow", "Mohikau" },
            { "timezone.excity.Europe/Prague", "Parāka" },
            { "timezone.excity.Europe/Vienna", "Whiena" },
            { "timezone.excity.Europe/Zurich", "Hūrika" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "timezone.excity.Pacific/Palau", "Pārau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Nairobi", "Ngāiropi" },
            { "timezone.excity.Africa/Tripoli", "Tiriporī" },
            { "timezone.excity.America/Belize", "Pērihi" },
            { "timezone.excity.America/Cayman", "Kāmana" },
            { "timezone.excity.America/Havana", "Hawhāna" },
            { "timezone.excity.Asia/Hong_Kong", "Hongipua" },
            { "timezone.excity.Asia/Jerusalem", "Hiruhārama" },
            { "timezone.excity.Asia/Singapore", "Hingapoa" },
            { "timezone.excity.Europe/Andorra", "Anatōra" },
            { "timezone.excity.Europe/Vatican", "Te Poho-o-Pita" },
            { "timezone.excity.Pacific/Noumea", "Nūmea" },
            { "timezone.excity.Pacific/Wallis", "Wārihi" },
            { "timezone.excity.America/Antigua", "Te Motu Nehe" },
            { "timezone.excity.America/Chicago", "Hikāko" },
            { "timezone.excity.America/Grenada", "Kerenata" },
            { "timezone.excity.America/Jamaica", "Hemeika" },
            { "timezone.excity.America/Toronto", "Tāroto" },
            { "timezone.excity.Asia/Phnom_Penh", "Penoma Pena" },
            { "timezone.excity.Australia/Perth", "Pētia" },
            { "timezone.excity.Europe/Brussels", "Paruhi" },
            { "timezone.excity.Europe/Budapest", "Putapēhi" },
            { "timezone.excity.Europe/Helsinki", "Hēriki" },
            { "timezone.excity.Europe/Istanbul", "Itapūru" },
            { "timezone.excity.Indian/Maldives", "Māratiri" },
            { "timezone.excity.Pacific/Chatham", "Rēkohu" },
            { "timezone.excity.Pacific/Norfolk", "Nōpoke" },
            { "timezone.excity.America/Barbados", "Papatohe" },
            { "timezone.excity.America/Dominica", "Tominika" },
            { "timezone.excity.America/New_York", "Te Āporo Nui" },
            { "timezone.excity.America/St_Johns", "Hato Hone" },
            { "timezone.excity.America/St_Lucia", "Hato Ruihia" },
            { "timezone.excity.Antarctica/Davis", "Rēweti" },
            { "timezone.excity.Atlantic/Bermuda", "Pāmura" },
            { "timezone.excity.Australia/Darwin", "Tāwini" },
            { "timezone.excity.Australia/Hobart", "Hopatāone" },
            { "timezone.excity.Australia/Sydney", "Poihākena" },
            { "timezone.excity.Europe/Amsterdam", "Pāpuniāmita" },
            { "timezone.excity.Europe/Stockholm", "Tokoomo" },
            { "timezone.excity.Indian/Christmas", "Kirihimete" },
            { "timezone.excity.Indian/Mauritius", "Marihi" },
            { "timezone.excity.Pacific/Auckland", "Tāmaki Makaurau" },
            { "timezone.excity.America/Goose_Bay", "Kuihi Pei" },
            { "timezone.excity.America/Guatemala", "Kuatamāra" },
            { "timezone.excity.America/St_Thomas", "Hato Tamati" },
            { "timezone.excity.America/Vancouver", "Te Whanga-a-Kiwa" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuara Rūpa" },
            { "timezone.excity.Europe/Copenhagen", "Kopeheikana" },
            { "timezone.excity.Europe/Luxembourg", "Rakapuō" },
            { "timezone.excity.Europe/San_Marino", "Hana Marino" },
            { "timezone.excity.Pacific/Pago_Pago", "Pango Pango" },
            { "timezone.excity.America/Costa_Rica", "Koto Rika" },
            { "timezone.excity.America/Grand_Turk", "Tākoru Nui" },
            { "timezone.excity.America/Martinique", "Mātiniki" },
            { "timezone.excity.America/St_Vincent", "Hato Wēneti" },
            { "timezone.excity.Atlantic/St_Helena", "Hato Hērena" },
            { "timezone.excity.Australia/Adelaide", "Atireira" },
            { "timezone.excity.Australia/Brisbane", "Piripane" },
            { "timezone.excity.Europe/Isle_of_Man", "Te Moutere Mana" },
            { "timezone.excity.America/El_Salvador", "Whakaora" },
            { "timezone.excity.America/Los_Angeles", "Ngā Anahera" },
            { "timezone.excity.America/Mexico_City", "Mēhiko Tāonenui" },
            { "timezone.excity.America/Puerto_Rico", "Peta Riko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Te Kūrae Matomato" },
            { "timezone.excity.Australia/Melbourne", "Poipiripi" },
            { "timezone.excity.Antarctica/Macquarie", "Makoare" },
            { "timezone.excity.Pacific/Port_Moresby", "Pota Moahipi" },
            { "timezone.excity.America/Cambridge_Bay", "Kemureti Pei" },
            { "timezone.excity.Atlantic/South_Georgia", "Hōria ki Te Tonga" },
        };
        return data;
    }
}
