/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_et extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "araabia";
        final String metaValue_hy = "armeenia";
        final String metaValue_ae = "avesta";
        final String metaValue_ban = "bali";
        final String metaValue_bbc = "bataki";
        final String metaValue_bn = "bengali";
        final String metaValue_zbl = "Blissi sümbolid";
        final String metaValue_bug = "bugi";
        final String metaValue_ccp = "tšaakma";
        final String metaValue_chr = "tšerokii";
        final String metaValue_cop = "kopti";
        final String metaValue_gez = "etioopia";
        final String metaValue_ka = "gruusia";
        final String metaValue_got = "gooti";
        final String metaValue_el = "kreeka";
        final String metaValue_gu = "gudžarati";
        final String metaValue_ko = "korea";
        final String metaValue_he = "heebrea";
        final String metaValue_jv = "jaava";
        final String metaValue_ja = "jaapani";
        final String metaValue_kaw = "kaavi";
        final String metaValue_km = "khmeeri";
        final String metaValue_kn = "kannada";
        final String metaValue_kpe = "kpelle";
        final String metaValue_lo = "lao";
        final String metaValue_la = "ladina";
        final String metaValue_mak = "makassari";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malajalami";
        final String metaValue_mn = "mongoli";
        final String metaValue_my = "birma";
        final String metaValue_new = "nevari";
        final String metaValue_nqo = "nkoo";
        final String metaValue_sat = "santali";
        final String metaValue_or = "oria";
        final String metaValue_osa = "oseidži";
        final String metaValue_phn = "foiniikia";
        final String metaValue_rhg = "rohingja";
        final String metaValue_saz = "sauraštra";
        final String metaValue_si = "singali";
        final String metaValue_sog = "sogdi";
        final String metaValue_su = "sunda";
        final String metaValue_syr = "süüria";
        final String metaValue_ta = "tamili";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalogi";
        final String metaValue_th = "tai";
        final String metaValue_bo = "tiibeti";
        final String metaValue_uga = "ugariti";
        final String metaValue_peo = "vanapärsia";
        final Object[][] data = new Object[][] {
            { "001", "maailm" },
            { "002", "Aafrika" },
            { "003", "Põhja-Ameerika" },
            { "005", "Lõuna-Ameerika" },
            { "009", "Okeaania" },
            { "011", "Lääne-Aafrika" },
            { "013", "Kesk-Ameerika" },
            { "014", "Ida-Aafrika" },
            { "015", "Põhja-Aafrika" },
            { "017", "Kesk-Aafrika" },
            { "018", "Lõuna-Aafrika" },
            { "019", "Ameerika" },
            { "021", "Ameerika põhjaosa" },
            { "029", "Kariibi piirkond" },
            { "030", "Ida-Aasia" },
            { "034", "Lõuna-Aasia" },
            { "035", "Kagu-Aasia" },
            { "039", "Lõuna-Euroopa" },
            { "053", "Australaasia" },
            { "054", "Melaneesia" },
            { "057", "Mikroneesia (piirkond)" },
            { "061", "Polüneesia" },
            { "142", "Aasia" },
            { "143", "Kesk-Aasia" },
            { "145", "Lääne-Aasia" },
            { "150", "Euroopa" },
            { "151", "Ida-Euroopa" },
            { "154", "Põhja-Euroopa" },
            { "155", "Lääne-Euroopa" },
            { "202", "Sahara-tagune Aafrika" },
            { "419", "Ladina-Ameerika" },
            { "AC", "Ascensioni saar" },
            { "AD", "Andorra" },
            { "AE", "Araabia Ühendemiraadid" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albaania" },
            { "AM", "Armeenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Ameerika Samoa" },
            { "AT", "Austria" },
            { "AU", "Austraalia" },
            { "AW", "Aruba" },
            { "AX", "Ahvenamaa" },
            { "AZ", "Aserbaidžaan" },
            { "BA", "Bosnia ja Hertsegoviina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Boliivia" },
            { "BQ", "Kariibi Madalmaad" },
            { "BR", "Brasiilia" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet’ saar" },
            { "BW", "Botswana" },
            { "BY", "Valgevene" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kookossaared" },
            { "CD", "Kongo DV" },
            { "CF", "Kesk-Aafrika Vabariik" },
            { "CG", "Kongo Vabariik" },
            { "CH", "Šveits" },
            { "CI", "Elevandiluurannik" },
            { "CK", "Cooki saared" },
            { "CL", "Tšiili" },
            { "CM", "Kamerun" },
            { "CN", "Hiina" },
            { "CO", "Colombia" },
            { "CP", "Clippertoni saar" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Roheneemesaared" },
            { "CW", "Curaçao" },
            { "CX", "Jõulusaar" },
            { "CY", "Küpros" },
            { "CZ", "Tšehhi" },
            { "DE", "Saksamaa" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Taani" },
            { "DM", "Dominica" },
            { "DO", "Dominikaani Vabariik" },
            { "DZ", "Alžeeria" },
            { "EA", "Ceuta ja Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Eesti" },
            { "EG", "Egiptus" },
            { "EH", "Lääne-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Hispaania" },
            { "ET", "Etioopia" },
            { "EU", "Euroopa Liit" },
            { "EZ", "euroala" },
            { "FI", "Soome" },
            { "FJ", "Fidži" },
            { "FK", "Falklandi saared" },
            { "FM", "Mikroneesia" },
            { "FO", "Fääri saared" },
            { "FR", "Prantsusmaa" },
            { "GA", "Gabon" },
            { "GB", "Ühendkuningriik" },
            { "GD", "Grenada" },
            { "GE", "Gruusia" },
            { "GF", "Prantsuse Guajaana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gröönimaa" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatoriaal-Guinea" },
            { "GR", "Kreeka" },
            { "GS", "Lõuna-Georgia ja Lõuna-Sandwichi saared" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkongi erihalduspiirkond" },
            { "HM", "Heardi ja McDonaldi saared" },
            { "HN", "Honduras" },
            { "HR", "Horvaatia" },
            { "HT", "Haiti" },
            { "HU", "Ungari" },
            { "IC", "Kanaari saared" },
            { "ID", "Indoneesia" },
            { "IE", "Iirimaa" },
            { "IL", "Iisrael" },
            { "IM", "Mani saar" },
            { "IN", "India" },
            { "IO", "Briti India ookeani ala" },
            { "IQ", "Iraak" },
            { "IR", "Iraan" },
            { "IS", "Island" },
            { "IT", "Itaalia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordaania" },
            { "JP", "Jaapan" },
            { "KE", "Keenia" },
            { "KG", "Kõrgõzstan" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komoorid" },
            { "KN", "Saint Kitts ja Nevis" },
            { "KP", "Põhja-Korea" },
            { "KR", "Lõuna-Korea" },
            { "KW", "Kuveit" },
            { "KY", "Kaimanisaared" },
            { "KZ", "Kasahstan" },
            { "LA", "Laos" },
            { "LB", "Liibanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libeeria" },
            { "LS", "Lesotho" },
            { "LT", "Leedu" },
            { "LU", "Luksemburg" },
            { "LV", "Läti" },
            { "LY", "Liibüa" },
            { "MA", "Maroko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalli Saared" },
            { "MK", "Põhja-Makedoonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongoolia" },
            { "MO", "Macau erihalduspiirkond" },
            { "MP", "Põhja-Mariaanid" },
            { "MQ", "Martinique" },
            { "MR", "Mauritaania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiivid" },
            { "MW", "Malawi" },
            { "MX", "Mehhiko" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambiik" },
            { "NA", "Namiibia" },
            { "NC", "Uus-Kaledoonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeeria" },
            { "NI", "Nicaragua" },
            { "NL", "Holland" },
            { "NO", "Norra" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Uus-Meremaa" },
            { "OM", "Omaan" },
            { "PA", "Panama" },
            { "PE", "Peruu" },
            { "PF", "Prantsuse Polüneesia" },
            { "PG", "Paapua Uus-Guinea" },
            { "PH", "Filipiinid" },
            { "PK", "Pakistan" },
            { "PL", "Poola" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairni saared" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiina alad" },
            { "PT", "Portugal" },
            { "PW", "Belau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Okeaania hajasaared" },
            { "RE", "Réunion" },
            { "RO", "Rumeenia" },
            { "RS", "Serbia" },
            { "RU", "Venemaa" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Araabia" },
            { "SB", "Saalomoni Saared" },
            { "SC", "Seišellid" },
            { "SD", "Sudaan" },
            { "SE", "Rootsi" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "SI", "Sloveenia" },
            { "SJ", "Svalbard ja Jan Mayen" },
            { "SK", "Slovakkia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somaalia" },
            { "SR", "Suriname" },
            { "SS", "Lõuna-Sudaan" },
            { "ST", "São Tomé ja Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Süüria" },
            { "SZ", "Svaasimaa" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks ja Caicos" },
            { "TD", "Tšaad" },
            { "TF", "Prantsuse Lõunaalad" },
            { "TG", "Togo" },
            { "TH", "Tai" },
            { "TJ", "Tadžikistan" },
            { "TK", "Tokelau" },
            { "TL", "Ida-Timor" },
            { "TM", "Türkmenistan" },
            { "TN", "Tuneesia" },
            { "TO", "Tonga" },
            { "TR", "Türgi" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansaania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Ühendriikide hajasaared" },
            { "UN", "Ühinenud Rahvaste Organisatsioon" },
            { "US", "Ameerika Ühendriigid" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Saint Vincent ja Grenadiinid" },
            { "VE", "Venezuela" },
            { "VG", "Briti Neitsisaared" },
            { "VI", "USA Neitsisaared" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ja Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-aktsent" },
            { "XB", "pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Jeemen" },
            { "YT", "Mayotte" },
            { "ZA", "Lõuna-Aafrika Vabariik" },
            { "ZM", "Sambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tundmatu piirkond" },
            { "aa", "afari" },
            { "ab", "abhaasi" },
            { "ae", metaValue_ae },
            { "af", "afrikaani" },
            { "ak", "akani" },
            { "am", "amhara" },
            { "an", "aragoni" },
            { "ar", metaValue_ar },
            { "as", "assami" },
            { "av", "avaari" },
            { "ay", "aimara" },
            { "az", "aserbaidžaani" },
            { "ba", "baškiiri" },
            { "be", "valgevene" },
            { "bg", "bulgaaria" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretooni" },
            { "bs", "bosnia" },
            { "ca", "katalaani" },
            { "ce", "tšetšeeni" },
            { "ch", "tšamorro" },
            { "co", "korsika" },
            { "cr", "krii" },
            { "cs", "tšehhi" },
            { "cu", "kirikuslaavi" },
            { "cv", "tšuvaši" },
            { "cy", "kõmri" },
            { "da", "taani" },
            { "de", "saksa" },
            { "dv", "maldiivi" },
            { "dz", "dzongkha" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "inglise" },
            { "eo", "esperanto" },
            { "es", "hispaania" },
            { "et", "eesti" },
            { "eu", "baski" },
            { "fa", "pärsia" },
            { "ff", "fula" },
            { "fi", "soome" },
            { "fj", "fidži" },
            { "fo", "fääri" },
            { "fr", "prantsuse" },
            { "fy", "läänefriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "gl", "galeegi" },
            { "gn", "guaranii" },
            { "gu", metaValue_gu },
            { "gv", "mänksi" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "horvaadi" },
            { "ht", "haiti" },
            { "hu", "ungari" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indoneesia" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "nuosu" },
            { "ik", "injupiaki" },
            { "io", "ido" },
            { "is", "islandi" },
            { "it", "itaalia" },
            { "iu", "inuktituti" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kvanjama" },
            { "kk", "kasahhi" },
            { "kl", "grööni" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kašmiiri" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "la", metaValue_la },
            { "lb", "letseburgi" },
            { "lg", "ganda" },
            { "li", "limburgi" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "leedu" },
            { "lu", "Katanga luba" },
            { "lv", "läti" },
            { "mg", "malagassi" },
            { "mh", "maršalli" },
            { "mi", "maoori" },
            { "mk", "makedoonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malai" },
            { "mt", "malta" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "norra bokmål" },
            { "nd", "põhjandebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "nl", "hollandi" },
            { "nn", "uusnorra" },
            { "no", "norra" },
            { "nr", "lõunandebele" },
            { "nv", "navaho" },
            { "ny", "njandža" },
            { "oc", "oksitaani" },
            { "oj", "odžibvei" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osseedi" },
            { "pa", "pandžabi" },
            { "pi", "paali" },
            { "pl", "poola" },
            { "ps", "puštu" },
            { "pt", "portugali" },
            { "qu", "ketšua" },
            { "rm", "romanši" },
            { "rn", "rundi" },
            { "ro", "rumeenia" },
            { "ru", "vene" },
            { "rw", "ruanda" },
            { "sa", "sanskriti" },
            { "sc", "sardi" },
            { "sd", "sindhi" },
            { "se", "põhjasaami" },
            { "sg", "sango" },
            { "sh", "serbia-horvaadi" },
            { "si", metaValue_si },
            { "sk", "slovaki" },
            { "sl", "sloveeni" },
            { "sm", "samoa" },
            { "sn", "šona" },
            { "so", "somaali" },
            { "sq", "albaania" },
            { "sr", "serbia" },
            { "ss", "svaasi" },
            { "st", "lõunasotho" },
            { "su", metaValue_su },
            { "sv", "rootsi" },
            { "sw", "suahiili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadžiki" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "türkmeeni" },
            { "tl", metaValue_tl },
            { "tn", "tsvana" },
            { "to", "tonga" },
            { "tr", "türgi" },
            { "ts", "tsonga" },
            { "tt", "tatari" },
            { "tw", "tvii" },
            { "ty", "tahiti" },
            { "ug", "uiguuri" },
            { "uk", "ukraina" },
            { "ur", "urdu" },
            { "uz", "usbeki" },
            { "ve", "venda" },
            { "vi", "vietnami" },
            { "vo", "volapüki" },
            { "wa", "vallooni" },
            { "wo", "volofi" },
            { "xh", "koosa" },
            { "yi", "jidiši" },
            { "yo", "joruba" },
            { "za", "tšuangi" },
            { "zh", "hiina" },
            { "zu", "suulu" },
            { "ace", "atšehi" },
            { "ach", "atšoli" },
            { "ada", "adangme" },
            { "ady", "adõgee" },
            { "aeb", "Tuneesia araabia" },
            { "afh", "afrihili" },
            { "agq", "aghemi" },
            { "ain", "ainu" },
            { "akk", "akadi" },
            { "akz", "alabama" },
            { "ale", "aleuudi" },
            { "aln", "geegi" },
            { "alt", "altai" },
            { "ang", "vanainglise" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "Levandi araabia" },
            { "arc", "aramea" },
            { "arn", "mapudunguni" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "Alžeeria araabia" },
            { "ars", "Najdi araabia" },
            { "arw", "aravaki" },
            { "ary", "Maroko araabia" },
            { "arz", "Egiptuse araabia" },
            { "asa", "asu" },
            { "ase", "Ameerika viipekeel" },
            { "ast", "astuuria" },
            { "atj", "atikameki" },
            { "awa", "avadhi" },
            { "bal", "belutši" },
            { "ban", metaValue_ban },
            { "bar", "baieri" },
            { "bas", "basaa" },
            { "bax", "bamuni" },
            { "bbc", metaValue_bbc },
            { "bbj", "ghomala" },
            { "bej", "bedža" },
            { "bem", "bemba" },
            { "bew", "betavi" },
            { "bez", "bena" },
            { "bfd", "bafuti" },
            { "bfq", "badaga" },
            { "bgc", "harjaanvi" },
            { "bgn", "läänebelutši" },
            { "bho", "bhodžpuri" },
            { "bik", "bikoli" },
            { "bin", "edo" },
            { "bjn", "bandžari" },
            { "bkm", "komi (Aafrika)" },
            { "bla", "mustjalaindiaani" },
            { "blo", "anii" },
            { "blt", "tai-dami" },
            { "bpy", "bišnuprija" },
            { "bqi", "bahtiari" },
            { "bra", "bradži" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "burjaadi" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "bilini" },
            { "byv", "medumba" },
            { "cad", "kado" },
            { "car", "kariibi" },
            { "cay", "kajuka" },
            { "cch", "aitšami" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebu" },
            { "cgg", "tšiga" },
            { "chb", "tšibtša" },
            { "chg", "tšagatai" },
            { "chk", "tšuugi" },
            { "chm", "mari" },
            { "chn", "tšinuki žargoon" },
            { "cho", "tšokto" },
            { "chp", "tšipevai" },
            { "chr", metaValue_chr },
            { "chy", "šaieeni" },
            { "cic", "tšikasoo" },
            { "ckb", "sorani" },
            { "clc", "tšilkotini" },
            { "cop", metaValue_cop },
            { "cps", "kapisnoni" },
            { "crg", "michifi" },
            { "crh", "krimmitatari" },
            { "crj", "lõuna-idakrii" },
            { "crk", "tasandikukrii" },
            { "crl", "põhja-idakrii" },
            { "crm", "põdrakrii" },
            { "crr", "Carolina algonkini" },
            { "crs", "seišelli" },
            { "csb", "kašuubi" },
            { "csw", "sookrii" },
            { "dak", "siuu" },
            { "dar", "dargi" },
            { "dav", "davida" },
            { "del", "delavari" },
            { "den", "sleivi" },
            { "dgr", "dogribi" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "alamsorbi" },
            { "dtp", "keskdusuni" },
            { "dua", "duala" },
            { "dum", "keskhollandi" },
            { "dyo", "fonji" },
            { "dyu", "djula" },
            { "dzg", "daza" },
            { "ebu", "embu" },
            { "efi", "efiki" },
            { "egl", "emiilia" },
            { "egy", "egiptuse" },
            { "eka", "ekadžuki" },
            { "elx", "eelami" },
            { "enm", "keskinglise" },
            { "esu", "keskjupiki" },
            { "ewo", "evondo" },
            { "ext", "estremenju" },
            { "fan", "fangi" },
            { "fat", "fanti" },
            { "fil", "filipiini" },
            { "fit", "meä" },
            { "fon", "foni" },
            { "frc", "cajun’i" },
            { "frm", "keskprantsuse" },
            { "fro", "vanaprantsuse" },
            { "frp", "frankoprovansi" },
            { "frr", "põhjafriisi" },
            { "frs", "idafriisi" },
            { "fur", "friuuli" },
            { "gag", "gagauusi" },
            { "gan", "kani" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gez", metaValue_gez },
            { "gil", "kiribati" },
            { "glk", "gilaki" },
            { "gmh", "keskülemsaksa" },
            { "goh", "vanaülemsaksa" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "vanakreeka" },
            { "gsw", "šveitsisaksa" },
            { "guc", "vajuu" },
            { "gur", "farefare" },
            { "guz", "gusii" },
            { "gwi", "gvitšini" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "havai" },
            { "hax", "lõunahaida" },
            { "hif", "Fidži hindi" },
            { "hil", "hiligainoni" },
            { "hit", "heti" },
            { "hmn", "hmongi" },
            { "hsb", "ülemsorbi" },
            { "hsn", "sjangi" },
            { "hup", "hupa" },
            { "hur", "halkomelemi" },
            { "iba", "ibani" },
            { "ibb", "ibibio" },
            { "ikt", "Lääne-Kanada inuktituti" },
            { "ilo", "iloko" },
            { "inh", "inguši" },
            { "izh", "isuri" },
            { "jam", "Jamaica kreoolkeel" },
            { "jbo", "ložban" },
            { "jgo", "ngomba" },
            { "jmc", "matšame" },
            { "jpr", "juudipärsia" },
            { "jrb", "juudiaraabia" },
            { "jut", "jüüti" },
            { "kaa", "karakalpaki" },
            { "kab", "kabiili" },
            { "kac", "katšini" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", metaValue_kaw },
            { "kbd", "kabardi-tšerkessi" },
            { "kbl", "kanembu" },
            { "kcg", "tjapi" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingangi" },
            { "kha", "khasi" },
            { "kho", "saka" },
            { "khq", "koyra chiini" },
            { "khw", "khovari" },
            { "kiu", "kõrmandžki" },
            { "kkj", "kako" },
            { "kln", "kalendžini" },
            { "kmb", "mbundu" },
            { "koi", "permikomi" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", metaValue_kpe },
            { "krc", "karatšai-balkaari" },
            { "kri", "krio" },
            { "krj", "kinaraia" },
            { "krl", "karjala" },
            { "kru", "kuruhhi" },
            { "ksb", "šambala" },
            { "ksf", "bafia" },
            { "ksh", "kölni" },
            { "kum", "kumõki" },
            { "kut", "kutenai" },
            { "kwk", "kvakvala" },
            { "kxv", "kuvi" },
            { "lad", "ladiino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lesgi" },
            { "lij", "liguuri" },
            { "lil", "lillueti" },
            { "liv", "liivi" },
            { "lkt", "lakota" },
            { "lld", "ladiini" },
            { "lmo", "lombardi" },
            { "lol", "mongo" },
            { "lou", "Louisiana kreoolkeel" },
            { "loz", "lozi" },
            { "lrc", "põhjaluri" },
            { "lsm", "samia" },
            { "ltg", "latgali" },
            { "lua", "lulua" },
            { "lui", "luisenjo" },
            { "lun", "lunda" },
            { "lus", "lušei" },
            { "luy", "luhja" },
            { "lzh", "klassikaline hiina" },
            { "lzz", "lazi" },
            { "mad", "madura" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "man", "malinke" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "mokša" },
            { "mdr", "mandari" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "Mauritiuse kreoolkeel" },
            { "mga", "keskiiri" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta" },
            { "mhn", "mohheni" },
            { "mic", "mikmaki" },
            { "min", "minangkabau" },
            { "mnc", "mandžu" },
            { "mni", "manipuri" },
            { "moe", "innu" },
            { "moh", "mohoogi" },
            { "mos", "more" },
            { "mrj", "mäemari" },
            { "mua", "mundangi" },
            { "mul", "mitu keelt" },
            { "mus", "maskogi" },
            { "mwl", "miranda" },
            { "mwr", "marvari" },
            { "mwv", "mentavei" },
            { "mye", "mjene" },
            { "myv", "ersa" },
            { "mzn", "mazandaraani" },
            { "nan", "lõunamini" },
            { "nap", "napoli" },
            { "naq", "nama" },
            { "nds", "alamsaksa" },
            { "new", metaValue_new },
            { "nia", "niasi" },
            { "niu", "niue" },
            { "njo", "ao" },
            { "nmg", "kwasio" },
            { "nnh", "ngiembooni" },
            { "nog", "nogai" },
            { "non", "vanapõhja" },
            { "nov", "noviaal" },
            { "nqo", metaValue_nqo },
            { "nso", "põhjasotho" },
            { "nus", "nueri" },
            { "nwc", "vananevari" },
            { "nym", "njamvesi" },
            { "nyn", "njankole" },
            { "nyo", "njoro" },
            { "nzi", "nzima" },
            { "ojb", "loodeodžibvei" },
            { "ojc", "keskodžibvei" },
            { "ojs", "Severni odžibvei" },
            { "ojw", "lääneodžibvei" },
            { "oka", "okanagani" },
            { "osa", metaValue_osa },
            { "ota", "osmanitürgi" },
            { "pag", "pangasinani" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "belau" },
            { "pcd", "pikardi" },
            { "pcm", "Nigeeria pidžinkeel" },
            { "pdc", "Pennsylvania saksa" },
            { "pdt", "mennoniidisaksa" },
            { "peo", metaValue_peo },
            { "pfl", "Pfalzi" },
            { "phn", metaValue_phn },
            { "pis", "pijini" },
            { "pms", "piemonte" },
            { "pnt", "pontose" },
            { "pon", "poonpei" },
            { "pqm", "passamakodi" },
            { "prg", "preisi" },
            { "pro", "vanaprovansi" },
            { "quc", "kitše" },
            { "raj", "radžastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romanja" },
            { "rhg", metaValue_rhg },
            { "rif", "riifi" },
            { "rof", "rombo" },
            { "rom", "mustlaskeel" },
            { "rtm", "rotuma" },
            { "rue", "russiini" },
            { "rug", "roviana" },
            { "rup", "aromuuni" },
            { "rwk", "rvaa" },
            { "sad", "sandave" },
            { "sah", "jakuudi" },
            { "sam", "Samaaria aramea" },
            { "saq", "samburu" },
            { "sas", "sasaki" },
            { "sat", metaValue_sat },
            { "saz", metaValue_saz },
            { "sba", "ngambai" },
            { "sbp", "sangu" },
            { "scn", "sitsiilia" },
            { "sco", "šoti" },
            { "sdh", "lõunakurdi" },
            { "see", "seneka" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "sölkupi" },
            { "ses", "koyraboro senni" },
            { "sga", "vanaiiri" },
            { "sgs", "žemaidi" },
            { "shi", "šilha" },
            { "shn", "šani" },
            { "shu", "Tšaadi araabia" },
            { "sid", "sidamo" },
            { "skr", "seraiki" },
            { "slh", "Lõuna-Puget-Soundi sališi" },
            { "sli", "alamsileesia" },
            { "sly", "selajari" },
            { "sma", "lõunasaami" },
            { "smj", "Lule saami" },
            { "smn", "Inari saami" },
            { "sms", "koltasaami" },
            { "snk", "soninke" },
            { "sog", metaValue_sog },
            { "srn", "sranani" },
            { "srr", "sereri" },
            { "ssy", "saho" },
            { "stq", "saterfriisi" },
            { "str", "väinasališi" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeri" },
            { "swb", "komoori" },
            { "syc", "vanasüüria" },
            { "syr", metaValue_syr },
            { "szl", "sileesia" },
            { "tce", "lõunatutšoni" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetumi" },
            { "tgx", "tagishi" },
            { "tht", "tahltani" },
            { "tig", "tigree" },
            { "tiv", "tivi" },
            { "tkl", "tokelau" },
            { "tkr", "tsahhi" },
            { "tlh", "klingoni" },
            { "tli", "tlingiti" },
            { "tly", "talõši" },
            { "tmh", "tamašeki" },
            { "tog", "tšitonga" },
            { "tok", "toki pona" },
            { "tpi", "uusmelaneesia" },
            { "tru", "turojo" },
            { "trv", "taroko" },
            { "trw", "torvali" },
            { "tsd", "tsakoonia" },
            { "tsi", "tsimši" },
            { "ttm", "põhjatutšoni" },
            { "ttt", "lõunataadi" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "taswaqi" },
            { "tyv", "tõva" },
            { "tzm", "tamasikti" },
            { "udm", "udmurdi" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "määramata keel" },
            { "vec", "veneti" },
            { "vep", "vepsa" },
            { "vls", "lääneflaami" },
            { "vmf", "Maini frangi" },
            { "vmw", "makua" },
            { "vot", "vadja" },
            { "vro", "võru" },
            { "vun", "vundžo" },
            { "wae", "valsi" },
            { "wal", "volaita" },
            { "war", "varai" },
            { "was", "vašo" },
            { "wbp", "varlpiri" },
            { "wuu", "uu" },
            { "xal", "kalmõki" },
            { "xmf", "megreli" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "jao" },
            { "yap", "japi" },
            { "yav", "yangbeni" },
            { "ybb", "jemba" },
            { "yrl", "njengatu" },
            { "yue", "kantoni" },
            { "zap", "sapoteegi" },
            { "zbl", metaValue_zbl },
            { "zea", "zeelandi" },
            { "zen", "zenaga" },
            { "zgh", "tamasikti (Maroko)" },
            { "zun", "sunji" },
            { "zxx", "mittekeeleline" },
            { "zza", "zaza" },
            { "Adlm", "adlami" },
            { "Afak", "afaka" },
            { "Aghb", "albaani" },
            { "Ahom", "ahomi" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliik" },
            { "Armi", "vanaaramea" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "bamumi" },
            { "Bass", "bassa" },
            { "Batk", metaValue_bbc },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "braahmi" },
            { "Brai", "punktkiri" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhidi" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Kanada põlisrahvaste ühtlustatud silpkiri" },
            { "Cari", "kaaria" },
            { "Cham", "tšaami" },
            { "Cher", metaValue_chr },
            { "Chrs", "horezmi" },
            { "Cirt", "Cirthi" },
            { "Copt", metaValue_cop },
            { "Cpmn", "Küprose minose" },
            { "Cprt", "Küprose silpkiri" },
            { "Cyrl", "kirillitsa" },
            { "Cyrs", "kürilliline kirikuslaavi" },
            { "Deva", "devanaagari" },
            { "Diak", "divehi" },
            { "Dsrt", "desereti" },
            { "Dupl", "Duployé kiirkiri" },
            { "Egyd", "egiptuse demootiline" },
            { "Egyh", "egiptuse hieraatiline" },
            { "Egyp", "egiptuse hieroglüüfkiri" },
            { "Elba", "Elbasani" },
            { "Elym", "elümi" },
            { "Ethi", metaValue_gez },
            { "Gara", "garai" },
            { "Geok", "hutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagoolitsa" },
            { "Gong", "Gūnjāla gondi" },
            { "Gonm", "Masarami gondi" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanbi" },
            { "Hang", metaValue_ko },
            { "Hani", "hani" },
            { "Hano", "hanunoo" },
            { "Hans", "lihtsustatud" },
            { "Hant", "traditsiooniline" },
            { "Hatr", "Hatra" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "Anatoolia hieroglüüfkiri" },
            { "Hmng", "phahau-hmongi kiri" },
            { "Hrkt", "jaapani silpkirjad" },
            { "Hung", "vanaungari" },
            { "Inds", "Induse" },
            { "Ital", "vanaitali" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "tšurtšeni" },
            { "Kali", "kaja-lii" },
            { "Kana", "katakana" },
            { "Kawi", metaValue_kaw },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "hodžki" },
            { "Kits", "kitani väike kiri" },
            { "Knda", metaValue_kn },
            { "Kore", "korea segakiri" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "tai-thami" },
            { "Laoo", metaValue_lo },
            { "Latf", "ladina fraktuurkiri" },
            { "Latg", "ladina gaeli" },
            { "Latn", metaValue_la },
            { "Lepc", "leptša" },
            { "Limb", "limbu" },
            { "Lina", "lineaarkiri A" },
            { "Linb", "lineaarkiri B" },
            { "Lisu", "lisu" },
            { "Loma", "loma" },
            { "Lyci", "lüükia" },
            { "Lydi", "lüüdia" },
            { "Mahj", "mahaadžani" },
            { "Maka", metaValue_mak },
            { "Mand", "mandea" },
            { "Mani", "mani" },
            { "Maya", "maaja hieroglüüfkiri" },
            { "Mend", metaValue_men },
            { "Merc", "meroe kursiivkiri" },
            { "Mero", "meroe" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "Mooni" },
            { "Mroo", "mruu" },
            { "Mtei", "meitei" },
            { "Mult", "Multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "Nagi mundari" },
            { "Narb", "Põhja-Araabia" },
            { "Nbat", "Nabatea" },
            { "Newa", metaValue_new },
            { "Nkgb", "nasi" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nüšu" },
            { "Ogam", "ogam" },
            { "Olck", metaValue_sat },
            { "Orkh", "Orhoni" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmani" },
            { "Ougr", "vanauiguuri" },
            { "Palm", "Palmyra" },
            { "Perm", "vanapermi" },
            { "Phag", "phakpa" },
            { "Phli", "pahlavi raidkiri" },
            { "Phlp", "pahlavi psalmikiri" },
            { "Phlv", "pahlavi raamatukiri" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollardi miao" },
            { "Prti", "partia raidkiri" },
            { "Rjng", "redžangi" },
            { "Rohg", metaValue_rhg },
            { "Roro", "rongorongo" },
            { "Runr", "ruunikiri" },
            { "Samr", "Samaaria" },
            { "Sara", "sarati" },
            { "Sarb", "Lõuna-Araabia" },
            { "Saur", metaValue_saz },
            { "Sgnw", "viipekiri" },
            { "Shaw", "Shaw’ kiri" },
            { "Shrd", "šaarada" },
            { "Sidd", "siddhami" },
            { "Sind", "hudavadi" },
            { "Sinh", metaValue_si },
            { "Sogd", metaValue_sog },
            { "Sogo", "vanasogdi" },
            { "Sora", "sora" },
            { "Soyo", "sojombo" },
            { "Sund", metaValue_su },
            { "Sunu", "sunvari" },
            { "Sylo", "siloti" },
            { "Syrc", metaValue_syr },
            { "Syre", "süüria estrangelo" },
            { "Syrj", "läänesüüria" },
            { "Syrn", "idasüüria" },
            { "Tagb", "tagbanva" },
            { "Takr", "taakri" },
            { "Tale", "tai-löö" },
            { "Talu", "uus tai-lõõ" },
            { "Taml", metaValue_ta },
            { "Tang", "tanguudi" },
            { "Tavt", "tai-vieti" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwari" },
            { "Tfng", "tifinagi" },
            { "Tglg", metaValue_tl },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tase" },
            { "Toto", "toto" },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Visp", "nähtava kõne" },
            { "Vith", "Vithkuqi" },
            { "Wara", "hoo" },
            { "Wcho", "vantšo" },
            { "Wole", "voleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumeri-akadi kiilkiri" },
            { "Yezi", "jeziidi" },
            { "Yiii", "jii" },
            { "Zanb", "Dzanabadzari ruutkiri" },
            { "Zinh", "päritud" },
            { "Zmth", "matemaatiline tähistus" },
            { "Zsye", "emoji" },
            { "Zsym", "sümbolid" },
            { "Zxxx", "kirjakeeleta" },
            { "Zyyy", "üldine" },
            { "Zzzz", "määramata kiri" },
            { "de_AT", "Austria saksa" },
            { "de_CH", "Šveitsi ülemsaksa" },
            { "en_AU", "Austraalia inglise" },
            { "en_CA", "Kanada inglise" },
            { "en_GB", "Briti inglise" },
            { "en_US", "Ameerika inglise" },
            { "es_ES", "Euroopa hispaania" },
            { "es_MX", "Mehhiko hispaania" },
            { "fa_AF", "dari" },
            { "fr_CA", "Kanada prantsuse" },
            { "fr_CH", "Šveitsi prantsuse" },
            { "nl_BE", "flaami" },
            { "pt_BR", "Brasiilia portugali" },
            { "pt_PT", "Euroopa portugali" },
            { "ro_MD", "moldova" },
            { "sw_CD", "Kongo suahiili" },
            { "%%1901", "saksa traditsiooniline kirjaviis" },
            { "%%1994", "normitud Resia kirjaviis" },
            { "%%1996", "saksa reformitud kirjaviis" },
            { "ar_001", "tänapäeva araabia kirjakeel" },
            { "es_419", "Ladina-Ameerika hispaania" },
            { "key.ca", "kalender" },
            { "key.cf", "rahavorming" },
            { "key.co", "järjestus" },
            { "key.cu", "vääring" },
            { "key.hc", "12 või 24 tunni süsteem" },
            { "key.lb", "reavahetuse laad" },
            { "key.ms", "mõõdustik" },
            { "key.nu", "numbrid" },
            { "key.tz", "ajavöönd" },
            { "key.va", "lokaadi variant" },
            { "nds_NL", "Hollandi alamsaksa" },
            { "%%BISKE", "San Giorgio/Bila murre" },
            { "%%BOONT", "boontlingi" },
            { "%%KKCOR", "üldlevinud kirjaviis" },
            { "%%KSCOR", "normitud kirjaviis" },
            { "%%LIPAW", "Resia Lipovaz’i murre" },
            { "%%NEDIS", "Natisone murre" },
            { "%%NJIVA", "Gniva/Njiva murre" },
            { "%%OSOJS", "Oseacco/Osojane murre" },
            { "%%POSIX", "arvuti" },
            { "%%ROZAJ", "Resia murre" },
            { "%%SAAHO", "saho murre" },
            { "%%SOLBA", "Stolvizza/Solbica murre" },
            { "%%UCCOR", "ühtlustatud ortograafia" },
            { "zh_Hans", "lihtsustatud hiina" },
            { "zh_Hant", "traditsiooniline hiina" },
            { "%%EKAVSK", "štokavi e-line murrak" },
            { "%%FONIPA", "IPA foneetika" },
            { "%%FONUPA", "UPA foneetika" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "Taraskievica ortograafia" },
            { "%%UCRCOR", "ühtlustatud redigeeritud ortograafia" },
            { "%%ALALC97", "ALA-LC latinisatsioon (1997)" },
            { "%%AREVELA", "idaarmeenia" },
            { "%%AREVMDA", "läänearmeenia" },
            { "%%HEPBURN", "Hepburni latinisatsioon" },
            { "%%MONOTON", "monotoonne" },
            { "%%POLYTON", "polütooniline" },
            { "%%REVISED", "uus kirjaviis" },
            { "%%1606NICT", "hiliskeskprantsuse (kuni 1606)" },
            { "%%1694ACAD", "varajane moodne prantsuse" },
            { "%%1959ACAD", "akadeemiline" },
            { "%%BAKU1926", "ühtlustatud türgi-ladina tähestik" },
            { "%%IJEKAVSK", "štokavi ije-line murrak" },
            { "%%SCOTLAND", "šoti tavainglise" },
            { "%%VALENCIA", "valentsia" },
            { "%%WADEGILE", "Wade’i-Gilesi latinisatsioon" },
            { "type.ca.roc", "Hiina Vabariigi kalender" },
            { "type.co.eor", "Euroopa järjestusreeglid" },
            { "type.hc.h11", "12-tunnine süsteem (0–11)" },
            { "type.hc.h12", "12-tunnine süsteem (1–12)" },
            { "type.hc.h23", "24-tunnine süsteem (0–23)" },
            { "type.hc.h24", "24-tunnine süsteem (1–24)" },
            { "type.m0.bgn", "transkriptsioon (BGN)" },
            { "type.nu.ahom", "ahomi numbrid" },
            { "type.nu.arab", "idaaraabia numbrid" },
            { "type.nu.armn", "armeenia numbrid" },
            { "type.nu.bali", "bali numbrid" },
            { "type.nu.beng", "bengali numbrid" },
            { "type.nu.brah", "braahmi numbrid" },
            { "type.nu.cakm", "tšaakma numbrid" },
            { "type.nu.cham", "tšaami numbrid" },
            { "type.nu.cyrl", "kirillitsa numbrid" },
            { "type.nu.deva", "devanaagari numbrid" },
            { "type.nu.diak", "divehi numbrid" },
            { "type.nu.ethi", "etioopia numbrid" },
            { "type.nu.geor", "gruusia numbrid" },
            { "type.nu.gong", "Gūnjāla gondi numbrid" },
            { "type.nu.gonm", "Masarami gondi numbrid" },
            { "type.nu.grek", "kreeka numbrid" },
            { "type.nu.gujr", "gudžarati numbrid" },
            { "type.nu.guru", "gurmukhi numbrid" },
            { "type.nu.hans", "lihtsustatud hiina keele numbrid" },
            { "type.nu.hant", "traditsioonilise hiina keele numbrid" },
            { "type.nu.hebr", "heebrea numbrid" },
            { "type.nu.hmng", "phahau-hmongi numbrid" },
            { "type.nu.java", "jaava numbrid" },
            { "type.nu.jpan", "jaapani numbrid" },
            { "type.nu.kali", "kaja-lii numbrid" },
            { "type.nu.kawi", "kaavi numbrid" },
            { "type.nu.khmr", "khmeeri numbrid" },
            { "type.nu.knda", "kannada numbrid" },
            { "type.nu.lana", "tai tham hora numbrid" },
            { "type.nu.laoo", "lao numbrid" },
            { "type.nu.latn", "araabia numbrid" },
            { "type.nu.lepc", "leptša numbrid" },
            { "type.nu.limb", "limbu numbrid" },
            { "type.nu.mlym", "malajalami numbrid" },
            { "type.nu.modi", "modi numbrid" },
            { "type.nu.mong", "mongoli numbrid" },
            { "type.nu.mroo", "mruu numbrid" },
            { "type.nu.mtei", "meitei numbrid" },
            { "type.nu.mymr", "birma numbrid" },
            { "type.nu.nagm", "Nagi mundari numbrid" },
            { "type.nu.nkoo", "nkoo numbrid" },
            { "type.nu.olck", "santali numbrid" },
            { "type.nu.orya", "oria numbrid" },
            { "type.nu.osma", "osmani numbrid" },
            { "type.nu.rohg", "rohingja numbrid" },
            { "type.nu.saur", "sauraštra numbrid" },
            { "type.nu.shrd", "šaarada numbrid" },
            { "type.nu.sind", "hudavadi numbrid" },
            { "type.nu.sinh", "sinhala lithi numbrid" },
            { "type.nu.sora", "sora numbrid" },
            { "type.nu.sund", "sunda numbrid" },
            { "type.nu.takr", "taakri numbrid" },
            { "type.nu.talu", "uue tai-lõõ numbrid" },
            { "type.nu.taml", "traditsioonilised tamili numbrid" },
            { "type.nu.telu", "telugu numbrid" },
            { "type.nu.thai", "tai numbrid" },
            { "type.nu.tibt", "tiibeti numbrid" },
            { "type.nu.tirh", "tirhuta numbrid" },
            { "type.nu.tnsa", "tase numbrid" },
            { "type.nu.vaii", "vai numbrid" },
            { "type.nu.wara", "hoo numbrid" },
            { "type.nu.wcho", "vantšo numbrid" },
            { "type.ca.dangi", "dangi kalender" },
            { "type.co.ducet", "Unicode’i vaikejärjestus" },
            { "type.co.emoji", "emoji sortimisjärjestus" },
            { "type.lb.loose", "paindlik reavahetuse laad" },
            { "type.nu.roman", "Rooma numbrid" },
            { "type.ca.coptic", "kopti kalender" },
            { "type.ca.hebrew", "juudi kalender" },
            { "type.ca.indian", "India rahvuslik kalender" },
            { "type.co.compat", "varasem sortimisjärjestus (ühilduvuse jaoks)" },
            { "type.co.pinyin", "pinyin’i sortimisjärjestus" },
            { "type.co.search", "üldeesmärgiline otsing" },
            { "type.co.stroke", "kriipsude sortimisjärjestus" },
            { "type.co.unihan", "võtmete-kriipsude sortimisjärjestus" },
            { "type.co.zhuyin", "zhuyin’i sortimisjärjestus" },
            { "type.d0.fwidth", "täislaius" },
            { "type.d0.hwidth", "poollaius" },
            { "type.lb.normal", "harilik reavahetuse laad" },
            { "type.lb.strict", "jäik reavahetuse laad" },
            { "type.m0.ungegn", "transkriptsioon (UNGEGN)" },
            { "type.ms.metric", "meetermõõdustik" },
            { "type.nu.native", "kohalikud numbrid" },
            { "type.ca.chinese", "Hiina kalender" },
            { "type.ca.islamic", "hidžra kalender" },
            { "type.ca.iso8601", "ISO-8601 kalender" },
            { "type.ca.persian", "Pärsia kalender" },
            { "type.cf.account", "arvelduse rahavorming" },
            { "type.co.big5han", "hiina traditsiooniline sortimisjärjestus (Big5)" },
            { "type.d0.npinyin", "Numbriline" },
            { "type.nu.arabext", "laiendatud idaaraabia numbrid" },
            { "type.nu.armnlow", "väiketähelised armeenia numbrid" },
            { "type.nu.finance", "finantsnumbrid" },
            { "type.nu.greklow", "väiketähelised kreeka numbrid" },
            { "type.nu.hanidec", "hiina kümnendnumbrid" },
            { "type.nu.hansfin", "lihtsustatud hiina keele finantsnumbrid" },
            { "type.nu.hantfin", "traditsioonilise hiina keele finantsnumbrid" },
            { "type.nu.jpanfin", "jaapani finantsnumbrid" },
            { "type.nu.tamldec", "tamili numbrid" },
            { "type.ca.buddhist", "budistlik kalender" },
            { "type.ca.ethiopic", "Etioopia kalender" },
            { "type.ca.japanese", "Jaapani kalender" },
            { "type.cf.standard", "standardne rahavorming" },
            { "type.co.phonetic", "foneetiline sortimisjärjestus" },
            { "type.co.searchjl", "otsing korea alguskonsonandi järgi" },
            { "type.co.standard", "standardne järjestus" },
            { "type.ms.uksystem", "inglise mõõdustik" },
            { "type.ms.ussystem", "USA mõõdustik" },
            { "type.nu.fullwide", "täislaiusega numbrid" },
            { "type.nu.lanatham", "tai tham tham numbrid" },
            { "type.nu.mymrshan", "myanmari shan numbrid" },
            { "type.nu.mymrtlng", "myanmari tai laing numbrid" },
            { "type.nu.romanlow", "väiketähelised Rooma numbrid" },
            { "type.ca.gregorian", "Gregoriuse kalender" },
            { "type.co.gb2312han", "hiina lihtsustatud sortimisjärjestus (GB2312)" },
            { "type.co.phonebook", "telefoniraamatu sortimisjärjestus" },
            { "type.co.dictionary", "sõnastiku sortimisjärjestus" },
            { "type.co.traditional", "traditsiooniline sortimisjärjestus" },
            { "type.nu.traditional", "traditsioonilised numbrid" },
            { "type.ca.islamic-rgsa", "hidžra kalender (Saudi Araabia, vaatluspõhine)" },
            { "type.ca.islamic-tbla", "hidžra kalender (tabelkalender, astronoomiline ajastu)" },
            { "type.ca.islamic-civil", "hidžra kalender (tabelkalender, ilmalik)" },
            { "type.ca.islamic-umalqura", "hidžra kalender (Umm al-Qurá)" },
            { "type.ca.ethiopic-amete-alem", "Etioopia amete alemi kalender" },
        };
        return data;
    }
}
