/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Horário do Meridiano de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Horário Padrão do Acre",
               "ACT",
               "Horário de Verão do Acre",
               "ACST",
               "Horário do Acre",
               "ACT",
            };
        final String[] Apia = new String[] {
               "Horário Padrão de Apia",
               "",
               "Horário de Verão de Apia",
               "",
               "Horário de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Horário Padrão das Ilhas Cook",
               "",
               "Meio Horário de Verão das Ilhas Cook",
               "",
               "Horário das Ilhas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Horário Padrão de Cuba",
               "CST",
               "Horário de Verão de Cuba",
               "CDT",
               "Horário de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Horário Padrão de Fiji",
               "",
               "Horário de Verão de Fiji",
               "",
               "Horário de Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Horário do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Horário Padrão de Hovd",
               "",
               "Horário de Verão de Hovd",
               "",
               "Horário de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Horário Padrão do Irã",
               "",
               "Horário de Verão do Irã",
               "",
               "Horário do Irã",
               "",
            };
        final String[] Niue = new String[] {
               "Horário de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Horário Padrão de Omsk",
               "",
               "Horário de Verão de Omsk",
               "",
               "Horário de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Horário Padrão do Peru",
               "",
               "Horário de Verão do Peru",
               "",
               "Horário do Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Horário de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Horário das Ilhas Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Horário Padrão do Chile",
               "",
               "Horário de Verão do Chile",
               "",
               "Horário do Chile",
               "",
            };
        final String[] China = new String[] {
               "Horário Padrão da China",
               "CST",
               "Horário de Verão da China",
               "CDT",
               "Horário da China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Horário das Ilhas Coco",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Horário de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Horário Padrão da Índia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Horário Padrão do Japão",
               "JST",
               "Horário de Verão do Japão",
               "JDT",
               "Horário do Japão",
               "JT",
            };
        final String[] Korea = new String[] {
               "Horário Padrão da Coreia",
               "KST",
               "Horário de Verão da Coreia",
               "KST",
               "Horário da Coreia",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Horário de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Horário do Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Horário de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Horário Padrão de Samoa",
               "SST",
               "Horário de Verão de Samoa",
               "SST",
               "Horário de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Horário de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Horário Padrão de Tonga",
               "",
               "Horário de Verão de Tonga",
               "",
               "Horário de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Horário do Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Horário Padrão do Alasca",
               "AKST",
               "Horário de Verão do Alasca",
               "AKDT",
               "Horário do Alasca",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Horário Padrão do Amazonas",
               "AMT",
               "Horário de Verão do Amazonas",
               "AMST",
               "Horário do Amazonas",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "Horário Padrão do Anadyr",
               "",
               "Horário de Verão do Anadyr",
               "",
               "Horário de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Horário Padrão dos Açores",
               "",
               "Horário de Verão dos Açores",
               "",
               "Horário dos Açores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Horário do Butão",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Horário de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Horário Padrão da Ilha de Páscoa",
               "",
               "Horário de Verão da Ilha de Páscoa",
               "",
               "Horário da Ilha de Páscoa",
               "",
            };
        final String[] Guyana = new String[] {
               "Horário da Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Horário Padrão de Israel",
               "IST",
               "Horário de Verão de Israel",
               "IDT",
               "Horário de Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Horário de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Horário de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Horário Padrão de Moscou",
               "MSK",
               "Horário de Verão de Moscou",
               "MSK",
               "Horário de Moscou",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Horário de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Horário Padrão de Samara",
               "",
               "Horário de Verão de Samara",
               "",
               "Horário de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Horário do Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Horário Padrão de Taipei",
               "CST",
               "Horário de Verão de Taipei",
               "CDT",
               "Horário de Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Horário de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Horário de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Horário de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Horário Padrão da Arábia",
               "",
               "Horário de Verão da Arábia",
               "",
               "Horário da Arábia",
               "",
            };
        final String[] Armenia = new String[] {
               "Horário Padrão da Armênia",
               "",
               "Horário de Verão da Armênia",
               "",
               "Horário da Armênia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Horário da Bolívia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Horário Padrão de Chatham",
               "",
               "Horário de Verão de Chatham",
               "",
               "Horário de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Horário Universal Coordenado",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Horário do Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Horário de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Horário Padrão da Geórgia",
               "",
               "Horário de Verão da Geórgia",
               "",
               "Horário da Geórgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Horário Padrão de Irkutsk",
               "",
               "Horário de Verão de Irkutsk",
               "",
               "Horário de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Horário Padrão de Magadan",
               "",
               "Horário de Verão de Magadan",
               "",
               "Horário de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Horário de Mianmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Horário Padrão da Ilha Norfolk",
               "",
               "Horário de Verão da Ilha Norfolk",
               "",
               "Horário da Ilha Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Horário Padrão de Fernando de Noronha",
               "",
               "Horário de Verão de Fernando de Noronha",
               "",
               "Horário de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Horário de Reunião",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Horário de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Horário das Ilhas Salomão",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Horário de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Horário Padrão do Uruguai",
               "",
               "Horário de Verão do Uruguai",
               "",
               "Horário do Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Horário Padrão de Vanuatu",
               "",
               "Horário de Verão de Vanuatu",
               "",
               "Horário de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Horário Padrão de Yakutsk",
               "",
               "Horário de Verão de Yakutsk",
               "",
               "Horário de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Horário Padrão do Atlântico",
               "AST",
               "Horário de Verão do Atlântico",
               "AST",
               "Horário do Atlântico",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Horário Padrão de Brasília",
               "BRT",
               "Horário de Verão de Brasília",
               "BRST",
               "Horário de Brasília",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "Horário de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Horário Padrão da Colômbia",
               "",
               "Horário de Verão da Colômbia",
               "",
               "Horário da Colômbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Horário Padrão das Ilhas Malvinas",
               "",
               "Horário de Verão das Ilhas Malvinas",
               "",
               "Horário das Ilhas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Horário da Malásia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Horário das Ilhas Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Horário Padrão de Ulan Bator",
               "",
               "Horário de Verão de Ulan Bator",
               "",
               "Horário de Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Horário Padrão do Paquistão",
               "PKT",
               "Horário de Verão do Paquistão",
               "PKST",
               "Horário do Paquistão",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Horário Padrão do Paraguai",
               "",
               "Horário de Verão do Paraguai",
               "",
               "Horário do Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Horário de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Horário Padrão de Sacalina",
               "",
               "Horário de Verão de Sacalina",
               "",
               "Horário de Sacalina",
               "",
            };
        final String[] Suriname = new String[] {
               "Horário do Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Horário Padrão da Argentina",
               "",
               "Horário de Verão da Argentina",
               "",
               "Horário da Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Horário da Ilha Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Horário de Galápagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Horário Padrão de Hong Kong",
               "HKT",
               "Horário de Verão de Hong Kong",
               "HKST",
               "Horário de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Horário da Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Horário Padrão de Petropavlovsk-Kamchatski",
               "",
               "Horário de Verão de Petropavlovsk-Kamchatski",
               "",
               "Horário de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Horário do Quirguistão",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Horário Padrão de Lord Howe",
               "",
               "Horário de Verão de Lord Howe",
               "",
               "Horário de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Horário das Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Horário Padrão de Maurício",
               "",
               "Horário de Verão de Maurício",
               "",
               "Horário de Maurício",
               "",
            };
        final String[] Singapore = new String[] {
               "Horário Padrão de Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Horário da Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Horário Padrão de Volgogrado",
               "MSK",
               "Horário de Verão de Volgogrado",
               "MSK",
               "Horário de Volgogrado",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Horário Padrão do Arzeibaijão",
               "",
               "Horário de Verão do Arzeibaijão",
               "",
               "Horário do Arzeibaijão",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Horário Padrão de Bangladesh",
               "",
               "Horário de Verão de Bangladesh",
               "",
               "Horário de Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Horário Padrão de Cabo Verde",
               "",
               "Horário de Verão de Cabo Verde",
               "",
               "Horário de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Horário do Timor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Horário do Cazaquistão",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Horário de Seicheles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Horário do Tajiquistão",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Horário Padrão do Uzbequistão",
               "",
               "Horário de Verão do Uzbequistão",
               "",
               "Horário do Uzbequistão",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Horário do Afeganistão",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Horário Padrão de Krasnoyarsk",
               "",
               "Horário de Verão de Krasnoyarsk",
               "",
               "Horário de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Horário Padrão da Nova Zelândia",
               "NZST",
               "Horário de Verão da Nova Zelândia",
               "NZDT",
               "Horário da Nova Zelândia",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Horário Padrão de Novosibirsk",
               "",
               "Horário de Verão de Novosibirsk",
               "",
               "Horário de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Horário Padrão das Filipinas",
               "PST",
               "Horário de Verão das Filipinas",
               "PDT",
               "Horário das Filipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Horário Padrão de Vladivostok",
               "",
               "Horário de Verão de Vladivostok",
               "",
               "Horário de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Horário do Oceano Índico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Horário das Ilhas da Linha",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Horário Padrão da Terra Nova",
               "NST",
               "Horário de Verão da Terra Nova",
               "NDT",
               "Horário da Terra Nova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Horário Padrão do Turcomenistão",
               "",
               "Horário de Verão do Turcomenistão",
               "",
               "Horário do Turcomenistão",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Horário da Guiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Horário Padrão da Nova Caledônia",
               "",
               "Horário de Verão da Nova Caledônia",
               "",
               "Horário da Nova Caledônia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Horário da Geórgia do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Horário Padrão de Ecaterimburgo",
               "",
               "Horário de Verão de Ecaterimburgo",
               "",
               "Horário de Ecaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Horário da África Central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Horário da África Oriental",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Horário Padrão da África Ocidental",
               "WAT",
               "Horário de Verão da África Ocidental",
               "WAT",
               "Horário da África Ocidental",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Horário de Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Horário Padrão da Europa Central",
               "CET",
               "Horário de Verão da Europa Central",
               "CEST",
               "Horário da Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Horário Padrão da Europa Oriental",
               "EET",
               "Horário de Verão da Europa Oriental",
               "EEST",
               "Horário da Europa Oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Horário Padrão da Europa Ocidental",
               "WET",
               "Horário de Verão da Europa Ocidental",
               "WEST",
               "Horário da Europa Ocidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Horário Padrão do Pacífico Mexicano",
               "MST",
               "Horário de Verão do Pacífico Mexicano",
               "MDT",
               "Horário do Pacífico Mexicano",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Horário da África do Sul",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Horário Padrão Central",
               "CST",
               "Horário de Verão Central",
               "CDT",
               "Horário Central",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Horário Padrão do Leste",
               "EST",
               "Horário de Verão do Leste",
               "EST",
               "Horário do Leste",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Horário Padrão do Pacífico",
               "PST",
               "Horário de Verão do Pacífico",
               "PDT",
               "Horário do Pacífico",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Horário dos Territórios Franceses do Sul e Antártida",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Horário das Ilhas Gilberto",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Horário Padrão do Havaí e Ilhas Aleutas",
               "HST",
               "Horário de Verão do Havaí e Ilhas Aleutas",
               "HST",
               "Horário do Havaí e Ilhas Aleutas",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Horário das Ilhas Fênix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Horário Padrão de São Pedro e Miquelão",
               "",
               "Horário Verão de São Pedro e Miquelão",
               "",
               "Horário de São Pedro e Miquelão",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Horário Padrão das Montanhas",
               "MST",
               "Horário de Verão das Montanhas",
               "MST",
               "Horário das Montanhas",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Horário das Ilhas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Horário de Papua-Nova Guiné",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Horário Padrão da Austrália Central",
               "ACST",
               "Horário de Verão da Austrália Central",
               "ACDT",
               "Horário da Austrália Central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Horário Padrão da Austrália Oriental",
               "AEST",
               "Horário de Verão da Austrália Oriental",
               "AEDT",
               "Horário da Austrália Oriental",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Horário Padrão da Austrália Ocidental",
               "AWST",
               "Horário de Verão da Austrália Ocidental",
               "AWDT",
               "Horário da Austrália Ocidental",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Horário da Indonésia Central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Horário da Indonésia Oriental",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Horário da Indonésia Ocidental",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Horário Padrão da Austrália Centro-Ocidental",
               "",
               "Horário de Verão da Austrália Centro-Ocidental",
               "",
               "Horário da Austrália Centro-Ocidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Horário Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário Padrão Irlandês",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Horário Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Horário Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Horário Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Horário Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Horário Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário Padrão Irlandês",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Horário do Meridiano de Greenwich",
                    "GMT",
                    "Horário de Verão Britânico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Áden" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amã" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "timezone.excity.Asia/Kabul", "Cabul" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tóquio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lomé" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Beirute" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riade" },
            { "timezone.excity.Asia/Saigon", "Cidade de Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Teerã" },
            { "timezone.excity.Etc/Unknown", "Cidade desconhecida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mahé" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Tunis", "Túnis" },
            { "timezone.excity.Asia/Baghdad", "Bagdá" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Jakarta", "Jacarta" },
            { "timezone.excity.Asia/Nicosia", "Nicósia" },
            { "timezone.excity.Asia/Rangoon", "Rangum" },
            { "timezone.excity.Europe/Sofia", "Sófia" },
            { "timezone.excity.America/Belem", "Belém" },
            { "timezone.excity.Asia/Ashgabat", "Asgabate" },
            { "timezone.excity.Asia/Calcutta", "Calcutá" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Duchambe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Sakhalin", "Sacalina" },
            { "timezone.excity.Asia/Shanghai", "Xangai" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berlim" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madri" },
            { "timezone.excity.Europe/Monaco", "Mônaco" },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsóvia" },
            { "timezone.excity.Europe/Zurich", "Zurique" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.Pacific/Efate", "Éfaté" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "timezone.excity.Africa/Conakry", "Conacri" },
            { "timezone.excity.Africa/Nairobi", "Nairóbi" },
            { "timezone.excity.Africa/Tripoli", "Trípoli" },
            { "timezone.excity.America/Bogota", "Bogotá" },
            { "timezone.excity.America/Cuiaba", "Cuiabá" },
            { "timezone.excity.America/Guyana", "Guiana" },
            { "timezone.excity.America/Maceio", "Maceió" },
            { "timezone.excity.America/Panama", "Panamá" },
            { "timezone.excity.Asia/Jerusalem", "Jerusalém" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.Indian/Reunion", "Reunião" },
            { "timezone.excity.Pacific/Easter", "Ilha de Páscoa" },
            { "timezone.excity.Pacific/Noumea", "Nouméa" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Taraua" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiún" },
            { "timezone.excity.Africa/Khartoum", "Cartum" },
            { "timezone.excity.Africa/Monrovia", "Monróvia" },
            { "timezone.excity.Africa/Ndjamena", "N’Djamena" },
            { "timezone.excity.America/Antigua", "Antígua" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Managua", "Manágua" },
            { "timezone.excity.Atlantic/Azores", "Açores" },
            { "timezone.excity.Atlantic/Canary", "Canárias" },
            { "timezone.excity.Atlantic/Faeroe", "Ilhas Faroé" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruxelas" },
            { "timezone.excity.Europe/Budapest", "Budapeste" },
            { "timezone.excity.Europe/Busingen", "Büsingen" },
            { "timezone.excity.Europe/Helsinki", "Helsinque" },
            { "timezone.excity.Europe/Istanbul", "Istambul" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Pacific/Chatham", "Chatnam" },
            { "timezone.excity.Africa/Mogadishu", "Mogadíscio" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Assunção" },
            { "timezone.excity.America/Eirunepe", "Eirunepé" },
            { "timezone.excity.America/New_York", "Nova York" },
            { "timezone.excity.America/Santarem", "Santarém" },
            { "timezone.excity.America/St_Johns", "Saint John’s" },
            { "timezone.excity.America/St_Kitts", "São Cristóvão" },
            { "timezone.excity.America/St_Lucia", "Santa Lúcia" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdã" },
            { "timezone.excity.Europe/Astrakhan", "Astracã" },
            { "timezone.excity.Europe/Bucharest", "Bucareste" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Mauritius", "Maurício" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Araguaina", "Araguaína" },
            { "timezone.excity.America/Guayaquil", "Guaiaquil" },
            { "timezone.excity.America/Sao_Paulo", "São Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galápagos" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Montevideo", "Montevidéu" },
            { "timezone.excity.America/St_Vincent", "São Vicente" },
            { "timezone.excity.Asia/Yekaterinburg", "Ecaterimburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Ilha de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Africa/Johannesburg", "Joanesburgo" },
            { "timezone.excity.America/Mexico_City", "Cidade do México" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.America/Indianapolis", "Indianápolis" },
            { "timezone.excity.America/St_Barthelemy", "São Bartolomeu" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Porto Príncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Geórgia do Sul" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucumã" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota do Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota do Norte" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salen, Dakota do Norte" },
        };
        return data;
    }
}
