/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_yrl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Miridiyanu yara Hurariyu",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Hurariyu Retewa Acre yara",
               "ACT",
               "Hurariyu Kurasí Ara Acre yara",
               "ACST",
               "Hurariyu Acre yara",
               "ACT",
            };
        final String[] Apia = new String[] {
               "Apiya Uraruiyu Retewa",
               "",
               "Apiya Kurasí Ara Hurariyu",
               "",
               "Apiya Hurariyu",
               "",
            };
        final String[] Cook = new String[] {
               "Kapuã-ita Kooki Hurariyu Retewa",
               "",
               "Kapuã-ita Kooki Kurasí Ara Pitera Hurariyu",
               "",
               "Kapuã-ita Kooki Hurariyu",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba Hurariyu Retewa",
               "CST",
               "Kuba Kurasí Ara Hurariyu",
               "CDT",
               "Kuba Hurariyu",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiyi Hurariyu Retewa",
               "",
               "Fiyi Kurasí Ara Hurariyu",
               "",
               "Fiyi Hurariyu",
               "",
            };
        final String[] Gulf = new String[] {
               "Golfo Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Howidi Hurariyu Retewa",
               "",
               "Howidi Kurasí Ara Hurariyu",
               "",
               "Howidi Hurariyu",
               "",
            };
        final String[] Iran = new String[] {
               "Irã Hurariyu Retewa",
               "",
               "Irã Kurasí Ara Hurariyu",
               "",
               "Irã Hurariyu",
               "",
            };
        final String[] Niue = new String[] {
               "Niwe Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omisiki Hurariyu Retewa",
               "",
               "Omisiki Kurasí Ara Hurariyu",
               "",
               "Omisiki Hurariyu",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Hurariyu Retewa",
               "",
               "Peru Kurasí Ara Hurariyu",
               "",
               "Peru Hurariyu",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Kapuã-ita Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Xiri Hurariyu Retewa",
               "",
               "Xiri Kurasí Ara Hurariyu",
               "",
               "Xiri Hurariyu",
               "",
            };
        final String[] China = new String[] {
               "Xina Hurariyu Retewa",
               "CST",
               "Xina Kurasí Ara Hurariyu",
               "CDT",
               "Xina Hurariyu",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kapuã-ita Kuku-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dawi Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ĩdia Hurariyu Retewa",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Nipõ Hurariyu Retewa",
               "JST",
               "Nipõ Kurasí Ara Hurariyu",
               "JDT",
               "Nipõ Hurariyu",
               "JT",
            };
        final String[] Korea = new String[] {
               "Kureya Hurariyu Retewa",
               "KST",
               "Kureya Kurasí Ara Hurariyu",
               "KST",
               "Kureya Hurariyu",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepau Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Parau Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samowa Hurariyu Retewa",
               "SST",
               "Samowa Kurasí Ara Hurariyu",
               "SST",
               "Samowa Hurariyu",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Siyowa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tõga Hurariyu Retewa",
               "",
               "Tõga Kurasí Ara Hurariyu",
               "",
               "Tõga Hurariyu",
               "",
            };
        final String[] Alaska = new String[] {
               "Alasika Hurariyu Eté",
               "AKST",
               "Alasika Kurasí Ara Hurariyu",
               "AKDT",
               "Alasika Hurariyu",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amasuna Hurariyu Eté",
               "AMT",
               "Amasuna Kurasí Ara Hurariyu",
               "AMST",
               "Amasuna Hurariyu",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "Anadí Hurariyu Retewa",
               "",
               "Anadí Kurasí Ara Hurariyu",
               "",
               "Anadí Hurariyu",
               "",
            };
        final String[] Azores = new String[] {
               "Asori-ita Hurariyu Retewa",
               "",
               "Asori-ita Kurasí Ara Hurariyu",
               "",
               "Asori-ita Hurariyu",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butãu Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Burunei Darusaram Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Pasikuwa Kapuãma Hurariyu Retewa",
               "",
               "Pasikuwa Kapuãma Kurasí Ara Hurariyu",
               "",
               "Pasikuwa Kapuãma Hurariyu",
               "",
            };
        final String[] Guyana = new String[] {
               "Giyana Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Isirayeu Hurariyu Retewa",
               "IST",
               "Isirayeu Kurasí Ara Hurariyu",
               "IDT",
               "Isirayeu Hurariyu",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kusirai Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mausũ Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskou Hurariyu Retewa",
               "MSK",
               "Moskou Kurasí Ara Hurariyu",
               "MSK",
               "Moskou Hurariyu",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara Hurariyu Retewa",
               "",
               "Samara Kurasí Ara Hurariyu",
               "",
               "Samara Hurariyu",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Hurariyu Retewa",
               "CST",
               "Taipei Kurasí Ara Hurariyu",
               "CDT",
               "Taipei Hurariyu",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaru Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wosituki Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wari asuí Futuna Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arábiya Hurariyu Retewa",
               "",
               "Arabiya Kurasí Ara Hurariyu",
               "",
               "Arábiya Hurariyu",
               "",
            };
        final String[] Armenia = new String[] {
               "Arimẽniya Hurariyu Retewa",
               "",
               "Arimẽniya Kurasí Ara Hurariyu",
               "",
               "Arimẽniya Hurariyu",
               "",
            };
        final String[] Bolivia = new String[] {
               "Buríwia Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Xatham Hurariyu Retewa",
               "",
               "Xatham Kurasí Ara Hurariyu",
               "",
               "Xatham Hurariyu",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hurariyu Mũdi turususawa Kurdenadu",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekuadú Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gãbiere Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Geugiya Hurariyu Retewa",
               "",
               "Geugiya Kurasí Ara Hurariyu",
               "",
               "Geugiya Hurariyu",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutisiki Hurariyu Retewa",
               "",
               "Irkutisiki Kurasí Ara Hurariyu",
               "",
               "Irkutisiki Hurariyu",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadã Hurariyu Retewa",
               "",
               "Magadã Kurasí Ara Hurariyu",
               "",
               "Magadã Hurariyu",
               "",
            };
        final String[] Myanmar = new String[] {
               "Miyamá Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Kapuãma Norfolk Hurariyu Retewa",
               "",
               "Kapuãma Norfolk Kurasí Ara Hurariyu",
               "",
               "Kapuãma Norfolk Hurariyu",
               "",
            };
        final String[] Noronha = new String[] {
               "Fenãdu Nuruyã Hurariyu Retewa",
               "",
               "Fenãdu Nuruyã Kurasí Ara Hurariyu",
               "",
               "Fenãdu Nuruyã Hurariyu",
               "",
            };
        final String[] Reunion = new String[] {
               "Yumuatirisawa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Kapuãma-ita Sarumũ Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokerau Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguwai Hurariyu Retewa",
               "",
               "Uruguwai Kurasí Ara Hurariyu",
               "",
               "Uruguwai Hurariyu",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Wanuatu Hurariyu Retewa",
               "",
               "Wanuatu Kurasí Ara Hurariyu",
               "",
               "Wanuatu Hurariyu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutisiki Hurariyu Retewa",
               "",
               "Yakutisiki Kurasí Ara Hurariyu",
               "",
               "Yakutisiki Hurariyu",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atalãtiku Hurariyu Retewa",
               "AST",
               "Atalãtku Kurasí Ara Hurariyu",
               "AST",
               "Atalãtiku Hurariyu",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Óra Pã Brasília tá",
               "BRT",
               "Rỹ Kã Óra Brasília tá",
               "BRST",
               "Óra Brasília tá",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "Xamoro Hurariyu",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kurũbia Hurariyu Retewa",
               "",
               "Kurũbia Kurasí Ara Hurariyu",
               "",
               "Kurũbia Hurariyu",
               "",
            };
        final String[] Falkland = new String[] {
               "Kapuã-ita Mawina Hurariyu Retewa",
               "",
               "Kapuã-ita Mawina Kurasí Ara Hurariyu",
               "",
               "Kapuã-ita Mawina Hurariyu",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malasiya Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Kapuã-ita Maudiwa-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Urã Baturu Hurariyu Retewa",
               "",
               "Urã Baturu Kurasí Ara Hurariyu",
               "",
               "Urã Baturu Hurariyu",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakiretãma Hurariyu Retewa",
               "PKT",
               "Pakiretãma Kurasí Ara Hurariyu",
               "PKST",
               "Pakiretãma Hurariyu",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguwai Hurariyu Retewa",
               "",
               "ParaguwaiKurasí Ara Hurariyu",
               "",
               "Paraguwai Hurariyu",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakarina Hurariyu Retewa",
               "",
               "Sakarina Kurasí Ara Hurariyu",
               "",
               "Sakarina Hurariyu",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argẽtina Hurariyu Retewa",
               "",
               "Argẽtina Kurasí Ara Hurariyu",
               "",
               "Argẽtina Hurariyu",
               "",
            };
        final String[] Christmas = new String[] {
               "KapuãmaKiritima Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Garapagu-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hũg Kũg Hurariyu Retewa",
               "HKT",
               "Hũg Kũg Kurasí Ara Hurariyu",
               "HKST",
               "Hũg Kũg Hurariyu",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ĩdoxina Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatski Hurariyu Retewa",
               "",
               "Petropavlovsk-Kamchatski Kurasí Ara Hurariyu",
               "",
               "Petropavlovsk-Kamchatski Hurariyu",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirigiretãma Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lurudi Howe Hurariyu Retewa",
               "",
               "Lurudi Howe Kurasí Ara Hurariyu",
               "",
               "Lurudi Howe Hurariyu",
               "",
            };
        final String[] Marquesas = new String[] {
               "Makesa-ita Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Maurisiyu Hurariyu Retewa",
               "",
               "Maurisiyu Kurasí Ara Hurariyu",
               "",
               "Maurisiyu Hurariyu",
               "",
            };
        final String[] Singapore = new String[] {
               "Sĩgapura Hurariyu Retewa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wenẽsuera Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Worwogaradu Hurariyu Retewa",
               "MSK",
               "Worwogaradu Kurasí Ara Hurariyu",
               "MSK",
               "Worwogaradu Hurariyu",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aseriretãma Hurariyu Retewa",
               "",
               "Aseriretãma Kurasí Ara Hurariyu",
               "",
               "Aseriretãma Hurariyu",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bãkaradexi Horariyu Retewa",
               "",
               "Bãkaradexi Kurasí Ara Horariyu",
               "",
               "Bãkaradexi Horariyu",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kabu Suikiri Hurariyu Retewa",
               "",
               "Kabu Suikiri Kurasí Ara Hurariyu",
               "",
               "Kabu Suikiri Hurariyu",
               "",
            };
        final String[] East_Timor = new String[] {
               "Timu-Semusawa Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seixeri Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tayikiretãma Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Yũbuesara-retãma Hurariyu Retewa",
               "",
               "Yũbuesara-retãma Kurasí Ara Hurariyu",
               "",
               "Yũbuesara-retãma Hurariyu",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afegãniretãma Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Karasinoyarisiki Hurariyu Retewa",
               "",
               "Karasinoyarisiki Kurasí Ara Hurariyu",
               "",
               "Karasinoyarisiki Hurariyu",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Serãdiya Pisasú Hurariyu Retewa",
               "NZST",
               "Serãdiya Pisasú Kurasí Ara Hurariyu",
               "NZDT",
               "Serãdiya Pisasú Hurariyu",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Sibirisiki Pisasú Hurariyu Retewa",
               "",
               "Sibirisiki Pisasú Kurasí Ara Hurariyu",
               "",
               "Sibirisiki Pisasú Hurariyu",
               "",
            };
        final String[] Philippines = new String[] {
               "Firipina Hurariyu Retewa",
               "PST",
               "Firipina Kurasí Ara Hurariyu",
               "PDT",
               "Firipina Hurariyu",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Waradiwosituki Hurariyu Retewa",
               "",
               "Waradiwosituki Kurasí Ara Hurariyu",
               "",
               "Waradiwosituki Hurariyu",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Useyanu Ĩdiku Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Kapuã-ita Inĩbu Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Iwí Pisasú Hurariyu Retewa",
               "NST",
               "Iwí Pisasú Kurasí Ara Hurariyu",
               "NDT",
               "Iwí Pisasú Hurariyu",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkuranaretãma Hurariyu Retewa",
               "",
               "Turkuranaretãma Kurasí Ara Hurariyu",
               "",
               "Turkuranaretãma Hurariyu",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Giyana Frãsa yara Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Karedũniya Pisasú Hurariyu Retewa",
               "",
               "Karedũniya Pisasú Kurasí Ara Hurariyu",
               "",
               "Karedũniya Pisasú Hurariyu",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Geugiya Su suí Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ekaterĩbugu Hurariyu Retewa",
               "",
               "Ekaterĩbugu Kurasí Ara Hurariyu",
               "",
               "Ekaterĩbugu Hurariyu",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afirika Piterawara Hurariyu",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afirika Uriẽtawara Hurariyu",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Afirika Usidẽtawara Hurariyu Retewa",
               "WAT",
               "Afirika Usidẽtawara Kurasí Ara Hurariyu",
               "WAT",
               "Afirikia Usidẽtawara Hurariyu",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Eurupa Piterawara Hurariyu Retewa",
               "CET",
               "Eurupa Piterawara Kurasí Ara Hurariyu",
               "CEST",
               "Eurupa Piterawara Hurariyu",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Eurupa Uriẽtawara Hurariyu Retewa",
               "EET",
               "Eurupa Uriẽtawara Kurasí Ara Hurariyu",
               "EEST",
               "Eurupa Uriẽtawara Hurariyu",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Eurupa Usidẽtawara Hurariyu Retewa",
               "WET",
               "Eurupa Usidẽtawara Kurasí Ara Hurariyu",
               "WEST",
               "Eurupa Usidẽtawara Hurariyu",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Pasifiku Mexikanu Hurariyu Retewa",
               "MST",
               "Pasifiku Mexikanu Kurasí Ara Hurariyu",
               "MDT",
               "Pasifiku Mexikanu Hurariyu",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Afirika Su suí Hurariyu",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hurariyu Retewa Piterawara",
               "CST",
               "Hurariyu Kurasí Ara Piterawara",
               "CDT",
               "Óra Kuju",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hurariyu Retewa Lesiti yara",
               "EST",
               "Hurariyu Kurasí Ara Lesiti",
               "EST",
               "Hurariyu Lesiti",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Óra Pã Pasifiku tá",
               "PST",
               "Rỹ Kã Óra Pasifiku tá",
               "PDT",
               "Óra Pasifiku tá",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Tetãma Su suí Frãsa yara asuí Ãtartida Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Kapuã-ita Yubetu Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaí asuí Kapuã-ita Areuta-ita Hurariyu Retewa",
               "HST",
               "Hawaí asuí Kapuã-ita Areuta-ita Kurasí Ara Hurariyu",
               "HST",
               "Hawaí asuí Kapuã-ita Areuta-ita Hurariyu",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Kapuã-ita Fẽnix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sã Peduru asuí Mikirãu Hurariyu Retewa",
               "",
               "Sã Peduru asuí Mikirãu Kurasí Ara Hurariyu",
               "",
               "Sã Peduru asuí Mikirãu Hurariyu",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Óra Pã Krĩ-ag tá",
               "MST",
               "Rỹ kã Óra Krĩ-ag tá",
               "MST",
               "Óra Krĩ-ag tá",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Kapuã-ita Marshall Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papuwa-Giné Pisasú Hurariyu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ausitaraliya Piterawara Hurariyu Retewa",
               "ACST",
               "Ausitaraliya Piterawara Kurasí Ara Hurariyu",
               "ACDT",
               "Ausitaraliya Piterawara Hurariyu",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ausitaraliya Uriẽtawara Hurariyu Retewa",
               "AEST",
               "Ausitaraliya Uriẽtawara Kurasí Ara Hurariyu",
               "AEDT",
               "Ausitaraliya Uriẽtawara Hurariyu",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ausitaraliya Usidẽtawara Hurariyu Retewa",
               "AWST",
               "Ausitaraliya Usidẽtawara Kurasí Ara Hurariyu",
               "AWDT",
               "Ausitaraliya Usidẽtawara Hurariyu",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ĩdonesiya Piterawara Hurariyu",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ĩdonesiya Uriẽtawara Hurariyu",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ĩdonesiya Usidẽtawara Hurariyu",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ausitaraliya Piterawara-Usidẽtawara Hurariyu Retewa",
               "",
               "Ausitaraliya Piterawara-Usidẽtawara Kurasí Ara Hurariyu",
               "",
               "Ausitaraliya Piterawara-Usidẽtawara Hurariyu",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hurariyu Mũdi turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Retewa Irãdei",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hurariyu Mũdi turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hurariyu Mũdi turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hurariyu Mũdi turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hurariyu Mũdi turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hurariyu Mũdi turususawa Kurdenadu",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Retewa Irãdei",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Miridiyanu yara Hurariyu",
                    "GMT",
                    "Hurariyu Kurasí Ara Biritãniku",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adẽ" },
            { "timezone.excity.Asia/Dili", "Diri" },
            { "timezone.excity.Asia/Gaza", "Gasa" },
            { "timezone.excity.Asia/Hovd", "Howidi" },
            { "timezone.excity.Asia/Omsk", "Omisiki" },
            { "timezone.excity.Asia/Oral", "Raure" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amã" },
            { "timezone.excity.Asia/Aqtau", "Akitau" },
            { "timezone.excity.Asia/Chita", "Xita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Kabul", "Kabú" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "timezone.excity.Asia/Qatar", "Katari" },
            { "timezone.excity.Asia/Seoul", "Seú" },
            { "timezone.excity.Asia/Tokyo", "Tokiyu" },
            { "timezone.excity.Asia/Tomsk", "Tomisiki" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Yuba" },
            { "timezone.excity.Africa/Lome", "Rumé" },
            { "timezone.excity.Asia/Almaty", "Aumati" },
            { "timezone.excity.Asia/Anadyr", "Anadi" },
            { "timezone.excity.Asia/Aqtobe", "Akitubi" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Beirute" },
            { "timezone.excity.Asia/Brunei", "Burunei" },
            { "timezone.excity.Asia/Hebron", "Heburũ" },
            { "timezone.excity.Asia/Kuwait", "Kuwaiti" },
            { "timezone.excity.Asia/Manila", "Manira" },
            { "timezone.excity.Asia/Muscat", "Masikati" },
            { "timezone.excity.Asia/Riyadh", "Riade" },
            { "timezone.excity.Asia/Tehran", "Teyerã" },
            { "timezone.excity.Asia/Urumqi", "Urũki" },
            { "timezone.excity.Etc/Unknown", "Tawa-wasú Ũbawaukuamamẽ" },
            { "timezone.excity.Europe/Kiev", "Kiyewe" },
            { "timezone.excity.Europe/Oslo", "Usiru" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Maé" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akara" },
            { "timezone.excity.Africa/Cairo", "Kairu" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Lagos", "Ipawaita" },
            { "timezone.excity.Africa/Tunis", "Tuni-ita" },
            { "timezone.excity.America/Adak", "Adaki" },
            { "timezone.excity.America/Lima", "Rima" },
            { "timezone.excity.America/Nome", "Réra" },
            { "timezone.excity.Asia/Baghdad", "Magna" },
            { "timezone.excity.Asia/Bahrain", "Barẽi" },
            { "timezone.excity.Asia/Bangkok", "Mág-kóki" },
            { "timezone.excity.Asia/Barnaul", "Barnau" },
            { "timezone.excity.Asia/Bishkek", "Bisikeki" },
            { "timezone.excity.Asia/Colombo", "Kurũbu" },
            { "timezone.excity.Asia/Irkutsk", "Irkutisiki" },
            { "timezone.excity.Asia/Jakarta", "Jakata" },
            { "timezone.excity.Asia/Karachi", "Karaxi" },
            { "timezone.excity.Asia/Kuching", "Kuxĩgi" },
            { "timezone.excity.Asia/Magadan", "Magadã" },
            { "timezone.excity.Asia/Nicosia", "Nikosiya" },
            { "timezone.excity.Asia/Rangoon", "Rãgũ" },
            { "timezone.excity.Asia/Tbilisi", "Tibilisi" },
            { "timezone.excity.Asia/Thimphu", "Tĩpu" },
            { "timezone.excity.Asia/Yakutsk", "Yakutisiki" },
            { "timezone.excity.Asia/Yerevan", "Yerewã" },
            { "timezone.excity.Europe/Kirov", "Kirowi" },
            { "timezone.excity.Europe/Malta", "Mauta" },
            { "timezone.excity.Europe/Minsk", "Mĩsiki" },
            { "timezone.excity.Europe/Sofia", "Sufiya" },
            { "timezone.excity.Europe/Vaduz", "Vadusi" },
            { "timezone.excity.Indian/Cocos", "Kuku-ita" },
            { "timezone.excity.Pacific/Apia", "Apiya" },
            { "timezone.excity.Pacific/Fiji", "Fiyi" },
            { "timezone.excity.Pacific/Guam", "Guwã" },
            { "timezone.excity.Pacific/Niue", "Niwe" },
            { "timezone.excity.Africa/Asmera", "Asimara" },
            { "timezone.excity.Africa/Bamako", "Bamaku" },
            { "timezone.excity.Africa/Bangui", "Bãki" },
            { "timezone.excity.Africa/Banjul", "Bãjú" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Douala", "Duwala" },
            { "timezone.excity.Africa/Kigali", "Kigari" },
            { "timezone.excity.Africa/Luanda", "Ruãda" },
            { "timezone.excity.Africa/Malabo", "Malabu" },
            { "timezone.excity.Africa/Maputo", "Maputu" },
            { "timezone.excity.Africa/Niamey", "Niamei" },
            { "timezone.excity.America/Bahia", "Baíya" },
            { "timezone.excity.America/Belem", "Belẽ" },
            { "timezone.excity.America/Boise", "Buwisé" },
            { "timezone.excity.America/Jujuy", "Yuyui" },
            { "timezone.excity.America/Sitka", "Sitika" },
            { "timezone.excity.America/Thule", "Tixuri" },
            { "timezone.excity.Asia/Ashgabat", "Asigabati" },
            { "timezone.excity.Asia/Calcutta", "Kaukutá" },
            { "timezone.excity.Asia/Damascus", "Damasiku" },
            { "timezone.excity.Asia/Dushanbe", "Duxãbi" },
            { "timezone.excity.Asia/Jayapura", "Yayapura" },
            { "timezone.excity.Asia/Katmandu", "Katimãdu" },
            { "timezone.excity.Asia/Khandyga", "Kãdiga" },
            { "timezone.excity.Asia/Qostanay", "Kositanai" },
            { "timezone.excity.Asia/Sakhalin", "Sakarina" },
            { "timezone.excity.Asia/Shanghai", "Xãgai" },
            { "timezone.excity.Asia/Tashkent", "Tasikẽti" },
            { "timezone.excity.Asia/Ust-Nera", "Usiti-Nera" },
            { "timezone.excity.Europe/Athens", "Atena-ita" },
            { "timezone.excity.Europe/Berlin", "Berlim" },
            { "timezone.excity.Europe/Dublin", "Dubirĩ" },
            { "timezone.excity.Europe/Jersey", "Jersei" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madri" },
            { "timezone.excity.Europe/Monaco", "Munaku" },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Skopje", "Isikupiye" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wiyena" },
            { "timezone.excity.Europe/Warsaw", "Warisówiya" },
            { "timezone.excity.Europe/Zagreb", "Sagarebi" },
            { "timezone.excity.Europe/Zurich", "Zuriki" },
            { "timezone.excity.Indian/Chagos", "Xagu-ita" },
            { "timezone.excity.Indian/Comoro", "Kumure-ita" },
            { "timezone.excity.Pacific/Efate", "Efaté" },
            { "timezone.excity.Pacific/Palau", "Parau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidiyã" },
            { "timezone.excity.Africa/Algiers", "Ageu" },
            { "timezone.excity.Africa/Conakry", "Kunakiri" },
            { "timezone.excity.Africa/Kampala", "Kãpara" },
            { "timezone.excity.Africa/Mbabane", "Ũbabani" },
            { "timezone.excity.Africa/Nairobi", "Nairubi" },
            { "timezone.excity.Africa/Tripoli", "Tiripuri" },
            { "timezone.excity.America/Belize", "Berise" },
            { "timezone.excity.America/Bogota", "Bugutá" },
            { "timezone.excity.America/Cancun", "Kãkũ" },
            { "timezone.excity.America/Cayman", "Kaimã" },
            { "timezone.excity.America/Cuiaba", "Kuyaba" },
            { "timezone.excity.America/Dawson", "Dausũ" },
            { "timezone.excity.America/Denver", "Dẽwer" },
            { "timezone.excity.America/Guyana", "Giyana" },
            { "timezone.excity.America/Havana", "Hawana" },
            { "timezone.excity.America/Inuvik", "Inuwiki" },
            { "timezone.excity.America/Juneau", "Yuneau" },
            { "timezone.excity.America/Maceio", "Maseyó" },
            { "timezone.excity.America/Manaus", "Manau" },
            { "timezone.excity.America/Nassau", "Nasau" },
            { "timezone.excity.America/Panama", "Panamã" },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.America/Regina", "Rejĩnỹ" },
            { "timezone.excity.Asia/Famagusta", "Famaguita" },
            { "timezone.excity.Asia/Hong_Kong", "Hũg Kũg" },
            { "timezone.excity.Asia/Jerusalem", "Yerusarẽi" },
            { "timezone.excity.Asia/Kamchatka", "Kãxatika" },
            { "timezone.excity.Asia/Pontianak", "Pũtianaka" },
            { "timezone.excity.Asia/Pyongyang", "Piũgiãgi" },
            { "timezone.excity.Asia/Qyzylorda", "Kisiroda" },
            { "timezone.excity.Asia/Samarkand", "Samakãda" },
            { "timezone.excity.Asia/Singapore", "Sĩgapura" },
            { "timezone.excity.Asia/Vientiane", "Viẽtiane" },
            { "timezone.excity.Europe/Andorra", "Ãdura" },
            { "timezone.excity.Europe/Saratov", "Saratuwo" },
            { "timezone.excity.Europe/Tallinn", "Tarĩ" },
            { "timezone.excity.Europe/Vatican", "Watikanu" },
            { "timezone.excity.Europe/Vilnius", "Viwiu-ita" },
            { "timezone.excity.Indian/Mayotte", "Mayuti" },
            { "timezone.excity.Indian/Reunion", "Yumuatirisawa" },
            { "timezone.excity.Pacific/Easter", "Pasikuwa Kapuãma" },
            { "timezone.excity.Pacific/Kosrae", "Kusirai" },
            { "timezone.excity.Pacific/Majuro", "Mayuru" },
            { "timezone.excity.Pacific/Midway", "Midiwei" },
            { "timezone.excity.Pacific/Noumea", "Numeya" },
            { "timezone.excity.Pacific/Saipan", "Saipã" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Wallis", "Wari-ita" },
            { "timezone.excity.Africa/Blantyre", "Barãtire" },
            { "timezone.excity.Africa/Djibouti", "Dijibuti" },
            { "timezone.excity.Africa/El_Aaiun", "Eu Ayũ" },
            { "timezone.excity.Africa/Freetown", "Firetũ" },
            { "timezone.excity.Africa/Gaborone", "Gaburuni" },
            { "timezone.excity.Africa/Khartoum", "Katũ" },
            { "timezone.excity.Africa/Kinshasa", "Kĩxasa" },
            { "timezone.excity.Africa/Monrovia", "Mũruwiya" },
            { "timezone.excity.Africa/Ndjamena", "N’ Diyamena" },
            { "timezone.excity.Africa/Sao_Tome", "Sã Tumé" },
            { "timezone.excity.Africa/Windhoek", "Wĩdueki" },
            { "timezone.excity.America/Antigua", "Ãtiguwa" },
            { "timezone.excity.America/Caracas", "Karaka" },
            { "timezone.excity.America/Cayenne", "Kayena" },
            { "timezone.excity.America/Chicago", "Xikagu" },
            { "timezone.excity.America/Cordoba", "Kóduba" },
            { "timezone.excity.America/Creston", "Kerestũ" },
            { "timezone.excity.America/Curacao", "Kurasau" },
            { "timezone.excity.America/Godthab", "Nuki" },
            { "timezone.excity.America/Grenada", "Garanada" },
            { "timezone.excity.America/Iqaluit", "Ikaruiti" },
            { "timezone.excity.America/Jamaica", "Yamaika" },
            { "timezone.excity.America/Managua", "Manáguwa" },
            { "timezone.excity.America/Marigot", "Mariguti" },
            { "timezone.excity.America/Mendoza", "Mẽdusa" },
            { "timezone.excity.America/Moncton", "Mũkitũ" },
            { "timezone.excity.America/Noronha", "Fenãdu Nuruyã" },
            { "timezone.excity.America/Ojinaga", "Oyinaga" },
            { "timezone.excity.America/Phoenix", "Puwenikisi" },
            { "timezone.excity.America/Tijuana", "Tijuvỹnỹ" },
            { "timezone.excity.America/Toronto", "Turũtu" },
            { "timezone.excity.America/Tortola", "Tutura" },
            { "timezone.excity.America/Yakutat", "Yakutati" },
            { "timezone.excity.Asia/Phnom_Penh", "Pinõ Pẽi" },
            { "timezone.excity.Atlantic/Azores", "Asori-ita" },
            { "timezone.excity.Atlantic/Canary", "Kanariya-ita" },
            { "timezone.excity.Atlantic/Faeroe", "Kapuãma-ita Faruwe" },
            { "timezone.excity.Australia/Eucla", "Eukara" },
            { "timezone.excity.Australia/Perth", "Periti" },
            { "timezone.excity.Europe/Belgrade", "Beugaradu" },
            { "timezone.excity.Europe/Brussels", "Buruxera" },
            { "timezone.excity.Europe/Budapest", "Budapeti" },
            { "timezone.excity.Europe/Busingen", "Busĩgeni" },
            { "timezone.excity.Europe/Chisinau", "Xisinau" },
            { "timezone.excity.Europe/Guernsey", "Guwẽnisei" },
            { "timezone.excity.Europe/Helsinki", "Heusĩke" },
            { "timezone.excity.Europe/Istanbul", "Istambul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayewo" },
            { "timezone.excity.Indian/Maldives", "Maudiwa-ita" },
            { "timezone.excity.Pacific/Chatham", "Xatinã" },
            { "timezone.excity.Pacific/Fakaofo", "Fakaufu" },
            { "timezone.excity.Pacific/Gambier", "Gãbiere" },
            { "timezone.excity.Pacific/Norfolk", "Nurufuki" },
            { "timezone.excity.Africa/Bujumbura", "Buyũbura" },
            { "timezone.excity.Africa/Mogadishu", "Mugadisiku" },
            { "timezone.excity.America/Anguilla", "Ãgira" },
            { "timezone.excity.America/Asuncion", "Asũsiyõ" },
            { "timezone.excity.America/Barbados", "Barabadu" },
            { "timezone.excity.America/Dominica", "Duminika" },
            { "timezone.excity.America/Edmonton", "Edimũtũ" },
            { "timezone.excity.America/Eirunepe", "Eirunepé" },
            { "timezone.excity.America/Mazatlan", "Masatarã" },
            { "timezone.excity.America/Miquelon", "Mikirũ" },
            { "timezone.excity.America/New_York", "Yurki Pisasú" },
            { "timezone.excity.America/Resolute", "Resoruti" },
            { "timezone.excity.America/Santarem", "Sãtarẽ" },
            { "timezone.excity.America/Santiago", "Sãtiyagu" },
            { "timezone.excity.America/St_Johns", "Sãti Juni" },
            { "timezone.excity.America/St_Kitts", "Sã Kirituwãu" },
            { "timezone.excity.America/St_Lucia", "Sãta Lusiya" },
            { "timezone.excity.America/Winnipeg", "Winĩpegi" },
            { "timezone.excity.Antarctica/Casey", "Kasei" },
            { "timezone.excity.Antarctica/Davis", "Dawi" },
            { "timezone.excity.Antarctica/Syowa", "Siyowa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Karasinoyarisiki" },
            { "timezone.excity.Asia/Novosibirsk", "Sibirisiki Pisasú" },
            { "timezone.excity.Asia/Ulaanbaatar", "Urã Baturu" },
            { "timezone.excity.Asia/Vladivostok", "Waradiwosituki" },
            { "timezone.excity.Atlantic/Bermuda", "Bemuda" },
            { "timezone.excity.Atlantic/Stanley", "Isitãrei" },
            { "timezone.excity.Australia/Darwin", "Dariwĩ" },
            { "timezone.excity.Australia/Hobart", "Hobati" },
            { "timezone.excity.Australia/Sydney", "Sidinei" },
            { "timezone.excity.Europe/Amsterdam", "Amiteridã" },
            { "timezone.excity.Europe/Astrakhan", "Asitarakã" },
            { "timezone.excity.Europe/Bucharest", "Bukareti" },
            { "timezone.excity.Europe/Gibraltar", "Gibarautá" },
            { "timezone.excity.Europe/Ljubljana", "Riubiriana" },
            { "timezone.excity.Europe/Mariehamn", "Mariẽyã" },
            { "timezone.excity.Europe/Podgorica", "Pudigurika" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianuwiki" },
            { "timezone.excity.Europe/Volgograd", "Wugogaradu" },
            { "timezone.excity.Indian/Christmas", "Kiritima-ita" },
            { "timezone.excity.Indian/Kerguelen", "Kergelẽ" },
            { "timezone.excity.Indian/Mauritius", "Maurisiyu" },
            { "timezone.excity.Pacific/Auckland", "Ókirãdi" },
            { "timezone.excity.Pacific/Honolulu", "Hunururu" },
            { "timezone.excity.Africa/Casablanca", "Uka Murutĩga" },
            { "timezone.excity.Africa/Libreville", "Riberevili" },
            { "timezone.excity.Africa/Lubumbashi", "Lubũbaxi" },
            { "timezone.excity.Africa/Nouakchott", "Nowakixuti" },
            { "timezone.excity.Africa/Porto-Novo", "Igarapawa Pisasú" },
            { "timezone.excity.America/Anchorage", "Ãkurage" },
            { "timezone.excity.America/Araguaina", "Araguayina" },
            { "timezone.excity.America/Boa_Vista", "Buwa Vista" },
            { "timezone.excity.America/Catamarca", "Katamaka" },
            { "timezone.excity.America/Chihuahua", "Sivava" },
            { "timezone.excity.America/Fortaleza", "Futaresa" },
            { "timezone.excity.America/Glace_Bay", "Yrusãgusu-atã Kuara" },
            { "timezone.excity.America/Goose_Bay", "Ipekawasu Kuara" },
            { "timezone.excity.America/Guatemala", "Guatemara" },
            { "timezone.excity.America/Guayaquil", "Guayakiu" },
            { "timezone.excity.America/Matamoros", "Moroitayuká" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "Mõterei" },
            { "timezone.excity.America/Sao_Paulo", "Sã Pauru" },
            { "timezone.excity.America/St_Thomas", "Sãti Tomá" },
            { "timezone.excity.America/Vancouver", "Vãkuweri" },
            { "timezone.excity.Antarctica/Mawson", "Mausũ" },
            { "timezone.excity.Antarctica/Palmer", "Paumere" },
            { "timezone.excity.Antarctica/Vostok", "Wosituki" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuara Rũpuru" },
            { "timezone.excity.Asia/Novokuznetsk", "Kusinetisiki Pisasú" },
            { "timezone.excity.Europe/Bratislava", "Baratisilawa" },
            { "timezone.excity.Europe/Copenhagen", "Kopẽyagi" },
            { "timezone.excity.Europe/Luxembourg", "Ruxẽbugu" },
            { "timezone.excity.Europe/San_Marino", "Sã Marinu" },
            { "timezone.excity.Europe/Simferopol", "Sĩwerupu" },
            { "timezone.excity.Pacific/Enderbury", "Ẽdeburi" },
            { "timezone.excity.Pacific/Galapagos", "Garapagu-ita" },
            { "timezone.excity.Pacific/Kwajalein", "Kuayarẽi" },
            { "timezone.excity.Pacific/Marquesas", "Makesa-ita" },
            { "timezone.excity.Pacific/Pago_Pago", "Pagu Pagu" },
            { "timezone.excity.Pacific/Rarotonga", "Rarutũga" },
            { "timezone.excity.Pacific/Tongatapu", "Tũgatapu" },
            { "timezone.excity.Africa/Addis_Ababa", "Adisi Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Barazawiri" },
            { "timezone.excity.Africa/Ouagadougou", "Uwagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kupé Rika" },
            { "timezone.excity.America/Grand_Turk", "Wasú Turiku" },
            { "timezone.excity.America/Guadeloupe", "Guadarupi" },
            { "timezone.excity.America/Hermosillo", "Hemusiru" },
            { "timezone.excity.America/Kralendijk", "Kararẽdiki" },
            { "timezone.excity.America/Louisville", "Luwisiviri" },
            { "timezone.excity.America/Martinique", "Matinika" },
            { "timezone.excity.America/Metlakatla", "Metirakatira" },
            { "timezone.excity.America/Montevideo", "Mũtiwidewu" },
            { "timezone.excity.America/Montserrat", "Mõtiserati" },
            { "timezone.excity.America/Paramaribo", "Paramaribu" },
            { "timezone.excity.America/Rio_Branco", "Paranã Murutĩga" },
            { "timezone.excity.America/St_Vincent", "Sã Wisẽti" },
            { "timezone.excity.America/Whitehorse", "Kawaru Murutĩga" },
            { "timezone.excity.Antarctica/McMurdo", "MakiMudu" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Xeredinekorimiziki" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterĩbugu" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiyawiki" },
            { "timezone.excity.Atlantic/St_Helena", "Sãta Erẽna" },
            { "timezone.excity.Australia/Adelaide", "Aderaidi" },
            { "timezone.excity.Australia/Brisbane", "Biribani" },
            { "timezone.excity.Australia/Lindeman", "Rĩdemã" },
            { "timezone.excity.Europe/Isle_of_Man", "Mã Kapuãma" },
            { "timezone.excity.Europe/Kaliningrad", "Karinĩgaradu" },
            { "timezone.excity.Africa/Johannesburg", "Juanesibugu" },
            { "timezone.excity.America/El_Salvador", "Eu Sawadu" },
            { "timezone.excity.America/Fort_Nelson", "Futi Neusũ" },
            { "timezone.excity.America/Mexico_City", "Ẽmã tỹ Mẽsiku" },
            { "timezone.excity.America/Porto_Velho", "Igarapawa Kuximawara" },
            { "timezone.excity.America/Puerto_Rico", "Igarapawa Riku" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigaupa" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyear Tawa-wasú" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kabu Suikiri" },
            { "timezone.excity.Australia/Lord_Howe", "Lurudi Howe" },
            { "timezone.excity.Australia/Melbourne", "Meubúni" },
            { "timezone.excity.Indian/Antananarivo", "Ãtananariu" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadaukanau" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Katuawa ruka" },
            { "timezone.excity.America/Blanc-Sablon", "Iwikuí Murutĩga" },
            { "timezone.excity.America/Buenos_Aires", "Buwenusairi" },
            { "timezone.excity.America/Campo_Grande", "Kãpu Wasu" },
            { "timezone.excity.America/Danmarkshavn", "Dinamarakasãv" },
            { "timezone.excity.America/Dawson_Creek", "Dausũ Kiriki" },
            { "timezone.excity.America/Indiana/Knox", "Knox, Ĩdiana" },
            { "timezone.excity.America/Indianapolis", "Ĩdianapuri" },
            { "timezone.excity.America/Punta_Arenas", "Pũta Arena-ita" },
            { "timezone.excity.America/Rankin_Inlet", "Rãkĩ Uikesawa" },
            { "timezone.excity.America/Scoresbysund", "Itukutumiti" },
            { "timezone.excity.Antarctica/Macquarie", "Makikuari" },
            { "timezone.excity.Pacific/Bougainville", "Bugaĩwiri" },
            { "timezone.excity.Pacific/Port_Moresby", "Igarapawa Moresby" },
            { "timezone.excity.America/Cambridge_Bay", "Kẽbiriyi Kuara" },
            { "timezone.excity.America/Coral_Harbour", "Atikokã" },
            { "timezone.excity.America/Indiana/Vevay", "Wewai, Ĩdiana" },
            { "timezone.excity.America/Lower_Princes", "Pirĩsipi Quarter Uirpewara" },
            { "timezone.excity.America/Port_of_Spain", "Esipãya Igarapawa" },
            { "timezone.excity.America/Santo_Domingo", "Sãtu Dumĩgu" },
            { "timezone.excity.America/St_Barthelemy", "Sã Batulumeu" },
            { "timezone.excity.America/Swift_Current", "Paranã Pirãtã" },
            { "timezone.excity.Australia/Broken_Hill", "Iwitera Mupenaíra" },
            { "timezone.excity.America/Bahia_Banderas", "Bãdera-ita Kuara" },
            { "timezone.excity.America/Port-au-Prince", "Igarapawa Pirĩsipi" },
            { "timezone.excity.Atlantic/South_Georgia", "Geugiya Su suí" },
            { "timezone.excity.America/Argentina/Salta", "Sauta" },
            { "timezone.excity.America/Indiana/Marengo", "Marẽgu, Ĩdiana" },
            { "timezone.excity.America/Indiana/Winamac", "Winãmaki, Ĩdiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukumã" },
            { "timezone.excity.America/Argentina/Ushuaia", "Uxuwaya" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell Tawa-wasú, Ĩdiana" },
            { "timezone.excity.America/Indiana/Vincennes", "Wĩsene-ita, Ĩdiana" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ra Rioya" },
            { "timezone.excity.America/Argentina/San_Juan", "Sã Yuwã" },
            { "timezone.excity.America/Argentina/San_Luis", "Sã Rui" },
            { "timezone.excity.America/Indiana/Petersburg", "Pitirisibugi, Ĩdiana" },
            { "timezone.excity.America/Kentucky/Monticello", "Mũtiseru, Kẽtuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beur, Dakota Nuti suí" },
            { "timezone.excity.America/North_Dakota/Center", "Sẽte, Dakota Nuti suí" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Paranã Garegu-ita" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Pisasú Sarẽ, Dakota Nuti suí" },
        };
        return data;
    }
}
