/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ak extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Ber\u025b",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia Susudua Ber\u025b",
               "",
               "Apia Awia Ber\u025b",
               "",
               "Apia Ber\u025b",
               "",
            };
        final String[] Cook = new String[] {
               "Kuk Aeland Susudua Ber\u025b",
               "",
               "Kuk Aeland Awia Fa Ber\u025b",
               "",
               "Kuk Aeland Ber\u025b",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba Susudua Ber\u025b",
               "CST",
               "Kuba Awia Ber\u025b",
               "CDT",
               "Kuba Ber\u025b",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Figyi Susudua Ber\u025b",
               "",
               "Figyi Awia Ber\u025b",
               "",
               "Figyi Ber\u025b",
               "",
            };
        final String[] Gulf = new String[] {
               "G\u0254\u0254fo Susudua Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd Susudua Ber\u025b",
               "",
               "Hovd Awia Ber\u025b",
               "",
               "Hovd Ber\u025b",
               "",
            };
        final String[] Iran = new String[] {
               "Iran Susudua Ber\u025b",
               "",
               "Iran Awia Ber\u025b",
               "",
               "Iran Ber\u025b",
               "",
            };
        final String[] Niue = new String[] {
               "Niue Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk Susudua Ber\u025b",
               "",
               "Omsk Awia Ber\u025b",
               "",
               "Omsk Ber\u025b",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Susudua Ber\u025b",
               "",
               "Peru Awia Ber\u025b",
               "",
               "Peru Ber\u025b",
               "",
            };
        final String[] Truk = new String[] {
               "Kyuuk Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Kyili Susudua Ber\u025b",
               "",
               "Kyili Awia Ber\u025b",
               "",
               "Kyili Ber\u025b",
               "",
            };
        final String[] China = new String[] {
               "Kyaena Susudua Ber\u025b",
               "CST",
               "Kyaena Awia Ber\u025b",
               "CDT",
               "Kyaena Ber\u025b",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokoso Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India Susudua Ber\u025b",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Gyapan Susudua Ber\u025b",
               "JST",
               "Gyapan Awia Ber\u025b",
               "JDT",
               "Gyapan Ber\u025b",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korean Susudua Ber\u025b",
               "KST",
               "Korean Awia Ber\u025b",
               "KST",
               "Korean Ber\u025b",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "N\u025bpal Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Susudua Ber\u025b",
               "SST",
               "Samoa Awia Ber\u025b",
               "SST",
               "Samoa Ber\u025b",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga Susudua Ber\u025b",
               "",
               "Tonga Awia Ber\u025b",
               "",
               "Tonga Ber\u025b",
               "",
            };
        final String[] Yukon = new String[] {
               "Yuk\u0254n Ber\u025b",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska Susudua Ber\u025b",
               "AKST",
               "Alaska Awia Ber\u025b",
               "AKDT",
               "Alaska Ber\u025b",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazon Susudua Ber\u025b",
               "",
               "Amazon Awia Ber\u025b",
               "",
               "Amazon Ber\u025b",
               "",
            };
        final String[] Azores = new String[] {
               "Azores Susudua Ber\u025b",
               "",
               "Azores Awia Ber\u025b",
               "",
               "Azores Ber\u025b",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darusalam Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Easta Aeland Susudua Ber\u025b",
               "",
               "Easta Aeland Awia Ber\u025b",
               "",
               "Easta Aeland Ber\u025b",
               "",
            };
        final String[] Guyana = new String[] {
               "Gayana Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel Susudua Ber\u025b",
               "IST",
               "Israel Awia Ber\u025b",
               "IDT",
               "Israel Ber\u025b",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "M\u0254\u0254son Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "M\u0254sko Susudua Ber\u025b",
               "MSK",
               "M\u0254sko Awia Ber\u025b",
               "MSK",
               "M\u0254sko Ber\u025b",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei Susudua Ber\u025b",
               "CST",
               "Taipei Awia Ber\u025b",
               "CDT",
               "Taipei Ber\u025b",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis ne Futuna Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabia Susudua Ber\u025b",
               "",
               "Arabia Awia Ber\u025b",
               "",
               "Arabia Ber\u025b",
               "",
            };
        final String[] Armenia = new String[] {
               "Aamenia Susudua Ber\u025b",
               "",
               "Aamenia Awia Ber\u025b",
               "",
               "Aamenia Ber\u025b",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Kyatam Susudua Ber\u025b",
               "",
               "Kyatam Awia Ber\u025b",
               "",
               "Kyatam Ber\u025b",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Amansan K\u0254dinat\u025bde Ber\u025b",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Yikuwed\u0254 Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gy\u0254gyea Susudua Ber\u025b",
               "",
               "Gy\u0254gyea Awia Ber\u025b",
               "",
               "Gy\u0254gyea Ber\u025b",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk Susudua Ber\u025b",
               "",
               "Irkutsk Awia Ber\u025b",
               "",
               "Irkutsk Ber\u025b",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan Susudua Ber\u025b",
               "",
               "Magadan Awia Ber\u025b",
               "",
               "Magadan Ber\u025b",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mayaama Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "N\u0254\u0254f\u0254k Aeland Susudua Ber\u025b",
               "",
               "N\u0254\u0254f\u0254k Aeland Awia Ber\u025b",
               "",
               "N\u0254\u0254f\u0254k Aeland Ber\u025b",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Susudua Ber\u025b",
               "",
               "Fernando de Noronha Awia Ber\u025b",
               "",
               "Fernando de Noronha Ber\u025b",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Yurugwae Susudua Ber\u025b",
               "",
               "Yurugwae Awia Ber\u025b",
               "",
               "Yurugwae Ber\u025b",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu Susudua Ber\u025b",
               "",
               "Vanuatu Awia Ber\u025b",
               "",
               "Vanuatu Ber\u025b",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk Susudua Ber\u025b",
               "",
               "Yakutsk Awia Ber\u025b",
               "",
               "Yakutsk Ber\u025b",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik Susudua Ber\u025b",
               "AST",
               "Atlantik Awia Ber\u025b",
               "AST",
               "Atlantik Ber\u025b",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Susudua Ber\u025b",
               "",
               "Brasilia Awia Ber\u025b",
               "",
               "Brasilia Ber\u025b",
               "",
            };
        final String[] Chamorro = new String[] {
               "Kyamoro Susudua Ber\u025b",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolombia Susudua Ber\u025b",
               "",
               "Kolombia Awia Ber\u025b",
               "",
               "Kolombia Ber\u025b",
               "",
            };
        final String[] Falkland = new String[] {
               "F\u0254kman Aeland Susudua Ber\u025b",
               "",
               "F\u0254kman Aeland Awia Ber\u025b",
               "",
               "F\u0254kman Aeland Ber\u025b",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malehyia Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Yulanbata Susudua Ber\u025b",
               "",
               "Yulanbata Awia Ber\u025b",
               "",
               "Yulanbata Ber\u025b",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Susudua Ber\u025b",
               "PKT",
               "Pakistan Awia Ber\u025b",
               "PKST",
               "Pakistan Ber\u025b",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguae Susudua Ber\u025b",
               "",
               "Paraguae Awia Ber\u025b",
               "",
               "Paraguae Ber\u025b",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkairn Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin Susudua Ber\u025b",
               "",
               "Sakhalin Awia Ber\u025b",
               "",
               "Sakhalin Ber\u025b",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Agy\u025bntina Susudua Ber\u025b",
               "",
               "Agy\u025bntina Awia Ber\u025b",
               "",
               "Agy\u025bntina Ber\u025b",
               "",
            };
        final String[] Christmas = new String[] {
               "Buronya Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapag\u0254s Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "H\u0254nk\u0254n Susudua Ber\u025b",
               "HKT",
               "H\u0254nk\u0254n Awia Ber\u025b",
               "HKST",
               "H\u0254nk\u0254n Ber\u025b",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ind\u0254kyina Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "K\u025b\u025bgestan Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "L\u0254d Howe Susudua Ber\u025b",
               "",
               "L\u0254d Howe Awia Ber\u025b",
               "",
               "L\u0254d Howe Ber\u025b",
               "",
            };
        final String[] Marquesas = new String[] {
               "Makesase Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "M\u0254rihyi\u0254so Susudua Ber\u025b",
               "",
               "M\u0254rihyi\u0254so Awia Ber\u025b",
               "",
               "M\u0254rihyi\u0254so Ber\u025b",
               "",
            };
        final String[] Singapore = new String[] {
               "Singap\u0254 Susudua Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd Susudua Ber\u025b",
               "MSK",
               "Volgograd Awia Ber\u025b",
               "MSK",
               "Volgograd Ber\u025b",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Asabegyan Susudua Ber\u025b",
               "",
               "Asabegyan Awia Ber\u025b",
               "",
               "Asabegyan Ber\u025b",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglad\u025bhye Susudua Ber\u025b",
               "",
               "Banglad\u025bhye Awia Ber\u025b",
               "",
               "Banglad\u025bhye Ber\u025b",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kepv\u025bde Susudua Ber\u025b",
               "",
               "Kepv\u025bde Awia Ber\u025b",
               "",
               "Kepv\u025bde Ber\u025b",
               "",
            };
        final String[] East_Timor = new String[] {
               "Tim\u0254\u0254 Apuee\u025b Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazakstan Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seyhy\u025bl Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tagyikistan Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usb\u025bkistan Susudua Ber\u025b",
               "",
               "Usb\u025bkistan Awia Ber\u025b",
               "",
               "Usb\u025bkistan Ber\u025b",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk Susudua Ber\u025b",
               "",
               "Krasnoyarsk Awia Ber\u025b",
               "",
               "Krasnoyarsk Ber\u025b",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ziland Fofor\u0254 Susudua Ber\u025b",
               "NZST",
               "Ziland Fofor\u0254 Awia Ber\u025b",
               "NZDT",
               "Ziland Fofor\u0254 Ber\u025b",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk Susudua Ber\u025b",
               "",
               "Novosibirsk Awia Ber\u025b",
               "",
               "Novosibirsk Ber\u025b",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipin Susudua Ber\u025b",
               "PST",
               "Filipin Awia Ber\u025b",
               "PDT",
               "Filipin Ber\u025b",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok Susudua Ber\u025b",
               "",
               "Vladivostok Awia Ber\u025b",
               "",
               "Vladivostok Ber\u025b",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "India Po Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lai Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Susudua Ber\u025b",
               "NST",
               "Newfoundland Awia Ber\u025b",
               "NDT",
               "Newfoundland Ber\u025b",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u025bkm\u025bnistan Susudua Ber\u025b",
               "",
               "T\u025bkm\u025bnistan Awia Ber\u025b",
               "",
               "T\u025bkm\u025bnistan Ber\u025b",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Fr\u025bnkye Gayana Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Kaledonia Fofor\u0254 Susudua Ber\u025b",
               "",
               "Kaledonia Fofor\u0254 Awia Ber\u025b",
               "",
               "Kaledonia Fofor\u0254 Ber\u025b",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Gy\u0254\u0254gyia Anaafo\u0254 Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Y\u025bkat\u025brinb\u025bg Susudua Ber\u025b",
               "",
               "Y\u025bkat\u025brinb\u025bg Awia Ber\u025b",
               "",
               "Y\u025bkat\u025brinb\u025bg Ber\u025b",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Afrika Finimfin Ber\u025b",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afrika Apuee\u025b Ber\u025b",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Afrika At\u0254e\u025b Susudua Ber\u025b",
               "WAT",
               "Afrika At\u0254e\u025b Awia Ber\u025b",
               "WAT",
               "Afrika At\u0254e\u025b Ber\u025b",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Yuropu Mfinimfini Susudua Ber\u025b",
               "CET",
               "Yuropu Mfinimfini Awia Ber\u025b",
               "CEST",
               "Yuropu Mfinimfini Ber\u025b",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Yuropu Apuee\u025b Susudua Ber\u025b",
               "EET",
               "Yuropu Apuee\u025b Awia Ber\u025b",
               "EEST",
               "Yuropu Apuee\u025b Ber\u025b",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Yuropu At\u0254ee\u025b Susudua Ber\u025b",
               "WET",
               "Yuropu At\u0254ee\u025b Awia Ber\u025b",
               "WEST",
               "Yuropu At\u0254ee\u025b Ber\u025b",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "M\u025bksiko Pasifik Susudua Ber\u025b",
               "MST",
               "M\u025bksiko Pasifik Awia Ber\u025b",
               "MDT",
               "M\u025bksiko Pasifik Ber\u025b",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Afrika Anaafo\u0254 Susudua Ber\u025b",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Mfinimfini Susudua Ber\u025b",
               "CST",
               "Mfinimfini Awia Ber\u025b",
               "CDT",
               "Mfinimfini Ber\u025b",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Apuee\u025b Susudua Ber\u025b",
               "EST",
               "Apuee\u025b Awia Ber\u025b",
               "EST",
               "Apuee\u025b Ber\u025b",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pasifik Susudua Ber\u025b",
               "PST",
               "Pasifik Awia Ber\u025b",
               "PDT",
               "Pasifik Ber\u025b",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Fr\u025bnkye Anaafo\u0254 ne Antaatik Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Geeb\u025bt Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian Susudua Ber\u025b",
               "HST",
               "Hawaii-Aleutian Awia Ber\u025b",
               "HST",
               "Hawaii-Aleutian Ber\u025b",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Finise Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon Susudua Ber\u025b",
               "",
               "St. Pierre & Miquelon Awia Ber\u025b",
               "",
               "St. Pierre & Miquelon Ber\u025b",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Bep\u0254 Susudua Ber\u025b",
               "MST",
               "Bep\u0254 Awia Ber\u025b",
               "MST",
               "Bep\u0254 Ber\u025b",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Mahyaa Aeland Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Gini Fofor\u0254 Ber\u025b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u0186strelia Mfinimfini Susudua Ber\u025b",
               "ACST",
               "\u0186strelia Mfinimfini Awia Ber\u025b",
               "ACDT",
               "\u0186strelia Mfinimfini Ber\u025b",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0186strelia Apuee\u025b Susudua Ber\u025b",
               "AEST",
               "\u0186strelia Apuee\u025b Awia Ber\u025b",
               "AEDT",
               "\u0186strelia Apuee\u025b Ber\u025b",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "\u0186strelia At\u0254ee\u025b Susudua Ber\u025b",
               "AWST",
               "\u0186strelia At\u0254ee\u025b Awia Ber\u025b",
               "AWDT",
               "\u0186strelia At\u0254ee\u025b Ber\u025b",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ind\u0254nehyia Mfinimfini Ber\u025b",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ind\u0254nehyia Apuee\u025b Ber\u025b",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ind\u0254nehyia At\u0254ee\u025b Ber\u025b",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0186strelia Mfinimfini At\u0254ee\u025b Susudua Ber\u025b",
               "",
               "\u0186strelia Mfinimfini At\u0254ee\u025b Awia Ber\u025b",
               "",
               "\u0186strelia Mfinimfini At\u0254ee\u025b Ber\u025b",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Amansan K\u0254dinat\u025bde Ber\u025b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Irelandfo\u0254 Susudua Ber\u025b",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Amansan K\u0254dinat\u025bde Ber\u025b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Amansan K\u0254dinat\u025bde Ber\u025b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Amansan K\u0254dinat\u025bde Ber\u025b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Amansan K\u0254dinat\u025bde Ber\u025b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Amansan K\u0254dinat\u025bde Ber\u025b",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Irelandfo\u0254 Susudua Ber\u025b",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Ber\u025b",
                    "GMT",
                    "Ingresi Awia Ber\u025b",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Kyita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Qatar", "Kata" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Dwuba" },
            { "timezone.excity.Asia/Almaty", "Aamati" },
            { "timezone.excity.Asia/Aqtobe", "Aktop\u025b" },
            { "timezone.excity.Asia/Beirut", "B\u025b\u025brut" },
            { "timezone.excity.Asia/Hebron", "H\u025bbr\u0254n" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Saigon", "Ho Kyi Min" },
            { "timezone.excity.Asia/Tehran", "T\u025b\u025bran" },
            { "timezone.excity.Asia/Urumqi", "Yurymki" },
            { "timezone.excity.Etc/Unknown", "Baabi a y\u025bnnim" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akraa" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Ceuta", "Kyuta" },
            { "timezone.excity.Africa/Dakar", "Dakaa" },
            { "timezone.excity.Africa/Lagos", "Leg\u0254s" },
            { "timezone.excity.Asia/Bangkok", "Bank\u0254k" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Jakarta", "Gyakaata" },
            { "timezone.excity.Asia/Karachi", "Karakyi" },
            { "timezone.excity.Asia/Kuching", "Kukyin" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Thimphu", "Timphu" },
            { "timezone.excity.Europe/Malta", "M\u0254\u0254ta" },
            { "timezone.excity.Europe/Sofia", "S\u0254fia" },
            { "timezone.excity.Indian/Cocos", "Kokoso" },
            { "timezone.excity.Pacific/Fiji", "Figyi" },
            { "timezone.excity.Pacific/Truk", "Kyuuk" },
            { "timezone.excity.Africa/Banjul", "Bandwuu" },
            { "timezone.excity.Africa/Bissau", "Bisaw" },
            { "timezone.excity.America/Belem", "B\u025bl\u025bm" },
            { "timezone.excity.America/Boise", "B\u0254isi" },
            { "timezone.excity.America/Jujuy", "Dwudwui" },
            { "timezone.excity.Asia/Calcutta", "K\u0254\u0254kata" },
            { "timezone.excity.Asia/Damascus", "Damask\u0254so" },
            { "timezone.excity.Asia/Jayapura", "Gyayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Makassar", "Makasa" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Berlin", "B\u025b\u025blin" },
            { "timezone.excity.Europe/Dublin", "D\u0254blin" },
            { "timezone.excity.Europe/Jersey", "J\u025b\u025bsi" },
            { "timezone.excity.Europe/Lisbon", "Lisb\u0254n" },
            { "timezone.excity.Europe/London", "L\u0254nd\u0254n" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "M\u0254sko" },
            { "timezone.excity.Europe/Skopje", "Sk\u0254pgye" },
            { "timezone.excity.Europe/Vienna", "Ve\u025bna" },
            { "timezone.excity.Europe/Warsaw", "W\u0254\u0254s\u0254\u0254" },
            { "timezone.excity.Europe/Zurich", "Zurekye" },
            { "timezone.excity.Indian/Chagos", "Kyag\u0254s" },
            { "timezone.excity.Indian/Comoro", "K\u0254m\u0254r\u0254" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abigyan" },
            { "timezone.excity.Africa/Algiers", "\u0186lgyese" },
            { "timezone.excity.Africa/Conakry", "K\u0254nakri" },
            { "timezone.excity.America/Belize", "B\u025blisi" },
            { "timezone.excity.America/Cayman", "Kemanfo" },
            { "timezone.excity.America/Cuiaba", "Kuiaba" },
            { "timezone.excity.America/Dawson", "D\u0254\u0254son" },
            { "timezone.excity.America/Denver", "D\u025bnva" },
            { "timezone.excity.America/Guyana", "Gayana" },
            { "timezone.excity.America/Maceio", "Makeio" },
            { "timezone.excity.America/Recife", "R\u025bsif\u025b" },
            { "timezone.excity.America/Regina", "R\u025bgyina" },
            { "timezone.excity.Asia/Jerusalem", "Yerusalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamkyatka" },
            { "timezone.excity.Asia/Singapore", "Singap\u0254" },
            { "timezone.excity.Asia/Vientiane", "Vienhyiane" },
            { "timezone.excity.Europe/Andorra", "And\u0254ra" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Indian/Mayotte", "Mayote" },
            { "timezone.excity.Pacific/Easter", "Easta" },
            { "timezone.excity.Pacific/Majuro", "Magyuro" },
            { "timezone.excity.Pacific/Ponape", "P\u0254npei" },
            { "timezone.excity.Africa/Blantyre", "Blantai" },
            { "timezone.excity.Africa/Djibouti", "Gyibuuti" },
            { "timezone.excity.Africa/Kinshasa", "Kinhyaahya" },
            { "timezone.excity.Africa/Ndjamena", "Ngyamena" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Cayenne", "Kayiini" },
            { "timezone.excity.America/Chicago", "Kyikago" },
            { "timezone.excity.America/Cordoba", "K\u0254\u0254d\u0254ba" },
            { "timezone.excity.America/Creston", "Kr\u025bston" },
            { "timezone.excity.America/Curacao", "Kurukaw" },
            { "timezone.excity.America/Detroit", "Detr\u0254it" },
            { "timezone.excity.America/Iqaluit", "Ikaluit" },
            { "timezone.excity.America/Jamaica", "Gyameka" },
            { "timezone.excity.America/Marigot", "Marig\u0254t" },
            { "timezone.excity.America/Mendoza", "M\u025bnd\u0254sa" },
            { "timezone.excity.America/Moncton", "M\u0254nktin" },
            { "timezone.excity.America/Ojinaga", "Ogyinaga" },
            { "timezone.excity.America/Phoenix", "Finisk" },
            { "timezone.excity.America/Tijuana", "Tidwuana" },
            { "timezone.excity.America/Tortola", "T\u0254\u0254tola" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Australia/Eucla", "Eukla" },
            { "timezone.excity.Australia/Perth", "P\u025b\u025bt" },
            { "timezone.excity.Europe/Belgrade", "B\u025blgrade" },
            { "timezone.excity.Europe/Brussels", "Br\u025bs\u025blse" },
            { "timezone.excity.Europe/Budapest", "Budap\u025bsh" },
            { "timezone.excity.Europe/Busingen", "Busingye" },
            { "timezone.excity.Europe/Chisinau", "Kyisinau" },
            { "timezone.excity.Europe/Helsinki", "H\u025blsinki" },
            { "timezone.excity.Europe/Sarajevo", "Saragyevo" },
            { "timezone.excity.Pacific/Chatham", "Kyatam" },
            { "timezone.excity.Pacific/Norfolk", "N\u0254\u0254f\u0254k" },
            { "timezone.excity.Africa/Bujumbura", "Budwumbura" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Barbados", "Baabados" },
            { "timezone.excity.America/Dominica", "D\u0254meneka" },
            { "timezone.excity.America/Edmonton", "Edm\u0254nton" },
            { "timezone.excity.America/Mazatlan", "Masatlan" },
            { "timezone.excity.America/New_York", "New Y\u0254k" },
            { "timezone.excity.America/Resolute", "R\u025bs\u0254lut" },
            { "timezone.excity.America/Winnipeg", "Winip\u025bg" },
            { "timezone.excity.Antarctica/Casey", "Kasi" },
            { "timezone.excity.Antarctica/Troll", "Tr\u0254\u0254" },
            { "timezone.excity.Asia/Ulaanbaatar", "Yulanbata" },
            { "timezone.excity.Atlantic/Bermuda", "B\u025bmuda" },
            { "timezone.excity.Atlantic/Stanley", "Stanli" },
            { "timezone.excity.Australia/Darwin", "Daawin" },
            { "timezone.excity.Australia/Hobart", "H\u0254bat" },
            { "timezone.excity.Australia/Sydney", "Sidni" },
            { "timezone.excity.Europe/Amsterdam", "Amstadam" },
            { "timezone.excity.Europe/Bucharest", "Bukyar\u025bst" },
            { "timezone.excity.Europe/Gibraltar", "Gyebrota" },
            { "timezone.excity.Europe/Ljubljana", "Ldwubdwana" },
            { "timezone.excity.Europe/Podgorica", "Podgorika" },
            { "timezone.excity.Europe/Stockholm", "St\u0254kh\u0254m" },
            { "timezone.excity.Indian/Christmas", "Buronya" },
            { "timezone.excity.Indian/Kerguelen", "K\u025bguel\u025bn" },
            { "timezone.excity.Indian/Mauritius", "M\u0254rihyi\u0254so" },
            { "timezone.excity.Pacific/Auckland", "Aukland" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkairne" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.America/Anchorage", "Ank\u0254ragyi" },
            { "timezone.excity.America/Catamarca", "Katamaaka" },
            { "timezone.excity.America/Chihuahua", "Kyihuahua" },
            { "timezone.excity.America/Fortaleza", "F\u0254\u0254tal\u025bsa" },
            { "timezone.excity.America/Goose_Bay", "Guus Bay" },
            { "timezone.excity.America/Guatemala", "Guwatemala" },
            { "timezone.excity.America/Guayaquil", "Gayakwuil" },
            { "timezone.excity.America/Matamoros", "Matam\u0254r\u0254so" },
            { "timezone.excity.America/Menominee", "M\u025bn\u0254minee" },
            { "timezone.excity.America/Monterrey", "M\u0254ntirii" },
            { "timezone.excity.Antarctica/Mawson", "M\u0254\u0254son" },
            { "timezone.excity.Antarctica/Palmer", "Paama" },
            { "timezone.excity.Antarctica/Vostok", "V\u0254st\u0254k" },
            { "timezone.excity.Europe/Copenhagen", "K\u0254p\u025bhang\u025bne" },
            { "timezone.excity.Europe/Luxembourg", "L\u025bsemb\u025bg" },
            { "timezone.excity.Pacific/Galapagos", "Galapag\u0254s" },
            { "timezone.excity.Pacific/Kwajalein", "Kwagyaleene" },
            { "timezone.excity.Pacific/Marquesas", "Maakesase" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.America/Costa_Rica", "K\u0254sta Rika" },
            { "timezone.excity.America/Grand_Turk", "Grand Tuk" },
            { "timezone.excity.America/Guadeloupe", "Guwadelup" },
            { "timezone.excity.America/Hermosillo", "H\u025bm\u0254silo" },
            { "timezone.excity.America/Kralendijk", "Kral\u025bngyik" },
            { "timezone.excity.America/Martinique", "Martinike" },
            { "timezone.excity.America/Metlakatla", "M\u025btlakatla" },
            { "timezone.excity.America/Montserrat", "Mantserat" },
            { "timezone.excity.America/Paramaribo", "Paramarib\u0254" },
            { "timezone.excity.America/Rio_Branco", "Rio Branko" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Yekaterinburg", "Y\u025bkat\u025brinb\u025bg" },
            { "timezone.excity.Atlantic/Reykjavik", "R\u025b\u025bkgyavik" },
            { "timezone.excity.America/El_Salvador", "El Salvad\u0254\u0254" },
            { "timezone.excity.America/Fort_Nelson", "F\u0254t N\u025blson" },
            { "timezone.excity.America/Los_Angeles", "L\u0254s Angy\u025blis" },
            { "timezone.excity.America/Mexico_City", "M\u025bksiko Siti" },
            { "timezone.excity.America/Porto_Velho", "P\u0254\u0254to Velho" },
            { "timezone.excity.America/Puerto_Rico", "Pu\u025bto Riko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kepv\u025bde" },
            { "timezone.excity.Australia/Lord_Howe", "L\u0254d Howe" },
            { "timezone.excity.Australia/Melbourne", "M\u025b\u025bb\u0254n" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadaakanaa" },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sabl\u0254n" },
            { "timezone.excity.America/Campo_Grande", "Kampo Grande" },
            { "timezone.excity.America/Dawson_Creek", "D\u0254\u0254son Kreek" },
            { "timezone.excity.America/Indianapolis", "Indianap\u0254lis" },
            { "timezone.excity.America/Scoresbysund", "Yitok\u0254tu\u0254mete" },
            { "timezone.excity.Antarctica/Macquarie", "Makaari" },
            { "timezone.excity.Pacific/Port_Moresby", "P\u0254t Mor\u025bsbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kambrigyi Bay" },
            { "timezone.excity.America/Lower_Princes", "Lowa Prinse K\u0254ta" },
            { "timezone.excity.America/Port_of_Spain", "Spain P\u0254\u0254to" },
            { "timezone.excity.America/St_Barthelemy", "St. Baatilemi" },
            { "timezone.excity.America/Swift_Current", "Swift K\u025br\u025bnt" },
            { "timezone.excity.Australia/Broken_Hill", "Br\u0254ken Hill" },
            { "timezone.excity.Atlantic/South_Georgia", "Gy\u0254\u0254gyia Anaafo\u0254" },
            { "timezone.excity.America/Indiana/Winamac", "Winamak, Indiana" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell Siti, Indiana" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Riogya" },
            { "timezone.excity.America/Argentina/San_Juan", "San Dwuan" },
            { "timezone.excity.America/Indiana/Petersburg", "Pit\u025bsb\u025bgye, Indiana" },
            { "timezone.excity.America/Kentucky/Monticello", "M\u0254ntis\u025blo, K\u025bnt\u025bki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beula, N\u0254f Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "S\u025bnta, N\u0254f Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Galleg\u0254s" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Sal\u025bm, N\u0254f Dakota" },
        };
        return data;
    }
}
