/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_id extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BG = "Bulgaria";
        final String metaValue_CZ = "Ceko";
        final String metaValue_DE = "Jerman";
        final String metaValue_GR = "Yunani";
        final String metaValue_ES = "Spanyol";
        final String metaValue_EE = "Estonia";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Prancis";
        final String metaValue_IE = "Irlandia";
        final String metaValue_HR = "Kroasia";
        final String metaValue_HU = "Hungaria";
        final String metaValue_AM = "Armenia";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IS = "Islandia";
        final String metaValue_IT = "Italia";
        final String metaValue_JP = "Jepang";
        final String metaValue_GE = "Georgia";
        final String metaValue_LU = "Luksemburg";
        final String metaValue_LT = "Lituania";
        final String metaValue_LV = "Latvia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NR = "Nauru";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norwegia";
        final String metaValue_RO = "Rumania";
        final String metaValue_RU = "Rusia";
        final String metaValue_SI = "Slovenia";
        final String metaValue_WS = "Samoa";
        final String metaValue_SO = "Somalia";
        final String metaValue_AL = "Albania";
        final String metaValue_RS = "Serbia";
        final String metaValue_SE = "Swedia";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_UA = "Ukraina";
        final String metaValue_VN = "Vietnam";
        final String metaValue_PW = "Palau";
        final String metaValue_SY = "Suriah";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ae = "Avesta";
        final String metaValue_bn = "Bengali";
        final String metaValue_zbl = "Blissymbol";
        final String metaValue_bug = "Bugis";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptik";
        final String metaValue_CY = "Siprus";
        final String metaValue_ET = "Etiopia";
        final String metaValue_gu = "Gujarat";
        final String metaValue_he = "Ibrani";
        final String metaValue_jv = "Jawa";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_LA = "Laos";
        final String metaValue_la = "Latin";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Oriya";
        final String metaValue_osa = "Osage";
        final String metaValue_pal = "Pahlevi";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sunda";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibet";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Persia Kuno";
        final String metaValue_ssy = "Saho";
        final String metaValue_key_nu = "Angka";
        final Object[][] data = new Object[][] {
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "005", "Amerika Selatan" },
            { "009", "Oseania" },
            { "011", "Afrika Bagian Barat" },
            { "013", "Amerika Tengah" },
            { "014", "Afrika Bagian Timur" },
            { "015", "Afrika Bagian Utara" },
            { "017", "Afrika Bagian Tengah" },
            { "018", "Afrika Bagian Selatan" },
            { "019", "Amerika" },
            { "021", "Amerika Bagian Utara" },
            { "029", "Kepulauan Karibia" },
            { "030", "Asia Bagian Timur" },
            { "034", "Asia Bagian Selatan" },
            { "035", "Asia Tenggara" },
            { "039", "Eropa Bagian Selatan" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Wilayah Mikronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Tengah" },
            { "145", "Asia Bagian Barat" },
            { "150", "Eropa" },
            { "151", "Eropa Bagian Timur" },
            { "154", "Eropa Bagian Utara" },
            { "155", "Eropa Bagian Barat" },
            { "202", "Afrika Sub-Sahara" },
            { "419", "Amerika Latin" },
            { "AC", "Pulau Ascension" },
            { "AD", "Andorra" },
            { "AE", "Uni Emirat Arab" },
            { "AF", "Afganistan" },
            { "AG", "Antigua dan Barbuda" },
            { "AI", "Anguilla" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Samoa Amerika" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Kepulauan Aland" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia dan Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Belanda Karibia" },
            { "BR", "Brasil" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kepulauan Cocos (Keeling)" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Swiss" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Cile" },
            { "CM", "Kamerun" },
            { "CN", "Tiongkok" },
            { "CO", "Kolombia" },
            { "CP", "Pulau Clipperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Tanjung Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Pulau Natal" },
            { "CY", metaValue_CY },
            { "CZ", metaValue_CZ },
            { "DE", metaValue_DE },
            { "DG", "Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Denmark" },
            { "DM", "Dominika" },
            { "DO", "Republik Dominika" },
            { "DZ", "Aljazair" },
            { "EA", "Ceuta dan Melilla" },
            { "EC", "Ekuador" },
            { "EE", metaValue_EE },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "ER", "Eritrea" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "Uni Eropa" },
            { "EZ", "Zona Euro" },
            { "FI", "Finlandia" },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Falkland" },
            { "FM", "Mikronesia" },
            { "FO", "Kepulauan Faroe" },
            { "FR", metaValue_FR },
            { "GA", "Gabon" },
            { "GB", "Inggris Raya" },
            { "GD", "Grenada" },
            { "GE", metaValue_GE },
            { "GF", "Guyana Prancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Ekuatorial" },
            { "GR", metaValue_GR },
            { "GS", "Georgia Selatan & Kep. Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong DAK Tiongkok" },
            { "HM", "Pulau Heard dan Kepulauan McDonald" },
            { "HN", "Honduras" },
            { "HR", metaValue_HR },
            { "HT", "Haiti" },
            { "HU", metaValue_HU },
            { "IC", "Kepulauan Canaria" },
            { "ID", metaValue_ID },
            { "IE", metaValue_IE },
            { "IL", "Israel" },
            { "IM", "Pulau Man" },
            { "IN", "India" },
            { "IO", "Wilayah Inggris di Samudra Hindia" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Yordania" },
            { "JP", metaValue_JP },
            { "KE", "Kenya" },
            { "KG", "Kirgizstan" },
            { "KH", "Kamboja" },
            { "KI", "Kiribati" },
            { "KM", "Komoro" },
            { "KN", "Saint Kitts dan Nevis" },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "KW", "Kuwait" },
            { "KY", "Kepulauan Cayman" },
            { "KZ", "Kazakhstan" },
            { "LA", metaValue_LA },
            { "LB", "Lebanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "Libya" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Kepulauan Marshall" },
            { "MK", "Makedonia Utara" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", metaValue_MN },
            { "MO", "Makau DAK Tiongkok" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinik" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "MV", "Maladewa" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Baru" },
            { "NE", "Niger" },
            { "NF", "Kepulauan Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Selandia Baru" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesia Prancis" },
            { "PG", "Papua Nugini" },
            { "PH", "Filipina" },
            { "PK", "Pakistan" },
            { "PL", "Polandia" },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "PR", "Puerto Riko" },
            { "PS", "Wilayah Palestina" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oseania Luar" },
            { "RE", "R\u00e9union" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "SA", "Arab Saudi" },
            { "SB", "Kepulauan Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", metaValue_SE },
            { "SG", "Singapura" },
            { "SH", "Saint Helena" },
            { "SI", metaValue_SI },
            { "SJ", "Kepulauan Svalbard dan Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", metaValue_SO },
            { "SR", "Suriname" },
            { "SS", "Sudan Selatan" },
            { "ST", "Sao Tome dan Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", metaValue_SY },
            { "SZ", "eSwatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "TD", "Chad" },
            { "TF", "Wilayah Selatan Prancis" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", metaValue_TK },
            { "TL", "Timor Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "Trinidad dan Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", metaValue_UA },
            { "UG", "Uganda" },
            { "UM", "Kepulauan Terluar AS" },
            { "UN", "Perserikatan Bangsa-Bangsa" },
            { "US", "Amerika Serikat" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Saint Vincent dan Grenadine" },
            { "VE", "Venezuela" },
            { "VG", "Kepulauan Virgin Britania Raya" },
            { "VI", "Kepulauan Virgin Amerika Serikat" },
            { "VN", metaValue_VN },
            { "VU", "Vanuatu" },
            { "WF", "Kepulauan Wallis dan Futuna" },
            { "WS", metaValue_WS },
            { "XA", "Aksen Asing" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yaman" },
            { "YT", "Mayotte" },
            { "ZA", "Afrika Selatan" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Wilayah Tidak Dikenal" },
            { "aa", "Afar" },
            { "ab", "Abkhaz" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharik" },
            { "an", "Aragon" },
            { "ar", "Arab" },
            { "as", "Assam" },
            { "av", "Avar" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "be", "Belarusia" },
            { "bg", metaValue_BG },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Breton" },
            { "bs", "Bosnia" },
            { "ca", "Katalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Korsika" },
            { "cr", "Kree" },
            { "cs", metaValue_CZ },
            { "cu", "Bahasa Gereja Slavonia" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Dansk" },
            { "de", metaValue_DE },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_GR },
            { "en", "Inggris" },
            { "eo", "Esperanto" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "Basque" },
            { "fa", "Persia" },
            { "ff", "Fula" },
            { "fi", "Suomi" },
            { "fj", metaValue_FJ },
            { "fo", "Faroe" },
            { "fr", metaValue_FR },
            { "fy", "Frisia Barat" },
            { "ga", metaValue_IE },
            { "gd", "Gaelik Skotlandia" },
            { "gl", "Galisia" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", metaValue_HR },
            { "ht", "Kreol Haiti" },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", metaValue_ID },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiak" },
            { "io", "Ido" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "Inuktitut" },
            { "ja", metaValue_JP },
            { "jv", metaValue_jv },
            { "ka", metaValue_GE },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmir" },
            { "ku", "Kurdi" },
            { "kv", "Komi" },
            { "kw", "Kornish" },
            { "ky", "Kirgiz" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "Ganda" },
            { "li", "Limburgia" },
            { "ln", "Lingala" },
            { "lo", "Lao" },
            { "lt", metaValue_LT },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Malagasi" },
            { "mh", "Marshall" },
            { "mi", "Maori" },
            { "mk", "Makedonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "Marathi" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "my", "Burma" },
            { "na", metaValue_NR },
            { "nb", "Bokm\u00e5l Norwegia" },
            { "nd", "Ndebele Utara" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", metaValue_NL },
            { "nn", "Nynorsk Norwegia" },
            { "no", metaValue_NO },
            { "nr", "Ndebele Selatan" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Ositania" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetia" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Polski" },
            { "ps", "Pashto" },
            { "pt", "Portugis" },
            { "qu", "Quechua" },
            { "rm", "Reto-Roman" },
            { "rn", "Rundi" },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskerta" },
            { "sc", "Sardinia" },
            { "sd", "Sindhi" },
            { "se", "Sami Utara" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroasia" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "Shona" },
            { "so", metaValue_SO },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "Swati" },
            { "st", "Sotho Selatan" },
            { "su", metaValue_su },
            { "sv", metaValue_SE },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "ug", "Uyghur" },
            { "uk", metaValue_UA },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", metaValue_VN },
            { "vo", "Volapuk" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Tionghoa" },
            { "zu", "Zulu" },
            { "ace", "Aceh" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adygei" },
            { "aeb", "Arab Tunisia" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Akkadia" },
            { "akz", "Alabama" },
            { "ale", "Aleut" },
            { "alt", "Altai Selatan" },
            { "ang", "Inggris Kuno" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arc", "Aram" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "arq", "Arab Aljazair" },
            { "ars", "Arab Najdi" },
            { "arw", "Arawak" },
            { "ary", "Arab Maroko" },
            { "arz", "Arab Mesir" },
            { "asa", "Asu" },
            { "ase", "Bahasa Isyarat Amerika" },
            { "ast", "Asturia" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "bal", "Baluchi" },
            { "ban", "Bali" },
            { "bar", "Bavaria" },
            { "bas", "Basa" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bgc", "Haryanvi" },
            { "bgn", "Balochi Barat" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bjn", "Banjar" },
            { "bkm", "Kom" },
            { "bla", "Siksika" },
            { "blo", "Anii" },
            { "bra", "Braj" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buriat" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Kado" },
            { "car", "Karibia" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Kiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Chuuke" },
            { "chm", "Mari" },
            { "chn", "Jargon Chinook" },
            { "cho", "Koktaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Kurdi Sorani" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "Michif" },
            { "crh", "Tatar Krimea" },
            { "crj", "East Cree Selatan" },
            { "crk", "Cree Dataran" },
            { "crl", "East Cree Utara" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "crs", "Seselwa Kreol Prancis" },
            { "csb", "Kashubia" },
            { "csw", "Cree Rawa" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Sorbia Hilir" },
            { "dua", "Duala" },
            { "dum", "Belanda Abad Pertengahan" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "Mesir Kuno" },
            { "eka", "Ekajuk" },
            { "elx", "Elam" },
            { "enm", "Inggris Abad Pertengahan" },
            { "ewo", "Ewondo" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipino" },
            { "fon", "Fon" },
            { "frc", "Prancis Cajun" },
            { "frm", "Prancis Abad Pertengahan" },
            { "fro", "Prancis Kuno" },
            { "frp", "Arpitan" },
            { "frr", "Frisia Utara" },
            { "frs", "Frisia Timur" },
            { "fur", "Friuli" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gez", "Geez" },
            { "gil", "Gilbert" },
            { "glk", "Gilaki" },
            { "gmh", "Jerman Abad Pertengahan" },
            { "goh", "Jerman Kuno" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", "Gotik" },
            { "grb", "Grebo" },
            { "grc", "Yunani Kuno" },
            { "gsw", "Jerman (Swiss)" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u2019in" },
            { "hai", "Haida" },
            { "haw", "Hawaii" },
            { "hax", "Haida Selatan" },
            { "hif", "Hindi Fiji" },
            { "hil", "Hiligaynon" },
            { "hit", "Hitit" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbia Hulu" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Inuktitut Kanada Barat" },
            { "ilo", "Iloko" },
            { "inh", "Ingushetia" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Ibrani-Persia" },
            { "jrb", "Ibrani-Arab" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardi" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "kho", "Khotan" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "kos", "Kosre" },
            { "kpe", metaValue_kpe },
            { "krc", "Karachai Balkar" },
            { "kri", "Krio" },
            { "krl", "Karelia" },
            { "kru", "Kuruk" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Dialek Kolsch" },
            { "kum", "Kumyk" },
            { "kut", "Kutenai" },
            { "kwk", "Kwak\u02bcwala" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lezghia" },
            { "lij", "Liguria" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lmo", "Lombard" },
            { "lol", "Mongo" },
            { "lou", "Kreol Louisiana" },
            { "loz", "Lozi" },
            { "lrc", "Luri Utara" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "lzz", "Laz" },
            { "mad", "Madura" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisien" },
            { "mga", "Irlandia Abad Pertengahan" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Mikmak" },
            { "min", "Minangkabau" },
            { "mnc", "Manchuria" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Beberapa Bahasa" },
            { "mus", "Bahasa Muskogee" },
            { "mwl", "Miranda" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Eryza" },
            { "mzn", "Mazanderani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Jerman Rendah" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuea" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Norse Kuno" },
            { "nqo", metaValue_nqo },
            { "nso", "Sotho Utara" },
            { "nus", "Nuer" },
            { "nwc", "Newari Klasik" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "ojb", "Ojibwe Barat Laut" },
            { "ojc", "Ojibwe Tengah" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Ojibwe Barat" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "ota", "Turki Osmani" },
            { "pag", "Pangasina" },
            { "pal", metaValue_pal },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", metaValue_PW },
            { "pcm", "Pidgin Nigeria" },
            { "pdc", "Jerman Pennsylvania" },
            { "peo", metaValue_peo },
            { "phn", "Funisia" },
            { "pis", "Pijin" },
            { "pon", "Pohnpeia" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prusia" },
            { "pro", "Provencal Lama" },
            { "quc", "K\u02bciche\u02bc" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotonga" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rom", "Romani" },
            { "rtm", "Rotuma" },
            { "rup", "Aromania" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sam", "Aram Samaria" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "sba", "Ngambai" },
            { "sbp", "Sangu" },
            { "scn", "Sisilia" },
            { "sco", "Skotlandia" },
            { "sdh", "Kurdi Selatan" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Irlandia Kuno" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "shu", "Arab Suwa" },
            { "sid", "Sidamo" },
            { "slh", "Lushootseed Selatan" },
            { "sli", "Silesia Rendah" },
            { "sly", "Selayar" },
            { "sma", "Sami Selatan" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdien" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "str", "Salish Selat" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Sumeria" },
            { "swb", "Komoria" },
            { "syc", "Suriah Klasik" },
            { "syr", metaValue_SY },
            { "szl", "Silesia" },
            { "tce", "Tutchone Selatan" },
            { "tcy", "Tulu" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetun" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", metaValue_TK },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "tsi", "Tsimshia" },
            { "ttm", "Tutchone Utara" },
            { "ttt", "Tat Muslim" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinia" },
            { "tzm", "Tamazight Maroko Tengah" },
            { "udm", "Udmurt" },
            { "uga", "Ugarit" },
            { "umb", "Umbundu" },
            { "und", "Bahasa Tidak Dikenal" },
            { "vai", metaValue_vai },
            { "vec", "Venesia" },
            { "vmw", "Makhuwa" },
            { "vot", "Votia" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Walamo" },
            { "war", "Warai" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Tionghoa" },
            { "xal", "Kalmuk" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapois" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kanton" },
            { "zap", "Zapotek" },
            { "zbl", metaValue_zbl },
            { "zen", "Zenaga" },
            { "zgh", "Tamazight Maroko Standar" },
            { "zun", "Zuni" },
            { "zxx", "Tidak ada konten linguistik" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Albania Kaukasia" },
            { "Aran", "Nastaliq" },
            { "Armi", "Aram Imperial" },
            { "Armn", metaValue_AM },
            { "Avst", metaValue_ae },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "Bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Simbol Aborigin Kanada Kesatuan" },
            { "Cari", "Karia" },
            { "Cher", metaValue_chr },
            { "Chrs", "Chorasmian" },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cpmn", "Cypro-Minoan" },
            { "Cprt", metaValue_CY },
            { "Cyrl", "Sirilik" },
            { "Cyrs", "Gereja Slavonia Sirilik Lama" },
            { "Deva", "Dewanagari" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Stenografi Duployan" },
            { "Egyd", "Demotik Mesir" },
            { "Egyh", "Hieratik Mesir" },
            { "Egyp", "Hieroglip Mesir" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaic" },
            { "Ethi", metaValue_ET },
            { "Geok", "Georgian Khutsuri" },
            { "Geor", metaValue_GE },
            { "Glag", "Glagolitic" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", "Gothic" },
            { "Gran", "Grantha" },
            { "Grek", metaValue_GR },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han dengan Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Sederhana" },
            { "Hant", "Tradisional" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Hieroglif Anatolia" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "Katakana atau Hiragana" },
            { "Hung", "Hungaria Kuno" },
            { "Inds", "Indus" },
            { "Ital", "Italia Lama" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_JP },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Skrip kecil Khitan" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_LA },
            { "Latf", "Latin Fraktur" },
            { "Latg", "Latin Gaelik" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Lycia" },
            { "Lydi", "Lydia" },
            { "Mahj", "Mahajani" },
            { "Maka", "Makassar" },
            { "Mand", "Mandae" },
            { "Mani", "Manikhei" },
            { "Marc", "Marchen" },
            { "Maya", "Hieroglip Maya" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Kursif Meroitik" },
            { "Mero", "Meroitik" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_MN },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", "Myanmar" },
            { "Nand", "Nandinagari" },
            { "Narb", "Arab Utara Kuno" },
            { "Nbat", "Nabataea" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nushu" },
            { "Ogam", "Ogham" },
            { "Olck", "Chiki Lama" },
            { "Orkh", "Orkhon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Uyghur Lama" },
            { "Palm", "Palmira" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Permik Kuno" },
            { "Phag", "Phags-pa" },
            { "Phli", metaValue_pal },
            { "Phlp", "Mazmur Pahlevi" },
            { "Phlv", "Kitab Pahlevi" },
            { "Phnx", "Phoenix" },
            { "Plrd", "Fonetik Pollard" },
            { "Prti", "Prasasti Parthia" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runik" },
            { "Samr", "Samaria" },
            { "Sara", "Sarati" },
            { "Sarb", "Arab Selatan Kuno" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "Tulisan Isyarat" },
            { "Shaw", "Shavia" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdian" },
            { "Sogo", "Sogdian Lama" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_SY },
            { "Syre", "Suriah Estrangelo" },
            { "Syrj", "Suriah Barat" },
            { "Syrn", "Suriah Timur" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue Baru" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Teng", "Tenghwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Toto", "Toto (txo)" },
            { "Ugar", "Ugaritik" },
            { "Vaii", metaValue_vai },
            { "Visp", "Ucapan Terlihat" },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Wole", "Woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Cuneiform Sumero-Akkadia" },
            { "Yezi", "Yezidi" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar Square" },
            { "Zinh", "Warisan" },
            { "Zmth", "Notasi Matematika" },
            { "Zsye", "Emoji" },
            { "Zsym", "Simbol" },
            { "Zxxx", "Tidak Tertulis" },
            { "Zyyy", "Umum" },
            { "Zzzz", "Skrip Tidak Dikenal" },
            { "de_CH", "Jerman Tinggi (Swiss)" },
            { "en_GB", "Inggris (Britania)" },
            { "es_ES", "Spanyol (Eropa)" },
            { "fa_AF", "Persia Dari" },
            { "pt_PT", "Portugis (Eropa)" },
            { "ro_MD", "Moldavia" },
            { "sw_CD", "Swahili (Kongo)" },
            { "%%1901", "Ortografi Jerman Tradisional" },
            { "%%1994", "Ortografi Resia Standar" },
            { "%%1996", "Ortografi Jerman 1996" },
            { "ar_001", "Arab Standar Modern" },
            { "key.ca", "Kalender" },
            { "key.cf", "Format Mata Uang" },
            { "key.co", "Aturan Pengurutan" },
            { "key.cu", "Mata Uang" },
            { "key.hc", "Siklus Jam (12 vs 24)" },
            { "key.lb", "Gaya Pemisah Baris" },
            { "key.ms", "Sistem Pengukuran" },
            { "key.nu", metaValue_key_nu },
            { "key.tz", "Zona Waktu" },
            { "key.va", "Varian Lokal" },
            { "%%ALUKU", "Dialek Aluku" },
            { "%%BARLA", "Kelompok dialek Barlavento Kabuverdianu" },
            { "%%BISKE", "Dialek San Giorgio/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%CORNU", "Cornu" },
            { "%%KKCOR", "Ortografi Umum" },
            { "%%LIPAW", "Dialek Lipovaz Resia" },
            { "%%NEDIS", "Dialek Natiso" },
            { "%%NJIVA", "Dialek Gniva/Njiva" },
            { "%%OSOJS", "Dialek Oseacco/Osojane" },
            { "%%POSIX", "Komputer" },
            { "%%ROZAJ", "Resia" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Dialek Stolvizza/Solbica" },
            { "%%UCCOR", "Ortografi Terpadu" },
            { "%%AO1990", "Perjanjian Ortografi Bahasa Portugis 1990" },
            { "%%ARANES", "ARAN" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvern" },
            { "%%CISAUP", "Cisaup" },
            { "%%CREISS", "Creiss" },
            { "%%DAJNKO", "Alfabet Dajnko" },
            { "%%FONIPA", "Fonetik IPA" },
            { "%%FONUPA", "Fonetik UPA" },
            { "%%NDYUKA", "Dialek Ndyuka" },
            { "%%PAMAKA", "Dialek Pamaka" },
            { "%%PINYIN", "Pinyin Latin" },
            { "%%SCOUSE", "Skaus" },
            { "%%TARASK", "Ortografi Taraskievica" },
            { "%%UCRCOR", "Ortografi Revisi Terpadu" },
            { "%%ABL1943", "Formulasi ortografi 1943" },
            { "%%AKUAPEM", "AKUAPIM" },
            { "%%ALALC97", "ALA-LC Latin, edisi 1997" },
            { "%%AREVELA", "Armenia Timur" },
            { "%%AREVMDA", "Armenia Barat" },
            { "%%ARKAIKA", "Arkaika" },
            { "%%BALANKA", "Dialek Balanka Anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "Alfabet Bohori\u010d" },
            { "%%HEPBURN", "Hepburn Latin" },
            { "%%MONOTON", "Monoton" },
            { "%%POLYTON", "Politon" },
            { "%%REVISED", "Ortografi Revisi" },
            { "%%1606NICT", "Prancis Pertengahan Akhir sampai 1606" },
            { "%%1694ACAD", "Prancis Modern Awal" },
            { "%%1959ACAD", "Akademik" },
            { "%%BAKU1926", "Alfabet Latin Turki Terpadu" },
            { "%%BASICENG", "Basiceng" },
            { "%%BISCAYAN", "BISKAY" },
            { "%%BORNHOLM", "Bornholm" },
            { "%%COLB1945", "Konvensi Ortografi Portugis-Brasil 1945" },
            { "%%HOGNORSK", "NORWEDIA TINGGI" },
            { "%%SCOTLAND", "Inggris Standar Skotlandia" },
            { "%%VALENCIA", "Valencia" },
            { "%%WADEGILE", "Wade-Giles Latin" },
            { "type.ca.roc", "Kalender Min-guo" },
            { "type.co.eor", "Aturan Pengurutan Eropa" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "type.m0.bgn", "Transliterasi BGN AS" },
            { "type.nu.ahom", "Angka Ahom" },
            { "type.nu.arab", "Angka Arab Timur" },
            { "type.nu.armn", "Angka Armenia" },
            { "type.nu.bali", "Angka Bali" },
            { "type.nu.beng", "Angka Bengali" },
            { "type.nu.brah", "Angka Brahmi" },
            { "type.nu.cakm", "Angka Chakma" },
            { "type.nu.cham", "Angka Cham" },
            { "type.nu.cyrl", "Angka Sirilik" },
            { "type.nu.deva", "Angka Dewanagari" },
            { "type.nu.diak", "Angka Dives Akuru" },
            { "type.nu.ethi", "Angka Etiopia" },
            { "type.nu.geor", "Angka Georgia" },
            { "type.nu.gong", "Angka Gunjala Gondi" },
            { "type.nu.gonm", "Angka Masaram Gondi" },
            { "type.nu.grek", "Angka Yunani" },
            { "type.nu.gujr", "Angka Gujarat" },
            { "type.nu.guru", "Angka Gurmukhi" },
            { "type.nu.hans", "Angka Tionghoa Sederhana" },
            { "type.nu.hant", "Angka Tionghoa Tradisional" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "type.nu.hmng", "Angka Pahawh Hmong" },
            { "type.nu.hmnp", "Angka Nyiakeng Puachue Hmong" },
            { "type.nu.java", "Angka Jawa" },
            { "type.nu.jpan", "Angka Jepang" },
            { "type.nu.kali", "Angka Kayah Li" },
            { "type.nu.khmr", "Angka Khmer" },
            { "type.nu.knda", "Angka Kannada" },
            { "type.nu.lana", "Angka Tai Tham Hora" },
            { "type.nu.laoo", "Angka Laos" },
            { "type.nu.latn", "Angka Latin" },
            { "type.nu.lepc", "Angka Lepcha" },
            { "type.nu.limb", "Angka Limbu" },
            { "type.nu.mlym", "Angka Malayalam" },
            { "type.nu.modi", "Angka Modi" },
            { "type.nu.mong", "Angka Mongolia" },
            { "type.nu.mroo", "Angka Mro" },
            { "type.nu.mtei", "Angka Meetei Mayek" },
            { "type.nu.mymr", "Angka Myanmar" },
            { "type.nu.nkoo", "Angka N\u2019Ko" },
            { "type.nu.olck", "Angka Ol Chiki" },
            { "type.nu.orya", "Angka Oriya" },
            { "type.nu.osma", "Angka Osmanya" },
            { "type.nu.rohg", "Angka Hanifi Rohingya" },
            { "type.nu.saur", "Angka Saurashtra" },
            { "type.nu.shrd", "Angka Sharada" },
            { "type.nu.sind", "Angka Khudawadi" },
            { "type.nu.sinh", "Angka Sinhala Lith" },
            { "type.nu.sora", "Angka Sora Sompeng" },
            { "type.nu.sund", "Angka Sunda" },
            { "type.nu.takr", "Angka Takri" },
            { "type.nu.talu", "Angka Tai Lue Baru" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "type.nu.telu", "Angka Telugu" },
            { "type.nu.thai", "Angka Thai" },
            { "type.nu.tibt", "Angka Tibet" },
            { "type.nu.tirh", "Angka Tirhuta" },
            { "type.nu.vaii", "Angka Vai" },
            { "type.nu.wara", "Angka Warang Citi" },
            { "type.nu.wcho", "Angka Wancho" },
            { "type.ca.dangi", "Kalender Dangi" },
            { "type.co.ducet", "Aturan Pengurutan Unicode Default" },
            { "type.co.emoji", "Urutan Sortir Emoji" },
            { "type.lb.loose", "Gaya Pemisah Baris Renggang" },
            { "type.nu.roman", "Angka Romawi" },
            { "type.ca.coptic", "Kalender Koptik" },
            { "type.ca.hebrew", "Kalender Ibrani" },
            { "type.ca.indian", "Kalender Nasional India" },
            { "type.co.compat", "Aturan Pengurutan Sebelumnya, untuk kompatibilitas" },
            { "type.co.pinyin", "Aturan Pengurutan Pinyin" },
            { "type.co.search", "Pencarian Tujuan Umum" },
            { "type.co.stroke", "Aturan Pengurutan Guratan" },
            { "type.co.unihan", "Aturan Pengurutan Guratan Radikal" },
            { "type.co.zhuyin", "Aturan Pengurutan Zhuyin" },
            { "type.d0.fwidth", "Lebar penuh" },
            { "type.d0.hwidth", "Lebar separuh" },
            { "type.lb.normal", "Gaya Pemisah Baris Normal" },
            { "type.lb.strict", "Gaya Pemisah Baris Rapat" },
            { "type.m0.ungegn", "Transliterasi GEGN PBB" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.nu.native", "Angka Asli" },
            { "type.ca.chinese", "Kalender Tionghoa" },
            { "type.ca.islamic", "Kalender Islam" },
            { "type.ca.iso8601", "Kalender ISO-8601" },
            { "type.ca.persian", "Kalender Persia" },
            { "type.cf.account", "Format Mata Uang Akuntansi" },
            { "type.co.big5han", "Aturan Pengurutan Tionghoa Tradisional - Big5" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "Angka Arab Timur Diperluas" },
            { "type.nu.armnlow", "Angka Huruf Kecil Armenia" },
            { "type.nu.finance", "Angka Finansial" },
            { "type.nu.greklow", "Angka Yunani Huruf Kecil" },
            { "type.nu.hanidec", "Angka Desimal Tionghoa" },
            { "type.nu.hansfin", "Angka Keuangan Tionghoa Sederhana" },
            { "type.nu.hantfin", "Angka Keuangan Tionghoa Tradisional" },
            { "type.nu.jpanfin", "Angka Keuangan Jepang" },
            { "type.nu.mathdbl", "Angka Double-Struck Matematika" },
            { "type.nu.tamldec", "Angka Tamil" },
            { "type.ca.buddhist", "Kalender Buddha" },
            { "type.ca.ethiopic", "Kalender Etiopia" },
            { "type.ca.japanese", "Kalender Jepang" },
            { "type.cf.standard", "Format Mata Uang Standar" },
            { "type.co.phonetic", "Aturan Pengurutan Fonetik" },
            { "type.co.searchjl", "Pencarian Menurut Konsonan Awal Hangul" },
            { "type.co.standard", "Aturan Pengurutan Standar" },
            { "type.ms.uksystem", "Sistem Pengukuran Imperial" },
            { "type.ms.ussystem", "Sistem Pengukuran AS" },
            { "type.nu.fullwide", "Angka Lebar Penuh" },
            { "type.nu.lanatham", "Angka Tai Tham Tham" },
            { "type.nu.mathbold", "Angka Tebal Matematika" },
            { "type.nu.mathmono", "Angka Monospace Matematika" },
            { "type.nu.mathsanb", "Angka Tebal Sans-Serif Matematika" },
            { "type.nu.mathsans", "Angka Sans-Serif Matematika" },
            { "type.nu.mymrshan", "Angka Myanmar Shan" },
            { "type.nu.mymrtlng", "Angka Myanmar Tai Laing" },
            { "type.nu.romanlow", "Angka Huruf Kecil Romawi" },
            { "type.ca.gregorian", "Kalender Gregorian" },
            { "type.co.gb2312han", "Aturan Pengurutan Tionghoa (Sederhana) - GB2312" },
            { "type.co.phonebook", "Aturan Pengurutan Buku Telepon" },
            { "type.co.dictionary", "Aturan Pengurutan Kamus" },
            { "type.co.traditional", "Aturan Pengurutan Tradisional" },
            { "type.nu.traditional", "Angka Tradisional" },
            { "type.ca.islamic-rgsa", "Kalender Islam (Arab Saudi, penglihatan)" },
            { "type.ca.islamic-tbla", "Kalender Astronomi Islam" },
            { "type.ca.islamic-civil", "Kalender Sipil Islam" },
            { "type.ca.islamic-umalqura", "Kalender Islam (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Kalender Amete Alem Etiopia" },
        };
        return data;
    }
}
