/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_bal_Latn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Grinwech Min Wahd",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Api\u00e1ay anj\u00e1ri wahd",
               "",
               "Api\u00e1ay r\u00f3chi wahd",
               "",
               "Api\u00e1ay wahd",
               "",
            };
        final String[] Cook = new String[] {
               "Kuk Isl\u00e1nday anj\u00e1ri wahd",
               "",
               "Kuk Isl\u00e1nday n\u00e9m-garm\u00e1gi wahd",
               "",
               "Kuk Isl\u00e1nday wahd",
               "",
            };
        final String[] Cuba = new String[] {
               "Kyub\u00e1ay anj\u00e1ri wahd",
               "CST",
               "Kyub\u00e1ay r\u00f3chay wahd",
               "CDT",
               "Kyub\u00e1ay wahd",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fijiay anj\u00e1ri wahd",
               "",
               "Fijiay garm\u00e1gi wahd",
               "",
               "Fijiay wahd",
               "",
            };
        final String[] Gulf = new String[] {
               "Khalijay anj\u00e1ri wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "H\u00f3wday anj\u00e1ri wahd",
               "",
               "H\u00f3wday garm\u00e1gi wahd",
               "",
               "H\u00f3wday wahd",
               "",
            };
        final String[] Iran = new String[] {
               "\u00c9r\u00e1nay anj\u00e1ri wahd",
               "",
               "\u00c9r\u00e1nay r\u00f3chi wahd",
               "",
               "\u00c9r\u00e1nay wahd",
               "",
            };
        final String[] Niue = new String[] {
               "Niuay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "\u00d3mskay anj\u00e1ri wahd",
               "",
               "\u00d3mskay garm\u00e1gi wahd",
               "",
               "\u00d3mskay wahd",
               "",
            };
        final String[] Peru = new String[] {
               "P\u00e9r\u00f3ay anj\u00e1ri wahd",
               "",
               "P\u00e9r\u00f3ay garm\u00e1gi wahd",
               "",
               "P\u00e9r\u00f3ay wahd",
               "",
            };
        final String[] Truk = new String[] {
               "Chukay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wayk Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilayay anj\u00e1ri wahd",
               "",
               "Chilayay garm\u00e1gi wahd",
               "",
               "Chilayay wahd",
               "",
            };
        final String[] China = new String[] {
               "Chinay anj\u00e1ri wahd",
               "CST",
               "Chinay r\u00f3chi wahd",
               "CDT",
               "Chinay wahd",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kukus Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Dawisay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Henday anj\u00e1ri wahd",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "J\u00e1p\u00e1nay anj\u00e1ri wahd",
               "JST",
               "J\u00e1p\u00e1nay r\u00f3chi wahd",
               "JDT",
               "J\u00e1p\u00e1nay wahd",
               "JT",
            };
        final String[] Korea = new String[] {
               "K\u00f3ri\u00e1ay anj\u00e1ri wahd",
               "KST",
               "K\u00f3ri\u00e1ay r\u00f3chi wahd",
               "KST",
               "K\u00f3ri\u00e1ay wahd",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauruay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "N\u00e9p\u00e1lay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Pal\u00e1uay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Sam\u00f3\u00e1way anj\u00e1ri wahd",
               "SST",
               "Sam\u00f3\u00e1way r\u00f3chi wahd",
               "SST",
               "Sam\u00f3\u00e1way wahd",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Sy\u00f3w\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tong\u00e1ay anj\u00e1ri wahd",
               "",
               "Tong\u00e1ay garm\u00e1gi wahd",
               "",
               "Tong\u00e1ay wahd",
               "",
            };
        final String[] Yukon = new String[] {
               "Yuk\u00f3n wahd",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Al\u00e1sk\u00e1ay anj\u00e1ri wahd",
               "AKST",
               "Al\u00e1sk\u00e1ay garm\u00e1gi wahd",
               "AKDT",
               "Al\u00e1sk\u00e1ay wahd",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Am\u00e1z\u00f3nay anj\u00e1ri wahd",
               "",
               "Am\u00e1z\u00f3nay garm\u00e1gi wahd",
               "",
               "Am\u00e1z\u00f3nay wahd",
               "",
            };
        final String[] Azores = new String[] {
               "Az\u00f3resay anj\u00e1ri wahd",
               "",
               "Az\u00f3resay garm\u00e1gi wahd",
               "",
               "Az\u00f3resay wahd",
               "",
            };
        final String[] Bhutan = new String[] {
               "Buth\u00e1nay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brun\u00e1iay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Isthar Isl\u00e1nday anj\u00e1ri wahd",
               "",
               "Isthar Isl\u00e1nday garm\u00e1gi wahd",
               "",
               "Isthar Isl\u00e1nday wahd",
               "",
            };
        final String[] Guyana = new String[] {
               "Guy\u00e1n\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Esr\u00e1ilay anj\u00e1ri wahd",
               "IST",
               "Esr\u00e1ilay r\u00f3chi wahd",
               "IDT",
               "Esr\u00e1ilay wahd",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "K\u00f3sraiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsonay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "M\u00e1sk\u00f3ay anj\u00e1ri wahd",
               "MSK",
               "M\u00e1sk\u00f3ay garm\u00e1gi wahd",
               "MSK",
               "M\u00e1sk\u00f3ay wahd",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "P\u00f3npiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "T\u00e1ipiay anj\u00e1ri wahd",
               "CST",
               "T\u00e1ipiay r\u00f3chi wahd",
               "CDT",
               "T\u00e1ipiay wahd",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuw\u00e1luay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostokay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis o Futun\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabi anj\u00e1ri wahd",
               "",
               "Arabi r\u00f3chi wahd",
               "",
               "Arabi wahd",
               "",
            };
        final String[] Armenia = new String[] {
               "\u00c1rmini\u00e1ay anj\u00e1ri wahd",
               "",
               "\u00c1rmini\u00e1ay garm\u00e1gi wahd",
               "",
               "\u00c1rmini\u00e1ay wahd",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliwi\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatam anj\u00e1ri wahd",
               "",
               "Chatam r\u00f3chi wahd",
               "",
               "Chatam wahd",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekw\u00e1d\u00f3ray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "J\u00e1rji\u00e1ay anj\u00e1ri wahd",
               "",
               "J\u00e1rji\u00e1ay garm\u00e1gi wahd",
               "",
               "J\u00e1rji\u00e1ay wahd",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Erkuskay anj\u00e1ri wahd",
               "",
               "Erkuskay garm\u00e1gi wahd",
               "",
               "Erkuskay wahd",
               "",
            };
        final String[] Magadan = new String[] {
               "M\u00e1gad\u00e1nay anj\u00e1ri wahd",
               "",
               "M\u00e1gad\u00e1nay garm\u00e1gi wahd",
               "",
               "M\u00e1gad\u00e1nay wahd",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanm\u00e1ray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Nurpolk Isl\u00e1nday anj\u00e1ri wahd",
               "",
               "Nurpolk Isl\u00e1nday r\u00f3chi wahd",
               "",
               "Nurpolk Isl\u00e1nday wahd",
               "",
            };
        final String[] Noronha = new String[] {
               "Noron\u00e1ay anj\u00e1ri wahd",
               "",
               "Noron\u00e1ay garm\u00e1gi wahd",
               "",
               "Noron\u00e1ay wahd",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9yunianay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Roth\u00e9r\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solom\u00e1n Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokel\u00e1uay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Yur\u00f3g\u00f3ayay anj\u00e1ri wahd",
               "",
               "Yur\u00f3g\u00f3ayay garm\u00e1gi wahd",
               "",
               "Yur\u00f3g\u00f3ayay wahd",
               "",
            };
        final String[] Vanuatu = new String[] {
               "W\u00e1nu\u00e1tuay anj\u00e1ri wahd",
               "",
               "W\u00e1nu\u00e1tuay garm\u00e1gi wahd",
               "",
               "W\u00e1nu\u00e1tuay wahd",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Y\u00e1kuskay anj\u00e1ri wahd",
               "",
               "Y\u00e1kuskay garm\u00e1gi wahd",
               "",
               "Y\u00e1kuskay wahd",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlant\u00e1ay anj\u00e1ri wahd",
               "AST",
               "Atlant\u00e1ay r\u00f3chi wahd",
               "AST",
               "Atlant\u00e1ay wahd",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Br\u00e1zilay anj\u00e1ri wahd",
               "",
               "Br\u00e1zilay garm\u00e1gi wahd",
               "",
               "Br\u00e1zilay wahd",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorr\u00f3ay wahd",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolambi\u00e1ay anj\u00e1ri wahd",
               "",
               "Kolambi\u00e1ay garm\u00e1gi wahd",
               "",
               "Kolambi\u00e1ay wahd",
               "",
            };
        final String[] Falkland = new String[] {
               "Palkl\u00e1nd Isl\u00e1nday anj\u00e1ri wahd",
               "",
               "Palkl\u00e1nd Isl\u00e1nday garm\u00e1gi wahd",
               "",
               "Palkl\u00e1nd Isl\u00e1nday wahd",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malishi\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "M\u00e1ldipay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ul\u00e1nb\u00e1taray anj\u00e1ri wahd",
               "",
               "Ul\u00e1nb\u00e1taray garm\u00e1gi wahd",
               "",
               "Ul\u00e1nb\u00e1taray wahd",
               "",
            };
        final String[] Pakistan = new String[] {
               "P\u00e1kest\u00e1nay anj\u00e1ri wahd",
               "PKT",
               "P\u00e1kest\u00e1nay garm\u00e1gi wahd",
               "PKST",
               "P\u00e1kest\u00e1nay wahd",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Parag\u00f3ayay anj\u00e1ri wahd",
               "",
               "Parag\u00f3ayay garm\u00e1gi wahd",
               "",
               "Parag\u00f3ayay wahd",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkar\u00e9nay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakh\u00e1linay anj\u00e1ri wahd",
               "",
               "Sakh\u00e1linay garm\u00e1gi wahd",
               "",
               "Sakh\u00e1linay wahd",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinaymay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Arjentin\u00e1ay anj\u00e1ri wahd",
               "",
               "Arjentin\u00e1ay garm\u00e1gi wahd",
               "",
               "Arjentin\u00e1ay wahd",
               "",
            };
        final String[] Christmas = new String[] {
               "Kresmes Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagosay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "H\u00e1ng K\u00e1ngay anj\u00e1ri wahd",
               "HKT",
               "H\u00e1ng K\u00e1ngay garm\u00e1gi wahd",
               "HKST",
               "H\u00e1ng K\u00e1ngay wahd",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hend\u00f3chinay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kargezest\u00e1nay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "\u00c1str\u00e9li\u00e1ay, L\u00e1dhaway anj\u00e1ri wahd",
               "",
               "\u00c1str\u00e9li\u00e1ay, L\u00e1dhaway garm\u00e1gi wahd",
               "",
               "\u00c1str\u00e9li\u00e1ay, L\u00e1dhaway wahd",
               "",
            };
        final String[] Marquesas = new String[] {
               "Mark\u00e9s\u00e1say wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Murit\u00e1ni\u00e1ay anj\u00e1ri wahd",
               "",
               "Murit\u00e1ni\u00e1ay garm\u00e1gi wahd",
               "",
               "Murit\u00e1ni\u00e1ay wahd",
               "",
            };
        final String[] Singapore = new String[] {
               "Seng\u00e1puray anj\u00e1ri wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Wenezw\u00e9l\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograday anj\u00e1ri wahd",
               "MSK",
               "Wolgograday garm\u00e1gi wahd",
               "MSK",
               "Wolgograday wahd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "\u00c1zerb\u00e1ij\u00e1nay anj\u00e1ri wahd",
               "",
               "\u00c1zerb\u00e1ij\u00e1nay garm\u00e1gi wahd",
               "",
               "\u00c1zerb\u00e1ij\u00e1nay wahd",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangalad\u00e9shay anj\u00e1ri wahd",
               "",
               "Bangalad\u00e9shay garm\u00e1gi wahd",
               "",
               "Bangalad\u00e9shay wahd",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Ward\u00e9ay anj\u00e1ri wahd",
               "",
               "Kap Ward\u00e9ay garm\u00e1gi wahd",
               "",
               "Kap Ward\u00e9ay wahd",
               "",
            };
        final String[] East_Timor = new String[] {
               "R\u00f3dar\u00e1tki Timuray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "K\u00e1zakest\u00e1nay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "S\u00e9chelesay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "T\u00e1jekest\u00e1nay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ozbekest\u00e1nay anj\u00e1ri wahd",
               "",
               "Ozbekest\u00e1nay garm\u00e1gi wahd",
               "",
               "Ozbekest\u00e1nay wahd",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Awg\u00e1nest\u00e1nay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasn\u00f3y\u00e1skay anj\u00e1ri wahd",
               "",
               "Krasn\u00f3y\u00e1skay garm\u00e1gi wahd",
               "",
               "Krasn\u00f3y\u00e1skay wahd",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Niu Zil\u00e1nday anj\u00e1ri wahd",
               "NZST",
               "Niu Zil\u00e1nday r\u00f3chi wahd",
               "NZDT",
               "Niu Zil\u00e1nday wahd",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Naw\u00e1sibiskay anj\u00e1ri wahd",
               "",
               "Naw\u00e1sibiskay garm\u00e1gi wahd",
               "",
               "Naw\u00e1sibiskay wahd",
               "",
            };
        final String[] Philippines = new String[] {
               "Pelpinay anj\u00e1ri wahd",
               "PST",
               "Pelpinay garm\u00e1gi wahd",
               "PDT",
               "Pelpinay wahd",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wal\u00e1diw\u00e1st\u00f3kay anj\u00e1ri wahd",
               "",
               "Wal\u00e1diw\u00e1st\u00f3kay garm\u00e1gi wahd",
               "",
               "Wal\u00e1diw\u00e1st\u00f3kay wahd",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hendi zeray wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lin\u00e9 Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Nip\u00e1ndlaynday anj\u00e1ri wahd",
               "NST",
               "Nip\u00e1ndlaynday garm\u00e1gi wahd",
               "NDT",
               "Nip\u00e1ndlaynday wahd",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Torkmenest\u00e1nay anj\u00e1ri wahd",
               "",
               "Torkmenest\u00e1nay garm\u00e1gi wahd",
               "",
               "Torkmenest\u00e1nay wahd",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Par\u00e1nsi Gwin\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nyu Kaled\u00f3ni\u00e1ay anj\u00e1ri wahd",
               "",
               "Nyu Kaled\u00f3ni\u00e1ay garm\u00e1gi wahd",
               "",
               "Nyu Kaled\u00f3ni\u00e1ay wahd",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Zerb\u00e1ri J\u00e1rji\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yak\u00e1trinborgay anj\u00e1ri wahd",
               "",
               "Yak\u00e1trinborgay garm\u00e1gi wahd",
               "",
               "Yak\u00e1trinborgay wahd",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Delg\u00e1hi Aprik\u00e1ay wahd",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "R\u00f3dar\u00e1tki Aprik\u00e1ay wahd",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "R\u00f3nendi Aprik\u00e1ay anj\u00e1ri wahd",
               "WAT",
               "R\u00f3nendi Aprik\u00e1ay garm\u00e1gi wahd",
               "WAT",
               "R\u00f3nendi Aprik\u00e1ay wahd",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont Urwilay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Delg\u00e1hi Yuropay anj\u00e1ri wahd",
               "CET",
               "Delg\u00e1hi Yuropay garm\u00e1gi wahd",
               "CEST",
               "Delg\u00e1hi Yuropay wahd",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "R\u00f3dar\u00e1tki Yuropay anj\u00e1ri wahd",
               "EET",
               "R\u00f3dar\u00e1tki Yuropay garm\u00e1gi wahd",
               "EEST",
               "R\u00f3dar\u00e1tki Yuropay wahd",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "R\u00f3nendi Yuropay anj\u00e1ri wahd",
               "WET",
               "R\u00f3nendi Yuropay garm\u00e1gi wahd",
               "WEST",
               "R\u00f3nendi Yuropay wahd",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u00c1r\u00e1mzeri Meksik\u00f3ay anj\u00e1ri wahd",
               "MST",
               "\u00c1r\u00e1mzeri Meksik\u00f3ay garm\u00e1gi wahd",
               "MDT",
               "\u00c1r\u00e1mzeri Meksik\u00f3ay wahd",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "R\u00f3dar\u00e1tki Aprik\u00e1ay anj\u00e1ri wahd",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Delg\u00e1hi Amrik\u00e1ay anj\u00e1ri wahd",
               "CST",
               "Delg\u00e1hi Amrik\u00e1ay garm\u00e1gi wahd",
               "CDT",
               "Delg\u00e1hi Amrik\u00e1ay wahd",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "R\u00f3dar\u00e1tki Amrik\u00e1ay anj\u00e1ri wahd",
               "EST",
               "R\u00f3dar\u00e1tki Amrik\u00e1ay garm\u00e1gi wahd",
               "EST",
               "R\u00f3dar\u00e1tki Amrik\u00e1ay wahd",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "\u00c1r\u00e1mzeri Amrik\u00e1ay anj\u00e1ri wahd",
               "PST",
               "\u00c1r\u00e1mzeri Amrik\u00e1ay garm\u00e1gi wahd",
               "PDT",
               "\u00c1r\u00e1mzeri Amrik\u00e1ay wahd",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Zerb\u00e1ri Paransi o Ant\u00e1rktik\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gelbart Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Haw\u00e1i/Alushiay anj\u00e1ri wahd",
               "HST",
               "Haw\u00e1i/Alushiay garm\u00e1gi wahd",
               "HST",
               "Haw\u00e1i/Alushiay wahd",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoeneks Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. P\u00e9ri o Mikw\u00e9lin aj\u00e1ri wahd",
               "",
               "St. P\u00e9ri o Mikw\u00e9lin r\u00f3chi wahd",
               "",
               "St. P\u00e9ri o Mikw\u00e9lin wahd",
               "",
            };
        final String[] America_Mountain = new String[] {
               "K\u00f3hestagi Amrik\u00e1ay anj\u00e1ri wahd",
               "MST",
               "K\u00f3hestagi Amrik\u00e1ay garm\u00e1gi wahd",
               "MST",
               "K\u00f3hestagi Amrik\u00e1ay wahd",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "M\u00e1rshal Isl\u00e1nday wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "P\u00e1pu\u00e1 Niu Gini\u00e1ay wahd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Delg\u00e1hi \u00c1str\u00e9li\u00e1ay anj\u00e1ri wahd",
               "ACST",
               "Delg\u00e1hi \u00c1str\u00e9li\u00e1ay garm\u00e1gi wahd",
               "ACDT",
               "Delg\u00e1hi \u00c1str\u00e9li\u00e1ay wahd",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "R\u00f3dar\u00e1tki \u00c1str\u00e9li\u00e1ay anj\u00e1ri wahd",
               "AEST",
               "R\u00f3dar\u00e1tki \u00c1str\u00e9li\u00e1ay garm\u00e1gi wahd",
               "AEDT",
               "R\u00f3dar\u00e1tki \u00c1str\u00e9li\u00e1ay wahd",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "R\u00f3nendi \u00c1str\u00e9li\u00e1ay anj\u00e1ri wahd",
               "AWST",
               "R\u00f3nendi \u00c1str\u00e9li\u00e1ay garm\u00e1gi wahd",
               "AWDT",
               "R\u00f3nendi \u00c1str\u00e9li\u00e1ay wahd",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Delg\u00e1hi Endhonishi\u00e1ay anj\u00e1ri wahd",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "R\u00f3dar\u00e1tki Endhonishi\u00e1ay anj\u00e1ri wahd",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "R\u00f3nendi Endhonishi\u00e1ay anj\u00e1ri wahd",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Delg\u00e1hir\u00f3nendi \u00c1str\u00e9li\u00e1ay anj\u00e1ri wahd",
               "",
               "Delg\u00e1hir\u00f3nendi \u00c1str\u00e9li\u00e1ay garm\u00e1gi wahd",
               "",
               "Delg\u00e1hir\u00f3nendi \u00c1str\u00e9li\u00e1ay wahd",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "\u00c1eri anj\u00e1ri wahd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hamd\u00e1r\u00e9n Jah\u00e1ni wahd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "\u00c1eri anj\u00e1ri wahd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Grinwech Min Wahd",
                    "GMT",
                    "Bart\u00e1ni\u00e1i garm\u00e1gi wahd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adan" },
            { "timezone.excity.Asia/Baku", "B\u00e1ku" },
            { "timezone.excity.Asia/Dili", "Dehli" },
            { "timezone.excity.Asia/Hovd", "H\u00f3wd" },
            { "timezone.excity.Asia/Oral", "Or\u00e1l" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "timezone.excity.Asia/Dubai", "Dabai" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bol" },
            { "timezone.excity.Asia/Macau", "Mak\u00e1\u00f3" },
            { "timezone.excity.Asia/Qatar", "Gatar" },
            { "timezone.excity.Asia/Seoul", "Se\u00f3l" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3ky\u00f3" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Jub\u00e1" },
            { "timezone.excity.Africa/Lome", "L\u00f3m\u00e9" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktub\u00e9" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "B\u00e9rut" },
            { "timezone.excity.Asia/Brunei", "Brun\u00e1i" },
            { "timezone.excity.Asia/Hebron", "Hebr\u00f3n" },
            { "timezone.excity.Asia/Kuwait", "Kwayt" },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "timezone.excity.Asia/Riyadh", "Ry\u00e1z" },
            { "timezone.excity.Asia/Saigon", "H\u00f3 Chi Menn" },
            { "timezone.excity.Asia/Taipei", "T\u00e1ipi" },
            { "timezone.excity.Asia/Tehran", "Tehr\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "Urumki" },
            { "timezone.excity.Etc/Unknown", "N\u00e1m\u00e1lum\u00e9n shahr" },
            { "timezone.excity.Europe/Oslo", "\u00d3sl\u00f3" },
            { "timezone.excity.Europe/Rome", "Rum" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akkr\u00e1" },
            { "timezone.excity.Africa/Cairo", "K\u00e1er\u00f3" },
            { "timezone.excity.Africa/Ceuta", "Kyut\u00e1" },
            { "timezone.excity.Africa/Lagos", "Lag\u00f3s" },
            { "timezone.excity.Africa/Tunis", "Tunes" },
            { "timezone.excity.America/Lima", "Lim\u00e1" },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1d" },
            { "timezone.excity.Asia/Bahrain", "Bahren" },
            { "timezone.excity.Asia/Bangkok", "Bengk\u00e1k" },
            { "timezone.excity.Asia/Colombo", "K\u00f3lamb\u00f3" },
            { "timezone.excity.Asia/Jakarta", "Jak\u00e1rt\u00e1" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1chi" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3shi\u00e1" },
            { "timezone.excity.Asia/Tbilisi", "Tebilisi" },
            { "timezone.excity.Asia/Thimphu", "Thimpu" },
            { "timezone.excity.Asia/Yerevan", "Yerew\u00e1n" },
            { "timezone.excity.Europe/Kirov", "Kir\u00f3w" },
            { "timezone.excity.Europe/Paris", "Payres" },
            { "timezone.excity.Europe/Sofia", "Sofi\u00e1" },
            { "timezone.excity.Europe/Vaduz", "Waduz" },
            { "timezone.excity.Indian/Cocos", "Kukus" },
            { "timezone.excity.Pacific/Apia", "Api\u00e1" },
            { "timezone.excity.Africa/Asmera", "Asmar\u00e1" },
            { "timezone.excity.Africa/Bamako", "Bamak\u00f3" },
            { "timezone.excity.Africa/Douala", "Dou\u00e1l\u00e1" },
            { "timezone.excity.Africa/Harare", "Har\u00e1r\u00e9" },
            { "timezone.excity.Africa/Luanda", "Luand\u00e1" },
            { "timezone.excity.Africa/Lusaka", "Lus\u00e1k\u00e1" },
            { "timezone.excity.Africa/Malabo", "Mal\u00e1b\u00f3" },
            { "timezone.excity.Africa/Maputo", "Maput\u00f3" },
            { "timezone.excity.Africa/Maseru", "Mas\u00e9r\u00f3" },
            { "timezone.excity.Africa/Niamey", "Niam\u00e9y" },
            { "timezone.excity.America/Aruba", "Arub\u00e1" },
            { "timezone.excity.America/Jujuy", "Jojui" },
            { "timezone.excity.America/Thule", "Tul\u00e9" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "timezone.excity.Asia/Damascus", "Dam\u00e1skas" },
            { "timezone.excity.Asia/Dushanbe", "Doshambeh" },
            { "timezone.excity.Asia/Jayapura", "Jaypur" },
            { "timezone.excity.Asia/Khandyga", "Khandiga" },
            { "timezone.excity.Asia/Qostanay", "Kastanay" },
            { "timezone.excity.Asia/Shanghai", "Shang\u00e1i" },
            { "timezone.excity.Asia/Tashkent", "T\u00e1shkand" },
            { "timezone.excity.Europe/Athens", "\u00c1ten" },
            { "timezone.excity.Europe/Jersey", "Jers\u00e9y" },
            { "timezone.excity.Europe/London", "Landan" },
            { "timezone.excity.Europe/Monaco", "Mon\u00e1k\u00f3" },
            { "timezone.excity.Europe/Moscow", "M\u00e1sk\u00f3" },
            { "timezone.excity.Europe/Prague", "Pr\u00e1g" },
            { "timezone.excity.Europe/Skopje", "Kopj\u00e9" },
            { "timezone.excity.Europe/Tirane", "Tir\u00e1ne" },
            { "timezone.excity.Europe/Vienna", "Wienn\u00e1" },
            { "timezone.excity.Europe/Warsaw", "W\u00e1rs\u00e1" },
            { "timezone.excity.Europe/Zurich", "Zyurekh" },
            { "timezone.excity.Indian/Chagos", "Chag\u00f3s" },
            { "timezone.excity.Indian/Comoro", "Kom\u00f3r\u00f3" },
            { "timezone.excity.Pacific/Efate", "Ef\u00e1ti" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "\u00c1bedj\u00e1n" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Kampala", "Kamp\u00e1la" },
            { "timezone.excity.Africa/Mbabane", "Mbaban\u00e9" },
            { "timezone.excity.Africa/Nairobi", "N\u00e9rubi" },
            { "timezone.excity.Africa/Tripoli", "Trip\u00f3li" },
            { "timezone.excity.America/Cancun", "Chanchun" },
            { "timezone.excity.America/Cayman", "Kayman" },
            { "timezone.excity.America/Cuiaba", "Kwaib\u00e1" },
            { "timezone.excity.America/Denver", "Denw\u00e9r" },
            { "timezone.excity.America/Guyana", "Guy\u00e1na" },
            { "timezone.excity.America/Havana", "Haw\u00e1n\u00e1" },
            { "timezone.excity.America/Inuvik", "Inuwik" },
            { "timezone.excity.America/Juneau", "Juniu" },
            { "timezone.excity.America/La_Paz", "L\u00e1 Paz" },
            { "timezone.excity.America/Maceio", "Machi\u00f3" },
            { "timezone.excity.America/Panama", "Pan\u00e1m\u00e1" },
            { "timezone.excity.America/Recife", "Rechip\u00e9" },
            { "timezone.excity.Asia/Famagusta", "Pamagust\u00e1" },
            { "timezone.excity.Asia/Hong_Kong", "H\u00e1ng K\u00e1ng" },
            { "timezone.excity.Asia/Jerusalem", "Urshalim" },
            { "timezone.excity.Asia/Pyongyang", "Pyongy\u00e1ng" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilord\u00e1" },
            { "timezone.excity.Asia/Singapore", "Seng\u00e1pur" },
            { "timezone.excity.Asia/Vientiane", "Wienti\u00e1n\u00e9" },
            { "timezone.excity.Europe/Saratov", "Sarat\u00f3w" },
            { "timezone.excity.Europe/Vatican", "Watikan" },
            { "timezone.excity.Europe/Vilnius", "Wilnius" },
            { "timezone.excity.Indian/Mayotte", "May\u00f3tay" },
            { "timezone.excity.Indian/Reunion", "R\u00e9yunian" },
            { "timezone.excity.Pacific/Easter", "Isthar" },
            { "timezone.excity.Pacific/Kosrae", "K\u00f3srai" },
            { "timezone.excity.Africa/Blantyre", "Blantiray" },
            { "timezone.excity.Africa/Djibouti", "Djeb\u00f3ti" },
            { "timezone.excity.Africa/El_Aaiun", "El \u00c1iun" },
            { "timezone.excity.Africa/Freetown", "Perith\u00e1\u00f3n" },
            { "timezone.excity.Africa/Gaborone", "Gaboron\u00e9" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Kinshasa", "Kensh\u00e1sa" },
            { "timezone.excity.Africa/Monrovia", "Monr\u00f3wi\u00e1" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamen\u00e1" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e1\u00f3 Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windoek" },
            { "timezone.excity.America/Antigua", "Antigu\u00e1" },
            { "timezone.excity.America/Caracas", "Charak\u00e1s" },
            { "timezone.excity.America/Cayenne", "Chayenn" },
            { "timezone.excity.America/Chicago", "Shek\u00e1g\u00f3" },
            { "timezone.excity.America/Cordoba", "Kortoba" },
            { "timezone.excity.America/Creston", "Krest\u00f3n" },
            { "timezone.excity.America/Curacao", "Chor\u00e1ch\u00e1\u00f3" },
            { "timezone.excity.America/Grenada", "Grenad\u00e1" },
            { "timezone.excity.America/Halifax", "Halifaks" },
            { "timezone.excity.America/Iqaluit", "Ik\u00e1lwit" },
            { "timezone.excity.America/Jamaica", "Jam\u00e1ek\u00e1" },
            { "timezone.excity.America/Mendoza", "Mendoz\u00e1" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "timezone.excity.America/Noronha", "Noronh\u00e1" },
            { "timezone.excity.America/Phoenix", "P\u00f3eniks" },
            { "timezone.excity.America/Tijuana", "Tiju\u00e1na" },
            { "timezone.excity.America/Toronto", "Toront\u00f3" },
            { "timezone.excity.America/Tortola", "Tortol\u00e1" },
            { "timezone.excity.Atlantic/Azores", "Az\u00f3res" },
            { "timezone.excity.Atlantic/Canary", "Kanaray" },
            { "timezone.excity.Australia/Eucla", "Yukl\u00e1" },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "timezone.excity.Europe/Belgrade", "Belgr\u00e1d" },
            { "timezone.excity.Europe/Budapest", "Bud\u00e1pest" },
            { "timezone.excity.Europe/Guernsey", "Guerns\u00e9y" },
            { "timezone.excity.Europe/Istanbul", "Estamb\u00f3l" },
            { "timezone.excity.Europe/Sarajevo", "Saraj\u00e9w\u00f3" },
            { "timezone.excity.Indian/Maldives", "M\u00e1ldip" },
            { "timezone.excity.Pacific/Fakaofo", "Faka\u00f3f\u00f3" },
            { "timezone.excity.Pacific/Norfolk", "Nurpolk" },
            { "timezone.excity.Africa/Bujumbura", "Bujombura" },
            { "timezone.excity.Africa/Mogadishu", "M\u00f3g\u00e1d\u00e9sh\u00f3" },
            { "timezone.excity.America/Anguilla", "Anguill\u00e1" },
            { "timezone.excity.America/Asuncion", "Asunchi\u00f3n" },
            { "timezone.excity.America/Dominica", "Dominik\u00e1" },
            { "timezone.excity.America/Eirunepe", "Irun\u00e9p\u00e9" },
            { "timezone.excity.America/Miquelon", "Mekwelon" },
            { "timezone.excity.America/New_York", "Nyu Y\u00e1rk" },
            { "timezone.excity.America/Resolute", "Res\u00f3lut" },
            { "timezone.excity.America/Santiago", "Santiag\u00f3" },
            { "timezone.excity.America/St_Lucia", "St. Lusi\u00e1" },
            { "timezone.excity.Antarctica/Casey", "K\u00e1s\u00e9" },
            { "timezone.excity.Antarctica/Davis", "Dawis" },
            { "timezone.excity.Antarctica/Syowa", "Sy\u00f3w\u00e1" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1nb\u00e1tar" },
            { "timezone.excity.Asia/Vladivostok", "Wladiw\u00f3stok" },
            { "timezone.excity.Atlantic/Stanley", "St\u00e1nl\u00e9" },
            { "timezone.excity.Australia/Sydney", "Sedhni" },
            { "timezone.excity.Europe/Bucharest", "Bukh\u00e1rest" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljan\u00e1" },
            { "timezone.excity.Europe/Podgorica", "Podgorik\u00e1" },
            { "timezone.excity.Europe/Stockholm", "Esth\u00e1kholm" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyan\u00f3wsk" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Kresmes" },
            { "timezone.excity.Indian/Kerguelen", "Kargwelen" },
            { "timezone.excity.Indian/Mauritius", "Murishas" },
            { "timezone.excity.Pacific/Auckland", "Awkl\u00e1nd" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkarin" },
            { "timezone.excity.Africa/Casablanca", "Kasablank\u00e1" },
            { "timezone.excity.Africa/Libreville", "Librewilay" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumb\u00e1shi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakshott" },
            { "timezone.excity.Africa/Porto-Novo", "Port\u00f3-N\u00f3w\u00f3" },
            { "timezone.excity.America/Anchorage", "Anchorag\u00e9" },
            { "timezone.excity.America/Boa_Vista", "B\u00f3\u00e1 Wist\u00e1" },
            { "timezone.excity.America/Catamarca", "Chatamark\u00e1" },
            { "timezone.excity.America/Chihuahua", "Chihuahu\u00e1" },
            { "timezone.excity.America/Fortaleza", "Portalez\u00e1" },
            { "timezone.excity.America/Glace_Bay", "Glays Bay" },
            { "timezone.excity.America/Guatemala", "Gw\u00e1t\u00e9m\u00e1l\u00e1" },
            { "timezone.excity.America/Guayaquil", "Gw\u00e1yakil" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "timezone.excity.America/Monterrey", "Monterray" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e1\u00f3 Paul\u00f3" },
            { "timezone.excity.America/St_Thomas", "St. T\u00f3mas" },
            { "timezone.excity.America/Vancouver", "Wankuwar" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kw\u00e1l\u00e1 Lampur" },
            { "timezone.excity.Asia/Novokuznetsk", "Nowokuznetsk" },
            { "timezone.excity.Europe/Bratislava", "Bratislaw\u00e1" },
            { "timezone.excity.Europe/Copenhagen", "Kopenh\u00e1gen" },
            { "timezone.excity.Europe/Luxembourg", "Logzemborg" },
            { "timezone.excity.Europe/San_Marino", "San Marin\u00f3" },
            { "timezone.excity.Europe/Simferopol", "Simper\u00f3p\u00f3l" },
            { "timezone.excity.Pacific/Marquesas", "Markes\u00e1s" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abab\u00e1" },
            { "timezone.excity.Africa/Brazzaville", "Brazzawilay" },
            { "timezone.excity.America/Costa_Rica", "K\u00f3st\u00e1 Rik\u00e1" },
            { "timezone.excity.America/Guadeloupe", "Gw\u00e1del\u00f3p" },
            { "timezone.excity.America/Louisville", "Luiswillay" },
            { "timezone.excity.America/Martinique", "Matinik" },
            { "timezone.excity.America/Montevideo", "Montewidi\u00f3" },
            { "timezone.excity.America/Paramaribo", "Paramarib\u00f3" },
            { "timezone.excity.America/Rio_Branco", "Ri\u00f3 Brank\u00f3" },
            { "timezone.excity.America/St_Vincent", "St. Winsent" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednek\u00f3limsk" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjawik" },
            { "timezone.excity.Atlantic/St_Helena", "St. Helen\u00e1" },
            { "timezone.excity.Australia/Adelaide", "Adil\u00e9d" },
            { "timezone.excity.Africa/Johannesburg", "Johannesbarg" },
            { "timezone.excity.America/El_Salvador", "El Salwad\u00f3r" },
            { "timezone.excity.America/Los_Angeles", "L\u00e1s Enjeles" },
            { "timezone.excity.America/Mexico_City", "Meksik\u00f3 Shahr" },
            { "timezone.excity.America/Porto_Velho", "Port\u00f3 welh\u00f3" },
            { "timezone.excity.America/Puerto_Rico", "Puert\u00f3 Rik\u00f3" },
            { "timezone.excity.America/Tegucigalpa", "Teguchigalp\u00e1" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Ward\u00e9" },
            { "timezone.excity.Australia/Melbourne", "Melborn" },
            { "timezone.excity.Indian/Antananarivo", "Antananariw\u00f3" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "D\u00e1r es sal\u00e1m" },
            { "timezone.excity.America/Blanc-Sablon", "Blanch-Sabl\u00f3n" },
            { "timezone.excity.America/Campo_Grande", "Champo Grande" },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshawn" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Kr\u00e9k" },
            { "timezone.excity.America/Indiana/Knox", "Knoks, Indi\u00e1n\u00e1" },
            { "timezone.excity.America/Indianapolis", "Indi\u00e1n\u00e1polis" },
            { "timezone.excity.America/Scoresbysund", "Ittokkorturmit" },
            { "timezone.excity.Antarctica/Macquarie", "Makw\u00e1er" },
            { "timezone.excity.Pacific/Bougainville", "B\u00f3g\u00e1inwilay" },
            { "timezone.excity.America/Cambridge_Bay", "Kambrej Bay" },
            { "timezone.excity.America/Ciudad_Juarez", "Chiudad Ju\u00e1rez" },
            { "timezone.excity.America/Coral_Harbour", "Atik\u00f3kan" },
            { "timezone.excity.America/Indiana/Vevay", "Weway, Indi\u00e1n\u00e1" },
            { "timezone.excity.America/Port_of_Spain", "P\u00f3rt Espin" },
            { "timezone.excity.America/Santo_Domingo", "Sant\u00f3 Doming\u00f3" },
            { "timezone.excity.America/Swift_Current", "Swift Karrant" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda de Bander\u00e1s" },
            { "timezone.excity.America/Port-au-Prince", "P\u00f3rt-au-Prens" },
            { "timezone.excity.Atlantic/South_Georgia", "Shem\u00e1li J\u00e1rji\u00e1" },
            { "timezone.excity.America/Indiana/Marengo", "Mareng\u00f3 Indi\u00e1n\u00e1" },
            { "timezone.excity.America/Indiana/Winamac", "Winamak, Indi\u00e1n\u00e1" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushw\u00e1i\u00e1" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell Sithi, Indi\u00e1n\u00e1" },
            { "timezone.excity.America/Indiana/Vincennes", "Winsennes, Indi\u00e1n\u00e1" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont Urwila" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg, Indi\u00e1n\u00e1" },
            { "timezone.excity.America/Kentucky/Monticello", "Montichell\u00f3, Kentuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, N\u00e1rt Dak\u00f3t\u00e1" },
            { "timezone.excity.America/North_Dakota/Center", "Santhar, N\u00e1rt Dak\u00f3t\u00e1" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nyu Salem, N\u00e1rt Dak\u00f3t\u00e1" },
        };
        return data;
    }
}
