/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ak extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Gyaaman";
        final String metaValue_CA = "Kanada";
        final String metaValue_ar = "Arabeke";
        final String metaValue_he = "Hibri kasa";
        final String metaValue_ko = "Korea kasa";
        final String metaValue_lo = "Lawo kasa";
        final String metaValue_ml = "Malayalam kasa";
        final String metaValue_mn = "Mongoliafo\u0254 kasa";
        final String metaValue_ta = "Tamil kasa";
        final Object[][] data = new Object[][] {
            { "001", "wiase" },
            { "002", "Abibirem" },
            { "003", "Am\u025brika Atifi" },
            { "005", "Am\u025brika Anaafo\u0254" },
            { "009", "Osiana" },
            { "011", "Abibirem At\u0254e\u025b Fam" },
            { "013", "Am\u025brika Mfimfini" },
            { "014", "Abibirem Apuei\u025b Fam" },
            { "015", "Abibirem Atifi Fam" },
            { "017", "Abibirem Mfimfini" },
            { "018", "Abibirem Anaafo\u0254 Fam" },
            { "019", "Am\u025brikafo\u0254" },
            { "021", "Am\u025brika Atifi Fam" },
            { "029", "Karibia" },
            { "030", "Asia Apuei\u025b" },
            { "034", "Asia Anaafo\u0254" },
            { "035", "Asia Anaafo\u0254 Apuie\u025b" },
            { "039", "Yuropu Anaafo\u0254" },
            { "053", "\u0186strelia ne Asia" },
            { "054", "Melanesia" },
            { "057", "Micronesia Mantam" },
            { "061", "P\u0254lenesia" },
            { "142", "Asia" },
            { "143", "Asia Mfimfini" },
            { "145", "Asia At\u0254e\u025b" },
            { "150", "Yuropu" },
            { "151", "Yuropu Apuie\u025b" },
            { "154", "Yuropu Atifi" },
            { "155", "Yuropu At\u0254e\u025b" },
            { "202", "Abibirem Mpapr\u025b Anaafo\u0254" },
            { "419", "Laaten Am\u025brika" },
            { "AC", "As\u025bnhyin" },
            { "AD", "Andora" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ne Baabuda" },
            { "AI", "Anguila" },
            { "AL", "Albenia" },
            { "AM", "Aamenia" },
            { "AO", "Angola" },
            { "AQ", "Antaatika" },
            { "AR", "Agy\u025bntina" },
            { "AS", "Am\u025brika Samoa" },
            { "AT", "\u0186stria" },
            { "AU", "\u0186strelia" },
            { "AW", "Aruba" },
            { "AX", "Aland Aeland" },
            { "AZ", "Asabegyan" },
            { "BA", "Bosnia ne H\u025bzegovina" },
            { "BB", "Baabados" },
            { "BD", "Banglad\u025bhye" },
            { "BE", "B\u025blgyium" },
            { "BF", "B\u0254kina Faso" },
            { "BG", "B\u0254lgeria" },
            { "BH", "Baren" },
            { "BI", "Burundi" },
            { "BJ", "B\u025bnin" },
            { "BL", "St. Baatilemi" },
            { "BM", "B\u025bmuda" },
            { "BN", "Brunae" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "BT", "Butan" },
            { "BV", "Bouvet Island" },
            { "BW", "B\u0254tswana" },
            { "BY", "B\u025blarus" },
            { "BZ", "Beliz" },
            { "CA", metaValue_CA },
            { "CC", "Kokoso Sup\u0254" },
            { "CD", "Kongo Kinhyaahya" },
            { "CF", "Afrika Finimfin Man" },
            { "CG", "Kongo" },
            { "CH", "Swetzaland" },
            { "CI", "Kodivuwa" },
            { "CK", "Kuk Nsup\u0254" },
            { "CL", "Kyili" },
            { "CM", "Kam\u025brun" },
            { "CN", "Kyaena" },
            { "CO", "Kolombia" },
            { "CP", "Klepatin Aeland" },
            { "CR", "K\u0254sta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kepv\u025bdfo Islands" },
            { "CW", "Kurakaw" },
            { "CX", "Buronya Sup\u0254" },
            { "CY", "Saepr\u0254so" },
            { "CZ", "Ky\u025bk" },
            { "DE", metaValue_DE },
            { "DG", "Di\u025bgo Gaasia" },
            { "DJ", "Gyibuti" },
            { "DK", "D\u025bnmak" },
            { "DM", "D\u0254meneka" },
            { "DO", "D\u0254meneka Man" },
            { "DZ", "\u0186lgyeria" },
            { "EA", "Ceuta ne Melilla" },
            { "EC", "Yikuwed\u0254" },
            { "EE", "\u0190stonia" },
            { "EG", "Misrim" },
            { "EH", "Sahara At\u0254e\u025b" },
            { "ER", "\u0190ritrea" },
            { "ES", "Spain" },
            { "ET", "Ithiopia" },
            { "EU", "Yuropu Nkabomkuo" },
            { "EZ", "Yuropu Fam" },
            { "FI", "Finland" },
            { "FJ", "Figyi" },
            { "FK", "F\u0254kman Aeland" },
            { "FM", "Maekronehyia" },
            { "FO", "Faro Aeland" },
            { "FR", "Franse" },
            { "GA", "Gab\u0254n" },
            { "GB", "UK" },
            { "GD", "Grenada" },
            { "GE", "Gy\u0254gyea" },
            { "GF", "Fr\u025bnkye Gayana" },
            { "GG", "Gu\u025bnse" },
            { "GH", "Gaana" },
            { "GI", "Gyebralta" },
            { "GL", "Greenman" },
            { "GM", "Gambia" },
            { "GN", "Gini" },
            { "GP", "Guwadelup" },
            { "GQ", "Gini Ikuweta" },
            { "GR", "Greekman" },
            { "GS", "Gy\u0254\u0254gyia Anaafo\u0254 ne Sandwich Aeland Anaafo\u0254" },
            { "GT", "Guwatemala" },
            { "GU", "Guam" },
            { "GW", "Gini Bisaw" },
            { "GY", "Gayana" },
            { "HK", "H\u0254nk\u0254n Kyaena" },
            { "HM", "Heard ne McDonald Sup\u0254" },
            { "HN", "H\u0254nduras" },
            { "HR", "Krowehyia" },
            { "HT", "Heiti" },
            { "HU", "Hangari" },
            { "IC", "Canary Islands" },
            { "ID", "Ind\u0254nehyia" },
            { "IE", "Aereland" },
            { "IL", "Israe" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Britenfo Man W\u0254 India Po No Mu" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Aesland" },
            { "IT", "Itali" },
            { "JE", "Gy\u025bsi" },
            { "JM", "Gyameka" },
            { "JO", "Gy\u0254dan" },
            { "JP", "Gyapan" },
            { "KE", "Kenya" },
            { "KG", "K\u025b\u025bgestan" },
            { "KH", "Kambodia" },
            { "KI", "Kiribati" },
            { "KM", "K\u0254m\u0254r\u0254s" },
            { "KN", "Saint Kitts ne N\u025bves" },
            { "KP", "Korea Atifi" },
            { "KR", "Korea Anaafo\u0254" },
            { "KW", "Kuweti" },
            { "KY", "Kemanfo Islands" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "L\u025bban\u0254n" },
            { "LC", "Saint Lucia" },
            { "LI", "Lektenstaen" },
            { "LK", "Sri Lanka" },
            { "LR", "Laeberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituwenia" },
            { "LU", "Lusimb\u025bg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Moroko" },
            { "MC", "Monako" },
            { "MD", "M\u0254ldova" },
            { "ME", "M\u0254ntenegro" },
            { "MF", "St. Maatin" },
            { "MG", "Madagaska" },
            { "MH", "Mahyaa Aeland" },
            { "MK", "Mesidonia Atifi" },
            { "ML", "Mali" },
            { "MM", "Mayaama (B\u025b\u025bma)" },
            { "MN", "M\u0254ngolia" },
            { "MO", "Makaw Kyaena" },
            { "MP", "Mariana Atifi Fam Aeland" },
            { "MQ", "Matinik" },
            { "MR", "M\u0254retenia" },
            { "MS", "Mantserat" },
            { "MT", "M\u0254lta" },
            { "MU", "M\u0254rehye\u0254s" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "M\u025bksiko" },
            { "MY", "Malehyia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Foforo" },
            { "NE", "Nigy\u025b\u025b" },
            { "NF", "Norfold Sup\u0254" },
            { "NG", "Naegyeria" },
            { "NI", "Nekaraguwa" },
            { "NL", "N\u025bd\u025bland" },
            { "NO", "N\u0254\u0254we" },
            { "NP", "N\u025bpal" },
            { "NR", "Naworu" },
            { "NU", "Niyu" },
            { "NZ", "Ziland Foforo" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fr\u025bnkye P\u0254lenehyia" },
            { "PG", "Papua Gini Fofor\u0254" },
            { "PH", "Filipin" },
            { "PK", "Pakistan" },
            { "PL", "P\u0254land" },
            { "PM", "Saint Pierre ne Miquelon" },
            { "PN", "Pitkaan Nsup\u0254" },
            { "PR", "Pu\u025bto Riko" },
            { "PS", "Palestaen West Bank ne Gaza" },
            { "PT", "P\u0254tugal" },
            { "PW", "Palau" },
            { "PY", "Paraguae" },
            { "QA", "Kata" },
            { "QO", "Osiana Ano Ano" },
            { "RE", "Reyuni\u0254n" },
            { "RO", "Romenia" },
            { "RS", "S\u025bbia" },
            { "RU", "R\u0254hyea" },
            { "RW", "Rewanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Solom\u0254n Aeland" },
            { "SC", "Seyhy\u025bl" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singap\u0254" },
            { "SH", "Saint Helena" },
            { "SI", "Slovinia" },
            { "SJ", "Svalbard ne Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "S\u025bra Li\u0254n" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudan Anaafo\u0254" },
            { "ST", "S\u00e3o Tom\u00e9 ne Pr\u00edncipe" },
            { "SV", "\u0190l Salvad\u0254" },
            { "SX", "Sint Maaten" },
            { "SY", "Siria" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Kuna" },
            { "TC", "Turks ne Caicos Islands" },
            { "TD", "Kyad" },
            { "TF", "Franse Anaafo\u0254 Nsaase" },
            { "TG", "Togo" },
            { "TH", "Taeland" },
            { "TJ", "Tagyikistan" },
            { "TK", "Tokelau" },
            { "TL", "Tim\u0254 Boka" },
            { "TM", "T\u025bkm\u025bnistan" },
            { "TN", "Tunihyia" },
            { "TO", "Tonga" },
            { "TR", "T\u025b\u025bki" },
            { "TT", "Trinidad ne Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukren" },
            { "UG", "Yuganda" },
            { "UM", "U.S. Nky\u025bnnky\u025bn Sup\u0254 Ahodo\u0254" },
            { "UN", "Amansan Nkabomkuo" },
            { "US", "Am\u025brika" },
            { "UY", "Yurugwae" },
            { "UZ", "Usb\u025bkistan" },
            { "VA", "Vatican Man" },
            { "VC", "Saint Vincent ne Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Ngresifo\u0254 Virgin Island" },
            { "VI", "Am\u025brika Virgin Islands" },
            { "VN", "Vi\u025btnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ne Futuna" },
            { "WS", "Samoa" },
            { "XA", "Anto Kasa" },
            { "XB", "Anto Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Y\u025bm\u025bn" },
            { "YT", "May\u0254te" },
            { "ZA", "Abibirem Anaafo\u0254" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Mantam a Y\u025bnnim" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amarik" },
            { "ar", metaValue_ar },
            { "as", "Asamese" },
            { "az", "Asabegyanni" },
            { "be", "Belarus kasa" },
            { "bg", "B\u0254lgeria kasa" },
            { "bn", "Bengali kasa" },
            { "br", "Britenni" },
            { "bs", "Bosniani" },
            { "ca", "Katalan" },
            { "cs", "Ky\u025bk kasa" },
            { "cv", "Kyuvahyi" },
            { "cy", "W\u025b\u025bhye Kasa" },
            { "da", "Dane kasa" },
            { "de", metaValue_DE },
            { "el", "Greek kasa" },
            { "en", "Bor\u0254fo" },
            { "eo", "Esperanto" },
            { "es", "Spain kasa" },
            { "et", "Estonia kasa" },
            { "eu", "Baske" },
            { "fa", "P\u025b\u025bhyia kasa" },
            { "ff", "Fula kasa" },
            { "fi", "Finlande kasa" },
            { "fo", "Farosi" },
            { "fr", "Fr\u025bnkye" },
            { "fy", "At\u0254e\u025b Fam Frihyia Kasa" },
            { "ga", "Aerelande kasa" },
            { "gd", "Skotlandfo\u0254 Galek Kasa" },
            { "gl", "Galisia kasa" },
            { "gu", "Gugyarata" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Kurowehyia kasa" },
            { "hu", "Hangri kasa" },
            { "hy", "Aameniani" },
            { "ia", "Kasa ntam" },
            { "id", "Indonihyia kasa" },
            { "ie", "Kasa afrafra" },
            { "ig", "Igbo kasa" },
            { "is", "Aeslande kasa" },
            { "it", "Italy kasa" },
            { "ja", "Gyapan kasa" },
            { "jv", "Gyabanis kasa" },
            { "ka", "Gy\u0254\u0254gyia kasa" },
            { "kk", "kasaki kasa" },
            { "km", "Kambodia kasa" },
            { "kn", metaValue_CA },
            { "ko", metaValue_ko },
            { "ks", "Kahyimi\u025b" },
            { "ku", "K\u025b\u025bde kasa" },
            { "ky", "K\u025bgyese kasa" },
            { "lb", "L\u0254simb\u0254ge kasa" },
            { "lo", metaValue_lo },
            { "lt", "Lituania kasa" },
            { "lv", "Latvia kasa" },
            { "mi", "Mawori" },
            { "mk", "M\u025bsidonia kasa" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marati" },
            { "ms", "Malay kasa" },
            { "mt", "Malta kasa" },
            { "my", "B\u025b\u025bmis kasa" },
            { "ne", "N\u025bpal kasa" },
            { "nl", "D\u025b\u025bkye" },
            { "nn", "N\u0254wefo\u0254 Nin\u0254so" },
            { "no", "N\u0254wefo\u0254 kasa" },
            { "oc", "Osita kasa" },
            { "or", "Odia" },
            { "pa", "Pungyabi kasa" },
            { "pl", "P\u0254land kasa" },
            { "ps", "Pahyito" },
            { "pt", "P\u0254\u0254tugal kasa" },
            { "qu", "Kw\u025bkya" },
            { "rm", "Romanhye kasa" },
            { "ro", "Romenia kasa" },
            { "ru", "Rahyia kasa" },
            { "rw", "Rewanda kasa" },
            { "sa", "Sanskrit kasa" },
            { "sc", "Saadinia kasa" },
            { "sd", "Sindi" },
            { "si", "Sinhala" },
            { "sk", "Slovak Kasa" },
            { "sl", "Slov\u025bniafo\u0254 Kasa" },
            { "so", "Somalia kasa" },
            { "sq", "Aabeniani" },
            { "sr", "S\u025bbia Kasa" },
            { "su", "Sunda Kasa" },
            { "sv", "Sweden kasa" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", "Telugu" },
            { "tg", "T\u025bgyeke kasa" },
            { "th", "Taeland kasa" },
            { "ti", "Tigrinya kasa" },
            { "tk", "T\u025bkm\u025bnistan Kasa" },
            { "to", "Tonga kasa" },
            { "tr", "T\u025b\u025bki kasa" },
            { "tt", "Tata kasa" },
            { "ug", "Yugaa Kasa" },
            { "uk", "Ukren kasa" },
            { "ur", "Urdu kasa" },
            { "uz", "Usb\u025bkistan Kasa" },
            { "vi", "Vi\u025btnam kasa" },
            { "wo", "Wol\u0254fo Kasa" },
            { "xh", "Hosa Kasa" },
            { "yo", "Yoruba" },
            { "za", "Zuang" },
            { "zh", "Kyaena kasa" },
            { "zu", "Zulu" },
            { "ast", "Asturiani" },
            { "bgc", "Harianvi" },
            { "bho", "Bopuri" },
            { "blo", "Anii" },
            { "brx", "Bodo" },
            { "ceb", "Kebuano" },
            { "chr", "Kiroki" },
            { "csw", "Tade\u025bm Kreefo\u0254 Kasa" },
            { "doi", "D\u0254gri" },
            { "dsb", "S\u0254\u0254bia a \u025bw\u0254 fam" },
            { "fil", "Filipin kasa" },
            { "hsb", "Atifi fam S\u0254\u0254bia Kasa" },
            { "kea", "Kabuvadianu" },
            { "kgp", "Kaingang" },
            { "kok", "Konkani kasa" },
            { "kxv", "Kuvi kasa" },
            { "lij", "Liguria kasa" },
            { "lmo", "Lombad kasa" },
            { "mai", "Maetili" },
            { "mni", "Manipuri" },
            { "mul", "Kasa ahodo\u0254" },
            { "nds", "Gyaaman kasa a \u025bw\u0254 fam" },
            { "nqo", "Nko" },
            { "pcm", "Nigeriafo\u0254 Pigyin" },
            { "prg", "Prusia kasa" },
            { "raj", "Ragyasitan kasa" },
            { "sah", "Yakut Kasa" },
            { "sat", "Santal kasa" },
            { "syr", "Siiria Kasa" },
            { "szl", "Silesiafo\u0254 Kasa" },
            { "und", "kasa a y\u025bnnim" },
            { "vec", "V\u025bnihyia Kasa" },
            { "vmw", "Makuwa" },
            { "xnr", "Kangri" },
            { "yrl", "Ningatu" },
            { "yue", "Kantonese" },
            { "zxx", "Lengwestese biara nnim" },
            { "Adlm", "Adlam kasa" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliki kasa" },
            { "Armn", "Amenia kasa" },
            { "Beng", "Bangala kasa" },
            { "Bopo", "Bopomofo kasa" },
            { "Brai", "Anifrafo\u0254 kasa" },
            { "Cakm", "Kyakma kasa" },
            { "Cans", "Kanadafo\u0254 Kann Kasa a W\u0254akeka Abom" },
            { "Cher", "K\u025broki" },
            { "Cyrl", "Kreleke" },
            { "Deva", "D\u025bvanagari kasa" },
            { "Ethi", "Yitiopia kasa" },
            { "Geor", "Dw\u0254\u0254gyia kasa" },
            { "Grek", "Griiki kasa" },
            { "Gujr", "Gudwurati kasa" },
            { "Guru", "Gurumuki kasa" },
            { "Hanb", "Hanse a Bopomofo kasa ka ho" },
            { "Hang", "Hangul kasa" },
            { "Hani", "Han" },
            { "Hans", "Kyaena Kasa Hanse" },
            { "Hant", "Tete" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana kasa" },
            { "Hrkt", "Gyapanfo\u0254 selabolo kasa" },
            { "Jamo", "Gyamo kasa" },
            { "Jpan", "Gyapanfo\u0254 kasa" },
            { "Kana", "Katakana kasa" },
            { "Khmr", "K\u025bma kasa" },
            { "Knda", "Kanada kasa" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "Laatin" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "Meeti May\u025bke kasa" },
            { "Mymr", "Mayama kasa" },
            { "Nkoo", "Nko kasa" },
            { "Olck", "Ol Kyiki kasa" },
            { "Orya", "Odia kasa" },
            { "Rohg", "Hanifi kasa" },
            { "Sinh", "Sinhala kasa" },
            { "Sund", "Sudanni kasa" },
            { "Syrc", "Siiria Tete kasa" },
            { "Taml", metaValue_ta },
            { "Telu", "Telugu kasa" },
            { "Tfng", "Tifinafo kasa" },
            { "Thaa", "Taana kasa" },
            { "Thai", "Taelanfo\u0254 kasa" },
            { "Tibt", "Tib\u025btanfo\u0254 kasa" },
            { "Vaii", "Vai kasa" },
            { "Yiii", "Yifo\u0254 kasa" },
            { "Zmth", "Nkontabude\u025b" },
            { "Zsye", "Yimogyi" },
            { "Zsym", "Ahy\u025bnsode\u025b" },
            { "Zxxx", "De\u025b w\u0254ntwer\u025be\u025b" },
            { "Zyyy", "obiara nim" },
            { "Zzzz", "De\u025b y\u025bnnim" },
            { "de_AT", "\u0186stria Gyaaman" },
            { "de_CH", "Swisalande Gyaaman" },
            { "en_GB", "Ngresi Bor\u0254fo" },
            { "en_US", "Am\u025brika Bor\u0254fo" },
            { "fr_CA", "Kanada Fr\u025bnkye" },
            { "fr_CH", "Swisalande Fr\u025bnkye" },
            { "nl_BE", "D\u025b\u025bkye (B\u025b\u025bgyi\u0254m" },
            { "ar_001", "Arabeke Kasa Nhyehy\u025be\u025b Fofor\u0254" },
            { "es_419", "Spain kasa (Laaten Am\u025brika)" },
            { "key.ca", "Kal\u025bnna" },
            { "key.cf", "Sika F\u0254mate" },
            { "key.co", "Nyiyie Kwan" },
            { "key.cu", "Sika" },
            { "key.hc", "D\u0254nhwere Nk\u0254mmae\u025b (12 anaa 24)" },
            { "key.lb", "Line Break Nhyehy\u025be\u025b" },
            { "key.ms", "Nsusude\u025b Sest\u025bm" },
            { "key.nu", "N\u025bma" },
            { "hi_Latn", "Laatenfo\u0254 Hindi" },
            { "zh_Hans", "Kyaena kasa a emu y\u025b mmr\u025b" },
            { "zh_Hant", "Tete Kyaena kasa" },
            { "type.ca.roc", "Minguo Kal\u025bnda" },
            { "type.hc.h11", "Nn\u0254nhwere 12 Sest\u025bm (0\u201311)" },
            { "type.hc.h12", "Nn\u0254nhwere 12 Sest\u025bm (1\u201312" },
            { "type.hc.h23", "Nn\u0254nhwere 24 Sest\u025bm (0\u201323)" },
            { "type.hc.h24", "Nn\u0254nhwere 24 Sest\u025bm (0\u201324)" },
            { "type.nu.arab", "Arabeke Digyete" },
            { "type.nu.armn", "Aamenia N\u0254ma" },
            { "type.nu.beng", "Bangla Gigyete" },
            { "type.nu.cakm", "Kyakma Digyete" },
            { "type.nu.deva", "Devanagari Gigyete" },
            { "type.nu.ethi", "Yitiopia N\u0254ma" },
            { "type.nu.geor", "Gy\u0254gyea N\u0254ma" },
            { "type.nu.grek", "Griiki N\u0254ma" },
            { "type.nu.gujr", "Gugyarati Digyete" },
            { "type.nu.guru", "Gurumuki Digyete" },
            { "type.nu.hans", "Kyaenafo\u0254 D\u025bsima N\u0254ma a Emu Y\u025b Mmr\u025b" },
            { "type.nu.hant", "Kyaenafo\u0254 Tete N\u0254ma" },
            { "type.nu.hebr", "Hibri N\u0254ma" },
            { "type.nu.java", "Gyavaniisi Digyete" },
            { "type.nu.jpan", "Gyapanfo\u0254 N\u0254ma" },
            { "type.nu.khmr", "Kima Digyete" },
            { "type.nu.knda", "Kanada Digyete" },
            { "type.nu.laoo", "Lawo Digyete" },
            { "type.nu.latn", "At\u0254e\u025b Fam Digyete" },
            { "type.nu.mlym", "Malayalam Digyete" },
            { "type.nu.mtei", "Meeti May\u025bke Digyete" },
            { "type.nu.mymr", "Mayaama Digyete" },
            { "type.nu.olck", "Ol Kyiki Digyete" },
            { "type.nu.orya", "Odia Digyete" },
            { "type.nu.taml", "Tamil Tete N\u0254ma" },
            { "type.nu.telu", "Telugu Digyete" },
            { "type.nu.thai", "Taelanfo\u0254 Digyete" },
            { "type.nu.tibt", "Tib\u025btan Digyete" },
            { "type.nu.vaii", "Vai Gigyete" },
            { "type.ca.dangi", "Dangi Kal\u025bnna" },
            { "type.co.ducet", "Koodu Kor\u0254 Nyiyie Kwan a \u025bdi Kan" },
            { "type.lb.loose", "Line Break Nhyehy\u025be\u025b a Emu Y\u025b Mmr\u025b" },
            { "type.nu.roman", "Roman N\u0254ma" },
            { "type.ca.coptic", "K\u0254tesefo\u0254 Kal\u025bnna" },
            { "type.ca.hebrew", "Hibri Kal\u025bnda" },
            { "type.co.search", "Daa-Botae\u025b Adehwehw\u025b" },
            { "type.lb.normal", "Daa Line Break Nhyehy\u025be\u025b" },
            { "type.lb.strict", "Line Break Nhyehy\u025be\u025b Ferenkyemm" },
            { "type.ms.metric", "M\u025btreke Nhyehy\u025be\u025b" },
            { "type.ca.chinese", "Kyaenafo\u0254 Kal\u025bnna" },
            { "type.ca.islamic", "Higyiri Kal\u025bnda" },
            { "type.ca.iso8601", "ISO-8601 Kal\u025bnna" },
            { "type.ca.persian", "P\u025b\u025bsiafo\u0254 Kal\u025bnda" },
            { "type.cf.account", "Sika Nkotabuo F\u0254mate" },
            { "type.nu.arabext", "Arabeke Digyete a W\u0254atr\u025bm" },
            { "type.nu.armnlow", "Aamenia N\u0254ma Nkumaa" },
            { "type.nu.greklow", "Griiki N\u0254ma Nkumaa" },
            { "type.nu.hanidec", "Kyaenafo\u0254 D\u025bsima N\u0254ma" },
            { "type.nu.hansfin", "Kyaenafo\u0254 Sikas\u025bm D\u025bsima N\u0254ma a Emu Y\u025b Mmr\u025b" },
            { "type.nu.hantfin", "Tete Kyaena Sikas\u025bm N\u0254ma" },
            { "type.nu.jpanfin", "Gyapanfo\u0254 Sikas\u025bm N\u0254ma" },
            { "type.nu.tamldec", "Tamil Digyete" },
            { "type.ca.buddhist", "Budafo\u0254 Kal\u025bnna" },
            { "type.ca.ethiopic", "Yitiopia Kal\u025bnna" },
            { "type.ca.japanese", "Gyapanfo\u0254 Kal\u025bnda" },
            { "type.cf.standard", "Sika F\u0254mate Susudua" },
            { "type.co.standard", "Nyiyie Kwan Susudua" },
            { "type.ms.uksystem", "Imperial Nsusude\u025b Sest\u025bm" },
            { "type.ms.ussystem", "US Nsusude\u025b Sest\u025bm" },
            { "type.nu.fullwide", "Digyete a Emu Pi" },
            { "type.nu.romanlow", "Romanfo\u0254 N\u0254ma Nkumaa" },
            { "type.ca.gregorian", "Gregorian Kal\u025bnna" },
            { "type.ca.islamic-civil", "Higyiri Kal\u025bnda (tabula, sivil epokyi" },
            { "type.ca.islamic-umalqura", "Higyiri Kal\u025bnda (Ummm al-Kura)" },
            { "type.ca.ethiopic-amete-alem", "Yitiopia Amete Al\u025bm Kal\u025bnna" },
        };
        return data;
    }
}
