/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pcm extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Gr\u00ednw\u00edch M\u00edn Taim",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "\u00c1pia F\u00edksd Taim",
               "",
               "\u00c1pia D\u00e9la\u00edt Taim",
               "",
               "\u00c1pia Taim",
               "",
            };
        final String[] Cook = new String[] {
               "K\u00fak A\u00edlands F\u00edksd Taim",
               "",
               "K\u00fak A\u00edlands Haf H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "K\u00fak A\u00edlands Taim",
               "",
            };
        final String[] Cuba = new String[] {
               "K\u00faba F\u00edksd Taim",
               "CST",
               "K\u00faba D\u00e9la\u00edt Taim",
               "CDT",
               "K\u00faba Taim",
               "CT",
            };
        final String[] Fiji = new String[] {
               "F\u00edji F\u00edksd Taim",
               "",
               "F\u00edji H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "F\u00edji Taim",
               "",
            };
        final String[] Gulf = new String[] {
               "G\u1ecd\u0301lf F\u00edksd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd F\u00edksd Taim",
               "",
               "Hovd H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Hovd Taim",
               "",
            };
        final String[] Iran = new String[] {
               "Iran F\u00edksd Taim",
               "",
               "Iran D\u00e9la\u00edt Taim",
               "",
               "Iran Taim",
               "",
            };
        final String[] Niue = new String[] {
               "Ni\u00fa\u1eb9 Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "\u1eccmsk F\u00edksd Taim",
               "",
               "\u1eccmsk H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "\u1eccmsk Taim",
               "",
            };
        final String[] Peru = new String[] {
               "P\u1eb9ru F\u00edksd Taim",
               "",
               "P\u1eb9ru H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "P\u1eb9ru Taim",
               "",
            };
        final String[] Truk = new String[] {
               "Chuk Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "W\u00e9k A\u00edland Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ch\u00edl\u1eb9 F\u00edksd Taim",
               "",
               "Ch\u00edl\u1eb9 H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "Ch\u00edl\u1eb9 Taim",
               "",
            };
        final String[] China = new String[] {
               "Cha\u00edna F\u00edksd Taim",
               "CST",
               "Cha\u00edna D\u00e9la\u00edt Taim",
               "CDT",
               "Cha\u00edna Taim",
               "CT",
            };
        final String[] Cocos = new String[] {
               "K\u00f3k\u00f3s A\u00edlands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "D\u00e9vis Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "\u00cdndia F\u00edksd Taim",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan F\u00edksd Taim",
               "JST",
               "Japan D\u00e9la\u00edt Taim",
               "JDT",
               "Japan Taim",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koria F\u00edksd Taim",
               "KST",
               "Koria D\u00e9la\u00edt Taim",
               "KST",
               "Koria Taim",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Na\u00faru Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "N\u1eb9p\u1ecdl Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Pal\u00e1u Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "S\u00e1mo\u00e1 F\u00edksd Taim",
               "SST",
               "S\u00e1mo\u00e1 D\u00e9la\u00edt Taim",
               "SST",
               "S\u00e1mo\u00e1 Taim",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Si\u00f3wa Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "T\u1ecd\u0301nga F\u00edksd Taim",
               "",
               "T\u1ecd\u0301nga H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "T\u1ecd\u0301nga Taim",
               "",
            };
        final String[] Yukon = new String[] {
               "Yuk\u00f3n Taim",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Al\u00e1sk\u00e1 F\u00edksd Taim",
               "AKST",
               "Al\u00e1sk\u00e1 D\u00e9la\u00edt Taim",
               "AKDT",
               "Al\u00e1sk\u00e1 Taim",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "\u00c1m\u00e1z\u1ecdn F\u00edksd Taim",
               "",
               "\u00c1m\u00e1z\u1ecdn H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "\u00c1m\u00e1z\u1ecdn Taim",
               "",
            };
        final String[] Azores = new String[] {
               "Az\u1ecdz F\u00edksd Taim",
               "",
               "Az\u1ecdz H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Az\u1ecdz Taim",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brun\u1eb9i Dar\u00fasalam Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u00cdsta F\u00edksd Taim",
               "",
               "\u00cdsta H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "\u00cdsta Taim",
               "",
            };
        final String[] Guyana = new String[] {
               "Gay\u00e1na Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "\u00cdzr\u1eb9l F\u00edksd Taim",
               "IST",
               "\u00cdzr\u1eb9l D\u00e9la\u00edt Taim",
               "IDT",
               "\u00cdzr\u1eb9l Taim",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "K\u1ecd\u0301sra\u1eb9 Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "M\u1ecd\u0301s\u1ecdn Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "M\u1ecd\u0301sko F\u00edksd Taim",
               "MSK",
               "M\u1ecd\u0301sko H\u1ecd\u0301t S\u00edzin Taim",
               "MSK",
               "M\u1ecd\u0301sko Taim",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "P\u00f3n\u00e1p\u1eb9 Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tah\u00edti Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taip\u1eb9i F\u00edksd Taim",
               "CST",
               "Taip\u1eb9i D\u00e9la\u00edt Taim",
               "CDT",
               "Taip\u1eb9i Taim",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuv\u00e1lu Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "V\u1ecd\u0301st\u1ecdk Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "W\u00e1lis an F\u00fat\u00fana Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ar\u00e9bi\u00e1 F\u00edksd Taim",
               "",
               "Ar\u00e9bi\u00e1 D\u00e9la\u00edt Taim",
               "",
               "Ar\u00e9bi\u00e1 Taim",
               "",
            };
        final String[] Armenia = new String[] {
               "Arm\u1eb9\u0301nia F\u00edksd Taim",
               "",
               "Arm\u1eb9\u0301nia H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Arm\u1eb9\u0301nia Taim",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bol\u00edvia F\u00edksd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ch\u00e1tam F\u00edksd Taim",
               "",
               "Ch\u00e1tam D\u00e9la\u00edt Taim",
               "",
               "Ch\u00e1tam Taim",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u1eb8\u0301kwu\u00e1d\u1ecd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "G\u00e1mbi\u1eb9r Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "J\u1ecd\u0301jia F\u00edksd Taim",
               "",
               "J\u1ecd\u0301jia H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "J\u1ecd\u0301jia Taim",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irk\u00fatsk F\u00edksd Taim",
               "",
               "Irk\u00fatsk H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Irk\u00fatsk Taim",
               "",
            };
        final String[] Magadan = new String[] {
               "M\u00e1g\u00e1dan F\u00edksd Taim",
               "",
               "M\u00e1g\u00e1dan H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "M\u00e1g\u00e1dan Taim",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mi\u00e1nma Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "N\u1ecd\u0301rf\u1ecd\u0301lk A\u00edland F\u00edksd Taim",
               "",
               "N\u1ecd\u0301rf\u1ecd\u0301lk A\u00edland D\u00e9la\u00edt Taim",
               "",
               "N\u1ecd\u0301rf\u1ecd\u0301lk A\u00edland Taim",
               "",
            };
        final String[] Noronha = new String[] {
               "F\u1eb9rn\u00e1nd\u00f3 di N\u1ecdr\u00f3nia F\u00edksd Taim",
               "",
               "F\u1eb9rn\u00e1nd\u00f3 di N\u1ecdr\u00f3nia H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "F\u1eb9rn\u00e1nd\u00f3 di N\u1ecdr\u00f3nia Taim",
               "",
            };
        final String[] Reunion = new String[] {
               "Riy\u00fani\u1ecdn Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rot\u1eb9\u0301ra Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "S\u00f3l\u00f3m\u1ecd\u0301n A\u00edlands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tok\u1eb9l\u00e1u Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Y\u00farugwue F\u00edksd Taim",
               "",
               "Y\u00farugwue H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "Y\u00farugwue Taim",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanu\u00e1tu F\u00edksd Taim",
               "",
               "Vanu\u00e1tu S\u00edzin Taim",
               "",
               "Vanu\u00e1tu Taim",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Y\u00e9k\u00fatsk F\u00edksd Taim",
               "",
               "Y\u00e9k\u00fatsk H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Y\u00e9k\u00fatsk Taim",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atl\u00e1nt\u00edk F\u00edksd Taim",
               "AST",
               "Atl\u00e1nt\u00edk D\u00e9la\u00edt Taim",
               "AST",
               "Atl\u00e1nt\u00edk Taim",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia F\u00edksd Taim",
               "",
               "Bras\u00edlia H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "Bras\u00edlia Taim",
               "",
            };
        final String[] Chamorro = new String[] {
               "Cham\u00f3ro F\u00edksd Taim",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kol\u00f3mbia F\u00edksd Taim",
               "",
               "Kol\u00f3mbia H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "Kol\u00f3mbia Taim",
               "",
            };
        final String[] Falkland = new String[] {
               "F\u1ecd\u0301lkland F\u00edksd Taim",
               "",
               "F\u1ecd\u0301lkland H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "F\u1ecd\u0301lkland Taim",
               "",
            };
        final String[] Malaysia = new String[] {
               "Mal\u00e9shia Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "M\u1ecd\u0301divs Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "M\u1ecdng\u00f3lia F\u00edksd Taim",
               "",
               "M\u1ecdng\u00f3lia H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "M\u1ecdng\u00f3lia Taim",
               "",
            };
        final String[] Pakistan = new String[] {
               "P\u00e1k\u00edstan F\u00edksd Taim",
               "PKT",
               "P\u00e1k\u00edstan H\u1ecd\u0301t S\u00edzin Taim",
               "PKST",
               "P\u00e1k\u00edstan Taim",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "P\u00e1r\u00e1gwue F\u00edksd Taim",
               "",
               "P\u00e1r\u00e1gwue H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "P\u00e1r\u00e1gwue Taim",
               "",
            };
        final String[] Pitcairn = new String[] {
               "P\u00edtkan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "S\u00e1khalin F\u00edksd Taim",
               "",
               "S\u00e1khalin H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "S\u00e1khalin Taim",
               "",
            };
        final String[] Suriname = new String[] {
               "S\u00far\u00ednam Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Aj\u1eb9nt\u00edna F\u00edksd Taim",
               "",
               "Aj\u1eb9nt\u00edna H\u1ecd\u0301t S\u00edz\u00edn Taim",
               "",
               "Aj\u1eb9nt\u00edna Taim",
               "",
            };
        final String[] Christmas = new String[] {
               "Kr\u00edsm\u00e1s A\u00edland Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Gal\u00e1p\u00e1g\u1ecds Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "H\u1ecdng K\u1ecdng F\u00edksd Taim",
               "HKT",
               "H\u1ecdng K\u1ecdng H\u1ecd\u0301t S\u00edzin Taim",
               "HKST",
               "H\u1ecdng K\u1ecdng Taim",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indocha\u00edna Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "K\u1eb9gistan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "L\u1ecdd Ha\u00fa F\u00edksd Taim",
               "",
               "L\u1ecdd Ha\u00fa D\u00e9la\u00edt Taim",
               "",
               "L\u1ecdd Ha\u00fa Taim",
               "",
            };
        final String[] Marquesas = new String[] {
               "Makw\u1eb9\u0301sas Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "M\u1ecdr\u00edsh\u1ecds F\u00edksd Taim",
               "",
               "M\u1ecdr\u00edsh\u1ecds H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "M\u1ecdr\u00edsh\u1ecds Taim",
               "",
            };
        final String[] Singapore = new String[] {
               "Singap\u1ecd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "V\u1eb9n\u1eb9zu\u1eb9\u0301la Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volv\u00f3grad F\u00edksd Taim",
               "MSK",
               "Volv\u00f3grad H\u1ecd\u0301t S\u00edzin Taim",
               "MSK",
               "Volv\u00f3grad Taim",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Az\u1eb9rbaijan F\u00edksd Taim",
               "",
               "Az\u1eb9rbaijan H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Az\u1eb9rbaijan Taim",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglad\u1eb9sh F\u00edksd Taim",
               "",
               "Banglad\u1eb9sh D\u00e9la\u00edt Taim",
               "",
               "Banglad\u1eb9sh Taim",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kep V\u1eb9\u0301d F\u00edksd Taim",
               "",
               "Kep V\u1eb9\u0301d H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Kep V\u1eb9\u0301d Taim",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00cdst T\u00edm\u1ecd Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "S\u1eb9\u0301ch\u1eb9ls Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Taj\u00edkistan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzb\u1eb9kistan F\u00edksd Taim",
               "",
               "Uzb\u1eb9kistan H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Uzb\u1eb9kistan Taim",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afg\u00e1n\u00edstan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyask F\u00edksd Taim",
               "",
               "Krasnoyask H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Krasnoyask Taim",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ni\u00fa Ziland F\u00edksd Taim",
               "NZST",
               "Ni\u00fa Ziland D\u00e9la\u00edt Taim",
               "NZDT",
               "Ni\u00fa Ziland Taim",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibisk F\u00edksd Taim",
               "",
               "Novosibisk H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Novosibisk Taim",
               "",
            };
        final String[] Philippines = new String[] {
               "F\u00edl\u00edpin F\u00edksd Taim",
               "PST",
               "F\u00edl\u00edpin H\u1ecdt S\u00edzin Taim",
               "PDT",
               "F\u00edl\u00edpin Taim",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladiv\u1ecdst\u1ecdk F\u00edksd Taim",
               "",
               "Vladivostok H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Vladiv\u1ecdst\u1ecdk Taim",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u00cdndi\u00e1n \u00d3sh\u1eb9\u0301n Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "La\u00edn A\u00edlands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ni\u00fafa\u00fandl\u00e1nd F\u00edksd Taim",
               "NST",
               "Ni\u00fafa\u00fandl\u00e1nd D\u00e9la\u00edt Taim",
               "NDT",
               "Ni\u00fafa\u00fandl\u00e1nd Taim",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u1ecdkm\u1eb9nistan F\u00edksd Taim",
               "",
               "T\u1ecdkm\u1eb9nistan H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "T\u1ecdkm\u1eb9nistan Taim",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Fr\u1eb9\u0301nch Gi\u00e1na Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ni\u00fa Kal\u1eb9d\u00f3nia F\u00edksd Taim",
               "",
               "Ni\u00fa Kal\u1eb9d\u00f3nia H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Ni\u00fa Kal\u1eb9d\u00f3nia Taim",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Sa\u00fat J\u1ecd\u0301jia Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Y\u1eb9ket\u1eb9r\u00ednbug F\u00edksd Taim",
               "",
               "Y\u1eb9ket\u1eb9r\u00ednbug H\u1ecd\u0301t S\u00edzin Taim",
               "",
               "Y\u1eb9ket\u1eb9r\u00ednbug Taim",
               "",
            };
        final String[] Africa_Central = new String[] {
               "M\u00edd\u00fal \u00c1fr\u00edk\u00e1 Taim",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00cdst \u00c1fr\u00edk\u00e1 Taim",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "W\u1eb9\u0301st \u00c1fr\u00edk\u00e1 F\u00edksd Taim",
               "WAT",
               "W\u1eb9\u0301st \u00c1fr\u00edk\u00e1 H\u1ecd\u0301t S\u00edzin Taim",
               "WAT",
               "W\u1eb9\u0301st \u00c1fr\u00edk\u00e1 Taim",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Di\u00fam\u1ecd\u0301n-d\u2019Uvil Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "M\u00edd\u00fal Y\u00farop F\u00edksd Taim",
               "CET",
               "M\u00edd\u00fal Y\u00farop H\u1ecd\u0301t S\u00edzin Taim",
               "CEST",
               "M\u00edd\u00fal Y\u00farop Taim",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00cdst\u00e1n Y\u00farop F\u00edksd Taim",
               "EET",
               "\u00cdst\u00e1n Y\u00farop H\u1ecd\u0301t S\u00edzin Taim",
               "EEST",
               "\u00cdst\u00e1n Y\u00farop Taim",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "W\u1eb9\u0301st\u00e1n Y\u00farop F\u00edksd Taim",
               "WET",
               "W\u1eb9\u0301st\u00e1n Y\u00farop H\u1ecd\u0301t S\u00edzin Taim",
               "WEST",
               "W\u1eb9\u0301st\u00e1n Y\u00farop Taim",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "M\u1eb9\u0301ks\u00edk\u00f3 Pas\u00edf\u00edk F\u00edksd Taim",
               "MST",
               "M\u1eb9\u0301ks\u00edk\u00f3 Pas\u00edf\u00edk D\u00e9la\u00edt Taim",
               "MDT",
               "M\u1eb9\u0301ks\u00edk\u00f3 Pas\u00edf\u00edk Taim",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Sa\u00fat \u00c1fr\u00edk\u00e1 F\u00edksd Taim",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 M\u00edd\u00fal \u00c9ri\u00e1 F\u00edksd Taim",
               "CST",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 M\u00edd\u00fal \u00c9ri\u00e1 D\u00e9la\u00edt Taim",
               "CDT",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 M\u00edd\u00fal \u00c9ri\u00e1 Taim",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 \u00cdst\u00e1n \u00c9ri\u00e1 F\u00edksd Taim",
               "EST",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 \u00cdst\u00e1n \u00c9ri\u00e1 D\u00e9la\u00edt Taim",
               "EST",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 \u00cdst\u00e1n \u00c9ri\u00e1 Taim",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 Pas\u00edf\u00edk \u00c9ri\u00e1 F\u00edksd Taim",
               "PST",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 Pas\u00edf\u00edk \u00c9ri\u00e1 D\u00e9la\u00edt Taim",
               "PDT",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 Pas\u00edf\u00edk \u00c9ri\u00e1 Taim",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Fr\u1eb9\u0301nch Sa\u00fatan an Ant\u00e1t\u00edk Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "G\u00edlbat A\u00edlands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawai\u00ed-El\u00fashi\u00e1n F\u00edksd Taim",
               "HST",
               "Hawai\u00ed-El\u00fashi\u00e1n D\u00e9la\u00edt Taim",
               "HST",
               "Hawai\u00ed-El\u00fashi\u00e1n Taim",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u00edniks A\u00edlands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sent Pi\u1eb9r an M\u00edk\u1eb9l\u1ecdn F\u00edksd Taim",
               "",
               "Sent Pi\u1eb9r an M\u00edk\u1eb9l\u1ecdn D\u00e9la\u00edt Taim",
               "",
               "Sent Pi\u1eb9r & M\u00edk\u1eb9l\u1ecdn Taim",
               "",
            };
        final String[] America_Mountain = new String[] {
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 Ma\u00fantin \u00c9ri\u00e1 F\u00edksd Taim",
               "MST",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 Ma\u00fantin \u00c9ri\u00e1 D\u00e9la\u00edt Taim",
               "MST",
               "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edk\u00e1 Ma\u00fantin \u00c9ri\u00e1 Taim",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "M\u00e1shal A\u00edlands Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "P\u00e1pu\u00e1 Ni\u00fa G\u00edni Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "\u1eccstr\u00e9lia M\u00edd\u00fal F\u00edksd Taim",
               "ACST",
               "\u1eccstr\u00e9lia M\u00edd\u00fal D\u00e9la\u00edt Taim",
               "ACDT",
               "M\u00edd\u00fal \u1eccstr\u00e9lia Taim",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u1eccstr\u00e9lia \u00cdst\u00e1n F\u00edksd Taim",
               "AEST",
               "\u1eccstr\u00e9lia \u00cdst\u00e1n D\u00e9la\u00edt Taim",
               "AEDT",
               "\u00cdst\u00e1n \u1eccstr\u00e9lia Taim",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "\u1eccstr\u00e9lia W\u1eb9\u0301st\u00e1n F\u00edksd Taim",
               "AWST",
               "\u1eccstr\u00e9lia W\u1eb9\u0301st\u00e1n D\u00e9la\u00edt Taim",
               "AWDT",
               "W\u1eb9\u0301st\u00e1n \u1eccstr\u00e9lia Taim",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "M\u00edd\u00fal Indon\u1eb9\u0301shia Taim",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00cdst\u00e1n Indon\u1eb9\u0301shia Taim",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "W\u1eb9\u0301st\u00e1n Indon\u1eb9\u0301shia Taim",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "W\u1eb9\u0301st Kaz\u00e9kstan Taim",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u1eccstr\u00e9lia M\u00edd\u00fal W\u1eb9\u0301st\u00e1n F\u00edksd Taim",
               "",
               "\u1eccstr\u00e9lia M\u00edd\u00fal W\u1eb9\u0301st\u00e1n D\u00e9la\u00edt Taim",
               "",
               "\u1eccstr\u00e9lia M\u00edd\u00fal W\u1eb9\u0301st\u00e1n Taim",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "A\u00edr\u00edsh F\u00edksd Taim",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ar\u00e9njm\u1eb9nt \u1ecdf Di H\u00f3l W\u1ecdld Taim",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "A\u00edr\u00edsh F\u00edksd Taim",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Gr\u00ednw\u00edch M\u00edn Taim",
                    "GMT",
                    "Br\u00edt\u00edsh H\u1ecd\u0301t S\u00edzin Taim",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "\u00c9d\u1eb9n" },
            { "timezone.excity.Asia/Dili", "D\u00edli" },
            { "timezone.excity.Asia/Gaza", "G\u00e1za" },
            { "timezone.excity.Asia/Omsk", "\u1eccmsk" },
            { "timezone.excity.Asia/Oral", "\u1ecc\u0301ral" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Aman" },
            { "timezone.excity.Asia/Aqtau", "Akt\u00e1u" },
            { "timezone.excity.Asia/Chita", "Ch\u00edt\u00e1" },
            { "timezone.excity.Asia/Dhaka", "D\u00e1ka" },
            { "timezone.excity.Asia/Macau", "Mak\u00e1o" },
            { "timezone.excity.Asia/Qatar", "K\u00e1ta" },
            { "timezone.excity.Asia/Seoul", "Sol" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3kyo" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "J\u00faba" },
            { "timezone.excity.Africa/Lome", "L\u00f3m\u1eb9" },
            { "timezone.excity.Asia/Almaty", "\u00c1lm\u00e1ti" },
            { "timezone.excity.Asia/Anadyr", "\u00c1nadiar" },
            { "timezone.excity.Asia/Aqtobe", "Akt\u00f3b\u1eb9" },
            { "timezone.excity.Asia/Atyrau", "\u00c1t\u00edrau" },
            { "timezone.excity.Asia/Beirut", "B\u1eb9rut" },
            { "timezone.excity.Asia/Brunei", "Brun\u1eb9i" },
            { "timezone.excity.Asia/Hebron", "H\u1eb9\u0301br\u1ecdn" },
            { "timezone.excity.Asia/Kuwait", "Kuwet" },
            { "timezone.excity.Asia/Manila", "Man\u00edla" },
            { "timezone.excity.Asia/Muscat", "M\u00faskat" },
            { "timezone.excity.Asia/Riyadh", "Riy\u00e1d" },
            { "timezone.excity.Asia/Saigon", "H\u00f3 Chi M\u00edn S\u00edti" },
            { "timezone.excity.Asia/Taipei", "Taip\u1eb9i" },
            { "timezone.excity.Asia/Tehran", "T\u1eb9ran" },
            { "timezone.excity.Asia/Urumqi", "Yur\u1ecd\u0301mki" },
            { "timezone.excity.Etc/Unknown", "Taun w\u00e9 P\u1eb9\u0301sin N\u1ecd\u0301 No" },
            { "timezone.excity.Europe/Kiev", "Ki\u1eb9v" },
            { "timezone.excity.Europe/Oslo", "\u1ecc\u0301slo" },
            { "timezone.excity.Europe/Riga", "R\u00edga" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "timezone.excity.Indian/Mahe", "Mah\u1eb9\u0301" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akr\u00e1" },
            { "timezone.excity.Africa/Cairo", "Ka\u00edro" },
            { "timezone.excity.Africa/Ceuta", "S\u1eb9\u00fata" },
            { "timezone.excity.Africa/Dakar", "Dak\u00e1r" },
            { "timezone.excity.Africa/Lagos", "L\u00e9gos" },
            { "timezone.excity.Africa/Tunis", "T\u00fanis" },
            { "timezone.excity.America/Adak", "\u00c1dak" },
            { "timezone.excity.America/Lima", "L\u00edma" },
            { "timezone.excity.America/Nome", "Noom" },
            { "timezone.excity.Asia/Baghdad", "B\u00e1gdad" },
            { "timezone.excity.Asia/Bahrain", "Bahr\u00e9n" },
            { "timezone.excity.Asia/Bangkok", "B\u00e1nk\u1ecdk" },
            { "timezone.excity.Asia/Barnaul", "B\u00e1rn\u00e1ul" },
            { "timezone.excity.Asia/Bishkek", "Bishk\u1eb9k" },
            { "timezone.excity.Asia/Colombo", "Kol\u00f3mbo" },
            { "timezone.excity.Asia/Irkutsk", "Irk\u00fatsk" },
            { "timezone.excity.Asia/Jakarta", "Jak\u00e1ta" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1chi" },
            { "timezone.excity.Asia/Magadan", "M\u00e1g\u00e1dan" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Rangoon", "Yang\u1ecdn" },
            { "timezone.excity.Asia/Tbilisi", "Tibl\u00edsi" },
            { "timezone.excity.Asia/Thimphu", "T\u00edmfu" },
            { "timezone.excity.Asia/Yakutsk", "Y\u00e9k\u00fatsk" },
            { "timezone.excity.Asia/Yerevan", "Y\u1eb9r\u1eb9\u0301van" },
            { "timezone.excity.Europe/Kirov", "Kir\u1ecdv" },
            { "timezone.excity.Europe/Malta", "M\u1ecd\u0301lta" },
            { "timezone.excity.Europe/Paris", "P\u00e1ris" },
            { "timezone.excity.Europe/Sofia", "Sof\u00eda" },
            { "timezone.excity.Indian/Cocos", "K\u00f3kos" },
            { "timezone.excity.Pacific/Apia", "\u00c1pia" },
            { "timezone.excity.Pacific/Fiji", "F\u00edji" },
            { "timezone.excity.Pacific/Niue", "Ni\u00fa" },
            { "timezone.excity.Pacific/Truk", "Chuk" },
            { "timezone.excity.Pacific/Wake", "Wek" },
            { "timezone.excity.Africa/Asmera", "Asm\u00e1ra" },
            { "timezone.excity.Africa/Bamako", "Bam\u00e1ko" },
            { "timezone.excity.Africa/Bangui", "Bang\u00fai" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "timezone.excity.Africa/Douala", "Du\u00e1la" },
            { "timezone.excity.Africa/Harare", "Har\u00e1r\u1eb9" },
            { "timezone.excity.Africa/Kigali", "Kig\u00e1li" },
            { "timezone.excity.Africa/Luanda", "Lu\u00e1nda" },
            { "timezone.excity.Africa/Lusaka", "Lus\u00e1ka" },
            { "timezone.excity.Africa/Malabo", "Mal\u00e1bo" },
            { "timezone.excity.Africa/Maputo", "Map\u00fato" },
            { "timezone.excity.Africa/Maseru", "Mas\u1eb9\u0301ru" },
            { "timezone.excity.Africa/Niamey", "Ni\u00e1me" },
            { "timezone.excity.America/Aruba", "Ar\u00faba" },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "timezone.excity.America/Belem", "B\u1eb9l\u1eb9m" },
            { "timezone.excity.America/Boise", "B\u1ecd\u00edsi" },
            { "timezone.excity.America/Jujuy", "Huhui" },
            { "timezone.excity.America/Thule", "T\u00fali" },
            { "timezone.excity.Asia/Ashgabat", "\u00c1shgabat" },
            { "timezone.excity.Asia/Calcutta", "Kolk\u00e1ta" },
            { "timezone.excity.Asia/Damascus", "Dam\u00e1sk\u1ecds" },
            { "timezone.excity.Asia/Dushanbe", "Dush\u00e1nb\u1eb9" },
            { "timezone.excity.Asia/Jayapura", "Jayap\u00fara" },
            { "timezone.excity.Asia/Katmandu", "Katm\u00e1ndu" },
            { "timezone.excity.Asia/Khandyga", "Kand\u00edga" },
            { "timezone.excity.Asia/Makassar", "Mak\u00e1sa" },
            { "timezone.excity.Asia/Qostanay", "Kost\u00e1nai" },
            { "timezone.excity.Asia/Sakhalin", "S\u00e1khalin" },
            { "timezone.excity.Asia/Shanghai", "Sh\u00e1nghai" },
            { "timezone.excity.Asia/Tashkent", "T\u00e1shk\u1eb9nt" },
            { "timezone.excity.Asia/Ust-Nera", "Ust-N\u1eb9\u0301ra" },
            { "timezone.excity.Europe/Athens", "\u00c1t\u1eb9ns" },
            { "timezone.excity.Europe/Berlin", "B\u1eb9lin" },
            { "timezone.excity.Europe/Dublin", "D\u1ecd\u0301blin" },
            { "timezone.excity.Europe/Jersey", "J\u1eb9\u0301si" },
            { "timezone.excity.Europe/Lisbon", "L\u00edsb\u1ecdn" },
            { "timezone.excity.Europe/London", "L\u1ecd\u0301nd\u1ecdn" },
            { "timezone.excity.Europe/Monaco", "M\u1ecd\u0301n\u00e1ko" },
            { "timezone.excity.Europe/Moscow", "M\u1ecd\u0301sko" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Samara", "Sam\u00e1ra" },
            { "timezone.excity.Europe/Skopje", "Sk\u1ecd\u0301py\u1eb9" },
            { "timezone.excity.Europe/Tirane", "Tir\u00e1n\u1eb9" },
            { "timezone.excity.Europe/Vienna", "Vi\u1eb9\u0301na" },
            { "timezone.excity.Europe/Warsaw", "W\u1ecd\u0301s\u1ecd" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1gr\u1eb9b" },
            { "timezone.excity.Europe/Zurich", "Z\u00farik" },
            { "timezone.excity.Indian/Chagos", "Ch\u00e1g\u1ecds" },
            { "timezone.excity.Indian/Comoro", "K\u1ecd\u0301m\u1ecd\u0301ros" },
            { "timezone.excity.Pacific/Efate", "\u1eb8f\u00e1t\u1eb9" },
            { "timezone.excity.Pacific/Nauru", "Na\u00faru" },
            { "timezone.excity.Pacific/Palau", "Pal\u00e1u" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "\u00c1bijan" },
            { "timezone.excity.Africa/Algiers", "Alj\u00ed\u1eb9z" },
            { "timezone.excity.Africa/Conakry", "K\u1ecdn\u00e1kri" },
            { "timezone.excity.Africa/Kampala", "Kamp\u00e1la" },
            { "timezone.excity.Africa/Mbabane", "Mbab\u00e1n\u1eb9" },
            { "timezone.excity.Africa/Nairobi", "Na\u00edr\u00f3bi" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edp\u1ecd\u0301li" },
            { "timezone.excity.America/Belize", "B\u1eb9liz" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.America/Cayman", "K\u00e9man" },
            { "timezone.excity.America/Cuiaba", "K\u00fay\u00e1baa" },
            { "timezone.excity.America/Dawson", "D\u1ecd\u0301s\u1ecdn" },
            { "timezone.excity.America/Denver", "D\u1eb9\u0301nva" },
            { "timezone.excity.America/Guyana", "Gay\u00e1na" },
            { "timezone.excity.America/Havana", "Hav\u00e1na" },
            { "timezone.excity.America/Inuvik", "In\u00favik" },
            { "timezone.excity.America/Juneau", "J\u00fano" },
            { "timezone.excity.America/Maceio", "Mas\u1eb9\u0301io" },
            { "timezone.excity.America/Manaus", "Man\u00e1us" },
            { "timezone.excity.America/Merida", "M\u1eb9\u0301r\u00edda" },
            { "timezone.excity.America/Nassau", "N\u00e1ss\u1ecdu" },
            { "timezone.excity.America/Panama", "P\u00e1n\u00e1ma" },
            { "timezone.excity.America/Recife", "R\u1eb9s\u00edf\u1eb9" },
            { "timezone.excity.America/Regina", "R\u1eb9j\u00edna" },
            { "timezone.excity.Asia/Famagusta", "Fag\u00fasta" },
            { "timezone.excity.Asia/Hong_Kong", "H\u1ecdng K\u1ecdng" },
            { "timezone.excity.Asia/Jerusalem", "J\u1eb9r\u00fas\u00e1l\u1eb9m" },
            { "timezone.excity.Asia/Kamchatka", "Kamch\u00e1tk\u00e9" },
            { "timezone.excity.Asia/Pontianak", "P\u1ecdnti\u00e1nak" },
            { "timezone.excity.Asia/Pyongyang", "Pi\u1ecdngyang" },
            { "timezone.excity.Asia/Qyzylorda", "K\u00edzil\u1ecd\u0301da" },
            { "timezone.excity.Asia/Samarkand", "S\u00e1m\u00e1kand" },
            { "timezone.excity.Asia/Singapore", "Singap\u1ecd" },
            { "timezone.excity.Asia/Vientiane", "Vi\u1eb9\u0301nti\u1eb9n" },
            { "timezone.excity.Europe/Andorra", "And\u1ecd\u0301ra" },
            { "timezone.excity.Europe/Saratov", "S\u00e1r\u00e1tov" },
            { "timezone.excity.Europe/Tallinn", "T\u00e1lin" },
            { "timezone.excity.Europe/Vatican", "V\u00e1t\u00edkan" },
            { "timezone.excity.Europe/Vilnius", "V\u00edlnius" },
            { "timezone.excity.Indian/Mayotte", "Mey\u1ecdt" },
            { "timezone.excity.Indian/Reunion", "Riy\u00fani\u1ecdn" },
            { "timezone.excity.Pacific/Easter", "\u00cdsta" },
            { "timezone.excity.Pacific/Kosrae", "K\u1ecd\u0301sra\u1eb9" },
            { "timezone.excity.Pacific/Majuro", "Maj\u00faro" },
            { "timezone.excity.Pacific/Midway", "M\u00eddw\u00e8" },
            { "timezone.excity.Pacific/Noumea", "N\u00fam\u1eb9\u0301a" },
            { "timezone.excity.Pacific/Ponape", "P\u1ecdnp\u1eb9\u0301i" },
            { "timezone.excity.Pacific/Tahiti", "Tah\u00edti" },
            { "timezone.excity.Pacific/Tarawa", "Tar\u00e1wa" },
            { "timezone.excity.Pacific/Wallis", "W\u00e1li" },
            { "timezone.excity.Africa/Blantyre", "Blant\u00e1ya" },
            { "timezone.excity.Africa/Djibouti", "Jib\u00fati" },
            { "timezone.excity.Africa/El_Aaiun", "\u1eb8l Aiun" },
            { "timezone.excity.Africa/Freetown", "Fr\u00edtaun" },
            { "timezone.excity.Africa/Gaborone", "H\u00e1bor\u00f3n\u1eb9" },
            { "timezone.excity.Africa/Khartoum", "Kartum" },
            { "timezone.excity.Africa/Kinshasa", "Kinsh\u00e1sha" },
            { "timezone.excity.Africa/Monrovia", "Monr\u00f3via" },
            { "timezone.excity.Africa/Ndjamena", "Njam\u1eb9\u0301na" },
            { "timezone.excity.Africa/Sao_Tome", "Sao T\u00f3m\u1eb9" },
            { "timezone.excity.Africa/Windhoek", "W\u00edndhok" },
            { "timezone.excity.America/Antigua", "Ant\u00edgwua" },
            { "timezone.excity.America/Caracas", "Kar\u00e1kas" },
            { "timezone.excity.America/Cayenne", "Kay\u1eb9n" },
            { "timezone.excity.America/Chicago", "Chik\u00e1go" },
            { "timezone.excity.America/Cordoba", "K\u00f3rdoba" },
            { "timezone.excity.America/Creston", "Kr\u1eb9\u0301st\u1ecdn" },
            { "timezone.excity.America/Curacao", "Kiur\u00e1sao" },
            { "timezone.excity.America/Detroit", "Ditr\u1ecdit" },
            { "timezone.excity.America/Grenada", "Gr\u1eb9n\u00e9da" },
            { "timezone.excity.America/Halifax", "H\u00e1l\u00edfaks" },
            { "timezone.excity.America/Iqaluit", "Ik\u00e1luit" },
            { "timezone.excity.America/Jamaica", "Jama\u00edka" },
            { "timezone.excity.America/Managua", "Man\u00e1gua" },
            { "timezone.excity.America/Marigot", "M\u00e1r\u00edg\u1ecdt" },
            { "timezone.excity.America/Mendoza", "M\u1eb9nd\u00f3za" },
            { "timezone.excity.America/Moncton", "M\u1ecd\u0301nkt\u1ecdn" },
            { "timezone.excity.America/Noronha", "N\u1ecdr\u00f3nia" },
            { "timezone.excity.America/Ojinaga", "Okhin\u00e1ga" },
            { "timezone.excity.America/Phoenix", "F\u00edniks" },
            { "timezone.excity.America/Tijuana", "Tikhu\u00e1na" },
            { "timezone.excity.America/Toronto", "Tor\u00f3nto" },
            { "timezone.excity.America/Tortola", "T\u1ecdt\u00f3la" },
            { "timezone.excity.America/Yakutat", "Yak\u00fatat" },
            { "timezone.excity.Asia/Choibalsan", "Choib\u00e1lsan" },
            { "timezone.excity.Asia/Phnom_Penh", "Fn\u1ecd\u0301m P\u1eb9n" },
            { "timezone.excity.Atlantic/Azores", "Az\u1ecdz" },
            { "timezone.excity.Atlantic/Canary", "Kener\u00ed" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e1r\u00f3is" },
            { "timezone.excity.Australia/Eucla", "Y\u00fakla" },
            { "timezone.excity.Australia/Perth", "P\u1eb9rt" },
            { "timezone.excity.Europe/Belgrade", "B\u1eb9\u0301lgr\u00e9d" },
            { "timezone.excity.Europe/Brussels", "Br\u00fasuls" },
            { "timezone.excity.Europe/Budapest", "B\u00fad\u00e1p\u1eb9st" },
            { "timezone.excity.Europe/Busingen", "Bus\u00edng\u1eb9n" },
            { "timezone.excity.Europe/Chisinau", "Chisin\u00e1u" },
            { "timezone.excity.Europe/Guernsey", "Gu\u1eb9nzi" },
            { "timezone.excity.Europe/Helsinki", "H\u1eb9ls\u00ednki" },
            { "timezone.excity.Europe/Istanbul", "\u00cdst\u00e1nbul" },
            { "timezone.excity.Europe/Sarajevo", "Saray\u1eb9\u0301vo" },
            { "timezone.excity.Indian/Maldives", "M\u1ecd\u0301ldivs" },
            { "timezone.excity.Pacific/Chatham", "Ch\u00e1tam" },
            { "timezone.excity.Pacific/Fakaofo", "Fak\u00e1\u00f3fo" },
            { "timezone.excity.Pacific/Gambier", "G\u00e1mbi\u1eb9r" },
            { "timezone.excity.Pacific/Norfolk", "N\u1ecd\u0301rf\u1ecd\u0301lk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumb\u00fara" },
            { "timezone.excity.Africa/Mogadishu", "M\u1ecdg\u00e1d\u00edshu" },
            { "timezone.excity.America/Anguilla", "Angw\u00edla" },
            { "timezone.excity.America/Asuncion", "Asunsi\u1ecdn" },
            { "timezone.excity.America/Barbados", "Barb\u00e9d\u1ecds" },
            { "timezone.excity.America/Dominica", "D\u1ecdm\u00edn\u00edka" },
            { "timezone.excity.America/Edmonton", "\u1eb8\u0301dm\u1ecd\u0301nt\u1ecdn" },
            { "timezone.excity.America/Eirunepe", "\u1eb8irun\u1eb9p\u1eb9" },
            { "timezone.excity.America/Mazatlan", "Maz\u00e1tlan" },
            { "timezone.excity.America/Miquelon", "M\u00edk\u1eb9l\u1ecdn" },
            { "timezone.excity.America/New_York", "Ni\u00fa Y\u1ecdk" },
            { "timezone.excity.America/Resolute", "R\u1eb9\u0301z\u00f3lut" },
            { "timezone.excity.America/Santarem", "Santar\u1eb9m" },
            { "timezone.excity.America/Santiago", "Santi\u00e1go" },
            { "timezone.excity.America/St_Johns", "Sent J\u1ecdn" },
            { "timezone.excity.America/St_Kitts", "Sent Kits" },
            { "timezone.excity.America/St_Lucia", "Sent L\u00fashia" },
            { "timezone.excity.America/Winnipeg", "W\u00edn\u00edp\u1eb9g" },
            { "timezone.excity.Antarctica/Casey", "K\u00e9si" },
            { "timezone.excity.Antarctica/Davis", "D\u00e9vis" },
            { "timezone.excity.Antarctica/Syowa", "Si\u00f3wa" },
            { "timezone.excity.Antarctica/Troll", "Trol" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyask" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibisk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanb\u00e1ta" },
            { "timezone.excity.Asia/Vladivostok", "Vladiv\u1ecdst\u1ecdk" },
            { "timezone.excity.Atlantic/Bermuda", "B\u1eb9mi\u00fada" },
            { "timezone.excity.Atlantic/Madeira", "Mad\u00edra" },
            { "timezone.excity.Atlantic/Stanley", "St\u00e1nli" },
            { "timezone.excity.Australia/Darwin", "D\u00e1rwin" },
            { "timezone.excity.Australia/Hobart", "H\u00f3bat" },
            { "timezone.excity.Australia/Sydney", "S\u00eddni" },
            { "timezone.excity.Europe/Amsterdam", "\u00c1mst\u00e1dam" },
            { "timezone.excity.Europe/Astrakhan", "\u00c1strah\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "B\u00fak\u00e1r\u1eb9st" },
            { "timezone.excity.Europe/Gibraltar", "Jibr\u1ecd\u0301lta" },
            { "timezone.excity.Europe/Ljubljana", "Lubli\u00e1na" },
            { "timezone.excity.Europe/Mariehamn", "Mar\u00edah\u00e1mn" },
            { "timezone.excity.Europe/Podgorica", "P\u1ecd\u0301j\u00f3r\u00edka" },
            { "timezone.excity.Europe/Stockholm", "St\u1ecd\u0301kh\u1ecdm" },
            { "timezone.excity.Europe/Ulyanovsk", "Uli\u00e1n\u1ecdvsk" },
            { "timezone.excity.Europe/Volgograd", "Volv\u00f3grad" },
            { "timezone.excity.Indian/Christmas", "Kr\u00edsmas" },
            { "timezone.excity.Indian/Kerguelen", "K\u1eb9\u0301rg\u00fal\u1eb9n" },
            { "timezone.excity.Indian/Mauritius", "M\u1ecdr\u00edsh\u1ecds" },
            { "timezone.excity.Pacific/Auckland", "\u1ecc\u0301kland" },
            { "timezone.excity.Pacific/Funafuti", "Funaf\u00fati" },
            { "timezone.excity.Pacific/Pitcairn", "P\u00edtkan" },
            { "timezone.excity.Africa/Casablanca", "Kasabl\u00e1nka" },
            { "timezone.excity.Africa/Libreville", "L\u00edbr\u1eb9vil" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumb\u00e1shi" },
            { "timezone.excity.Africa/Nouakchott", "Nou\u00e1ksh\u1ecdt" },
            { "timezone.excity.Africa/Porto-Novo", "P\u1ecdto-N\u00f3vo" },
            { "timezone.excity.America/Anchorage", "\u00c1nk\u1ecd\u0301rej" },
            { "timezone.excity.America/Araguaina", "Aragwua\u00edna" },
            { "timezone.excity.America/Boa_Vista", "B\u00f3a V\u00edsta" },
            { "timezone.excity.America/Catamarca", "Katam\u00e1ka" },
            { "timezone.excity.America/Chihuahua", "Chiwu\u00e1wua" },
            { "timezone.excity.America/Fortaleza", "F\u1ecdtal\u1eb9\u0301za" },
            { "timezone.excity.America/Glace_Bay", "Gl\u00e1s B\u00e8" },
            { "timezone.excity.America/Goose_Bay", "G\u00faz B\u00e8" },
            { "timezone.excity.America/Guatemala", "Gu\u00e1t\u1eb9m\u00e1la" },
            { "timezone.excity.America/Guayaquil", "Gu\u00e1yakil" },
            { "timezone.excity.America/Matamoros", "M\u00e1tam\u00f3ros" },
            { "timezone.excity.America/Menominee", "M\u1eb9n\u1ecd\u0301minii" },
            { "timezone.excity.America/Monterrey", "M\u1ecdnt\u1eb9r\u1eb9\u1eb9" },
            { "timezone.excity.America/Sao_Paulo", "Sao Pa\u00falo" },
            { "timezone.excity.America/St_Thomas", "Sent T\u1ecdm\u1ecds" },
            { "timezone.excity.America/Vancouver", "Vank\u00fava" },
            { "timezone.excity.Antarctica/Mawson", "M\u1ecd\u0301s\u1ecdn" },
            { "timezone.excity.Antarctica/Palmer", "P\u00e1ma" },
            { "timezone.excity.Antarctica/Vostok", "V\u1ecd\u0301st\u1ecdk" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Ku\u00e1la L\u00famp\u1ecd" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzn\u1eb9\u0301sk" },
            { "timezone.excity.Europe/Bratislava", "Brat\u00edsl\u00e1va" },
            { "timezone.excity.Europe/Copenhagen", "K\u1ecdp\u1eb9nh\u00e1g\u1eb9n" },
            { "timezone.excity.Europe/Luxembourg", "L\u1ecd\u0301ks\u1eb9\u0301mb\u1ecdg" },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edno" },
            { "timezone.excity.Europe/Simferopol", "S\u00edmf\u1eb9r\u00f3pol" },
            { "timezone.excity.Pacific/Enderbury", "\u1eb8\u0301nd\u00e1b\u1eb9\u0301ri" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1p\u00e1g\u1ecds" },
            { "timezone.excity.Pacific/Kwajalein", "Kw\u00e1jal\u1eb9n" },
            { "timezone.excity.Pacific/Marquesas", "Makw\u1eb9\u0301sas" },
            { "timezone.excity.Pacific/Pago_Pago", "P\u00e1go P\u00e1go" },
            { "timezone.excity.Pacific/Rarotonga", "Rarat\u00f3nga" },
            { "timezone.excity.Pacific/Tongatapu", "Tongat\u00e1pu" },
            { "timezone.excity.Africa/Addis_Ababa", "Ad\u00ed Ab\u00e1ba" },
            { "timezone.excity.Africa/Brazzaville", "Br\u00e1zavil" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagad\u00fagu" },
            { "timezone.excity.America/Costa_Rica", "K\u00f3sta R\u00edka" },
            { "timezone.excity.America/Grand_Turk", "Gr\u00e1nd T\u1ecdk" },
            { "timezone.excity.America/Guadeloupe", "Guadal\u00fap\u1eb9" },
            { "timezone.excity.America/Hermosillo", "H\u1eb9\u0301m\u00f3s\u00edlo" },
            { "timezone.excity.America/Kralendijk", "Kr\u00e1l\u1eb9\u0301ndijk" },
            { "timezone.excity.America/Louisville", "Lu\u00edvil" },
            { "timezone.excity.America/Martinique", "Mat\u00ednik" },
            { "timezone.excity.America/Metlakatla", "M\u1eb9tlak\u00e1tla" },
            { "timezone.excity.America/Montevideo", "M\u1ecdnt\u1eb9vid\u1eb9o" },
            { "timezone.excity.America/Montserrat", "M\u1ecdnts\u1eb9rat" },
            { "timezone.excity.America/Paramaribo", "P\u00e1r\u00e1maribo" },
            { "timezone.excity.America/Rio_Branco", "Ri\u00f3 Br\u00e1nko" },
            { "timezone.excity.America/St_Vincent", "Sent V\u00edns\u1eb9nt" },
            { "timezone.excity.America/Whitehorse", "Wa\u00edth\u1ecds" },
            { "timezone.excity.Antarctica/McMurdo", "McM\u1ecd\u0301do" },
            { "timezone.excity.Antarctica/Rothera", "Rot\u1eb9\u0301ra" },
            { "timezone.excity.Asia/Srednekolymsk", "Sr\u1eb9\u0301dn\u1eb9kolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Y\u1eb9ket\u1eb9r\u00ednbug" },
            { "timezone.excity.Atlantic/Reykjavik", "R\u1eb9\u0301kj\u00e1vik" },
            { "timezone.excity.Atlantic/St_Helena", "Sent H\u1eb9l\u1eb9\u0301na" },
            { "timezone.excity.Australia/Adelaide", "Adleid" },
            { "timezone.excity.Australia/Brisbane", "Br\u00edsben" },
            { "timezone.excity.Australia/Lindeman", "L\u00ednd\u1eb9man" },
            { "timezone.excity.Europe/Isle_of_Man", "A\u00edl \u1ecdf Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kal\u00edn\u00edngrad" },
            { "timezone.excity.Pacific/Kiritimati", "Krit\u00edm\u00e1ti" },
            { "timezone.excity.Africa/Johannesburg", "Joh\u00e1n\u00edsb\u1ecdg" },
            { "timezone.excity.America/El_Salvador", "El S\u00e1lv\u00e1d\u1ecd" },
            { "timezone.excity.America/Fort_Nelson", "F\u1ecdt N\u1eb9\u0301lson" },
            { "timezone.excity.America/Los_Angeles", "L\u1ecds \u00c1nj\u1eb9\u0301lis" },
            { "timezone.excity.America/Mexico_City", "M\u1eb9\u0301ks\u00edk\u00f3 S\u00edti" },
            { "timezone.excity.America/Porto_Velho", "P\u1ecdto V\u1eb9\u0301lho" },
            { "timezone.excity.America/Puerto_Rico", "Pu\u1eb9\u0301rto R\u00edk\u1ecd" },
            { "timezone.excity.America/Tegucigalpa", "T\u1eb9g\u00fasig\u00e1lpa" },
            { "timezone.excity.Arctic/Longyearbyen", "L\u1ecdngy\u1eb9\u0301abi\u1eb9n" },
            { "timezone.excity.Atlantic/Cape_Verde", "K\u00e9p V\u1eb9d" },
            { "timezone.excity.Australia/Lord_Howe", "L\u1ecdd Ha\u00fa" },
            { "timezone.excity.Australia/Melbourne", "M\u1eb9\u0301lb\u1ecdn" },
            { "timezone.excity.Indian/Antananarivo", "Ant\u00e1n\u00e1nar\u00edvo" },
            { "timezone.excity.Pacific/Guadalcanal", "Gu\u00e1d\u00e1lkanal" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar \u1eb9\u0301s Salam" },
            { "timezone.excity.America/Blanc-Sablon", "Blank-S\u00e1bl\u1ecdn" },
            { "timezone.excity.America/Buenos_Aires", "Bu\u1eb9nos A\u00edr\u1eb9s" },
            { "timezone.excity.America/Campo_Grande", "Kamp\u00f3 Gr\u00e1nd\u1eb9" },
            { "timezone.excity.America/Danmarkshavn", "Danm\u00e1ksh\u00e1vun" },
            { "timezone.excity.America/Dawson_Creek", "D\u1ecd\u0301s\u1ecdn Krik" },
            { "timezone.excity.America/Indiana/Knox", "N\u1ecdks, Indi\u00e1na" },
            { "timezone.excity.America/Indianapolis", "Indi\u00e1n\u00e1p\u1ecd\u0301lis" },
            { "timezone.excity.America/Punta_Arenas", "P\u00fant\u00e1 Ar\u1eb9\u0301nas" },
            { "timezone.excity.America/Rankin_Inlet", "R\u00e1nk\u00edn \u00cdnl\u1eb9t" },
            { "timezone.excity.America/Scoresbysund", "It\u00f3kot\u00farmit" },
            { "timezone.excity.Antarctica/Macquarie", "Makwu\u00e9\u00ed" },
            { "timezone.excity.Pacific/Bougainville", "Bugenv\u00edlia" },
            { "timezone.excity.Pacific/Port_Moresby", "P\u1ecdt M\u1ecdr\u1eb9\u0301sbi" },
            { "timezone.excity.America/Cambridge_Bay", "K\u00e9mbr\u00edj B\u00e8" },
            { "timezone.excity.America/Coral_Harbour", "At\u00edk\u00f3kan" },
            { "timezone.excity.America/Indiana/Vevay", "V\u1eb9\u0301ve, Indi\u00e1na" },
            { "timezone.excity.America/Lower_Princes", "L\u00f3w\u00e1 Pr\u00edns Im Kw\u1ecd\u0301ta" },
            { "timezone.excity.America/Port_of_Spain", "P\u1ecd\u0301t \u1ecdf Spen" },
            { "timezone.excity.America/Santo_Domingo", "S\u00e1nt\u00f3 Dom\u00edngo" },
            { "timezone.excity.America/St_Barthelemy", "Sent Bat\u1eb9l\u1eb9\u0301mi" },
            { "timezone.excity.America/Swift_Current", "Sw\u00edft K\u1ecd\u0301r\u1eb9nt" },
            { "timezone.excity.Australia/Broken_Hill", "Br\u00f3k\u00fan Hil" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda Band\u1eb9\u0301ras" },
            { "timezone.excity.America/Port-au-Prince", "P\u1ecdt-o-Prins" },
            { "timezone.excity.Atlantic/South_Georgia", "Sa\u00fat J\u1ecd\u0301jia" },
            { "timezone.excity.America/Argentina/Salta", "S\u00e1lta" },
            { "timezone.excity.America/Indiana/Marengo", "Mar\u1eb9\u0301ngo, Indi\u00e1na" },
            { "timezone.excity.America/Indiana/Winamac", "W\u00edn\u00e1mak, Indi\u00e1na" },
            { "timezone.excity.America/Argentina/Tucuman", "T\u00fak\u00faman" },
            { "timezone.excity.America/Argentina/Ushuaia", "Usu\u00e1ya" },
            { "timezone.excity.America/Indiana/Tell_City", "T\u1eb9\u0301l S\u00edti, Indi\u00e1na" },
            { "timezone.excity.America/Indiana/Vincennes", "V\u00edns\u1eb9n, Indi\u00e1na" },
            { "timezone.excity.Antarctica/DumontDUrville", "Di\u00fam\u1ecd\u0301n-d\u2019Uvil" },
            { "timezone.excity.America/Argentina/La_Rioja", "La Ri\u00f3kha" },
            { "timezone.excity.America/Argentina/San_Juan", "San Hwan" },
            { "timezone.excity.America/Indiana/Petersburg", "P\u00edt\u00e1sb\u1ecdg, Indi\u00e1na" },
            { "timezone.excity.America/Kentucky/Monticello", "M\u1ecdnt\u1eb9ch\u1eb9\u0301lo, K\u1eb9\u0301nt\u1ecd\u0301ki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Bi\u00fala, N\u1ecd\u0301t Dak\u00f3ta" },
            { "timezone.excity.America/North_Dakota/Center", "S\u1eb9\u0301nta, N\u1ecd\u0301t Dak\u00f3ta" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Ri\u00f3 Gal\u1eb9\u0301g\u1ecds" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Ni\u00fa S\u00e9l\u1eb9m, N\u1ecd\u0301t Dak\u00f3ta" },
        };
        return data;
    }
}
