/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_is extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich-sta\u00f0alt\u00edmi",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Ap\u00eda",
               "",
               "Sumart\u00edmi \u00ed Ap\u00eda",
               "",
               "T\u00edmi \u00ed Ap\u00eda",
               "",
            };
        final String[] Cook = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Cooks-eyjum",
               "",
               "H\u00e1lfsumart\u00edmi \u00e1 Cooks-eyjum",
               "",
               "Cooks-eyjat\u00edmi",
               "",
            };
        final String[] Cuba = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 K\u00fabu",
               "CST",
               "Sumart\u00edmi \u00e1 K\u00fabu",
               "CDT",
               "K\u00fabut\u00edmi",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 F\u00eddj\u00edeyjum",
               "",
               "Sumart\u00edmi \u00e1 F\u00eddj\u00edeyjum",
               "",
               "F\u00eddj\u00edeyjat\u00edmi",
               "",
            };
        final String[] Gulf = new String[] {
               "Sta\u00f0alt\u00edmi vi\u00f0 Persafl\u00f3a",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Hovd",
               "",
               "Sumart\u00edmi \u00ed Hovd",
               "",
               "Hovd-t\u00edmi",
               "",
            };
        final String[] Iran = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00cdran",
               "",
               "Sumart\u00edmi \u00ed \u00cdran",
               "",
               "\u00cdranst\u00edmi",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Omsk",
               "",
               "Sumart\u00edmi \u00ed Omsk",
               "",
               "T\u00edmi \u00ed Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Per\u00fa",
               "",
               "Sumart\u00edmi \u00ed Per\u00fa",
               "",
               "Per\u00fat\u00edmi",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "T\u00edmi \u00e1 Wake-eyju",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed S\u00edle",
               "",
               "Sumart\u00edmi \u00ed S\u00edle",
               "",
               "S\u00edlet\u00edmi",
               "",
            };
        final String[] China = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00edna",
               "CST",
               "Sumart\u00edmi \u00ed K\u00edna",
               "CDT",
               "K\u00ednat\u00edmi",
               "CT",
            };
        final String[] Cocos = new String[] {
               "K\u00f3koseyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indlandst\u00edmi",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Japan",
               "JST",
               "Sumart\u00edmi \u00ed Japan",
               "JDT",
               "Japanst\u00edmi",
               "JT",
            };
        final String[] Korea = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00f3reu",
               "KST",
               "Sumart\u00edmi \u00ed K\u00f3reu",
               "KST",
               "K\u00f3reut\u00edmi",
               "KST",
            };
        final String[] Nauru = new String[] {
               "N\u00e1r\u00fa-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalt\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Pal\u00e1t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Sam\u00f3a",
               "SST",
               "Sumart\u00edmi \u00e1 Sam\u00f3a",
               "SST",
               "Sam\u00f3a-t\u00edmi",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Tonga",
               "",
               "Sumart\u00edmi \u00e1 Tonga",
               "",
               "Tongat\u00edmi",
               "",
            };
        final String[] Yukon = new String[] {
               "T\u00edmi \u00ed J\u00fakon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Alaska",
               "AKST",
               "Sumart\u00edmi \u00ed Alaska",
               "AKDT",
               "T\u00edmi \u00ed Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Amas\u00f3nsv\u00e6\u00f0inu",
               "",
               "Sumart\u00edmi \u00e1 Amas\u00f3nsv\u00e6\u00f0inu",
               "",
               "Amas\u00f3nt\u00edmi",
               "",
            };
        final String[] Anadyr = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Anadyr",
               "",
               "Sumart\u00edmi \u00ed Anadyr",
               "",
               "T\u00edmi \u00ed Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 As\u00f3reyjum",
               "",
               "Sumart\u00edmi \u00e1 As\u00f3reyjum",
               "",
               "As\u00f3reyjat\u00edmi",
               "",
            };
        final String[] Bhutan = new String[] {
               "B\u00fatant\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Br\u00faneit\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 P\u00e1skaeyju",
               "",
               "Sumart\u00edmi \u00e1 P\u00e1skaeyju",
               "",
               "P\u00e1skaeyjut\u00edmi",
               "",
            };
        final String[] Guyana = new String[] {
               "Gv\u00e6janat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00cdsrael",
               "IST",
               "Sumart\u00edmi \u00ed \u00cdsrael",
               "IDT",
               "\u00cdsraelst\u00edmi",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Moskvu",
               "MSK",
               "Sumart\u00edmi \u00ed Moskvu",
               "MSK",
               "Moskvut\u00edmi",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Samara",
               "",
               "Sumart\u00edmi \u00ed Samara",
               "",
               "T\u00edmi \u00ed Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tah\u00edt\u00ed-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Taipei",
               "CST",
               "Sumart\u00edmi \u00ed Taipei",
               "CDT",
               "Taipei-t\u00edmi",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "T\u00faval\u00fat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "T\u00edmi \u00e1 Wallis- og F\u00fat\u00fanaeyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Arab\u00edu",
               "",
               "Sumart\u00edmi \u00ed Arab\u00edu",
               "",
               "Arab\u00edut\u00edmi",
               "",
            };
        final String[] Armenia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Armen\u00edu",
               "",
               "Sumart\u00edmi \u00ed Armen\u00edu",
               "",
               "Armen\u00edut\u00edmi",
               "",
            };
        final String[] Bolivia = new String[] {
               "B\u00f3liv\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Chatham",
               "",
               "Sumart\u00edmi \u00ed Chatham",
               "",
               "Chatham-t\u00edmi",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadort\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Georg\u00edu",
               "",
               "Sumart\u00edmi \u00ed Georg\u00edu",
               "",
               "Georg\u00edut\u00edmi",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Irkutsk",
               "",
               "Sumart\u00edmi \u00ed Irkutsk",
               "",
               "T\u00edmi \u00ed Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Magadan",
               "",
               "Sumart\u00edmi \u00ed Magadan",
               "",
               "T\u00edmi \u00ed Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmar-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Norfolk-eyju",
               "",
               "Sumart\u00edmi \u00e1 Norfolk-eyju",
               "",
               "T\u00edmi \u00e1 Norfolk-eyju",
               "",
            };
        final String[] Noronha = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Fernando de Noronha",
               "",
               "Sumart\u00edmi \u00ed Fernando de Noronha",
               "",
               "T\u00edmi \u00ed Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Sal\u00f3monseyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "T\u00f3kel\u00e1-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dar\u00fagv\u00e6",
               "",
               "Sumart\u00edmi \u00ed \u00dar\u00fagv\u00e6",
               "",
               "\u00dar\u00fagv\u00e6t\u00edmi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Van\u00faat\u00fa",
               "",
               "Sumart\u00edmi \u00e1 Van\u00faat\u00fa",
               "",
               "Van\u00faat\u00fa-t\u00edmi",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Yakutsk",
               "",
               "Sumart\u00edmi \u00ed Yakutsk",
               "",
               "T\u00edmi \u00ed Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "AST",
               "Sumart\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "AST",
               "T\u00edmi \u00e1 Atlantshafssv\u00e6\u00f0inu",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Brasil\u00edu",
               "",
               "Sumart\u00edmi \u00ed Brasil\u00edu",
               "",
               "Brasil\u00edut\u00edmi",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-sta\u00f0alt\u00edmi",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed K\u00f3lumb\u00edu",
               "",
               "Sumart\u00edmi \u00ed K\u00f3lumb\u00edu",
               "",
               "K\u00f3lumb\u00edut\u00edmi",
               "",
            };
        final String[] Falkland = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Falklandseyjum",
               "",
               "Sumart\u00edmi \u00e1 Falklandseyjum",
               "",
               "Falklandseyjat\u00edmi",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malas\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Mald\u00edveyja-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dalan Bator",
               "",
               "Sumart\u00edmi \u00ed \u00dalan Bator",
               "",
               "T\u00edmi \u00ed \u00dalan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Pakistan",
               "PKT",
               "Sumart\u00edmi \u00ed Pakistan",
               "PKST",
               "Pakistant\u00edmi",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Paragv\u00e6",
               "",
               "Sumart\u00edmi \u00ed Paragv\u00e6",
               "",
               "Paragv\u00e6t\u00edmi",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Sakhalin",
               "",
               "Sumart\u00edmi \u00ed Sakhalin",
               "",
               "T\u00edmi \u00ed Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "S\u00farinamt\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Argent\u00ednu",
               "",
               "Sumart\u00edmi \u00ed Argent\u00ednu",
               "",
               "Argent\u00ednut\u00edmi",
               "",
            };
        final String[] Christmas = new String[] {
               "J\u00f3laeyjart\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Hong Kong",
               "HKT",
               "Sumart\u00edmi \u00ed Hong Kong",
               "HKST",
               "Hong Kong-t\u00edmi",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ind\u00f3k\u00ednat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "",
               "Sumart\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "",
               "T\u00edmi \u00ed Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Lord Howe-eyju",
               "",
               "Sumart\u00edmi \u00e1 Lord Howe-eyju",
               "",
               "T\u00edmi \u00e1 Lord Howe-eyju",
               "",
            };
        final String[] Marquesas = new String[] {
               "T\u00edmi \u00e1 Markgreifafr\u00fareyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 M\u00e1rit\u00edus",
               "",
               "Sumart\u00edmi \u00e1 M\u00e1rit\u00edus",
               "",
               "M\u00e1rit\u00edust\u00edmi",
               "",
            };
        final String[] Singapore = new String[] {
               "Singap\u00fart\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venes\u00faelat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Volgograd",
               "MSK",
               "Sumart\u00edmi \u00ed Volgograd",
               "MSK",
               "T\u00edmi \u00ed Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Aserba\u00eddsjan",
               "",
               "Sumart\u00edmi \u00ed Aserba\u00eddsjan",
               "",
               "Aserba\u00eddsjant\u00edmi",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Bangladess",
               "",
               "Sumart\u00edmi \u00ed Bangladess",
               "",
               "Bangladess-t\u00edmi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Gr\u00e6nh\u00f6f\u00f0aeyjum",
               "",
               "Sumart\u00edmi \u00e1 Gr\u00e6nh\u00f6f\u00f0aeyjum",
               "",
               "Gr\u00e6nh\u00f6f\u00f0aeyjat\u00edmi",
               "",
            };
        final String[] East_Timor = new String[] {
               "T\u00edmi \u00e1 T\u00edmor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelles-eyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadsj\u00edkistan-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed \u00dasbekistan",
               "",
               "Sumart\u00edmi \u00ed \u00dasbekistan",
               "",
               "\u00dasbekistan-t\u00edmi",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistant\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Krasnoyarsk",
               "",
               "Sumart\u00edmi \u00ed Krasnoyarsk",
               "",
               "T\u00edmi \u00ed Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "NZST",
               "Sumart\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "NZDT",
               "T\u00edmi \u00e1 N\u00fdja-Sj\u00e1landi",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Novosibirsk",
               "",
               "Sumart\u00edmi \u00ed Novosibirsk",
               "",
               "T\u00edmi \u00ed Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Filippseyjum",
               "PST",
               "Sumart\u00edmi \u00e1 Filippseyjum",
               "PDT",
               "Filippseyjat\u00edmi",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vladivostok",
               "",
               "Sumart\u00edmi \u00ed Vladivostok",
               "",
               "T\u00edmi \u00ed Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indlandshafst\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "L\u00ednueyja-t\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 N\u00fdfundnalandi",
               "NST",
               "Sumart\u00edmi \u00e1 N\u00fdfundnalandi",
               "NDT",
               "T\u00edmi \u00e1 N\u00fdfundnalandi",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed T\u00farkmenistan",
               "",
               "Sumart\u00edmi \u00ed T\u00farkmenistan",
               "",
               "T\u00farkmenistan-t\u00edmi",
               "",
            };
        final String[] French_Guiana = new String[] {
               "T\u00edmi \u00ed Fr\u00f6nsku Gv\u00e6jana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "",
               "Sumart\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "",
               "T\u00edmi \u00ed N\u00fdju-Kaled\u00f3n\u00edu",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Su\u00f0ur-Georg\u00edut\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Yekaterinborg",
               "",
               "Sumart\u00edmi \u00ed Yekaterinburg",
               "",
               "T\u00edmi \u00ed Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Mi\u00f0-Afr\u00edkut\u00edmi",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austur-Afr\u00edkut\u00edmi",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Afr\u00edku",
               "WAT",
               "Sumart\u00edmi \u00ed Vestur-Afr\u00edku",
               "WAT",
               "Vestur-Afr\u00edkut\u00edmi",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "T\u00edmi \u00e1 Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mi\u00f0-Evr\u00f3pu",
               "CET",
               "Sumart\u00edmi \u00ed Mi\u00f0-Evr\u00f3pu",
               "CEST",
               "Mi\u00f0-Evr\u00f3put\u00edmi",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Austur-Evr\u00f3pu",
               "EET",
               "Sumart\u00edmi \u00ed Austur-Evr\u00f3pu",
               "EEST",
               "Austur-Evr\u00f3put\u00edmi",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-Evr\u00f3pu",
               "WET",
               "Sumart\u00edmi \u00ed Vestur-Evr\u00f3pu",
               "WEST",
               "Vestur-Evr\u00f3put\u00edmi",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mex\u00edk\u00f3 \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "MST",
               "Sumart\u00edmi \u00ed Mex\u00edk\u00f3 \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "MDT",
               "Kyrrahafst\u00edmi \u00ed Mex\u00edk\u00f3",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Su\u00f0ur-Afr\u00edkut\u00edmi",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "CST",
               "Sumart\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "CDT",
               "T\u00edmi \u00ed mi\u00f0hluta Bandar\u00edkjanna og Kanada",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "EST",
               "Sumart\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "EST",
               "T\u00edmi \u00ed austurhluta Bandar\u00edkjanna og Kanada",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "PST",
               "Sumart\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "PDT",
               "T\u00edmi \u00e1 Kyrrahafssv\u00e6\u00f0inu",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "T\u00edmi \u00e1 fr\u00f6nsku su\u00f0urhafssv\u00e6\u00f0um og Su\u00f0urskautslandssv\u00e6\u00f0i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "T\u00edmi \u00e1 Gilbert-eyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "HST",
               "Sumart\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "HST",
               "T\u00edmi \u00e1 Hava\u00ed og Ale\u00fata",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u00f6nixeyjat\u00edmi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sta\u00f0alt\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "",
               "Sumart\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "",
               "T\u00edmi \u00e1 Sankti Pierre og Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Klettafj\u00f6llum",
               "MST",
               "Sumart\u00edmi \u00ed Klettafj\u00f6llum",
               "MST",
               "T\u00edmi \u00ed Klettafj\u00f6llum",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "T\u00edmi \u00e1 Marshall-eyjum",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "T\u00edmi \u00e1 Pap\u00faa N\u00fdju-G\u00edneu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "ACST",
               "Sumart\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "ACDT",
               "T\u00edmi \u00ed Mi\u00f0-\u00c1stral\u00edu",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "AEST",
               "Sumart\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "AEDT",
               "T\u00edmi \u00ed Austur-\u00c1stral\u00edu",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "AWST",
               "Sumart\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "AWDT",
               "T\u00edmi \u00ed Vestur-\u00c1stral\u00edu",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mi\u00f0-Ind\u00f3nes\u00edut\u00edmi",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austur-Ind\u00f3nes\u00edut\u00edmi",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur-Ind\u00f3nes\u00edut\u00edmi",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "T\u00edmi \u00ed Vestur-Kasakstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Sta\u00f0alt\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "",
               "Sumart\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "",
               "T\u00edmi \u00ed mi\u00f0vesturhluta \u00c1stral\u00edu",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00e1 \u00cdrlandi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Samr\u00e6mdur al\u00fej\u00f3\u00f0legur t\u00edmi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00e1 \u00cdrlandi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich-sta\u00f0alt\u00edmi",
                    "GMT",
                    "Sumart\u00edmi \u00ed Bretlandi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "timezone.excity.Asia/Kabul", "Kab\u00fal" },
            { "timezone.excity.Asia/Macau", "Maka\u00f3" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3k\u00fd\u00f3" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Beirut", "Beir\u00fat" },
            { "timezone.excity.Asia/Brunei", "Br\u00fanei" },
            { "timezone.excity.Asia/Kuwait", "K\u00faveit" },
            { "timezone.excity.Asia/Riyadh", "R\u00edjad" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh-borg" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "\u00d3\u00feekkt borg" },
            { "timezone.excity.Europe/Kiev", "K\u00e6nugar\u00f0ur" },
            { "timezone.excity.Europe/Oslo", "Osl\u00f3" },
            { "timezone.excity.Europe/Rome", "R\u00f3m" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Ka\u00edr\u00f3" },
            { "timezone.excity.Africa/Tunis", "T\u00fanisborg" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Asia/Colombo", "K\u00f3lomb\u00f3" },
            { "timezone.excity.Asia/Jakarta", "Djakarta" },
            { "timezone.excity.Asia/Nicosia", "N\u00edk\u00f3s\u00eda" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Sofia", "S\u00f3f\u00eda" },
            { "timezone.excity.Indian/Cocos", "K\u00f3koseyjar" },
            { "timezone.excity.Pacific/Fiji", "F\u00eddj\u00ed" },
            { "timezone.excity.Pacific/Guam", "Gvam" },
            { "timezone.excity.Africa/Bissau", "Biss\u00e1" },
            { "timezone.excity.America/Aruba", "Ar\u00faba" },
            { "timezone.excity.Asia/Calcutta", "Kalk\u00fatta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Shanghai", "Sjangh\u00e6" },
            { "timezone.excity.Europe/Athens", "A\u00feena" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Lund\u00fanir" },
            { "timezone.excity.Europe/Madrid", "Madr\u00edd" },
            { "timezone.excity.Europe/Monaco", "M\u00f3nak\u00f3" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Tirane", "T\u00edrana" },
            { "timezone.excity.Europe/Vienna", "V\u00edn" },
            { "timezone.excity.Europe/Warsaw", "Varsj\u00e1" },
            { "timezone.excity.Pacific/Nauru", "N\u00e1r\u00fa" },
            { "timezone.excity.Pacific/Palau", "Pal\u00e1" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algeirsborg" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edp\u00f3l\u00ed" },
            { "timezone.excity.America/Belize", "Bel\u00eds" },
            { "timezone.excity.America/Cancun", "Kank\u00fan" },
            { "timezone.excity.America/Cayman", "Cayman-eyjar" },
            { "timezone.excity.America/Guyana", "Gv\u00e6jana" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Jer\u00fasalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Singapore", "Singap\u00far" },
            { "timezone.excity.Europe/Vatican", "Vat\u00edkani\u00f0" },
            { "timezone.excity.Europe/Vilnius", "Viln\u00edus" },
            { "timezone.excity.Pacific/Easter", "P\u00e1skaeyja" },
            { "timezone.excity.Pacific/Tahiti", "Tah\u00edt\u00ed" },
            { "timezone.excity.Africa/Djibouti", "Djib\u00fat\u00ed" },
            { "timezone.excity.Africa/Sao_Tome", "Sa\u00f3 T\u00f3me" },
            { "timezone.excity.America/Antigua", "Ant\u00edgva" },
            { "timezone.excity.America/Jamaica", "Jama\u00edka" },
            { "timezone.excity.America/Tortola", "Tort\u00f3la" },
            { "timezone.excity.Atlantic/Azores", "Azoreyjar" },
            { "timezone.excity.Atlantic/Canary", "Kanar\u00edeyjar" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e6reyjar" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "timezone.excity.Europe/Budapest", "B\u00fadapest" },
            { "timezone.excity.Europe/Istanbul", "Istanb\u00fal" },
            { "timezone.excity.Europe/Sarajevo", "Sarajev\u00f3" },
            { "timezone.excity.Indian/Maldives", "Mald\u00edveyjar" },
            { "timezone.excity.America/Anguilla", "Angvilla" },
            { "timezone.excity.America/Dominica", "D\u00f3min\u00edka" },
            { "timezone.excity.America/St_Kitts", "Sankti Kitts" },
            { "timezone.excity.America/St_Lucia", "Sankti L\u00fas\u00eda" },
            { "timezone.excity.Asia/Ulaanbaatar", "\u00dalan Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Berm\u00fada" },
            { "timezone.excity.Europe/Bucharest", "B\u00fakarest" },
            { "timezone.excity.Europe/Gibraltar", "G\u00edbraltar" },
            { "timezone.excity.Europe/Mariehamn", "Mar\u00eduh\u00f6fn" },
            { "timezone.excity.Europe/Stockholm", "Stokkh\u00f3lmur" },
            { "timezone.excity.Indian/Christmas", "J\u00f3laey" },
            { "timezone.excity.Indian/Mauritius", "M\u00e1rit\u00edus" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/St_Thomas", "Sankti Thomas" },
            { "timezone.excity.Asia/Kuala_Lumpur", "K\u00faala L\u00famp\u00far" },
            { "timezone.excity.Europe/Copenhagen", "Kaupmannah\u00f6fn" },
            { "timezone.excity.Europe/Luxembourg", "L\u00faxemborg" },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edn\u00f3" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas-eyjar" },
            { "timezone.excity.America/Costa_Rica", "Kostar\u00edka" },
            { "timezone.excity.America/Guadeloupe", "Gvadel\u00fap" },
            { "timezone.excity.America/Martinique", "Martin\u00edk" },
            { "timezone.excity.America/St_Vincent", "Sankti Vinsent" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Sankti Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "M\u00f6n" },
            { "timezone.excity.Africa/Johannesburg", "J\u00f3hannesarborg" },
            { "timezone.excity.America/Mexico_City", "Mex\u00edk\u00f3borg" },
            { "timezone.excity.America/Puerto_Rico", "P\u00faert\u00f3 R\u00edk\u00f3" },
            { "timezone.excity.Atlantic/Cape_Verde", "Gr\u00e6nh\u00f6f\u00f0aeyjar" },
            { "timezone.excity.America/St_Barthelemy", "Sankti Bart\u00f3l\u00f3meusareyjar" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Su\u00f0ur-Georg\u00eda" },
        };
        return data;
    }
}
