/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ceb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Oras sa Greenwich Mean",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Tamdanang Oras sa Apia",
               "",
               "Daylight Time sa Apia",
               "",
               "Oras sa Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Tamdanang Oras sa Cook Islands",
               "",
               "Katungang Oras sa Tag-init sa Cook Islands",
               "",
               "Oras sa Cook Islands",
               "",
            };
        final String[] Cuba = new String[] {
               "Tamdanang Oras sa Cuba",
               "CST",
               "Oras sa Tag-init sa Cuba",
               "CDT",
               "Oras sa Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Tamdanang Oras sa Fiji",
               "",
               "Oras sa Tag-init sa Fiji",
               "",
               "Oras sa Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Tamdanang Oras sa Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Tamdanang Oras sa Hovd",
               "",
               "Oras sa Tag-init sa Hovd",
               "",
               "Oras sa Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Tamdanang Oras sa Iran",
               "",
               "Oras sa Tag-init sa Iran",
               "",
               "Oras sa Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Oras sa Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Tamdanang Oras sa Omsk",
               "",
               "Oras sa Tag-init sa Omsk",
               "",
               "Oras sa Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Tamdanang Oras sa Peru",
               "",
               "Oras sa Tag-init sa Peru",
               "",
               "Oras sa Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Oras sa Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Oras sa Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Tamdanang Oras sa Chile",
               "",
               "Oras sa Tag-init sa Chile",
               "",
               "Oras sa Chile",
               "",
            };
        final String[] China = new String[] {
               "Tamdanang Oras sa Tsina",
               "CST",
               "Oras sa Tag-init sa Tsina",
               "CDT",
               "Oras sa Tsina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Oras sa Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Oras sa Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Tamdanang Oras sa India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Tamdanang Oras sa Japan",
               "JST",
               "Oras sa Adlawan sa Japan",
               "JDT",
               "Oras sa Japan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Tamdanang Oras sa Korea",
               "KST",
               "Oras sa Tag-init sa Korea",
               "KST",
               "Oras sa Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Oras sa Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Oras sa Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Oras sa Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Tamdanang Oras sa Samoa",
               "SST",
               "Daylight Time sa Samoa",
               "SST",
               "Oras sa Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Oras sa Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tamdanang Oras sa Tonga",
               "",
               "Oras sa Tag-init sa Tonga",
               "",
               "Oras sa Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Oras sa Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Tamdanang Oras sa Alaska",
               "AKST",
               "Daylight Time sa Alaska",
               "AKDT",
               "Oras sa Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Tamdanang Oras sa Amazon",
               "",
               "Oras sa Tag-init sa Amazon",
               "",
               "Oras sa Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Tamdanang Oras sa Azores",
               "",
               "Oras sa Tag-init sa Azores",
               "",
               "Oras sa Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Oras sa Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Oras sa Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Tamdanang Oras sa Easter Island",
               "",
               "Oras sa Tag-init sa Easter Island",
               "",
               "Oras sa Easter Island",
               "",
            };
        final String[] Guyana = new String[] {
               "Oras sa Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Tamdanang Oras sa Israel",
               "IST",
               "Oras sa Tag-init sa Israel",
               "IDT",
               "Oras sa Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Oras sa Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Oras sa Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Tamdanang Oras sa Moscow",
               "MSK",
               "Oras sa Tag-init sa Moscow",
               "MSK",
               "Oras sa Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Oras sa Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Oras sa Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tamdanang Oras sa Taipei",
               "CST",
               "Oras sa Tag-init sa Taipei",
               "CDT",
               "Oras sa Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Oras sa Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Oras sa Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Oras sa Wallis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Tamdanang Oras sa Arabia",
               "",
               "Oras sa Tag-init sa Arabia",
               "",
               "Oras sa Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Tamdanang Oras sa Armenia",
               "",
               "Oras sa Tag-init sa Armenia",
               "",
               "Oras sa Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Oras sa Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Tamdanang Oras sa Chatham",
               "",
               "Oras sa Tag-init sa Chatham",
               "",
               "Oras sa Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Gikoordinar nga Kinatibuk-ang Oras",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Oras sa Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Oras sa Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Tamdanang Oras sa Georgia",
               "",
               "Oras sa Tag-init sa Georgia",
               "",
               "Oras sa Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Tamdanang Oras sa Irkutsk",
               "",
               "Oras sa Tag-init sa Irkutsk",
               "",
               "Oras sa Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Tamdanang Oras sa Magadan",
               "",
               "Oras sa Tag-init sa Magadan",
               "",
               "Oras sa Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Oras sa Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Tamdanang Oras sa Norfolk Island",
               "",
               "Oras sa Tag-init sa Norfolk Island",
               "",
               "Oras sa Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Tamdanang Oras sa Fernando de Noronha",
               "",
               "Oras sa Tag-init sa Fernando de Noronha",
               "",
               "Oras sa Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Oras sa Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Oras sa Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Oras sa Solomon Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Oras sa Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Tamdanang Oras sa Uruguay",
               "",
               "Oras sa Tag-init sa Uruguay",
               "",
               "Oras sa Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Tamdanang Oras sa Vanuatu",
               "",
               "Oras sa Tag-init sa Vanuatu",
               "",
               "Oras sa Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Tamdanang Oras sa Yakutsk",
               "",
               "Oras sa Tag-init sa Yakutsk",
               "",
               "Oras sa Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic Standard Time",
               "AST",
               "Atlantic Daylight Time",
               "ADT",
               "Atlantic Time",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Tamdanang Oras sa Brasilia",
               "",
               "Oras sa Tag-init sa Brasilia",
               "",
               "Oras sa Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Tamdanang Oras sa Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Tamdanang Oras sa Colombia",
               "",
               "Oras sa Tag-init sa Colombia",
               "",
               "Oras sa Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Tamdanang Oras sa Falkland Islands",
               "",
               "Oras sa Tag-init sa Falkland Islands",
               "",
               "Oras sa Falkland Islands",
               "",
            };
        final String[] Malaysia = new String[] {
               "Oras sa Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Oras sa Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Tamdanang Oras sa Ulaanbaatar",
               "",
               "Oras sa Tag-init sa Ulaanbaatar",
               "",
               "Oras sa Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Tamdanang Oras sa Pakistan",
               "PKT",
               "Oras sa Tag-init sa Pakistan",
               "PKST",
               "Oras sa Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Tamdanang Oras sa Paraguay",
               "",
               "Oras sa Tag-init sa Paraguay",
               "",
               "Oras sa Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Oras sa Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Tamdanang Oras sa Sakhalin",
               "",
               "Oras sa Tag-init sa Sakhalin",
               "",
               "Oras sa Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Oras sa Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Tamdanang Oras sa Argentina",
               "",
               "Oras sa Tag-init sa Argentina",
               "",
               "Oras sa Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Oras sa Christmas Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Oras sa Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Tamdanang Oras sa Hong Kong",
               "HKT",
               "Oras sa Tag-init sa Hong Kong",
               "HKST",
               "Oras sa Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Oras sa Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Oras sa Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Tamdanang Oras sa Lord Howe",
               "",
               "Oras sa Tag-init sa Lord Howe",
               "",
               "Oras sa Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Oras sa Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Tamdanang Oras sa Mauritius",
               "",
               "Oras sa Tag-init sa Mauritius",
               "",
               "Oras sa Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Tamdanang Oras sa Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Oras sa Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Tamdanang Oras sa Volgograd",
               "MSK",
               "Oras sa Tag-init sa Volgograd",
               "MSK",
               "Oras sa Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Tamdanang Oras sa Azerbaijan",
               "",
               "Oras sa Tag-init sa Azerbaijan",
               "",
               "Oras sa Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Tamdanang Oras sa Bangladesh",
               "",
               "Oras sa Tag-init sa Bangladesh",
               "",
               "Oras sa Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Tamdanang Oras sa Cape Verde",
               "",
               "Oras sa Tag-init sa Cape Verde",
               "",
               "Oras sa Cape Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oras sa East Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Oras sa Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Oras sa Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Tamdanang Oras sa Uzbekistan",
               "",
               "Oras sa Tag-init sa Uzbekistan",
               "",
               "Oras sa Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Oras sa Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Tamdanang Oras sa Krasnoyarsk",
               "",
               "Oras sa Tag-init sa Krasnoyarsk",
               "",
               "Oras sa Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Tamdanang Oras sa New Zealand",
               "NZST",
               "Oras sa Tag-init sa New Zealand",
               "NZDT",
               "Oras sa New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Tamdanang Oras sa Novosibirsk",
               "",
               "Oras sa Tag-init sa Novosibirsk",
               "",
               "Oras sa Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Tamdanang Oras sa Pilipinas",
               "PST",
               "Oras sa Tag-init sa Pilipinas",
               "PDT",
               "Oras sa Pilipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Tamdanang Oras sa Vladivostok",
               "",
               "Oras sa Tag-init sa Vladivostok",
               "",
               "Oras sa Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Oras sa Indian Ocean",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Oras sa Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Tamdanang Oras sa Newfoundland",
               "NST",
               "Oras sa Tag-init sa Newfoundland",
               "NDT",
               "Oras sa Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Tamdanang Oras sa Turkmenistan",
               "",
               "Oras sa Tag-init sa Turkmenistan",
               "",
               "Oras sa Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Oras sa French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Tamdanang Oras sa New Caledonia",
               "",
               "Oras sa Tag-init sa New Caledonia",
               "",
               "Oras sa New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Oras sa South Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Tamdanang Oras sa Yekaterinburg",
               "",
               "Oras sa Tag-init sa Yekaterinburg",
               "",
               "Oras sa Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Oras sa Central Africa",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oras sa East Africa",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Tamdanang Oras sa West Africa",
               "WAT",
               "Oras sa Tag-init sa West Africa",
               "WAT",
               "Oras sa West Africa",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Oras sa Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Tamdanang Oras sa Central Europe",
               "CET",
               "Oras sa Tag-init sa Central Europe",
               "CEST",
               "Oras sa Central Europe",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Tamdanang Oras sa Eastern Europe",
               "EET",
               "Oras sa Tag-init sa Eastern Europe",
               "EEST",
               "Oras sa Eastern Europe",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Tamdanang Oras sa Western Europe",
               "WET",
               "Oras sa Tag-init sa Western Europe",
               "WEST",
               "Oras sa Western Europe",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Tamdanang Oras sa Mexican Pacific",
               "MST",
               "Oras sa Tag-init sa Mexican Pacific",
               "MDT",
               "Oras sa Mexican Pacific",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Tamdanang Oras sa South Africa",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Central Standard Time",
               "CST",
               "Central Daylight Time",
               "CDT",
               "Central Time",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern Standard Time",
               "EST",
               "Eastern Daylight Time",
               "EST",
               "Eastern Time",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pacific Standard Time",
               "PST",
               "Pacific Daylight Time",
               "PDT",
               "Pacific Time",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Oras sa French Southern ug Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Oras sa Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Tamdanang Oras sa Hawaii-Aleutian",
               "HST",
               "Oras sa Tag-init sa Hawaii-Aleutian",
               "HST",
               "Oras sa Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Oras sa Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Tamdanang Oras sa St. Pierre & Miquelon",
               "",
               "Oras sa Tag-init sa St.Pierre & Miquelon",
               "",
               "Oras sa St. Pierre & Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain Standard Time",
               "MST",
               "Mountain Daylight Time",
               "MST",
               "Mountain Time",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Oras sa Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Tamdanang Oras sa Northwest Mexico",
               "",
               "Oras sa Tag-init sa Northwest Mexico",
               "",
               "Oras sa Northwest Mexico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Oras sa Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Tamdanang Oras sa Central Australia",
               "ACST",
               "Oras sa Tag-init sa Central Australia",
               "ACDT",
               "Oras sa Central Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Tamdanang Oras sa Eastern Australia",
               "AEST",
               "Oras sa Tag-init sa Eastern Australia",
               "AEDT",
               "Oras sa Eastern Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Tamdanang Oras sa Western Australia",
               "AWST",
               "Oras sa Tag-init sa Western Australia",
               "AWDT",
               "Oras sa Western Australia",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Tamdanang Oras sa East Greenland",
               "",
               "Oras sa Tag-init sa East Greenland",
               "",
               "Oras sa East Greenland",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Tamdanang Oras sa West Greenland",
               "",
               "Oras sa Tag-init sa West Greenland",
               "",
               "Oras sa West Greenland",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Oras sa Central Indonesia",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oras sa Eastern Indonesia",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Oras sa Western Indonesia",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oras sa East Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oras sa West Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Tamdanang Oras sa Central Western Australia",
               "",
               "Oras sa Tag-init sa Central Western Australia",
               "",
               "Oras sa Central Western Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "Tamdanang Oras sa Irish",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "Oras sa Tag-init sa British",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Oras sa Greenwich Mean",
                    "GMT",
                    "Oras sa Tag-init sa British",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Saigon", "Siyudad sa Ho Chi Minh" },
            { "timezone.excity.Etc/Unknown", "Wala Mailhing Lungsod" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
        };
        return data;
    }
}
