/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sc extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ora de su meridianu de Greenwich",
               "OMG",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "Ora istandard de Acre",
               "",
               "Ora legale de Acre",
               "",
               "Ora de Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Ora istandard de Apia",
               "",
               "Ora legale de Apia",
               "",
               "Ora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Ora istandard de sas \u00ccsulas Cook",
               "",
               "Ora legale de sas \u00ccsulas Cook",
               "",
               "Ora de sas \u00ccsulas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora istandard de Cuba",
               "",
               "Ora legale de Cuba",
               "",
               "Ora de Cuba",
               "",
            };
        final String[] Fiji = new String[] {
               "Ora istandard de sas Fiji",
               "",
               "Ora legale de sas Fiji",
               "",
               "Ora de sas Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora istandard de su Gulfu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora istandard de Hovd",
               "",
               "Ora legale de Hovd",
               "",
               "Ora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Ora istandard de s\u2019Ir\u00e0n",
               "",
               "Ora legale de s\u2019Ir\u00e0n",
               "",
               "Ora de s\u2019Ir\u00e0n",
               "",
            };
        final String[] Niue = new String[] {
               "Ora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora istandard de Omsk",
               "",
               "Ora legale de Omsk",
               "",
               "Ora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Ora istandard de su Per\u00f9",
               "",
               "Ora legale de su Per\u00f9",
               "",
               "Ora de su Per\u00f9",
               "",
            };
        final String[] Truk = new String[] {
               "Ora de su Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora de sas \u00ccsulas Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "Ora de Casey",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ora istandard de su Tzile",
               "",
               "Ora legale de su Tzile",
               "",
               "Ora de su Tzile",
               "",
            };
        final String[] China = new String[] {
               "Ora istandard de sa Tzina",
               "",
               "Ora legale de sa Tzina",
               "",
               "Ora de sa Tzina",
               "",
            };
        final String[] Cocos = new String[] {
               "Ora de sas \u00ccsulas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora istandard de s\u2019\u00ccndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Ora istandard de su Giapone",
               "",
               "Ora legale de su Giapone",
               "",
               "Ora de su Giapone",
               "",
            };
        final String[] Korea = new String[] {
               "Ora istandard coreana",
               "",
               "Ora legale coreana",
               "",
               "Ora coreana",
               "",
            };
        final String[] Nauru = new String[] {
               "Ora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora de su Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora istandard de sas Samoa",
               "",
               "Ora legale de sas Samoa",
               "",
               "Ora de sas Samoa",
               "",
            };
        final String[] Syowa = new String[] {
               "Ora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora istandard de su Tonga",
               "",
               "Ora legale de su Tonga",
               "",
               "Ora de su Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Ora de su Yukon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Alaska = new String[] {
               "Ora istandard de s\u2019Alaska",
               "OIAK",
               "Ora legale de s\u2019Alaska",
               "OLAK",
               "Ora de s\u2019Alaska",
               "OAK",
            };
        final String[] Amazon = new String[] {
               "Ora istandard de s\u2019Amatz\u00f2nia",
               "",
               "Ora legale de s\u2019Amatz\u00f2nia",
               "",
               "Ora de s\u2019Amatz\u00f2nia",
               "",
            };
        final String[] Anadyr = new String[] {
               "Ora istandard de Anadyr",
               "",
               "Ora legale de Anadyr",
               "",
               "Ora de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Ora istandard de sas Azorras",
               "",
               "Ora legale de sas Azorras",
               "",
               "Ora de sas Azorras",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora de su Bhut\u00e0n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora de su Brunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora istandard de s\u2019\u00ccsula de Pasca",
               "",
               "Ora legale de s\u2019\u00ccsula de Pasca",
               "",
               "Ora de s\u2019\u00ccsula de Pasca",
               "",
            };
        final String[] Guyana = new String[] {
               "Ora de sa Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ora istandard de Israele",
               "",
               "Ora legale de Israele",
               "",
               "Ora de Israele",
               "",
            };
        final String[] Kosrae = new String[] {
               "Ora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ora istandard de Mosca",
               "",
               "Ora legale de Mosca",
               "",
               "Ora de Mosca",
               "",
            };
        final String[] Ponape = new String[] {
               "Ora de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Ora istandard de Samara",
               "",
               "Ora legale de Samara",
               "",
               "Ora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora de Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora istandard de Taipei",
               "",
               "Ora legale de Taipei",
               "",
               "Ora de Taipei",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Ora de su Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora istandard \u00e0raba",
               "",
               "Ora legale \u00e0raba",
               "",
               "Ora \u00e0raba",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora istandard de s\u2019Arm\u00e8nia",
               "",
               "Ora legale de s\u2019Arm\u00e8nia",
               "",
               "Ora de s\u2019Arm\u00e8nia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora de sa Bol\u00ecvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora istandard de sas Chatham",
               "",
               "Ora legale de sas Chatham",
               "",
               "Ora de sas Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Tempus coordinadu universale",
               "TCU",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora de s\u2019Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora istandard de sa Ge\u00f2rgia",
               "",
               "Ora legale de sa Ge\u00f2rgia",
               "",
               "Ora de sa Ge\u00f2rgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora istandard de Irkutsk",
               "",
               "Ora legale de Irkutsk",
               "",
               "Ora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora istandard de Magadan",
               "",
               "Ora legale de Magadan",
               "",
               "Ora de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora de su Myanm\u00e0r",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora istandard de s\u2019\u00ccsula Norfolk",
               "",
               "Ora legale de s\u2019\u00ccsula Norfolk",
               "",
               "Ora de s\u2019\u00ccsula Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora istandard de su Fernando de Noronha",
               "",
               "Ora legale de su Fernando de Noronha",
               "",
               "Ora de su Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora de sa Reunione",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora de sas \u00ccsulas Salomone",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora de su Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora istandard de s\u2019Uruguay",
               "",
               "Ora legale de s\u2019Uruguay",
               "",
               "Ora de s\u2019Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora istandard de su Vanuatu",
               "",
               "Ora legale de su Vanuatu",
               "",
               "Ora de su Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora istandard de Yakutsk",
               "",
               "Ora legale de Yakutsk",
               "",
               "Ora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora istandard de s\u2019Atl\u00e0nticu",
               "OIA",
               "Ora legale de s\u2019Atl\u00e0nticu",
               "OLA",
               "Ora de s\u2019Atl\u00e0nticu",
               "OA",
            };
        final String[] Brasilia = new String[] {
               "Ora istandard de Bras\u00eclia",
               "",
               "Ora legale de Bras\u00eclia",
               "",
               "Ora de Bras\u00eclia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora istandard de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Ora istandard de sa Col\u00f2mbia",
               "",
               "Ora legale de sa Col\u00f2mbia",
               "",
               "Ora de sa Col\u00f2mbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora istandard de sas \u00ccsulas Falkland",
               "",
               "Ora legale de sas \u00ccsulas Falkland",
               "",
               "Ora de sas \u00ccsulas Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora de sa Mal\u00e8sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora de sas Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora istandard de Ul\u00e0n Bator",
               "",
               "Ora legale de Ul\u00e0n Bator",
               "",
               "Ora de Ul\u00e0n Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora istandard de su P\u00e0kistan",
               "",
               "Ora legale de su P\u00e0kistan",
               "",
               "Ora de su P\u00e0kistan",
               "",
            };
        final String[] Paraguay = new String[] {
               "Ora istandard de su Paraguay",
               "",
               "Ora legale de su Paraguay",
               "",
               "Ora de su Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora de sas Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Ora istandard de Sakhalin",
               "",
               "Ora legale de Sakhalin",
               "",
               "Ora de Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora de su Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora istandard de s\u2019Argentina",
               "",
               "Ora legale de s\u2019Argentina",
               "",
               "Ora de s\u2019Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora de s\u2019\u00ccsula de sa Natividade",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora de sas Gal\u00e0pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora istandard de Hong Kong",
               "",
               "Ora legale de Hong Kong",
               "",
               "Ora de Hong Kong",
               "",
            };
        final String[] Indochina = new String[] {
               "Ora de s\u2019Indotzina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Ora istandard de Petropavlovsk-Kamchatski",
               "",
               "Ora legale de Petropavlovsk-Kamchatski",
               "",
               "Ora de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora de su Kirgh\u00eczistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora istandard de Lord Howe",
               "",
               "Ora legale de Lord Howe",
               "",
               "Ora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora de sas Marchesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora istandard de sas Maur\u00ectzius",
               "",
               "Ora legale de sas Maur\u00ectzius",
               "",
               "Ora de sas Maur\u00ectzius",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora de Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora de su Venetzuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Ora istandard de Volgograd",
               "",
               "Ora legale de Volgograd",
               "",
               "Ora de Volgograd",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ora istandard de s\u2019Azerbaigi\u00e0n",
               "",
               "Ora legale de s\u2019Azerbaigi\u00e0n",
               "",
               "Ora de s\u2019Azerbaigi\u00e0n",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora istandard de su Bangladesh",
               "",
               "Ora legale de su Bangladesh",
               "",
               "Ora de su Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora istandard de su Cabu Birde",
               "",
               "Ora legale de su Cabu Birde",
               "",
               "Ora de su Cabu Birde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora de su Timor Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora de sas Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora de su Tag\u00eckistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora istandard de s\u2019Uzb\u00e8kistan",
               "",
               "Ora legale de s\u2019Uzb\u00e8kistan",
               "",
               "Ora de s\u2019Uzb\u00e8kistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora de s\u2019Afgh\u00e0nistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora istandard de Krasnoyarsk",
               "",
               "Ora legale de Krasnoyarsk",
               "",
               "Ora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora istandard de sa Zelanda Noa",
               "",
               "Ora legale de sa Zelanda Noa",
               "",
               "Ora de sa Zelanda Noa",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Ora istandard de Novosibirsk",
               "",
               "Ora legale de Novosibirsk",
               "",
               "Ora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Ora istandard de sas Filipinas",
               "",
               "Ora legale de sas Filipinas",
               "",
               "Ora de sas Filipinas",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Ora istandard de Vladivostok",
               "",
               "Ora legale de Vladivostok",
               "",
               "Ora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora de s\u2019Otz\u00e8anu Indianu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora de sas \u00ccsulas de sa L\u00ecnia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora istandard de Terranova",
               "",
               "Ora legale de Terranova",
               "",
               "Ora de Terranova",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Ora istandard de su Turkm\u00e8nistan",
               "",
               "Ora legale de su Turkm\u00e8nistan",
               "",
               "Ora de su Turkm\u00e8nistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora de sa Guiana Frantzesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora istandard de sa Caled\u00f2nia Noa",
               "",
               "Ora legale de sa Caled\u00f2nia Noa",
               "",
               "Ora de sa Caled\u00f2nia Noa",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora de sa Ge\u00f2rgia de su Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora istandard de Yekaterinburg",
               "",
               "Ora legale de Yekaterinburg",
               "",
               "Ora de Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora de s\u2019\u00c0frica tzentrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora de s\u2019\u00c0frica orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Ora istandard de s\u2019\u00c0frica otzidentale",
               "",
               "Ora legale de s\u2019\u00c0frica otzidentale",
               "",
               "Ora de s\u2019\u00c0frica otzidentale",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Ora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora istandard de s\u2019Europa tzentrale",
               "",
               "Ora legale de s\u2019Europa tzentrale",
               "",
               "Ora de s\u2019Europa tzentrale",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora istandard de s\u2019Europa orientale",
               "",
               "Ora legale de s\u2019Europa orientale",
               "",
               "Ora de s\u2019Europa orientale",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Ora istandard de s\u2019Europa otzidentale",
               "",
               "Ora legale de s\u2019Europa otzidentale",
               "",
               "Ora de s\u2019Europa otzidentale",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora istandard de su Patz\u00ecficu (M\u00e8ssicu)",
               "",
               "Ora legale de su Patz\u00ecficu (M\u00e8ssicu)",
               "",
               "Ora de su Patz\u00ecficu (M\u00e8ssicu)",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Ora istandard de s\u2019\u00c0frica meridionale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Central = new String[] {
               "Ora istandard tzentrale USA",
               "OIT",
               "Ora legale tzentrale USA",
               "OLT",
               "Ora tzentrale USA",
               "OT",
            };
        final String[] America_Eastern = new String[] {
               "Ora istandard orientale USA",
               "OIO",
               "Ora legale orientale USA",
               "OLO",
               "Ora orientale USA",
               "OO",
            };
        final String[] America_Pacific = new String[] {
               "Ora istandard de su Patz\u00ecficu USA",
               "OIP",
               "Ora legale de su Patz\u00ecficu USA",
               "OLP",
               "Ora de su Patz\u00ecficu USA",
               "OP",
            };
        final String[] French_Southern = new String[] {
               "Ora de sa Terras australes e ant\u00e0rticas frantzesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora de sas \u00ccsulas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora istandard de sas \u00ecsulas Hawaii-Aleutinas",
               "",
               "Ora legale de sas \u00ecsulas Hawaii-Aleutinas",
               "",
               "Ora de sas \u00ecsulas Hawaii-Aleutinas",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora de sas \u00ccsulas de sa Fen\u00ectzie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora istandard de Saint-Pierre e Miquelon",
               "",
               "Ora legale de Saint-Pierre e Miquelon",
               "",
               "Ora de Saint-Pierre e Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora istandard Montes Pedrosos USA",
               "OIMP",
               "Ora legale Montes Pedrosos USA",
               "OLMP",
               "Ora Montes Pedrosos USA",
               "OMP",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora de sas \u00ccsulas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Ora istandard de su M\u00e8ssicu nord-otzidentale",
               "",
               "Ora legale de su M\u00e8ssicu nord-otzidentale",
               "",
               "Ora de su M\u00e8ssicu nord-otzidentale",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora de sa P\u00e0pua Guinea Noa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora istandard de s\u2019Austr\u00e0lia tzentrale",
               "",
               "Ora legale de s\u2019Austr\u00e0lia tzentrale",
               "",
               "Ora de s\u2019Austr\u00e0lia tzentrale",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora istandard de s\u2019Austr\u00e0lia orientale",
               "",
               "Ora legale de s\u2019Austr\u00e0lia orientale",
               "",
               "Ora de s\u2019Austr\u00e0lia orientale",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Ora istandard de s\u2019Austr\u00e0lia otzidentale",
               "",
               "Ora legale de s\u2019Austr\u00e0lia otzidentale",
               "",
               "Ora de s\u2019Austr\u00e0lia otzidentale",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora istandard de sa Groenl\u00e0ndia orientale",
               "",
               "Ora legale de sa Groenl\u00e0ndia orientale",
               "",
               "Ora de sa Groenl\u00e0ndia orientale",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Ora istandard de sa Groenl\u00e0ndia otzidentale",
               "",
               "Ora legale de sa Groenl\u00e0ndia otzidentale",
               "",
               "Ora de sa Groenl\u00e0ndia otzidentale",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora de s\u2019Indon\u00e8sia tzentrale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora de s\u2019Indon\u00e8sia orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora de s\u2019Indon\u00e8sia otzidentale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora de su Kaz\u00e0kistan orientale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora de su Kaz\u00e0kistan otzidentale",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora istandard de s\u2019Austr\u00e0lia tzentru-otzidentale",
               "",
               "Ora legale de s\u2019Austr\u00e0lia tzentru-otzidentale",
               "",
               "Ora de s\u2019Austr\u00e0lia tzentru-otzidentale",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Ora istandard de sas \u00ecsulas Hawaii-Aleutinas",
                    "OIH",
                    "Ora legale de sas \u00ecsulas Hawaii-Aleutinas",
                    "OLH",
                    "Ora de sas \u00ecsulas Hawaii-Aleutinas",
                    "OIH",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ora de su meridianu de Greenwich",
                    "OMG",
                    "Ora istandard irlandesa",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ora de su meridianu de Greenwich",
                    "OMG",
                    "Ora istiale brit\u00e0nnica",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10",
                new String[] {
                    "Ora istandard de sas \u00ecsulas Hawaii-Aleutinas",
                    "OIH",
                    "Ora legale de sas \u00ecsulas Hawaii-Aleutinas",
                    "OLH",
                    "Ora de sas \u00ecsulas Hawaii-Aleutinas",
                    "OIH",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ora de su meridianu de Greenwich",
                    "OMG",
                    "Ora istiale brit\u00e0nnica",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "timezone.excity.Asia/Qatar", "Cat\u00e0r" },
            { "timezone.excity.Asia/Seoul", "Se\u00f9l" },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riy\u00e0d" },
            { "timezone.excity.Asia/Saigon", "Tzitade de Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e0n" },
            { "timezone.excity.Etc/Unknown", "Tzitade disconnota" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Africa/Cairo", "Su C\u00e0iru" },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Tunis", "T\u00f9nisi" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Jakarta", "Giacarta" },
            { "timezone.excity.Europe/Paris", "Parigi" },
            { "timezone.excity.Pacific/Guam", "Gu\u00e0m" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damascu" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Berlin", "Berlinu" },
            { "timezone.excity.Europe/Dublin", "Dublinu" },
            { "timezone.excity.Europe/Lisbon", "Lisbona" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Monaco", "M\u00f2nacu" },
            { "timezone.excity.Europe/Moscow", "Mosca" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Warsaw", "Vars\u00e0via" },
            { "timezone.excity.Europe/Zagreb", "Zag\u00e0bria" },
            { "timezone.excity.Europe/Zurich", "Zurigu" },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "timezone.excity.Africa/Algiers", "Algeri" },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00ecpoli" },
            { "timezone.excity.America/Havana", "S\u2019Avana" },
            { "timezone.excity.America/Panama", "P\u00e0nama" },
            { "timezone.excity.Asia/Jerusalem", "Gerusalemme" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Europe/Vatican", "Tzitade de su Vaticanu" },
            { "timezone.excity.Indian/Mayotte", "Maiota" },
            { "timezone.excity.Indian/Reunion", "Reunione" },
            { "timezone.excity.Pacific/Kanton", "Canton" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aaiun" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Africa/Monrovia", "Monr\u00f2via" },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Atlantic/Azores", "Azorras" },
            { "timezone.excity.Atlantic/Canary", "\u00ccsulas Can\u00e0rias" },
            { "timezone.excity.Atlantic/Faeroe", "\u00ccsulas F\u00f8royar" },
            { "timezone.excity.Europe/Belgrade", "Belgradu" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Europe/Budapest", "B\u00f9dapest" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Istanbul", "\u00ccstanbul" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u00ecsciu" },
            { "timezone.excity.America/New_York", "Noa York" },
            { "timezone.excity.America/St_Johns", "Santu Giuanne" },
            { "timezone.excity.America/St_Kitts", "Santu Cristolu" },
            { "timezone.excity.America/St_Lucia", "Santa Lughia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e0n Bator" },
            { "timezone.excity.Europe/Bucharest", "B\u00f9carest" },
            { "timezone.excity.Europe/Gibraltar", "Gibilterra" },
            { "timezone.excity.Europe/Stockholm", "Istocolma" },
            { "timezone.excity.Indian/Christmas", "Natividade" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "timezone.excity.Indian/Mauritius", "Maur\u00ectzius" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Porto-Novo", "Portu-Nou" },
            { "timezone.excity.America/St_Thomas", "Santu Tommasu" },
            { "timezone.excity.Europe/Luxembourg", "Lussemburgu" },
            { "timezone.excity.Europe/San_Marino", "Santu Marinu" },
            { "timezone.excity.Pacific/Marquesas", "Marchesas" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/St_Vincent", "Santu Vissente" },
            { "timezone.excity.Atlantic/St_Helena", "Sant\u2019Elene" },
            { "timezone.excity.Europe/Isle_of_Man", "\u00ccsula de Man" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.America/Mexico_City", "Tzitade de su M\u00e8ssicu" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabu Birde" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Port_of_Spain", "Portu de Ispagna" },
            { "timezone.excity.America/St_Barthelemy", "Santu Bartolomeu" },
            { "timezone.excity.Atlantic/South_Georgia", "Ge\u00f2rgia de su Sud" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota de su Nord" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota de su Nord" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota de su Nord" },
        };
        return data;
    }
}
