/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pcm extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "T\u1ecd\u0301ki";
        final String metaValue_GE = "J\u1ecd\u0301jia";
        final String metaValue_JP = "Japan";
        final String metaValue_MN = "M\u1ecdng\u00f3lia";
        final String metaValue_nqo = "N\u2019Ko L\u00e1ngwej";
        final String metaValue_syr = "S\u00edri\u00e1k L\u00e1ngwej";
        final String metaValue_th = "Ta\u00ed";
        final Object[][] data = new Object[][] {
            { "001", "W\u1ecdld" },
            { "002", "\u00c1fr\u00edka" },
            { "003", "N\u1ecd\u0301t Am\u1eb9\u0301r\u00edka" },
            { "005", "Sa\u00fat Am\u1eb9\u0301r\u00edka" },
            { "009", "Osh\u1eb9nia" },
            { "011", "W\u1eb9\u0301st\u00e1n \u00c1fr\u00edka" },
            { "013", "M\u00edd\u00fal Am\u1eb9\u0301r\u00edka" },
            { "014", "\u00cdst\u00e1n \u00c1fr\u00edk\u00e1" },
            { "015", "N\u1ecd\u0301t\u00e1n \u00c1fr\u00edka" },
            { "017", "M\u00edd\u00fal \u00c1fr\u00edka" },
            { "018", "Sa\u00fat\u00e1n \u00c1fr\u00edka" },
            { "019", "Am\u1eb9\u0301r\u00edkas" },
            { "021", "N\u1ecd\u0301t\u00e1n Am\u1eb9\u0301r\u00edka" },
            { "029", "Kar\u00edbi\u00e1n" },
            { "030", "\u00cdst\u00e1n \u00c9shia" },
            { "034", "Sa\u00fat\u00e1n \u00c9shia" },
            { "035", "Sa\u00fat\u00edst \u00c9shi\u00e1" },
            { "039", "Sa\u00fat\u00e1n Y\u00farop" },
            { "053", "\u1eccstral\u00e9shia" },
            { "054", "M\u1eb9lan\u1eb9\u00edshia" },
            { "057", "Maikron\u00edshia R\u00edj\u1ecdn" },
            { "061", "Polin\u00edshi\u00e1" },
            { "142", "\u00c9shia" },
            { "143", "M\u00edd\u00fal \u00c9shia" },
            { "145", "W\u1eb9\u0301st\u00e1n \u00c9shia" },
            { "150", "Y\u00farop" },
            { "151", "\u00cdst\u00e1n Y\u00farop" },
            { "154", "N\u1ecd\u0301t\u00e1n Y\u00farop" },
            { "155", "W\u1eb9\u0301st\u00e1n Y\u00farop" },
            { "202", "\u00c1fr\u00edka \u00c9ria Bil\u00f3 Sah\u00e1ra" },
            { "419", "L\u00e1t\u00edn Am\u1eb9\u0301r\u00edka" },
            { "AC", "As\u1eb9\u0301nsh\u1ecd\u0301n A\u00edland" },
            { "AD", "And\u1ecd\u0301ra" },
            { "AE", "Yuna\u00edt\u1eb9\u0301d \u00c1r\u00e1b \u1eb8\u0301m\u00edrets" },
            { "AF", "Afg\u00e1n\u00edstan" },
            { "AG", "Ant\u00edgwua & Barb\u00fada" },
            { "AI", "Angw\u00edla" },
            { "AL", "Alb\u00e9nia" },
            { "AM", "Arm\u1eb9\u0301ni\u00e1" },
            { "AO", "Ang\u00f3la" },
            { "AQ", "Ant\u00e1kt\u00edka" },
            { "AR", "Aj\u1eb9nt\u00edna" },
            { "AS", "Am\u1eb9\u0301r\u00edk\u00e1 Samoa" },
            { "AT", "\u1ecc\u0301stria" },
            { "AU", "\u1eccstr\u00e9lia" },
            { "AW", "Ar\u00faba" },
            { "AX", "\u1ecc\u0301l\u00e1nd A\u00edlands" },
            { "AZ", "Az\u1eb9rbaijan" },
            { "BA", "B\u1ecd\u0301zni\u00e1 & H\u1eb9z\u1eb9gov\u00edna" },
            { "BB", "Barb\u00e9d\u1ecds" },
            { "BD", "Banglad\u1eb9sh" },
            { "BE", "B\u1eb9\u0301lj\u1ecdm" },
            { "BF", "Burk\u00edna F\u00e1so" },
            { "BG", "B\u1ecdlg\u00e9ria" },
            { "BH", "Barein" },
            { "BI", "Bur\u00fandi" },
            { "BJ", "Binin" },
            { "BL", "S\u00e9nt Bat\u1eb9l\u1eb9\u0301mi" },
            { "BM", "B\u1eb9mi\u00fada" },
            { "BN", "Brun\u1eb9i" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Kar\u00edbi\u00e1n N\u1eb9\u0301dalands" },
            { "BR", "Br\u00e1zil" },
            { "BS", "Bah\u00e1mas" },
            { "BT", "Butan" },
            { "BV", "Buv\u1eb9\u0301 A\u00edland" },
            { "BW", "Botsw\u00e1na" },
            { "BY", "B\u1eb9\u0301larus" },
            { "BZ", "B\u1eb9liz" },
            { "CA", "K\u00e1n\u00e1da" },
            { "CC", "K\u00f3k\u00f3s A\u00edlands" },
            { "CD", "K\u00f3ng\u00f3 \u2013 Kinsh\u00e1sa" },
            { "CF", "S\u1eb9\u0301ntr\u00e1l \u00c1fr\u00edk\u00e1n Rip\u1ecd\u0301blik" },
            { "CG", "K\u00f3ngo \u2013 Br\u00e1zavil" },
            { "CH", "Sw\u00edtsaland" },
            { "CI", "A\u00edvri Kost" },
            { "CK", "K\u00fak A\u00edlands" },
            { "CL", "Ch\u00edl\u1eb9" },
            { "CM", "Kam\u1eb9run" },
            { "CN", "Cha\u00edna" },
            { "CO", "Kol\u00f3mbia" },
            { "CP", "Klipat\u1ecd\u0301n A\u00edland" },
            { "CR", "K\u00f3sta R\u00edka" },
            { "CU", "Ki\u00fab\u00e1" },
            { "CV", "K\u00e9p V\u1eb9\u0301d" },
            { "CW", "Kiur\u00e1sao" },
            { "CX", "Kr\u00edsm\u00e1s A\u00edland" },
            { "CY", "Sa\u00edpr\u1ecds" },
            { "CZ", "Ch\u1eb9\u0301kia" },
            { "DE", "J\u00e1m\u00e1ni" },
            { "DG", "Di\u1eb9\u0301g\u00f3 Garsia" },
            { "DJ", "Jib\u00fati" },
            { "DK", "D\u1eb9\u0301nmak" },
            { "DM", "D\u1ecdm\u00edn\u00edka" },
            { "DO", "D\u1ecdm\u00edn\u00edka Rip\u1ecd\u0301blik" },
            { "DZ", "Alj\u00edria" },
            { "EA", "S\u1eb9\u00fata & M\u1eb9\u0301l\u00edla" },
            { "EC", "\u1eb8\u0301kwu\u00e1d\u1ecd" },
            { "EE", "\u1eb8st\u00f3nia" },
            { "EG", "\u00cdjipt" },
            { "EH", "W\u1eb9\u0301st\u00e1n Sah\u00e1ra" },
            { "ER", "\u1eb8ritr\u1eb9\u0301a" },
            { "ES", "Spen" },
            { "ET", "\u1eb8ti\u00f3pia" },
            { "EU", "Yur\u00f3pi\u00e1n Y\u00fani\u1ecd\u0301n" },
            { "EZ", "Y\u00far\u00f3\u00e9ria" },
            { "FI", "F\u00ednland" },
            { "FJ", "F\u00edji" },
            { "FK", "F\u1ecd\u0301kl\u00e1nd A\u00edlands" },
            { "FM", "Maikron\u00edshia" },
            { "FO", "F\u00e1ro A\u00edlands" },
            { "FR", "Frans" },
            { "GA", "Gab\u1ecdn" },
            { "GB", "Yun\u00e1\u00edt\u1eb9\u0301d K\u00ednd\u1ecdm" },
            { "GD", "Gr\u1eb9n\u00e9da" },
            { "GE", metaValue_GE },
            { "GF", "Fr\u1eb9\u0301nch Gi\u00e1na" },
            { "GG", "Gu\u1eb9nzi" },
            { "GH", "G\u00e1na" },
            { "GI", "Jibr\u1ecd\u0301lta" },
            { "GL", "Gr\u00ednland" },
            { "GM", "G\u00e1mbia" },
            { "GN", "G\u00edni" },
            { "GP", "Guadal\u00fap\u1eb9" },
            { "GQ", "Ikw\u00e9t\u00f3ri\u00e1l G\u00edni" },
            { "GR", "Gris" },
            { "GS", "Sa\u00fat J\u1ecd\u0301jia an Sa\u00fat S\u00e1ndw\u00edch A\u00edlands" },
            { "GT", "Gu\u00e1t\u1eb9m\u00e1la" },
            { "GU", "Guam" },
            { "GW", "G\u00edn\u00ed-Bis\u00e1u" },
            { "GY", "Gay\u00e1na" },
            { "HK", "H\u1ecdng K\u1ecdng SAR" },
            { "HM", "Hi\u00e1d & MakD\u00f3n\u00e1ld A\u00edlands" },
            { "HN", "H\u1ecdnd\u00faras" },
            { "HR", "Kro\u00e9shia" },
            { "HT", "Ha\u00edti" },
            { "HU", "H\u1ecd\u0301ng\u00e1ri" },
            { "IC", "Kener\u00ed A\u00edlands" },
            { "ID", "Indon\u00edshia" },
            { "IE", "Ayaland" },
            { "IL", "\u00cdzr\u1eb9l" },
            { "IM", "A\u00edl \u1ecdf Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Br\u00edt\u00edsh \u00cdndi\u00e1n \u00d3shen T\u1eb9\u0301r\u1eb9\u0301tri" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "A\u00edsland" },
            { "IT", "\u00cdt\u00e1li" },
            { "JE", "J\u1eb9\u0301si" },
            { "JM", "Jama\u00edka" },
            { "JO", "J\u1ecd\u0301dan" },
            { "JP", metaValue_JP },
            { "KE", "K\u1eb9\u0301nya" },
            { "KG", "K\u1eb9j\u00edstan" },
            { "KH", "Kamb\u00f3dia" },
            { "KI", "Kirib\u00e1ti" },
            { "KM", "K\u1ecd\u0301m\u1ecd\u0301ros" },
            { "KN", "Sent Kits & N\u1eb9\u0301vis" },
            { "KP", "N\u1ecd\u0301t Koria" },
            { "KR", "Sa\u00fat Koria" },
            { "KW", "Kuw\u00e9t" },
            { "KY", "K\u00e9man A\u00edlands" },
            { "KZ", "Kazakstan" },
            { "LA", "Laos" },
            { "LB", "L\u1eb9\u0301b\u00e1n\u1ecdn" },
            { "LC", "Sent L\u00fashia" },
            { "LI", "L\u00edkt\u1eb9\u0301nstain" },
            { "LK", "Sri L\u00e1nka" },
            { "LR", "Laib\u1eb9\u0301ria" },
            { "LS", "L\u1eb9s\u00f3to" },
            { "LT", "Litu\u00e9nia" },
            { "LU", "L\u1ecd\u0301ks\u1eb9\u0301mb\u1ecdg" },
            { "LV", "L\u00e1tvia" },
            { "LY", "L\u00edbia" },
            { "MA", "Mor\u1ecdko" },
            { "MC", "M\u1ecd\u0301n\u00e1ko" },
            { "MD", "M\u1ecdld\u00f3va" },
            { "ME", "M\u1ecdntin\u00edgro" },
            { "MF", "Sent M\u00e1tin" },
            { "MG", "Madag\u00e1ska" },
            { "MH", "M\u00e1sh\u00e1l A\u00edlands" },
            { "MK", "N\u1ecd\u0301t Masid\u00f3nia" },
            { "ML", "M\u00e1li" },
            { "MM", "Mi\u00e1nma (B\u1ecd\u0301ma)" },
            { "MN", metaValue_MN },
            { "MO", "Mak\u00e1o SAR Cha\u00edna" },
            { "MP", "N\u1ecd\u0301t\u00e1n Mari\u00e1na A\u00edlands" },
            { "MQ", "Mat\u00ednik" },
            { "MR", "M\u1ecdrit\u00e9nia" },
            { "MS", "M\u1ecdnts\u1eb9rat" },
            { "MT", "M\u1ecd\u0301lta" },
            { "MU", "M\u1ecdr\u00edsh\u1ecds" },
            { "MV", "M\u1ecd\u0301ldivs" },
            { "MW", "Mal\u00e1wi" },
            { "MX", "M\u1eb9\u0301ks\u00edko" },
            { "MY", "Mal\u00e9shia" },
            { "MZ", "Moz\u00e1mbik" },
            { "NA", "Nam\u00edbia" },
            { "NC", "Ni\u00fa Kal\u1eb9d\u00f3nia" },
            { "NE", "Nizh\u1eb9r" },
            { "NF", "N\u1ecd\u0301f\u1ecdlk A\u00edland" },
            { "NG", "Naij\u00edria" },
            { "NI", "Nikar\u00e1gwua" },
            { "NL", "N\u1eb9\u0301dalands" },
            { "NO", "N\u1ecd\u0301we" },
            { "NP", "N\u1eb9\u0301pal" },
            { "NR", "N\u00e1uru" },
            { "NU", "Ni\u00fa\u1eb9" },
            { "NZ", "Ni\u00fa Z\u00edland" },
            { "OM", "Oman" },
            { "PA", "P\u00e1n\u00e1ma" },
            { "PE", "P\u1eb9\u0301ru" },
            { "PF", "Fr\u1eb9\u0301nch Polin\u00edshia" },
            { "PG", "P\u00e1pu\u00e1 Ni\u00fa G\u00edni" },
            { "PH", "F\u00edl\u00edpins" },
            { "PK", "Pak\u00edstan" },
            { "PL", "P\u00f3land" },
            { "PM", "Sent Pi\u1eb9r & M\u00edk\u1eb9l\u1ecdn" },
            { "PN", "P\u00edtk\u00e9n A\u00edlands" },
            { "PR", "Pu\u1eb9\u0301rto R\u00edk\u1ecd" },
            { "PS", "P\u00e1l\u1eb9\u0301sta\u00edn \u00c9ria-d\u1eb9m" },
            { "PT", "P\u1ecd\u0301t\u00fagal" },
            { "PW", "Palau" },
            { "PY", "P\u00e1r\u00e1gwue" },
            { "QA", "Kata" },
            { "QO", "Rim\u00f3t P\u00e1t \u1ecdf Osh\u1eb9\u0301nia" },
            { "RE", "R\u00e9y\u00fani\u1ecdn" },
            { "RO", "Rum\u00e9nia" },
            { "RS", "S\u1eb9\u0301bia" },
            { "RU", "R\u1ecd\u0301shia" },
            { "RW", "Ruw\u00e1nda" },
            { "SA", "Sa\u00fad\u00ed Ar\u00e9bia" },
            { "SB", "S\u00f3l\u00f3m\u1ecd\u0301n A\u00edlands" },
            { "SC", "S\u1eb9\u0301ch\u1eb9ls" },
            { "SD", "Sudan" },
            { "SE", "Sw\u00edd\u1eb9n" },
            { "SG", "Singap\u1ecd" },
            { "SH", "Sent H\u1eb9l\u1eb9\u0301na" },
            { "SI", "Slov\u1eb9\u0301nia" },
            { "SJ", "Sv\u00e1lbad & J\u00e9n Mey\u1eb9n" },
            { "SK", "Slov\u00e9kia" },
            { "SL", "Si\u1eb9\u0301ra L\u00edon" },
            { "SM", "San Mar\u00edno" },
            { "SN", "S\u1eb9\u0301n\u1eb9\u0301gal" },
            { "SO", "S\u1ecdm\u00e1lia" },
            { "SR", "S\u00far\u00ednam" },
            { "SS", "Sa\u00fat Sudan" },
            { "ST", "Sao T\u00f3m\u00e9 & Pr\u00edns\u00edp\u1eb9" },
            { "SV", "El S\u00e1lv\u00e1d\u1ecd" },
            { "SX", "Sint M\u00e1tin" },
            { "SY", "S\u00edria" },
            { "SZ", "\u1eb8swat\u00edni" },
            { "TA", "Tr\u00edst\u00e1n da K\u00fana" },
            { "TC", "T\u1ecdks an Ka\u00edk\u1ecd\u0301s A\u00edlands" },
            { "TD", "Chad" },
            { "TF", "Fr\u1eb9\u0301nch Sa\u00fat\u00e1n T\u1eb9\u0301r\u1eb9\u0301tris" },
            { "TG", "T\u00f3go" },
            { "TH", "Ta\u00edland" },
            { "TJ", "Taj\u00edkstan" },
            { "TK", "T\u00f3k\u1eb9\u0301lau" },
            { "TL", "\u00cdst T\u00edm\u1ecd" },
            { "TM", "T\u1ecdkm\u1eb9\u0301n\u00edstan" },
            { "TN", "Tun\u00edshia" },
            { "TO", "T\u00f3nga" },
            { "TR", metaValue_TR },
            { "TT", "Tr\u00edn\u00eddad & Tob\u00e1go" },
            { "TV", "Tuv\u00e1lu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanz\u00e1nia" },
            { "UA", "Yukrein" },
            { "UG", "Yug\u00e1nda" },
            { "UM", "U.S. Fa\u00e1 Fa\u00e1 A\u00edlands" },
            { "UN", "Yuna\u00edt\u1eb9d N\u00e9sh\u1ecdns" },
            { "US", "Yuna\u00edt\u1eb9\u0301d Stets" },
            { "UY", "Y\u00farugwue" },
            { "UZ", "Uzb\u1eb9\u0301kistan" },
            { "VA", "V\u00e1t\u00edk\u00e1n S\u00edti" },
            { "VC", "Sent V\u00edns\u1eb9nt & Gr\u1eb9\u0301n\u00e1dians" },
            { "VE", "V\u1eb9n\u1eb9zu\u1eb9\u0301la" },
            { "VG", "Br\u00edt\u00edsh V\u00e1j\u00edn A\u00edlands" },
            { "VI", "U.S. V\u00e1j\u00edn A\u00edlands" },
            { "VN", "Vi\u1eb9\u0301tnam" },
            { "VU", "Vanu\u00e1tu" },
            { "WF", "W\u1ecd\u0301lis & Fiut\u00fana" },
            { "WS", "Sam\u00f3a" },
            { "XA", "To y\u00faz atif\u00edsh\u00e1l v\u1ecdis w\u1eb9\u0301n yu de t\u1ecdk" },
            { "XB", "At\u00edf\u00edsh\u00e1l T\u00fa-W\u00e9 Dair\u1eb9\u0301ksh\u1ecdn" },
            { "XK", "K\u00f3s\u00f3vo" },
            { "YE", "Y\u1eb9\u0301m\u1eb9n" },
            { "YT", "Mey\u1ecdt" },
            { "ZA", "Sa\u00fat \u00c1fr\u00edka" },
            { "ZM", "Z\u00e1mbia" },
            { "ZW", "Zimb\u00e1bw\u1eb9" },
            { "ZZ", "R\u00edj\u1ecdn W\u00e9 N\u00f3b\u1ecd\u0301di Sab\u00ed" },
            { "ab", "Abkh\u00e1zian" },
            { "af", "\u00c1fr\u00edkaans L\u00e1ngwej" },
            { "ak", "Akan L\u00e1ngwej" },
            { "am", "Amh\u00e1r\u00edk L\u00e1ngwej" },
            { "an", "Arag\u00f3n\u1eb9\u0301s\u1eb9 L\u00e1ngwej" },
            { "ar", "Ar\u00e1b\u00edk L\u00e1ngwej" },
            { "as", "Asam\u00edz L\u00e1ngwej" },
            { "av", "Afar\u00edk L\u00e1ngwej" },
            { "ay", "Aym\u00e1ra" },
            { "az", "Az\u1eb9rbaij\u00e1ni L\u00e1ngwej" },
            { "ba", "Bashk\u00edr" },
            { "be", "B\u1eb9lar\u00fasi\u00e1 L\u00e1ngwej" },
            { "bg", "B\u1ecdlg\u00e9ri\u00e1 L\u00e1ngwej" },
            { "bi", "Bisl\u00e1ma" },
            { "bm", "Bamb\u00e1ra L\u00e1ngwej" },
            { "bn", "B\u00e1ngla L\u00e1ngwej" },
            { "bo", "Tib\u1eb9\u0301tan" },
            { "br", "Br\u1eb9\u0301t\u1ecdn L\u00e1ngwej" },
            { "bs", "B\u1ecd\u0301sni\u00e1 L\u00e1ngwej" },
            { "ca", "K\u00e1t\u00e1la L\u00e1ngwej" },
            { "ce", "Ch\u1eb9\u0301ch\u1eb9n L\u00e1ngwej" },
            { "ch", "Cham\u00f3ro L\u00e1ngwej" },
            { "co", "K\u1ecds\u00edkan L\u00e1ngwej" },
            { "cs", "Ch\u1eb9\u0301k L\u00e1ngwej" },
            { "cu", "Ch\u1ecd\u0301ch Sl\u00e1vik" },
            { "cv", "Ch\u00favash" },
            { "cy", "W\u1eb9lsh" },
            { "da", "D\u00e9n\u00edsh L\u00e1ngwej" },
            { "de", "J\u00e1m\u00e1n L\u00e1ngwej" },
            { "dv", "Div\u1eb9h\u00ed" },
            { "dz", "Z\u1ecd\u0301ngka L\u00e1ngwej" },
            { "ee", "\u1eb8\u0301w\u1eb9\u0301 L\u00e1ngwej" },
            { "el", "Gr\u00edk L\u00e1ngwej" },
            { "en", "\u00cdnglish" },
            { "eo", "\u1eb8sper\u00e1nto L\u00e1ngwej" },
            { "es", "Sp\u00e1nish L\u00e1ngwej" },
            { "et", "\u1eb8st\u00f3ni\u00e1 L\u00e1ngwej" },
            { "eu", "B\u00e1sk L\u00e1ngwej" },
            { "fa", "P\u1eb9\u0301shi\u00e1 L\u00e1ngwej" },
            { "ff", "F\u00falan\u00ed L\u00e1ngwej" },
            { "fi", "F\u00edn\u00edsh L\u00e1ngwej" },
            { "fj", "F\u00edj\u00e1n L\u00e1ngwej" },
            { "fo", "F\u00e1r\u00f3\u00eds L\u00e1ngwej" },
            { "fr", "Fr\u1eb9\u0301nch L\u00e1ngwej" },
            { "fy", "W\u1eb9\u0301st\u00e1n Fr\u00edsi\u00e1 L\u00e1ngwej" },
            { "ga", "A\u00edr\u00edsh L\u00e1ngwej" },
            { "gd", "Gael\u00edk L\u00e1ngwej \u1ecdf Gael P\u00edpol f\u1ecd Sk\u1ecd\u0301tland" },
            { "gl", "Gal\u00edsi\u00e1 L\u00e1ngwej" },
            { "gn", "Gu\u00e1r\u00e1ni L\u00e1ngwej" },
            { "gu", "Gujar\u00e1t\u00ed L\u00e1ngwej" },
            { "gv", "M\u00e1nks L\u00e1ngwej" },
            { "ha", "H\u00e1us\u00e1 L\u00e1ngwej" },
            { "he", "H\u00edbru L\u00e1ngwej" },
            { "hi", "H\u00edndi L\u00e1ngwej" },
            { "hr", "Kro\u00e9shia L\u00e1ngwej" },
            { "ht", "Ha\u00edt\u00ed Kriol" },
            { "hu", "H\u1ecdng\u00e1ri L\u00e1ngwej" },
            { "hy", "Arm\u1eb9\u0301ni\u00e1 L\u00e1ngwej" },
            { "hz", "H\u1eb9r\u1eb9\u0301ro" },
            { "ia", "Intal\u00edngwu\u00e1 L\u00e1ngwej" },
            { "id", "Indon\u00edshia L\u00e1ngwej" },
            { "ig", "Igbo L\u00e1ngwej" },
            { "ii", "S\u00edchuan Yi" },
            { "io", "Id\u00f3 L\u00e1ngwej" },
            { "is", "A\u00edsl\u00e1nd L\u00e1ngwej" },
            { "it", "\u00cdt\u00e1li L\u00e1ngwej" },
            { "iu", "Inukt\u00edtut" },
            { "ja", "Japan L\u00e1ngwej" },
            { "jv", "Jav\u00e1n\u00edz L\u00e1ngwej" },
            { "ka", "J\u1ecd\u0301ji\u00e1 L\u00e1ngwej" },
            { "ki", "Kik\u00fay\u00fa L\u00e1ngwej" },
            { "kj", "Kuany\u00e1ma L\u00e1ngwej" },
            { "kk", "Kaz\u00e1k L\u00e1ngwej" },
            { "kl", "Kal\u00e1l\u00eds\u00fat L\u00e1ngwej" },
            { "km", "Kma\u00ed L\u00e1ngwej" },
            { "kn", "K\u00e1nn\u00e1da L\u00e1ngwej" },
            { "ko", "Kori\u00e1 L\u00e1ngwej" },
            { "kr", "K\u00e1nur\u00ed L\u00e1ngwej" },
            { "ks", "Kashm\u00edr\u00ed L\u00e1ngwej" },
            { "ku", "K\u1ecd\u0301d\u00edsh L\u00e1ngwej" },
            { "kv", "Komi L\u00e1ngwej" },
            { "kw", "K\u1ecd\u0301nish L\u00e1ngwej" },
            { "ky", "Ki\u1eb9\u0301g\u00edz L\u00e1ngwej" },
            { "la", "L\u00e1t\u00edn L\u00e1ngwej" },
            { "lb", "L\u1ecd\u0301ks\u00e9mb\u1ecd\u0301g L\u00e1ngwej" },
            { "lg", "G\u00e1nda L\u00e1ngwej" },
            { "li", "Limb\u00f3g\u00edsh L\u00e1ngwej" },
            { "ln", "Ling\u00e1l\u00e1 L\u00e1ngwej" },
            { "lo", "L\u00e1o L\u00e1ngwej" },
            { "lt", "Litu\u00e9ni\u00e1 L\u00e1ngwej" },
            { "lu", "L\u00fab\u00e1-Kat\u00e1ng\u00e1 L\u00e1ngwej" },
            { "lv", "L\u00e1tvi\u00e1n L\u00e1ngwej" },
            { "mg", "Malag\u00e1s\u00ed L\u00e1ngwej" },
            { "mh", "M\u00e1sh\u00e1ll\u00eds L\u00e1ngwej" },
            { "mi", "Ma\u00f3r\u00ed L\u00e1ngwej" },
            { "mk", "Mas\u1eb9d\u00f3ni\u00e1 L\u00e1ngwej" },
            { "ml", "Mal\u00e9y\u00e1l\u00e1m L\u00e1ngwej" },
            { "mn", "M\u1ecdng\u00f3li\u00e1 L\u00e1ngwej" },
            { "mr", "Mar\u00e1t\u00ed L\u00e1ngwej" },
            { "ms", "Mal\u00e9 L\u00e1ngwej" },
            { "mt", "M\u1ecd\u0301lt\u00e1 L\u00e1ngwej" },
            { "my", "B\u1ecd\u0301ma L\u00e1ngwej" },
            { "na", "Na\u00faru L\u00e1ngwej" },
            { "nb", "N\u1ecdw\u1eb9\u0301ji\u00e1 Bokm\u00e1l L\u00e1ngwej" },
            { "nd", "N\u1ecd\u0301t\u00e1n Nd\u1eb9b\u1eb9l\u1eb9 L\u00e1ngwej" },
            { "ne", "N\u1eb9p\u00e1l\u00ed L\u00e1ngwej" },
            { "ng", "Nd\u00f3nga L\u00e1ngwej" },
            { "nl", "D\u1ecdch L\u00e1ngwej" },
            { "nn", "N\u1ecdw\u1eb9\u0301ji\u00e1 Ni\u00fan\u1ecdsk" },
            { "no", "N\u1ecd\u0301w\u1eb9\u0301ji\u00e1 L\u00e1ngwej" },
            { "nr", "S\u00e1\u00fat Nd\u1eb9b\u1eb9l\u1eb9 L\u00e1ngwej" },
            { "nv", "Nav\u00e1jo L\u00e1ngwej" },
            { "ny", "Ny\u00e1nja" },
            { "oc", "Oksit\u00e1n L\u00e1ngwej" },
            { "om", "Or\u00f3m\u00f3" },
            { "or", "\u00d3di\u00e1" },
            { "os", "Os\u1eb9\u0301tik" },
            { "pa", "Punj\u00e1bi" },
            { "pl", "P\u00f3l\u00e1nd L\u00e1ngwej" },
            { "ps", "P\u00e1shto" },
            { "pt", "P\u1ecdtiugiz" },
            { "qu", "K\u1eb9chu\u00e1" },
            { "rm", "Rom\u00e1nsh" },
            { "rn", "R\u00fandi" },
            { "ro", "Rom\u00e1ni\u00e1 L\u00e1ngwej" },
            { "ru", "R\u1ecdshi\u00e1 L\u00e1ngwej" },
            { "rw", "Kinyarw\u00e1nda L\u00e1ngwej" },
            { "sa", "S\u00e1nskrit" },
            { "sc", "Sad\u00edni\u00e1n L\u00e1ngwej" },
            { "sd", "S\u00ednd\u00ed" },
            { "se", "N\u1ecd\u0301t\u00e1n S\u00e1m\u00ed L\u00e1ngwej" },
            { "sg", "s\u00e0ngo" },
            { "si", "S\u00ednhala" },
            { "sk", "Sl\u00f3vak" },
            { "sl", "Slov\u1eb9\u0301ni\u00e1 L\u00e1ngwej" },
            { "sm", "Sam\u00f3\u00e1 L\u00e1ngwej" },
            { "sn", "Sh\u00f3na" },
            { "so", "S\u1ecdm\u00e1li" },
            { "sq", "Alb\u00e9ni\u00e1 L\u00e1ngwej" },
            { "sr", "S\u1eb9rbi\u00e1 L\u00e1ngwej" },
            { "ss", "Sw\u00e1ti L\u00e1ngwej" },
            { "st", "Sa\u00fat\u00e1n S\u00f3to" },
            { "su", "S\u1ecd\u0301ndaniz" },
            { "sv", "Suw\u00edd\u1eb9\u0301n L\u00e1ngwej" },
            { "sw", "Swah\u00edli" },
            { "ta", "t\u00e0mil" },
            { "te", "T\u1eb9lugu" },
            { "tg", "T\u00e1jik" },
            { "th", metaValue_th },
            { "ti", "Tigr\u00edny\u00e1" },
            { "tk", "T\u1ecd\u0301km\u1eb9n" },
            { "tn", "Tsw\u00e1na L\u00e1ngwej" },
            { "to", "T\u00f3ngan" },
            { "tr", metaValue_TR },
            { "ts", "Ts\u00f3nga L\u00e1ngwej" },
            { "tt", "Tat\u00e1" },
            { "ty", "Tah\u00edti\u00e1n L\u00e1ngwej" },
            { "ug", "Wi\u00fag\u1ecd" },
            { "uk", "Yukr\u00e9nia" },
            { "ur", "\u00dard\u00fa" },
            { "uz", "\u00dazb\u1eb9k" },
            { "ve", "V\u1eb9\u0301nda L\u00e1ngwej" },
            { "vi", "Vi\u1eb9\u0301tn\u00e1m L\u00e1ngwej" },
            { "vo", "V\u00f3lapiuk" },
            { "wa", "W\u00e1lun L\u00e1ngwej" },
            { "wo", "W\u00f3lof" },
            { "xh", "K\u1ecd\u0301sa" },
            { "yi", "Y\u00eddish" },
            { "yo", "Yorub\u00e1" },
            { "zh", "Mandar\u00edn Chain\u00edz L\u00e1ngwej" },
            { "zu", "Z\u00falu" },
            { "ace", "Ach\u00edn\u1eb9\u0301s\u1eb9" },
            { "ada", "Ad\u00e1ngme" },
            { "ady", "Adygh\u1eb9\u0301" },
            { "agq", "Agh\u1eb9\u0301m L\u00e1ngwej" },
            { "ain", "Ain\u00fa" },
            { "ale", "Al\u1eb9ut" },
            { "alt", "Sa\u00fat\u00e1n Altai L\u00e1ngwej" },
            { "ann", "\u00d3b\u00f3l\u00f3 L\u00e1ngwej" },
            { "anp", "Ang\u00edka" },
            { "arn", "Map\u00fach\u1eb9\u0301 L\u00e1ngwej" },
            { "arp", "Arapah\u00f3" },
            { "ars", "N\u00e1jd\u00ed Ar\u00e1b\u00edk L\u00e1ngwej" },
            { "asa", "Asu L\u00e1ngwej" },
            { "ast", "Ast\u00fari\u00e1 L\u00e1ngwej" },
            { "atj", "At\u00edkam\u1eb9\u0301kw" },
            { "awa", "Awadh\u00ed" },
            { "ban", "Balin\u1eb9\u1eb9\u0301s" },
            { "bas", "B\u00e1saa L\u00e1ngwej" },
            { "bem", "B\u1eb9\u0301mba L\u00e1ngwej" },
            { "bez", "B\u1eb9\u0301na L\u00e1ngwej" },
            { "bho", "Bhojp\u00fari" },
            { "bin", "Bin\u00ed" },
            { "bla", "Siks\u00edk\u00e1 L\u00e1ngwej" },
            { "brx", "B\u00f3do L\u00e1ngwej" },
            { "bug", "Bugini\u00eds" },
            { "byn", "Blin\u00ed" },
            { "cay", "Kay\u00faga" },
            { "ccp", "Ch\u00e1kma L\u00e1ngwej" },
            { "ceb", "S\u1eb9bu\u00e1no L\u00e1ngwej" },
            { "cgg", "Ch\u00edga L\u00e1ngwej" },
            { "chk", "Chuuk\u00eds L\u00e1ngwej" },
            { "chm", "Mari L\u00e1ngwej" },
            { "cho", "Sh\u1ecd\u0301ktau L\u00e1ngwej" },
            { "chp", "Sh\u00edp\u1eb9wi\u00e1n L\u00e1ngwej" },
            { "chr", "Ch\u1eb9\u0301r\u00f3kii L\u00e1ngwej" },
            { "chy", "Sh\u1eb9\u00ednn L\u00e1ngwej" },
            { "ckb", "M\u00edd\u00fal K\u1ecd\u0301dish L\u00e1ngwej" },
            { "clc", "Ch\u00edlkot\u00edn L\u00e1ngwej" },
            { "crg", "Mich\u00edf L\u00e1ngwej" },
            { "crj", "Sa\u00fat\u00e1n \u00cdst Krii L\u00e1ngwej" },
            { "crk", "Krii f\u1ecd Pl\u00e9n L\u00e1ngwej" },
            { "crl", "N\u1ecd\u0301t\u00e1n \u00cdst Kri\u00ed L\u00e1ngwej" },
            { "crm", "Muse Kri\u00ed L\u00e1ngwej" },
            { "crr", "Karol\u00edna Alg\u00f3nkw\u00edan" },
            { "csw", "Swampi Kri\u00ed L\u00e1ngwej" },
            { "dak", "Dak\u00f3t\u00e1 L\u00e1ngwej" },
            { "dar", "Dargw\u00e1 L\u00e1ngwej" },
            { "dav", "Ta\u00edta" },
            { "dgr", "D\u1ecdgr\u00edb L\u00e1ngwej" },
            { "dje", "Z\u00e1rm\u00e1" },
            { "doi", "Dogri" },
            { "dsb", "L\u00f3w\u00e1 Sorbi\u00e1" },
            { "dua", "Du\u00e1la L\u00e1ngwej" },
            { "dyo", "J\u00f3la-F\u00f3nyi L\u00e1ngwej" },
            { "dzg", "Daz\u00e1g\u00e1 L\u00e1ngwej" },
            { "ebu", "\u1eb8mbu L\u00e1ngwej" },
            { "efi", "\u1eb8\u0301f\u00edk L\u00e1ngwej" },
            { "eka", "\u1eb8kaj\u00fak L\u00e1ngwej" },
            { "ewo", "\u1eb8wondo L\u00e1ngwej" },
            { "fil", "Filip\u00edn\u00f3 L\u00e1ngwej" },
            { "fon", "F\u1ecdn L\u00e1ngwej" },
            { "frc", "K\u00e1jun Fr\u1eb9nchi" },
            { "frr", "N\u1ecd\u0301t\u00e1n Fr\u00edsian" },
            { "fur", "Fri\u00fali\u00e1n L\u00e1ngwej" },
            { "gaa", "Ga L\u00e1ngwej" },
            { "gez", "Giiz L\u00e1ngwej" },
            { "gil", "G\u00edlb\u00e1t\u00eds L\u00e1ngwej" },
            { "gor", "Goront\u00e1l\u00f3 L\u00e1ngwej" },
            { "gsw", "J\u00e1m\u00e1n Swis" },
            { "guz", "Gus\u00ed L\u00e1ngwej" },
            { "gwi", "Gwich\u00edn L\u00e1ngwej" },
            { "hai", "Ha\u00edda L\u00e1ngwej" },
            { "haw", "Hawaii L\u00e1ngwej" },
            { "hax", "Sa\u00fat\u00e1n Haida" },
            { "hil", "H\u00edliga\u00edn\u1ecdn" },
            { "hmn", "M\u1ecd\u0301ng L\u00e1ngwej" },
            { "hsb", "S\u00f3bi\u00e1 L\u00e1ngwej di \u1ecd\u0301p-\u1ecd\u0301p wan" },
            { "hup", "H\u00fap\u00e1 L\u00e1ngwej" },
            { "hur", "Halkom\u1eb9\u0301l\u1eb9\u0301m L\u00e1ngwej" },
            { "iba", "Iban L\u00e1ngwej" },
            { "ibb", "Ibibio L\u00e1ngwej" },
            { "ikt", "W\u1eb9\u0301st\u00e1n K\u00e1n\u00e1d\u00e1 Inukt\u00edtut" },
            { "ilo", "Ilok\u00f3" },
            { "inh", "Ingu\u00edsh L\u00e1ngwej" },
            { "jbo", "Lojban L\u00e1ngwej" },
            { "jgo", "Ng\u00f3mb\u00e1 L\u00e1ngwej" },
            { "jmc", "Mach\u00e1m\u1eb9\u0301 L\u00e1ngwej" },
            { "kab", "Kabail L\u00e1ngwej" },
            { "kac", "Kach\u00edn L\u00e1ngwej" },
            { "kaj", "Jju L\u00e1ngwej" },
            { "kam", "K\u00e1mb\u00e1 L\u00e1ngwej" },
            { "kbd", "Kab\u00e1rdian" },
            { "kcg", "Tyap L\u00e1ngwej" },
            { "kde", "Mak\u1ecd\u0301nd\u1eb9\u0301 L\u00e1ngwej" },
            { "kea", "K\u00e1b\u00fav\u1eb9rdi\u00e1nu L\u00e1ngwej" },
            { "kfo", "Koro L\u00e1ngwej" },
            { "kgp", "Kaing\u00e1ng L\u00e1ngwej" },
            { "kha", "Kh\u00e1si L\u00e1ngwej" },
            { "khq", "Koyra Ch\u00edn\u00ed L\u00e1ngwej" },
            { "kkj", "K\u00e1k\u00f3 L\u00e1ngwej" },
            { "kln", "K\u00e1l\u1eb9\u0301nj\u00edn L\u00e1ngwej" },
            { "kmb", "Kimb\u00fand\u00fa L\u00e1ngwej" },
            { "kok", "K\u00f3nk\u00e9n\u00ed L\u00e1ngwej" },
            { "kpe", "Kp\u1eb9ll\u1eb9 L\u00e1ngwej" },
            { "krc", "Kar\u00e1chei-B\u00e1lkar" },
            { "krl", "Kar\u1eb9\u0301lian" },
            { "kru", "Kur\u00fakh L\u00e1ngwej" },
            { "ksb", "Sh\u00e1mbala" },
            { "ksf", "Bafi\u00e1 L\u00e1ngwej" },
            { "ksh", "K\u1ecdl\u00f3ni\u00e1n L\u00e1ngwej" },
            { "kum", "Kumy\u00edk L\u00e1ngwej" },
            { "kwk", "Kwakw\u00e1la L\u00e1ngwej" },
            { "lad", "Lad\u00edno L\u00e1ngwej" },
            { "lag", "Langi L\u00e1ngwej" },
            { "lez", "L\u1eb9zghi\u00e1n L\u00e1ngwej" },
            { "lil", "Lilloo\u1eb9\u0301t L\u00e1ngwej" },
            { "lkt", "Lak\u00f3t\u00e1 L\u00e1ngwej" },
            { "lou", "Kriol f\u1ecd Luisi\u00e1na" },
            { "loz", "L\u00f3z\u00ed L\u00e1ngwej" },
            { "lrc", "N\u1ecd\u0301t\u00e1n L\u00far\u00ed L\u00e1ngwej" },
            { "lsm", "Saami\u00e1 L\u00e1ngwej" },
            { "lua", "Luba-L\u00falua" },
            { "lun", "Lunda L\u00e1ngwej" },
            { "luo", "Lu\u00f3 L\u00e1ngwej" },
            { "lus", "Mizo L\u00e1ngwej" },
            { "luy", "Luyia L\u00e1ngwej" },
            { "mad", "Madur\u1eb9\u0301s\u1eb9" },
            { "mag", "Magah\u00ed L\u00e1ngwej" },
            { "mai", "Ma\u00edt\u00edli" },
            { "mak", "M\u00e1k\u00e1s\u00e1 L\u00e1ngwej" },
            { "mas", "Masa\u00ed L\u00e1ngwej" },
            { "mdf", "M\u00f3ksha L\u00e1ngwej" },
            { "men", "M\u1eb9nd\u1eb9\u0301 L\u00e1ngwej" },
            { "mer", "M\u1eb9\u0301r\u00fa L\u00e1ngwej" },
            { "mfe", "Mor\u00edsi\u1eb9\u0301n L\u00e1ngwej" },
            { "mgh", "Mak\u00faw\u00e1-M\u00edt\u00f3" },
            { "mgo", "M\u1eb9ta\u2019 L\u00e1ngwej" },
            { "mic", "Mikm\u00e1k L\u00e1ngwej" },
            { "min", "Minangkab\u00e1u" },
            { "mni", "Man\u00edpuri" },
            { "moe", "Innu-a\u00edmun L\u00e1ngwej" },
            { "moh", "M\u00f3h\u1ecd\u0301k L\u00e1ngwej" },
            { "mos", "M\u00f3s\u00ed L\u00e1ngwej" },
            { "mua", "Mund\u00e1ng L\u00e1ngwej" },
            { "mul", "Pl\u1eb9\u0301nt\u00ed L\u00e1ngwej-d\u1eb9m" },
            { "mus", "M\u00fask\u00f3jii L\u00e1ngwej" },
            { "mwl", "Mir\u00e1nd\u1eb9\u0301s\u1eb9 L\u00e1ngwej" },
            { "myv", "\u1eb8rzi\u00e1 L\u00e1ngwej" },
            { "mzn", "Mazand\u1eb9r\u00e1n\u00ed L\u00e1ngwej" },
            { "nap", "Niapol\u00edt\u00e1n L\u00e1ngwej" },
            { "naq", "Na\u00e1m\u00e1 L\u00e1ngwej" },
            { "nds", "L\u00f3 J\u00e1m\u00e1n L\u00e1ngwej" },
            { "new", "N\u1eb9war\u00ed L\u00e1ngwej" },
            { "nia", "Nias L\u00e1ngwej" },
            { "niu", "Ni\u00fae\u00e1n L\u00e1ngwej" },
            { "nmg", "Kwasi\u00f3 L\u00e1ngwej" },
            { "nnh", "Ngi\u1eb9\u0301mb\u1ecdn L\u00e1ngwej" },
            { "nog", "Nog\u00e1i L\u00e1ngwej" },
            { "nqo", metaValue_nqo },
            { "nso", "N\u1ecd\u0301t\u00e1n S\u00f3tho L\u00e1ngwej" },
            { "nus", "N\u00faa" },
            { "nyn", "Nyank\u00f3l\u1eb9" },
            { "ojb", "N\u1ecd\u0301t\u00e1n Ojibwa" },
            { "ojc", "S\u1eb9\u0301ntr\u00e1l Oj\u00edbwa" },
            { "ojs", "Oj\u00ed-Krii L\u00e1ngwej" },
            { "ojw", "W\u1eb9\u0301st\u00e1n Ojibua" },
            { "oka", "Okanagan Langwej" },
            { "pag", "Pangas\u00edn\u00e1n L\u00e1ngwej" },
            { "pam", "Pamp\u00e1nga L\u00e1ngwej" },
            { "pap", "Papiam\u00e9nto L\u00e1ngwej" },
            { "pau", "Pala\u00fa\u00e1n L\u00e1ngwej" },
            { "pcm", "Naij\u00edri\u00e1 P\u00edjin" },
            { "pis", "P\u00edj\u00edn L\u00e1ngwej" },
            { "pqm", "Malisi\u00edt Pasam\u00e1k\u00f3d\u00ed L\u00e1ngwej" },
            { "prg", "Pr\u00fashia" },
            { "rap", "Rap\u00e1nui L\u00e1ngwej" },
            { "rar", "Rarot\u00f3ngan" },
            { "rhg", "Roh\u00ednjia" },
            { "rof", "R\u00f3mbo" },
            { "rup", "Ar\u00f3m\u00e1nian" },
            { "rwk", "Rw\u00e1" },
            { "sad", "Sand\u00e1w\u1eb9\u0301 L\u00e1ngwej" },
            { "sah", "Sakh\u00e1" },
            { "saq", "Samb\u00faru" },
            { "sat", "S\u00e1nt\u00e1li" },
            { "sba", "Ngambai L\u00e1ngwej" },
            { "sbp", "Sangu" },
            { "scn", "Sis\u00edli\u00e1n L\u00e1ngwej" },
            { "sco", "Sk\u1ecd\u0301t L\u00e1ngwej" },
            { "seh", "S\u1eb9\u0301n\u00e1" },
            { "ses", "K\u00f3irabor\u00f3 S\u1eb9\u0301nn\u00ed L\u00e1ngwej" },
            { "shi", "T\u00e1ch\u1eb9\u0301lit" },
            { "shn", "Sh\u00e1n L\u00e1ngwej" },
            { "slh", "Sa\u00fatan Lush\u00fatsid" },
            { "smn", "\u00cdn\u00e1r\u00ed S\u00e1m\u00ed L\u00e1ngwej" },
            { "sms", "Skolt S\u00e1m\u00ed L\u00e1ngwej" },
            { "snk", "Son\u00ednk\u1eb9\u0301 L\u00e1ngwej" },
            { "srn", "Sran\u00e1n T\u00f3ngo" },
            { "str", "Streti Sal\u00edsh L\u00e1ngwej" },
            { "suk", "Suk\u00fama L\u00e1ngwej" },
            { "swb", "Kom\u00f3ria L\u00e1ngwej" },
            { "syr", metaValue_syr },
            { "tce", "Sa\u00fat\u00e1n Tutch\u00f3n\u1eb9 L\u00e1ngwej" },
            { "tem", "T\u00edmn\u1eb9 L\u00e1ngwej" },
            { "teo", "T\u1eb9\u0301so" },
            { "tet", "T\u1eb9\u0301tum L\u00e1ngwej" },
            { "tgx", "T\u00e1g\u00edsh L\u00e1ngwej" },
            { "tht", "Tahlt\u00e1n L\u00e1ngwej" },
            { "tig", "T\u00edgr\u1eb9 L\u00e1ngwej" },
            { "tlh", "Kl\u00edngon" },
            { "tli", "Tlingit L\u00e1ngwej" },
            { "tok", "Tong\u00e1n L\u00e1ngwej" },
            { "tpi", "T\u1ecdk P\u00edsin" },
            { "trv", "Tar\u00f3k\u00f3 L\u00e1ngwej" },
            { "ttm", "N\u00f3t\u00e1n Tuch\u00f3n\u1eb9 L\u00e1ngwej" },
            { "tum", "Tumb\u00faka L\u00e1ngwej" },
            { "tvl", "Tuv\u00e1lu L\u00e1ngwej" },
            { "twq", "Tasawak" },
            { "tyv", "Tuv\u00edni\u00e1n L\u00e1ngwej" },
            { "tzm", "M\u00edd\u00fal Atl\u00e1s T\u00e1maz\u00edgt L\u00e1ngwej" },
            { "udm", "\u00dadmurt L\u00e1ngwej" },
            { "umb", "Umb\u00fandu L\u00e1ngwej" },
            { "und", "L\u00e1ngwej w\u00e9 n\u00f3b\u1ecd\u0301di sabi" },
            { "vai", "Va\u00ed" },
            { "vun", "V\u00fanjo" },
            { "wae", "W\u1ecd\u0301lsa" },
            { "wal", "Wola\u00edt\u00e1 L\u00e1ngwej" },
            { "war", "Warai L\u00e1ngwej" },
            { "wuu", "Wu Chainiz" },
            { "xal", "Kalmik" },
            { "xog", "s\u00f3ga" },
            { "yav", "Yangb\u1eb9n" },
            { "ybb", "Y\u1eb9mba L\u00e1ngwej" },
            { "yrl", "Nhiing\u00e1tu L\u00e1ngwej" },
            { "yue", "K\u00e1nt\u1ecdn L\u00e1ngwej" },
            { "zgh", "G\u1eb9\u0301n\u00e1r\u00e1l Mor\u00f3k\u00f3 T\u00e1maz\u00edgt L\u00e1ngwej" },
            { "zun", "Z\u00fan\u00ed L\u00e1ngwej" },
            { "zxx", "N\u00f3 L\u00e1ngw\u00e9j K\u1ecd\u0301nt\u1eb9nt" },
            { "zza", "Z\u00e1z\u00e1 L\u00e1ngwej" },
            { "Adlm", "\u00c1dlam" },
            { "Arab", "Ar\u00e1b\u00edk" },
            { "Aran", "Aran L\u00e1ngwej" },
            { "Armn", "Arm\u1eb9\u0301nia" },
            { "Beng", "B\u00e1ngla" },
            { "Bopo", "Bopom\u00f3fo" },
            { "Brai", "Bla\u00ednd P\u00edpol Ra\u00edt\u00edn S\u00edst\u1eb9m" },
            { "Cakm", "Ch\u00e1km\u00e1 L\u00e1ngwej" },
            { "Cans", "N\u00e9t\u00edv K\u00e1n\u00e1d\u00e1 P\u00edpul S\u00edlebul-d\u1eb9m W\u00e9 D\u1eb9m J\u1ecd\u00edn Tog\u1eb9\u0301da" },
            { "Cher", "Ch\u00edr\u00f3ki L\u00e1ngwej" },
            { "Cyrl", "S\u00edr\u00edlik" },
            { "Deva", "D\u1eb9van\u00e1g\u00e1ri" },
            { "Ethi", "\u1eb8ti\u00f3pik" },
            { "Geor", metaValue_GE },
            { "Grek", "Gr\u00edk" },
            { "Gujr", "Gujar\u00e1ti" },
            { "Guru", "G\u00farmukhi" },
            { "Hanb", "Han Wit Bopom\u00f3fo" },
            { "Hang", "H\u00e1ngul" },
            { "Hani", "Chainiz" },
            { "Hans", "\u00cdz\u00ed Chain\u00edz L\u00e1ngwej" },
            { "Hant", "N\u1ecd\u0301mal" },
            { "Hebr", "H\u00edbr\u00fa" },
            { "Hira", "Hiag\u00e1na" },
            { "Hrkt", "P\u00e1t \u1ecdf Jap\u00e1n Ra\u00edt\u00edn S\u00edst\u1eb9m" },
            { "Jamo", "J\u00e1mo" },
            { "Jpan", metaValue_JP },
            { "Kana", "Kat\u00e1k\u00e1na" },
            { "Khmr", "Kem\u1eb9\u1eb9" },
            { "Knda", "K\u00e1nnad Ra\u00edt\u00edn S\u00edst\u1eb9m" },
            { "Kore", "Koria" },
            { "Laoo", "Lao" },
            { "Latn", "L\u00e1tin" },
            { "Mlym", "Mal\u00e9y\u00e1lam" },
            { "Mong", metaValue_MN },
            { "Mtei", "M\u1eb9it\u1eb9\u00ed May\u1eb9k L\u00e1ngwej" },
            { "Mymr", "Mi\u00e1nmar" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki" },
            { "Orya", "\u00d3dia" },
            { "Rohg", "Han\u00edfi L\u00e1ngwej" },
            { "Sinh", "Sinh\u00e1la" },
            { "Sund", "S\u00fandan\u00edz L\u00e1ngwej" },
            { "Syrc", metaValue_syr },
            { "Taml", "T\u00e1mil" },
            { "Telu", "T\u1eb9\u0301l\u00fagu" },
            { "Tfng", "T\u00edf\u00ednag L\u00e1ngwej" },
            { "Thaa", "T\u00e1na" },
            { "Thai", metaValue_th },
            { "Tibt", "T\u00edb\u1eb9t" },
            { "Vaii", "Va\u00ed L\u00e1ngwej" },
            { "Yiii", "Yi L\u00e1ngwej" },
            { "Zmth", "Matim\u00e1tiks Sains" },
            { "Zsye", "\u1eb8\u0301m\u00f3ji" },
            { "Zsym", "S\u00edmbuls" },
            { "Zxxx", "W\u00e9t\u00edn D\u1eb9m N\u00f3 Rait" },
            { "Zyyy", "J\u1eb9\u0301n\u00e1ral" },
            { "Zzzz", "Ra\u00edt\u00edn S\u00edst\u1eb9m W\u00e9 N\u00f3b\u1ecd\u0301di Sab\u00ed" },
            { "de_AT", "\u1ecc\u0301stria J\u00e1m\u00e1n" },
            { "de_CH", "Sw\u00edtzaland Ha\u00ed J\u00e1m\u00e1n" },
            { "en_AU", "\u1eccstr\u00e9li\u00e1 \u00cdnglish" },
            { "en_CA", "K\u00e1n\u00e1da \u00cdnglish" },
            { "en_GB", "Br\u00edt\u00edsh \u00cdnglish" },
            { "en_US", "Am\u1eb9\u0301r\u00edka \u00cdnglish" },
            { "es_ES", "Y\u00farop Sp\u00e1nish" },
            { "es_MX", "M\u1eb9\u0301ksiko Sp\u00e1nish" },
            { "fa_AF", "D\u00e1ri" },
            { "fr_CA", "K\u00e1n\u00e1d\u00e1 Fr\u1eb9nch" },
            { "fr_CH", "Sw\u00edzal\u00e1nd Fr\u1eb9nch" },
            { "nl_BE", "Fl\u1eb9\u0301mish L\u00e1ngwej" },
            { "pt_BR", "Braz\u00edl P\u1ecdtiug\u00edz" },
            { "pt_PT", "Y\u00far\u00f3p P\u1ecdtiug\u00edz" },
            { "es_419", "L\u00e1t\u00edn Am\u1eb9\u0301r\u00edka Sp\u00e1nish" },
            { "key.ca", "Kal\u1eb9\u0301nda" },
            { "key.cf", "Ha\u00fa To Ar\u00e9nj M\u1ecdn\u00ed" },
            { "key.co", "Ar\u00e9nj Tins W\u1eb9l" },
            { "key.cu", "M\u1ecdn\u00ed" },
            { "key.hc", "Aw\u00e1 Sa\u00edkul (12 vs 24)" },
            { "key.lb", "La\u00edn Br\u1eb9k Sta\u00edl" },
            { "key.ms", "S\u00edst\u1eb9m f\u1ecd M\u1eb9\u0301zh\u1ecd\u0301m\u1eb9nt" },
            { "key.nu", "N\u1ecd\u0301mba-d\u1eb9m" },
            { "hi_Latn", "H\u00edndi (L\u00e1tin)" },
            { "type.ca.roc", "Rip\u1ecd\u0301bl\u00edk \u1ecdf Cha\u00edn\u00e1 Kal\u1eb9\u0301nda" },
            { "type.hc.h11", "12 \u00c1wa S\u00edst\u1eb9m (0\u201311)" },
            { "type.hc.h12", "12 \u00c1wa S\u00edst\u1eb9m (1\u201312)" },
            { "type.hc.h23", "24 \u00c1wa S\u00edst\u1eb9m (0\u201323)" },
            { "type.hc.h24", "24 \u00c1wa S\u00edst\u1eb9m (1\u201324)" },
            { "type.nu.arab", "Ar\u00e1b\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.armn", "Arm\u1eb9\u0301ni\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.beng", "B\u00e1ngl\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.cakm", "Chakm\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.deva", "D\u1eb9van\u00e1g\u00e1ri N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.ethi", "\u1eb8ti\u00f3pi\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.geor", "J\u1ecd\u0301ji\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.grek", "Gr\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.gujr", "Gujar\u00e1t\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.guru", "G\u00farmukhi N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hans", "\u00cdz\u00ed Chain\u00edz N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hant", "N\u1ecd\u0301m\u00e1l Chain\u00edz N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hebr", "H\u00edbru N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.java", "J\u00e1v\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.jpan", "Jap\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.khmr", "Kmai N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.knda", "K\u00e1nn\u00e1d N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.laoo", "Lao N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.latn", "W\u1eb9\u0301st\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.mlym", "Mal\u00e9y\u00e1lam N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.mtei", "Miit\u1eb9\u00ed May\u1eb9\u0301k N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.mymr", "Mi\u00e1nma N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.olck", "Ol Chiki N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.orya", "\u00d3dia N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.taml", "N\u1ecd\u0301m\u00e1l T\u00e1m\u00edl N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.telu", "T\u1eb9\u0301l\u00fagu N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.thai", "Ta\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.tibt", "T\u00edb\u1eb9t N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.vaii", "Va\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.ca.dangi", "Dangi Kal\u1eb9\u0301nda" },
            { "type.co.ducet", "Y\u00fan\u00edk\u00f3d M\u00e9n W\u00e8 To Ar\u00e9nj Tins W\u1eb9l" },
            { "type.lb.loose", "L\u00faz La\u00edn Br\u1eb9k Sta\u00edl" },
            { "type.nu.roman", "R\u00f3m\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.ca.coptic", "K\u1ecd\u0301pt\u00edk Kal\u1eb9\u0301nda" },
            { "type.ca.hebrew", "H\u00edbr\u00fa Kal\u1eb9\u0301nda" },
            { "type.co.search", "J\u1eb9\u0301n\u00e1r\u00e1l Sachin" },
            { "type.lb.normal", "N\u1ecd\u0301m\u00e1l La\u00edn Br\u1eb9k Sta\u00edl" },
            { "type.lb.strict", "F\u00edksd La\u00edn Br\u1eb9k Sta\u00edl" },
            { "type.ms.metric", "M\u1eb9\u0301tr\u00edk S\u00edst\u1eb9m" },
            { "type.ca.chinese", "Cha\u00edn\u00edz Kal\u1eb9\u0301nda" },
            { "type.ca.islamic", "\u00cdsl\u00e1m Kal\u1eb9\u0301nda" },
            { "type.ca.iso8601", "ISO-8601 Kal\u1eb9\u0301nda" },
            { "type.ca.persian", "P\u1eb9\u0301shia Kal\u1eb9\u0301nda" },
            { "type.cf.account", "Ak\u00e1unt To T\u00e9k Ar\u00e9nj M\u1ecdn\u00ed" },
            { "type.nu.arabext", "\u1eb8str\u00e1 Ar\u00e1b\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.armnlow", "Sm\u1ecd\u0301l Ta\u00edp Arm\u1eb9\u0301ni\u00e1 N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.greklow", "Sm\u1ecd\u0301l Ta\u00edp Gr\u00edk N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hanidec", "Chain\u00edz N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hansfin", "\u00cdz\u00ed Chain\u00edz M\u1ecdn\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.hantfin", "N\u1ecd\u0301m\u00e1l Chain\u00edz M\u1ecdn\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.jpanfin", "Jap\u00e1n M\u1ecdn\u00ed N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.tamldec", "T\u00e1m\u00edl N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.ca.buddhist", "B\u00fad\u00edst Kal\u1eb9\u0301nda" },
            { "type.ca.ethiopic", "\u1eb8ti\u00f3pi\u00e1 Kal\u1eb9\u0301nda" },
            { "type.ca.japanese", "Jap\u00e1n Kal\u1eb9\u0301nda" },
            { "type.cf.standard", "N\u1ecd\u0301m\u00e1l W\u00e8 To Ar\u00e9nj M\u1ecdn\u00ed" },
            { "type.co.standard", "N\u1ecd\u0301m\u00e1l W\u00e8 To Ar\u00e9nj Tins W\u1eb9l" },
            { "type.ms.uksystem", "Imp\u1eb9\u0301ri\u00e1l S\u00edst\u1eb9m f\u1ecd M\u1eb9\u0301zh\u1ecd\u0301m\u1eb9nt" },
            { "type.ms.ussystem", "US S\u00edst\u1eb9m f\u1ecd M\u1eb9\u0301zh\u1ecd\u0301m\u1eb9nt" },
            { "type.nu.fullwide", "F\u00fal-Waid N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.nu.romanlow", "Sm\u1ecd\u0301l Ta\u00edp R\u00f3m\u00e1n N\u1ecd\u0301mba-d\u1eb9m" },
            { "type.ca.gregorian", "Gr\u1eb9\u0301g\u00f3r\u00ed Kal\u1eb9\u0301nda" },
            { "type.ca.islamic-civil", "\u00cdsl\u00e1m Kal\u1eb9\u0301nda (T\u00e9b\u00fal\u00e1 Taip an S\u00edv\u00fal Taip)" },
            { "type.ca.islamic-umalqura", "\u00cdsl\u00e1m Kal\u1eb9\u0301nda (\u00damm al-K\u00fara)" },
            { "type.ca.ethiopic-amete-alem", "\u1eb8ti\u00f3pi\u00e1 Am\u1eb9t\u1eb9\u0301 \u00c1l\u1eb9\u0301m Kal\u00e9nda" },
        };
        return data;
    }
}
