/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_WS = "Samoa";
        final String metaValue_ar = "arab\u0173";
        final String metaValue_bn = "bengal\u0173";
        final String metaValue_bo = "tibetie\u010di\u0173";
        final String metaValue_el = "graik\u0173";
        final String metaValue_gu = "gud\u017earat\u0173";
        final String metaValue_he = "hebraj\u0173";
        final String metaValue_hy = "arm\u0117n\u0173";
        final String metaValue_ja = "japon\u0173";
        final String metaValue_jv = "javie\u010di\u0173";
        final String metaValue_ka = "gruzin\u0173";
        final String metaValue_km = "khmer\u0173";
        final String metaValue_kn = "kanad\u0173";
        final String metaValue_ko = "kor\u0117jie\u010di\u0173";
        final String metaValue_la = "lotyn\u0173";
        final String metaValue_lo = "laosie\u010di\u0173";
        final String metaValue_ml = "malajali\u0173";
        final String metaValue_mn = "mongol\u0173";
        final String metaValue_my = "birmie\u010di\u0173";
        final String metaValue_si = "sinhal\u0173";
        final String metaValue_su = "sund\u0173";
        final String metaValue_ta = "tamil\u0173";
        final String metaValue_te = "telug\u0173";
        final String metaValue_th = "taj\u0173";
        final String metaValue_tl = "tagalog\u0173";
        final String metaValue_bug = "buginez\u0173";
        final String metaValue_chr = "\u010deroki\u0173";
        final String metaValue_cop = "kopt\u0173";
        final String metaValue_got = "got\u0173";
        final String metaValue_nqo = "enko";
        final String metaValue_syr = "sir\u0173";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "kologn\u0173" },
            { "Ogam", "ogham" },
            { "mwl", "mirandez\u0173" },
            { "Zsym", "simboli\u0173" },
            { "cch", "atsam\u0173" },
            { "mwr", "marvari" },
            { "type.nu.lanatham", "Tai Tham Tham skaitmenys" },
            { "egl", "ital\u0173 kalbos Emilijos tarm\u0117" },
            { "mwv", "mentavai" },
            { "Tagb", "tagbanva" },
            { "Zsye", "jaustukai" },
            { "%%NJIVA", "Gniva / Njiva tarm\u0117" },
            { "xmf", "megrel\u0173" },
            { "ccp", "\u010cakma" },
            { "egy", "senov\u0117s egiptie\u010di\u0173" },
            { "raj", "Rad\u017eastano" },
            { "Phag", "pagsa pa" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "Tereno" },
            { "AC", "Dangun \u017dengimo sala" },
            { "rar", "rarotongan\u0173" },
            { "tet", "tetum" },
            { "AD", "Andora" },
            { "AE", "Jungtiniai Arab\u0173 Emyratai" },
            { "nl_BE", "flamand\u0173" },
            { "AF", "Afganistanas" },
            { "AG", "Antigva ir Barbuda" },
            { "type.ca.ethiopic", "Etiopijos kalendorius" },
            { "glk", "gilaki" },
            { "AI", "Angilija" },
            { "key.tz", "Laiko juosta" },
            { "AL", "Albanija" },
            { "AM", "Arm\u0117nija" },
            { "Teng", "tengvar" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "Prti", "ra\u0161ytiniai part\u0173" },
            { "AS", "Amerikos Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "en_US", "Jungtini\u0173 Valstij\u0173 angl\u0173" },
            { "AX", "Aland\u0173 Salos" },
            { "mye", "mjen\u0173" },
            { "AZ", "Azerbaid\u017eanas" },
            { "%%AREVELA", "Ryt\u0173 arm\u0117nai" },
            { "BA", "Bosnija ir Hercegovina" },
            { "BB", "Barbadosas" },
            { "ceb", "sebuan\u0173" },
            { "BD", "Banglade\u0161as" },
            { "kum", "kumik\u0173" },
            { "BE", "Belgija" },
            { "gmh", "Vidurio Auk\u0161tosios Vokietijos" },
            { "BF", "Burkina Fasas" },
            { "BG", "Bulgarija" },
            { "BH", "Bahreinas" },
            { "BI", "Burundis" },
            { "BJ", "Beninas" },
            { "BL", "Sen Bartelemi" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzyj\u0173" },
            { "BN", "Brun\u0117jus" },
            { "BO", "Bolivija" },
            { "BQ", "Karib\u0173 Nyderlandai" },
            { "BR", "Brazilija" },
            { "BS", "Bahamos" },
            { "xog", "sog\u0173" },
            { "BT", "Butanas" },
            { "BV", "Buv\u0117 Sala" },
            { "BW", "Botsvana" },
            { "BY", "Baltarusija" },
            { "BZ", "Belizas" },
            { "Visp", "matoma kalba" },
            { "type.ca.persian", "pers\u0173 kalendorius" },
            { "type.nu.hebr", "hebraj\u0173 skaitmenys" },
            { "CA", "Kanada" },
            { "CC", "Kokos\u0173 (Kilingo) Salos" },
            { "mzn", "mazenderani\u0173" },
            { "CD", "Kongas-Kin\u0161asa" },
            { "CF", "Centrin\u0117s Afrikos Respublika" },
            { "CG", "Kongas-Brazavilis" },
            { "CH", "\u0160veicarija" },
            { "CI", "Dramblio Kaulo Krantas" },
            { "CK", "Kuko Salos" },
            { "CL", "\u010cil\u0117" },
            { "Kthi", "kaithi" },
            { "CM", "Kamer\u016bnas" },
            { "CN", "Kinija" },
            { "CO", "Kolumbija" },
            { "CP", "Klipertono sala" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "\u017daliasis Ky\u0161ulys" },
            { "CW", "Kiurasao" },
            { "CX", "Kal\u0117d\u0173 Sala" },
            { "CY", "Kipras" },
            { "type.nu.bali", "bali skaitmenys" },
            { "CZ", "\u010cekija" },
            { "eka", "ekajuk" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "vakar\u0173 flamand\u0173" },
            { "DE", "Vokietija" },
            { "goh", "senoji Auk\u0161tosios Vokietijos" },
            { "ace", "a\u010dinez\u0173" },
            { "cgg", "\u010dig\u0173" },
            { "DG", "Diego Garsija" },
            { "gom", "Goa konkani\u0173" },
            { "type.nu.deva", "devanagari skaitmenys" },
            { "DJ", "D\u017eibutis" },
            { "DK", "Danija" },
            { "ach", "akoli\u0173" },
            { "gon", "gondi" },
            { "Brai", "brailio" },
            { "Brah", "brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "arm\u0117n\u0173 skaitmenys ma\u017eosiomis raid\u0117mis" },
            { "DO", "Dominikos Respublika" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "pagrindin\u0117 frankon\u0173" },
            { "Mtei", "meitei majek" },
            { "zun", "Zuni" },
            { "tig", "tigre" },
            { "Takr", "Takri" },
            { "DZ", "Al\u017eyras" },
            { "pag", "pangasinan\u0173" },
            { "type.d0.hwidth", "vidutinio plo\u010dio" },
            { "pal", "vidurin\u0117 pers\u0173 kalba" },
            { "EA", "Seuta ir Melila" },
            { "chb", "\u010dib\u010d\u0173" },
            { "pam", "pampang\u0173" },
            { "EC", "Ekvadoras" },
            { "pap", "papiamento" },
            { "ada", "adangm\u0173" },
            { "EE", "Estija" },
            { "tiv", "tiv" },
            { "EG", "Egiptas" },
            { "EH", "Vakar\u0173 Sachara" },
            { "chg", "\u010dagat\u0173" },
            { "pau", "palaulie\u010di\u0173" },
            { "chk", "\u010dukes\u0173" },
            { "chn", "\u010dinuk \u017eargonas" },
            { "chm", "mari\u0173" },
            { "chp", "\u010dipv\u0117j\u0173" },
            { "cho", "\u010doktau" },
            { "chr", metaValue_chr },
            { "ER", "Eritr\u0117ja" },
            { "ES", "Ispanija" },
            { "ET", "Etiopija" },
            { "EU", "Europos S\u0105junga" },
            { "elx", "elamit\u0173" },
            { "type.ca.gregorian", "Grigaliaus kalendorius" },
            { "EZ", "euro zona" },
            { "chy", "\u010dajen\u0173" },
            { "type.nu.gujr", "gud\u017earat\u0173 skaitmenys" },
            { "Inds", "indus" },
            { "ady", "adyg\u0117j\u0173" },
            { "aeb", "Tuniso arab\u0173" },
            { "FI", "Suomija" },
            { "FJ", "Fid\u017eis" },
            { "FK", "Folklando Salos" },
            { "FM", "Mikronezija" },
            { "key.va", "Lokal\u0117s variantas" },
            { "FO", "Farer\u0173 Salos" },
            { "Taml", metaValue_ta },
            { "FR", "Pranc\u016bzija" },
            { "Kpel", "Kpel\u0173" },
            { "pcd", "pikard\u0173" },
            { "tkl", metaValue_TK },
            { "grb", "grebo" },
            { "type.ca.indian", "nacionalinis ind\u0173 kalendorius" },
            { "rgn", "ital\u0173 kalbos Romanijos tarm\u0117" },
            { "grc", "senov\u0117s graik\u0173" },
            { "GA", "Gabonas" },
            { "tkr", "tsakur\u0173" },
            { "vot", "Votik" },
            { "GB", "Jungtin\u0117 Karalyst\u0117" },
            { "pcm", "Nigerijos pid\u017ein\u0173" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Pranc\u016bzijos Gviana" },
            { "GG", "Gernsis" },
            { "GH", "Gana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltaras" },
            { "afh", "afrihili" },
            { "GL", "Grenlandija" },
            { "enm", "Vidurio Anglijos" },
            { "GM", "Gambija" },
            { "GN", "Gvin\u0117ja" },
            { "GP", "Gvadelupa" },
            { "GQ", "Pusiaujo Gvin\u0117ja" },
            { "GR", "Graikija" },
            { "GS", "Piet\u0173 D\u017eord\u017eija ir Piet\u0173 Sandvi\u010do salos" },
            { "GT", "Gvatemala" },
            { "GU", "Guamas" },
            { "pdc", "Pensilvanijos vokie\u010di\u0173" },
            { "GW", "Bisau Gvin\u0117ja" },
            { "tli", "tlingit\u0173" },
            { "tlh", "klingon\u0173" },
            { "Talu", "naujasis Tailando lue" },
            { "GY", "Gajana" },
            { "ckb", "sorani\u0173 kurd\u0173" },
            { "zxx", "n\u0117ra kalbinio turinio" },
            { "Jurc", "Jurchen" },
            { "tly", "taly\u0161\u0173" },
            { "pdt", "vokie\u010di\u0173 kalbos \u017eemai\u010di\u0173 tarm\u0117" },
            { "de_AT", "Austrijos vokie\u010di\u0173" },
            { "Vaii", metaValue_vai },
            { "HK", "Ypatingasis Administracinis Kinijos Regionas Honkongas" },
            { "HM", "Herdo ir Makdonaldo Salos" },
            { "HN", "Hond\u016bras" },
            { "HR", "Kroatija" },
            { "agq", "aghem\u0173" },
            { "gsw", "\u0160veicarijos vokie\u010di\u0173" },
            { "type.ca.islamic-umalqura", "Islamo kalendorius (Umm al-Qura)" },
            { "HT", "Haitis" },
            { "HU", "Vengrija" },
            { "rif", "rif\u0173" },
            { "tmh", "tama\u0161ek" },
            { "IC", "Kanar\u0173 salos" },
            { "nan", "kin\u0173 kalbos piet\u0173 min\u0173 tarm\u0117" },
            { "ID", "Indonezija" },
            { "peo", "senoji pers\u0173" },
            { "type.nu.kali", "Kayah Li skaitmenys" },
            { "IE", "Airija" },
            { "nap", "neapolie\u010di\u0173" },
            { "naq", "nama" },
            { "type.nu.sora", "Sora Sompeng skaitmenys" },
            { "zza", "zaza" },
            { "Tang", "Tangut" },
            { "IL", "Izraelis" },
            { "Nbat", "Nabat\u0117j\u0173" },
            { "IM", "Meno Sala" },
            { "IN", "Indija" },
            { "type.co.eor", "r\u016b\u0161iavimo tvarka daugiakalb\u0117s Europos dokument\u0173" },
            { "IO", "Indijos Vandenyno Brit\u0173 Sritis" },
            { "IQ", "Irakas" },
            { "IR", "Iranas" },
            { "IS", "Islandija" },
            { "IT", "Italija" },
            { "Zmth", "matematiniai simboliai" },
            { "type.nu.thai", "taj\u0173 skaitmenys" },
            { "vro", "veru" },
            { "guc", "vaj\u0173" },
            { "%%POSIX", "Kompiuteris" },
            { "type.nu.beng", "bengal\u0173 skaitmenys" },
            { "pfl", "vokie\u010di\u0173 kalbos Pfalco tarm\u0117" },
            { "JE", "D\u017eersis" },
            { "type.ca.islamic", "islamo kalendorius" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordanija" },
            { "gur", "frafra" },
            { "JP", "Japonija" },
            { "%%1606NICT", "1606 -\u0173j\u0173 met\u0173 pranc\u016bz\u0173 kalba" },
            { "ain", "ain\u0173" },
            { "Mend", "Mende" },
            { "guz", "gusi" },
            { "tog", "niasa tong\u0173" },
            { "type.nu.knda", "kanad\u0173 skaitmenys" },
            { "Kali", "kajah li" },
            { "Sidd", "Siddham" },
            { "de_CH", "\u0160veicarijos auk\u0161tutin\u0117 vokie\u010di\u0173" },
            { "type.co.phonetic", "Fonetin\u0117 rikiavimo tvarka" },
            { "izh", "ingr\u0173" },
            { "type.ca.buddhist", "budist\u0173 kalendorius" },
            { "KE", "Kenija" },
            { "419", "Lotyn\u0173 Amerika" },
            { "KG", "Kirgizija" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribatis" },
            { "KM", "Komorai" },
            { "Knda", metaValue_kn },
            { "KN", "Sent Kitsas ir Nevis" },
            { "Zinh", "paveld\u0117tas" },
            { "fr_CA", "Kanados pranc\u016bz\u0173" },
            { "KP", "\u0160iaur\u0117s Kor\u0117ja" },
            { "KR", "Piet\u0173 Kor\u0117ja" },
            { "Plrd", "polard fonetin\u0117" },
            { "fr_CH", "\u0160veicarijos pranc\u016bz\u0173" },
            { "KW", "Kuveitas" },
            { "tpi", "Papua pid\u017ein\u0173" },
            { "KY", "Kaiman\u0173 Salos" },
            { "KZ", "Kazachstanas" },
            { "Cyrl", "kirilica" },
            { "LA", "Laosas" },
            { "LB", "Libanas" },
            { "LC", "Sent Lusija" },
            { "phn", "finikie\u010di\u0173" },
            { "Cyrs", "senoji ba\u017enytin\u0117 slav\u0173 kirilica" },
            { "gwi", "gvi\u010dino" },
            { "nds", "\u017demutin\u0117s Vokietijos" },
            { "LI", "Lichten\u0161teinas" },
            { "LK", "\u0160ri Lanka" },
            { "akk", "akadian\u0173" },
            { "cop", metaValue_cop },
            { "LR", "Liberija" },
            { "esu", "centrin\u0117s Aliaskos jupik\u0173" },
            { "LS", "Lesotas" },
            { "Phlv", "buk pahvali" },
            { "LT", "Lietuva" },
            { "LU", "Liuksemburgas" },
            { "LV", "Latvija" },
            { "Kana", "katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libija" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "alabamie\u010di\u0173" },
            { "lah", "landa" },
            { "Mahj", "Mahad\u017eani" },
            { "lag", "langi" },
            { "Thaa", "hana" },
            { "MA", "Marokas" },
            { "MC", "Monakas" },
            { "MD", "Moldova" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Juodkalnija" },
            { "MF", "Sen Martenas" },
            { "lam", "lamba" },
            { "MG", "Madagaskaras" },
            { "Thai", metaValue_th },
            { "MH", "Mar\u0161alo Salos" },
            { "ale", "aleut\u0173" },
            { "MK", "\u0160iaur\u0117s Makedonija" },
            { "ML", "Malis" },
            { "MM", "Mianmaras (Birma)" },
            { "MN", "Mongolija" },
            { "new", "nevari" },
            { "MO", "Ypatingasis Administracinis Kinijos Regionas Makao" },
            { "aln", "alban\u0173 kalbos geg\u0173 tarm\u0117" },
            { "MP", "Marianos \u0160iaurin\u0117s Salos" },
            { "MQ", "Martinika" },
            { "MR", "Mauritanija" },
            { "MS", "Montseratas" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "type.m0.ungegn", "UNGEGN simboliai" },
            { "MU", "Mauricijus" },
            { "alt", "piet\u0173 Altajaus" },
            { "MV", "Maldyvai" },
            { "MW", "Malavis" },
            { "MX", "Meksika" },
            { "type.ca.japanese", "japon\u0173 kalendorius" },
            { "MY", "Malaizija" },
            { "MZ", "Mozambikas" },
            { "Phli", "ra\u0161ytiniai pahlavi" },
            { "NA", "Namibija" },
            { "202", "U\u017esachario Afrika" },
            { "type.ca.hebrew", "hebraj\u0173 kalendorius" },
            { "type.co.dictionary", "\u017eodyno r\u016b\u0161iavimo tvarka" },
            { "NC", "Naujoji Kaledonija" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "Suvienodinta i\u0161taisyta ra\u0161yba" },
            { "NE", "Nigeris" },
            { "NF", "Norfolko sala" },
            { "NG", "Nigerija" },
            { "trv", "Taroko" },
            { "Phlp", "pselter pahlavi" },
            { "NI", "Nikaragva" },
            { "Hmng", "pahav hmong" },
            { "NL", "Nyderlandai" },
            { "NO", "Norvegija" },
            { "NP", "Nepalas" },
            { "NR", "Nauru" },
            { "tsd", "tsakon\u0173" },
            { "NU", "Niuj\u0117" },
            { "Phnx", "foenik\u0173" },
            { "rof", "rombo" },
            { "tsi", "tsim\u0161ian" },
            { "NZ", "Naujoji Zelandija" },
            { "Merc", "Merojit\u0173 rankra\u0161tinis" },
            { "rom", "rom\u0173" },
            { "Mero", "meroitik" },
            { "crh", "Krymo turk\u0173" },
            { "ang", "senoji angl\u0173" },
            { "OM", "Omanas" },
            { "anp", "angik\u0173" },
            { "crs", "Sei\u0161eli\u0173 kreol\u0173 ir pranc\u016bz\u0173" },
            { "Xpeo", "senieji pers\u0173" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamo kalendorius (lentelinis, pilietin\u0117 era)" },
            { "csb", "ka\u0161ub\u0173" },
            { "en_GB", "Did\u017eiosios Britanijos angl\u0173" },
            { "PE", "Peru" },
            { "ttt", "musulmon\u0173 tat\u0173" },
            { "PF", "Pranc\u016bzijos Polinezija" },
            { "PG", "Papua Naujoji Gvin\u0117ja" },
            { "PH", "Filipinai" },
            { "PK", "Pakistanas" },
            { "PL", "Lenkija" },
            { "ewo", "evondo" },
            { "PM", "Sen Pjeras ir Mikelonas" },
            { "PN", "Pitkerno salos" },
            { "PR", "Puerto Rikas" },
            { "PS", "Palestinos teritorija" },
            { "Bali", "Balie\u010di\u0173" },
            { "PT", "Portugalija" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "graik\u0173 skaitmenys ma\u017eosiomis raid\u0117mis" },
            { "PY", "Paragvajus" },
            { "tum", "tumbuk\u0173" },
            { "Hebr", metaValue_he },
            { "QA", "Kataras" },
            { "%%SCOTLAND", "Normin\u0117 \u0161koti\u0161ka angl\u0173 kalba" },
            { "jam", "Jamaikos kreol\u0173 angl\u0173" },
            { "pms", "ital\u0173 kalbos Pjemonto tarm\u0117" },
            { "niu", "niujie\u010di\u0173" },
            { "QO", "Nuo\u0161ali Okeanija" },
            { "ext", "ispan\u0173 kalbos Ekstremad\u016bros tarm\u0117" },
            { "lez", "lezgin\u0173" },
            { "%%FONUPA", "UPA fonetika" },
            { "type.nu.takr", "Takri skaitmenys" },
            { "tvl", metaValue_TV },
            { "Tavt", "tai vet" },
            { "001", "pasaulis" },
            { "002", "Afrika" },
            { "njo", "ao naga" },
            { "003", "\u0160iaur\u0117s Amerika" },
            { "RE", "Reunjonas" },
            { "005", "Piet\u0173 Amerika" },
            { "lfn", "naujoji frank\u0173 kalba" },
            { "jbo", "loiban" },
            { "pnt", "Ponto" },
            { "Rjng", "rejang" },
            { "009", "Okeanija" },
            { "RO", "Rumunija" },
            { "RS", "Serbija" },
            { "Mroo", "Mro" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "Naujieji Tai Lue skaitmenys" },
            { "Mani", "mani\u010d\u0173" },
            { "Ugar", "ugaritik" },
            { "Khar", "karo\u0161ti" },
            { "SA", "Saudo Arabija" },
            { "pon", "Ponap\u0117s" },
            { "Mand", "mand\u0117j\u0173" },
            { "SB", "Saliamono Salos" },
            { "twq", "tasavak\u0173" },
            { "011", "Vakar\u0173 Afrika" },
            { "SC", "Sei\u0161eliai" },
            { "SD", "Sudanas" },
            { "013", "Centrin\u0117 Amerika" },
            { "SE", "\u0160vedija" },
            { "014", "Ryt\u0173 Afrika" },
            { "arc", "aramaik\u0173" },
            { "Loma", "Loma" },
            { "015", "\u0160iaur\u0117s Afrika" },
            { "SG", "Singap\u016bras" },
            { "SH", "\u0160v. Elenos Sala" },
            { "type.lb.strict", "grie\u017etas teksto lau\u017eymo stilius" },
            { "017", "Vidurio Afrika" },
            { "SI", "Slov\u0117nija" },
            { "018", "Pietin\u0117 Afrika" },
            { "SJ", "Svalbardas ir Janas Majenas" },
            { "019", "Amerika" },
            { "SK", "Slovakija" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Siera Leon\u0117" },
            { "SM", "San Marinas" },
            { "SN", "Senegalas" },
            { "SO", "Somalis" },
            { "arn", "mapudungun\u0173" },
            { "arp", "arapah\u0173" },
            { "type.nu.taml", "tradicin\u0117s tamil\u0173 skaitmenys" },
            { "SR", "Surinamas" },
            { "aro", "araon\u0173" },
            { "SS", "Piet\u0173 Sudanas" },
            { "ST", "San Tom\u0117 ir Prinsip\u0117" },
            { "arq", "Al\u017eyro arab\u0173" },
            { "SV", "Salvadoras" },
            { "SX", "Sint Martenas" },
            { "SY", "Sirija" },
            { "yao", "jao" },
            { "SZ", "Svazilandas" },
            { "arw", "aravak\u0173" },
            { "arz", "Egipto arab\u0173" },
            { "ary", "Maroko arab\u0173" },
            { "yap", "japez\u0173" },
            { "rtm", "rotuman\u0173" },
            { "TA", "Tristano da Kunjos" },
            { "asa", "asu" },
            { "type.ms.ussystem", "amerikieti\u0161ka mat\u0173 sistema" },
            { "021", "\u0160iaurin\u0117 Amerika" },
            { "TC", "Terkso ir Kaikoso Salos" },
            { "yav", "jangben\u0173" },
            { "TD", "\u010cadas" },
            { "TF", "Pranc\u016bzijos Piet\u0173 sritys" },
            { "ase", "Amerikos \u017eenkl\u0173 kalba" },
            { "TG", "Togas" },
            { "TH", "Tailandas" },
            { "TJ", "Tad\u017eikija" },
            { "TK", metaValue_TK },
            { "029", "Karibai" },
            { "TL", "Ryt\u0173 Timoras" },
            { "ybb", "jemb\u0173" },
            { "TM", "Turkm\u0117nistanas" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunisas" },
            { "TO", "Tonga" },
            { "TR", "Turkija" },
            { "TT", "Trinidadas ir Tobagas" },
            { "TV", metaValue_TV },
            { "TW", "Taivanas" },
            { "ast", "asturian\u0173" },
            { "rue", "rusin\u0173" },
            { "rug", "Rovianos" },
            { "Orkh", "orkon" },
            { "TZ", "Tanzanija" },
            { "nmg", "kvasi\u0173" },
            { "Zzzz", "ne\u017einomi ra\u0161menys" },
            { "Sind", "Khudawadi" },
            { "UA", "Ukraina" },
            { "lij", "lig\u016br\u0173" },
            { "rup", "aromani\u0173" },
            { "030", "Ryt\u0173 Azija" },
            { "tyv", "tuvi\u0173" },
            { "sw_CD", "Kongo suahili\u0173" },
            { "034", "Piet\u0173 Azija" },
            { "hai", "haido" },
            { "035", "Pietry\u010di\u0173 Azija" },
            { "UG", "Uganda" },
            { "hak", "kin\u0173 kalbos hak\u0173 tarm\u0117" },
            { "type.co.pinyin", "supaprastinta kini\u0161k\u0173 hieroglif\u0173 r\u016b\u0161iavimo tvarka" },
            { "039", "Piet\u0173 Europa" },
            { "Sinh", metaValue_si },
            { "UM", "Jungtini\u0173 Valstij\u0173 Ma\u017eosios Tolimosios Salos" },
            { "liv", "lyvi\u0173" },
            { "UN", "Jungtin\u0117s Tautos" },
            { "US", "Jungtin\u0117s Valstijos" },
            { "haw", "havajie\u010di\u0173" },
            { "%%1959ACAD", "Akademinis" },
            { "type.co.gb2312han", "supaprastinta kini\u0161ka r\u016b\u0161iavimo tvarka - GB2312" },
            { "UY", "Urugvajus" },
            { "prg", "pr\u016bs\u0173" },
            { "UZ", "Uzbekistanas" },
            { "tzm", "Centrinio Maroko tamazit\u0173" },
            { "type.co.stroke", "\u012eprasta kini\u0161ko po\u017eymio r\u016b\u0161iavimo tvarka" },
            { "nnh", "ngiemb\u016bn\u0173" },
            { "VA", "Vatikano Miesto Valstyb\u0117" },
            { "pro", "senov\u0117s provansal\u0173" },
            { "VC", "\u0160ventasis Vincentas ir Grenadinai" },
            { "VE", "Venesuela" },
            { "VG", "Did\u017eiosios Britanijos Mergeli\u0173 Salos" },
            { "VI", "Jungtini\u0173 Valstij\u0173 Mergeli\u0173 Salos" },
            { "VN", "Vietnamas" },
            { "VU", "Vanuatu" },
            { "nog", "nog\u0173" },
            { "rwk", "rua" },
            { "non", "senoji nors\u0173" },
            { "053", "Australazija" },
            { "%%AREVMDA", "Vakar\u0173 arm\u0117nai" },
            { "054", "Melanezija" },
            { "WF", "Volisas ir Fut\u016bna" },
            { "type.co.traditional", "\u012fprasta r\u016b\u0161iavimo tvarka" },
            { "057", "Mikronezijos regionas" },
            { "jgo", "ngomb\u0173" },
            { "lkt", "lakot\u0173" },
            { "nov", "novial" },
            { "type.nu.finance", "Finansiniai skai\u010diai" },
            { "avk", "kotava" },
            { "type.co.compat", "ankstesn\u0117 r\u016b\u0161iavimo tvarka, skirta suderinamumui" },
            { "wae", "valser\u0173" },
            { "WS", metaValue_WS },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Meetei Mayek skaitmenys" },
            { "wal", "valamo" },
            { "was", "Va\u0161o" },
            { "XA", "pseudo A" },
            { "war", "varai" },
            { "XB", "pseudo B" },
            { "awa", "avadhi" },
            { "061", "Polinezija" },
            { "XK", "Kosovas" },
            { "type.nu.brah", "Brahmi skaitmenys" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "nepara\u0161yta" },
            { "Olck", "ol \u010diki" },
            { "wbp", "valrpiri" },
            { "Batk", "batak" },
            { "Blis", "\u201eBliss\u201c simboliai" },
            { "YE", "Jemenas" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "standartinis rikiavimas" },
            { "lmo", "lombard\u0173" },
            { "fan", "fang\u0173" },
            { "%%ROZAJ", "Resian" },
            { "fat", "fanti" },
            { "Sgnw", "\u017eenkl\u0173 ra\u0161tas" },
            { "YT", "Majotas" },
            { "type.nu.cham", "cham skaitmenys" },
            { "ZA", "Piet\u0173 Afrika" },
            { "type.nu.sund", "Sudanie\u010di\u0173 skaitmenys" },
            { "type.lb.loose", "laisvas teksto lau\u017eymo stilius" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "gruzin\u0173 skaitmenys" },
            { "type.co.zhuyin", "Zhuyin rikiavimo tvarka" },
            { "Hira", "hiragana" },
            { "ZM", "Zambija" },
            { "%%PINYIN", "Kin\u0173 hieroglif\u0173 vertimo sistema Romanization" },
            { "ZW", "Zimbabv\u0117" },
            { "ZZ", "ne\u017einoma sritis" },
            { "Runr", "run\u0173" },
            { "type.ms.metric", "metrin\u0117 sistema" },
            { "type.ca.iso8601", "ISO 8601 kalendorius" },
            { "lol", "mong\u0173" },
            { "nso", "\u0161iaur\u0117s Soto" },
            { "type.nu.telu", "telug\u0173 skaitmenys" },
            { "lou", "Luizianos kreol\u0173" },
            { "loz", "lozi\u0173" },
            { "Nkgb", "Naxi Geba" },
            { "jmc", "ma\u010dam\u0173" },
            { "hif", "Fid\u017eio hindi" },
            { "type.nu.hansfin", "supaprastintos kin\u0173 k. finans. skaitmenys" },
            { "hil", "hiligainon\u0173" },
            { "type.nu.arabext", "i\u0161pl\u0117stiniai arab\u0173-ind\u0173 skaitmenys" },
            { "nus", "nuer\u0173" },
            { "dak", "dakot\u0173" },
            { "type.nu.fullwide", "viso plo\u010dio skaitmenys" },
            { "hit", "hitit\u0173" },
            { "dar", "dargva" },
            { "dav", "tait\u0173" },
            { "Maya", "mal\u0173 hieroglifai" },
            { "lrc", "\u0161iaur\u0117s luri" },
            { "Copt", metaValue_cop },
            { "nwc", "klasikin\u0117 nevari" },
            { "udm", "udmurt\u0173" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Islamo kalendorius (Saudo Arabija)" },
            { "Limb", "limbu" },
            { "sad", "sandavi\u0173" },
            { "type.nu.roman", "rom\u0117ni\u0161ki skaitmenys" },
            { "sah", "jakut\u0173" },
            { "type.nu.shrd", "\u0160arad\u0173 skaitmenys" },
            { "ltg", "latgali\u0173" },
            { "sam", "samar\u0117j\u0173 arami\u0173" },
            { "Aghb", "Kaukazo Albanijos" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "samb\u016br\u0173" },
            { "sas", "sasak" },
            { "sat", "santali\u0173" },
            { "Tfng", "tifinag" },
            { "jpr", "jud\u0117j\u0173 pers\u0173" },
            { "saz", "saura\u0161tr\u0173" },
            { "type.d0.npinyin", "Skaitinis" },
            { "type.nu.native", "Vietiniai skaitmenys" },
            { "sba", "ngambaj\u0173" },
            { "Guru", "gurmuki" },
            { "lua", "luba lulua" },
            { "type.d0.fwidth", "viso plo\u010dio" },
            { "sbp", "sang\u0173" },
            { "lui", "luiseno" },
            { "nyn", "niankol\u0173" },
            { "nym", "niamvezi" },
            { "lun", "Lundos" },
            { "nyo", "nior\u0173" },
            { "luo", "luo" },
            { "fil", "filipinie\u010di\u0173" },
            { "hmn", "hmong" },
            { "del", "delavero" },
            { "lus", "mizo" },
            { "bal", "balu\u010di" },
            { "den", "slave" },
            { "ban", "balie\u010di\u0173" },
            { "uga", "ugarit\u0173" },
            { "fit", "suomi\u0173 kalbos Tornedalio tarm\u0117" },
            { "luy", "luja" },
            { "bar", "bavar\u0173" },
            { "bas", "bas\u0173" },
            { "bax", "bamun\u0173" },
            { "jrb", "jud\u0117j\u0173 arab\u0173" },
            { "es_ES", "Europos ispan\u0173" },
            { "nzi", "nzima" },
            { "sco", "\u0161kot\u0173" },
            { "scn", "sicilie\u010di\u0173" },
            { "aa", "afar\u0173" },
            { "ab", "abchaz\u0173" },
            { "bbc", "batak toba" },
            { "ae", "avest\u0173" },
            { "af", "afrikan\u0173" },
            { "ak", "akan\u0173" },
            { "type.nu.cakm", "\u010cakm\u0173 skaitmenys" },
            { "bbj", "ghomal\u0173" },
            { "am", "amhar\u0173" },
            { "Arab", metaValue_ar },
            { "an", "aragones\u0173" },
            { "%%SOLBA", "Stolvizza / Solbica tarm\u0117" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana / hiragana" },
            { "as", "asam\u0173" },
            { "sdc", "sasares\u0173 sardin\u0173" },
            { "Lina", "linijiniai A" },
            { "av", "avarik\u0173" },
            { "Linb", "linijiniai B" },
            { "sdh", "piet\u0173 kurd\u0173" },
            { "ay", "aimar\u0173" },
            { "az", "azerbaid\u017eanie\u010di\u0173" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Oseacco / Osojane tarm\u0117" },
            { "ba", "ba\u0161kir\u0173" },
            { "type.co.unihan", "\u0160aknies \u017eenkl\u0173 ir br\u016bk\u0161ni\u0173 r\u016b\u0161iavimo tvarka" },
            { "be", "baltarusi\u0173" },
            { "bg", "bulgar\u0173" },
            { "bi", "bislama" },
            { "type.nu.java", "javie\u010di\u0173 skaitmenys" },
            { "bm", "bambar\u0173" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib\u0173" },
            { "br", "breton\u0173" },
            { "bs", "bosni\u0173" },
            { "see", "senec\u0173" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "type.nu.laoo", "laosie\u010di\u0173 skaitmenys" },
            { "seh", "sen\u0173" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "katalon\u0173" },
            { "ses", "kojraboro seni" },
            { "ce", "\u010de\u010d\u0117n\u0173" },
            { "ch", "\u010damor\u0173" },
            { "%%REVISED", "I\u0161taisyta ra\u0161yba" },
            { "co", "korsikie\u010di\u0173" },
            { "Orya", "orij\u0173" },
            { "cr", "kry" },
            { "cs", "\u010dek\u0173" },
            { "cu", "ba\u017enytin\u0117 slav\u0173" },
            { "yrl", "njengatu" },
            { "cv", "\u010diuva\u0161\u0173" },
            { "cy", "val\u0173" },
            { "type.nu.ethi", "Etiopijos skaitmenys" },
            { "Yiii", "ji" },
            { "da", "dan\u0173" },
            { "pt_PT", "Europos portugal\u0173" },
            { "de", "vokie\u010di\u0173" },
            { "type.cf.standard", "standartinis valiutos formatas" },
            { "bej", "b\u0117j\u0173" },
            { "din", "dink\u0173" },
            { "jut", "dan\u0173 kalbos jut\u0173 tarm\u0117" },
            { "Bugi", metaValue_bug },
            { "bem", "bemb\u0173" },
            { "sga", "senoji airi\u0173" },
            { "type.nu.mong", "mongol\u0173 skaitmenys" },
            { "dv", "diveh\u0173" },
            { "es_419", "Lotyn\u0173 Amerikos ispan\u0173" },
            { "bew", "betavi" },
            { "dz", "botij\u0173" },
            { "bez", "ben\u0173" },
            { "type.ca.chinese", "kin\u0173 kalendorius" },
            { "lzh", "klasikin\u0117 kin\u0173" },
            { "Lisu", "Fraser" },
            { "dje", "zarm\u0173" },
            { "sgs", "\u017eemai\u010di\u0173" },
            { "type.nu.grek", "graik\u0173 skaitmenys" },
            { "ee", "evi\u0173" },
            { "bfd", "bafut\u0173" },
            { "type.lb.normal", "\u012fprastas teksto lau\u017eymo stilius" },
            { "ro_MD", "moldav\u0173" },
            { "el", metaValue_el },
            { "en", "angl\u0173" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "laz" },
            { "type.co.big5han", "\u012fprasta kini\u0161ka r\u016b\u0161iavimo tvarka - Big5" },
            { "es", "ispan\u0173" },
            { "et", "est\u0173" },
            { "Hanb", "hanb\u0173" },
            { "eu", "bask\u0173" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samarie\u010di\u0173" },
            { "shi", "tachelhit\u0173" },
            { "hsb", "auk\u0161tutini\u0173 sorb\u0173" },
            { "Hani", "han" },
            { "shn", "\u0161an" },
            { "Hano", "hanuno" },
            { "fa", "pers\u0173" },
            { "Hans", "supaprastinti" },
            { "type.nu.latn", "lotyni\u0161ki skaitmenys" },
            { "Hant", "tradiciniai" },
            { "ff", "fulah\u0173" },
            { "shu", "chadian arab\u0173" },
            { "hsn", "kin\u0173 kalbos hunano tarm\u0117" },
            { "fi", "suomi\u0173" },
            { "fj", "fid\u017ei\u0173" },
            { "fon", "fon" },
            { "bgn", "vakar\u0173 belud\u017ei\u0173" },
            { "yue", "kin\u0173 kalbos Kantono tarm\u0117" },
            { "fo", "farer\u0173" },
            { "type.m0.bgn", "BGN simboliai" },
            { "umb", "umbundu" },
            { "fr", "pranc\u016bz\u0173" },
            { "sid", "sidam\u0173" },
            { "fy", "vakar\u0173 fryz\u0173" },
            { "ga", "airi\u0173" },
            { "gd", "\u0161kot\u0173 (g\u0117l\u0173)" },
            { "gl", "galis\u0173" },
            { "gn", "gvarani\u0173" },
            { "bho", "bau\u010dpuri" },
            { "und", "ne\u017einoma kalba" },
            { "type.ca.ethiopic-amete-alem", "Etiopijos \u201eAmete Alem\u201c kalendorius" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Islamo kalendorius (lentelinis, astronomin\u0117 era)" },
            { "gv", "menie\u010di\u0173" },
            { "type.nu.osma", "Osman\u0173 skaitmenys" },
            { "ha", "haus\u0173" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol\u0173" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "kroat\u0173" },
            { "ht", "Hai\u010dio" },
            { "hu", "vengr\u0173" },
            { "hy", metaValue_hy },
            { "hz", "herer\u0173" },
            { "frc", "kad\u017eun\u0173 pranc\u016bz\u0173" },
            { "%%FONIPA", "Tarptautin\u0117s ab\u0117c\u0117l\u0117s fonetika" },
            { "ia", "tarpin\u0117" },
            { "Jamo", "Jamo simboliai" },
            { "id", "indonezie\u010di\u0173" },
            { "type.nu.tibt", "tibetie\u010di\u0173 skaitmenys" },
            { "ie", "interkalba" },
            { "ig", "igb\u0173" },
            { "ii", "si\u010duan ji" },
            { "frm", "Vidurio Pranc\u016bzijos" },
            { "ik", "inupiak\u0173" },
            { "fro", "senoji pranc\u016bz\u0173" },
            { "frp", "arpitano" },
            { "io", "ido" },
            { "frs", "ryt\u0173 fryz\u0173" },
            { "bjn", "band\u017ear\u0173" },
            { "frr", "\u0161iaurini\u0173 fryz\u0173" },
            { "is", "island\u0173" },
            { "it", "ital\u0173" },
            { "iu", "inukitut" },
            { "sli", "silezie\u010di\u0173 \u017eemai\u010di\u0173" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "senoji piet\u0173 Arabijos" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selajar\u0173" },
            { "type.nu.lepc", "Lepcha skaitmenys" },
            { "bkm", "kom\u0173" },
            { "sma", "piet\u0173 sami\u0173" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0161avi\u0173" },
            { "mad", "madurez\u0173" },
            { "smj", "Liuleo sami\u0173" },
            { "mag", "magahi" },
            { "maf", "maf\u0173" },
            { "mai", "maithili" },
            { "smn", "Inario sami\u0173" },
            { "ka", metaValue_ka },
            { "bla", "siksik\u0173" },
            { "mak", "Makasaro" },
            { "wuu", "kin\u0173 kalbos vu tarm\u0117" },
            { "sms", "Skolto sami\u0173" },
            { "man", "manding\u0173" },
            { "kg", "Kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuj\u0173" },
            { "mas", "masaj\u0173" },
            { "kj", "kuaniama" },
            { "kk", "kazach\u0173" },
            { "kl", "kalalisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri\u0173" },
            { "ks", "ka\u0161myr\u0173" },
            { "Cirt", "kirt" },
            { "Lepc", "lep\u010da" },
            { "Avst", "avestano" },
            { "ku", "kurd\u0173" },
            { "kv", "komi" },
            { "kw", "korn\u0173" },
            { "ky", "kirgiz\u0173" },
            { "snk", "soninke" },
            { "la", metaValue_la },
            { "lb", "liuksemburgie\u010di\u0173" },
            { "type.nu.mlym", "malajali\u0173 skaitmenys" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgie\u010di\u0173" },
            { "Tibt", metaValue_bo },
            { "ln", "ngal\u0173" },
            { "fur", "friuli\u0173" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "angli\u0161ka mat\u0173 sistema" },
            { "type.nu.lana", "Tai Tham Hora skaitmenys" },
            { "lt", "lietuvi\u0173" },
            { "lu", "luba katanga" },
            { "lv", "latvi\u0173" },
            { "sog", "sogdien" },
            { "mg", "malagas\u0173" },
            { "mh", "Mar\u0161alo Sal\u0173" },
            { "type.co.ducet", "numatytasis unikodo rikiavimas" },
            { "mi", "maori\u0173" },
            { "mk", "makedon\u0173" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marat\u0173" },
            { "ms", "malajie\u010di\u0173" },
            { "mt", "maltie\u010di\u0173" },
            { "my", metaValue_my },
            { "Saur", "saura\u0161tra" },
            { "Armn", metaValue_hy },
            { "mdf", "mok\u0161a" },
            { "mde", "mab\u0173" },
            { "dsb", "\u017eemutini\u0173 sorb\u0173" },
            { "Armi", "imperin\u0117 aramaik\u0173" },
            { "na", "naur\u0173" },
            { "type.co.search", "bendroji paie\u0161ka" },
            { "nb", "norveg\u0173 bukmolas" },
            { "nd", "\u0161iaur\u0117s ndebel\u0173" },
            { "ne", "nepalie\u010di\u0173" },
            { "ng", "ndong\u0173" },
            { "mdr", "mandar\u0173" },
            { "nl", "oland\u0173" },
            { "nn", "naujoji norveg\u0173" },
            { "no", "norveg\u0173" },
            { "nr", "piet\u0173 ndebele" },
            { "nv", "navaj\u0173" },
            { "kaa", "karakalpak\u0173" },
            { "ny", "nianj\u0173" },
            { "kac", "ka\u010din\u0173" },
            { "kab", "kebail\u0173" },
            { "%%POLYTON", "Polytonic" },
            { "oc", "o\u010ditar\u0173" },
            { "kaj", "ju" },
            { "kam", "kemb\u0173" },
            { "men", "mende" },
            { "oj", "ojibva" },
            { "mer", "mer\u0173" },
            { "type.nu.armn", "arm\u0117n\u0173 skaitmenys" },
            { "om", "orom\u0173" },
            { "kaw", "kavi\u0173" },
            { "dtp", "centrinio Dusuno" },
            { "or", "odij\u0173" },
            { "Modi", "Modi" },
            { "os", "osetin\u0173" },
            { "bpy", "bi\u0161nuprijos" },
            { "kbd", "kabardin\u0173" },
            { "mfe", "morisij\u0173" },
            { "srn", "sranan tongo" },
            { "pa", "pend\u017eab\u0173" },
            { "dua", "dual\u0173" },
            { "srr", "serer\u0173" },
            { "%%LIPAW", "Resian tarmei priklausanti Lipovaz tarm\u0117" },
            { "kbl", "kanemb\u0173" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "lenk\u0173" },
            { "dum", "Vidurio Vokietijos" },
            { "type.nu.saur", "Saura\u0161tr\u0173 skaitmenys" },
            { "type.ca.dangi", "dangi kalendorius" },
            { "ps", "pu\u0161t\u016bn\u0173" },
            { "pt", "portugal\u0173" },
            { "mga", "Vidurio Airijos" },
            { "key.co", "rikiavimas" },
            { "pt_BR", "Brazilijos portugal\u0173" },
            { "kcg", "tyap" },
            { "mgh", "makua-maeto" },
            { "key.cf", "valiutos formatas" },
            { "type.nu.nkoo", "N\u2019Ko skaitmenys" },
            { "bra", "braj\u0173" },
            { "key.ca", "kalendorius" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta" },
            { "type.hc.h23", "24 valand\u0173 sistema (0\u201323)" },
            { "type.hc.h24", "24 valand\u0173 sistema (1\u201324)" },
            { "ssy", "saho" },
            { "brh", "brahuj\u0173" },
            { "type.nu.mymr", "mianmarie\u010di\u0173 skaitmenys" },
            { "qu", "ke\u010duj\u0173" },
            { "zap", "zapotek\u0173" },
            { "brx", "bodo" },
            { "Lana", "lana" },
            { "kde", "makond\u0173" },
            { "stq", "Saterlendo fryz\u0173" },
            { "Ethi", "etiop\u0173" },
            { "type.hc.h12", "12 valand\u0173 sistema (1\u201312)" },
            { "type.hc.h11", "12 valand\u0173 sistema (0\u201311)" },
            { "rm", "retoroman\u0173" },
            { "rn", "rundi" },
            { "key.cu", "valiuta" },
            { "ro", "rumun\u0173" },
            { "%%SAAHO", "Saho" },
            { "type.nu.orya", "orij\u0173 skaitmenys" },
            { "type.nu.hanidec", "kin\u0173 de\u0161imtainiai skaitmenys" },
            { "ru", "rus\u0173" },
            { "bss", "ak\u016bs\u0173" },
            { "rw", "kinjaruand\u0173" },
            { "zbl", "BLISS simboli\u0173" },
            { "kea", "\u017daliojo Ky\u0161ulio kreol\u0173" },
            { "mic", "mikmak\u0173" },
            { "suk", "sukuma" },
            { "en_AU", "Australijos angl\u0173" },
            { "Dupl", "Duploj\u0117 stenografija" },
            { "sa", "sanskritas" },
            { "%%UCCOR", "Suvienodinta ra\u0161yba" },
            { "sc", "sardinie\u010di\u0173" },
            { "sus", "susu" },
            { "sd", "sind\u0173" },
            { "se", "\u0161iaur\u0117s sami\u0173" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serb\u0173-kroat\u0173" },
            { "ken", "kenyang" },
            { "si", metaValue_si },
            { "sux", "\u0161umer\u0173" },
            { "sk", "slovak\u0173" },
            { "sl", "slov\u0117n\u0173" },
            { "Gran", "Granta" },
            { "sm", metaValue_WS },
            { "sn", "\u0161on\u0173" },
            { "so", "somalie\u010di\u0173" },
            { "type.nu.arab", "arab\u0173-ind\u0173 skaitmenys" },
            { "sq", "alban\u0173" },
            { "sr", "serb\u0173" },
            { "ss", "svat\u0173" },
            { "type.cf.account", "apskaitos valiutos formatas" },
            { "Java", metaValue_jv },
            { "st", "piet\u0173 Soto" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone tarm\u0117" },
            { "sv", "\u0161ved\u0173" },
            { "sw", "suahili\u0173" },
            { "type.nu.hantfin", "tradicin\u0117s kin\u0173 k. finans. skaitmenys" },
            { "ibb", "ibibij\u0173" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Azija" },
            { "bua", "buriat\u0173" },
            { "143", "Centrin\u0117 Azija" },
            { "te", metaValue_te },
            { "145", "Vakar\u0173 Azija" },
            { "tg", "tad\u017eik\u0173" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigraj\u0173" },
            { "kfo", "koro" },
            { "en_CA", "Kanados angl\u0173" },
            { "tk", "turkm\u0117n\u0173" },
            { "tl", metaValue_tl },
            { "tn", "tsvan\u0173" },
            { "to", "tongan\u0173" },
            { "bum", "bulu" },
            { "dyo", "d\u017eiola-foni" },
            { "type.nu.jpan", "japon\u0173 skaitmenys" },
            { "tr", "turk\u0173" },
            { "ts", "tsong\u0173" },
            { "swb", "Komor\u0173" },
            { "Cakm", "\u010dakma" },
            { "tt", "totori\u0173" },
            { "dyu", "dyul\u0173" },
            { "tw", "tvi" },
            { "ty", "taitie\u010di\u0173" },
            { "%%BISKE", "San Giorgio / Bila tarm\u0117" },
            { "150", "Europa" },
            { "151", "Ryt\u0173 Europa" },
            { "154", "\u0160iaur\u0117s Europa" },
            { "dzg", "dazag\u0173" },
            { "155", "Vakar\u0173 Europa" },
            { "ug", "uig\u016br\u0173" },
            { "Kore", metaValue_ko },
            { "Ital", "senasis ital\u0173" },
            { "kgp", "kaingang" },
            { "Zyyy", "bendri" },
            { "uk", "ukrainie\u010di\u0173" },
            { "zea", "zeland\u0173" },
            { "type.ca.coptic", "kopt\u0173 kalendorius" },
            { "ur", "urd\u0173" },
            { "%%1994", "Sunorminta Resian ra\u0161yba" },
            { "xal", "kalmuk\u0173" },
            { "zen", "zenaga" },
            { "uz", "uzbek\u0173" },
            { "kha", "kasi" },
            { "%%1996", "1996 -\u0173j\u0173 met\u0173 vokie\u010di\u0173 ra\u0161yba" },
            { "nds_NL", "\u017demutin\u0117s Saksonijos (Nyderlandai)" },
            { "Sylo", "syloti nagri" },
            { "ve", "vend\u0173" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Kinijos Respublikos kalendorius" },
            { "vi", "vietnamie\u010di\u0173" },
            { "kho", "kotanez\u0173" },
            { "khq", "kojra \u010dini" },
            { "key.hc", "valand\u0173 ciklas (12 ir 24)" },
            { "%%TARASK", "Taraskievica tarm\u0117" },
            { "vo", "volapiuko" },
            { "khw", "khovar\u0173" },
            { "syc", "klasikin\u0117 sir\u0173" },
            { "Osma", "osman\u0173" },
            { "quc", "ki\u010di\u0173" },
            { "qug", "\u010cimboraso auk\u0161tum\u0173 ke\u010duj\u0173" },
            { "gaa", "ga" },
            { "wa", "valon\u0173" },
            { "gag", "gaga\u016bz\u0173" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "kin\u0173 kalbos dziangsi tarm\u0117" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lidian" },
            { "Xsux", "\u0160umero Akado dantira\u0161tis" },
            { "wo", "volof\u0173" },
            { "zgh", "standartin\u0117 Maroko tamazigt\u0173" },
            { "ar_001", "\u0161iuolaikin\u0117 standartin\u0117 arab\u0173" },
            { "Cans", "suvienodinti Kanados aborigen\u0173 silabiniai" },
            { "gay", "gajo" },
            { "Mong", metaValue_mn },
            { "mnc", "man\u010du" },
            { "Latf", "fraktur lotyn\u0173" },
            { "szl", "silezie\u010di\u0173" },
            { "Hluw", "Anatolijaus hieroglifai" },
            { "gba", "gbaja" },
            { "mni", "manipuri\u0173" },
            { "Latn", metaValue_la },
            { "Latg", "g\u0117l\u0173 lotyn\u0173" },
            { "type.nu.hans", "supaprastintos kin\u0173 k. skaitmenys" },
            { "type.nu.hant", "tradicin\u0117s kin\u0173 k. skaitmenys" },
            { "xh", "kos\u0173" },
            { "type.nu.romanlow", "rom\u0117ni\u0161ki skaitmenys ma\u017eosiomis raid\u0117mis" },
            { "byn", "blin" },
            { "Lyci", "lician" },
            { "osa", "osage" },
            { "byv", "medumb\u0173" },
            { "gbz", "zoroastr\u0173 dari" },
            { "Moon", "m\u016bn" },
            { "moh", "mohok" },
            { "kkj", "kako" },
            { "%%1694ACAD", "Ankstyvasis Pranc\u016bzijos modernizmas" },
            { "Syrc", metaValue_syr },
            { "yi", "jidi\u0161" },
            { "mos", "mosi" },
            { "Dsrt", "deseretas" },
            { "yo", "jorub\u0173" },
            { "type.nu.traditional", "Tradiciniai skai\u010diai" },
            { "es_MX", "Meksikos ispan\u0173" },
            { "Syrj", "vakar\u0173 sir\u0173" },
            { "ota", "osman\u0173 turk\u0173" },
            { "Syre", "estrangelo sirie\u010di\u0173" },
            { "vai", metaValue_vai },
            { "za", "chuang" },
            { "Cari", "kari\u0173" },
            { "kln", "kalenjin\u0173" },
            { "zh", "kin\u0173" },
            { "Afak", "Afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "senieji perm\u0117s" },
            { "key.lb", "teksto lau\u017eymo stilius" },
            { "zu", "zul\u0173" },
            { "type.co.phonebook", "telefon\u0173 knygos r\u016b\u0161iavimo tvarka" },
            { "%%MONOTON", "Vienodas" },
            { "Geor", metaValue_ka },
            { "Shrd", "\u0160arados" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japon\u0173 finans. skaitmenys" },
            { "Cham", "\u010dam" },
            { "gez", "gyz" },
            { "mrj", "vakar\u0173 mari" },
            { "Syrn", "ryt\u0173 sir\u0173" },
            { "type.nu.mymrshan", "Myanmar Shan skaitmenys" },
            { "Elba", "Elbasano" },
            { "Narb", "Senasis \u0161iaur\u0117s arab\u0173" },
            { "type.nu.olck", "Ol Chiki skaitmenys" },
            { "type.co.reformed", "reformuota r\u016b\u0161iavimo tvarka" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Egipto liaudies" },
            { "Egyh", "Egipto \u017eyni\u0173" },
            { "Palm", "Palmiros" },
            { "ebu", "embu" },
            { "Egyp", "egipto hieroglifai" },
            { "Geok", "gruzin\u0173 kutsuri" },
            { "zh_Hans", "supaprastintoji kin\u0173" },
            { "koi", "komi\u0173-permi\u0173" },
            { "Hung", "senasis vengr\u0173" },
            { "kok", "konkani\u0173" },
            { "%%1901", "\u012eprasta vokie\u010di\u0173 ra\u0161yba" },
            { "kos", "kosrean\u0173" },
            { "vec", "venet\u0173" },
            { "type.nu.limb", "Limbu skaitmenys" },
            { "zh_Hant", "tradicin\u0117 kin\u0173" },
            { "Sund", metaValue_su },
            { "vep", "veps\u0173" },
            { "kpe", "kpeli\u0173" },
            { "type.nu.khmr", "khmer\u0173 skaitmenys" },
            { "Tirh", "Tirhuta" },
            { "ilo", "ilok\u0173" },
            { "%%VALENCIA", "Valencie\u010diai" },
            { "Cprt", "kipro" },
            { "%%BAKU1926", "Suvienodinta turk\u0173 kalbos lotyni\u0161ka ab\u0117c\u0117l\u0117" },
            { "mua", "mundang\u0173" },
            { "type.nu.guru", "gurmuki skaitmenys" },
            { "mul", "kelios kalbos" },
            { "cad", "kado" },
            { "key.ms", "mat\u0173 sistema" },
            { "mus", "kryk\u0173" },
            { "Glag", "glagolitik" },
            { "gil", "kiribati" },
            { "%%KKCOR", "\u012eprasta ra\u0161yba" },
            { "Cher", metaValue_chr },
            { "car", "karib\u0173" },
            { "cay", "kaij\u016bg\u0173" },
            { "type.nu.tamldec", "tamil\u0173 skaitmenys" },
            { "krc", "kara\u010diaj\u0173 balkarijos" },
            { "inh", "ingu\u0161\u0173" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karel\u0173" },
            { "efi", "efik" },
            { "tcy", "tul\u0173" },
            { "key.nu", "skai\u010diai" },
            { "kru", "kuruk" },
            { "ksb", "\u0161ambal\u0173" },
            { "Telu", metaValue_te },
            { "ksf", "baf\u0173" },
        };
        return data;
    }
}
