/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import jdk.internal.jimage.ImageStream;

public final class ImageHeader {
    public static final int MAGIC = -889267494;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    private static final int HEADER_SLOTS = 7;
    private final int magic;
    private final int majorVersion;
    private final int minorVersion;
    private final int flags;
    private final int resourceCount;
    private final int tableLength;
    private final int locationsSize;
    private final int stringsSize;

    public ImageHeader(int resourceCount, int tableCount, int locationsSize, int stringsSize) {
        this(-889267494, 1, 0, 0, resourceCount, tableCount, locationsSize, stringsSize);
    }

    public ImageHeader(int magic, int majorVersion, int minorVersion, int flags, int resourceCount, int tableLength, int locationsSize, int stringsSize) {
        this.magic = magic;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.flags = flags;
        this.resourceCount = resourceCount;
        this.tableLength = tableLength;
        this.locationsSize = locationsSize;
        this.stringsSize = stringsSize;
    }

    public static int getHeaderSize() {
        return 28;
    }

    static ImageHeader readFrom(IntBuffer buffer) {
        Objects.requireNonNull(buffer);
        if (buffer.capacity() != 7) {
            throw new InternalError("jimage header not the correct size: " + buffer.capacity());
        }
        int magic = buffer.get(0);
        int version = buffer.get(1);
        int majorVersion = version >>> 16;
        int minorVersion = version & 0xFFFF;
        int flags = buffer.get(2);
        int resourceCount = buffer.get(3);
        int tableLength = buffer.get(4);
        int locationsSize = buffer.get(5);
        int stringsSize = buffer.get(6);
        return new ImageHeader(magic, majorVersion, minorVersion, flags, resourceCount, tableLength, locationsSize, stringsSize);
    }

    public void writeTo(ImageStream stream) {
        Objects.requireNonNull(stream);
        stream.ensure(ImageHeader.getHeaderSize());
        this.writeTo(stream.getBuffer());
    }

    public void writeTo(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        buffer.putInt(this.magic);
        buffer.putInt(this.majorVersion << 16 | this.minorVersion);
        buffer.putInt(this.flags);
        buffer.putInt(this.resourceCount);
        buffer.putInt(this.tableLength);
        buffer.putInt(this.locationsSize);
        buffer.putInt(this.stringsSize);
    }

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getResourceCount() {
        return this.resourceCount;
    }

    public int getTableLength() {
        return this.tableLength;
    }

    public int getRedirectSize() {
        return this.tableLength * 4;
    }

    public int getOffsetsSize() {
        return this.tableLength * 4;
    }

    public int getLocationsSize() {
        return this.locationsSize;
    }

    public int getStringsSize() {
        return this.stringsSize;
    }

    public int getIndexSize() {
        return ImageHeader.getHeaderSize() + this.getRedirectSize() + this.getOffsetsSize() + this.getLocationsSize() + this.getStringsSize();
    }

    int getRedirectOffset() {
        return ImageHeader.getHeaderSize();
    }

    int getOffsetsOffset() {
        return this.getRedirectOffset() + this.getRedirectSize();
    }

    int getLocationsOffset() {
        return this.getOffsetsOffset() + this.getOffsetsSize();
    }

    int getStringsOffset() {
        return this.getLocationsOffset() + this.getLocationsSize();
    }
}

