/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ast extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_bn = "bengal\u00edn";
        final String metaValue_bo = "tibetanu";
        final String metaValue_el = "griegu";
        final String metaValue_he = "hebr\u00e9u";
        final String metaValue_hy = "armeniu";
        final String metaValue_ja = "xapon\u00e9s";
        final String metaValue_jv = "xavan\u00e9s";
        final String metaValue_ka = "xeorxanu";
        final String metaValue_km = "\u1e25emer";
        final String metaValue_kn = "canar\u00e9s";
        final String metaValue_ko = "coreanu";
        final String metaValue_la = "llat\u00edn";
        final String metaValue_lo = "laosianu";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmanu";
        final String metaValue_or = "oriya";
        final String metaValue_si = "cingal\u00e9s";
        final String metaValue_su = "sondan\u00e9s";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailand\u00e9s";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balin\u00e9s";
        final String metaValue_got = "g\u00f3ticu";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_peo = "persa antiguu";
        final String metaValue_phn = "feniciu";
        final String metaValue_saz = "saurashtra";
        final String metaValue_ssy = "saho";
        final String metaValue_syr = "siriacu";
        final String metaValue_uga = "ugar\u00edticu";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "colonianu" },
            { "Ogam", "ogham" },
            { "mwl", "mirand\u00e9s" },
            { "Zsym", "s\u00edmbolos" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "type.nu.lanatham", "numberaci\u00f3n Tai Tham Tham" },
            { "egl", "emilianu" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "dialectu gniva/njiva" },
            { "xmf", "mingrelianu" },
            { "egy", "exipciu antiguu" },
            { "raj", "rajasthan\u00edn" },
            { "Phag", "escritura \u2018Phags-pa" },
            { "tem", "timne" },
            { "type.nu.sind", "n\u00famberos Khudawadi" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "terena" },
            { "AC", "Islla Ascensi\u00f3n" },
            { "rar", "rarotonganu" },
            { "tet", "tetum" },
            { "%%BARLA", "grupu dialectal barlavento del cabuverdianu" },
            { "type.nu.sinh", "n\u00famberos Lith cingaleses" },
            { "AD", "Andorra" },
            { "AE", "Emiratos \u00c1rabes Xun\u00edos" },
            { "nl_BE", "flamencu" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua y Barbuda" },
            { "type.nu.mroo", "n\u00famberos mro" },
            { "type.ca.ethiopic", "calendariu et\u00edope" },
            { "glk", "gilaki" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "L\u2019Ant\u00e1rtida" },
            { "AR", "Arxentina" },
            { "Prti", "partu d\u2019inscripciones" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "ingl\u00e9s d\u2019Estaos Xun\u00edos" },
            { "AX", "Islles Aland" },
            { "mye", "myene" },
            { "AZ", "Azerbaix\u00e1n" },
            { "%%AREVELA", "armeniu oriental" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuanu" },
            { "BD", "Bangladex" },
            { "kum", "kumyk" },
            { "BE", "B\u00e9lxica" },
            { "gmh", "altualem\u00e1n mediu" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulgaria" },
            { "BH", "Ba\u1e25r\u00e9in" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "San Bartolom\u00e9" },
            { "BM", "Les Bermudes" },
            { "kut", "kutenai" },
            { "myv", "erzya" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe neerland\u00e9s" },
            { "BR", "Brasil" },
            { "BS", "Les Bahames" },
            { "xog", "soga" },
            { "BT", "But\u00e1n" },
            { "BV", "Islla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belize" },
            { "Visp", "fala visible" },
            { "type.ca.persian", "calendariu persa" },
            { "type.nu.hebr", "n\u00famberos hebreos" },
            { "CA", "Canad\u00e1" },
            { "CC", "Islles Cocos (Keeling)" },
            { "mzn", "mazanderani" },
            { "CD", "Congu - Kinxasa" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Congu - Brazzaville" },
            { "CH", "Suiza" },
            { "CI", "Costa de Marfil" },
            { "CK", "Islles Cook" },
            { "CL", "Chile" },
            { "Kthi", "kaithi" },
            { "CM", "Camer\u00fan" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Islla Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabu Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Islla Christmas" },
            { "CY", "Xipre" },
            { "type.nu.bali", "n\u00famberos balineses" },
            { "CZ", "Chequia" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "pau cin hau" },
            { "vls", "flamencu occidental" },
            { "%%RIGIK", "volap\u00fck cl\u00e1sicu" },
            { "DE", "Alema\u00f1a" },
            { "goh", "altualem\u00e1n antiguu" },
            { "ace", "achin\u00e9s" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "goan konkani" },
            { "type.nu.deva", "n\u00famberos devanagari" },
            { "DJ", "Xibuti" },
            { "DK", "Dinamarca" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "n\u00famberos armenios en min\u00fascules" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "franconianu del Main" },
            { "Mtei", "meitei mayek" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri" },
            { "DZ", "Arxelia" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta y Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiv" },
            { "EG", "Exiptu" },
            { "EH", "S\u00e1\u1e25ara Occidental" },
            { "chg", "chagatai" },
            { "pau", "palauanu" },
            { "chk", "chuuk\u00e9s" },
            { "chn", "x\u00edriga chinook" },
            { "chm", "mari" },
            { "chp", "chipewyanu" },
            { "cho", "choctaw" },
            { "type.nu.mathbold", "n\u00famberos matem\u00e1ticos en negrina" },
            { "chr", "cheroqui" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Xuni\u00f3n Europea" },
            { "elx", "elamita" },
            { "type.ca.gregorian", "calendariu gregorianu" },
            { "EZ", "Eurozona" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "n\u00famberos gujarati" },
            { "Inds", "indus" },
            { "ady", "adyghe" },
            { "aeb", "\u00e1rabe de T\u00fanez" },
            { "FI", "Finlandia" },
            { "FJ", "Islles Fixi" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Islles Feroe" },
            { "Taml", metaValue_ta },
            { "FR", "Francia" },
            { "Kpel", metaValue_kpe },
            { "pcd", "p\u00edcaru" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "%%DAJNKO", "alfabetu dajnko" },
            { "type.ca.indian", "calendariu nacional indiu" },
            { "rgn", "roma\u00f1ol" },
            { "grc", "griegu antiguu" },
            { "GA", "Gab\u00f3n" },
            { "tkr", "tsakhur" },
            { "vot", "v\u00f3ticu" },
            { "GB", "Reinu Xun\u00edu" },
            { "pcm", "nixerianu simplific\u00e1u" },
            { "GD", "Granada" },
            { "GE", "Xeorxa" },
            { "GF", "Guyana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Xibraltar" },
            { "afh", "afrihili" },
            { "GL", "Groenlandia" },
            { "enm", "ingl\u00e9s mediu" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islles Xeorxa del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "alem\u00e1n de Pennsylvania" },
            { "type.nu.mathmono", "n\u00famberos matem\u00e1ticos monoespaciaos" },
            { "GW", "Guinea-Bis\u00e1u" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "tai lue nuevu" },
            { "GY", "Guyana" },
            { "ckb", "kurdu central" },
            { "zxx", "ensin conten\u00edu lling\u00fc\u00edsticu" },
            { "Jurc", "jurchen" },
            { "tly", "talix\u00edn" },
            { "pdt", "plautdietsch" },
            { "de_AT", "alem\u00e1n d\u2019Austria" },
            { "Vaii", metaValue_vai },
            { "HK", "ARE China de \u1e24ong Kong" },
            { "HM", "Islles Heard y McDonald" },
            { "HN", "Hondures" },
            { "HR", "Croacia" },
            { "agq", "aghem" },
            { "gsw", "alem\u00e1n de Suiza" },
            { "type.ca.islamic-umalqura", "calendariu isl\u00e1micu (Umm al-Qura)" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "rif", "rifianu" },
            { "tmh", "tamashek" },
            { "IC", "Islles Canaries" },
            { "nan", "chinu min nan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "Adlm", "adlm" },
            { "type.nu.kali", "n\u00famberos Kayah Li" },
            { "IE", "Irlanda" },
            { "nap", "napolitanu" },
            { "%%NDYUKA", "dialectu ndyuka" },
            { "naq", "nama" },
            { "type.nu.sora", "n\u00famberos Sora Sompeng" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabat\u00e9u" },
            { "IM", "Islla de Man" },
            { "IN", "India" },
            { "type.co.eor", "regles d\u2019ordenamientu europees" },
            { "IO", "Territoriu Brit\u00e1nicu del Oc\u00e9anu \u00cdndicu" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "Zmth", "escritura matem\u00e1tica" },
            { "type.nu.thai", "n\u00famberos tailandeses" },
            { "vro", "voro" },
            { "guc", "wayuu" },
            { "%%POSIX", "ordenador" },
            { "type.nu.beng", "n\u00famberos bengalinos" },
            { "pfl", "alem\u00e1n palatinu" },
            { "type.nu.cyrl", "n\u00famberos cir\u00edlicos" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendariu isl\u00e1micu" },
            { "Beng", metaValue_bn },
            { "JM", "Xamaica" },
            { "%%EKAVSK", "serbiu con pronunciaci\u00f3n ekaviana" },
            { "JO", "Xordania" },
            { "gur", "frafra" },
            { "JP", "Xap\u00f3n" },
            { "%%1606NICT", "\u00faltimu franc\u00e9s mediu fasta 1606" },
            { "ain", "ainu" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "tonga nyasa" },
            { "type.nu.knda", "numberaci\u00f3n kannada" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "de_CH", "altualem\u00e1n de Suiza" },
            { "izh", "ingrianu" },
            { "type.ca.buddhist", "calendariu budista" },
            { "KE", "Kenia" },
            { "419", "Am\u00e9rica Llatina" },
            { "KG", "Kirguist\u00e1n" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Les Comores" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts y Nevis" },
            { "Zinh", "hered\u00e1u" },
            { "fr_CA", "franc\u00e9s de Canad\u00e1" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "Plrd", "fon\u00e9ticu de Pollard" },
            { "fr_CH", "franc\u00e9s de Suiza" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Islles Caim\u00e1n" },
            { "KZ", "Kazakst\u00e1n" },
            { "Cyrl", "cir\u00edlicu" },
            { "LA", "Laos" },
            { "LB", "L\u00edbanu" },
            { "phn", metaValue_phn },
            { "LC", "Santa Lluc\u00eda" },
            { "Cyrs", "eslav\u00f3nicu cir\u00edlicu eclesi\u00e1sticu antiguu" },
            { "gwi", "gwich\u02bcin" },
            { "nds", "baxu alem\u00e1n" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "acadianu" },
            { "cop", "c\u00f3pticu" },
            { "LR", "Liberia" },
            { "esu", "yupik central" },
            { "LS", "Lesothu" },
            { "Phlv", "pahlavi de llibros" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgu" },
            { "LV", "Letonia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "lah", "lahnda" },
            { "Mahj", "mahajani" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marruecos" },
            { "MC", "M\u00f3nacu" },
            { "MD", "Moldavia" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegru" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Islles Marshall" },
            { "ale", "aleut" },
            { "type.nu.vaii", "n\u00famberos vai" },
            { "type.nu.mathdbl", "n\u00famberos matem\u00e1ticos con trazu doble" },
            { "ML", "Mal\u00ed" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "ARE China de Mac\u00e1u" },
            { "aln", "gheg d\u2019Albania" },
            { "MP", "Islles Marianes del Norte" },
            { "MQ", "La Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "cps", "capiznon" },
            { "MU", "Mauriciu" },
            { "alt", "altai del sur" },
            { "MV", "Les Maldives" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xicu" },
            { "type.ca.japanese", "calendariu xapon\u00e9s" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "Phli", "pahlavi d\u2019inscripciones" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "calendariu hebr\u00e9u" },
            { "type.co.dictionary", "orde de clasificaci\u00f3n de diccionariu" },
            { "NC", "Nueva Caledonia" },
            { "%%WADEGILE", "romanizaci\u00f3n de Wade-Giles" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "ortograf\u00eda unificada revisada" },
            { "NE", "El N\u00edxer" },
            { "NF", "Islla Norfolk" },
            { "NG", "Nixeria" },
            { "trv", "taroko" },
            { "Phlp", "pahlavi de salteriu" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Pa\u00edses Baxos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakoniu" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nueva Zelanda" },
            { "Merc", "mero\u00edticu en cursiva" },
            { "%%COLB1945", "convenci\u00f3n ortogr\u00e1fica brasilanu-portuguesa de 1945" },
            { "rom", "roman\u00ed" },
            { "Mero", "mero\u00edticu" },
            { "crh", "turcu de Crimea" },
            { "ang", "ingl\u00e9s antiguu" },
            { "OM", "Om\u00e1n" },
            { "anp", "angika" },
            { "crs", "franc\u00e9s criollu seselwa" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "n\u00famberos Pahawh Hmong" },
            { "PA", "Panam\u00e1" },
            { "type.ca.islamic-civil", "calendariu isl\u00e1micu (tabular, \u00e9poca civil)" },
            { "csb", "kashubianu" },
            { "en_GB", "ingl\u00e9s de Gran Breta\u00f1a" },
            { "PE", "Per\u00fa" },
            { "ttt", "tati musulm\u00e1n" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Pap\u00faa Nueva Guinea" },
            { "PH", "Filipines" },
            { "PK", "Paquist\u00e1n" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre y Miquelon" },
            { "PN", "Islles Pitcairn" },
            { "PR", "Puertu Ricu" },
            { "Bali", metaValue_ban },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Pal\u00e1u" },
            { "nia", "nias" },
            { "type.nu.greklow", "n\u00famberos griegos en min\u00fascules" },
            { "PY", "Paragu\u00e1i" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "ingl\u00e9s est\u00e1ndar escoc\u00e9s" },
            { "jam", "ingl\u00e9s criollu xamaicanu" },
            { "pms", "piamont\u00e9s" },
            { "niu", "niueanu" },
            { "QO", "Ocean\u00eda esterior" },
            { "ext", "estreme\u00f1u" },
            { "lez", "lezghianu" },
            { "type.nu.ahom", "n\u00famberos ahom" },
            { "%%FONUPA", "fon\u00e9tica UPA" },
            { "type.nu.takr", "n\u00famberos takri" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "grupu dialectal sotavento del cabuverdianu" },
            { "001", "Mundu" },
            { "002", "\u00c1frica" },
            { "njo", "ao naga" },
            { "003", "Norteam\u00e9rica" },
            { "RE", "Reuni\u00f3n" },
            { "005", "Am\u00e9rica del Sur" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "p\u00f3nticu" },
            { "Rjng", "rejang" },
            { "009", "Ocean\u00eda" },
            { "RO", "Ruman\u00eda" },
            { "RS", "Serbia" },
            { "Mroo", "mro" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "numberaci\u00f3n Tai Lue nueva" },
            { "%%METELKO", "alfabetu metelko" },
            { "Ugar", metaValue_uga },
            { "Mani", "maniqu\u00e9u" },
            { "Khar", "kharoshthi" },
            { "SA", "Arabia Saudita" },
            { "pon", "pohnpeianu" },
            { "Mand", "mand\u00e9u" },
            { "SB", "Islles Salom\u00f3n" },
            { "twq", "tasawaq" },
            { "011", "\u00c1frica Occidental" },
            { "SC", "Les Seixeles" },
            { "SD", "Sud\u00e1n" },
            { "013", "Am\u00e9rica Central" },
            { "SE", "Suecia" },
            { "014", "\u00c1frica Oriental" },
            { "arc", "aram\u00e9u" },
            { "Loma", "loma" },
            { "015", "\u00c1frica del Norte" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "type.lb.strict", "saltu de llinia estrictu" },
            { "017", "\u00c1frica Central" },
            { "SI", "Eslovenia" },
            { "type.nu.mymrtlng", "n\u00famberos Tai Laing de Myanmar" },
            { "018", "\u00c1frica del Sur" },
            { "SJ", "Svalbard ya Islla Jan Mayen" },
            { "019", "Am\u00e9rica" },
            { "SK", "Eslovaquia" },
            { "Bamu", "bamum" },
            { "Wole", "woleai" },
            { "SL", "Sierra Lleona" },
            { "SM", "San Mar\u00edn" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "type.nu.taml", "n\u00famberos tamil tradicionales" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Sud\u00e1n del Sur" },
            { "ST", "Santu Tom\u00e9 y Pr\u00edncipe" },
            { "arq", "\u00e1rabe d\u2019Arxelia" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "yao", "yao" },
            { "SZ", "Suazilandia" },
            { "arw", "arawak" },
            { "arz", "\u00e1rabe d\u2019Exiptu" },
            { "ary", "\u00e1rabe de Marruecos" },
            { "yap", "yap\u00e9s" },
            { "rtm", "rotumanu" },
            { "TA", "Trist\u00e1n da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "sistema de midida d\u2019EE.XX." },
            { "021", "Am\u00e9rica del Norte" },
            { "TC", "Islles Turques y Caicos" },
            { "yav", "yangben" },
            { "TD", "Chad" },
            { "TF", "Tierres Australes Franceses" },
            { "ase", "llingua de signos americana" },
            { "TG", "Togu" },
            { "TH", "Tailandia" },
            { "TJ", "Taxiquist\u00e1n" },
            { "029", "Caribe" },
            { "TK", "Tokel\u00e1u" },
            { "TL", "Timor Oriental" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "gueta por consonante Hangul d\u2019aniciu" },
            { "TM", "Turkmenist\u00e1n" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunicia" },
            { "TO", "Tonga" },
            { "%%NULIK", "volap\u00fck modernu" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinid\u00e1 y Tobagu" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "ast", "asturianu" },
            { "rue", "rusyn" },
            { "rug", "roviana" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "escritura desconocida" },
            { "Sind", "khudabadi" },
            { "UA", "Ucra\u00edna" },
            { "lij", "ligurianu" },
            { "rup", "aromanianu" },
            { "030", "Asia Oriental" },
            { "tyv", "tuvinianu" },
            { "sw_CD", "sua\u1e25ili del Congu" },
            { "034", "Asia del Sur" },
            { "hai", "haida" },
            { "035", "Sureste Asi\u00e1ticu" },
            { "UG", "Uganda" },
            { "hak", "chinu hakka" },
            { "type.co.pinyin", "orde de clasificaci\u00f3n pinyin" },
            { "039", "Europa del Sur" },
            { "Sinh", metaValue_si },
            { "UM", "Islles Perif\u00e9riques Menores de los EE.XX." },
            { "liv", "livonianu" },
            { "UN", "Naciones Xun\u00edes" },
            { "US", "Estaos Xun\u00edos" },
            { "haw", "hawaianu" },
            { "%%1959ACAD", "acad\u00e9micu" },
            { "type.co.gb2312han", "orde de clasificaci\u00f3n chinu simplific\u00e1u - GB2312" },
            { "UY", "Urugu\u00e1i" },
            { "prg", "prusianu" },
            { "UZ", "Uzbequist\u00e1n" },
            { "tzm", "tamazight del Atles central" },
            { "type.co.stroke", "orde de clasificaci\u00f3n pol trazu" },
            { "nnh", "ngiemboon" },
            { "VA", "Ciud\u00e1 del Vaticanu" },
            { "pro", "provenzal antiguu" },
            { "VC", "San Vicente y Granadines" },
            { "VE", "Venezuela" },
            { "VG", "Islles V\u00edrxenes Brit\u00e1niques" },
            { "VI", "Islles V\u00edrxenes Americanes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "Marc", "marc" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "noruegu antiguu" },
            { "053", "Australasia" },
            { "%%AREVMDA", "armeniu occidental" },
            { "054", "Melanesia" },
            { "WF", "Wallis y Futuna" },
            { "type.co.traditional", "orde de clasificaci\u00f3n tradicional" },
            { "057", "Rex\u00f3n de Micronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "avk", "kotava" },
            { "%%HEPBURN", "romanizaci\u00f3n de Hepburn" },
            { "type.co.compat", "orde de clasificaci\u00f3n anterior, por compatibilid\u00e1" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "type.nu.mtei", "n\u00famberos Meetei Mayek" },
            { "wal", "wolaytta" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polinesia" },
            { "%%KSCOR", "ortograf\u00eda est\u00e1ndar" },
            { "XK", "Kosovu" },
            { "type.nu.brah", "n\u00famberos brahmi" },
            { "Gujr", "guyarati" },
            { "Zxxx", "non escritu" },
            { "Olck", "ol chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", "s\u00edmbolos de Bliss" },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "orde de clasificaci\u00f3n est\u00e1ndar" },
            { "lmo", "lombardu" },
            { "fan", "fang" },
            { "%%BALANKA", "dialectu balanka del anii" },
            { "%%ROZAJ", "resianu" },
            { "fat", "fanti" },
            { "Sgnw", "escritura de signos" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "n\u00famberos cham" },
            { "ZA", "Sud\u00e1frica" },
            { "type.nu.sund", "n\u00famberos sondaneses" },
            { "type.lb.loose", "saltu de llinia relax\u00e1u" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "n\u00famberos xeorxanos" },
            { "type.co.zhuyin", "orde de clasificaci\u00f3n zhuyin" },
            { "Hira", "\u1e25iragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "romanizaci\u00f3n pinyin" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Rex\u00f3n desconocida" },
            { "Runr", "runes" },
            { "type.ms.metric", "sistema m\u00e9tricu" },
            { "type.ca.iso8601", "calendariu ISO-8601" },
            { "lol", "mongo" },
            { "nso", "sotho del norte" },
            { "type.nu.telu", "n\u00famberos telugu" },
            { "loz", "lozi" },
            { "Nkgb", "geba del naxi" },
            { "jmc", "machame" },
            { "hif", "hindi de Fiji" },
            { "type.nu.hansfin", "n\u00famberos chinos financieros simplificaos" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "n\u00famberos ar\u00e1bico-\u00edndicos estend\u00edos" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "n\u00famberos n\u2019anchu completu" },
            { "hit", "hitita" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "xerogl\u00edficos mayes" },
            { "lrc", "luri del norte" },
            { "type.co.emoji", "orde de clasificaci\u00f3n Emoji" },
            { "Copt", "coptu" },
            { "nwc", "newari cl\u00e1sicu" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "calendariu isl\u00e1micu (Arabia Saudita, visual)" },
            { "Limb", "limbu" },
            { "sad", "sandav\u00e9s" },
            { "type.nu.roman", "n\u00famberos romanos" },
            { "sah", "sakha" },
            { "type.nu.shrd", "n\u00famberos sharada" },
            { "ltg", "latgalianu" },
            { "sam", "aram\u00e9u samaritanu" },
            { "Aghb", "c\u00e1ucaso-alban\u00e9s" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "xudeo-persa" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "dialectu aluku" },
            { "lua", "luba-lulua" },
            { "type.nu.tirh", "n\u00famberos tirhuta" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filip\u00edn" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "mizo" },
            { "bal", "baluchi" },
            { "den", "slave" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "type.nu.wara", "n\u00famberos Warang Citi" },
            { "fit", "finland\u00e9s de Tornedalen" },
            { "luy", "luyia" },
            { "bar", "b\u00e1varu" },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "%%ABL1943", "formulaci\u00f3n ortogr\u00e1fica de 1943" },
            { "jrb", "xudeo-\u00e1rabe" },
            { "es_ES", "espa\u00f1ol europ\u00e9u" },
            { "nzi", "nzima" },
            { "sco", "scots" },
            { "scn", "sicilianu" },
            { "aa", "afar" },
            { "ab", "abkhazianu" },
            { "bbc", "batak toba" },
            { "ae", "avestan\u00edn" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "type.nu.cakm", "n\u00famberos chakma" },
            { "bbj", "ghomala" },
            { "am", "amh\u00e1ricu" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00e9s" },
            { "%%SOLBA", "dialectu stolvizza/solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "silabarios xaponeses" },
            { "as", "asam\u00e9s" },
            { "sdc", "sardu sassar\u00e9s" },
            { "Lina", "llinial A" },
            { "av", "av\u00e1ricu" },
            { "Linb", "llinial B" },
            { "sdh", "kurdu del sur" },
            { "ay", "aymara" },
            { "az", "azerbaixanu" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "dialectu oseacco/osojane" },
            { "%%UNIFON", "alfabetu fon\u00e9ticu Unifon" },
            { "ba", "bashkir" },
            { "type.co.unihan", "orde de clasificaci\u00f3n por radical y trazu" },
            { "be", "bielorrusu" },
            { "bg", "b\u00falgaru" },
            { "bi", "bislama" },
            { "type.nu.java", "n\u00famberos xavanesos" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bret\u00f3n" },
            { "bs", "bosniu" },
            { "Bhks", "bhks" },
            { "see", "s\u00e9neca" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "type.nu.laoo", "n\u00famberos laosianos" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "catal\u00e1n" },
            { "ses", "koyraboro senni" },
            { "ce", "chechenu" },
            { "ch", "chamorro" },
            { "%%REVISED", "ortograf\u00eda revisada" },
            { "co", "corsu" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "checu" },
            { "cu", "esl\u00e1vicu eclesi\u00e1sticu" },
            { "yrl", "nheengatu" },
            { "cv", "chuvash" },
            { "cy", "gal\u00e9s" },
            { "type.nu.ethi", "n\u00famberos et\u00edopes" },
            { "Yiii", "yi" },
            { "da", "dan\u00e9s" },
            { "pt_PT", "portugu\u00e9s europ\u00e9u" },
            { "de", "alem\u00e1n" },
            { "type.cf.standard", "formatu monetariu est\u00e1ndar" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "jut", "jutland\u00e9s" },
            { "Bugi", "lontara" },
            { "bem", "bemba" },
            { "sga", "irland\u00e9s antiguu" },
            { "type.nu.mong", "n\u00famberos mongoles" },
            { "dv", "divehi" },
            { "es_419", "espa\u00f1ol d\u2019Am\u00e9rica Llatina" },
            { "bew", "betawi" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "calendariu chinu" },
            { "lzh", "chinu lliterariu" },
            { "Lisu", "alfabetu de Fraser" },
            { "dje", "zarma" },
            { "sgs", "samogitianu" },
            { "type.nu.grek", "n\u00famberos griegos" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "saltu de llinia normal" },
            { "ro_MD", "moldavu" },
            { "el", metaValue_el },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "laz" },
            { "type.co.big5han", "orde de clasificaci\u00f3n chinu tradicional - Big5" },
            { "es", "espa\u00f1ol" },
            { "et", "estoniu" },
            { "Hanb", "hanb" },
            { "eu", "vascu" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritanu" },
            { "shi", "tachelhit" },
            { "hsb", "altu sorbiu" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanun\u00f3\u2019o" },
            { "fa", "persa" },
            { "Hans", "simplific\u00e1u" },
            { "type.nu.latn", "n\u00famberos occidentales" },
            { "Hant", "tradicional" },
            { "ff", "fulah" },
            { "shu", "\u00e1rabe chadianu" },
            { "hsn", "chinu xiang" },
            { "fi", "finland\u00e9s" },
            { "fj", "fixanu" },
            { "fon", "fon" },
            { "bgn", "balochi occidental" },
            { "yue", "canton\u00e9s" },
            { "fo", "fero\u00e9s" },
            { "umb", "umbundu" },
            { "fr", "franc\u00e9s" },
            { "sid", "sidamo" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9licu escoc\u00e9s" },
            { "gl", "gallegu" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhojpuri" },
            { "und", "llingua desconocida" },
            { "type.ca.ethiopic-amete-alem", "calendariu et\u00edope Amete Alem" },
            { "gu", "guyarat\u00ed" },
            { "type.ca.islamic-tbla", "calendariu isl\u00e1micu (tabular, \u00e9poca astron\u00f3mica)" },
            { "gv", "man\u00e9s" },
            { "type.nu.osma", "n\u00famberos osmanya" },
            { "ha", "\u1e25ausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitianu" },
            { "hu", "h\u00fangaru" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "franc\u00e9s cajun" },
            { "%%FONIPA", "fon\u00e9tica IPA" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesiu" },
            { "type.nu.tibt", "n\u00famberos tibetanos" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichu\u00e1n" },
            { "frm", "franc\u00e9s mediu" },
            { "%%AO1990", "alcuerdu ortogr\u00e1ficu de 1990 pa la llingua portuguesa" },
            { "ik", "inupiaq" },
            { "fro", "franc\u00e9s antiguu" },
            { "frp", "arpitanu" },
            { "io", "ido" },
            { "frs", "fris\u00f3n oriental" },
            { "bjn", "banjar" },
            { "frr", "fris\u00f3n del norte" },
            { "is", "island\u00e9s" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "sli", "baxu silesianu" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u00e1rabe del sur antiguu" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar\u00e9s" },
            { "type.nu.lepc", "n\u00famberos lepcha" },
            { "bkm", "kom" },
            { "sma", "sami del sur" },
            { "jv", metaValue_jv },
            { "Shaw", "shavianu" },
            { "mad", "madur\u00e9s" },
            { "smj", "lule sami" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inari sami" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "chinu wu" },
            { "sms", "skolt sami" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "mas\u00e1i" },
            { "kj", "kuanyama" },
            { "kk", "kazaquistan\u00edn" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cachemir\u00e9s" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", "av\u00e9sticu" },
            { "ku", "curdu" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnicu" },
            { "ky", "kirguistan\u00edn" },
            { "snk", "soninke" },
            { "Mult", "multani" },
            { "la", metaValue_la },
            { "Hatr", "hatranu" },
            { "lb", "luxemburgu\u00e9s" },
            { "type.nu.mlym", "n\u00famberos malayalam" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgu\u00e9s" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulianu" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "sistema de midida imperial" },
            { "type.nu.lana", "numberaci\u00f3n Tai Tham Hora" },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "sog", "sogdianu" },
            { "mg", "malgaxe" },
            { "mh", "marshall\u00e9s" },
            { "type.co.ducet", "orde de clasificaci\u00f3n Unicode predetermin\u00e1u" },
            { "mi", "maor\u00ed" },
            { "mk", "macedoniu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayu" },
            { "mt", "malt\u00e9s" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "baxu sorbiu" },
            { "Armi", "aramaicu imperial" },
            { "na", "nauru" },
            { "type.co.search", "gueta xeneral" },
            { "nb", "noruegu Bokm\u00e5l" },
            { "nd", "ndebele del norte" },
            { "ne", "nepal\u00e9s" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "neerland\u00e9s" },
            { "nn", "noruegu Nynorsk" },
            { "no", "noruegu" },
            { "nr", "ndebele del sur" },
            { "type.nu.modi", "n\u00famberos modi" },
            { "Osge", "osge" },
            { "nv", "navajo" },
            { "kaa", "kara-kalpak" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabile\u00f1u" },
            { "%%POLYTON", "polit\u00f3nicu" },
            { "oc", "occitanu" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "ingl\u00e9s modernu primitivu" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "n\u00famberos armenios" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "dusun central" },
            { "or", metaValue_or },
            { "Modi", "modi" },
            { "os", "os\u00e9ticu" },
            { "%%ALALC97", "romanizacion ALA-LC, edicion de 1997" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardianu" },
            { "mfe", "morisyen" },
            { "srn", "sranan tongo" },
            { "pa", "punyab\u00ed" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "el dialectu lipovaz del resianu" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polacu" },
            { "dum", "neerland\u00e9s mediu" },
            { "type.nu.saur", "n\u00famberos saurashtra" },
            { "type.ca.dangi", "calendariu dangi" },
            { "ps", "pashtu" },
            { "pt", "portugu\u00e9s" },
            { "mga", "\u00edrland\u00e9s mediu" },
            { "key.co", "orde de clasificaci\u00f3n" },
            { "pt_BR", "portugu\u00e9s del Brasil" },
            { "%%BOHORIC", "alfabetu bohori\u010d" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "formatu monetariu" },
            { "type.nu.nkoo", "n\u00famberos N\u2019Ko" },
            { "bra", "braj" },
            { "key.ca", "calendariu" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "sistema de 24 hores (0\u201323)" },
            { "type.hc.h24", "sistema de 24 hores (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "brahui" },
            { "type.nu.mymr", "n\u00famberos de Myanmar" },
            { "qu", "quechua" },
            { "zap", "zapoteca" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "stq", "fris\u00f3n de Saterland" },
            { "Ethi", "et\u00edope" },
            { "type.hc.h12", "sistema de 12 hores (1\u201312)" },
            { "type.hc.h11", "sistema de 12 hores (0\u201311)" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "key.cu", "moneda" },
            { "ro", "rumanu" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "n\u00famberos odia" },
            { "type.nu.hanidec", "n\u00famberos decimales chinos" },
            { "ru", "rusu" },
            { "bss", "akoose" },
            { "rw", "kinyarwanda" },
            { "zbl", "simb\u00f3licu Bliss" },
            { "kea", "cabuverdianu" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "ingl\u00e9s d\u2019Australia" },
            { "Dupl", "taquigraf\u00eda Duploy\u00e9" },
            { "sa", "s\u00e1nscritu" },
            { "%%UCCOR", "ortograf\u00eda unificada" },
            { "sc", "sardu" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "sami del norte" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbo-croata" },
            { "ken", "kenyang" },
            { "si", metaValue_si },
            { "sux", "sumeriu" },
            { "sk", "eslovacu" },
            { "sl", "eslovenu" },
            { "Gran", "grantha" },
            { "sm", "samoanu" },
            { "sn", "shona" },
            { "so", "somal\u00edn" },
            { "type.nu.arab", "n\u00famberos ar\u00e1bico-\u00edndicos" },
            { "sq", "albanu" },
            { "sr", "serbiu" },
            { "ss", "swati" },
            { "type.cf.account", "formatu monetariu contable" },
            { "Java", metaValue_jv },
            { "st", "sotho del sur" },
            { "su", metaValue_su },
            { "%%NEDIS", "dialectu natisone" },
            { "sv", "suecu" },
            { "sw", "sua\u1e25ili" },
            { "type.nu.hantfin", "n\u00famberos chinos financieros tradicionales" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "buriat" },
            { "143", "Asia Central" },
            { "te", metaValue_te },
            { "145", "Asia Occidental" },
            { "tg", "taxiquistan\u00edn" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "bug", "bugin\u00e9s" },
            { "kfo", "koro" },
            { "en_CA", "ingl\u00e9s de Canad\u00e1" },
            { "tk", "turcomanu" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganu" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "n\u00famberos xaponeses" },
            { "tr", "turcu" },
            { "ts", "tsonga" },
            { "swb", "comorianu" },
            { "Cakm", "chakma" },
            { "tt", "t\u00e1rtaru" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitianu" },
            { "%%BISKE", "dialectu San Giorgio/Bila" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "type.nu.mathsanb", "n\u00famberos matem\u00e1ticos Sans-Serif en negrina" },
            { "154", "Europa del Norte" },
            { "dzg", "dazaga" },
            { "155", "Europa Occidental" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Ital", "it\u00e1licu antiguu" },
            { "kgp", "kaingang" },
            { "Zyyy", "com\u00fan" },
            { "uk", "ucra\u00edn" },
            { "zea", "zeeland\u00e9s" },
            { "type.ca.coptic", "calendariu coptu" },
            { "ur", "urdu" },
            { "%%1994", "ortograf\u00eda resiana estandarizada" },
            { "xal", "calmuco" },
            { "zen", "zenaga" },
            { "uz", "uzbequistan\u00edn" },
            { "kha", "khasi" },
            { "%%1996", "ortograf\u00eda alemana de 1996" },
            { "nds_NL", "baxu sax\u00f3n" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "calendariu de la Rep\u00fablica de China" },
            { "vi", "vietnam\u00edn" },
            { "kho", "khotan\u00e9s" },
            { "khq", "koyra chiini" },
            { "key.hc", "ciclu horariu (12 o 24)" },
            { "%%TARASK", "ortograf\u00eda taraskievica" },
            { "vo", "volap\u00fck" },
            { "khw", "khowar" },
            { "syc", "siriacu cl\u00e1sicu" },
            { "type.nu.mathsans", "n\u00famberos matem\u00e1ticos Sans-Serif" },
            { "Osma", "osmanya" },
            { "quc", "k\u02bciche\u02bc" },
            { "qug", "quichua del altiplanu de Chimborazo" },
            { "Newa", "newa" },
            { "gaa", "ga" },
            { "wa", "val\u00f3n" },
            { "gag", "gagauz" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "chinu gan" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lidiu" },
            { "Xsux", "cuneiforme sumeriu acadiu" },
            { "wo", "wolof" },
            { "zgh", "tamazight est\u00e1ndar de Marruecos" },
            { "ar_001", "\u00e1rabe est\u00e1ndar modernu" },
            { "Cans", "sil\u00e1bicu unific\u00e1u de los nativos canadienses" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manch\u00fa" },
            { "Latf", "fraktur llat\u00edn" },
            { "szl", "silesianu" },
            { "Hluw", "xerogl\u00edficos anatolios" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "ga\u00e9licu llat\u00edn" },
            { "type.nu.hans", "n\u00famberos chinos simplificaos" },
            { "type.nu.hant", "n\u00famberos chinos tradicionales" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "n\u00famberos romanos en min\u00fascules" },
            { "byn", "blin" },
            { "%%PAMAKA", "dialectu pamaka" },
            { "Lyci", "liciu" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "gbz", "dari zoroastrianu" },
            { "Moon", "tipos Moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "franc\u00e9s modernu primitivu" },
            { "Syrc", metaValue_syr },
            { "yi", "yiddish" },
            { "mos", "mossi" },
            { "Dsrt", "alfabetu Deseret" },
            { "yo", "yoruba" },
            { "es_MX", "espa\u00f1ol de M\u00e9xicu" },
            { "Syrj", "siriacu occidental" },
            { "ota", "turcu otomanu" },
            { "Syre", "siriacu estrangelo" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "cariu" },
            { "kln", "kalenjin" },
            { "zh", "chinu" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "p\u00e9rmicu antiguu" },
            { "key.lb", "estilu de saltu de llinia" },
            { "zu", "zul\u00fa" },
            { "type.co.phonebook", "orde de clasificaci\u00f3n de llista telef\u00f3nica" },
            { "%%MONOTON", "monot\u00f3nicu" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "n\u00famberos financieros xaponeses" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "mrj", "mari occidental" },
            { "Syrn", "siriacu oriental" },
            { "type.nu.mymrshan", "n\u00famberos Shan de Myanmar" },
            { "Elba", "elbasan" },
            { "Narb", "\u00e1rabe del norte antiguu" },
            { "type.nu.olck", "n\u00famberos Ol Chiki" },
            { "type.co.reformed", "orde de clasificaci\u00f3n reform\u00e1u" },
            { "Tglg", metaValue_tl },
            { "Egyd", "dem\u00f3ticu exipcianu" },
            { "Egyh", "hier\u00e1ticu exipcianu" },
            { "Palm", "palmirenu" },
            { "ebu", "emb\u00fa" },
            { "Egyp", "xerogl\u00edficos exipcianos" },
            { "Geok", "khutsuri xeorxanu" },
            { "zh_Hans", "chinu simplific\u00e1u" },
            { "koi", "komi-permyak" },
            { "Hung", "h\u00fangaru antiguu" },
            { "kok", "konkani" },
            { "%%1901", "ortograf\u00eda alemana tradicional" },
            { "kos", "kosraeanu" },
            { "vec", "venecianu" },
            { "type.nu.limb", "n\u00famberos limbu" },
            { "zh_Hant", "chinu tradicional" },
            { "Sund", metaValue_su },
            { "vep", "vepsiu" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "numberaci\u00f3n khmer" },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valencianu" },
            { "Cprt", "xipriota" },
            { "%%BAKU1926", "alfabetu turcu llatino unific\u00e1u" },
            { "%%IJEKAVSK", "serbiu con pronunciaci\u00f3n Ijekaviana" },
            { "mua", "mundang" },
            { "type.nu.guru", "n\u00famberos gurmukhi" },
            { "mul", "m\u00faltiples lling\u00fces" },
            { "cad", "caddo" },
            { "key.ms", "sistema de midida" },
            { "mus", "creek" },
            { "Glag", "glagol\u00edticu" },
            { "gil", "gilbert\u00e9s" },
            { "%%KKCOR", "ortograf\u00eda com\u00fan" },
            { "Cher", "cheroki" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "n\u00famberos tamil" },
            { "krc", "karachay-balkar" },
            { "inh", "ingush" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "krl", "karelianu" },
            { "%%OXENDICT", "ortograf\u00eda del diccionariu d\u2019ingl\u00e9s d\u2019Oxford" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "key.nu", "n\u00famberos" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
