/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_sd_Deva extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u091c\u0928\u0935\u0930\u0940",
               "\u092b\u0930\u0935\u0930\u0940",
               "\u092e\u093e\u0930\u094d\u091a\u0941",
               "\u0905\u092a\u094d\u0930\u0948\u0932",
               "\u092e\u0908",
               "\u091c\u0942\u0928",
               "\u091c\u0941\u0932\u093e\u0908",
               "\u0905\u0917\u0938\u094d\u0924",
               "\u0938\u093f\u0924\u0902\u092c\u0930",
               "\u0905\u0915\u094d\u091f\u0942\u092c\u0930",
               "\u0928\u0935\u0902\u092c\u0930",
               "\u0926\u093f\u0938\u0902\u092c\u0930",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u091c\u0928",
               "\u092b\u0930",
               "\u092e\u093e\u0930\u094d\u091a",
               "\u0905\u092a\u094d\u0930\u0948",
               "\u092e\u0908",
               "\u091c\u0942\u0928",
               "\u091c\u0941",
               "\u0905\u0917",
               "\u0938\u093f\u0924\u0902",
               "\u0905\u0915\u094d\u091f\u0942",
               "\u0928\u0935\u0902",
               "\u0926\u093f\u0938\u0902",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u091c",
               "\u092b\u093c",
               "\u092e",
               "\u0905",
               "\u092e",
               "\u091c\u0942",
               "\u091c\u0941",
               "\u0905",
               "\u0938\u093f",
               "\u0905",
               "\u0928",
               "\u0926",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0906\u0930\u094d\u0924\u0935\u093e\u0930",
               "\u0938\u0942\u092e\u0930",
               "\u092e\u0902\u0917\u0932\u0941",
               "\u092c\u0941\u0927\u0930",
               "\u0935\u093f\u0938\u094d\u092a\u0924",
               "\u091c\u0941\u092e\u0913",
               "\u091b\u0902\u091b\u0930",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u0906\u0930\u094d\u0924",
               "\u0938\u0942",
               "\u092e\u0902\u0917",
               "\u092c\u0941\u0927",
               "\u0935\u093f\u0938",
               "\u091c\u0941\u092e",
               "\u091b\u0902\u091b",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u0906",
               "\u092e",
               "\u092e\u0902",
               "\u092c\u0941",
               "\u0935\u093f",
               "\u0936\u0941",
               "\u091b\u0902",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u092a\u0939\u093f\u0930\u094b\u0902 \u092a\u093e\u0921\u093c\u094b",
               "\u097f\u093f\u092f\u094b \u092a\u093e\u0921\u093c\u094b",
               "\u091f\u093f\u092f\u094b \u092a\u093e\u0921\u093c\u094b",
               "\u091a\u094b\u0925\u094b \u092a\u093e\u0921\u093c\u094b",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "1",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u092e\u0902\u091d\u0902\u0926\u093f \u0915\u093e \u092a\u0939\u093f\u0902\u0930\u094b",
               "\u092e\u0902\u091d\u0902\u0926\u093f \u0915\u094b \u092a\u094b\u090f",
            };
        final String[] metaValue_long_Eras = new String[] {
               "\u092c\u0940\u0938\u0940",
               "\u090f\u0921\u0940",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "a h:mm:ss zzzz",
               "a h:mm:ss z",
               "a h:mm:ss",
               "a h:mm",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, MMMM d, y G",
               "MMMM d, y G",
               "MMM d, y G",
               "M/d/y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, MMMM d, y GGGG",
               "MMMM d, y GGGG",
               "MMM d, y GGGG",
               "M/d/y G",
            };
        final String metaValue_calendarname_gregorian = "\u0917\u094d\u0930\u0947\u0917\u0947\u0930\u093f\u092f\u0928 \u0915\u0932\u0947\u0902\u0921\u0930\u0941";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "islamic.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows",
                new String[] {
                    "\u0906",
                    "\u0938\u0942",
                    "\u092e\u0902",
                    "\u092c\u0941",
                    "\u0935\u093f",
                    "\u0936\u0941",
                    "\u091b\u0902",
                }
            },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "field.zone", "\u0935\u0915\u094d\u0924\u0941 \u091c\u094b \u0926\u093e\u092f\u0930\u094b" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterNames },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_long_Eras },
            { "timezone.regionFormat.standard", "{0} (+0) \u092e\u0905\u092f\u093e\u0930\u0940 \u092d\u0947\u0930\u094b" },
            { "Eras", metaValue_long_Eras },
            { "timezone.gmtZeroFormat", "\u091c\u0940\u090f\u092e\u091f\u0940" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "roc.DayNames", metaValue_DayNames },
            { "standalone.DayAbbreviations",
                new String[] {
                    "\u0906",
                    "\u0938\u0942",
                    "\u092e\u0902",
                    "\u092c\u0941\u0927",
                    "\u0935\u093f\u0938\u094d",
                    "\u091c\u0941\u092e",
                    "\u091b\u0902\u091b",
                }
            },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "long.Eras", metaValue_long_Eras },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "field.weekday", "\u0939\u092b\u094d\u0924\u0947 \u091c\u094b \u097e\u0940\u0902\u0939\u0941" },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} 'at' {0}",
                    "{1} {0}",
                    "{1}, {0}",
                    "{1}, {0}",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.DayNames", metaValue_DayNames },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u097e\u0940\u0902\u0939\u0941/\u0930\u093e\u0924\u0941" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterNames },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterNames },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "field.month", "\u092e\u0939\u0940\u0928\u094b" },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "field.second", "\u0938\u0947\u0915\u093f\u0902\u0921\u0941" },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\u0939\u092b\u094d\u0924\u094b" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMMM y",
                    "d MMMM y",
                    "d MMM y",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames",
                new String[] {
                    "\u0906\u0930\u094d\u0924",
                    "\u0938\u0942",
                    "\u092e\u0902",
                    "\u092c\u0941\u0927",
                    "\u0935\u093f\u0938",
                    "\u091c\u0941\u092e",
                    "\u091b\u0902\u091b",
                }
            },
            { "field.hour", "\u0915\u0932\u093e\u0915" },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "\u091c\u0928",
                    "\u092b\u0930",
                    "\u092e\u093e\u0930\u094d\u091a",
                    "\u0905\u092a\u094d\u0930\u0948",
                    "\u092e\u0908",
                    "\u091c\u0942\u0928",
                    "\u091c\u0941\u0932\u093e",
                    "\u0905\u0917",
                    "\u0938\u093f\u0924\u0902",
                    "\u0905\u0915\u094d\u091f\u0942",
                    "\u0928\u0935\u0902",
                    "\u0926\u093f\u0938\u0902",
                    "",
                }
            },
            { "timezone.regionFormat", "{0} \u092d\u0947\u0930\u094b" },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterNames },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
