/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sg extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "Z\u00e2mani";
        final String metaValue_FR = "Far\u00e2nzi";
        final String metaValue_IN = "\u00cannde";
        final String metaValue_RW = "Ruand\u00e4a";
        final String metaValue_SO = "Somal\u00efi";
        final String metaValue_UA = "Ukr\u00eani";
        final String metaValue_VN = "Vietn\u00e4m";
        final Object[][] data = new Object[][] {
            { "PR", "Porto R\u00eeko" },
            { "PS", "S\u00ease t\u00ee Palest\u00eeni" },
            { "PT", "P\u00f6rtug\u00e4le, K\u00f6d\u00f6r\u00f6 P\u00fbra" },
            { "pt", "Portug\u00ebe, P\u00fbra" },
            { "PW", "Palau" },
            { "PY", "Paragu\u00ebe" },
            { "QA", "Kat\u00e4ra" },
            { "AD", "And\u00f4ro" },
            { "AE", "Ar\u00e2bo Emir\u00e2ti \u00d4ko" },
            { "AF", "Fagan\u00efta, Afgan\u00efst\u00e4an" },
            { "AG", "Ant\u00eegua na Barb\u00fbda" },
            { "AI", "Ang\u00fb\u00eela" },
            { "ak", "Ak\u00e2an" },
            { "AL", "Alban\u00efi" },
            { "AM", "Armen\u00efi" },
            { "am", "Amar\u00eeki" },
            { "AO", "Angol\u00e4a" },
            { "AR", "Arzant\u00eena" },
            { "ar", "Ar\u00e2bo" },
            { "AS", "Sam\u00f6a t\u00ee Amer\u00eeka" },
            { "AT", "Otr\u00eesi" },
            { "RE", "Rein\u00efon" },
            { "AU", "Ostral\u00efi, Sotral\u00efi" },
            { "AW", "Ar\u00fbba" },
            { "AZ", "Zerebaidy\u00e4an, Azerbaidy\u00e4an," },
            { "RO", "Ruman\u00efi" },
            { "ro", "Rum\u00eben" },
            { "BA", "Bosn\u00efi na Herzegov\u00eenni" },
            { "BB", "Barab\u00e2da" },
            { "BD", "Benglad\u00eashi" },
            { "BE", "B\u00ealeze, Belez\u00eeki" },
            { "RU", "Rus\u00efi" },
            { "be", "Biel\u00f6r\u00fbsi" },
            { "ru", "R\u00fbsi" },
            { "BF", "Burkina Faso" },
            { "rw", metaValue_RW },
            { "RW", metaValue_RW },
            { "BG", "Bulugar\u00efi" },
            { "bg", "Bulug\u00e4ri" },
            { "BH", "Bahr\u00e2ina" },
            { "BI", "Burund\u00efi" },
            { "BJ", "Ben\u00eben" },
            { "BM", "Berem\u00fbda" },
            { "BN", "Brun\u00eai" },
            { "bn", "Beng\u00e4li" },
            { "BO", "Boliv\u00efi" },
            { "SA", "Sa\u00fbdi Arab\u00efi" },
            { "SB", "Z\u00fb\u00e2 Salom\u00f6on" },
            { "BR", "Brez\u00eeli" },
            { "SC", "S\u00ebysh\u00eale" },
            { "BS", "Bah\u00e2masa" },
            { "SD", "Sud\u00e4an" },
            { "BT", "But\u00e4an" },
            { "SE", "Su\u00eade" },
            { "SG", "S\u00efng\u00e4p\u00fbru" },
            { "sg", "S\u00e4ng\u00f6" },
            { "BW", "Botswana" },
            { "SH", "S\u00eant-Hel\u00eana" },
            { "SI", "Soloven\u00efi" },
            { "BY", "Belar\u00fcsi" },
            { "BZ", "Bel\u00eezi" },
            { "SK", "Solovak\u00efi" },
            { "SL", "Sier\u00e4-Le\u00f4ne" },
            { "SM", "S\u00ean-Mar\u00eben" },
            { "SN", "Seneg\u00e4le" },
            { "so", metaValue_SO },
            { "SO", metaValue_SO },
            { "CA", "Kanad\u00e4a" },
            { "SR", "Surin\u00e4m" },
            { "CD", "K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee Ngunuhal\u00ebzo t\u00ee kong\u00f6" },
            { "ST", "S\u00e2\u00f4 T\u00f6m\u00ea na Prins\u00eepe" },
            { "CF", "K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee B\u00eaafr\u00eeka" },
            { "SV", "Salvad\u00f6ro" },
            { "sv", "Suedu\u00e4a" },
            { "CG", "Kong\u00f6" },
            { "CH", "S\u00fb\u00eesi" },
            { "CI", "K\u00f4div\u00fc\u00e4ra" },
            { "SY", "Sir\u00efi" },
            { "SZ", "Sw\u00e4z\u00efl\u00e2nde" },
            { "CK", "\u00e2z\u00fb\u00e2 K\u00fbku" },
            { "CL", "Shil\u00efi" },
            { "CM", "Kamer\u00fbne" },
            { "CN", "Sh\u00eena" },
            { "CO", "Kolomb\u00efi" },
            { "ta", "T\u00e4m\u00fbli" },
            { "CR", "K\u00f4sta R\u00eeka" },
            { "TC", "\u00c2z\u00fb\u00e2 Turku na Ka\u00eeki" },
            { "TD", "Ty\u00e2de" },
            { "cs", "Ty\u00eaki" },
            { "CU", "Kub\u00e4a" },
            { "CV", "Az\u00fb\u00e2 t\u00ee K\u00e2po-V\u00eare" },
            { "TG", "Tog\u00f6" },
            { "TH", "Tail\u00e2nde" },
            { "th", "Th\u00e2i" },
            { "CY", "S\u00eepri" },
            { "TJ", "Taazikiist\u00e4an" },
            { "CZ", "K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee Ty\u00eaki" },
            { "TK", "Tokelau" },
            { "TL", "Tim\u00f4ro t\u00ee T\u00f6" },
            { "TM", "Turkumenist\u00e4an" },
            { "TN", "Tuniz\u00efi" },
            { "TO", "Tonga" },
            { "TR", "Turuk\u00efi" },
            { "tr", "T\u00fbr\u00fbku" },
            { "TT", "Trinit\u00f9ee na Tobag\u00f6" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "TV", "T\u00fcval\u00fc" },
            { "TW", "T\u00e2iw\u00e2ni" },
            { "DJ", "Dibut\u00f9ii" },
            { "TZ", "Tanzan\u00efi" },
            { "DK", "Danem\u00earke" },
            { "DM", "D\u00f6m\u00efn\u00eeka" },
            { "DO", "K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee Domin\u00eeka" },
            { "UA", metaValue_UA },
            { "UG", "Ugand\u00e4a" },
            { "uk", metaValue_UA },
            { "DZ", "Alzer\u00efi" },
            { "ur", "\u00dbrdu" },
            { "EC", "Ekuat\u00ebre" },
            { "US", "\u00c2Leaa-\u00d4ko t\u00ee Amerika" },
            { "EE", "Eston\u00efi" },
            { "EG", "K\u00e2mit\u00e2" },
            { "UY", "Urugu\u00ebe" },
            { "UZ", "Uzbekist\u00e4an" },
            { "el", "Ger\u00eaki" },
            { "en", "Angl\u00ebe" },
            { "VA", "Let\u00ebe t\u00ee Vatik\u00e4an" },
            { "ER", "Eritr\u00ebe" },
            { "VC", "S\u00ean-Vens\u00e4an na \u00e2Grenad\u00eeni" },
            { "ES", "Esp\u00e2nye" },
            { "es", "Espany\u00f6l" },
            { "ET", "Etiop\u00efi" },
            { "VE", "Venezuel\u00e4a" },
            { "VG", "\u00c2z\u00f4\u00e2 Vi\u00eer\u00eeggo t\u00ee Angl\u00ebe" },
            { "vi", metaValue_VN },
            { "VI", "\u00c2z\u00fb\u00e2 Vir\u00eego t\u00ee Amer\u00eeka" },
            { "VN", metaValue_VN },
            { "fa", "Fars\u00ee" },
            { "VU", "Vanuat\u00fc" },
            { "FI", "F\u00ebl\u00e2nde" },
            { "FJ", "Fidy\u00efi" },
            { "FK", "\u00c2z\u00fb\u00e2 t\u00ee M\u00e4l\u00fc\u00eeni" },
            { "FM", "Mikronez\u00efi" },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "WF", "Wal\u00eesi na Futuna" },
            { "GA", "Gab\u00f6on" },
            { "GB", "K\u00f6d\u00f6r\u00f6gb\u00ef\u00e4--\u00d4ko" },
            { "WS", "Samo\u00e4a" },
            { "GD", "Gren\u00e2da" },
            { "GE", "Zorz\u00efi" },
            { "GF", "G\u00fcy\u00e2ni t\u00ee far\u00e2nzi" },
            { "GH", "Gan\u00e4a" },
            { "GI", "Zibralt\u00e4ra, Zibarat\u00e4ra" },
            { "GL", "Gorol\u00e2nde" },
            { "GM", "Gamb\u00efi" },
            { "GN", "Gin\u00ebe" },
            { "GP", "Guadel\u00fbpu" },
            { "GQ", "Gin\u00ebe t\u00ee Ekuat\u00ebre" },
            { "GR", "Ger\u00easi" },
            { "GT", "Guat\u00eam\u00e4l\u00e4" },
            { "GU", "Gu\u00e2m" },
            { "GW", "Gnin\u00ebe-Bisau" },
            { "GY", "Gay\u00e2na" },
            { "ha", "Ha\u00fcs\u00e4" },
            { "hi", "H\u00eendi" },
            { "HN", "Hondur\u00e4si" },
            { "HR", "Kroas\u00efi" },
            { "HT", "Hait\u00efi" },
            { "YE", "Y\u00ebm\u00eani" },
            { "HU", "Hongir\u00f9ii" },
            { "hu", "Hongru\u00e4a" },
            { "yo", "Yoruba" },
            { "ID", "\u00canndonez\u00efi" },
            { "YT", "M\u00e4y\u00f4te" },
            { "id", "Enndonez\u00efi" },
            { "IE", "Irl\u00e2nde" },
            { "ig", "\u00cfgb\u00f6" },
            { "IL", "Isra\u00ebli" },
            { "IN", metaValue_IN },
            { "IO", "S\u00ease t\u00ee Angl\u00ebe na Ng\u00fby\u00e4m\u00e4 t\u00ee \u00cannde" },
            { "ZA", "Mbongo-Afr\u00eeka" },
            { "IQ", "Ir\u00e2ki" },
            { "IR", "Ir\u00e4an" },
            { "IS", "Isl\u00e2nde" },
            { "it", metaValue_IN },
            { "IT", "Ital\u00f9ii" },
            { "zh", "Shinu\u00e4a" },
            { "ZM", "Zamb\u00efi" },
            { "ja", "Zapon\u00ebe" },
            { "zu", "Z\u00fblu" },
            { "ZW", "Zimb\u00e4bwe" },
            { "JM", "Zama\u00eeka" },
            { "JO", "Zordan\u00efi" },
            { "JP", "Zap\u00f6on" },
            { "jv", "Zavan\u00ebe" },
            { "KE", "Keny\u00e4a" },
            { "KG", "Kirigizit\u00f9aan" },
            { "KH", "K\u00e4mb\u00f4zi" },
            { "KI", "Kiribati" },
            { "KM", "K\u00f6m\u00f4ro" },
            { "km", "Km\u00eare" },
            { "KN", "S\u00ean-Kr\u00efst\u00f4fo-na-Nev\u00eesi" },
            { "ko", "Korey\u00eben" },
            { "KP", "Kor\u00ebe t\u00ee Banga" },
            { "KR", "Kor\u00ebe t\u00ee Mbongo" },
            { "KW", "K\u00f6w\u00eati" },
            { "KY", "\u00c2z\u00fb\u00e2 Ngund\u00eb, Kaim\u00e4ni" },
            { "KZ", "Kazakisit\u00e4an" },
            { "LA", "L\u00f9a\u00f4si" },
            { "LB", "Lib\u00f9aan" },
            { "LC", "S\u00eant-Lis\u00efi" },
            { "LI", "Liechtenstein," },
            { "LK", "Sir\u00ee-Lanka" },
            { "LR", "Liber\u00efa" },
            { "LS", "Les\u00f4tho" },
            { "LT", "Lituan\u00efi" },
            { "LU", "Lugzamb\u00fbru" },
            { "LV", "Leton\u00f9ii" },
            { "LY", "Lib\u00efi" },
            { "MA", "Mar\u00f4ko" },
            { "MC", "Monak\u00f6o" },
            { "MD", "Moldav\u00f9ii" },
            { "MG", "Madagask\u00e4ra" },
            { "MH", "\u00c2z\u00fb\u00e2 M\u00e4rsh\u00e2l" },
            { "MK", "Masedu\u00e4ni" },
            { "ML", "Mal\u00efi" },
            { "MM", "My\u00e4m\u00e2ra" },
            { "MN", "Mongol\u00efi" },
            { "MP", "\u00c2z\u00fb\u00e2 M\u00e4r\u00ef\u00e2ni t\u00ee Banga" },
            { "MQ", "M\u00e4rt\u00efn\u00eeki" },
            { "MR", "Moritan\u00efi" },
            { "MS", "Monser\u00e2te" },
            { "ms", "Mal\u00ebe" },
            { "MT", "M\u00e2lta" },
            { "MU", "M\u00f6r\u00eesi" },
            { "MV", "Mald\u00eeva" },
            { "MW", "Malaw\u00efi" },
            { "MX", "Mekis\u00eeki" },
            { "MY", "Malez\u00efi" },
            { "my", "Miam\u00e4ra, Birim\u00e4ni" },
            { "MZ", "M\u00f6z\u00e4mb\u00eeka" },
            { "NA", "Namib\u00f9ii" },
            { "NC", "Fin\u00ee Kaledon\u00efi" },
            { "NE", "Niz\u00ebre" },
            { "ne", "Nepal\u00ebe" },
            { "NF", "Z\u00fb\u00e2 N\u00f4rf\u00f4lko" },
            { "NG", "Nizer\u00efa" },
            { "NI", "Nikaragua" },
            { "NL", "Hol\u00e4nde" },
            { "nl", "Holand\u00ebe" },
            { "NO", "N\u00f6rv\u00eazi" },
            { "NP", "N\u00ebp\u00e2li" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Fin\u00ee Zel\u00e2nde" },
            { "OM", "Om\u00e2ni" },
            { "PA", "Panama" },
            { "pa", "Penz\u00e4b\u00ef" },
            { "PE", "Per\u00fcu" },
            { "PF", "Polinez\u00efi t\u00ee far\u00e2nzi" },
            { "PG", "Pap\u00fb Fin\u00ee Gin\u00ebe, Papuaz\u00efi" },
            { "PH", "Filip\u00eeni" },
            { "PK", "Pakist\u00e4an" },
            { "PL", "P\u00f6l\u00f4ni" },
            { "pl", "Polon\u00ebe" },
            { "PM", "S\u00ean-Py\u00eare na Mikel\u00f6on" },
            { "PN", "Pitik\u00earni" },
        };
        return data;
    }
}
