/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.ui.DefaultEditorUtility;
import org.eclipse.handly.ui.EditorOpener;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.PartListenerAdapter;
import org.eclipse.handly.ui.action.HistoryDropDownAction;
import org.eclipse.handly.ui.callhierarchy.CallHierarchy;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyKind;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyLabelProvider;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyViewManager;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchyNode;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;
import org.eclipse.handly.ui.callhierarchy.LocationTableLabelProvider;
import org.eclipse.handly.ui.callhierarchy.Messages;
import org.eclipse.handly.ui.viewer.ColumnDescription;
import org.eclipse.handly.ui.viewer.DelegatingSelectionProvider;
import org.eclipse.handly.ui.viewer.LabelComparator;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class CallHierarchyViewPart
extends ViewPart {
    protected static final String GROUP_FOCUS = "group.focus";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private static final String KEY_HIERARCHY_KIND = "org.eclipse.handly.callhierarchy.view.kind";
    private static final String KEY_ORIENTATION = "org.eclipse.handly.callhierarchy.view.orientation";
    private static final String KEY_HORIZONTAL_RATIO = "org.eclipse.handly.callhierarchy.view.horizontalRatio";
    private static final String KEY_VERTICAL_RATIO = "org.eclipse.handly.callhierarchy.view.verticalRatio";
    private static final int ORIENTATION_AUTO = 768;
    private final EnumSet<CallHierarchyKind> supportedHierarchyKinds;
    private CallHierarchyKind hierarchyKind;
    private int orientation = 768;
    private boolean orientationAdjusted;
    private int horizontalRatio = 500;
    private int verticalRatio = 500;
    private Object[] inputElements = NO_ELEMENTS;
    private boolean pinned;
    private PageBook pageBook;
    private Control noHierarchyPage;
    private SashForm sashForm;
    private TreeViewer hierarchyViewer;
    private TableViewer locationViewer;
    private EditorOpener editorOpener;
    private final RefreshAction refreshAction = new RefreshAction();
    private final RefreshElementAction refreshElementAction = new RefreshElementAction();
    private final RemoveFromViewAction removeFromViewAction = new RemoveFromViewAction();
    private SetHierarchyKindAction[] setHierarchyKindActions = new SetHierarchyKindAction[0];
    private SetOrientationAction[] setOrientationActions = new SetOrientationAction[]{new SetOrientationAction(512), new SetOrientationAction(256), new SetOrientationAction(768)};
    private final FocusOnSelectionAction focusOnSelectionAction = new FocusOnSelectionAction();
    private HistoryDropDownAction<HistoryEntry> historyDropDownAction;
    private final PinAction pinAction = new PinAction();
    private final IPartListener partListener = new PartListenerAdapter(){

        @Override
        public void partActivated(IWorkbenchPart part) {
            if (part != CallHierarchyViewPart.this) {
                return;
            }
            CallHierarchyViewPart.this.getViewManager().viewOpenedOrActivated(CallHierarchyViewPart.this);
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (part != CallHierarchyViewPart.this) {
                return;
            }
            CallHierarchyViewPart.this.getViewManager().viewClosed(CallHierarchyViewPart.this);
        }

        @Override
        public void partOpened(IWorkbenchPart part) {
            if (part != CallHierarchyViewPart.this) {
                return;
            }
            CallHierarchyViewPart.this.getViewManager().viewOpenedOrActivated(CallHierarchyViewPart.this);
            CallHierarchyViewPart.this.refresh();
        }
    };

    public CallHierarchyViewPart() {
        this(EnumSet.allOf(CallHierarchyKind.class));
    }

    public CallHierarchyViewPart(EnumSet<CallHierarchyKind> supportedHierarchyKinds) {
        if (supportedHierarchyKinds == null) {
            throw new IllegalArgumentException();
        }
        if (supportedHierarchyKinds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.supportedHierarchyKinds = supportedHierarchyKinds.clone();
        this.hierarchyKind = (CallHierarchyKind)((Object)supportedHierarchyKinds.iterator().next());
        this.makeSetHierarchyKindActions();
    }

    private void makeSetHierarchyKindActions() {
        int size = this.supportedHierarchyKinds.size();
        if (size > 1) {
            this.setHierarchyKindActions = new SetHierarchyKindAction[size];
            int i = 0;
            for (CallHierarchyKind kind : this.supportedHierarchyKinds) {
                this.setHierarchyKindActions[i++] = new SetHierarchyKindAction(kind);
            }
            this.setHierarchyKindActions[0].setChecked(true);
        }
    }

    public final boolean arePossibleInputElements(Object[] elements) {
        if (elements == null) {
            return false;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.isPossibleInputElement(element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected abstract boolean isPossibleInputElement(Object var1);

    public void setInputElements(Object[] elements) {
        if (!this.arePossibleInputElements(elements)) {
            throw new IllegalArgumentException(Arrays.toString(elements));
        }
        this.inputElements = elements;
        if (elements.length > 0) {
            this.addHistoryEntry(this.createHistoryEntry(elements));
        }
        this.refresh();
    }

    public final Object[] getInputElements() {
        return this.inputElements;
    }

    public final CallHierarchyKind getHierarchyKind() {
        return this.hierarchyKind;
    }

    public void setHierarchyKind(CallHierarchyKind kind) {
        if (!this.supportsHierarchyKind(kind)) {
            throw new IllegalArgumentException();
        }
        if (kind == this.hierarchyKind) {
            return;
        }
        this.hierarchyKind = kind;
        SetHierarchyKindAction[] setHierarchyKindActionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyKindAction action = setHierarchyKindActionArray[n2];
            action.setChecked(action.kind == kind);
            ++n2;
        }
        this.refresh();
    }

    public final boolean supportsHierarchyKind(CallHierarchyKind kind) {
        return this.supportedHierarchyKinds.contains((Object)kind);
    }

    public void setOrientation(int orientation) {
        if (!CallHierarchyViewPart.supportsOrientation(orientation)) {
            throw new IllegalArgumentException();
        }
        if (orientation == this.orientation) {
            return;
        }
        this.orientation = orientation;
        SetOrientationAction[] setOrientationActionArray = this.setOrientationActions;
        int n = this.setOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetOrientationAction action = setOrientationActionArray[n2];
            action.setChecked(action.orientation == orientation);
            ++n2;
        }
        this.adjustOrientation();
    }

    private static boolean supportsOrientation(int orientation) {
        return orientation == 256 || orientation == 512 || orientation == 768;
    }

    private void adjustOrientation() {
        if (this.sashForm == null || this.sashForm.isDisposed()) {
            return;
        }
        Point size = this.sashForm.getParent().getParent().getSize();
        if (size.x == 0 || size.y == 0) {
            return;
        }
        int orientation = this.orientation;
        if (orientation == 768) {
            int n = orientation = size.x > size.y ? 256 : 512;
        }
        if (this.sashForm.getOrientation() == orientation && this.orientationAdjusted) {
            return;
        }
        if (this.sashForm.getOrientation() != orientation) {
            if (this.orientationAdjusted) {
                this.saveSplitterRatio();
            }
            this.sashForm.setOrientation(orientation);
            this.sashForm.layout();
        }
        this.restoreSplitterRatio();
        this.orientationAdjusted = true;
    }

    private void saveSplitterRatio() {
        int[] weights = this.sashForm.getWeights();
        int ratio = weights[0] * 1000 / (weights[0] + weights[1]);
        if (this.sashForm.getOrientation() == 256) {
            this.horizontalRatio = ratio;
        } else {
            this.verticalRatio = ratio;
        }
    }

    private void restoreSplitterRatio() {
        int ratio = this.sashForm.getOrientation() == 256 ? this.horizontalRatio : this.verticalRatio;
        this.sashForm.setWeights(new int[]{ratio, 1000 - ratio});
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public final boolean isPinned() {
        return this.pinned;
    }

    public final void refresh() {
        this.refresh(Contexts.EMPTY_CONTEXT);
    }

    protected final void refresh(IContext context) {
        if (this.hierarchyViewer == null || this.hierarchyViewer.getControl().isDisposed()) {
            return;
        }
        this.doRefresh(context);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            int value;
            Integer integer;
            String value2;
            if (this.supportedHierarchyKinds.size() > 1 && (value2 = memento.getString(KEY_HIERARCHY_KIND)) != null) {
                CallHierarchyKind kind = null;
                try {
                    kind = CallHierarchyKind.valueOf(value2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (this.supportsHierarchyKind(kind)) {
                    this.setHierarchyKind(kind);
                }
            }
            if ((integer = memento.getInteger(KEY_ORIENTATION)) != null && CallHierarchyViewPart.supportsOrientation(value = integer.intValue())) {
                this.setOrientation(value);
            }
            if ((integer = memento.getInteger(KEY_HORIZONTAL_RATIO)) != null && (value = integer.intValue()) > 0 && value < 1000) {
                this.horizontalRatio = value;
            }
            if ((integer = memento.getInteger(KEY_VERTICAL_RATIO)) != null && (value = integer.intValue()) > 0 && value < 1000) {
                this.verticalRatio = value;
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.supportedHierarchyKinds.size() > 1) {
            memento.putString(KEY_HIERARCHY_KIND, this.hierarchyKind.name());
        }
        memento.putInteger(KEY_ORIENTATION, this.orientation);
        this.saveSplitterRatio();
        memento.putInteger(KEY_HORIZONTAL_RATIO, this.horizontalRatio);
        memento.putInteger(KEY_VERTICAL_RATIO, this.verticalRatio);
    }

    public void createPartControl(Composite parent) {
        SetHierarchyKindAction action;
        this.getSite().getPage().addPartListener(this.partListener);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!CallHierarchyViewPart.this.orientationAdjusted || CallHierarchyViewPart.this.orientation == 768) {
                    CallHierarchyViewPart.this.adjustOrientation();
                }
            }
        });
        this.pageBook = new PageBook(parent, 0);
        this.noHierarchyPage = this.createNoHierarchyPage((Composite)this.pageBook);
        this.sashForm = this.createSashForm((Composite)this.pageBook);
        this.hierarchyViewer = this.createHierarchyViewer((Composite)this.sashForm);
        this.locationViewer = this.createLocationViewer((Composite)this.sashForm);
        this.configureHierarchyViewer(this.hierarchyViewer);
        this.configureLocationViewer(this.locationViewer);
        ConvertingSelectionProvider selectionProvider = new ConvertingSelectionProvider();
        selectionProvider.setDelegate((ISelectionProvider)this.hierarchyViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        selectionProvider.addSelectionChangedListener(e -> this.updateStatusLine(this.getViewSite().getActionBars().getStatusLineManager(), e.getStructuredSelection()));
        this.initContextMenu(this.hierarchyViewer.getControl(), manager -> {
            this.createHierarchyViewerMenuGroups(manager);
            this.fillHierarchyViewerMenu(manager);
        }, this.getSite().getId(), (ISelectionProvider)selectionProvider);
        this.initContextMenu(this.locationViewer.getControl(), manager -> {
            this.createLocationViewerMenuGroups(manager);
            this.fillLocationViewerMenu(manager);
        }, this.getSite().getId() + ".locationViewerMenu", (ISelectionProvider)this.locationViewer);
        new OpenEditorHelper((StructuredViewer)this.hierarchyViewer);
        new OpenEditorHelper((StructuredViewer)this.locationViewer);
        this.hierarchyViewer.addSelectionChangedListener(e -> this.hierarchySelectionChanged(e.getSelection()));
        this.locationViewer.addSelectionChangedListener(e -> this.locationSelectionChanged(e.getSelection()));
        this.editorOpener = this.createEditorOpener();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.focusOnSelectionAction);
        this.addRefreshAction((IAction)this.refreshAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshElementAction);
        this.hierarchyViewer.addSelectionChangedListener((ISelectionChangedListener)this.removeFromViewAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeFromViewAction);
        Action[] actionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.addSetHierarchyKindAction((IAction)action, action.kind);
            ++n2;
        }
        actionArray = this.setOrientationActions;
        n = this.setOrientationActions.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.addSetOrientationAction((IAction)action, ((SetOrientationAction)((Object)action)).orientation);
            ++n2;
        }
        this.historyDropDownAction = this.createHistoryDropDownAction(new HistoryDropDownAction.History<HistoryEntry>(){

            @Override
            public List<HistoryEntry> getHistoryEntries() {
                return CallHierarchyViewPart.this.getHistory();
            }

            @Override
            public void setHistoryEntries(List<HistoryEntry> entries) {
                List<HistoryEntry> history = CallHierarchyViewPart.this.getHistory();
                history.clear();
                history.addAll(entries);
                CallHierarchyViewPart.this.notifyHistoryUpdated();
            }

            @Override
            public HistoryEntry getActiveEntry() {
                Object[] inputElements = CallHierarchyViewPart.this.getInputElements();
                if (inputElements.length == 0) {
                    return null;
                }
                return CallHierarchyViewPart.this.createHistoryEntry(inputElements);
            }

            @Override
            public void setActiveEntry(HistoryEntry entry) {
                CallHierarchyViewPart.this.setInputElements(entry.getInputElements());
            }

            @Override
            public String getLabel(HistoryEntry entry) {
                return entry.getLabel();
            }

            @Override
            public ImageDescriptor getImageDescriptor(HistoryEntry entry) {
                return entry.getImageDescriptor();
            }
        });
        this.historyDropDownAction.setEnabled(!this.getHistory().isEmpty());
        this.addHistoryDropDownAction((IAction)this.historyDropDownAction);
        this.addPinAction((IAction)this.pinAction);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public void setFocus() {
        this.pageBook.setFocus();
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.updateStatusLine(this.getViewSite().getActionBars().getStatusLineManager(), (IStructuredSelection)selection);
        }
    }

    protected abstract CallHierarchyViewManager getViewManager();

    protected ICallHierarchyNode[] getHierarchyRoots() {
        return this.createHierarchyRoots(this.inputElements);
    }

    protected abstract ICallHierarchyNode[] createHierarchyRoots(Object[] var1);

    protected ViewerComparator getHierarchyComparator() {
        if (this.getHierarchyKind() == CallHierarchyKind.CALLER) {
            return new LabelComparator();
        }
        return null;
    }

    protected abstract String computeContentDescription();

    protected void updateStatusLine(IStatusLineManager manager, IStructuredSelection selection) {
        String message = null;
        int size = selection.size();
        if (size > 1) {
            message = MessageFormat.format(Messages.CallHierarchyViewPart_0__items_selected, size);
        }
        manager.setMessage(message);
        manager.setErrorMessage(null);
    }

    protected void doRefresh(IContext context) {
        this.setContentDescription(this.computeContentDescription());
        this.hierarchyViewer.setInput(null);
        this.locationViewer.setInput(null);
        if (this.inputElements.length > 0) {
            this.pageBook.showPage((Control)this.sashForm);
            this.hierarchyViewer.setComparator(this.getHierarchyComparator());
            ICallHierarchyNode[] roots = this.getHierarchyRoots();
            this.hierarchyViewer.setInput((Object)new CallHierarchy(this.hierarchyKind, roots));
            if (roots.length > 0) {
                this.hierarchyViewer.setSelection((ISelection)new StructuredSelection((Object)roots[0]), true);
            }
            this.hierarchyViewer.getTree().setFocus();
            this.refreshAction.setEnabled(true);
            this.refreshElementAction.setEnabled(true);
        } else {
            this.pageBook.showPage(this.noHierarchyPage);
            this.pageBook.setFocus();
            this.refreshAction.setEnabled(false);
            this.refreshElementAction.setEnabled(false);
        }
    }

    protected Control createNoHierarchyPage(Composite parent) {
        Label label = new Label(parent, 16448);
        label.setText(Messages.CallHierarchyViewPart_No_hierarchy_to_display);
        return label;
    }

    protected final SashForm getSashForm() {
        return this.sashForm;
    }

    protected SashForm createSashForm(Composite parent) {
        return new SashForm(parent, 0);
    }

    protected final TreeViewer getHierarchyViewer() {
        return this.hierarchyViewer;
    }

    protected TreeViewer createHierarchyViewer(Composite parent) {
        return new TreeViewer(parent, 2);
    }

    protected void configureHierarchyViewer(TreeViewer viewer) {
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setUseHashlookup(true);
        viewer.setAutoExpandLevel(2);
        viewer.setContentProvider((IContentProvider)new CallHierarchyContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CallHierarchyLabelProvider((ILabelProvider)new WorkbenchLabelProvider())));
    }

    protected void createHierarchyViewerMenuGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(GROUP_FOCUS));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillHierarchyViewerMenu(IMenuManager manager) {
        if (this.focusOnSelectionAction.isEnabled()) {
            manager.appendToGroup(GROUP_FOCUS, (IAction)this.focusOnSelectionAction);
        }
        manager.appendToGroup(GROUP_FOCUS, (IAction)this.refreshElementAction);
        if (this.removeFromViewAction.isEnabled()) {
            manager.appendToGroup(GROUP_FOCUS, (IAction)this.removeFromViewAction);
        }
    }

    protected void hierarchySelectionChanged(ISelection selection) {
        Object element = CallHierarchyViewPart.getSelectedElement(selection);
        if (!(element instanceof ICallHierarchyNode)) {
            this.locationViewer.setInput(null);
        } else {
            ICallLocation[] callLocations = ((ICallHierarchyNode)element).getCallLocations();
            this.locationViewer.setInput((Object)callLocations);
            if (callLocations.length > 0) {
                this.locationViewer.setSelection((ISelection)new StructuredSelection((Object)callLocations[0]), true);
            }
            if (this.hierarchyViewer.getControl().isFocusControl()) {
                try {
                    this.revealInEditor(element, false, false);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
    }

    protected final TableViewer getLocationViewer() {
        return this.locationViewer;
    }

    protected TableViewer createLocationViewer(Composite parent) {
        return new TableViewer(parent, 66306);
    }

    protected void configureLocationViewer(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LocationTableLabelProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        this.createLocationColumns(table);
    }

    protected void createLocationColumns(Table table) {
        ColumnDescription[] columnDescriptions;
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        ColumnDescription[] columnDescriptionArray = columnDescriptions = this.getLocationColumnDescriptions();
        int n = columnDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescription columnDescription = columnDescriptionArray[n2];
            ColumnLayoutData layoutData = columnDescription.getLayoutData();
            layout.addColumnData(layoutData);
            TableColumn column = new TableColumn(table, 0);
            column.setResizable(layoutData.resizable);
            String header = columnDescription.getHeader();
            if (header != null) {
                column.setText(header);
            }
            ++n2;
        }
    }

    protected ColumnDescription[] getLocationColumnDescriptions() {
        ColumnDescription iconColumn = new ColumnDescription(null, (ColumnLayoutData)new ColumnPixelData(18, false, true));
        ColumnDescription lineColumn = new ColumnDescription(Messages.CallHierarchyViewPart_Line_column_header, (ColumnLayoutData)new ColumnWeightData(60));
        ColumnDescription infoColumn = new ColumnDescription(Messages.CallHierarchyViewPart_Info_column_header, (ColumnLayoutData)new ColumnWeightData(300));
        return new ColumnDescription[]{iconColumn, lineColumn, infoColumn};
    }

    protected void createLocationViewerMenuGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocationViewerMenu(IMenuManager manager) {
    }

    protected void locationSelectionChanged(ISelection selection) {
        Object element = CallHierarchyViewPart.getSelectedElement(selection);
        if (!(element instanceof ICallLocation)) {
            return;
        }
        if (this.locationViewer.getControl().isFocusControl()) {
            try {
                this.revealInEditor(element, false, false);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    protected void revealInEditor(Object element, boolean activate, boolean mayOpenNewEditor) throws PartInitException {
        ICallLocation callLocation = null;
        if (element instanceof ICallLocation) {
            callLocation = (ICallLocation)element;
            element = callLocation.getCaller();
        } else if (element instanceof ICallHierarchyNode) {
            ICallHierarchyNode node = (ICallHierarchyNode)element;
            ICallLocation[] callLocations = node.getCallLocations();
            if (callLocations.length == 0) {
                element = node.getElement();
            } else {
                callLocation = callLocations[0];
                element = callLocation.getCaller();
            }
        }
        EditorUtility editorUtility = this.editorOpener.getEditorUtility();
        if (editorUtility.getEditorInput(element) == null) {
            return;
        }
        IEditorPart editor = null;
        if (mayOpenNewEditor) {
            editor = this.editorOpener.open(element, activate, callLocation == null);
        } else {
            IWorkbenchPage page = this.editorOpener.getWorkbenchPage();
            IEditorReference editorRef = editorUtility.findEditor(page, element);
            if (editorRef != null && (editor = editorRef.getEditor(true)) != null) {
                if (activate) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.bringToTop((IWorkbenchPart)editor);
                }
                if (callLocation == null) {
                    editorUtility.revealElement(editor, element);
                }
            }
        }
        if (editor != null && callLocation != null) {
            this.revealCallLocation(editor, callLocation, Contexts.EMPTY_CONTEXT);
        }
    }

    protected void revealCallLocation(IEditorPart editor, ICallLocation callLocation, IContext context) {
        TextRange callRange = callLocation.getCallRange();
        if (callRange == null) {
            this.handleCannotRevealCallLocation(editor, callLocation, context);
        } else {
            EditorUtility editorUtility = this.editorOpener.getEditorUtility();
            try {
                editorUtility.revealTextRange(editor, callRange.getOffset(), callRange.getLength(), callLocation.getSnapshot());
            }
            catch (StaleSnapshotException e) {
                this.handleCannotRevealCallLocation(editor, callLocation, context);
            }
        }
    }

    protected void handleCannotRevealCallLocation(IEditorPart editor, ICallLocation callLocation, IContext context) {
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Messages.CallHierarchyViewPart_Cannot_reveal_call_location);
        Object element = callLocation.getCaller();
        if (element != null) {
            this.editorOpener.getEditorUtility().revealElement(editor, element);
        }
    }

    protected final EditorOpener getEditorOpener() {
        return this.editorOpener;
    }

    protected EditorOpener createEditorOpener() {
        return new EditorOpener(this.getSite().getPage(), DefaultEditorUtility.INSTANCE);
    }

    protected final IAction getFocusOnSelectionAction() {
        return this.focusOnSelectionAction;
    }

    protected final IAction getRefreshElementAction() {
        return this.refreshElementAction;
    }

    protected final IAction getRemoveFromViewAction() {
        return this.removeFromViewAction;
    }

    protected void addRefreshAction(IAction action) {
        this.getViewSite().getActionBars().getToolBarManager().add(action);
    }

    protected void addSetHierarchyKindAction(IAction action, CallHierarchyKind kind) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add(action);
        actionBars.getMenuManager().add(action);
    }

    protected void addSetOrientationAction(IAction action, int orientation) {
        String id;
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        IMenuManager layoutSubMenu = viewMenu.findMenuUsingPath(id = "layout");
        if (layoutSubMenu == null) {
            viewMenu.add((IContributionItem)new Separator());
            layoutSubMenu = new MenuManager(Messages.CallHierarchyViewPart_Layout_menu, id);
            viewMenu.add((IContributionItem)layoutSubMenu);
        }
        layoutSubMenu.add(action);
    }

    protected HistoryDropDownAction<HistoryEntry> createHistoryDropDownAction(HistoryDropDownAction.History<HistoryEntry> history) {
        return new HistoryDropDownAction<HistoryEntry>(history);
    }

    protected void addHistoryDropDownAction(IAction action) {
        this.getViewSite().getActionBars().getToolBarManager().add(action);
    }

    protected void addPinAction(IAction action) {
        this.getViewSite().getActionBars().getToolBarManager().add(action);
    }

    protected List<HistoryEntry> getHistory() {
        return this.getViewManager().getViewHistory();
    }

    protected abstract HistoryEntry createHistoryEntry(Object[] var1);

    protected void notifyHistoryUpdated() {
        List<CallHierarchyViewPart> views = this.getViewManager().getViews();
        for (CallHierarchyViewPart view : views) {
            view.historyUpdated();
        }
    }

    protected void historyUpdated() {
        boolean empty = this.getHistory().isEmpty();
        this.historyDropDownAction.setEnabled(!empty);
        if (empty) {
            this.setInputElements(NO_ELEMENTS);
        }
    }

    private void addHistoryEntry(HistoryEntry entry) {
        List<HistoryEntry> history = this.getHistory();
        history.remove(entry);
        history.add(0, entry);
        this.notifyHistoryUpdated();
    }

    private void initContextMenu(Control parent, IMenuListener listener, String menuId, ISelectionProvider selectionProvider) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        Menu menu = manager.createContextMenu(parent);
        parent.setMenu(menu);
        this.getSite().registerContextMenu(menuId, manager, selectionProvider);
    }

    private static Object getSelectedElement(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement();
        }
        return null;
    }

    private static class ConvertingSelectionProvider
    extends DelegatingSelectionProvider {
        private ConvertingSelectionProvider() {
        }

        @Override
        public ISelection getSelection() {
            return this.convert(super.getSelection());
        }

        @Override
        protected SelectionChangedEvent newSelectionChangedEvent(ISelection selection) {
            return super.newSelectionChangedEvent(this.convert(selection));
        }

        private ISelection convert(ISelection selection) {
            if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                return selection;
            }
            Object[] elements = ((IStructuredSelection)selection).toArray();
            int length = elements.length;
            Object[] converted = new Object[length];
            int i = 0;
            while (i < length) {
                converted[i] = this.convert(elements[i]);
                ++i;
            }
            return new StructuredSelection(converted);
        }

        private Object convert(Object element) {
            if (element instanceof ICallHierarchyNode) {
                return ((ICallHierarchyNode)element).getElement();
            }
            return element;
        }
    }

    private class FocusOnSelectionAction
    extends BaseSelectionListenerAction {
        FocusOnSelectionAction() {
            super(Messages.CallHierarchyViewPart_Focus_on_selection_action_text);
            this.setToolTipText(Messages.CallHierarchyViewPart_Focus_on_selection_action_tooltip);
        }

        public void run() {
            CallHierarchyViewPart.this.setInputElements(this.getStructuredSelection().toArray());
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return !selection.isEmpty() && CallHierarchyViewPart.this.arePossibleInputElements(selection.toArray());
        }
    }

    protected static abstract class HistoryEntry {
        private final Object[] inputElements;

        protected HistoryEntry(Object[] inputElements) {
            if (inputElements.length == 0) {
                throw new AssertionError();
            }
            this.inputElements = inputElements;
        }

        public final Object[] getInputElements() {
            return this.inputElements;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoryEntry other = (HistoryEntry)obj;
            return Arrays.equals(this.inputElements, other.inputElements);
        }

        public int hashCode() {
            return Arrays.hashCode(this.inputElements);
        }

        public String getLabel() {
            switch (this.inputElements.length) {
                case 1: {
                    return MessageFormat.format(Messages.CallHierarchyViewPart_History_entry_label__0, this.getElementLabel(this.inputElements[0]));
                }
                case 2: {
                    return MessageFormat.format(Messages.CallHierarchyViewPart_History_entry_label__0__1, this.getElementLabel(this.inputElements[0]), this.getElementLabel(this.inputElements[1]));
                }
            }
            return MessageFormat.format(Messages.CallHierarchyViewPart_History_entry_label__0__1_more, this.getElementLabel(this.inputElements[0]), this.getElementLabel(this.inputElements[1]));
        }

        protected abstract String getElementLabel(Object var1);

        public ImageDescriptor getImageDescriptor() {
            return null;
        }
    }

    private class OpenEditorHelper
    extends OpenAndLinkWithEditorHelper {
        OpenEditorHelper(StructuredViewer viewer) {
            super(viewer);
        }

        protected void activate(ISelection selection) {
            Object element = CallHierarchyViewPart.getSelectedElement(selection);
            if (element != null) {
                try {
                    CallHierarchyViewPart.this.revealInEditor(element, true, false);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }

        protected void open(ISelection selection, boolean activate) {
            Object element = CallHierarchyViewPart.getSelectedElement(selection);
            if (element != null) {
                try {
                    CallHierarchyViewPart.this.revealInEditor(element, activate, true);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)CallHierarchyViewPart.this.getSite().getShell(), (String)Messages.CallHierarchyViewPart_Show_call_location, (String)Messages.CallHierarchyViewPart_Error_opening_editor, (IStatus)e.getStatus());
                }
            }
        }
    }

    private class PinAction
    extends Action {
        PinAction() {
            super(Messages.CallHierarchyViewPart_Pin_action_text, 2);
            this.setToolTipText(Messages.CallHierarchyViewPart_Pin_action_tooltip);
            this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/pin_view.png"));
        }

        public void run() {
            CallHierarchyViewPart.this.setPinned(this.isChecked());
        }
    }

    private class RefreshAction
    extends Action {
        RefreshAction() {
            this.setText(Messages.CallHierarchyViewPart_Refresh_action_text);
            this.setToolTipText(Messages.CallHierarchyViewPart_Refresh_action_tooltip);
            this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/refresh.png"));
            this.setDisabledImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/dlcl16/refresh.png"));
        }

        public void run() {
            CallHierarchyViewPart.this.refresh();
        }
    }

    private class RefreshElementAction
    extends Action {
        RefreshElementAction() {
            this.setText(Messages.CallHierarchyViewPart_Refresh_element_action_text);
            this.setToolTipText(Messages.CallHierarchyViewPart_Refresh_element_action_tooltip);
            this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/refresh.png"));
            this.setActionDefinitionId("org.eclipse.ui.file.refresh");
        }

        public void run() {
            ITreeSelection selection = CallHierarchyViewPart.this.hierarchyViewer.getStructuredSelection();
            if (selection.isEmpty()) {
                CallHierarchyViewPart.this.refresh();
            } else {
                for (Object e : selection) {
                    if (e instanceof ICallHierarchyNode) {
                        ((ICallHierarchyNode)e).refresh();
                    }
                    CallHierarchyViewPart.this.hierarchyViewer.refresh(e);
                }
            }
        }
    }

    private class RemoveFromViewAction
    extends BaseSelectionListenerAction {
        RemoveFromViewAction() {
            super(Messages.CallHierarchyViewPart_Remove_from_view_action_text);
            this.setToolTipText(Messages.CallHierarchyViewPart_Remove_from_view_action_tooltip);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_ELCL_REMOVE"));
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        }

        public void run() {
            Object[] elements = this.getStructuredSelection().toArray();
            CallHierarchyViewPart.this.hierarchyViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            CallHierarchyViewPart.this.hierarchyViewer.remove(elements);
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return !selection.isEmpty();
        }
    }

    private class SetHierarchyKindAction
    extends Action {
        final CallHierarchyKind kind;

        SetHierarchyKindAction(CallHierarchyKind kind) {
            super(null, 8);
            this.kind = kind;
            switch (kind) {
                case CALLER: {
                    this.setText(Messages.CallHierarchyViewPart_Show_caller_hierarchy_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Show_caller_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/ch_callers.png"));
                    break;
                }
                case CALLEE: {
                    this.setText(Messages.CallHierarchyViewPart_Show_callee_hierarchy_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Show_callee_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/ch_callees.png"));
                }
            }
        }

        public void run() {
            CallHierarchyViewPart.this.setHierarchyKind(this.kind);
        }
    }

    private class SetOrientationAction
    extends Action {
        final int orientation;

        SetOrientationAction(int orientation) {
            super(null, 8);
            this.orientation = orientation;
            switch (orientation) {
                case 256: {
                    this.setText(Messages.CallHierarchyViewPart_Layout_horizontal_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Layout_horizontal_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_horizontal.png"));
                    break;
                }
                case 512: {
                    this.setText(Messages.CallHierarchyViewPart_Layout_vertical_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Layout_vertical_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_vertical.png"));
                    break;
                }
                default: {
                    this.setText(Messages.CallHierarchyViewPart_Layout_automatic_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Layout_automatic_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/layout_automatic.png"));
                    this.setChecked(true);
                }
            }
        }

        public void run() {
            CallHierarchyViewPart.this.setOrientation(this.orientation);
        }
    }
}

